$MIST_EXIT_IMG = @ScriptDir&"\Ext.jpg"
$MIST_MINI_IMG = @ScriptDir&"\Min.jpg"

Func Mist_Create($sTitle,$sWidth,$sHeight,$sLeft = Default, $sTop = Default,$iMin=1,$hParent = 0)

Local $gui = GUICreate($sTitle,$sWidth,$sHeight,$sLeft,$sTop,BitOR($WS_POPUP,$WS_SYSMENU,$WS_BORDER,$WS_MINIMIZEBOX),-1,$hParent)
If @error Then SetError(@Error,@Extended,$gui)
GUISetFont(8,400,0,"Tahoma")
GUISetBkColor(0x999999)

GUICtrlCreateLabel('',1,1,5,16,-1,$GUI_WS_EX_PARENTDRAG)
GUICtrlSetBkColor(-1,0x303030)

$x = 17
If $iMin = 1 Then $x = 33
GUICtrlCreateLabel($sTitle,6,1,$sWidth-$x,16,-1,$GUI_WS_EX_PARENTDRAG)
GUICtrlSetBkColor(-1,0x303030)
GUICtrlSetColor(-1,0xFFFFFF)
GUICtrlSetFont(-1,8.5,650,4)

Local $MIST_EXIT = GUICtrlCreatePic($MIST_EXIT_IMG,$sWidth-17,1,16,16)
GUICtrlSetCursor(-1,0)

If $iMin = 1 Then
	Local $MIST_MINI = GUICtrlCreatePic($MIST_MINI_IMG,$sWidth-33,1,16,16)
	GUICtrlSetCursor(-1,0)
EndIf

Dim $ret[2]
$ret[0] = $gui
$ret[1] = $MIST_EXIT

If $iMin = 1 Then
	ReDim $ret[3]
	$ret[2] = $MIST_MINI
EndIf

Return $ret
EndFunc

Func Mist_CtrlCreateButton($sText,$sLeft,$sTop,$sWidth = 75, $sHeight = 20)

Local $but = GUICtrlCreateLabel($sText,$sLeft+1,$sTop+20,$sWidth-2,$sHeight-2,BitOR($SS_CENTER,$WS_BORDER))
GUICtrlSetBkColor(-1,0x303030)
GUICtrlSetColor(-1,0xFFFFFF)
GUICtrlSetFont(-1,8.5)
GUICtrlSetCursor(-1,0)

Return $but
EndFunc

Func Mist_CtrlCreateCheckbox($sText,$sLeft,$sTop,$sWidth=Default,$sHeight=Default,$sStyle=Default,$sExStyle=Default)
Local $cb = GUICtrlCreateCheckbox($sText,$sLeft+1,$sTop+19,$sWidth,$sHeight)
GUICtrlSetFont(-1,8.8)

Return $cb
EndFunc

Func Mist_CtrlCreateCombo($sText,$sLeft,$sTop,$sWidth=Default,$sHeight=Default,$sStyle=Default,$sExStyle=Default)
Local $combo = GUICtrlCreateCombo($sText,$sLeft+1,$sTop+19,$sWidth,$sHeight)
DllCall("UxTheme.dll", "int", "SetWindowTheme", "hwnd", GUICtrlGetHandle($combo), "wstr", 0, "wstr", 0)
GUICtrlSetFont(-1,8.8)

Return $combo
EndFunc

Func Mist_CtrlCreateEdit($sText,$sLeft,$sTop,$sWidth=100,$sHeight=Default,$sStyle=Default,$sExStyle=Default)
If $sStyle = Default Then $sStyle = BitOR($ES_AUTOVSCROLL,$ES_WANTRETURN,$WS_VSCROLL)
Local $edit = GUICtrlCreateEdit($sText,$sLeft+1,$sTop+19,$sWidth,$sHeight,$sStyle,$sExStyle)
GUICtrlSetBkColor(-1,0x303030)
GUICtrlSetColor(-1,0xFFFFFF)
GUICtrlSetFont(-1,8.5)

Return $edit
EndFunc

Func Mist_CtrlCreateGroup($sText,$sLeft,$sTop,$sWidth=Default,$sHeight=Default)
	GUICtrlCreateGraphic($sLeft+1,$sTop+19,$sWidth,$sHeight,BitOR($SS_CENTER,$SS_RIGHT,$SS_BLACKRECT,$SS_GRAYRECT,$SS_WHITERECT,$SS_BLACKFRAME))
	GUICtrlSetBkColor(-1,0x999999)
	
	Local $group = GUICtrlCreateLabel(" "&$sText,$sLeft+3,$sTop+21,$sWidth-4,16)
	GUICtrlSetBkColor(-1,0x303030)
	GUICtrlSetColor(-1,0xFFFFFF)
	GUICtrlSetFont(-1,8.8,650)
	
	Return $group
EndFunc

Func Mist_CtrlCreateInput($sText,$sLeft,$sTop,$sWidth=Default,$sHeight=Default,$sStyle=Default,$sExStyle=Default)
Local $input = GUICtrlCreateInput($sText,$sLeft+1,$sTop+19,$sWidth,$sHeight,$sStyle,$sExStyle)
GUICtrlSetBkColor(-1,0x303030)
GUICtrlSetColor(-1,0xFFFFFF)
GUICtrlSetFont(-1,8.8)

Return $input
EndFunc

Func Mist_CtrlCreateLabel($sText,$sLeft,$sTop,$sWidth=Default,$sHeight=Default)
Local $label = GUICtrlCreateLabel($sText,$sLeft+1,$sTop+19,$sWidth,$sHeight)
GUICtrlSetColor(-1,0xFFFFFF)
GUICtrlSetFont(-1,8.8,650,0,"Arial")

Return $label
EndFunc

Func Mist_CtrlCreateList($sText,$sLeft,$sTop,$sWidth=Default,$sHeight=Default,$sStyle=Default,$sExStyle=Default)
Local $list = GUICtrlCreateList($sText,$sLeft+1,$sTop+19,$sWidth,$sHeight,$sStyle,$sExStyle)
GUICtrlSetBkColor(-1,0x303030)
GUICtrlSetColor(-1,0xFFFFFF)
GUICtrlSetFont(-1,8.8)

Return $list
EndFunc

Func Mist_CtrlCreateListView($sText,$sLeft,$sTop,$sWidth=Default,$sHeight=Default,$sStyle=Default,$sExStyle=Default)
Local $list = GUICtrlCreateListView($sText,$sLeft+1,$sTop+19,$sWidth,$sHeight,$sStyle,$sExStyle)
GUICtrlSetBkColor(-1,0x303030)
GUICtrlSetColor(-1,0xFFFFFF)
GUICtrlSetFont(-1,8.8)

Return $list
EndFunc

Func Mist_CtrlCreateProgress($sPos,$sLeft,$sTop,$sWidth=100,$sHeight=20,$sStyle=Default,$sExStyle=Default)
If $spos < 0 Then $spos = 0
If $spos > 100 Then $spos = 100

$progress = GUICtrlCreateProgress($sLeft+1,$sTop+19,$sWidth,$sHeight,$sStyle,$sExStyle)
DllCall("UxTheme.dll", "int", "SetWindowTheme", "hwnd", GUICtrlGetHandle($progress), "wstr", 0, "wstr", 0)
GUICtrlSetStyle($progress, BitOr($GUI_SS_DEFAULT_PROGRESS, $PBS_SMOOTH))
GUICtrlSetData($progress,$spos)

GUICtrlSetColor(-1,0xFFFFFF)
GUICtrlSetBkColor(-1,0x303030)


Return $progress
EndFunc

Func Mist_CtrlCreateRadio($sText,$sLeft,$sTop,$sWidth=Default,$sHeight=Default,$sStyle=Default,$sExStyle=Default)
Local $rd = GUICtrlCreateRadio($sText,$sLeft+1,$sTop+19,$sWidth,$sHeight)
GUICtrlSetFont(-1,8.8)

Return $rd
EndFunc

Func Mist_CtrlCreateSlider($sPos,$sLeft,$sTop,$sWidth=100,$sHeight=20,$sStyle=Default,$sExStyle=Default)
If $spos < 0 Then $spos = 0
If $spos > 100 Then $spos = 100

$sl = GUICtrlCreateSlider($sLeft+1,$sTop+19,$sWidth,$sHeight,$sStyle,$sExStyle)
DllCall("UxTheme.dll", "int", "SetWindowTheme", "hwnd", GUICtrlGetHandle($sl), "wstr", 0, "wstr", 0)
GUICtrlSetStyle($sl, BitOr($GUI_SS_DEFAULT_PROGRESS, $PBS_SMOOTH))
GUICtrlSetData($sl,$spos)

GUICtrlSetColor(-1,0xFFFFFF)
GUICtrlSetBkColor(-1,0x303030)

Return $sl
EndFunc

Func Mist_CtrlCreateTab($sLeft,$sTop,$sWidth=Default,$sHeight=Default,$sStyle=$WS_BORDER,$sExStyle=Default)
Local $tab = GUICtrlCreateTab($sLeft+1,$sTop+19,$sWidth,$sHeight,$sStyle,$sExStyle)

GUICtrlSetBkColor($tab,0x303030)

Return $tab
EndFunc