#include <Array.au3>

#cs == Params ======================================================================
$XMPP_PING_SERVER (True/False) -    [False]
$XMPP_AUTO_CLOSE_TCP (True/False) -   TCP  Exit [True]
#ce ================================================================================



;===================================================================================
Global $XMPP_PING_SERVER = True, _
       $XMPP_AUTO_CLOSE_TCP = True, _
	   $XMPP_JID = "", _
	   $XMPP_CONNECT = -1
;===================================================================================
AdlibRegister("__PingServer",30000)
If $XMPP_AUTO_CLOSE_TCP Then OnAutoItExitRegister("__EndJabberTCP")
;===================================================================================

; #FUNCTION# ====================================================================================================================
; Name...........: Jabber_Connect
; Description....: Produce the connection with Jabber server.
; Syntax.........: Jabber_Connect($sJID, $sPASS, $sClientName [, $iPORT = 5222])
; Parameters.....: $sJID         - your JID
;                  $sPASS        - your password
;                  $sClientName  - conditional name of the client
;                  $iPORT        - number of port, default: 5222
; Return values..: Success       - number TCP connections
;                  Failure       - -1
; Author.........: Nik(rus)
; Modified.......: SECTOR
; Remarks........: register JID possible on www.jabber.org
; Related........:
; Link...........: No
; Example........: Yes
; ===============================================================================================================================

Func Jabber_Connect($sJID,$sPASS,$sClientName,$iPORT = 5222)
	$split = StringSplit($sJID,"@")
	If @error <> 0 Or Not IsArray($split) Or UBound($split) <> 3 Then SetError(1,0,-1)

	$sServer = $split[2]
	$sJID_name = $split[1]

	TCPStartup()

	$connect = TCPConnect(TCPNameToIP($sServer),$iPORT)
	If @error <> 0 Then SetError(2,0,-1)

	TCPSend($connect, "<?xml version='1.0' encoding='UTF-8' ?><stream:stream to='" &$sServer& "' xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams'>")
    TCPSend($connect, "<iq type='get' to='" &$sServer& "' id='auth1'><query xmlns='jabber:iq:auth'><username>" &$sJID_name& "</username></query></iq>")
    TCPSend($connect, "<iq type='set' id='auth2'><query xmlns='jabber:iq:auth'><username>" &$sJID_name& "</username><password>" &$sPASS& "</password><resource>" &StringToXMPP($sClientName)& "</resource></query></iq><presence type='available'></presence>")

	Sleep(500)

	$XMPP_JID = $sJID
	$XMPP_CONNECT = $connect

	Return 1
EndFunc

; #FUNCTION# ====================================================================================================================
; Name...........: Jabber_ReConnect
; Description....: be disconnected from Jabber server.
; Syntax.........: Jabber_ReConnect(ByRef $connect)
; Parameters.....:
; Return values..: Success       - 1
;                  Failure       - 0
; Author.........: Nik(rus)
; Modified.......: SECTOR
; Remarks........:
; Related........:
; Link...........: No
; Example........: Yes
; ===============================================================================================================================

Func Jabber_ReConnect()
	If $XMPP_CONNECT = -1 Then Return 0

    TCPsend($XMPP_CONNECT, "</stream:stream>")
    TCPCloseSocket($XMPP_CONNECT)

	$XMPP_JID = ""
	$XMPP_CONNECT = -1

	Return 1
EndFunc

; #FUNCTION# ====================================================================================================================
; Name...........: Jabber_Send
; Description....: Send message other user.
; Syntax.........: Jabber_Send($sJID,$sTEXT,ByRef $connect)
; Parameters.....: $sJID         - JID the grantee
;                  $sTEXT        - sent text
; Return values..: Success       - 1
;                  Failure       - 0
; Author.........: Nik(rus)
; Modified.......: SECTOR
; Remarks........:
; Related........:
; Link...........: No
; Example........: Yes
; ===============================================================================================================================

Func Jabber_Send($sJID,$sTEXT) ;       :
	If $XMPP_CONNECT = -1 Then Return 0            ; Jabber_Send("autoit@conference.jabber.ru/SECTOR","")

	$sTEXT = StringToXMPP($sTEXT)
    TCPSend($XMPP_CONNECT, "<message to='" &$sJID& "' type='normal'><body>" &$sTEXT& "</body></message>")
	Return 1
EndFunc

Func JabSendFile($fname,$sJID)
	If $XMPP_CONNECT = -1 Then Return 0

	$sid = Int(Random(10000000,99999999))
	$count = 0
	if StringRegExp($fname,".*\\.*") = 1 Then
		$f = StringSplit($fname,"\\",2)
		$fname2 = $f[UBound($f)-1]
	Else
		$fname2 = $fname
	EndIf
	TCPSend($XMPP_CONNECT,"<iq type='set' to='" & $sJID & "' id='jadmin_" & $count & "'>" & @CRLF & _
"<si xmlns='http://jabber.org/protocol/si' id='" & $sid & "' mime-type='binary/octet-stream' profile='http://jabber.org/protocol/si/profile/file-transfer'>" & @CRLF & _
"<file xmlns='http://jabber.org/protocol/si/profile/file-transfer' name='" & $fname2 & "' size='" & StringLen(FileRead($fname)) & "'>" & @CRLF & _
"<desc>" & $fname2 & "</desc>" & @CRLF & _
"</file>" & @CRLF & _
"<feature xmlns='http://jabber.org/protocol/feature-neg'>" & @CRLF & _
"<x xmlns='jabber:x:data' type='form'>" & @CRLF & _
"<field var='stream-method' type='list-single'>" & @CRLF & _
"<option>" & @CRLF & _
"<value>http://jabber.org/protocol/ibb</value>" & @CRLF & _
"</option>" & @CRLF & _
"</field>" & @CRLF & _
"</x>" & @CRLF & _
"</feature>" & @CRLF & _
"</si>" & @CRLF & _
"</iq>")
	$recv = ""
	While $recv = ""
		$recv = TCPRecv($XMPP_CONNECT, 2048)
		if StringRegExp($recv,".*id=[""']jadmin_" & $count & "[""'].*") and StringRegExp($recv,".*type=[""']result[""'].*") Then
			TCPSend($XMPP_CONNECT,"<iq type='set' to='" & $sJID & "' id='jadmin_" & $count+1 & "'>" & @CRLF & _
"<open xmlns='http://jabber.org/protocol/ibb' sid='" & $sid & "' block-size='2048' />" & @CRLF & _
"</iq>")
			$fblocks = _StringSplit(FileRead($fname),2048)
			For $iBl=0 To UBound($fblocks)-1 Step 1
				TCPSend($XMPP_CONNECT,"<message id='jadmin_" & $count+2 & "' to='" & $sJID & "'>" & @CRLF & _
				"<data xmlns='http://jabber.org/protocol/ibb' seq='" & $count & "' sid='" & $sid & "'>" & _Base64Encode($fblocks[$iBl]) & "</data>" & @CRLF & _
				"<amp xmlns='http://jabber.org/protocol/amp'>" & @CRLF & _
				"<rule condition='deliver-at' value='stored' action='error' />" & @CRLF & _
				"<rule condition='match-resource' value='exact' action='error' />" & @CRLF & _
				"</amp>" & @CRLF & _
				"</message>")
				$count = $count + 1
				Sleep(1000)
			Next
			TCPSend($XMPP_CONNECT,"<iq type='set' to='" & $sJID & "' id='jadmin_" & $count+2 & "'>" & @CRLF & _
			"<close xmlns='http://jabber.org/protocol/ibb' sid='" & $sid & "' />" & @CRLF & _
			"</iq>")
			return True
		ElseIf StringRegExp($recv,".*type=[""']cancel[""'].*") or StringRegExp($recv,".*type=[""']error[""'].*") Then
			Return False
		Else
			$recv = ""
			ContinueLoop
		EndIf
	WEnd
EndFunc

; #FUNCTION# ====================================================================================================================
; Name...........: Jabber_Read
; Description....: Read messages.
; Syntax.........: Jabber_Read(ByRef $connect)
; Parameters.....:
; Return values..: Success       - Array:
;                                  $array[0] - jid sender
;                                  $array[1] - text of the message
;                  Failure       - 0 or ""
; Author.........: Nik(rus)
; Modified.......: SECTOR
; Remarks........:
; Related........:
; Link...........: No
; Example........: Yes
; ===============================================================================================================================

Func Jabber_Read()
	If $XMPP_CONNECT = -1 Then Return 0

	$recv = TCPRecv($XMPP_CONNECT, 2048)
    if $recv <> "" then
        if StringInStr($recv, "<message from=") OR StringInStr($recv, "<message to=") OR StringInStr($recv, "<message type=") And StringInStr($recv, "<body>") Then
            ;$from1 = StringTrimLeft($recv, StringInStr($recv, "from=") + 5)
            ;$from2 = StringTrimRight($from1, StringLen($from1) - StringInStr($from1, ">") + 2)
			;$fromtemp = StringLen($from2) - StringInStr($from2,'/') + 1
			;$from = StringTrimRight($from2,$fromtemp)
			$from = StringRegExp($recv,"from=[""']([^""']*)[""']",3)
			$from = $from[0]
            $body = StringInStr($recv, "<body>") + 5
            $body2 = StringLen($recv) - StringInStr($recv, "</body>") + 1
            $messbod = StringTrimRight(StringTrimLeft($recv, $body), $body2)
			$messbod = XMPPToString($messbod)
			;---------------------------------------------------------------------
			Local $retun[2]
			$retun[0] = $from
			$retun[1] = $messbod
			return $retun
			;---------------------------------------------------------------------
        EndIf
	EndIf
	if StringInStr($recv, "<presence from=") And StringInStr($recv, "<priority>") Then
		$from1 = StringTrimLeft($recv, StringInStr($recv, "from=") + 5)
		$from = StringTrimRight($from1, StringLen($from1) - StringInStr($from1, " ") + 2)
        $recv = ""
    EndIf
EndFunc

; #FUNCTION# ====================================================================================================================
; Name...........: Jabber_Status
; Description....: Set Status.
; Syntax.........: Jabber_Status($status,$statstr,ByRef $connect)
; Parameters.....: $status       - status, look the remarks
;                  $statstr      - text of the status
; Return values..: Success       - 1
;                  Failure       - 0
; Author.........: Nik(rus)
; Modified.......: SECTOR
; Remarks........: as parameter $status, use following importances (online|dnd|chat|xa|away|invisible|unavailable)
; Related........:
; Link...........: No
; Example........: Yes
; ===============================================================================================================================

Func Jabber_Status($status,$statstr) ;  $status = online|dnd|chat|xa|away|invisible|unavailable
	If $XMPP_CONNECT = -1 Then Return 0

    TCPSend($XMPP_CONNECT, "<presence><show>" & $status & "</show><status>" & StringToXMPP($statstr) & "</status></presence>")
	Sleep(500)

	Return 1
EndFunc

; #FUNCTION# ====================================================================================================================
; Name...........: Jabber_Conf_Open
; Description....: call at in conference
; Syntax.........: Jabber_Conf_Open($conf,$nick,ByRef $connect)
; Parameters.....: $conf         - JID the conference
;                  $nick         - your nick-name
; Return values..: Success       - 1
;                  Failure       - 0
; Author.........: SECTOR
; Modified.......:
; Remarks........: JID conferences looks approximately so: autoit@conference.jabber.ru
; Related........:
; Link...........: No
; Example........: Yes
; ===============================================================================================================================

Func Jabber_Conf_Open($conf,$nick)
	If $XMPP_CONNECT = -1 Then Return 0

	TCPSend($XMPP_CONNECT, _
		'<presence to="'&StringToXMPP($conf)&'/'&StringToXMPP($nick)&'">'& _
			'<priority>'& _
				'0'& _
			'</priority>'& _
			'<x xmlns="http://jabber.org/protocol/muc" />'& _
		'</presence>')

	Sleep(500)
	Return 1
EndFunc

; #FUNCTION# ====================================================================================================================
; Name...........: Jabber_Conf_Close
; Description....: exiting a conference
; Syntax.........: Jabber_Conf_Close($conf,$connect)
; Parameters.....: $conf         - JID the conference
; Return values..: Success       - 1
;                  Failure       - 0
; Author.........: SECTOR
; Modified.......:
; Remarks........: before this it is necessary to use Jabber_Conf_Open, but that can be a mistakes
; Related........:
; Link...........: No
; Example........: Yes
; ===============================================================================================================================

Func Jabber_Conf_Close($conf)
	If $XMPP_CONNECT = -1 Then Return 0
	TCPSend($XMPP_CONNECT,"<presence to='"&StringToXMPP($conf)&"' type='unavailable'/>")

	Sleep(500)
	Return 1
EndFunc

; #FUNCTION# ====================================================================================================================
; Name...........: Jabber_Conf_Send
; Description....: send message in conference
; Syntax.........: Jabber_Conf_Send($conf,$msg,ByRef $connect)
; Parameters.....: $conf         - JID the conference
;                  $msg          - sent text
; Return values..: Success       - 1
;                  Failure       - 0
; Author.........: SECTOR
; Modified.......:
; Remarks........: before this it is necessary to use Jabber_Conf_Open, but that can be a mistakes
; Related........:
; Link...........: No
; Example........: Yes
; ===============================================================================================================================

Func Jabber_Conf_Send($conf,$msg)
	If $XMPP_CONNECT = -1 Then Return 0

	$msg = StringToXMPP($msg)
    $conf = StringToXMPP($conf)

	TCPSend($XMPP_CONNECT, _
		'<message to="'&$conf&'" type="groupchat">'& _
			'<body>'& _
				$msg& _
			'</body>'& _
		'</message>')
	Return 1
EndFunc

; #FUNCTION# ====================================================================================================================
; Name...........: Jabber_Conf_Read
; Description....: read messages in conference
; Syntax.........: Jabber_Conf_Read($conf,ByRef $connect)
; Parameters.....: $conf         - JID the conference
; Return values..: Success       - Array:
;                                  $array[0] - nick sender
;                                  $array[1] - text of the message
;                                  $array[2] - type: "groupchat" - conference, "chat" - private
;                  Failure       - 0 or ""
; Author.........: SECTOR
; Modified.......: Kaster
; Remarks........: before this it is necessary to use Jabber_Conf_Open, but that can be a mistakes
; Related........:
; Link...........: No
; Example........: Yes
; ===============================================================================================================================

Func Jabber_Conf_Read($conf)
	If $XMPP_CONNECT = -1 Then Return 0

	$recv = TCPRecv($XMPP_CONNECT, 2048)
	If $recv = "" Then Return ""
	;MsgBox(0, '', $recv)
	$confin = StringInStr($recv,$conf)
	If $confin = 0 Or @error Then Return ""
	If StringInStr($recv,'stamp=') <> 0 Then Return ""

	$who = StringTrimLeft($recv,$confin + StringLen($conf))
	$who = StringTrimRight($who,StringLen($who)-StringInStr($who,$XMPP_JID)+7)
	$who = XMPPToString($who)
	$msg = XMPPToString(GetXML($recv,"<body>","</body>"))

	$type = "chat"
	If StringInStr($recv,'type="groupchat"')<>0 Or StringInStr($recv,"type='groupchat'")<>0 Then $type = "groupchat"
	If StringInStr($recv, "presence from='") Then
		;MsgBox(0, '', '1')
		$type = "groupchat"
		$nick = StringRegExpReplace($recv, "(?s).+from='" & $conf & "/(.+)'\sto.+", '\1')
		$sPattern = "(?s).+item\sjid='(.+)'\saffiliation='(.+)'\srole='(.+)'.+"
		$realJID = StringRegExpReplace($recv, $sPattern, '\1')
		$affiliation = StringRegExpReplace($recv, $sPattern, '\2')
		$role = StringRegExpReplace($recv, $sPattern, '\3')
		If StringInStr($affiliation, 'none') Then
			$postfix = '(none)'
		ElseIf StringInStr($affiliation, 'member') Then
			$postfix = '(member)'
		ElseIf StringInStr($affiliation, 'admin') Then
			$postfix = '(admin)'
		ElseIf StringInStr($affiliation, 'owner') Then
			$postfix = '(owner)'
		EndIf
		$action = ' new member '
		If StringInStr($recv, "type='unavailable'") Then
			If StringInStr($recv, 'nick=') Then
				$action = ' rename '
				$postfix = ''
			Else
				$action = ' exit '
			EndIf
		EndIf
		$msg = XMPPToString($nick) & "(" & $realJID & ")" & $action & $postfix
	EndIf

	Local $return[3]
	$return[0] = $who
	$return[1] = $msg
	$return[2] = $type ; chat - , groupchat - 

	Return $return
EndFunc

; #FUNCTION# ====================================================================================================================
; Name...........: Jabber_Conf_Member_List
; Description....: rget list a on-line participant
; Syntax.........: Jabber_Conf_Member_List($conf, ByRef $connect)
; Parameters.....: $conf         - JID the conference
; Return values..: Success       - 2D Array:
;                                  $array[$n][0] - nick sender
;                                  $array[$n][1] - jid sender
;                  Failure       - 0 or ""
; Author.........: SECTOR
; Modified.......: Kaster
; Remarks........: before this it is necessary to use Jabber_Conf_Open, but that can be a mistakes
; Related........:
; Link...........: No
; Example........: Yes
; ===============================================================================================================================

Func Jabber_Conf_Member_List($conf)
	If $XMPP_CONNECT = -1 Then Return 0

	TCPSend($XMPP_CONNECT, _
		"<iq to='"&StringToXMPP($conf)&"' type='get'>"& _
			"<query xmlns='http://jabber.org/protocol/disco#items'>"& _
				"<item affiliation='member'/>"& _
			"</query>"& _
		"</iq>")

	Sleep(100)

	$recv = TCPRecv($XMPP_CONNECT,4096)
	;If $recv = '' Then Return 0
	;ClipPut($recv)
	$recv_use = StringRegExpReplace($recv, '.+\#items''\>(\<item jid.+)\</query\>\</iq\>', '\1')
	$recv_use = StringMid($recv_use, 2, StringLen($recv_use) - 1)
	$recv_use = StringSplit($recv_use, '><', 1)
	Local $aRecv[UBound($recv_use)][2]
	For $i = 0 to UBound($aRecv, 1) - 1
		$aRecv[$i][0] = XMPPToString(StringRegExpReplace($recv_use[$i], '.+''(.+)''.+''(.+)''/\>?', '\1'))
		$aRecv[$i][1] = XMPPToString(StringRegExpReplace($recv_use[$i], '.+''(.+)''.+''(.+)''/\>?', '\2'))
	Next

	Return $aRecv
EndFunc

; #FUNCTION# ====================================================================================================================
; Name...........: Jabber_Conf_Kick
; Description....: kick member
; Syntax.........: Jabber_Conf_Kick($sConf,$sNick,$sText,$hConnect)
; Parameters.....: $sConf        - JID the conference
;                  $sNick        - Nick a member
;                  $sText        - Comment
; Return values..: Success       - 1
;                  Failure       - 0
; Author.........: SECTOR
; Modified.......: Kaster
; Remarks........: before this it is necessary to use Jabber_Conf_Open, but that can be a mistakes
; Related........:
; Link...........: No
; Example........: Yes
; ===============================================================================================================================

Func Jabber_Conf_Kick($sConf,$sNick,$sText) ;   

If $XMPP_CONNECT = -1 Then Return 0

Local $usr = Jabber_Conf_Member_List($sConf)
If @error Or Not IsArray($usr) Or _ArrayBinarySearch($usr,$sNick) = -1 Then Return False

TCPSend($XMPP_CONNECT, _
	"<iq id='kick1' to='"&StringToXMPP($sConf)&"' type='set'>"& _
	"<query xmlns='http://jabber.org/protocol/muc#admin'>"& _
	"<item nick='"&StringToXMPP($sNick)&"' role='none'>"& _
	"<reason>"&StringToXMPP($sText)&"</reason>"& _
	"</item></query></iq>")

	Return True

EndFunc

; #FUNCTION# ====================================================================================================================
; Name...........: Jabber_Conf_Voice_Yes
; Description....: Give voice a member
; Syntax.........: Jabber_Conf_Voice_Yes($sConf, $sNick, $hConnect[, $sReason=""][, $sRole="participant"])
; Parameters.....: $sConf        - JID the conference
;                  $sNick        - Nick a member
;                  $sReason      - Reason, not without. Defauls = ""
;                  $sRole        - New role a member, not without. Defauls = "participant"
; Return values..: Success       - 1
;                  Failure       - 0
; Author.........: SECTOR
; Modified.......: Kaster
; Remarks........: before this it is necessary to use Jabber_Conf_Open, but that can be a mistakes
; Related........:
; Link...........: No
; Example........: Yes
; ===============================================================================================================================

Func Jabber_Conf_Voice_Yes($sConf, $sNick, $sReason="", $sRole="participant") ;   

	If $XMPP_CONNECT = -1 Then Return 0

	Local $usr = Jabber_Conf_Member_List($sConf)
	If @error Or Not IsArray($usr) Or _ArrayBinarySearch($usr,$sNick) = -1 Then Return 0

	;    
	Local $send = "<iq id='voice1' to='"&StringToXMPP($sConf)&"' type='set'>"& _
			"<query xmlns='http://jabber.org/protocol/muc#admin'>"& _
			"<item nick='"&StringToXMPP($sNick)&"' role='"&StringToXMPP($sRole)&"'>"
	If Not $sReason = False And Not $sReason = "" Then $send &= "<reason>"&StringToXMPP($sReason)&"</reason>"
    $send &= "</item></query></iq>"

	;  
	TCPSend($XMPP_CONNECT,$send)

	If Not @error Then Return 1
	Return 0

EndFunc

; #FUNCTION# ====================================================================================================================
; Name...........: Jabber_Conf_Voice_No
; Description....: Get voice a member
; Syntax.........: Jabber_Conf_Voice_No($sConf, $sNick, $hConnect[, $sReason=""][, $sRole="participant"])
; Parameters.....: $sConf        - JID the conference
;                  $sNick        - Nick a member
;                  $sReason      - Reason, not without. Defauls = ""
;                  $sRole        - New role a member, not without. Defauls = "visitor"
; Return values..: Success       - 1
;                  Failure       - 0
; Author.........: SECTOR
; Modified.......: Kaster
; Remarks........: before this it is necessary to use Jabber_Conf_Open, but that can be a mistakes
; Related........:
; Link...........: No
; Example........: Yes
; ===============================================================================================================================

Func Jabber_Conf_Voice_No($sConf, $sNick, $sReason="", $sRole="visitor") ;   

	If $XMPP_CONNECT = -1 Then Return 0

	Local $usr = Jabber_Conf_Member_List($sConf)
	If @error Or Not IsArray($usr) Or _ArrayBinarySearch($usr,$sNick) = -1 Then Return 0

	;    
	Local $send = "<iq id='voice2' to='"&StringToXMPP($sConf)&"' type='set'>"& _
		"<query xmlns='http://jabber.org/protocol/muc#admin'>"& _
		"<item nick='"&StringToXMPP($sNick)&"' role='"&StringToXMPP($sRole)&"'>"
	If Not $sReason = False And Not $sReason = "" Then $send &= "<reason>"&StringToXMPP($sReason)&"</reason>"
    $send &= "</item></query></iq>"

	;  
	TCPSend($XMPP_CONNECT,$send)

	If Not @error Then Return 1
	Return 0

EndFunc
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

Func StringToXMPP($sString)
	Local $Result = "", $Code
	Local $VarUTFArr = StringSplit($sString, "")

	For $i = 1 To $VarUTFArr[0]
		$Code = Asc($VarUTFArr[$i])

		Select
			Case $Code >= 192 And $Code <= 239
				$VarUTFArr[$i] = Chr(208) & Chr($Code - 48)
			Case $Code >= 240 And $Code <= 255
				$VarUTFArr[$i] = Chr(209) & Chr($Code - 112)
			Case $Code = 168
				$VarUTFArr[$i] = Chr(208) & Chr(129)
			Case $Code = 184
				$VarUTFArr[$i] = Chr(209) & Chr(145)
			Case Else
				$VarUTFArr[$i] = Chr($Code)
		EndSelect

		$Result &= $VarUTFArr[$i]
	Next

	$Result = StringRegExpReplace($Result,"&",'&amp;')
	$Result = StringRegExpReplace($Result,"<","&lt;")
	$Result = StringRegExpReplace($Result,">","&gt;")
	$Result = StringRegExpReplace($Result,'"','&quot;')
	$Result = StringRegExpReplace($Result,"'",'&apos;')

	Return $Result
EndFunc

Func XMPPToString($string)
	$string = BinaryToString(StringToBinary($string),4)
	$string = StringRegExpReplace($string,"&amp;",'&')
	$string = StringRegExpReplace($string,"&lt;","<")
	$string = StringRegExpReplace($string,"&gt;",">")
	$string = StringRegExpReplace($string,"&quot;",'"')
	$string = StringRegExpReplace($string,"&apos;","'")
	Return $string
EndFunc

Func GetXML($str,$el_1,$el_2)
	$str = StringTrimLeft($str,StringInStr($str,$el_1)+StringLen($el_1)-1)
	$str = StringTrimRight($str,StringLen($str)-StringInStr($str,$el_2)+1)
	Return $str
EndFunc

Func __EndJabberTCP()
	If $XMPP_CONNECT <> -1 Then Jabber_ReConnect()
	TCPShutdown()
	If @error <> 0 Then Return ""
EndFunc

Func __PingServer()
	If $XMPP_PING_SERVER = False Then Return ""
	TCPSend($XMPP_CONNECT," ")
EndFunc

Func _Base64Decode($Data)
	Local $Opcode = "0xC81000005356578365F800E8500000003EFFFFFF3F3435363738393A3B3C3DFFFFFF00FFFFFF000102030405060708090A0B0C0D0E0F10111213141516171819FFFFFFFFFFFF1A1B1C1D1E1F202122232425262728292A2B2C2D2E2F303132338F45F08B7D0C8B5D0831D2E9910000008365FC00837DFC047D548A034384C0750383EA033C3D75094A803B3D75014AB00084C0751A837DFC047D0D8B75FCC64435F400FF45FCEBED6A018F45F8EB1F3C2B72193C7A77150FB6F083EE2B0375F08A068B75FC884435F4FF45FCEBA68D75F4668B06C0E002C0EC0408E08807668B4601C0E004C0EC0208E08847018A4602C0E00624C00A46038847028D7F038D5203837DF8000F8465FFFFFF89D05F5E5BC9C21000"

	Local $CodeBuffer = DllStructCreate("byte[" & BinaryLen($Opcode) & "]")
	DllStructSetData($CodeBuffer, 1, $Opcode)

	Local $Ouput = DllStructCreate("byte[" & BinaryLen($Data) & "]")
	Local $Ret = DllCall("user32.dll", "int", "CallWindowProc", "ptr", DllStructGetPtr($CodeBuffer), _
													"str", $Data, _
													"ptr", DllStructGetPtr($Ouput), _
													"int", 0, _
													"int", 0)

	Return BinaryMid(DllStructGetData($Ouput, 1), 1, $Ret[0])
EndFunc

Func _Base64Encode($Data, $LineBreak = 76)
	Local $Opcode = "0x5589E5FF7514535657E8410000004142434445464748494A4B4C4D4E4F505152535455565758595A6162636465666768696A6B6C6D6E6F707172737475767778797A303132333435363738392B2F005A8B5D088B7D108B4D0CE98F0000000FB633C1EE0201D68A06880731C083F901760C0FB6430125F0000000C1E8040FB63383E603C1E60409C601D68A0688470183F90176210FB6430225C0000000C1E8060FB6730183E60FC1E60209C601D68A06884702EB04C647023D83F90276100FB6730283E63F01D68A06884703EB04C647033D8D5B038D7F0483E903836DFC04750C8B45148945FC66B80D0A66AB85C90F8F69FFFFFFC607005F5E5BC9C21000"

	Local $CodeBuffer = DllStructCreate("byte[" & BinaryLen($Opcode) & "]")
	DllStructSetData($CodeBuffer, 1, $Opcode)

	$Data = Binary($Data)
	Local $Input = DllStructCreate("byte[" & BinaryLen($Data) & "]")
	DllStructSetData($Input, 1, $Data)

	$LineBreak = Floor($LineBreak / 4) * 4
	Local $OputputSize = Ceiling(BinaryLen($Data) * 4 / 3)
	$OputputSize = $OputputSize + Ceiling($OputputSize / $LineBreak) * 2 + 4

	Local $Ouput = DllStructCreate("char[" & $OputputSize & "]")
	DllCall("user32.dll", "none", "CallWindowProc", "ptr", DllStructGetPtr($CodeBuffer), _
													"ptr", DllStructGetPtr($Input), _
													"int", BinaryLen($Data), _
													"ptr", DllStructGetPtr($Ouput), _
													"uint", $LineBreak)
	Return DllStructGetData($Ouput, 1)
EndFunc

Func _StringSplit($str,$count)
	Dim $l[1]
	For $i=0 To StringLen($str) Step $count
		_ArrayAdd($l,StringTrimRight(StringTrimLeft($str,$i),StringLen($str)-$i-$count))
	Next
	_ArrayDelete($l,0)
	Return $l
EndFunc

Func _GetJID($jid1)
	$jid = StringSplit($jid1,"/",2)
	return $jid[0]
EndFunc