#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Compression=4
#AutoIt3Wrapper_UseX64=n
#AutoIt3Wrapper_Res_Fileversion=1.0
#AutoIt3Wrapper_Res_LegalCopyright=ArtProxy www.webinweb.ru
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
#region Include
	#NoTrayIcon
	#Include <Constants.au3>
	#include <EditConstants.au3>
	#Include <GuiComboBox.au3>
	#include <GUIConstantsEx.au3>
	#include <Misc.au3>
	#Include <String.au3>
	#include <WindowsConstants.au3>
	#include <WinAPI.au3>
#endregion

#region Opt
	Opt('GUIOnEventMode', 		1)
	Opt('MustDeclareVars', 		1)
	Opt('TrayAutoPause',		0)
	Opt('TrayIconDebug',		0)
	Opt('TrayMenuMode',			1)
	Opt('TrayOnEventMode',		1)
#endregion

#region Pro
Global	$sProName, $iProVer, $sProNameVer, $sProInstancID, $fProInstanc, $iProSleep, $hAutoItWin, $sCfgName, $sCfgFile

		$sProName		= 'FilesCopy'
		$iProVer		= '1.0'
		$sProNameVer	= $sProName &' v'& $iProVer
		$sProInstancID	= ' Instanc ID: '& $sProNameVer &' Instanc ID: '& $sProNameVer
		$fProInstanc	= 1
		$iProSleep		= 20

		If Not _Singleton($sProInstancID, 1) Then
			Msgbox(48, 'Warning', 'Program is already running')
			Exit
		EndIf

		AutoItWinSetTitle($sProNameVer &' '& @AutoItPID)
		$hAutoItWin = WinGetHandle(AutoItWinGetTitle())

		OnAutoItExitRegister('_ProExit_Action')
;~ 		HotKeySet('{ESC}', '_ProExit')

		$sCfgName		= StringRegExpReplace(@ScriptName, '(.*)\..*', '\1') & '.ini'
		$sCfgFile		= FileGetShortName(@ScriptDir &'\'& $sCfgName)
#endregion

#region Global
Local	$y

; Params
Global	$sLastCopyFile, $sLastCopyPath, $sDefCopyPath, $fShowAtStart, $fTrayState, $fMinToTray, $fCloseToTray, $iTrayLeftClick, $iTrayRightClick

; GUI: Main win
Global	$hMainWin, $iMainWin_Width, $iMainWin_Height, $iMainWin_X, $iMainWin_Y, $hMainWinMin, $aGUIs1[15], $aGUIs2[6]
Global	$hCopyFile, $hCopyPath, $hBtCopy, $hCopyFileInfo, $hCopyPathInfo, $hCopyStatus
		$hMainWinMin			= 0
		$iMainWin_Width			= 600
		$iMainWin_Height		= 190
		$aGUIs1[0]				= 14
		$aGUIs2[0]				= 5

; GUI: Settings win
Global	$hSettingsWin, $iSettingsWin_Width, $iSettingsWin_Height, $iSettingsWin_X, $iSettingsWin_Y
Global	$hCopyDefPath
		$iSettingsWin_Width		= 500
		$iSettingsWin_Height	= 270

; GUI: Tray
Global	$fTrayShow, $iTraiTipTime
Global	$hMinToTray, $hCloseToTray, $hShowAtStart, $hTrayState, $hTrayLeftClick, $hTrayRightClick
		$iTraiTipTime = 4000; msec

; Copy
Global	$iCopyPID, $iCopyCheck, $sCopyParam, $iCopyFileSize, $sCopyFileTo
		$iCopyCheck = 50


; Read/Write INI
		If Not FileExists($sCfgFile) Then _IniCreate()
		$sLastCopyFile 	= _IniRead('', 'Params', 'LastCopyFile', 	'', 	1, 3)
		$sLastCopyPath 	= _IniRead('', 'Params', 'LastCopyPath', 	'', 	1, 3)
		$sDefCopyPath  	= _IniRead('', 'Params', 'DefCopyPath', 	'', 	1, 3)
		$fShowAtStart 	= _IniRead('', 'Params', 'ShowAtStart', 	1, 		1, 8, '^[01]$')
		$fTrayState  	= _IniRead('', 'Params', 'TrayState', 		1, 		1, 8, '^[01]$')
		$fMinToTray  	= _IniRead('', 'Params', 'MinToTray', 		0, 		1, 8, '^[01]$')
		$fCloseToTray  	= _IniRead('', 'Params', 'CloseToTray', 	0, 		1, 8, '^[01]$')
		$iTrayLeftClick	= _IniRead('', 'Params', 'TrayLeftClick', 	3, 		1, 8, '^[0-5]$')
		$iTrayRightClick= _IniRead('', 'Params', 'TrayRightClick', 	1, 		1, 8, '^[0-5]$')
		$iMainWin_X		= _IniRead('', 'Params', 'WinX',	 		-1,		1, 8, '^\d+|-1$')
		$iMainWin_Y		= _IniRead('', 'Params', 'WinY', 			-1,		1, 8, '^\d+|-1$')
#endregion

#region GUI: Main win
	$hMainWin = GUICreate($sProNameVer, $iMainWin_Width, $iMainWin_Height, $iMainWin_X, $iMainWin_Y)
		GUISetOnEvent($GUI_EVENT_CLOSE, '_MainWinClose')

	; Copy file
	$aGUIs1[1] = GUICtrlCreateGroup('   :  ', 10, 10, $iMainWin_Width-20, 65)
		GUICtrlSetFont(-1, 10)

	$aGUIs1[2] = GUICtrlCreateInput($sLastCopyFile, 25, 35, $iMainWin_Width-138-24, 25)
		GUICtrlSetFont(-1, 11)
		$hCopyFile = $aGUIs1[2]

	$aGUIs1[3] = GUICtrlCreateButton('X', $iMainWin_Width-110-25, 35, 25)
		GUICtrlSetOnEvent(-1, '_CopyFileNullInput')

	$aGUIs1[3] = GUICtrlCreateButton('O', $iMainWin_Width-110, 35, 25)
		GUICtrlSetOnEvent(-1, '_CopyFileOpenDir')

	$aGUIs1[4] = GUICtrlCreateButton('', $iMainWin_Width-85, 35, 60)
		GUICtrlSetOnEvent(-1, '_CopyFileFind')


	; Copy path
	$y = 70
	$aGUIs1[5] = GUICtrlCreateGroup('   :  ', 10, 10+$y, $iMainWin_Width-20, 65)
		GUICtrlSetFont(-1, 10)

	$aGUIs1[6] = GUICtrlCreateInput($sLastCopyPath, 25, 35+$y, $iMainWin_Width-138-24, 25)
		GUICtrlSetFont(-1, 11)
		$hCopyPath = $aGUIs1[6]

	$aGUIs1[7] = GUICtrlCreateButton('X', $iMainWin_Width-110-25, 35+$y, 25)
		GUICtrlSetOnEvent(-1, '_CopyPathNullInput')

	$aGUIs1[8] = GUICtrlCreateButton('O', $iMainWin_Width-110, 35+$y, 25)
		GUICtrlSetOnEvent(-1, '_CopyPathOpenDir')

	$aGUIs1[9] = GUICtrlCreateButton('', $iMainWin_Width-85, 35+$y, 60)
		GUICtrlSetOnEvent(-1, '_CopyPathFind')


	; Buttons
	$aGUIs1[10] = GUICtrlCreateButton('', 10, 155, 70)
		GUICtrlSetOnEvent(-1, '_SettingsWinShow')

	$aGUIs1[11] = GUICtrlCreateButton('', 10+5+70, 155, 70)
		GUICtrlSetOnEvent(-1, '_ProExit')

	$aGUIs1[12] = GUICtrlCreateButton('', 10+05*2+70*2, 155, 70)
		GUICtrlSetOnEvent(-1, '_MainWinHide')

	$aGUIs1[13] = GUICtrlCreateButton('.  ', $iMainWin_Width-125-5*2-115*2, 155, 115)
		GUICtrlSetFont(-1, 9, 600)
		GUICtrlSetOnEvent(-1, '_CopyAndClose')

	$aGUIs1[14] = GUICtrlCreateButton('.  ', $iMainWin_Width-125-5-115, 155, 115)
		GUICtrlSetFont(-1, 9, 600)
		GUICtrlSetOnEvent(-1, '_CopyAndHide')

	$hBtCopy = GUICtrlCreateButton('', $iMainWin_Width-125, 155, 115)
		GUICtrlSetFont(-1, 9, 600)
		GUICtrlSetOnEvent(-1, '_Copy')


	; Info win
;~ 	For $i=1 To $aGUIs1[0]
;~ 		GUICtrlSetState($aGUIs1[$i], $GUI_HIDE)
;~ 	Next
;~ 	GUICtrlSetPos($hBtCopy, $iMainWin_Width-125-28, 145, 115)
	$y = 10
	$aGUIs2[1] = GUICtrlCreateLabel(' :', 40, $y+8, $iMainWin_Width-50, 25, -1, $GUI_WS_EX_PARENTDRAG)
		GUICtrlSetFont(-1, 11, 500)
	$aGUIs2[2] = GUICtrlCreateInput('c:\asdasd\dqwd2d\asdasddsa.sss', 40, $y+27, $iMainWin_Width-80, 25, $ES_READONLY)
		GUICtrlSetFont(-1, 12, 600)
		$hCopyFileInfo = $aGUIs2[2]

	$y = 68
	$aGUIs2[3] = GUICtrlCreateLabel(' :', 40, $y+8, $iMainWin_Width-50, 25, -1, $GUI_WS_EX_PARENTDRAG)
		GUICtrlSetFont(-1, 11, 500)
	$aGUIs2[4] = GUICtrlCreateInput('\\192.168.1.2\asdasd\dqwd2d\', 40, $y+30, $iMainWin_Width-80, 25, $ES_READONLY)
		GUICtrlSetFont(-1, 12, 600)
		$hCopyPathInfo = $aGUIs2[4]

	$aGUIs2[5] = GUICtrlCreateLabel(' :  0 ', 40, 149, $iMainWin_Width-125-28-50, 25, -1, $GUI_WS_EX_PARENTDRAG)
		GUICtrlSetFont(-1, 11, 500)
		$hCopyStatus = $aGUIs2[5]

	For $i=1 To $aGUIs2[0]
		GUICtrlSetState($aGUIs2[$i], $GUI_HIDE)
	Next
#endregion

#region GUI: Settings
	$hSettingsWin = GUICreate('', $iSettingsWin_Width, $iSettingsWin_Height, -1, -1, $WS_SYSMENU, $WS_EX_MDICHILD, $hMainWin)
		GUISetOnEvent($GUI_EVENT_CLOSE, '_SettingsWinHide')


	; Copy def path
	GUICtrlCreateGroup('    :  ', 10, 10, $iSettingsWin_Width-25, 65)
		GUICtrlSetFont(-1, 10)

	$hCopyDefPath = GUICtrlCreateInput($sDefCopyPath, 25, 35, $iSettingsWin_Width-143-24, 25)
		GUICtrlSetFont(-1, 11)

	GUICtrlCreateButton('X', $iSettingsWin_Width-115-25, 35, 25)
		GUICtrlSetOnEvent(-1, '_CopyDefPathNullInput')

	GUICtrlCreateButton('O', $iSettingsWin_Width-115, 35, 25)
		GUICtrlSetOnEvent(-1, '_CopyDefPathOpenDir')

	GUICtrlCreateButton('', $iSettingsWin_Width-90, 35, 60)
		GUICtrlSetOnEvent(-1, '_CopyDefPathFind')


	; To tray
	GUICtrlCreateGroup('    tray:  ', 10, 80, $iSettingsWin_Width-40-($iSettingsWin_Width/2), 65)
		GUICtrlSetFont(-1, 10)

	$hMinToTray = GUICtrlCreateCheckbox(' ', 	28, 100)
		GUICtrlSetOnEvent(-1, '_SettingsMinToTray')
		If $fMinToTray Then GUICtrlSetState(-1, $GUI_CHECKED)

	$hCloseToTray = GUICtrlCreateCheckbox(' ', 		28, 120)
		GUICtrlSetOnEvent(-1, '_SettingsCloseToTray')
		If $fCloseToTray Then GUICtrlSetState(-1, $GUI_CHECKED)


	; Misck
	GUICtrlCreateGroup('  :  ', ($iSettingsWin_Width/2)-20, 80, $iSettingsWin_Width-($iSettingsWin_Width/2)+5, 65)
		GUICtrlSetFont(-1, 10)

	$hShowAtStart = GUICtrlCreateCheckbox('    ', 	($iSettingsWin_Width/2)-2, 100)
		If $fShowAtStart Then GUICtrlSetState(-1, $GUI_CHECKED)
		GUICtrlSetOnEvent(-1, '_SettingsShowAtStart')

	$hTrayState = GUICtrlCreateCheckbox('    tray', 		($iSettingsWin_Width/2)-2, 120)
		If $fTrayState Then GUICtrlSetState(-1, $GUI_CHECKED)
		GUICtrlSetOnEvent(-1, '_SettingsTrayState')


	; Misck
	GUICtrlCreateGroup('      tray :  ', 10, 150, $iSettingsWin_Width-25, 80)
		GUICtrlSetFont(-1, 10)

	GUICtrlCreateLabel('  ', 28, 175, 130, 25, -1, $GUI_WS_EX_PARENTDRAG)
	$hTrayLeftClick = GUICtrlCreateCombo('', 25, 195, $iSettingsWin_Width-($iSettingsWin_Width/2)-35, 25, BitOR($CBS_DROPDOWN, $CBS_AUTOHSCROLL, $WS_VSCROLL, $CBS_DROPDOWNLIST))
		GUICtrlSetData(-1, ' || |||', '')
		_GUICtrlComboBox_SetCurSel($hTrayLeftClick, $iTrayLeftClick)
		GUICtrlSetOnEvent(-1, '_SettingsLeftClick')


	GUICtrlCreateLabel('  ', $iSettingsWin_Width-($iSettingsWin_Width/2)+2, 175, 130, 25, -1, $GUI_WS_EX_PARENTDRAG)
	$hTrayRightClick = GUICtrlCreateCombo('', $iSettingsWin_Width-($iSettingsWin_Width/2), 195, $iSettingsWin_Width-($iSettingsWin_Width/2)-35, 25, BitOR($CBS_DROPDOWN, $CBS_AUTOHSCROLL, $WS_VSCROLL, $CBS_DROPDOWNLIST))
		GUICtrlSetData(-1, ' || |||', '')
		_GUICtrlComboBox_SetCurSel($hTrayRightClick, $iTrayRightClick)
		GUICtrlSetOnEvent(-1, '_SettingsRightClick')
#endregion

#region GUI: Tray
	TrayCreateItem('')
		TrayItemSetOnEvent(-1, '_MainWinShow')

	TrayCreateItem(' -')
		TrayItemSetOnEvent(-1, '_CopyQuick')

	TrayCreateItem('')
		TrayItemSetOnEvent(-1, '_SettingsWinShow')

	TrayCreateItem('')
		TrayItemSetOnEvent(-1, '_ProExit')
#endregion

#region Start
	GUIRegisterMsg($WM_MOVE,		'WM_MOVE')
	GUIRegisterMsg($WM_NCHITTEST,	'WM_NCHITTEST')
	_TrayState()
	_TraySetClick()
	If $fShowAtStart Then
		_MainWinShow()
	Else
		_TrayShow()
	EndIf
	_MainWinHotKey()
#endregion

#region Sleep...
While 1
	Sleep($iProSleep)
	_MainWinMin()
WEnd

Func _ProExit()
	Exit
EndFunc

Func _ProExit_Action()

EndFunc
#endregion

#region Ini
Func _IniCreate()
	FileWrite($sCfgFile, '')
EndFunc

Func _IniRead($sFile, $sSection, $sKey, $sDef='', $fReWriteIfEr=0, $iStringStripWS=3, $sTestPattern='', $fTestOk=1)
	If $sFile == '' Then $sFile = StringRegExpReplace(@ScriptFullPath, '(.*)\..*', '\1') & '.ini'
	If Not FileExists($sFile) Then
		SetError(1)
		Return $sDef
	EndIf

	If $sSection == '' Then
		SetError(2)
		Return $sDef
	EndIf

	If $sKey == '' Then
		SetError(3)
		Return $sDef
	EndIf

	Local $sResult 	= IniRead($sFile, $sSection, $sKey, '<^!!$@#error#@$!!^>')
	If $sResult <> '<^!!$@#error#@$!!^>' Then
		$sResult = StringStripWS($sResult, $iStringStripWS)
		If StringRegExp($sResult, '^-?\d+\.?\d*$') Then $sResult = Number($sResult)
	Else
		$sResult = $sDef
		If $fReWriteIfEr Then _IniWrite($sFile, $sSection, $sKey, $sResult)
	EndIf

	If $sTestPattern <> '' Then
		If $fTestOk <> 1 AND $fTestOk <> 0 Then $fTestOk = 1
		If StringRegExp($sResult, $sTestPattern) <> $fTestOk Then $sResult = $sDef
	EndIf

	SetError(0)
	Return $sResult
EndFunc

Func _IniWrite($sFile, $sSection, $sKey, $sValue='', $iStringStripWS=0)
	If $sFile == '' Then $sFile = StringRegExpReplace(@ScriptFullPath, '(.*)\..*', '\1') & '.ini'

	If $sSection == '' Then
		SetError(1)
		Return 0
	EndIf

	If $sKey == '' Then
		SetError(2)
		Return 0
	EndIf

	If $iStringStripWS Then $sValue = StringStripWS($sValue, $iStringStripWS)

	If Not StringRegExp($sValue, '^-?\d+\.?\d*$') Then
		$sValue = '"'& $sValue &'"'
	Else
		$sValue = Number($sValue)
	EndIf

	If Not IniWrite($sFile, $sSection, $sKey, $sValue) Then
		SetError(3)
		Return 0
	EndIf

	SetError(0)
	Return 1
EndFunc
#endregion

#region Functions: Tray
Func _TrayState()
	If $fTrayState Then
		_TrayShow()
	Else
		_TrayHide()
	EndIf
EndFunc
Func _TrayShow()
	If $fTrayShow Then Return
	TraySetState(1)
	$fTrayShow = 1
EndFunc
Func _TrayHide()
	If Not $fTrayShow Then Return
	TraySetState(2)
	$fTrayShow = 0
EndFunc
Func _TraySetClick()
	Local $iMouseButton = 0

	If $iTrayLeftClick  == 1 Then
		$iMouseButton += 1
	Else
		_TraySetClick_Action($TRAY_EVENT_PRIMARYDOWN, 	$iTrayLeftClick)
	EndIf

	If $iTrayRightClick == 1 Then
		$iMouseButton += 8
	Else
		_TraySetClick_Action($TRAY_EVENT_SECONDARYDOWN, $iTrayRightClick)
	EndIf

	TraySetClick($iMouseButton)
EndFunc

Func _TraySetClick_Action($vEvent, $iType)
	Switch $iType
		Case 0
			TraySetOnEvent($vEvent, '')
		Case 2
			TraySetOnEvent($vEvent, '_CopyQuick')
		Case 3
			TraySetOnEvent($vEvent, '_MainWinShow')
		Case 4
			TraySetOnEvent($vEvent, '_SettingsWinShow')
		Case 5
			TraySetOnEvent($vEvent, '_ProExit')
	EndSwitch
EndFunc
#endregion

#region Functions: Main win
; Win
Func WM_NCHITTEST($hWnd, $Msg, $wParam, $lParam)
	Local $iProc = DllCall('user32.dll', 'int', 'DefWindowProc', 'hwnd', $hWnd, 'int', $Msg, 'wparam', $wParam, 'lparam', $lParam)
	If $iProc[0] = $HTCLIENT Then Return $HTCAPTION
	Return $GUI_RUNDEFMSG
EndFunc
Func WM_MOVE($hWnd, $Msg, $wParam, $lParam)
	If $hWnd <> $hMainWin OR BitAnd(WinGetState($hMainWin), 16) Then Return
	Local $aWinPos = WinGetPos($hWnd)
	_IniWrite('', 'Params', 'WinX', $aWinPos[0])
	_IniWrite('', 'Params', 'WinY', $aWinPos[1])
EndFunc
Func _MainWinHotKey()
	Local $sEvent = '_ProExit'
	If $fCloseToTray Then $sEvent = '_MainWinHide'

	If BitAnd(WinGetState($hMainWin), 16) OR Not BitAnd(WinGetState($hMainWin), 2) Then
		HotKeySet('{ESC}')
	Else
		HotKeySet('{ESC}', $sEvent)
	EndIf
EndFunc
Func _MainWinClose()
	If $fCloseToTray Then
		_MainWinHide()
	Else
		_ProExit()
	EndIf
EndFunc
Func _MainWinMin()
	If BitAnd(WinGetState($hMainWin), 16) OR Not BitAnd(WinGetState($hMainWin), 2) Then
		If $hMainWinMin  Then Return
		$hMainWinMin = 1
		If $fMinToTray Then
			_MainWinHide()
			_TrayShow()
		EndIf
	Else
		If Not $hMainWinMin  Then Return
		$hMainWinMin = 0
	EndIf
EndFunc
Func _MainWinShow()
	GUISetState(@SW_SHOW, $hMainWin)
	GUISetState(@SW_RESTORE, $hMainWin)
	_TrayState()
	_MainWinHotKey()
	If Not WinActive($hMainWin) Then WinActivate($hMainWin)
EndFunc
Func _MainWinHide()
	GUISetState(@SW_HIDE, $hMainWin)
	_TrayShow()
	_MainWinHotKey()
EndFunc


; Copy file
Func _CopyFileNullInput()
	GUICtrlSetData($hCopyFile, '')
EndFunc
Func _CopyFileOpenDir()
	Local $sFile = StringRegExpReplace(GUICtrlRead($hCopyFile), '^(.+\\).+\..*$', '\1')
	If $sFile == '' OR Not FileExists($sFile) Then
		MsgBox(16, '', '   ')
		Return
	EndIf
	Run('explorer.exe "' & $sFile & '"')
EndFunc
Func _CopyFileFind()
	Local $sFile = GUICtrlRead($hCopyFile)
	If $sFile == '' OR StringInStr(FileGetAttrib($sFile), 'D') OR Not FileExists($sFile) Then $sFile = $sLastCopyFile

	$sFile = FileOpenDialog('  ', StringRegExpReplace($sFile, '^(.+\\).+\..*$', '\1'), 'All (*.*)', 1, StringRegExpReplace($sFile, '^.+\\(.+\..*)$', '\1'), $hMainWin)
	If $sFile <> '' AND $sFile <> $sLastCopyFile Then
		$sLastCopyFile = $sFile
		GUICtrlSetData($hCopyFile, $sLastCopyFile)
		_IniWrite('', 'Params', 'LastCopyFile', $sLastCopyFile)
	EndIf
EndFunc


; Copy path
Func _CopyPathNullInput()
	GUICtrlSetData($hCopyPath, '')
EndFunc
Func _CopyPathOpenDir()
	_OpenDir(GUICtrlRead($hCopyPath))
EndFunc
Func _CopyPathFind()
	Local $sDir = GUICtrlRead($hCopyPath)
	If $sDir == '' OR Not StringInStr(FileGetAttrib($sDir), 'D') OR Not FileExists($sDir) Then $sDir = $sLastCopyPath
	If Not StringInStr(FileGetAttrib($sDir), 'D') Then $sDir = ''

	$sDir = FileSelectFolder('  ', '', 1, $sDir, $hMainWin)
	If $sDir <> '' AND $sDir <> $sLastCopyPath Then
		$sLastCopyPath = $sDir
		GUICtrlSetData($hCopyPath, $sLastCopyPath)
		_IniWrite('', 'Params', 'LastCopyPath', $sLastCopyPath)
	EndIf
EndFunc

Func _OpenDir($sDir)
	If $sDir == '' OR Not StringInStr(FileGetAttrib($sDir), 'D') OR Not FileExists($sDir) Then
		MsgBox(16, '', '   ')
		Return
	EndIf
	Run('explorer.exe "' & $sDir & '"')
EndFunc
#endregion

#region Functions: Settings win
; Win
Func _SettingsWinHide()
	GUISetState(@SW_ENABLE, 	$hMainWin)
	GUISetState(@SW_HIDE, 		$hSettingsWin)
	_MainWinShow()
EndFunc
Func _SettingsWinShow()
	If BitAnd(WinGetState($hMainWin), 16) OR Not BitAnd(WinGetState($hMainWin), 2) Then _MainWinShow()

	Local $aMainWinPos = WinGetPos($hMainWin)
	Local $y = $aMainWinPos[1]+($iMainWin_Height/2)-($iSettingsWin_Height/3.5)

	If $y <= 0 Then
		$y = 10
	ElseIf $y+$iSettingsWin_Height >= @DesktopHeight Then
		$y = @DesktopHeight-10-$iSettingsWin_Height
	EndIf

	WinMove($hSettingsWin, '', $aMainWinPos[0]+($iMainWin_Width/2)-($iSettingsWin_Width/2), $y)
	GUISetState(@SW_DISABLE, 	$hMainWin)
	GUISetState(@SW_SHOW, 		$hSettingsWin)
	HotKeySet('{ESC}', '_SettingsWinHide')
EndFunc


; Copy def path
Func _CopyDefPathNullInput()
	GUICtrlSetData($hCopyPath, '')
EndFunc
Func _CopyDefPathOpenDir()
	_OpenDir(GUICtrlRead($hCopyDefPath))
EndFunc
Func _CopyDefPathFind()
	Local $sDir = GUICtrlRead($hCopyDefPath)
	If $sDir == '' OR Not StringInStr(FileGetAttrib($sDir), 'D') OR Not FileExists($sDir) Then $sDir = $sDefCopyPath
	If Not StringInStr(FileGetAttrib($sDir), 'D') Then $sDir = ''

	$sDir = FileSelectFolder('  ', '', 1, $sDir, $hSettingsWin)
	If $sDir AND $sDir <> $sDefCopyPath Then
		$sDefCopyPath = $sDir
		GUICtrlSetData($hCopyDefPath, $sDefCopyPath)
		_IniWrite('', 'Params', 'DefCopyPath', $sDefCopyPath)
	EndIf
EndFunc


; To tray
Func _SettingsMinToTray()
	$fMinToTray = BitAND(GUICtrlRead($hMinToTray), 1)
	_IniWrite('', 'Params', 'MinToTray', $fMinToTray)
EndFunc
Func _SettingsCloseToTray()
	$fCloseToTray = BitAND(GUICtrlRead($hCloseToTray), 1)
	_IniWrite('', 'Params', 'CloseToTray', $fCloseToTray)
EndFunc


; Micsk
Func _SettingsShowAtStart()
	$fShowAtStart = BitAND(GUICtrlRead($hShowAtStart), 1)
	_IniWrite('', 'Params', 'ShowAtStart', $fShowAtStart)
EndFunc
Func _SettingsTrayState()
	$fTrayState = BitAND(GUICtrlRead($hTrayState), 1)
	_IniWrite('', 'Params', 'TrayState', $fTrayState)
EndFunc


; Tray click
Func _SettingsLeftClick()
	$iTrayLeftClick = _GUICtrlComboBox_GetCurSel($hTrayLeftClick)
	_IniWrite('', 'Params', 'TrayLeftClick', $iTrayLeftClick)
	_TraySetClick()
EndFunc
Func _SettingsRightClick()
	$iTrayRightClick = _GUICtrlComboBox_GetCurSel($hTrayRightClick)
	_IniWrite('', 'Params', 'TrayRightClick', $iTrayRightClick)
	_TraySetClick()
EndFunc
#endregion

#region Functions: Copy
Func _CopyQuick()
	Local $sFile = GUICtrlRead($hCopyFile)
	If $sFile == '' OR StringInStr(FileGetAttrib($sFile), 'D') OR Not FileExists($sFile) Then $sFile = $sLastCopyFile

	$sFile = FileOpenDialog('  ', StringRegExpReplace($sFile, '^(.+\\).+\..*$', '\1'), 'All (*.*)', 1, StringRegExpReplace($sFile, '^.+\\(.+\..*)$', '\1'), $hMainWin)
	If $sFile == '' Then Return

	$sLastCopyFile = $sFile
	GUICtrlSetData($hCopyFile, $sLastCopyFile)
	_CopyStart('quick')
EndFunc
Func _CopyAndClose()
	_CopyStart('close')
EndFunc
Func _CopyAndHide()
	_CopyStart('hide')
EndFunc
Func _Copy()
	_CopyStart('standart')
EndFunc

Func _CopyStart($sParam)
	$sCopyParam = $sParam
	Local $sFile = GUICtrlRead($hCopyFile)
	If $sFile == '' OR StringInStr(FileGetAttrib($sFile), 'D') OR Not FileExists($sFile) Then
		MsgBox(16, '', '      ')
		Return
	EndIf

	If $sParam <> 'quick' Then
		Local $sDir = GUICtrlRead($hCopyPath)
	Else
		Local $sDir = GUICtrlRead($hCopyDefPath)
	EndIf
	If $sDir == '' OR Not StringInStr(FileGetAttrib($sDir), 'D') OR Not FileExists($sDir) Then
		If $sParam <> 'quick' Then
			MsgBox(16, '', '      ')
		Else
			MsgBox(16, '', '       ')
		EndIf
		Return
	EndIf

	$sLastCopyFile = $sFile
	Local $qwe = _IniWrite('', 'Params', 'LastCopyFile', $sLastCopyFile)

	$sLastCopyPath = $sDir
	_IniWrite('', 'Params', 'LastCopyPath', $sLastCopyPath)

	$sCopyFileTo = StringRegExpReplace(GUICtrlRead($hCopyPath), '^(.+)\\$', '\1') & '\' & StringRegExpReplace(GUICtrlRead($hCopyFile), '^.+\\(.+\..*)$', '\1')
	$iCopyFileSize = FileGetSize($sFile)
	GUICtrlSetData($hCopyStatus, ' : ' & _StringReverse(StringRegExpReplace(_StringReverse(Floor($iCopyFileSize/(1024*1024))), '(.{3,3})', '\1 ')) & ' ')

	$iCopyPID = Run(@ComSpec & ' /c ' & 'copy /y /n "' & $sFile & '" "' & $sDir & '"', '', @SW_HIDE)
	GUICtrlSetData($hCopyFileInfo, $sFile)
	GUICtrlSetData($hCopyPathInfo, $sDir)
	GUICtrlSetData($hBtCopy, '')
	GUICtrlSetPos($hBtCopy, $iMainWin_Width-125-28, 145, 115)
	GUICtrlSetOnEvent($hBtCopy, '_CopyStop')
	AdlibRegister('_CopyCheck', $iCopyCheck)
	For $i=1 To $aGUIs2[0]
		GUICtrlSetState($aGUIs2[$i], $GUI_SHOW)
	Next
	For $i=1 To $aGUIs1[0]
		GUICtrlSetState($aGUIs1[$i], $GUI_HIDE)
	Next

	If $sCopyParam == 'hide' OR $sCopyParam == 'close' Then _MainWinHide()
EndFunc
Func _CopyDone($sType)
	AdlibUnRegister('_CopyCheck')
	If $sType == 'done' AND (BitAnd(WinGetState($hMainWin), 16) OR Not BitAnd(WinGetState($hMainWin), 2)) Then TrayTip(' ', '', $iTraiTipTime)
	For $i=1 To $aGUIs1[0]
		GUICtrlSetState($aGUIs1[$i], $GUI_SHOW)
	Next
	For $i=1 To $aGUIs2[0]
		GUICtrlSetState($aGUIs2[$i], $GUI_HIDE)
	Next
	GUICtrlSetData($hBtCopy, '')
	GUICtrlSetPos($hBtCopy, $iMainWin_Width-125, 155, 115)
	GUICtrlSetOnEvent($hBtCopy, '_Copy')

	If $sCopyParam == 'close' Then _ProExit()
EndFunc
Func _CopyStop()
	_CopyDone('stop')
	ProcessClose($iCopyPID)
	If BitAnd(WinGetState($hMainWin), 16) OR Not BitAnd(WinGetState($hMainWin), 2) Then TrayTip(' ', '', $iTraiTipTime)
	If FileExists($sCopyFileTo) Then Run(@ComSpec & ' /c ' & 'del /f /q "' & $sCopyFileTo & '"', '', @SW_HIDE)
	If FileExists($sCopyFileTo) Then FileDelete($sCopyFileTo)
EndFunc

Func _CopyCheck()
	If Not ProcessExists($iCopyPID) Then _CopyDone('done')
EndFunc
#endregion

