#include <WindowsConstants.au3>
#include <GUIConstantsEx.au3>
#include <EditConstants.au3>
#include <ProgressConstants.au3>
#include <Winapi.au3>
Global $fMult=False, $sM_old=10, $fStart, $Title = "CalcResolutionSize"
Global $hGUI = GUICreate($Title, 400, 400, -1, -1, BitOR($WS_MINIMIZEBOX, $WS_CAPTION, $WS_POPUP, $WS_SYSMENU, $WS_SIZEBOX, $WS_CLIPCHILDREN))
Global Const $aPos = WinGetPos($hGUI)
$div = _Nod(@DesktopWidth, @DesktopHeight)
Global $sW_old = @DesktopWidth/$div, $sH_old = @DesktopHeight/$div
$edit = GUICtrlCreateEdit("", 200, 10, 190,380,BitOR($ES_MULTILINE,$ES_WANTRETURN,$WS_VSCROLL,$WS_HSCROLL,$ES_READONLY))
GUICtrlSetBkColor(-1, 0xFFFFFF)
GUICtrlSendMsg(-1, $EM_LIMITTEXT, -1, 0)
GUICtrlSetResizing(-1, $GUI_DOCKBORDERS)
$inputW = GUICtrlCreateInput($sW_old, 10, 10, 80, 20)
GUICtrlSetTip(-1, '', ':', 1)
GUICtrlCreateLabel("X", 97, 13, 10, 10)
$inputH = GUICtrlCreateInput($sH_old, 110, 10, 80, 20)
GUICtrlSetTip(-1, '', ':', 1)
GUICtrlCreateLabel(" :", 10, 50, -1, 18)
Opt('GUICoordMode', 2)
$inputMax = GUICtrlCreateInput("8000", -1, 0, 100, 18, $ES_NUMBER)
GUICtrlSetLimit(-1, 7, 1)
GUICtrlSetTip(-1, '', ' :', 1)
$checkboxMultiple = GUICtrlCreateCheckbox(': ', -1, 20, -1, 18)
$inputMultiple = GUICtrlCreateInput($sM_old, -1, 5, 100, 18)
GUICtrlSetLimit(-1, 7, 1)
GUICtrlSetTip(-1, '  ', ':', 1)
$button = GUICtrlCreateButton("", -1, 40, 100, 24, 0x0001)
GUICtrlSetCursor(-1, 0)
GUICtrlSetTip(-1, ' ', ':', 1)
For $i = $inputW To $button
	GUICtrlSetResizing($i, $GUI_DOCKALL)
Next
$progress = GUICtrlCreateProgress(-1, 170, 180, 8)
GUICtrlSetTip(-1, '     ', ':', 1)
GUICtrlSetResizing(-1, $GUI_DOCKSIZE+$GUI_DOCKLEFT+$GUI_DOCKBOTTOM)

GUICtrlSetState($checkboxMultiple, $fMult?1:4)
GUICtrlSetState($inputMultiple, $fMult?64:128)
GUIRegisterMsg($WM_SIZING, "WM_SIZING")
GUIRegisterMsg($WM_COMMAND, "WM_COMMAND")
GUIRegisterMsg($WM_SYSCOMMAND, "WM_SYSCOMMAND")
GUISetState()

While 1
	$iMsg = GUIGetMsg()
	Switch $iMsg
		Case $checkboxMultiple
			$fMult = $fMult=False
			GUICtrlSetState($inputMultiple, $fMult?64:128)
			GUICtrlSetState($checkboxMultiple, $fMult?1:4)
		Case $button
			GUICtrlSetData ($edit, "")
			calcProcess(GUICtrlRead($inputW), GUICtrlRead($inputH))
		Case $GUI_EVENT_CLOSE
			Exit
	EndSwitch
WEnd

Func WM_SYSCOMMAND($hWnd, $iMsg, $wparam, $lparam)
	Local $iID = BitAND($wParam, 0xFFFF)
	Switch $iID
		Case 61536
			If $fStart Then
				If MsgBox(4+32+256,WinGetTitle($hGUI),' ...' & @LF & '   ?', 0, $hGUI) = 6 Then
					Exit
				Else
					Sleep(10)
					Return 1
				EndIf
			EndIf
	EndSwitch
	Return $GUI_RUNDEFMSG
EndFunc

Func WM_COMMAND($hWnd, $iMsg, $wparam, $lparam)
	Local $CtrlID  = BitAND($wParam, 0xFFFF) ; LoWord
	Local $NotifyCode = BitShift($wParam, 16) ; HiWord
	Local $sM_new, $sW_new, $sH_new
	Switch $CtrlID
		Case $inputW
			Switch $NotifyCode
				Case 1024
					$sW_new = GUICtrlRead($CtrlID)
					If Not Int($sW_new) Or Not StringIsDigit($sW_new) Then
						GUICtrlSetData($CtrlID, $sW_old)
					Else
						$sW_old = $sW_new
					EndIf
			EndSwitch
		Case $inputH
			Switch $NotifyCode
				Case 1024
					$sH_new = GUICtrlRead($CtrlID)
					If Not Int($sH_new) Or Not StringIsDigit($sH_new) Then
						GUICtrlSetData($CtrlID, $sH_old)
					Else
						$sH_old = $sH_new
					EndIf
			EndSwitch
		Case $button
			If $fStart Then Return 1
		Case $inputMultiple
			Switch $NotifyCode
				Case 512, 256
					$sM_new = GUICtrlRead($CtrlID)
					If $sM_new < 1 Then
						GUICtrlSetData($CtrlID, 1)
						$sM_old = 1
					Else
						$sM_old = Int($sM_new)
						GUICtrlSetData($CtrlID, $sM_old)
					EndIf
				Case 1024
					$sM_new = GUICtrlRead($CtrlID)
				If Not StringIsDigit($sM_new) And $sM_new<>'' Then
					GUICtrlSetData($CtrlID, $sM_old)
				Else
					$sM_old = $sM_new
				EndIf
			EndSwitch
	EndSwitch
	Return $GUI_RUNDEFMSG
EndFunc

Func WM_SIZING($hWnd, $iMsg, $wparam, $lparam)
	Local $sRect, $left, $top, $right, $bottom, $w, $h
	$sRect = DllStructCreate("Int[4]", $lparam)
    $left = DllStructGetData($sRect, 1, 1)
    $top = DllStructGetData($sRect, 1, 2)
    $right = DllStructGetData($sRect, 1, 3)
    $bottom = DllStructGetData($sRect, 1, 4)
	$w = $right - $left
	$h = $bottom - $top
	If $w < $aPos[2] Then
		Switch $wparam
			Case 1, 4, 7
				DllStructSetData($sRect, 1, $right-$aPos[2], 1)
			Case 2, 5, 8
				DllStructSetData($sRect, 1, $left+$aPos[2], 3)
		EndSwitch
	EndIf
	If $h < $aPos[3] Then
		Switch $wparam
			Case 3, 4, 5
				DllStructSetData($sRect, 1, $bottom-$aPos[3], 2)
			Case 6, 7, 8
				DllStructSetData($sRect, 1, $top+$aPos[3], 4)
		EndSwitch
	EndIf
	Return $GUI_RUNDEFMSG
EndFunc

Func calcProcess($xM, $yM)
	$fStart = True
	If $fMult And $sM_old <= 1 Then
		$fMult = $fMult=False
		GUICtrlSetState($inputMultiple, $fMult?64:128)
		GUICtrlSetState($checkboxMultiple, $fMult?1:4)
	EndIf
	Local $fMult_L = $fMult
	Local $sM_L = $sM_old
	Local $Max = GUICtrlRead($inputMax), $div, $Str, $x, $y, $iStNew, $iStOld, $Factor, $MaxVal
	$div = _Nod($xM, $yM)
	$xM /= $div
	$yM /= $div
	$MaxVal = $xM>$yM?$xM:$yM
	$Max = $Max<$MaxVal?$MaxVal:Int($Max)
	GUICtrlSetData($inputW, $xM)
	GUICtrlSetData($inputH, $yM)
	GUICtrlSetData($inputMax, $Max)
	$iFactor = Floor($Max/$MaxVal)
	If $fMult Then
		If $sM_L > $iFactor Then $x = $Max+1 ;      
	EndIf
	While 1
		$x += $xM
		$y += $yM
		If $x>$Max Or $y>$Max Then ExitLoop
		$iStNew = Round(($x>$y?$x:$y)/$Max*100, 0)
		If $iStNew <> $iStOld Then
			WinSetTitle($hGUI, '', $Title & ' ' & $iStNew & '%')
			GUICtrlSetData($progress, $iStNew)
			$iStOld = $iStNew
		EndIf
		If $fMult_L Then
			If Not IsInt($x/$sM_L) Or Not IsInt($y/$sM_L) Then ContinueLoop
		EndIf
		$Str &= $x & " x " & $y & " - " & StringFormat("%.2f", Round($x*$y/1000000,2)) & " ." & @CRLF
		If StringLen($Str) >= 1500^2 Then
			GUICtrlSetData($edit, $Str, Default)
			$Str=''
		EndIf
	WEnd
	GUICtrlSetData($edit, $Str=''?'  ,'& @CRLF & '   :' & @CRLF & $iFactor:$Str, Default)
	$Str=''
	WinSetTitle($hGUI, '', $Title)
	GUICtrlSetData($progress, 0)
	$fStart = False
EndFunc

Func _Nod($a, $b)
	While $a And $b
		Execute($a>$b?Assign('a', Mod($a, $b)):Assign('b', Mod($b, $a)))
	WEnd
	Return $a + $b
EndFunc   ;==>_Nod
