#CS
; 	#Include "IniVirtual.au3"
:		Astel064
:	 IniVirtual.au3    -  !!!
===========================================================================

:		 _IniVirtual_Initial($sData)
:		  INI       
	$sData =  INI

:		 1
@Error:		 0

===========================================================================

:		 _IniVirtual_Save($aIniArray)
:		    INI
	$aIniArray =    _IniVirtual_Initial

:		"" ( )=, 1=
@Error:		1=$aIniArray   , 0=

===========================================================================

:		 _IniVirtual_ReadSectionNames($aIniArray)
:		      INI
	$aIniArray =    _IniVirtual_Initial

:		0=, =
@Error:		1=$aIniArray   , 2=  , 0=

===========================================================================

:		 _IniVirtual_Write($aIniArray, $sSection, $sKey, $sValue)
:		     INI
	$aIniArray =    _IniVirtual_Initial
	$sSection = 
	$sKey = 
	$sValue = 

:		0=, 1=
@Error:		1=$aIniArray   , 0=

===========================================================================

:		 _IniVirtual_Read($aIniArray, $sSection, $sKey, $sDefault)
:		     INI
	$aIniArray =    _IniVirtual_Initial
	$sSection = 
	$sKey = 
	$sDefault = ,   ,     

:		 ,    $sDefault
@Error:		1=$aIniArray   , 0=
@Extended:		1= , 0=   -    $sDefault

===========================================================================

:		 _IniVirtual_Delete($aIniArray, $sSection, $sKey)
:		 /   INI
	$aIniArray =    _IniVirtual_Initial
	$sSection = 
	$sKey = ( ) 

:		0=, 1=
@Error:		1=$aIniArray   , 0=

===========================================================================

:		_IniVirtual_ReadSection($aIniArray, $sSection)
:		   =     INI
	$aIniArray =    _IniVirtual_Initial
	$sSection = 

:		0=, 2- =
@Error:		1=$aIniArray   , 2=  , 0=

===========================================================================

:		_IniVirtual_RenameSection(ByRef $aIniArray, $sSection, $sNewName, $iFlag)
:		   INI
	$aIniArray =    _IniVirtual_Initial
	$sSection = ,   
	$sNewName =   
	$iFlag = ( )  : 0 ( )= ,     ; 1=,    $sNewName .      $sNewName.


:		0=, 1=
@Error:		1=$aIniArray   ; 2=  ,   $flag=0; 3=  ; 0=

===========================================================================
#CE















#include-once

;----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

Func __IniVirtual__CheckIni($aIniArray)
If NOT IsArray($aIniArray) Then Return SetError(1,0,0)
If UBound($aIniArray, 2) <> 3 Then Return SetError(2,0,0)
If $aIniArray[0][2] <> "IniVirtual data" Then Return SetError(3,0,0)
Return SetError(0,0,1)
EndFunc

;----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

Func __IniVirtual__SortIni(ByRef $aIniArray)
Local $aSections, $i, $n, $iCol, $aReturn[$aIniArray[0][0]+1][3]
$aSections = _IniVirtual_ReadSectionNames($aIniArray)
	If @Error Then Return 0

$iCol = 0
$aReturn[0][0] = $aIniArray[0][0]
$aReturn[0][1] = $aIniArray[0][1]
$aReturn[0][2] = $aIniArray[0][2]

For $i = 1 To $aSections[0]
	For $n = 1 To $aIniArray[0][0]
		If $aIniArray[$n][0] <> $aSections[$i] Then ContinueLoop
		$iCol += 1
		$aReturn[$iCol][0] = $aIniArray[$n][0]
		$aReturn[$iCol][1] = $aIniArray[$n][1]
		$aReturn[$iCol][2] = $aIniArray[$n][2]
	Next
Next

$aIniArray = $aReturn
Return 1
EndFunc

;----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

Func _IniVirtual_Initial($sData)
Local $aData, $aReturn[1][3], $i, $sSect, $iSect, $aSplit
$aReturn[0][0] = 0
$sSect=""
$iSect=0

$aData = StringSplit($sData, @CRLF, 1)
	If NOT @Error Then
	For $i = 1 To $aData[0]
		If StringLeft($aData[$i], 1) = "[" AND StringRight($aData[$i], 1) = "]" Then
		$sSect = StringTrimLeft(StringTrimRight($aData[$i], 1), 1)
		$iSect += 1
		ContinueLoop
		EndIF
		
		If NOT $iSect Then ContinueLoop
		
		$aSplit = StringSplit($aData[$i], "=")
			If @Error Then ContinueLoop
		
		$aReturn[0][0] += 1
		ReDim $aReturn[$aReturn[0][0]+1][3]
		$aReturn[$aReturn[0][0]][0] = $sSect
		$aReturn[$aReturn[0][0]][1] = $aSplit[1]
		$aReturn[$aReturn[0][0]][2] = StringTrimLeft($aData[$i], StringLen($aSplit[1])+1)
	Next
	EndIF
		
$aReturn[0][1] = $iSect
$aReturn[0][2] = "IniVirtual data"
Return SetError(0,0,$aReturn)
EndFunc

;----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

Func _IniVirtual_Save($aIniArray)
__IniVirtual__CheckIni($aIniArray)
	If @Error Then Return SetError(1,0,"")

__IniVirtual__SortIni($aIniArray)
Local $sReturn, $sSect, $iSect, $i
$sReturn = ""
$sSect = ""
$iSect = 0

If $aIniArray[0][0] < 1 Then Return SetError(0,0,"")

For $i = 1 To $aIniArray[0][0]
	If $aIniArray[$i][0] = "" AND $aIniArray[$i][1] = "" AND $aIniArray[$i][2] = "" Then ContinueLoop

	If $iSect < 1 Then
	$sReturn &= "["&$aIniArray[$i][0]&"]"&@CRLF
	$sSect = $aIniArray[$i][0]
	$iSect += 1
	EndIF
	
	If $sSect <> $aIniArray[$i][0] Then
	$sReturn &= @CRLF&"["&$aIniArray[$i][0]&"]"&@CRLF
	$sSect = $aIniArray[$i][0]
	$iSect += 1
	EndIF
	
	If $aIniArray[$i][0] = "" AND $aIniArray[$i][1] = "" AND $aIniArray[$i][2] = "" Then ContinueLoop
	$sReturn &= $aIniArray[$i][1]&"="&$aIniArray[$i][2]&@CRLF
Next

Return SetError(0,0,$sReturn)
EndFunc

;----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

Func _IniVirtual_ReadSectionNames($aIniArray)
__IniVirtual__CheckIni($aIniArray)
	If @Error Then Return SetError(1,0,"")

	If $aIniArray[0][0] < 1 Then Return SetError(2,0,0)
Local $aReturn[$aIniArray[0][0]][3], $aSectionNames[1], $i, $n, $sEndSect, $fExist
$aSectionNames[0] = 0

For $i = 1 To $aIniArray[0][0]
	If $aIniArray[$i][0] = "" AND $aIniArray[$i][1] = "" AND $aIniArray[$i][2] = "" Then ContinueLoop

	If $aSectionNames[0] < 1 Then
	$aSectionNames[0] += 1
	ReDim $aSectionNames[$aSectionNames[0]+1]
	$aSectionNames[$aSectionNames[0]] = $aIniArray[$i][0]
	$sEndSect = $aIniArray[$i][0]
	ContinueLoop
	EndIF

	If $aIniArray[$i][0] = $sEndSect Then ContinueLoop
	
	$fExist = 0
	For $n = 1 To $aSectionNames[0]
		If $aSectionNames[$n] = $aIniArray[$i][0] Then
		$fExist = 1
		ExitLoop
		EndIF
	Next
	
	If NOT $fExist Then
	$aSectionNames[0] += 1
	ReDim $aSectionNames[$aSectionNames[0]+1]
	$aSectionNames[$aSectionNames[0]] = $aIniArray[$i][0]
	$sEndSect = $aIniArray[$i][0]
	ContinueLoop
	EndIF
Next
	
If $aSectionNames[0] < 1 Then Return SetError(2,0,0)
Return SetError(0,0,$aSectionNames)
EndFunc

;----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

Func _IniVirtual_Write(ByRef $aIniArray, $sSection, $sKey, $sValue)
Local $i, $iMode, $aData[1][3]
__IniVirtual__CheckIni($aIniArray)
	If @Error Then Return SetError(1,0,"")

If $aIniArray[0][0] > 0 Then
	For $i = 1 To $aIniArray[0][0]
		If $aIniArray[$i][0] <> $sSection Then ContinueLoop
		If $aIniArray[$i][1] <> $sKey Then ContinueLoop
		$aIniArray[$i][2] = $sValue
		Return SetError(0,0,1)
	Next
EndIF

$aIniArray[0][0] +=1
ReDim $aIniArray[$aIniArray[0][0]+1][3]
$aIniArray[$aIniArray[0][0]][0] = $sSection
$aIniArray[$aIniArray[0][0]][1] = $sKey
$aIniArray[$aIniArray[0][0]][2] = $sValue
Return SetError(0,0,1)
EndFunc

;----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

Func _IniVirtual_Read($aIniArray, $sSection, $sKey, $sDefault)
__IniVirtual__CheckIni($aIniArray)
	If @Error Then Return SetError(1,0,"")

If $aIniArray[0][0] < 1 Then Return SetError(0,0,$sDefault)

Local $i
For $i = 1 To $aIniArray[0][0]
	If $aIniArray[$i][0] <> $sSection Then ContinueLoop
	If $aIniArray[$i][1] <> $sKey Then ContinueLoop
	Return SetError(0,1,$aIniArray[$i][2])
Next

Return SetError(0,0,$sDefault)
EndFunc

;----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

Func _IniVirtual_Delete(ByRef $aIniArray, $sSection, $sKey="")
__IniVirtual__CheckIni($aIniArray)
	If @Error Then Return SetError(1,0,0)

If $aIniArray[0][0] < 1 Then Return SetError(0,0,1)
Local $i

	If $sKey = "" Then
	For $i = 1 To $aIniArray[0][0]
		If $aIniArray[$i][0] <> $sSection Then ContinueLoop
		$aIniArray[$i][0] = ""
		$aIniArray[$i][1] = ""
		$aIniArray[$i][2] = ""
	Next
	Return SetError(0,0,1)
	EndIF

For $i = 1 To $aIniArray[0][0]
	If $aIniArray[$i][0] <> $sSection Then ContinueLoop
	If $aIniArray[$i][1] <> $sKey Then ContinueLoop
	$aIniArray[$i][0] = ""
	$aIniArray[$i][1] = ""
	$aIniArray[$i][2] = ""
Next
Return SetError(0,0,1)
EndFunc

;----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

Func _IniVirtual_ReadSection($aIniArray, $sSection)
__IniVirtual__CheckIni($aIniArray)
	If @Error Then Return SetError(1,0,0)

If $aIniArray[0][0] < 1 Then Return SetError(2,0,0)

Local $i, $aReturn[1][2]=[[0]]

For $i = 1 To $aIniArray[0][0]
	If $aIniArray[$i][0] <> $sSection Then ContinueLoop
	$aReturn[0][0] += 1
	ReDim $aReturn[$aReturn[0][0]+1][2]
	$aReturn[$aReturn[0][0]][0] = $aIniArray[$i][1]
	$aReturn[$aReturn[0][0]][1] = $aIniArray[$i][2]
Next

If $aReturn[0][0] < 1 Then Return SetError(2,0,0)
Return SetError(0,0,$aReturn)
EndFunc

;----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

Func _IniVirtual_RenameSection(ByRef $aIniArray, $sSection, $sNewName, $iFlag=0)
__IniVirtual__CheckIni($aIniArray)
	If @Error Then Return SetError(1,0,0)

If $aIniArray[0][0] < 1 Then Return SetError(2,0,0)

If $iFlag = 0 Then
	For $i = 1 To $aIniArray[0][0]
		If $aIniArray[$i][0] = $sNewName Then Return SetError(3,0,0)
	Next
EndIF

_IniVirtual_Delete($aIniArray, $sNewName, "")

If $iFlag = 0 Then
	For $i = 1 To $aIniArray[0][0]
		If $aIniArray[$i][0] = $sSection Then $aIniArray[$i][0] = $sNewName
	Next
EndIF

Return SetError(0,0,1)
EndFunc

;----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

Func _IniVirtual_WriteSection(ByRef $aIniArray, $sSection, $vData, $iIndex=1)
__IniVirtual__CheckIni($aIniArray)
	If @Error Then Return SetError(1,0,0)

If IsArray($vData) Then
	If UBound($vData, 2) <> 2 Then Return SetError(2,0,0)
	If UBound($vData, 1) <= $iIndex Then Return SetError(3,0,0)
	Local $i
	
	For $i = $iIndex To UBound($vData, 1)-1
	_IniVirtual_Write($aIniArray, $sSection, $vData[$i][0], $vData[$i][1])
	Next
	
	Return SetError(0,0,1)
EndIF

Local $aLfSplit, $i, $aKeySplit
$aLfSplit = StringSplit($vData, @CRLF, 1)
	If @Error Then
	$aLfSplit = StringSplit($vData, @LF, 1)
		If @Error Then Return SetError(2,0,0)
	EndIF

For $i = 1 To $aLfSplit[0]
	$aKeySplit = StringSplit($aLfSplit[$i], "=")
		If @Error Then ContinueLoop
	_IniVirtual_Write($aIniArray, $sSection, $aKeySplit[1], StringTrimLeft($aLfSplit[$i], StringLen($aKeySplit[1])+1))
Next

Return SetError(0,0,1)
EndFunc

;----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

Func _IniVirtual_IsDuplicateSection($aIniArray)
Return false
EndFunc

;----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

Func _IniVirtual_IsDuplicateKeys($aIniArray, $sSection)
Return false
EndFunc

;----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------



