#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>
#include <Misc.au3>
#include 'Settings.au3'

#Region Settings Startup

Global $sApp_Name = StringTrimRight(@ScriptName, 4)

Global $aSettings_Defs[][2] = _
	[ _
		['GUI BkColor', 0xFFFFFF], _
		['GUI Width', 400], _
		['GUI Height', 200], _
		['GUI OnTop', 0], _
		['Confirm Exit', 1], _
		['Start With Windows', 0] _
	]

Global $sSettings_File = StringTrimRight(@ScriptFullPath, 3) & 'ini'
Global $oSettings = _Settings_Startup($sSettings_File, 'Main', $aSettings_Defs, True)

$oSettings('Start With Windows') = Int(RegRead('HKCU\SOFTWARE\Microsoft\Windows\CurrentVersion\Run', $sApp_Name) <> '')

#EndRegion

$hGUI = GUICreate('Settings UDF Advanced Example', $oSettings('GUI Width'), $oSettings('GUI Height'))
GUISetBkColor($oSettings('GUI BkColor'), $hGUI)
WinSetOnTop($hGUI, '', $oSettings('GUI OnTop'))

$iSettings_Bttn = GUICtrlCreateButton('Settings...', $oSettings('GUI Width') - 160, $oSettings('GUI Height') - 30, 70, 20)
$iExit_Bttn = GUICtrlCreateButton('Exit', $oSettings('GUI Width') - 80, $oSettings('GUI Height') - 30, 60, 20)

GUISetState(@SW_SHOW, $hGUI)

While 1
	Switch GUIGetMsg()
		Case $GUI_EVENT_CLOSE, $iExit_Bttn
			If $oSettings('Confirm Exit') = 0 Or MsgBox(52, 'Attention', 'Are you sure, exit the program?', 0, $hGUI) = 6 Then
				_Settings_Shutdown($oSettings)
				Exit
			EndIf
		Case $iSettings_Bttn
			_Settings_GUI('Settings', $hGUI)
			
			If Not @error Then
				WinSetOnTop($hGUI, '', $oSettings('GUI OnTop'))
				GUISetBkColor($oSettings('GUI BkColor'), $hGUI)
				
				If $oSettings('Start With Windows') = 1 Then
					RegWrite('HKCU\SOFTWARE\Microsoft\Windows\CurrentVersion\Run', $sApp_Name, 'REG_SZ', (@Compiled ? @AutoItExe : '"' & @AutoItExe & '" "' & @ScriptFullPath & '"'))
				Else
					RegDelete('HKCU\SOFTWARE\Microsoft\Windows\CurrentVersion\Run', $sApp_Name)
				EndIf
			EndIf
	EndSwitch
WEnd

Func _Settings_GUI($sTitle, $hParent = 0)
	Local $hGUI, $iOnTop_CB, $iConfirmExit_CB, $iSetBkColor_Bttn, $iSetStartupDefs_Bttn, $iSetFactoryDefs_Bttn
	Local $iOK_Bttn, $iCancel_Bttn, $iMsg
	Local $iError = 1
	
	If IsHWnd($hParent) Then
		GUISetState(@SW_DISABLE, $hParent)
	EndIf
	
	$hGUI = GUICreate($sTitle, 300, 300, -1, -1, -1, $WS_EX_TOOLWINDOW, $hParent)
	GUISetBkColor($oSettings('GUI BkColor'), $hGUI)
	
	$iOnTop_CB = GUICtrlCreateCheckbox('Set on top', 20, 20)
	GUICtrlSetState($iOnTop_CB, ($oSettings('GUI OnTop') = 1 ? $GUI_CHECKED : $GUI_UNCHECKED))
	
	$iConfirmExit_CB = GUICtrlCreateCheckbox('Confirm exit', 20, 50)
	GUICtrlSetState($iConfirmExit_CB, ($oSettings('Confirm Exit') = 1 ? $GUI_CHECKED : $GUI_UNCHECKED))
	
	$iStartWithWindows_CB = GUICtrlCreateCheckbox('Start with windows', 20, 80)
	GUICtrlSetState($iStartWithWindows_CB, ($oSettings('Start With Windows') = 1 ? $GUI_CHECKED : $GUI_UNCHECKED))
	
	GUICtrlCreateLabel('Bk Color', 20, 133)
	$iSetBkColor_Bttn = GUICtrlCreateButton('', 80, 130, 50, 20)
	GUICtrlSetBkColor($iSetBkColor_Bttn, $oSettings('GUI BkColor'))
	
	$iSetStartupDefs_Bttn = GUICtrlCreateButton('Set Startup/Last Defaults...', 20, 240, 140, 20)
	$iSetFactoryDefs_Bttn = GUICtrlCreateButton('Set Factory Defaults...', 170, 240, 120, 20)
	
	$iOK_Bttn = GUICtrlCreateButton('OK', 20, 270, 60, 20)
	$iCancel_Bttn = GUICtrlCreateButton('Cancel', 90, 270, 60, 20)
	
	GUISetState(@SW_SHOW, $hGUI)
	
	While 1
		$iMsg = GUIGetMsg()
		
		Switch $iMsg
			Case $iOnTop_CB
				$oSettings('GUI OnTop') = Int(BitAND(GUICtrlRead($iOnTop_CB), $GUI_CHECKED) = $GUI_CHECKED)
			Case $iConfirmExit_CB
				$oSettings('Confirm Exit') = Int(BitAND(GUICtrlRead($iConfirmExit_CB), $GUI_CHECKED) = $GUI_CHECKED)
			Case $iStartWithWindows_CB
				$oSettings('Start With Windows') = Int(BitAND(GUICtrlRead($iStartWithWindows_CB), $GUI_CHECKED) = $GUI_CHECKED)
			Case $iSetBkColor_Bttn
				Local $iColor = _ChooseColor(2, $oSettings('GUI BkColor'), 2, $hGUI)
				
				If Not @error Then
					$oSettings('GUI BkColor') = $iColor
					GUICtrlSetBkColor($iSetBkColor_Bttn, $iColor)
				EndIf
			Case $iSetStartupDefs_Bttn, $iSetFactoryDefs_Bttn
				If MsgBox(52, 'Attention', 'Are you sure, reset program to ' & ($iMsg = $iSetStartupDefs_Bttn ? 'startup' : 'factory') & ' defaults?', 0, $hGUI) = 6 Then
					_Settings_SetDefaults($oSettings, ($iMsg = $iSetFactoryDefs_Bttn))
					ContinueCase
				EndIf
			Case $iOK_Bttn
				$iError = 0
				_Settings_Apply($oSettings) ;Resets startup defaults
				ExitLoop
			Case $GUI_EVENT_CLOSE, $iCancel_Bttn
				_Settings_SetDefaults($oSettings, False)
				ExitLoop
		EndSwitch
	WEnd
	
	If IsHWnd($hParent) Then
		GUISetState(@SW_ENABLE, $hParent)
	EndIf
	
	GUIDelete($hGUI)
	SetError($iError)
EndFunc
