#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>
#include <Misc.au3>
#include 'Settings.au3'

#Region Settings Startup

Global $aSettings_Defs[][2] = _
	[ _
		['GUI BkColor', 0xFFFFFF], _
		['GUI OnTop', 0], _
		['Confirm Exit', 1] _
	]

Global $sSettings_File = StringTrimRight(@ScriptFullPath, 3) & 'ini'
Global $oSettings = _Settings_Startup($sSettings_File, 'Main', $aSettings_Defs, True)

#EndRegion

$hGUI = GUICreate('Settings UDF Advanced Example', 300, 200)
GUISetBkColor($oSettings('GUI BkColor'), $hGUI)
WinSetOnTop($hGUI, '', $oSettings('GUI OnTop'))

$iOnTop_CB = GUICtrlCreateCheckbox('Set on top', 20, 20)
GUICtrlSetState($iOnTop_CB, ($oSettings('GUI OnTop') = 1 ? $GUI_CHECKED : $GUI_UNCHECKED))

$iConfirmExit_CB = GUICtrlCreateCheckbox('Confirm exit', 20, 50)
GUICtrlSetState($iConfirmExit_CB, ($oSettings('Confirm Exit') = 1 ? $GUI_CHECKED : $GUI_UNCHECKED))

GUICtrlCreateLabel('Bk Color', 20, 92)
$iSetBkColor_Bttn = GUICtrlCreateButton('...', 80, 90, 20, 20)

$iSetStartupDefs_Bttn = GUICtrlCreateButton('Set Startup Defaults...', 70, 140, 160, 20)
$iSetFactoryDefs_Bttn = GUICtrlCreateButton('Set Factory Defaults...', 70, 170, 160, 20)

GUISetState(@SW_SHOW, $hGUI)

$oTmp_Sttngs = _Settings_GetDefaults($oSettings, True)
ConsoleWrite($oTmp_Sttngs('Confirm Exit') & @CRLF)

While 1
	$iMsg = GUIGetMsg()
	
	Switch $iMsg
		Case $GUI_EVENT_CLOSE
			If $oSettings('Confirm Exit') = 0 Or MsgBox(52, 'Attention', 'Are you sure, exit the program?', 0, $hGUI) = 6 Then
				_Settings_Shutdown($oSettings)
				Exit
			EndIf
		Case $iOnTop_CB
			$oSettings('GUI OnTop') = Int(BitAND(GUICtrlRead($iOnTop_CB), $GUI_CHECKED) = $GUI_CHECKED)
			WinSetOnTop($hGUI, '', $oSettings('GUI OnTop'))
		Case $iConfirmExit_CB
			$oSettings('Confirm Exit') = Int(BitAND(GUICtrlRead($iConfirmExit_CB), $GUI_CHECKED) = $GUI_CHECKED)
		Case $iSetBkColor_Bttn
			$iColor = _ChooseColor(2, $oSettings('GUI BkColor'), 2, $hGUI)
			
			If Not @error Then
				$oSettings('GUI BkColor') = $iColor
				GUISetBkColor($oSettings('GUI BkColor'), $hGUI)
			EndIf
		Case $iSetStartupDefs_Bttn, $iSetFactoryDefs_Bttn
			If MsgBox(52, 'Attention', 'Are you sure, reset program to ' & ($iMsg = $iSetStartupDefs_Bttn ? 'startup' : 'factory') & ' defaults?', 0, $hGUI) = 6 Then
				_Settings_SetDefaults($oSettings, ($iMsg = $iSetFactoryDefs_Bttn))
				
				WinSetOnTop($hGUI, '', $oSettings('GUI OnTop'))
				GUISetBkColor($oSettings('GUI BkColor'), $hGUI)
				
				GUICtrlSetState($iOnTop_CB, ($oSettings('GUI OnTop') = 1 ? $GUI_CHECKED : $GUI_UNCHECKED))
				GUICtrlSetState($iConfirmExit_CB, ($oSettings('Confirm Exit') = 1 ? $GUI_CHECKED : $GUI_UNCHECKED))
			EndIf
	EndSwitch
WEnd
