#include-once
#include <StructureConstants.au3>
#include <GDIPlusConstants.au3>

#Region Enums, Constants and Structures

; External Data Item structure
Global Const $tagGDIPIMAGEITEMDATA = _
    "uint Size;" & _		; size of the structure
    "uint Position;" & _	; flags describing how the data is to be used.
    "ptr Desc;" & _			; description on how the data is to be saved. it is different for every codec type.
    "uint DescSize;" & _	; size memory pointed by Desc
    "ptr Data;" & _ 		; pointer to the data that is to be saved in the file, could be anything saved directly.
	"uint DataSize;" & _	; size memory pointed by Data
    "uint Cookie;"			; opaque for the apps data member used during enumeration of image data items.

; Property Item structure
Global Const $tagGDIPPROPERTYITEM = _
    "uint id;" & _			; ID of this property
    "uint length;" & _		; Length of the property value, in bytes
    "ushort type;" & _		; Type of the value, as one of TAG_TYPE_XXX constants
	"ptr value;"			; property value

Global Const $tagGDIPCOLORPALETTE = _
    "uint Flags;" & _		; Palette flags
    "uint Count;" & _		; Number of color entries
    "uint Entries[0]"		; Palette color entries

Global Const $tagGDIPPWMFRect16 = "short Left;short Top;short Right;short Bottom;"
Global Const $tagGDIPWmfPlaceableFileHeader = "align 2;uint Key;short Hmf;" & $tagGDIPPWMFRect16 & "short Inch;uint Reserved;short Checksum;"

; GDI metafile header structure
Global Const $tagGDIPMETAHEADER = "ushort mtType;ushort mtHeaderSize;ushort mtVersion;uint mtSize;ushort mtNoObjects;uint mtMaxRecord;ushort mtNoParameters;"

; GDI+ enhanced metafile header structure
Global Const $tagGDIPENHMETAHEADER3 = _
	"uint Type;" & _		; Record type EMR_HEADER
    "uint Size;" & _		; Record size in bytes. This may be greater than the sizeof $tagGDIPMETAHEADER
    "int BoundLeft;" & _	; Inclusive-inclusive bounds in device units
	"int BoundTop;" & _
	"int BoundRight;" & _
	"int BoundBottom;" & _
    "int FrameLeft;" & _	; Inclusive-inclusive Picture Frame .01mm unit
	"int FrameTop;" & _
	"int FrameRight;" & _
	"int FrameBottom;" & _
    "uint Signature;" & _	; Signature.  Must be $GDIP_ENHMETA_SIGNATURE
    "uint Version;" & _		; Version number
    "uint Bytes;" & _		; Size of the metafile in bytes
    "uint Records;" & _		; Number of records in the metafile
    "ushort Handles;" & _	; Number of handles in the handle table. Handle index zero is reserved
    "ushort Reserved;" & _	; Reserved.  Must be zero
    "uint DescriptionChars;" & _	; Number of chars in the unicode desc string This is 0 if there is no description string
    "uint DescriptionOffset;" & _	; Offset to the metafile description record. This is 0 if there is no description string
    "uint PalEntries;" & _	; Number of entries in the metafile palette
    "int cxPixels;" & _		; Size of the reference device in pixels
	"int cyPixels;" & _
    "int cxMillimeters;" & _; Size of the reference device in millimeters
	"int cyMillimeters;"

Global Const $tagGDIPMETAFILEHEADER_METAHEADER = _
	"align 2;" & _
    "int Type;" & _
    "uint Size;" & _		; Size of the metafile (in bytes)
    "uint Version;" & _		; EMF+, EMF, or WMF version
    "uint EmfPlusFlags;" & _
    "float DpiX;" & _
    "float DpiY;" & _
    "int X;" & _			; Bounds in device units
    "int Y;" & _
    "int Width;" & _
    "int Height;" & _
    $tagGDIPMETAHEADER & _
	"byte[70];" & _			; Padding
    "int EmfPlusHeaderSize;" & _	; size of the EMF+ header in file
    "int LogicalDpiX;" & _	; Logical Dpi of reference Hdc
    "int LogicalDpiY;"		; usually valid only for EMF+

Global Const $tagGDIPMETAFILEHEADER_ENHMETAHEADER3 = _
    "int Type;" & _
    "uint Size;" & _		; Size of the metafile (in bytes)
    "uint Version;" & _		; EMF+, EMF, or WMF version
    "uint EmfPlusFlags;" & _
    "float DpiX;" & _
    "float DpiY;" & _
    "int X;" & _			; Bounds in device units
    "int Y;" & _
    "int Width;" & _
    "int Height;" & _
    $tagGDIPENHMETAHEADER3 & _
    "int EmfPlusHeaderSize;" & _	; size of the EMF+ header in file
    "int LogicalDpiX;" & _	; Logical Dpi of reference Hdc
    "int LogicalDpiY;"		; usually valid only for EMF+

; $tagGDIPCHARACTERRANGE structure used by several Text Functions
Global Const $tagGDIPCHARACTERRANGE = _
	"int First;" & _	; Specifies the first position of this range
	"int Length;"		; Specifies the number of positions in this range

; $tagLOGFONT structures (ASCII and Unicode)
Global Const $tagLOGFONTA = $tagLOGFONT
Global Const $tagLOGFONTW = "int Height;int Width;int Escapement;int Orientation;int Weight;byte Italic;byte Underline;" & _
		"byte Strikeout;byte CharSet;byte OutPrecision;byte ClipPrecision;byte Quality;byte PitchAndFamily;wchar FaceName[32]"

Global Const $GDIP_ENHMETA_SIGNATURE = 0x464D4520

; Multi-frame dimensions (Globally Unique Identifier (GUID))
Global Const $GDIP_FRAMEDIMENSION_TIME 		 = "{6AEFBD6D-3FB5-418A-83A6-7F45229DC872}"
Global Const $GDIP_FRAMEDIMENSION_RESOLUTION = "{84236F7B-3BD3-428F-8DAB-4EA1439CA315}"
Global Const $GDIP_FRAMEDIMENSION_PAGE 		 = "{7462DC86-6180-4C7E-8E3F-EE7333A7A483}"

; Property sets constants
Global Const $GDIP_FIDIMAGEINFO  			 = "{E5836CBE-5EEF-4F1D-ACDE-AE4C43B608CE}"
Global Const $GDIP_FIDJPEGAPPHEADERS 	 	 = "{1C4AFDCD-6177-43CF-ABC7-5F51AF39EE85}"

; GDIPVER >= 0x0110 error code
Global Const $GDIP_ERRPROFILENOTFOUND = 21 ; The specified profile could not be found

; Radians, PI, etc..
Global Const $GDIP_PI = 4*atan(1)
Global Const $GDIP_RAD = $GDIP_PI/180
Global Const $FlatnessDefault = 1/4

; LogFont maximum face name string length.
Global Const $GDIP_LF_FACESIZE = 32

Global Const $GDIP_ITEMDATAPOSITIONAFTERHEADER = 0x0
Global Const $GDIP_ITEMDATAPOSITIONAFTERPALETTE = 0x1
Global Const $GDIP_ITEMDATAPOSITIONAFTERBITS = 0x2

; Image property types constants
Global Const $GDIP_PROPERTYTAGTYPEBYTE = 1
Global Const $GDIP_PROPERTYTAGTYPEASCII = 2
Global Const $GDIP_PROPERTYTAGTYPESHORT = 3
Global Const $GDIP_PROPERTYTAGTYPELONG = 4
Global Const $GDIP_PROPERTYTAGTYPERATIONAL = 5
Global Const $GDIP_PROPERTYTAGTYPEUNDEFINED = 7
Global Const $GDIP_PROPERTYTAGTYPESLONG = 9
Global Const $GDIP_PROPERTYTAGTYPESRATIONAL = 10

; Image property ID tags constants
Global Const $GDIP_PROPERTYTAGEXIFIFD = 0x8769
Global Const $GDIP_PROPERTYTAGGPSIFD = 0x8825

Global Const $GDIP_PROPERTYTAGNEWSUBFILETYPE = 0x00FE
Global Const $GDIP_PROPERTYTAGSUBFILETYPE = 0x00FF
Global Const $GDIP_PROPERTYTAGIMAGEWIDTH = 0x0100
Global Const $GDIP_PROPERTYTAGIMAGEHEIGHT = 0x0101
Global Const $GDIP_PROPERTYTAGBITSPERSAMPLE = 0x0102
Global Const $GDIP_PROPERTYTAGCOMPRESSION = 0x0103
Global Const $GDIP_PROPERTYTAGPHOTOMETRICINTERP = 0x0106
Global Const $GDIP_PROPERTYTAGTHRESHHOLDING = 0x0107
Global Const $GDIP_PROPERTYTAGCELLWIDTH = 0x0108
Global Const $GDIP_PROPERTYTAGCELLHEIGHT = 0x0109
Global Const $GDIP_PROPERTYTAGFILLORDER = 0x010A
Global Const $GDIP_PROPERTYTAGDOCUMENTNAME = 0x010D
Global Const $GDIP_PROPERTYTAGIMAGEDESCRIPTION = 0x010E
Global Const $GDIP_PROPERTYTAGEQUIPMAKE = 0x010F
Global Const $GDIP_PROPERTYTAGEQUIPMODEL = 0x0110
Global Const $GDIP_PROPERTYTAGSTRIPOFFSETS = 0x0111
Global Const $GDIP_PROPERTYTAGORIENTATION = 0x0112
Global Const $GDIP_PROPERTYTAGSAMPLESPERPIXEL = 0x0115
Global Const $GDIP_PROPERTYTAGROWSPERSTRIP = 0x0116
Global Const $GDIP_PROPERTYTAGSTRIPBYTESCOUNT = 0x0117
Global Const $GDIP_PROPERTYTAGMINSAMPLEVALUE = 0x0118
Global Const $GDIP_PROPERTYTAGMAXSAMPLEVALUE = 0x0119
Global Const $GDIP_PROPERTYTAGXRESOLUTION = 0x011A   ; Image resolution in width direction
Global Const $GDIP_PROPERTYTAGYRESOLUTION = 0x011B   ; Image resolution in height direction
Global Const $GDIP_PROPERTYTAGPLANARCONFIG = 0x011C   ; Image data arrangement
Global Const $GDIP_PROPERTYTAGPAGENAME = 0x011D
Global Const $GDIP_PROPERTYTAGXPOSITION = 0x011E
Global Const $GDIP_PROPERTYTAGYPOSITION = 0x011F
Global Const $GDIP_PROPERTYTAGFREEOFFSET = 0x0120
Global Const $GDIP_PROPERTYTAGFREEBYTECOUNTS = 0x0121
Global Const $GDIP_PROPERTYTAGGRAYRESPONSEUNIT = 0x0122
Global Const $GDIP_PROPERTYTAGGRAYRESPONSECURVE = 0x0123
Global Const $GDIP_PROPERTYTAGT4OPTION = 0x0124
Global Const $GDIP_PROPERTYTAGT6OPTION = 0x0125
Global Const $GDIP_PROPERTYTAGRESOLUTIONUNIT = 0x0128   ; Unit of X and Y resolution
Global Const $GDIP_PROPERTYTAGPAGENUMBER = 0x0129
Global Const $GDIP_PROPERTYTAGTRANSFERFUNCITION = 0x012D
Global Const $GDIP_PROPERTYTAGSOFTWAREUSED = 0x0131
Global Const $GDIP_PROPERTYTAGDATETIME = 0x0132
Global Const $GDIP_PROPERTYTAGARTIST = 0x013B
Global Const $GDIP_PROPERTYTAGHOSTCOMPUTER = 0x013C
Global Const $GDIP_PROPERTYTAGPREDICTOR = 0x013D
Global Const $GDIP_PROPERTYTAGWHITEPOINT = 0x013E
Global Const $GDIP_PROPERTYTAGPRIMARYCHROMATICITIES = 0x013F
Global Const $GDIP_PROPERTYTAGCOLORMAP = 0x0140
Global Const $GDIP_PROPERTYTAGHALFTONEHINTS = 0x0141
Global Const $GDIP_PROPERTYTAGTILEWIDTH = 0x0142
Global Const $GDIP_PROPERTYTAGTILELENGTH = 0x0143
Global Const $GDIP_PROPERTYTAGTILEOFFSET = 0x0144
Global Const $GDIP_PROPERTYTAGTILEBYTECOUNTS = 0x0145
Global Const $GDIP_PROPERTYTAGINKSET = 0x014C
Global Const $GDIP_PROPERTYTAGINKNAMES = 0x014D
Global Const $GDIP_PROPERTYTAGNUMBEROFINKS = 0x014E
Global Const $GDIP_PROPERTYTAGDOTRANGE = 0x0150
Global Const $GDIP_PROPERTYTAGTARGETPRINTER = 0x0151
Global Const $GDIP_PROPERTYTAGEXTRASAMPLES = 0x0152
Global Const $GDIP_PROPERTYTAGSAMPLEFORMAT = 0x0153
Global Const $GDIP_PROPERTYTAGSMINSAMPLEVALUE = 0x0154
Global Const $GDIP_PROPERTYTAGSMAXSAMPLEVALUE = 0x0155
Global Const $GDIP_PROPERTYTAGTRANSFERRANGE = 0x0156

Global Const $GDIP_PROPERTYTAGJPEGPROC = 0x0200
Global Const $GDIP_PROPERTYTAGJPEGINTERFORMAT = 0x0201
Global Const $GDIP_PROPERTYTAGJPEGINTERLENGTH = 0x0202
Global Const $GDIP_PROPERTYTAGJPEGRESTARTINTERVAL = 0x0203
Global Const $GDIP_PROPERTYTAGJPEGLOSSLESSPREDICTORS = 0x0205
Global Const $GDIP_PROPERTYTAGJPEGPOINTTRANSFORMS = 0x0206
Global Const $GDIP_PROPERTYTAGJPEGQTABLES = 0x0207
Global Const $GDIP_PROPERTYTAGJPEGDCTABLES = 0x0208
Global Const $GDIP_PROPERTYTAGJPEGACTABLES = 0x0209
Global Const $GDIP_PROPERTYTAGYCBCRCOEFFICIENTS = 0x0211
Global Const $GDIP_PROPERTYTAGYCBCRSUBSAMPLING = 0x0212
Global Const $GDIP_PROPERTYTAGYCBCRPOSITIONING = 0x0213
Global Const $GDIP_PROPERTYTAGREFBLACKWHITE = 0x0214

Global Const $GDIP_PROPERTYTAGICCPROFILE = 0x8773   ; This TAG is defined by ICC for embedded ICC in TIFF
Global Const $GDIP_PROPERTYTAGGAMMA = 0x0301
Global Const $GDIP_PROPERTYTAGICCPROFILEDESCRIPTOR = 0x0302
Global Const $GDIP_PROPERTYTAGSRGBRENDERINGINTENT = 0x0303
Global Const $GDIP_PROPERTYTAGIMAGETITLE = 0x0320
Global Const $GDIP_PROPERTYTAGCOPYRIGHT = 0x8298

; Extra TAG constants (Like Adobe Image Information tags etc.)
Global Const $GDIP_PROPERTYTAGRESOLUTIONXUNIT = 0x5001
Global Const $GDIP_PROPERTYTAGRESOLUTIONYUNIT = 0x5002
Global Const $GDIP_PROPERTYTAGRESOLUTIONXLENGTHUNIT = 0x5003
Global Const $GDIP_PROPERTYTAGRESOLUTIONYLENGTHUNIT = 0x5004
Global Const $GDIP_PROPERTYTAGPRINTFLAGS = 0x5005
Global Const $GDIP_PROPERTYTAGPRINTFLAGSVERSION = 0x5006
Global Const $GDIP_PROPERTYTAGPRINTFLAGSCROP = 0x5007
Global Const $GDIP_PROPERTYTAGPRINTFLAGSBLEEDWIDTH = 0x5008
Global Const $GDIP_PROPERTYTAGPRINTFLAGSBLEEDWIDTHSCALE = 0x5009
Global Const $GDIP_PROPERTYTAGHALFTONELPI = 0x500A
Global Const $GDIP_PROPERTYTAGHALFTONELPIUNIT = 0x500B
Global Const $GDIP_PROPERTYTAGHALFTONEDEGREE = 0x500C
Global Const $GDIP_PROPERTYTAGHALFTONESHAPE = 0x500D
Global Const $GDIP_PROPERTYTAGHALFTONEMISC = 0x500E
Global Const $GDIP_PROPERTYTAGHALFTONESCREEN = 0x500F
Global Const $GDIP_PROPERTYTAGJPEGQUALITY = 0x5010
Global Const $GDIP_PROPERTYTAGGRIDSIZE = 0x5011
Global Const $GDIP_PROPERTYTAGTHUMBNAILFORMAT = 0x5012  ; 1 = JPEG, 0 = RAW RGB
Global Const $GDIP_PROPERTYTAGTHUMBNAILWIDTH = 0x5013
Global Const $GDIP_PROPERTYTAGTHUMBNAILHEIGHT = 0x5014
Global Const $GDIP_PROPERTYTAGTHUMBNAILCOLORDEPTH = 0x5015
Global Const $GDIP_PROPERTYTAGTHUMBNAILPLANES = 0x5016
Global Const $GDIP_PROPERTYTAGTHUMBNAILRAWBYTES = 0x5017
Global Const $GDIP_PROPERTYTAGTHUMBNAILSIZE = 0x5018
Global Const $GDIP_PROPERTYTAGTHUMBNAILCOMPRESSEDSIZE = 0x5019
Global Const $GDIP_PROPERTYTAGCOLORTRANSFERFUNCTION = 0x501A
Global Const $GDIP_PROPERTYTAGTHUMBNAILDATA = 0x501B; RAW thumbnail bits in JPEG format or RGB format depends on PropertyTagThumbnailFormat

; Thumbnail related TAG constants
Global Const $PropertyTagThumbnailImageWidth = 0x5020  ; Thumbnail width
Global Const $PropertyTagThumbnailImageHeight = 0x5021  ; Thumbnail height
Global Const $PropertyTagThumbnailBitsPerSample = 0x5022  ; Number of bits per component
Global Const $GDIP_PROPERTYTAGTHUMBNAILCOMPRESSION = 0x5023  ; Compression Scheme
Global Const $GDIP_PROPERTYTAGTHUMBNAILPHOTOMETRICINTERP = 0x5024 ; Pixel composition
Global Const $GDIP_PROPERTYTAGTHUMBNAILIMAGEDESCRIPTION = 0x5025  ; Image Tile
Global Const $GDIP_PROPERTYTAGTHUMBNAILEQUIPMAKE = 0x5026  ; Manufacturer of Image Input equipment
Global Const $GDIP_PROPERTYTAGTHUMBNAILEQUIPMODEL = 0x5027  ; Model of Image input equipment
Global Const $GDIP_PROPERTYTAGTHUMBNAILSTRIPOFFSETS = 0x5028  ; Image data location
Global Const $GDIP_PROPERTYTAGTHUMBNAILORIENTATION = 0x5029  ; Orientation of image
Global Const $GDIP_PROPERTYTAGTHUMBNAILSAMPLESPERPIXEL = 0x502A  ; Number of components
Global Const $GDIP_PROPERTYTAGTHUMBNAILROWSPERSTRIP = 0x502B  ; Number of rows per strip
Global Const $GDIP_PROPERTYTAGTHUMBNAILSTRIPBYTESCOUNT = 0x502C  ; Bytes per compressed strip
Global Const $GDIP_PROPERTYTAGTHUMBNAILRESOLUTIONX = 0x502D  ; Resolution in width direction
Global Const $GDIP_PROPERTYTAGTHUMBNAILRESOLUTIONY = 0x502E  ; Resolution in height direction
Global Const $GDIP_PROPERTYTAGTHUMBNAILPLANARCONFIG = 0x502F  ; Image data arrangement
Global Const $GDIP_PROPERTYTAGTHUMBNAILRESOLUTIONUNIT = 0x5030  ; Unit of X and Y Resolution
Global Const $GDIP_PROPERTYTAGTHUMBNAILTRANSFERFUNCTION = 0x5031  ; Transfer function
Global Const $GDIP_PROPERTYTAGTHUMBNAILSOFTWAREUSED = 0x5032  ; Software used
Global Const $GDIP_PROPERTYTAGTHUMBNAILDATETIME = 0x5033  ; File change date and time
Global Const $GDIP_PROPERTYTAGTHUMBNAILARTIST = 0x5034  ; Person who created the image
Global Const $GDIP_PROPERTYTAGTHUMBNAILWHITEPOINT = 0x5035  ; White point chromaticity
Global Const $GDIP_PROPERTYTAGTHUMBNAILPRIMARYCHROMATICITIES = 0x5036  ; Chromaticities of primaries
Global Const $GDIP_PROPERTYTAGTHUMBNAILYCBCRCOEFFICIENTS = 0x5037 ; Color space transformation coefficients
Global Const $GDIP_PROPERTYTAGTHUMBNAILYCBCRSUBSAMPLING = 0x5038  ; Subsampling ratio of Y to C
Global Const $GDIP_PROPERTYTAGTHUMBNAILYCBCRPOSITIONING = 0x5039  ; Y and C position
Global Const $GDIP_PROPERTYTAGTHUMBNAILREFBLACKWHITE = 0x503A  ; Pair of black and white reference values
Global Const $GDIP_PROPERTYTAGTHUMBNAILCOPYRIGHT = 0x503B  ; CopyRight holder
Global Const $GDIP_PROPERTYTAGLUMINANCETABLE = 0x5090
Global Const $GDIP_PROPERTYTAGCHROMINANCETABLE = 0x5091
Global Const $GDIP_PROPERTYTAGFRAMEDELAY = 0x5100
Global Const $GDIP_PROPERTYTAGLOOPCOUNT = 0x5101
Global Const $GDIP_PROPERTYTAGGLOBALPALETTE = 0x5102
Global Const $GDIP_PROPERTYTAGINDEXBACKGROUND = 0x5103
Global Const $GDIP_PROPERTYTAGINDEXTRANSPARENT = 0x5104
Global Const $GDIP_PROPERTYTAGPIXELUNIT = 0x5110  ; Unit specifier for pixel/unit
Global Const $GDIP_PROPERTYTAGPIXELPERUNITX = 0x5111  ; Pixels per unit in X
Global Const $GDIP_PROPERTYTAGPIXELPERUNITY = 0x5112  ; Pixels per unit in Y
Global Const $GDIP_PROPERTYTAGPALETTEHISTOGRAM = 0x5113  ; Palette histogram

; EXIF specific tag constants
Global Const $GDIP_PROPERTYTAGEXIFEXPOSURETIME = 0x829A
Global Const $GDIP_PROPERTYTAGEXIFFNUMBER = 0x829D
Global Const $GDIP_PROPERTYTAGEXIFEXPOSUREPROG = 0x8822
Global Const $GDIP_PROPERTYTAGEXIFSPECTRALSENSE = 0x8824
Global Const $GDIP_PROPERTYTAGEXIFISOSPEED = 0x8827
Global Const $GDIP_PROPERTYTAGEXIFOECF = 0x8828
Global Const $GDIP_PROPERTYTAGEXIFVER = 0x9000
Global Const $GDIP_PROPERTYTAGEXIFDTORIG = 0x9003 ; Date & time of original
Global Const $GDIP_PROPERTYTAGEXIFDTDIGITIZED = 0x9004 ; Date & time of digital data generation
Global Const $GDIP_PROPERTYTAGEXIFCOMPCONFIG = 0x9101
Global Const $GDIP_PROPERTYTAGEXIFCOMPBPP = 0x9102
Global Const $GDIP_PROPERTYTAGEXIFSHUTTERSPEED = 0x9201
Global Const $GDIP_PROPERTYTAGEXIFAPERTURE = 0x9202
Global Const $GDIP_PROPERTYTAGEXIFBRIGHTNESS = 0x9203
Global Const $GDIP_PROPERTYTAGEXIFEXPOSUREBIAS = 0x9204
Global Const $GDIP_PROPERTYTAGEXIFMAXAPERTURE = 0x9205
Global Const $GDIP_PROPERTYTAGEXIFSUBJECTDIST = 0x9206
Global Const $GDIP_PROPERTYTAGEXIFMETERINGMODE = 0x9207
Global Const $GDIP_PROPERTYTAGEXIFLIGHTSOURCE = 0x9208
Global Const $GDIP_PROPERTYTAGEXIFFLASH = 0x9209
Global Const $GDIP_PROPERTYTAGEXIFFOCALLENGTH = 0x920A
Global Const $GDIP_PROPERTYTAGEXIFSUBJECTAREA = 0x9214  ; exif 2.2 Subject Area
Global Const $GDIP_PROPERTYTAGEXIFMAKERNOTE = 0x927C
Global Const $GDIP_PROPERTYTAGEXIFUSERCOMMENT = 0x9286
Global Const $GDIP_PROPERTYTAGEXIFDTSUBSEC = 0x9290  ; Date & Time subseconds
Global Const $GDIP_PROPERTYTAGEXIFDTORIGSS = 0x9291  ; Date & Time original subseconds
Global Const $GDIP_PROPERTYTAGEXIFDTDIGSS = 0x9292  ; Date & TIme digitized subseconds
Global Const $GDIP_PROPERTYTAGEXIFFPXVER = 0xA000
Global Const $GDIP_PROPERTYTAGEXIFCOLORSPACE = 0xA001
Global Const $GDIP_PROPERTYTAGEXIFPIXXDIM = 0xA002
Global Const $GDIP_PROPERTYTAGEXIFPIXYDIM = 0xA003
Global Const $GDIP_PROPERTYTAGEXIFRELATEDWAV = 0xA004  ; related sound file
Global Const $GDIP_PROPERTYTAGEXIFINTEROP = 0xA005
Global Const $GDIP_PROPERTYTAGEXIFFLASHENERGY = 0xA20B
Global Const $GDIP_PROPERTYTAGEXIFSPATIALFR = 0xA20C  ; Spatial Frequency Response
Global Const $GDIP_PROPERTYTAGEXIFFOCALXRES = 0xA20E  ; Focal Plane X Resolution
Global Const $GDIP_PROPERTYTAGEXIFFOCALYRES = 0xA20F  ; Focal Plane Y Resolution
Global Const $GDIP_PROPERTYTAGEXIFFOCALRESUNIT = 0xA210  ; Focal Plane Resolution Unit
Global Const $GDIP_PROPERTYTAGEXIFSUBJECTLOC = 0xA214
Global Const $GDIP_PROPERTYTAGEXIFEXPOSUREINDEX = 0xA215
Global Const $GDIP_PROPERTYTAGEXIFSENSINGMETHOD = 0xA217
Global Const $GDIP_PROPERTYTAGEXIFFILESOURCE = 0xA300
Global Const $GDIP_PROPERTYTAGEXIFSCENETYPE = 0xA301
Global Const $GDIP_PROPERTYTAGEXIFCFAPATTERN = 0xA302
Global Const $GDIP_PROPERTYTAGEXIFCUSTOMRENDERED = 0xA401
Global Const $GDIP_PROPERTYTAGEXIFEXPOSUREMODE = 0xA402
Global Const $GDIP_PROPERTYTAGEXIFWHITEBALANCE = 0xA403
Global Const $GDIP_PROPERTYTAGEXIFDIGITALZOOMRATIO = 0xA404
Global Const $GDIP_PROPERTYTAGEXIFFOCALLENGTHIN35MMFILM = 0xA405
Global Const $GDIP_PROPERTYTAGEXIFSCENECAPTURETYPE = 0xA406
Global Const $GDIP_PROPERTYTAGEXIFGAINCONTROL = 0xA407
Global Const $GDIP_PROPERTYTAGEXIFCONTRAST = 0xA408
Global Const $GDIP_PROPERTYTAGEXIFSATURATION = 0xA409
Global Const $GDIP_PROPERTYTAGEXIFSHARPNESS = 0xA40A
Global Const $GDIP_PROPERTYTAGEXIFDEVICESETTINGDESC = 0xA40B
Global Const $GDIP_PROPERTYTAGEXIFSUBJECTDISTANCERANGE = 0xA40C
Global Const $GDIP_PROPERTYTAGEXIFUNIQUEIMAGEID = 0xA420

; EXIF 2.2 properties constants
Global Const $GDIP_PROPERTYTAGGPSVER = 0x0000
Global Const $GDIP_PROPERTYTAGGPSLATITUDEREF = 0x0001
Global Const $GDIP_PROPERTYTAGGPSLATITUDE = 0x0002
Global Const $GDIP_PROPERTYTAGGPSLONGITUDEREF = 0x0003
Global Const $GDIP_PROPERTYTAGGPSLONGITUDE = 0x0004
Global Const $GDIP_PROPERTYTAGGPSALTITUDEREF = 0x0005
Global Const $GDIP_PROPERTYTAGGPSALTITUDE = 0x0006
Global Const $GDIP_PROPERTYTAGGPSGPSTIME = 0x0007
Global Const $GDIP_PROPERTYTAGGPSGPSSATELLITES = 0x0008
Global Const $GDIP_PROPERTYTAGGPSGPSSTATUS = 0x0009
Global Const $GDIP_PROPERTYTAGGPSGPSMEASUREMODE = 0x00A
Global Const $GDIP_PROPERTYTAGGPSGPSDOP = 0x000B  ; Measurement precision
Global Const $GDIP_PROPERTYTAGGPSSPEEDREF = 0x000C
Global Const $GDIP_PROPERTYTAGGPSSPEED = 0x000D
Global Const $GDIP_PROPERTYTAGGPSTRACKREF = 0x000E
Global Const $GDIP_PROPERTYTAGGPSTRACK = 0x000F
Global Const $GDIP_PROPERTYTAGGPSIMGDIRREF = 0x0010
Global Const $GDIP_PROPERTYTAGGPSIMGDIR = 0x0011
Global Const $GDIP_PROPERTYTAGGPSMAPDATUM = 0x0012
Global Const $GDIP_PROPERTYTAGGPSDESTLATREF = 0x0013
Global Const $GDIP_PROPERTYTAGGPSDESTLAT = 0x0014
Global Const $GDIP_PROPERTYTAGGPSDESTLONGREF = 0x0015
Global Const $GDIP_PROPERTYTAGGPSDESTLONG = 0x0016
Global Const $GDIP_PROPERTYTAGGPSDESTBEARREF = 0x0017
Global Const $GDIP_PROPERTYTAGGPSDESTBEAR = 0x0018
Global Const $GDIP_PROPERTYTAGGPSDESTDISTREF = 0x0019
Global Const $GDIP_PROPERTYTAGGPSDESTDIST = 0x001A
Global Const $GDIP_PROPERTYTAGGPSPROCESSINGMETHOD = 0x001B
Global Const $GDIP_PROPERTYTAGGPSAREAINFORMATION = 0x001C
Global Const $GDIP_PROPERTYTAGGPSDATE = 0x001D
Global Const $GDIP_PROPERTYTAGGPSDIFFERENTIAL = 0x001E

Global Const $META_SETBKCOLOR = 0x0201
Global Const $META_SETBKMODE = 0x0102
Global Const $META_SETMAPMODE = 0x0103
Global Const $META_SETROP2 = 0x0104
Global Const $META_SETRELABS = 0x0105
Global Const $META_SETPOLYFILLMODE = 0x0106
Global Const $META_SETSTRETCHBLTMODE = 0x0107
Global Const $META_SETTEXTCHAREXTRA = 0x0108
Global Const $META_SETTEXTCOLOR = 0x0209
Global Const $META_SETTEXTJUSTIFICATION = 0x020A
Global Const $META_SETWINDOWORG = 0x020B
Global Const $META_SETWINDOWEXT = 0x020C
Global Const $META_SETVIEWPORTORG = 0x020D
Global Const $META_SETVIEWPORTEXT = 0x020E
Global Const $META_OFFSETWINDOWORG = 0x020F
Global Const $META_SCALEWINDOWEXT = 0x0410
Global Const $META_OFFSETVIEWPORTORG = 0x0211
Global Const $META_SCALEVIEWPORTEXT = 0x0412
Global Const $META_LINETO = 0x0213
Global Const $META_MOVETO = 0x0214
Global Const $META_EXCLUDECLIPRECT = 0x0415
Global Const $META_INTERSECTCLIPRECT = 0x0416
Global Const $META_ARC = 0x0817
Global Const $META_ELLIPSE = 0x0418
Global Const $META_FLOODFILL = 0x0419
Global Const $META_PIE = 0x081A
Global Const $META_RECTANGLE = 0x041B
Global Const $META_ROUNDRECT = 0x061C
Global Const $META_PATBLT = 0x061D
Global Const $META_SAVEDC = 0x001E
Global Const $META_SETPIXEL = 0x041F
Global Const $META_OFFSETCLIPRGN = 0x0220
Global Const $META_TEXTOUT = 0x0521
Global Const $META_BITBLT = 0x0922
Global Const $META_STRETCHBLT = 0x0B23
Global Const $META_POLYGON = 0x0324
Global Const $META_POLYLINE = 0x0325
Global Const $META_ESCAPE = 0x0626
Global Const $META_RESTOREDC = 0x0127
Global Const $META_FILLREGION = 0x0228
Global Const $META_FRAMEREGION = 0x0429
Global Const $META_INVERTREGION = 0x012A
Global Const $META_PAINTREGION = 0x012B
Global Const $META_SELECTCLIPREGION = 0x012C
Global Const $META_SELECTOBJECT = 0x012D
Global Const $META_SETTEXTALIGN = 0x012E
Global Const $META_CHORD = 0x0830
Global Const $META_SETMAPPERFLAGS = 0x0231
Global Const $META_EXTTEXTOUT = 0x0a32
Global Const $META_SETDIBTODEV = 0x0d33
Global Const $META_SELECTPALETTE = 0x0234
Global Const $META_REALIZEPALETTE = 0x0035
Global Const $META_ANIMATEPALETTE = 0x0436
Global Const $META_SETPALENTRIES = 0x0037
Global Const $META_POLYPOLYGON = 0x0538
Global Const $META_RESIZEPALETTE = 0x0139
Global Const $META_DIBBITBLT = 0x0940
Global Const $META_DIBSTRETCHBLT = 0x0b41
Global Const $META_DIBCREATEPATTERNBRUSH = 0x0142
Global Const $META_STRETCHDIB = 0x0f43
Global Const $META_EXTFLOODFILL = 0x0548
Global Const $META_SETLAYOUT = 0x0149
Global Const $META_DELETEOBJECT = 0x01f0
Global Const $META_CREATEPALETTE = 0x00f7
Global Const $META_CREATEPATTERNBRUSH = 0x01F9
Global Const $META_CREATEPENINDIRECT = 0x02FA
Global Const $META_CREATEFONTINDIRECT = 0x02FB
Global Const $META_CREATEBRUSHINDIRECT = 0x02FC
Global Const $META_CREATEREGION = 0x06FF

Global Const $EMR_HEADER = 1
Global Const $EMR_POLYBEZIER = 2
Global Const $EMR_POLYGON = 3
Global Const $EMR_POLYLINE = 4
Global Const $EMR_POLYBEZIERTO = 5
Global Const $EMR_POLYLINETO = 6
Global Const $EMR_POLYPOLYLINE = 7
Global Const $EMR_POLYPOLYGON = 8
Global Const $EMR_SETWINDOWEXTEX = 9
Global Const $EMR_SETWINDOWORGEX = 10
Global Const $EMR_SETVIEWPORTEXTEX = 11
Global Const $EMR_SETVIEWPORTORGEX = 12
Global Const $EMR_SETBRUSHORGEX = 13
Global Const $EMR_EOF = 14
Global Const $EMR_SETPIXELV = 15
Global Const $EMR_SETMAPPERFLAGS = 16
Global Const $EMR_SETMAPMODE = 17
Global Const $EMR_SETBKMODE = 18
Global Const $EMR_SETPOLYFILLMODE = 19
Global Const $EMR_SETROP2 = 20
Global Const $EMR_SETSTRETCHBLTMODE = 21
Global Const $EMR_SETTEXTALIGN = 22
Global Const $EMR_SETCOLORADJUSTMENT = 23
Global Const $EMR_SETTEXTCOLOR = 24
Global Const $EMR_SETBKCOLOR = 25
Global Const $EMR_OFFSETCLIPRGN = 26
Global Const $EMR_MOVETOEX = 27
Global Const $EMR_SETMETARGN = 28
Global Const $EMR_EXCLUDECLIPRECT = 29
Global Const $EMR_INTERSECTCLIPRECT = 30
Global Const $EMR_SCALEVIEWPORTEXTEX = 31
Global Const $EMR_SCALEWINDOWEXTEX = 32
Global Const $EMR_SAVEDC = 33
Global Const $EMR_RESTOREDC = 34
Global Const $EMR_SETWORLDTRANSFORM = 35
Global Const $EMR_MODIFYWORLDTRANSFORM = 36
Global Const $EMR_SELECTOBJECT = 37
Global Const $EMR_CREATEPEN = 38
Global Const $EMR_CREATEBRUSHINDIRECT = 39
Global Const $EMR_DELETEOBJECT = 40
Global Const $EMR_ANGLEARC = 41
Global Const $EMR_ELLIPSE = 42
Global Const $EMR_RECTANGLE = 43
Global Const $EMR_ROUNDRECT = 44
Global Const $EMR_ARC = 45
Global Const $EMR_CHORD = 46
Global Const $EMR_PIE = 47
Global Const $EMR_SELECTPALETTE = 48
Global Const $EMR_CREATEPALETTE = 49
Global Const $EMR_SETPALETTEENTRIES = 50
Global Const $EMR_RESIZEPALETTE = 51
Global Const $EMR_REALIZEPALETTE = 52
Global Const $EMR_EXTFLOODFILL = 53
Global Const $EMR_LINETO = 54
Global Const $EMR_ARCTO = 55
Global Const $EMR_POLYDRAW = 56
Global Const $EMR_SETARCDIRECTION = 57
Global Const $EMR_SETMITERLIMIT = 58
Global Const $EMR_BEGINPATH = 59
Global Const $EMR_ENDPATH = 60
Global Const $EMR_CLOSEFIGURE = 61
Global Const $EMR_FILLPATH = 62
Global Const $EMR_STROKEANDFILLPATH = 63
Global Const $EMR_STROKEPATH = 64
Global Const $EMR_FLATTENPATH = 65
Global Const $EMR_WIDENPATH = 66
Global Const $EMR_SELECTCLIPPATH = 67
Global Const $EMR_ABORTPATH = 68
Global Const $EMR_GDICOMMENT = 70
Global Const $EMR_FILLRGN = 71
Global Const $EMR_FRAMERGN = 72
Global Const $EMR_INVERTRGN = 73
Global Const $EMR_PAINTRGN = 74
Global Const $EMR_EXTSELECTCLIPRGN = 75
Global Const $EMR_BITBLT = 76
Global Const $EMR_STRETCHBLT = 77
Global Const $EMR_MASKBLT = 78
Global Const $EMR_PLGBLT = 79
Global Const $EMR_SETDIBITSTODEVICE = 80
Global Const $EMR_STRETCHDIBITS = 81
Global Const $EMR_EXTCREATEFONTINDIRECTW = 82
Global Const $EMR_EXTTEXTOUTA = 83
Global Const $EMR_EXTTEXTOUTW = 84
Global Const $EMR_POLYBEZIER16 = 85
Global Const $EMR_POLYGON16 = 86
Global Const $EMR_POLYLINE16 = 87
Global Const $EMR_POLYBEZIERTO16 = 88
Global Const $EMR_POLYLINETO16 = 89
Global Const $EMR_POLYPOLYLINE16 = 90
Global Const $EMR_POLYPOLYGON16 = 91
Global Const $EMR_POLYDRAW16 = 92
Global Const $EMR_CREATEMONOBRUSH = 93
Global Const $EMR_CREATEDIBPATTERNBRUSHPT = 94
Global Const $EMR_EXTCREATEPEN = 95
Global Const $EMR_POLYTEXTOUTA = 96
Global Const $EMR_POLYTEXTOUTW = 97
Global Const $EMR_SETICMMODE = 98
Global Const $EMR_CREATECOLORSPACE = 99
Global Const $EMR_SETCOLORSPACE = 100
Global Const $EMR_DELETECOLORSPACE = 101
Global Const $EMR_GLSRECORD = 102
Global Const $EMR_GLSBOUNDEDRECORD = 103
Global Const $EMR_PIXELFORMAT = 104
Global Const $EMR_RESERVED_105 = 105
Global Const $EMR_RESERVED_106 = 106
Global Const $EMR_RESERVED_107 = 107
Global Const $EMR_RESERVED_108 = 108
Global Const $EMR_RESERVED_109 = 109
Global Const $EMR_RESERVED_110 = 110
Global Const $EMR_COLORCORRECTPALETTE = 111
Global Const $EMR_SETICMPROFILEA = 112
Global Const $EMR_SETICMPROFILEW = 113
Global Const $EMR_ALPHABLEND = 114
Global Const $EMR_SETLAYOUT = 115
Global Const $EMR_TRANSPARENTBLT = 116
Global Const $EMR_RESERVED_117 = 117
Global Const $EMR_GRADIENTFILL = 118
Global Const $EMR_RESERVED_119 = 119
Global Const $EMR_RESERVED_120 = 120
Global Const $EMR_COLORMATCHTOTARGETW = 121
Global Const $EMR_CREATECOLORSPACEW = 122
Global Const $EMR_MIN = 1
Global Const $EMR_MAX = 122

Global Const $GDIP_EMFPLUS_RECORD_BASE = 0x00004000
Global Const $GDIP_WMF_RECORD_BASE = 0x00010000

; Constants used in the metafile enumeration callback
Global Const $GDIP_WMFRECORDTYPESETBKCOLOR = 0x00010201
Global Const $GDIP_WMFRECORDTYPESETBKMODE = 0x00010102
Global Const $GDIP_WMFRECORDTYPESETMAPMODE = 0x00010103
Global Const $GDIP_WMFRECORDTYPESETROP2 = 0x00010104
Global Const $GDIP_WMFRECORDTYPESETRELABS = 0x00010105
Global Const $GDIP_WMFRECORDTYPESETPOLYFILLMODE = 0x00010106
Global Const $GDIP_WMFRECORDTYPESETSTRETCHBLTMODE = 0x00010107
Global Const $GDIP_WMFRECORDTYPESETTEXTCHAREXTRA = 0x00010108
Global Const $GDIP_WMFRECORDTYPESETTEXTCOLOR = 0x00010209
Global Const $GDIP_WMFRECORDTYPESETTEXTJUSTIFICATION = 0x0001020A
Global Const $GDIP_WMFRECORDTYPESETWINDOWORG = 0x0001020B
Global Const $GDIP_WMFRECORDTYPESETWINDOWEXT = 0x0001020C
Global Const $GDIP_WMFRECORDTYPESETVIEWPORTORG = 0x0001020D
Global Const $GDIP_WMFRECORDTYPESETVIEWPORTEXT = 0x0001020E
Global Const $GDIP_WMFRECORDTYPEOFFSETWINDOWORG = 0x0001020F
Global Const $GDIP_WMFRECORDTYPESCALEWINDOWEXT = 0x00010410
Global Const $GDIP_WMFRECORDTYPEOFFSETVIEWPORTORG = 0x00010211
Global Const $GDIP_WMFRECORDTYPESCALEVIEWPORTEXT = 0x00010412
Global Const $GDIP_WMFRECORDTYPELINETO = 0x00010213
Global Const $GDIP_WMFRECORDTYPEMOVETO = 0x00010214
Global Const $GDIP_WMFRECORDTYPEEXCLUDECLIPRECT = 0x00010415
Global Const $GDIP_WMFRECORDTYPEINTERSECTCLIPRECT = 0x00010416
Global Const $GDIP_WMFRECORDTYPEARC = 0x00010817
Global Const $GDIP_WMFRECORDTYPEELLIPSE = 0x00010418
Global Const $GDIP_WMFRECORDTYPEFLOODFILL = 0x00010419
Global Const $GDIP_WMFRECORDTYPEPIE = 0x0001081A
Global Const $GDIP_WMFRECORDTYPERECTANGLE = 0x0001041B
Global Const $GDIP_WMFRECORDTYPEROUNDRECT = 0x0001061C
Global Const $GDIP_WMFRECORDTYPEPATBLT = 0x0001061D
Global Const $GDIP_WMFRECORDTYPESAVEDC = 0x0001001E
Global Const $GDIP_WMFRECORDTYPESETPIXEL = 0x0001041F
Global Const $GDIP_WMFRECORDTYPEOFFSETCLIPRGN = 0x00010220
Global Const $GDIP_WMFRECORDTYPETEXTOUT = 0x00010521
Global Const $GDIP_WMFRECORDTYPEBITBLT = 0x00010922
Global Const $GDIP_WMFRECORDTYPESTRETCHBLT = 0x00010B23
Global Const $GDIP_WMFRECORDTYPEPOLYGON = 0x00010324
Global Const $GDIP_WMFRECORDTYPEPOLYLINE = 0x00010325
Global Const $GDIP_WMFRECORDTYPEESCAPE = 0x00010626
Global Const $GDIP_WMFRECORDTYPERESTOREDC = 0x00010127
Global Const $GDIP_WMFRECORDTYPEFILLREGION = 0x00010228
Global Const $GDIP_WMFRECORDTYPEFRAMEREGION = 0x00010429
Global Const $GDIP_WMFRECORDTYPEINVERTREGION = 0x0001012A
Global Const $GDIP_WMFRECORDTYPEPAINTREGION = 0x0001012B
Global Const $GDIP_WMFRECORDTYPESELECTCLIPREGION = 0x0001012C
Global Const $GDIP_WMFRECORDTYPESELECTOBJECT = 0x0001012D
Global Const $GDIP_WMFRECORDTYPESETTEXTALIGN = 0x0001012E
Global Const $GDIP_WMFRECORDTYPEDRAWTEXT = 0x0001062F
Global Const $GDIP_WMFRECORDTYPECHORD = 0x00010830
Global Const $GDIP_WMFRECORDTYPESETMAPPERFLAGS = 0x00010231
Global Const $GDIP_WMFRECORDTYPEEXTTEXTOUT = 0x00010A32
Global Const $GDIP_WMFRECORDTYPESETDIBTODEV = 0x00010D33
Global Const $GDIP_WMFRECORDTYPESELECTPALETTE = 0x00010234
Global Const $GDIP_WMFRECORDTYPEREALIZEPALETTE = 0x00010035
Global Const $GDIP_WMFRECORDTYPEANIMATEPALETTE = 0x00010436
Global Const $GDIP_WMFRECORDTYPESETPALENTRIES = 0x00010037
Global Const $GDIP_WMFRECORDTYPEPOLYPOLYGON = 0x00010538
Global Const $GDIP_WMFRECORDTYPERESIZEPALETTE = 0x00010139
Global Const $GDIP_WMFRECORDTYPEDIBBITBLT = 0x00010940
Global Const $GDIP_WMFRECORDTYPEDIBSTRETCHBLT = 0x00010B41
Global Const $GDIP_WMFRECORDTYPEDIBCREATEPATTERNBRUSH = 0x00010142
Global Const $GDIP_WMFRECORDTYPESTRETCHDIB = 0x00010F43
Global Const $GDIP_WMFRECORDTYPEEXTFLOODFILL = 0x00010548
Global Const $GDIP_WMFRECORDTYPESETLAYOUT = 0x00010149
Global Const $GDIP_WMFRECORDTYPERESETDC = 0x0001014C
Global Const $GDIP_WMFRECORDTYPESTARTDOC = 0x0001014D
Global Const $GDIP_WMFRECORDTYPESTARTPAGE = 0x0001004F
Global Const $GDIP_WMFRECORDTYPEENDPAGE = 0x00010050
Global Const $GDIP_WMFRECORDTYPEABORTDOC = 0x00010052
Global Const $GDIP_WMFRECORDTYPEENDDOC = 0x0001005E
Global Const $GDIP_WMFRECORDTYPEDELETEOBJECT = 0x000101F0
Global Const $GDIP_WMFRECORDTYPECREATEPALETTE = 0x000100F7
Global Const $GDIP_WMFRECORDTYPECREATEBRUSH = 0x000100F8
Global Const $GDIP_WMFRECORDTYPECREATEPATTERNBRUSH = 0x000101F9
Global Const $GDIP_WMFRECORDTYPECREATEPENINDIRECT = 0x000102FA
Global Const $GDIP_WMFRECORDTYPECREATEFONTINDIRECT = 0x000102FB
Global Const $GDIP_WMFRECORDTYPECREATEBRUSHINDIRECT = 0x000102FC
Global Const $GDIP_WMFRECORDTYPECREATEBITMAPINDIRECT = 0x000102FD
Global Const $GDIP_WMFRECORDTYPECREATEBITMAP = 0x000106FE
Global Const $GDIP_WMFRECORDTYPECREATEREGION = 0x000106FF
Global Const $GDIP_EMFRECORDTYPEHEADER = $EMR_HEADER
Global Const $GDIP_EMFRECORDTYPEPOLYBEZIER = $EMR_POLYBEZIER
Global Const $GDIP_EMFRECORDTYPEPOLYGON = $EMR_POLYGON
Global Const $GDIP_EMFRECORDTYPEPOLYLINE = $EMR_POLYLINE
Global Const $GDIP_EMFRECORDTYPEPOLYBEZIERTO = $EMR_POLYBEZIERTO
Global Const $GDIP_EMFRECORDTYPEPOLYLINETO = $EMR_POLYLINETO
Global Const $GDIP_EMFRECORDTYPEPOLYPOLYLINE = $EMR_POLYPOLYLINE
Global Const $GDIP_EMFRECORDTYPEPOLYPOLYGON = $EMR_POLYPOLYGON
Global Const $GDIP_EMFRECORDTYPESETWINDOWEXTEX = $EMR_SETWINDOWEXTEX
Global Const $GDIP_EMFRECORDTYPESETWINDOWORGEX = $EMR_SETWINDOWORGEX
Global Const $GDIP_EMFRECORDTYPESETVIEWPORTEXTEX = $EMR_SETVIEWPORTEXTEX
Global Const $GDIP_EMFRECORDTYPESETVIEWPORTORGEX = $EMR_SETVIEWPORTORGEX
Global Const $GDIP_EMFRECORDTYPESETBRUSHORGEX = $EMR_SETBRUSHORGEX
Global Const $GDIP_EMFRECORDTYPEEOF = $EMR_EOF
Global Const $GDIP_EMFRECORDTYPESETPIXELV = $EMR_SETPIXELV
Global Const $GDIP_EMFRECORDTYPESETMAPPERFLAGS = $EMR_SETMAPPERFLAGS
Global Const $GDIP_EMFRECORDTYPESETMAPMODE = $EMR_SETMAPMODE
Global Const $GDIP_EMFRECORDTYPESETBKMODE = $EMR_SETBKMODE
Global Const $GDIP_EMFRECORDTYPESETPOLYFILLMODE = $EMR_SETPOLYFILLMODE
Global Const $GDIP_EMFRECORDTYPESETROP2 = $EMR_SETROP2
Global Const $GDIP_EMFRECORDTYPESETSTRETCHBLTMODE = $EMR_SETSTRETCHBLTMODE
Global Const $GDIP_EMFRECORDTYPESETTEXTALIGN = $EMR_SETTEXTALIGN
Global Const $GDIP_EMFRECORDTYPESETCOLORADJUSTMENT = $EMR_SETCOLORADJUSTMENT
Global Const $GDIP_EMFRECORDTYPESETTEXTCOLOR = $EMR_SETTEXTCOLOR
Global Const $GDIP_EMFRECORDTYPESETBKCOLOR = $EMR_SETBKCOLOR
Global Const $GDIP_EMFRECORDTYPEOFFSETCLIPRGN = $EMR_OFFSETCLIPRGN
Global Const $GDIP_EMFRECORDTYPEMOVETOEX = $EMR_MOVETOEX
Global Const $GDIP_EMFRECORDTYPESETMETARGN = $EMR_SETMETARGN
Global Const $GDIP_EMFRECORDTYPEEXCLUDECLIPRECT = $EMR_EXCLUDECLIPRECT
Global Const $GDIP_EMFRECORDTYPEINTERSECTCLIPRECT = $EMR_INTERSECTCLIPRECT
Global Const $GDIP_EMFRECORDTYPESCALEVIEWPORTEXTEX = $EMR_SCALEVIEWPORTEXTEX
Global Const $GDIP_EMFRECORDTYPESCALEWINDOWEXTEX = $EMR_SCALEWINDOWEXTEX
Global Const $GDIP_EMFRECORDTYPESAVEDC = $EMR_SAVEDC
Global Const $GDIP_EMFRECORDTYPERESTOREDC = $EMR_RESTOREDC
Global Const $GDIP_EMFRECORDTYPESETWORLDTRANSFORM = $EMR_SETWORLDTRANSFORM
Global Const $GDIP_EMFRECORDTYPEMODIFYWORLDTRANSFORM = $EMR_MODIFYWORLDTRANSFORM
Global Const $GDIP_EMFRECORDTYPESELECTOBJECT = $EMR_SELECTOBJECT
Global Const $GDIP_EMFRECORDTYPECREATEPEN = $EMR_CREATEPEN
Global Const $GDIP_EMFRECORDTYPECREATEBRUSHINDIRECT = $EMR_CREATEBRUSHINDIRECT
Global Const $GDIP_EMFRECORDTYPEDELETEOBJECT = $EMR_DELETEOBJECT
Global Const $GDIP_EMFRECORDTYPEANGLEARC = $EMR_ANGLEARC
Global Const $GDIP_EMFRECORDTYPEELLIPSE = $EMR_ELLIPSE
Global Const $GDIP_EMFRECORDTYPERECTANGLE = $EMR_RECTANGLE
Global Const $GDIP_EMFRECORDTYPEROUNDRECT = $EMR_ROUNDRECT
Global Const $GDIP_EMFRECORDTYPEARC = $EMR_ARC
Global Const $GDIP_EMFRECORDTYPECHORD = $EMR_CHORD
Global Const $GDIP_EMFRECORDTYPEPIE = $EMR_PIE
Global Const $GDIP_EMFRECORDTYPESELECTPALETTE = $EMR_SELECTPALETTE
Global Const $GDIP_EMFRECORDTYPECREATEPALETTE = $EMR_CREATEPALETTE
Global Const $GDIP_EMFRECORDTYPESETPALETTEENTRIES = $EMR_SETPALETTEENTRIES
Global Const $GDIP_EMFRECORDTYPERESIZEPALETTE = $EMR_RESIZEPALETTE
Global Const $GDIP_EMFRECORDTYPEREALIZEPALETTE = $EMR_REALIZEPALETTE
Global Const $GDIP_EMFRECORDTYPEEXTFLOODFILL = $EMR_EXTFLOODFILL
Global Const $GDIP_EMFRECORDTYPELINETO = $EMR_LINETO
Global Const $GDIP_EMFRECORDTYPEARCTO = $EMR_ARCTO
Global Const $GDIP_EMFRECORDTYPEPOLYDRAW = $EMR_POLYDRAW
Global Const $GDIP_EMFRECORDTYPESETARCDIRECTION = $EMR_SETARCDIRECTION
Global Const $GDIP_EMFRECORDTYPESETMITERLIMIT = $EMR_SETMITERLIMIT
Global Const $GDIP_EMFRECORDTYPEBEGINPATH = $EMR_BEGINPATH
Global Const $GDIP_EMFRECORDTYPEENDPATH = $EMR_ENDPATH
Global Const $GDIP_EMFRECORDTYPECLOSEFIGURE = $EMR_CLOSEFIGURE
Global Const $GDIP_EMFRECORDTYPEFILLPATH = $EMR_FILLPATH
Global Const $GDIP_EMFRECORDTYPESTROKEANDFILLPATH = $EMR_STROKEANDFILLPATH
Global Const $GDIP_EMFRECORDTYPESTROKEPATH = $EMR_STROKEPATH
Global Const $GDIP_EMFRECORDTYPEFLATTENPATH = $EMR_FLATTENPATH
Global Const $GDIP_EMFRECORDTYPEWIDENPATH = $EMR_WIDENPATH
Global Const $GDIP_EMFRECORDTYPESELECTCLIPPATH = $EMR_SELECTCLIPPATH
Global Const $GDIP_EMFRECORDTYPEABORTPATH = $EMR_ABORTPATH
Global Const $GDIP_EMFRECORDTYPERESERVED_069 = 69
Global Const $GDIP_EMFRECORDTYPEGDICOMMENT = $EMR_GDICOMMENT
Global Const $GDIP_EMFRECORDTYPEFILLRGN = $EMR_FILLRGN
Global Const $GDIP_EMFRECORDTYPEFRAMERGN = $EMR_FRAMERGN
Global Const $GDIP_EMFRECORDTYPEINVERTRGN = $EMR_INVERTRGN
Global Const $GDIP_EMFRECORDTYPEPAINTRGN = $EMR_PAINTRGN
Global Const $GDIP_EMFRECORDTYPEEXTSELECTCLIPRGN = $EMR_EXTSELECTCLIPRGN
Global Const $GDIP_EMFRECORDTYPEBITBLT = $EMR_BITBLT
Global Const $GDIP_EMFRECORDTYPESTRETCHBLT = $EMR_STRETCHBLT
Global Const $GDIP_EMFRECORDTYPEMASKBLT = $EMR_MASKBLT
Global Const $GDIP_EMFRECORDTYPEPLGBLT = $EMR_PLGBLT
Global Const $GDIP_EMFRECORDTYPESETDIBITSTODEVICE = $EMR_SETDIBITSTODEVICE
Global Const $GDIP_EMFRECORDTYPESTRETCHDIBITS = $EMR_STRETCHDIBITS
Global Const $GDIP_EMFRECORDTYPEEXTCREATEFONTINDIRECT = $EMR_EXTCREATEFONTINDIRECTW
Global Const $GDIP_EMFRECORDTYPEEXTTEXTOUTA = $EMR_EXTTEXTOUTA
Global Const $GDIP_EMFRECORDTYPEEXTTEXTOUTW = $EMR_EXTTEXTOUTW
Global Const $GDIP_EMFRECORDTYPEPOLYBEZIER16 = $EMR_POLYBEZIER16
Global Const $GDIP_EMFRECORDTYPEPOLYGON16 = $EMR_POLYGON16
Global Const $GDIP_EMFRECORDTYPEPOLYLINE16 = $EMR_POLYLINE16
Global Const $GDIP_EMFRECORDTYPEPOLYBEZIERTO16 = $EMR_POLYBEZIERTO16
Global Const $GDIP_EMFRECORDTYPEPOLYLINETO16 = $EMR_POLYLINETO16
Global Const $GDIP_EMFRECORDTYPEPOLYPOLYLINE16 = $EMR_POLYPOLYLINE16
Global Const $GDIP_EMFRECORDTYPEPOLYPOLYGON16 = $EMR_POLYPOLYGON16
Global Const $GDIP_EMFRECORDTYPEPOLYDRAW16 = $EMR_POLYDRAW16
Global Const $GDIP_EMFRECORDTYPECREATEMONOBRUSH = $EMR_CREATEMONOBRUSH
Global Const $GDIP_EMFRECORDTYPECREATEDIBPATTERNBRUSHPT = $EMR_CREATEDIBPATTERNBRUSHPT
Global Const $GDIP_EMFRECORDTYPEEXTCREATEPEN = $EMR_EXTCREATEPEN
Global Const $GDIP_EMFRECORDTYPEPOLYTEXTOUTA = $EMR_POLYTEXTOUTA
Global Const $GDIP_EMFRECORDTYPEPOLYTEXTOUTW = $EMR_POLYTEXTOUTW
Global Const $GDIP_EMFRECORDTYPESETICMMODE = 98
Global Const $GDIP_EMFRECORDTYPECREATECOLORSPACE = 99
Global Const $GDIP_EMFRECORDTYPESETCOLORSPACE = 100
Global Const $GDIP_EMFRECORDTYPEDELETECOLORSPACE = 101
Global Const $GDIP_EMFRECORDTYPEGLSRECORD = 102
Global Const $GDIP_EMFRECORDTYPEGLSBOUNDEDRECORD = 103
Global Const $GDIP_EMFRECORDTYPEPIXELFORMAT             = 104
Global Const $GDIP_EMFRECORDTYPEDRAWESCAPE = 105
Global Const $GDIP_EMFRECORDTYPEEXTESCAPE = 106
Global Const $GDIP_EMFRECORDTYPESTARTDOC = 107
Global Const $GDIP_EMFRECORDTYPESMALLTEXTOUT = 108
Global Const $GDIP_EMFRECORDTYPEFORCEUFIMAPPING = 109
Global Const $GDIP_EMFRECORDTYPENAMEDESCAPE = 110
Global Const $GDIP_EMFRECORDTYPECOLORCORRECTPALETTE = 111
Global Const $GDIP_EMFRECORDTYPESETICMPROFILEA = 112
Global Const $GDIP_EMFRECORDTYPESETICMPROFILEW = 113
Global Const $GDIP_EMFRECORDTYPEALPHABLEND = 114
Global Const $GDIP_EMFRECORDTYPESETLAYOUT = 115
Global Const $GDIP_EMFRECORDTYPETRANSPARENTBLT = 116
Global Const $GDIP_EMFRECORDTYPERESERVED_117 = 117
Global Const $GDIP_EMFRECORDTYPEGRADIENTFILL = 118
Global Const $GDIP_EMFRECORDTYPESETLINKEDUFIS = 119
Global Const $GDIP_EMFRECORDTYPESETTEXTJUSTIFICATION = 120
Global Const $GDIP_EMFRECORDTYPECOLORMATCHTOTARGETW = 121
Global Const $GDIP_EMFRECORDTYPECREATECOLORSPACEW = 122
Global Const $GDIP_EMFRECORDTYPEMAX = 122
Global Const $GDIP_EMFRECORDTYPEMIN = 1
Global Const $GDIP_EMFPLUSRECORDTYPEINVALID = $GDIP_EMFPLUS_RECORD_BASE
Global Const $GDIP_EMFPLUSRECORDTYPEHEADER = 0x00004001
Global Const $GDIP_EMFPLUSRECORDTYPEENDOFFILE = 0x00004002
Global Const $GDIP_EMFPLUSRECORDTYPECOMMENT = 0x00004003
Global Const $GDIP_EMFPLUSRECORDTYPEGETDC = 0x00004004
Global Const $GDIP_EMFPLUSRECORDTYPEMULTIFORMATSTART = 0x00004005
Global Const $GDIP_EMFPLUSRECORDTYPEMULTIFORMATSECTION = 0x00004006
Global Const $GDIP_EMFPLUSRECORDTYPEMULTIFORMATEND = 0x00004007
Global Const $GDIP_EMFPLUSRECORDTYPEOBJECT = 0x00004008
Global Const $GDIP_EMFPLUSRECORDTYPECLEAR = 0x00004009
Global Const $GDIP_EMFPLUSRECORDTYPEFILLRECTS = 0x0000400A
Global Const $GDIP_EMFPLUSRECORDTYPEDRAWRECTS = 0x0000400B
Global Const $GDIP_EMFPLUSRECORDTYPEFILLPOLYGON = 0x0000400C
Global Const $GDIP_EMFPLUSRECORDTYPEDRAWLINES = 0x0000400D
Global Const $GDIP_EMFPLUSRECORDTYPEFILLELLIPSE = 0x0000400E
Global Const $GDIP_EMFPLUSRECORDTYPEDRAWELLIPSE = 0x0000400F
Global Const $GDIP_EMFPLUSRECORDTYPEFILLPIE = 0x00004010
Global Const $GDIP_EMFPLUSRECORDTYPEDRAWPIE = 0x00004011
Global Const $GDIP_EMFPLUSRECORDTYPEDRAWARC = 0x00004012
Global Const $GDIP_EMFPLUSRECORDTYPEFILLREGION = 0x00004013
Global Const $GDIP_EMFPLUSRECORDTYPEFILLPATH = 0x00004014
Global Const $GDIP_EMFPLUSRECORDTYPEDRAWPATH = 0x00004015
Global Const $GDIP_EMFPLUSRECORDTYPEFILLCLOSEDCURVE = 0x00004016
Global Const $GDIP_EMFPLUSRECORDTYPEDRAWCLOSEDCURVE = 0x00004017
Global Const $GDIP_EMFPLUSRECORDTYPEDRAWCURVE = 0x00004018
Global Const $GDIP_EMFPLUSRECORDTYPEDRAWBEZIERS = 0x00004019
Global Const $GDIP_EMFPLUSRECORDTYPEDRAWIMAGE = 0x0000401A
Global Const $GDIP_EMFPLUSRECORDTYPEDRAWIMAGEPOINTS = 0x0000401B
Global Const $GDIP_EMFPLUSRECORDTYPEDRAWSTRING = 0x0000401C
Global Const $GDIP_EMFPLUSRECORDTYPESETRENDERINGORIGIN = 0x0000401D
Global Const $GDIP_EMFPLUSRECORDTYPESETANTIALIASMODE = 0x0000401E
Global Const $GDIP_EMFPLUSRECORDTYPESETTEXTRENDERINGHINT = 0x0000401F
Global Const $GDIP_EMFPLUSRECORDTYPESETTEXTCONTRAST = 0x00004020
Global Const $GDIP_EMFPLUSRECORDTYPESETINTERPOLATIONMODE = 0x00004021
Global Const $GDIP_EMFPLUSRECORDTYPESETPIXELOFFSETMODE = 0x00004022
Global Const $GDIP_EMFPLUSRECORDTYPESETCOMPOSITINGMODE = 0x00004023
Global Const $GDIP_EMFPLUSRECORDTYPESETCOMPOSITINGQUALITY = 0x00004024
Global Const $GDIP_EMFPLUSRECORDTYPESAVE = 0x00004025
Global Const $GDIP_EMFPLUSRECORDTYPERESTORE = 0x00004026
Global Const $GDIP_EMFPLUSRECORDTYPEBEGINCONTAINER = 0x00004027
Global Const $GDIP_EMFPLUSRECORDTYPEBEGINCONTAINERNOPARAMS = 0x00004028
Global Const $GDIP_EMFPLUSRECORDTYPEENDCONTAINER = 0x00004029
Global Const $GDIP_EMFPLUSRECORDTYPESETWORLDTRANSFORM = 0x0000402A
Global Const $GDIP_EMFPLUSRECORDTYPERESETWORLDTRANSFORM = 0x0000402B
Global Const $GDIP_EMFPLUSRECORDTYPEMULTIPLYWORLDTRANSFORM = 0x0000402C
Global Const $GDIP_EMFPLUSRECORDTYPETRANSLATEWORLDTRANSFORM = 0x0000402D
Global Const $GDIP_EMFPLUSRECORDTYPESCALEWORLDTRANSFORM = 0x0000402E
Global Const $GDIP_EMFPLUSRECORDTYPEROTATEWORLDTRANSFORM = 0x0000402F
Global Const $GDIP_EMFPLUSRECORDTYPESETPAGETRANSFORM = 0x00004030
Global Const $GDIP_EMFPLUSRECORDTYPERESETCLIP = 0x00004031
Global Const $GDIP_EMFPLUSRECORDTYPESETCLIPRECT = 0x00004032
Global Const $GDIP_EMFPLUSRECORDTYPESETCLIPPATH = 0x00004033
Global Const $GDIP_EMFPLUSRECORDTYPESETCLIPREGION = 0x00004034
Global Const $GDIP_EMFPLUSRECORDTYPEOFFSETCLIP = 0x00004035
Global Const $GDIP_EMFPLUSRECORDTYPEDRAWDRIVERSTRING = 0x00004036
Global Const $GDIP_EMFPLUSRECORDTYPESTROKEFILLPATH = 0x00004037
Global Const $GDIP_EMFPLUSRECORDTYPESERIALIZABLEOBJECT = 0x00004038
Global Const $GDIP_EMFPLUSRECORDTYPESETTSGRAPHICS = 0x00004039
Global Const $GDIP_EMFPLUSRECORDTYPESETTSCLIP = 0x0000403A
Global Const $GDIP_EMFPLUSRECORDTOTAL = 0x0000403B
Global Const $GDIP_EMFPLUSRECORDTYPEMAX = $GDIP_EMFPLUSRECORDTOTAL-1
Global Const $GDIP_EMFPLUSRECORDTYPEMIN = $GDIP_EMFPLUSRECORDTYPEHEADER

; Predefined color argb constants
Global Const $GDIP_ALICEBLUE            = 0xFFF0F8FF
Global Const $GDIP_ANTIQUEWHITE         = 0xFFFAEBD7
Global Const $GDIP_AQUA                 = 0xFF00FFFF
Global Const $GDIP_AQUAMARINE           = 0xFF7FFFD4
Global Const $GDIP_AZURE                = 0xFFF0FFFF
Global Const $GDIP_BEIGE                = 0xFFF5F5DC
Global Const $GDIP_BISQUE               = 0xFFFFE4C4
Global Const $GDIP_BLACK                = 0xFF000000
Global Const $GDIP_BLANCHEDALMOND       = 0xFFFFEBCD
Global Const $GDIP_BLUE                 = 0xFF0000FF
Global Const $GDIP_BLUEVIOLET           = 0xFF8A2BE2
Global Const $GDIP_BROWN                = 0xFFA52A2A
Global Const $GDIP_BURLYWOOD            = 0xFFDEB887
Global Const $GDIP_CADETBLUE            = 0xFF5F9EA0
Global Const $GDIP_CHARTREUSE           = 0xFF7FFF00
Global Const $GDIP_CHOCOLATE            = 0xFFD2691E
Global Const $GDIP_CORAL                = 0xFFFF7F50
Global Const $GDIP_CORNFLOWERBLUE       = 0xFF6495ED
Global Const $GDIP_CORNSILK             = 0xFFFFF8DC
Global Const $GDIP_CRIMSON              = 0xFFDC143C
Global Const $GDIP_CYAN                 = 0xFF00FFFF
Global Const $GDIP_DARKBLUE             = 0xFF00008B
Global Const $GDIP_DARKCYAN             = 0xFF008B8B
Global Const $GDIP_DARKGOLDENROD        = 0xFFB8860B
Global Const $GDIP_DARKGRAY             = 0xFFA9A9A9
Global Const $GDIP_DARKGREEN            = 0xFF006400
Global Const $GDIP_DARKKHAKI            = 0xFFBDB76B
Global Const $GDIP_DARKMAGENTA          = 0xFF8B008B
Global Const $GDIP_DARKOLIVEGREEN       = 0xFF556B2F
Global Const $GDIP_DARKORANGE           = 0xFFFF8C00
Global Const $GDIP_DARKORCHID           = 0xFF9932CC
Global Const $GDIP_DARKRED              = 0xFF8B0000
Global Const $GDIP_DARKSALMON           = 0xFFE9967A
Global Const $GDIP_DARKSEAGREEN         = 0xFF8FBC8B
Global Const $GDIP_DARKSLATEBLUE        = 0xFF483D8B
Global Const $GDIP_DARKSLATEGRAY        = 0xFF2F4F4F
Global Const $GDIP_DARKTURQUOISE        = 0xFF00CED1
Global Const $GDIP_DARKVIOLET           = 0xFF9400D3
Global Const $GDIP_DEEPPINK             = 0xFFFF1493
Global Const $GDIP_DEEPSKYBLUE          = 0xFF00BFFF
Global Const $GDIP_DIMGRAY              = 0xFF696969
Global Const $GDIP_DODGERBLUE           = 0xFF1E90FF
Global Const $GDIP_FIREBRICK            = 0xFFB22222
Global Const $GDIP_FLORALWHITE          = 0xFFFFFAF0
Global Const $GDIP_FORESTGREEN          = 0xFF228B22
Global Const $GDIP_FUCHSIA              = 0xFFFF00FF
Global Const $GDIP_GAINSBORO            = 0xFFDCDCDC
Global Const $GDIP_GHOSTWHITE           = 0xFFF8F8FF
Global Const $GDIP_GOLD                 = 0xFFFFD700
Global Const $GDIP_GOLDENROD            = 0xFFDAA520
Global Const $GDIP_GRAY                 = 0xFF808080
Global Const $GDIP_GREEN                = 0xFF008000
Global Const $GDIP_GREENYELLOW          = 0xFFADFF2F
Global Const $GDIP_HONEYDEW             = 0xFFF0FFF0
Global Const $GDIP_HOTPINK              = 0xFFFF69B4
Global Const $GDIP_INDIANRED            = 0xFFCD5C5C
Global Const $GDIP_INDIGO               = 0xFF4B0082
Global Const $GDIP_IVORY                = 0xFFFFFFF0
Global Const $GDIP_KHAKI                = 0xFFF0E68C
Global Const $GDIP_LAVENDER             = 0xFFE6E6FA
Global Const $GDIP_LAVENDERBLUSH        = 0xFFFFF0F5
Global Const $GDIP_LAWNGREEN            = 0xFF7CFC00
Global Const $GDIP_LEMONCHIFFON         = 0xFFFFFACD
Global Const $GDIP_LIGHTBLUE            = 0xFFADD8E6
Global Const $GDIP_LIGHTCORAL           = 0xFFF08080
Global Const $GDIP_LIGHTCYAN            = 0xFFE0FFFF
Global Const $GDIP_LIGHTGOLDENRODYELLOW = 0xFFFAFAD2
Global Const $GDIP_LIGHTGRAY            = 0xFFD3D3D3
Global Const $GDIP_LIGHTGREEN           = 0xFF90EE90
Global Const $GDIP_LIGHTPINK            = 0xFFFFB6C1
Global Const $GDIP_LIGHTSALMON          = 0xFFFFA07A
Global Const $GDIP_LIGHTSEAGREEN        = 0xFF20B2AA
Global Const $GDIP_LIGHTSKYBLUE         = 0xFF87CEFA
Global Const $GDIP_LIGHTSLATEGRAY       = 0xFF778899
Global Const $GDIP_LIGHTSTEELBLUE       = 0xFFB0C4DE
Global Const $GDIP_LIGHTYELLOW          = 0xFFFFFFE0
Global Const $GDIP_LIME                 = 0xFF00FF00
Global Const $GDIP_LIMEGREEN            = 0xFF32CD32
Global Const $GDIP_LINEN                = 0xFFFAF0E6
Global Const $GDIP_MAGENTA              = 0xFFFF00FF
Global Const $GDIP_MAROON               = 0xFF800000
Global Const $GDIP_MEDIUMAQUAMARINE     = 0xFF66CDAA
Global Const $GDIP_MEDIUMBLUE           = 0xFF0000CD
Global Const $GDIP_MEDIUMORCHID         = 0xFFBA55D3
Global Const $GDIP_MEDIUMPURPLE         = 0xFF9370DB
Global Const $GDIP_MEDIUMSEAGREEN       = 0xFF3CB371
Global Const $GDIP_MEDIUMSLATEBLUE      = 0xFF7B68EE
Global Const $GDIP_MEDIUMSPRINGGREEN    = 0xFF00FA9A
Global Const $GDIP_MEDIUMTURQUOISE      = 0xFF48D1CC
Global Const $GDIP_MEDIUMVIOLETRED      = 0xFFC71585
Global Const $GDIP_MIDNIGHTBLUE         = 0xFF191970
Global Const $GDIP_MINTCREAM            = 0xFFF5FFFA
Global Const $GDIP_MISTYROSE            = 0xFFFFE4E1
Global Const $GDIP_MOCCASIN             = 0xFFFFE4B5
Global Const $GDIP_NAVAJOWHITE          = 0xFFFFDEAD
Global Const $GDIP_NAVY                 = 0xFF000080
Global Const $GDIP_OLDLACE              = 0xFFFDF5E6
Global Const $GDIP_OLIVE                = 0xFF808000
Global Const $GDIP_OLIVEDRAB            = 0xFF6B8E23
Global Const $GDIP_ORANGE               = 0xFFFFA500
Global Const $GDIP_ORANGERED            = 0xFFFF4500
Global Const $GDIP_ORCHID               = 0xFFDA70D6
Global Const $GDIP_PALEGOLDENROD        = 0xFFEEE8AA
Global Const $GDIP_PALEGREEN            = 0xFF98FB98
Global Const $GDIP_PALETURQUOISE        = 0xFFAFEEEE
Global Const $GDIP_PALEVIOLETRED        = 0xFFDB7093
Global Const $GDIP_PAPAYAWHIP           = 0xFFFFEFD5
Global Const $GDIP_PEACHPUFF            = 0xFFFFDAB9
Global Const $GDIP_PERU                 = 0xFFCD853F
Global Const $GDIP_PINK                 = 0xFFFFC0CB
Global Const $GDIP_PLUM                 = 0xFFDDA0DD
Global Const $GDIP_POWDERBLUE           = 0xFFB0E0E6
Global Const $GDIP_PURPLE               = 0xFF800080
Global Const $GDIP_RED                  = 0xFFFF0000
Global Const $GDIP_ROSYBROWN            = 0xFFBC8F8F
Global Const $GDIP_ROYALBLUE            = 0xFF4169E1
Global Const $GDIP_SADDLEBROWN          = 0xFF8B4513
Global Const $GDIP_SALMON               = 0xFFFA8072
Global Const $GDIP_SANDYBROWN           = 0xFFF4A460
Global Const $GDIP_SEAGREEN             = 0xFF2E8B57
Global Const $GDIP_SEASHELL             = 0xFFFFF5EE
Global Const $GDIP_SIENNA               = 0xFFA0522D
Global Const $GDIP_SILVER               = 0xFFC0C0C0
Global Const $GDIP_SKYBLUE              = 0xFF87CEEB
Global Const $GDIP_SLATEBLUE            = 0xFF6A5ACD
Global Const $GDIP_SLATEGRAY            = 0xFF708090
Global Const $GDIP_SNOW                 = 0xFFFFFAFA
Global Const $GDIP_SPRINGGREEN          = 0xFF00FF7F
Global Const $GDIP_STEELBLUE            = 0xFF4682B4
Global Const $GDIP_TAN                  = 0xFFD2B48C
Global Const $GDIP_TEAL                 = 0xFF008080
Global Const $GDIP_THISTLE              = 0xFFD8BFD8
Global Const $GDIP_TOMATO               = 0xFFFF6347
Global Const $GDIP_TRANSPARENT          = 0x00FFFFFF
Global Const $GDIP_TURQUOISE            = 0xFF40E0D0
Global Const $GDIP_VIOLET               = 0xFFEE82EE
Global Const $GDIP_WHEAT                = 0xFFF5DEB3
Global Const $GDIP_WHITE                = 0xFFFFFFFF
Global Const $GDIP_WHITESMOKE           = 0xFFF5F5F5
Global Const $GDIP_YELLOW               = 0xFFFFFF00
Global Const $GDIP_YELLOWGREEN          = 0xFF9ACD32


; Start of enumerations

; Fill mode constants
Global Enum _
	$FillModeAlternate, _
	$FillModeWinding

#cs
	FilleModeAlternate:
		Specifies that areas are filled according to the even-odd parity rule. According to this rule, you can determine
		whether a test point is inside or outside a closed curve as follows: Draw a line from the test point to a point
		that is distant from the curve. If that line crosses the curve an odd number of times, the test point is inside
		the curve; otherwise, the test point is outside the curve.

	FillModeWinding
		Specifies that areas are filled according to the nonzero winding rule. According to this rule, you can determine
		whether a test point is inside or outside a closed curve as follows: Draw a line from a test point to a point that
		is distant from the curve. Count the number of times the curve crosses the test line from left to right, and count
		the number of times the curve crosses the test line from right to left. If those two numbers are the same, the test
		point is outside the curve; otherwise, the test point is inside the curve.
#ce

Global Enum _
	$QualityModeInvalid   = -1, _
	$QualityModeDefault   = 0, _
	$QualityModeLow       = 1, _
	$QualityModeHigh      = 2

; Alpha Compositing mode constants
Global Enum _
	$CompositingModeSourceOver, _ ; Specifies that when a color is rendered, it is blended with the background color. The blend is determined by the alpha component of the color being rendered
	$CompositingModeSourceCopy	  ; Specifies that when a color is rendered, it overwrites the background color. This mode cannot be used along with $TextRenderingHintClearTypeGridFit

; Alpha Compositing quality constants
Global Enum _
	$CompositingQualityInvalid          = $QualityModeInvalid, _ ; Invalid quality
	$CompositingQualityDefault          = $QualityModeDefault, _ ; Gamma correction is not applied
	$CompositingQualityHighSpeed        = $QualityModeLow, _	 ; Gamma correction is not applied. High speed, low quality
	$CompositingQualityHighQuality      = $QualityModeHigh, _	 ; Gamma correction is applied. Composition of high quality and speed.
	$CompositingQualityGammaCorrected, _						 ; Gamma correction is applied
	$CompositingQualityAssumeLinear								 ; Gamma correction is not applied. Linear values are used

Global Enum _
	$UnitWorld, _	; World coordinates, a nonphysical unit
	$UnitDisplay, _	; Display units
	$UnitPixel, _	; A unit is 1 pixel
	$UnitPoint, _	; A unit is 1 point or 1/72 inch
	$UnitInch, _	; A unit is 1 inch
	$UnitDocument, _; A unit is 1/300 inch
	$UnitMillimeter	; A unit is 1 millimeter

Global Enum _
	$MetafileFrameUnitPixel      = $UnitPixel, _	  ; A unit is 1 pixel
	$MetafileFrameUnitPoint      = $UnitPoint, _	  ; A unit is 1 point or 1/72 inch
	$MetafileFrameUnitInch       = $UnitInch, _		  ; A unit is 1 inch
	$MetafileFrameUnitDocument   = $UnitDocument, _   ; A unit is 1/300 inch
	$MetafileFrameUnitMillimeter = $UnitMillimeter, _ ; A unit is 1 millimeter
	$MetafileFrameUnitGdi                             ; A unit is 0.01 millimeter

; Coordinate space constants
Global Enum _
	$CoordinateSpaceWorld, _ ; World coordinate space
	$CoordinateSpacePage, _	 ; Page coordinate space
	$CoordinateSpaceDevice	 ; Device coordinate space

; Wrap mode constants
Global Enum _
	$WrapModeTile, _	   ; Tiling without flipping
	$WrapModeTileFlipX, _  ; Tiles are flipped horizontally as you move from one tile to the next in a row
	$WrapModeTileFlipY, _  ; Tiles are flipped vertically as you move from one tile to the next in a column
	$WrapModeTileFlipXY, _ ; Tiles are flipped horizontally as you move along a row and flipped vertically as you move along a column
	$WrapModeClamp		   ; No tiling takes place

Global Enum _
	$HatchStyleHorizontal, _
	$HatchStyleVertical, _
	$HatchStyleForwardDiagonal, _
	$HatchStyleBackwardDiagonal, _
	$HatchStyleCross, _
	$HatchStyleDiagonalCross, _
	$HatchStyle05Percent, _
	$HatchStyle10Percent, _
	$HatchStyle20Percent, _
	$HatchStyle25Percent, _
	$HatchStyle30Percent, _
	$HatchStyle40Percent, _
	$HatchStyle50Percent, _
	$HatchStyle60Percent, _
	$HatchStyle70Percent, _
	$HatchStyle75Percent, _
	$HatchStyle80Percent, _
	$HatchStyle90Percent, _
	$HatchStyleLightDownwardDiagonal, _
	$HatchStyleLightUpwardDiagonal, _
	$HatchStyleDarkDownwardDiagonal, _
	$HatchStyleDarkUpwardDiagonal, _
	$HatchStyleWideDownwardDiagonal, _
	$HatchStyleWideUpwardDiagonal, _
	$HatchStyleLightVertical, _
	$HatchStyleLightHorizontal, _
	$HatchStyleNarrowVertical, _
	$HatchStyleNarrowHorizontal, _
	$HatchStyleDarkVertical, _
	$HatchStyleDarkHorizontal, _
	$HatchStyleDashedDownwardDiagonal, _
	$HatchStyleDashedUpwardDiagonal, _
	$HatchStyleDashedHorizontal, _
	$HatchStyleDashedVertical, _
	$HatchStyleSmallConfetti, _
	$HatchStyleLargeConfetti, _
	$HatchStyleZigZag, _
	$HatchStyleWave, _
	$HatchStyleDiagonalBrick, _
	$HatchStyleHorizontalBrick, _
	$HatchStyleWeave, _
	$HatchStylePlaid, _
	$HatchStyleDivot, _
	$HatchStyleDottedGrid, _
	$HatchStyleDottedDiamond, _
	$HatchStyleShingle, _
	$HatchStyleTrellis, _
	$HatchStyleSphere, _
	$HatchStyleSmallGrid, _
	$HatchStyleSmallCheckerBoard, _
	$HatchStyleLargeCheckerBoard, _
	$HatchStyleOutlinedDiamond, _
	$HatchStyleSolidDiamond, _
	$HatchStyleTotal, _
	$HatchStyleLargeGrid = $HatchStyleCross, _
	$HatchStyleMin       = $HatchStyleHorizontal, _
	$HatchStyleMax       = $HatchStyleTotal - 1

Global Enum _
	$DashStyleSolid, _
	$DashStyleDash, _
	$DashStyleDot, _
	$DashStyleDashDot, _
	$DashStyleDashDotDot, _
	$DashStyleCustom

;  Dash cap constants
Global Enum _
	$DashCapFlat             = 0, _	; A square cap that squares off both ends of each dash
	$DashCapRound            = 2, _	; A circular cap that rounds off both ends of each dash
	$DashCapTriangle         = 3	; A triangular cap that points both ends of each dash

; Line cap constants (only the lowest 8 bits are used)
Global Enum _
	$LineCapFlat             = 0, _		; Specifies that the line ends at the last point. The end is squared off
	$LineCapSquare           = 1, _		; Specifies a square cap. The center of the square is the last point in the line. The height and width of the square are the line width.
	$LineCapRound            = 2, _		; Specifies a circular cap. The center of the circle is the last point in the line. The diameter of the circle is the line width.
	$LineCapTriangle         = 3, _		; Specifies a triangular cap. The base of the triangle is the last point in the line. The base of the triangle is the line width.
	$LineCapNoAnchor         = 0x10, _ 	; Specifies that the line ends are not anchored.
	$LineCapSquareAnchor     = 0x11, _ 	; Specifies that the line ends are anchored with a square. The center of the square is the last point in the line. The height and width of the square are the line width.
	$LineCapRoundAnchor      = 0x12, _ 	; Specifies that the line ends are anchored with a circle. The center of the circle is at the last point in the line. The circle is wider than the line.
	$LineCapDiamondAnchor    = 0x13, _ 	; Specifies that the line ends are anchored with a diamond (a square turned at 45 degrees). The center of the diamond is at the last point in the line. The diamond is wider than the line.
	$LineCapArrowAnchor      = 0x14, _ 	; Specifies that the line ends are anchored with arrowheads. The arrowhead point is located at the last point in the line. The arrowhead is wider than the line.
	$LineCapCustom           = 0xff, _ 	; Specifies that the line ends are made from a CustomLineCap object.
	$LineCapAnchorMask       = 0xf0    	; mask to check for anchor or not

; Custom Line cap type constants
Global Enum _
	$CustomLineCapTypeDefault         = 0, _ ; CustomLineCap object is an end personalized CustomLineCap
	$CustomLineCapTypeAdjustableArrow = 1	 ; CustomLineCap object is defined by a AdjustableArrowCap object

; Line join constants
Global Enum _
	$LineJoinMiter        = 0, _ ; Produces a sharp corner or a clipped corner
	$LineJoinBevel        = 1, _ ; Produces a diagonal corner.
	$LineJoinRound        = 2, _ ; Produces a smooth, circular arc between the lines.
	$LineJoinMiterClipped = 3	 ; Produces a sharp corner or a clipped corner

; Point type constants
Global Enum _
	$PathPointTypeStart           = 0, _	; The point is the start of a figure
	$PathPointTypeLine            = 1, _	; The point is one of the two endpoints of a line
	$PathPointTypeBezier          = 3, _	; The point is an endpoint or control point of a cubic bezier spline
	$PathPointTypePathTypeMask    = 0x07, _	; Masks all bits except for the three low-order bits, which indicate the point type
	$PathPointTypeDashMode        = 0x10, _	; Not used
	$PathPointTypePathMarker      = 0x20, _	; The point is a marker
	$PathPointTypeCloseSubpath    = 0x80, _	; The point is the last point in a closed subpath (figure)
	$PathPointTypeBezier3    	  = 3		; The point is an endpoint or control point of a cubic bezier spline

; WarpMode constants
Global Enum _
	$WarpModePerspective, _ ; Specifies the perspective warp mode
	$WarpModeBilinear		; Specifies the bilinear warp mode

; LineGradient Mode constants
Global Enum _
	$LinearGradientModeHorizontal, _	  ; Colors changed in a horizontal direction from the left of the display to the right of the display
	$LinearGradientModeVertical, _		  ; Colors changed in a vertical direction from the top of the display to the bottom of the display
	$LinearGradientModeForwardDiagonal, _ ; Colors changee in a forward diagonal direction from the upper-left corner to the lower-right corner of the display
	$LinearGradientModeBackwardDiagonal	  ; Colors changed in a backward diagonal direction from the upper-right corner to the lower-left corner of the display

; Region Comine Mode constants
Global Enum _
	$CombineModeReplace, _	 ; The existing region is replaced by the new region
	$CombineModeIntersect, _ ; The existing region is replaced by the intersection of itself and the new region
	$CombineModeUnion, _	 ; The existing region is replaced by the union of itself and the new region
	$CombineModeXor, _		 ; The existing region is replaced by the result of performing an XOR on the two regions. A point is in the XOR of two regions if it is in one region or the other but not in both regions
	$CombineModeExclude, _	 ; The existing region is replaced by the portion of itself that is outside of the new region
	$CombineModeComplement	 ; The existing region is replaced by the portion of the new region that is outside of the existing region

Global Enum _
	$ImageTypeUnknown, _
	$ImageTypeBitmap, _
	$ImageTypeMetafile

; Interpolation mode constants
Global Enum _
	$InterpolationModeInvalid          = $QualityModeInvalid, _ ; Used internally
	$InterpolationModeDefault          = $QualityModeDefault, _ ; Default interpolation mode
	$InterpolationModeLowQuality       = $QualityModeLow, _		; Low-quality mode
	$InterpolationModeHighQuality      = $QualityModeHigh, _	; High-quality mode
	$InterpolationModeBilinear, _								; Bilinear interpolation. No prefiltering is done. This mode is not suitable for shrinking an image below 50 percent of its original size
	$InterpolationModeBicubic, _								; Bicubic interpolation. No prefiltering is done. This mode is not suitable for shrinking an image below 25 percent of its original size
	$InterpolationModeNearestNeighbor, _						; Nearest-neighbor interpolation
	$InterpolationModeHighQualityBilinear, _					; High-quality, bilinear interpolation. Prefiltering is performed to ensure high-quality shrinking
	$InterpolationModeHighQualityBicubic						; High-quality, bicubic interpolation. Prefiltering is performed to ensure high-quality shrinking. This mode produces the highest quality transformed images

Global Enum _
	$PenAlignmentCenter       = 0, _
	$PenAlignmentInset        = 1

Global Enum _
	$BrushTypeSolidColor       = 0, _
	$BrushTypeHatchFill        = 1, _
	$BrushTypeTextureFill      = 2, _
	$BrushTypePathGradient     = 3, _
	$BrushTypeLinearGradient   = 4

;  Pen Fill Type constants
Global Enum _
	$PenTypeSolidColor       = $BrushTypeSolidColor, _	   ; The pen draws with a solid color
	$PenTypeHatchFill        = $BrushTypeHatchFill, _	   ; The pen draws with a hatch pattern that is specified by a HatchBrush object
	$PenTypeTextureFill      = $BrushTypeTextureFill, _	   ; The pen draws with a texture that is specified by a TextureBrush object
	$PenTypePathGradient     = $BrushTypePathGradient, _   ; The pen draws with a color gradient that is specified by a PathGradientBrush object
	$PenTypeLinearGradient   = $BrushTypeLinearGradient, _ ; The pen draws with a color gradient that is specified by a LinearGradientBrush object
	$PenTypeUnknown          = -1					 	   ; The pen type is unknown

Global Enum _
	$MatrixOrderPrepend    = 0, _ ; The new matrix is on the left and the existing matrix is on the right
	$MatrixOrderAppend     = 1	  ; The existing matrix is on the left and the new matrix is on the right

Global Enum _
	$GenericFontFamilySerif, _
	$GenericFontFamilySansSerif, _
    $GenericFontFamilyMonospace

; Face types and common styles constants
Global Enum _
	$FontStyleRegular    = 0, _ ; Specifies normal weight or thickness of the typeface
	$FontStyleBold       = 1, _ ; Specifies bold typeface. Bold is a heavier weight or thickness
	$FontStyleItalic     = 2, _ ; Specifies italic typeface, which produces a noticeable slant to the vertical stems of the characters
	$FontStyleBoldItalic = 3, _ ; Specifies the typeface as both bold and italic
	$FontStyleUnderline  = 4, _ ; Specifies underline, which displays a line underneath the baseline of the characters
	$FontStyleStrikeout  = 8	; Specifies strikeout, which displays a horizontal line drawn through the middle of the characters

Global Enum _
	$SmoothingModeInvalid     = $QualityModeInvalid, _
	$SmoothingModeDefault     = $QualityModeDefault, _
	$SmoothingModeHighSpeed   = $QualityModeLow, _
	$SmoothingModeHighQuality = $QualityModeHigh, _
	$SmoothingModeNone, _
	$SmoothingModeAntiAlias, _
	$SmoothingModeAntiAlias8x4 = $SmoothingModeAntiAlias, _
    $SmoothingModeAntiAlias8x8

; Pixel Format Mode constants
Global Enum _
	$PixelOffsetModeInvalid     = $QualityModeInvalid, _ ; Used internally
	$PixelOffsetModeDefault     = $QualityModeDefault, _ ; Equivalent to PixelOffsetModeNone
	$PixelOffsetModeHighSpeed   = $QualityModeLow, _	 ; Equivalent to PixelOffsetModeNone
	$PixelOffsetModeHighQuality = $QualityModeHigh, _	 ; Equivalent to PixelOffsetModeHalf
	$PixelOffsetModeNone, _								 ; Indicates that pixel centers have integer coordinates
	$PixelOffsetModeHalf								 ; Indicates that pixel centers have coordinates that are half way between integer values

; Text Rendering Hint constants
Global Enum _
	$TextRenderingHintSystemDefault = 0, _		  ; Character is drawn using the currently selected system font smoothing mode (also called a rendering hint)
	$TextRenderingHintSingleBitPerPixelGridFit, _ ; Character is drawn using its glyph bitmap and hinting to improve character appearance on stems and curvature
	$TextRenderingHintSingleBitPerPixel, _		  ; Character is drawn using its glyph bitmap and no hinting. This results in better performance at the expense of quality
	$TextRenderingHintAntiAliasGridFit, _		  ; Character is drawn using its antialiased glyph bitmap and hinting. This results in much better quality due to antialiasing at a higher performance cost
	$TextRenderingHintAntiAlias, _				  ; Character is drawn using its antialiased glyph bitmap and no hinting. Stem width differences may be noticeable because hinting is turned off
	$TextRenderingHintClearTypeGridFit			  ; Character is drawn using its glyph Microsoft ClearType bitmap and hinting. This type of text rendering cannot be used along with $CompositingModeSourceCopy

Global Enum _
	$MetafileTypeInvalid, _
	$MetafileTypeWmf, _
	$MetafileTypeWmfPlaceable, _
	$MetafileTypeEmf, _
	$MetafileTypeEmfPlusOnly, _
	$MetafileTypeEmfPlusDual

; Types of EMF to record
Global Enum _
	$EmfTypeEmfOnly     = $MetafileTypeEmf, _		  ; Records in the metafile are EMF records, which can be displayed by GDI or GDI+
	$EmfTypeEmfPlusOnly = $MetafileTypeEmfPlusOnly, _ ; Records in the metafile are EMF+ records, which can be displayed by GDI+ but not by GDI
	$EmfTypeEmfPlusDual = $MetafileTypeEmfPlusDual	  ; EMF+ records in the metafile are associated with an alternate EMF record. Metafiles of this type can be displayed by GDI or by GDI+

Global Enum _
	$ObjectTypeInvalid, _
	$ObjectTypeBrush, _
	$ObjectTypePen, _
	$ObjectTypePath, _
	$ObjectTypeRegion, _
	$ObjectTypeImage, _
	$ObjectTypeFont, _
	$ObjectTypeStringFormat, _
	$ObjectTypeImageAttributes, _
	$ObjectTypeCustomLineCap, _
	$ObjectTypeGraphics, _
	$ObjectTypeMax = $ObjectTypeGraphics, _
	$ObjectTypeMin = $ObjectTypeBrush

; StringFormatFlags constants
Global Enum _
	$StringFormatFlagsDirectionRightToLeft  = 0x00000001, _ ; Reading order is right to left. For horizontal text, characters are read from right to left. For vertical text, columns are read from right to left. By default, horizontal or vertical text is read from left to right
	$StringFormatFlagsDirectionVertical     = 0x00000002, _ ; Individual lines of text are drawn vertically on the display device. By default, lines of text are horizontal, each new line below the previous line
	$StringFormatFlagsNoFitBlackBox         = 0x00000004, _ ; Parts of characters are allowed to overhang the string's layout rectangle. By default, characters are first aligned inside the rectangle's boundaries, then any characters which still overhang the boundaries are repositioned to avoid any overhang and thereby avoid affecting pixels outside the layout rectangle. An italic, lowercase letter F ( f) is an example of a character that may have overhanging parts. Setting this flag ensures that the character aligns visually with the lines above and below but may cause parts of characters, which lie outside the layout rectangle, to be clipped or painted
	$StringFormatFlagsDisplayFormatControl  = 0x00000020, _ ; Unicode layout control characters are displayed with a representative character
	$StringFormatFlagsNoFontFallback        = 0x00000400, _ ; An alternate font is used for characters that are not supported in the requested font
	$StringFormatFlagsMeasureTrailingSpaces = 0x00000800, _ ; The space at the end of each line is included in a string measurement. By default, the boundary rectangle returned by the Graphics::MeasureString method excludes the space at the end of each line. Set this flag to include that space in the measurement
	$StringFormatFlagsNoWrap                = 0x00001000, _ ; Wrapping of text to the next line is disabled. NoWrap is implied when a point of origin is used instead of a layout rectangle. When drawing text within a rectangle, by default, text is broken at the last word boundary that is inside the rectangle's boundary and wrapped to the next line
	$StringFormatFlagsLineLimit             = 0x00002000, _ ; Only entire lines are laid out in the layout rectangle. By default, layout continues until the end of the text or until no more lines are visible as a result of clipping, whichever comes first. The default settings allow the last line to be partially obscured by a layout rectangle that is not a whole multiple of the line height. To ensure that only whole lines are seen, set this flag and be careful to provide a layout rectangle at least as tall as the height of one line
	$StringFormatFlagsNoClip                = 0x00004000, _ ; Characters overhanging the layout rectangle and text extending outside the layout rectangle are allowed to show. By default, all overhanging characters and text that extends outside the layout rectangle are clipped. Any trailing spaces (spaces that are at the end of a line) that extend outside the layout rectangle are clipped. Therefore, the setting of this flag will have an effect on a string measurement if trailing spaces are being included in the measurement. If clipping is enabled, trailing spaces that extend outside the layout rectangle are not included in the measurement. If clipping is disabled, all trailing spaces are included in the measurement, regardless of whether they are outside the layout rectangle
	$StringFormatFlagsBypassGDI             = 0x80000000 	;

; StringTrimming constants
Global Enum _
	$StringTrimmingNone              = 0, _ ; No trimming is done
	$StringTrimmingCharacter         = 1, _ ; String is broken at the boundary of the last character that is inside the layout rectangle
	$StringTrimmingWord              = 2, _ ; String is broken at the boundary of the last word that is inside the layout rectangle
	$StringTrimmingEllipsisCharacter = 3, _ ; String is broken at the boundary of the last character that is inside the layout rectangle and an ellipsis (...) is inserted after the character
	$StringTrimmingEllipsisWord      = 4, _ ; String is broken at the boundary of the last word that is inside the layout rectangle and an ellipsis (...) is inserted after the word
	$StringTrimmingEllipsisPath      = 5	; The center is removed from the string and replaced by an ellipsis. The algorithm keeps as much of the last portion of the string as possible

; National language digit substitution constants
Global Enum _
	$StringDigitSubstituteUser        = 0, _ ; A user-defined substitution scheme
	$StringDigitSubstituteNone        = 1, _ ; Digit substitution is disabled
	$StringDigitSubstituteNational    = 2, _ ; Substitution digits that correspond with the official national language of the user's locale
	$StringDigitSubstituteTraditional = 3	 ; Substitution digits that correspond with the user's native script or language

;  Hotkey prefix interpretation constants
Global Enum _
	$HotkeyPrefixNone        = 0, _	; No hot key processing occurs
	$HotkeyPrefixShow        = 1, _	; Unicode text is scanned for ampersands (&), which are interpreted as hot key markers in the same way as menu and dialog resources are processed in the Windows user interface. All pairs of ampersands are replaced by a single ampersand. All single ampersands are removed and the first character that follows the first single ampersand is displayed underlined
	$HotkeyPrefixHide        = 2	; Unicode text is scanned for ampersands (&), which are substituted and removed as in HotkeyPrefixShow but no underline is shown. This option can be used when accessibility hot key underlines are not required

; String alignment flags
Global Enum _
	$StringAlignmentNear   = 0, _ ; Alignment is towards the origin of the bounding rectangle
	$StringAlignmentCenter = 1, _ ; Alignment is centered between origin and extent (width) of the formatting rectangle
	$StringAlignmentFar    = 2	  ; Alignment is to the far extent (right side) of the formatting rectangle

;  DriverStringOptions flags
Global Enum _
	$DriverStringOptionsCmapLookup             = 1, _ ; The string array contains Unicode character values. If this flag is not set, each value in array is interpreted as an index to a font glyph that defines a character to be displayed
	$DriverStringOptionsVertical               = 2, _ ; The string is displayed vertically
	$DriverStringOptionsRealizedAdvance        = 4, _ ; The glyph positions are calculated from the position of the first glyph. If this flag is not set, the glyph positions are obtained from an array of coordinates
	$DriverStringOptionsLimitSubpixel          = 8 	  ; Less memory should be used for cache of antialiased glyphs. This also produces lower quality. If this flag is not set, more memory is used, but the quality is higher

; Flush Intention flags
Global Enum _
	$FlushIntentionFlush = 0, _ ; Flush all batched rendering operations
	$FlushIntentionSync = 1		; Flush all batched rendering operations and wait for them to complete

Global Enum _
	$EncoderParameterValueTypeByte           = 1, _
	$EncoderParameterValueTypeASCII          = 2, _
	$EncoderParameterValueTypeShort          = 3, _
	$EncoderParameterValueTypeLong           = 4, _
	$EncoderParameterValueTypeRational       = 5, _
	$EncoderParameterValueTypeLongRange      = 6, _
	$EncoderParameterValueTypeUndefined      = 7, _
	$EncoderParameterValueTypeRationalRange  = 8, _
    $EncoderParameterValueTypePointer        = 9

Global Enum _
	$EncoderValueColorTypeCMYK, _
	$EncoderValueColorTypeYCCK, _
	$EncoderValueCompressionLZW, _
	$EncoderValueCompressionCCITT3, _
	$EncoderValueCompressionCCITT4, _
	$EncoderValueCompressionRle, _
	$EncoderValueCompressionNone, _
	$EncoderValueScanMethodInterlaced, _
	$EncoderValueScanMethodNonInterlaced, _
	$EncoderValueVersionGif87, _
	$EncoderValueVersionGif89, _
	$EncoderValueRenderProgressive, _
	$EncoderValueRenderNonProgressive, _
	$EncoderValueTransformRotate90, _
	$EncoderValueTransformRotate180, _
	$EncoderValueTransformRotate270, _
	$EncoderValueTransformFlipHorizontal, _
	$EncoderValueTransformFlipVertical, _
	$EncoderValueMultiFrame, _
	$EncoderValueLastFrame, _
	$EncoderValueFlush, _
	$EncoderValueFrameDimensionTime, _
	$EncoderValueFrameDimensionResolution, _
	$EncoderValueFrameDimensionPage, _
	$EncoderValueColorTypeGray, _
	$EncoderValueColorTypeRGB

; Conversion of Emf To WMF Bits flag constants
Global Enum _
	$EmfToWmfBitsFlagsDefault          = 0, _ ; Specifies the default conversion
	$EmfToWmfBitsFlagsEmbedEmf         = 1, _ ; Specifies that the source EMF metafile is embedded as a comment in the resulting WMF metafile
	$EmfToWmfBitsFlagsIncludePlaceable = 2, _ ; Specifies that the resulting WMF metafile is in the placeable metafile format; that is, it has the additional 22-byte header required by a placeable metafile
	$EmfToWmfBitsFlagsNoXORClip        = 4	   ; Specifies that the clipping region is stored in the metafile in the traditional way. If you do not set this flag, the EmfToWmfBits method applies an optimization that stores the clipping region as a path and simulates clipping by using the XOR operator

Global Enum _
	$ConvertToEmfPlusFlagsDefault       = 0, _
	$ConvertToEmfPlusFlagsRopUsed       = 1, _
	$ConvertToEmfPlusFlagsText          = 2, _
	$ConvertToEmfPlusFlagsInvalidRecord = 4

Global Enum _
	$TestControlForceBilinear = 0, _
	$TestControlNoICM = 1, _
	$TestControlGetBuildNumber = 2

; Per-channel Histogram for 8bpp images.
Global Enum _
	$HistogramFormatARGB, _
    $HistogramFormatPARGB, _
    $HistogramFormatRGB, _
    $HistogramFormatGray, _
    $HistogramFormatB, _
    $HistogramFormatG, _
    $HistogramFormatR, _
    $HistogramFormatA

; Color Matrix flags
Global Enum _
    $ColorMatrixFlagsDefault, _	  ; All color values (including grays) are adjusted by the same color-adjustment matrix
    $ColorMatrixFlagsSkipGrays, _ ; Colors are adjusted but gray shades are not adjusted. A gray shade is any color that has the same value for its red, green, and blue components
    $ColorMatrixFlagsAltGray	  ; Colors are adjusted by one matrix and gray shades are adjusted by another matrix

; Color Adjust Type constants
Global Enum _
    $ColorAdjustTypeDefault, _ ; Color or grayscale adjustment applies to all categories that do not have adjustment settings of their own
    $ColorAdjustTypeBitmap, _  ; Color or grayscale adjustment applies to bitmapped images
    $ColorAdjustTypeBrush, _   ; Color or grayscale adjustment applies to brush operations in metafiles
    $ColorAdjustTypePen, _	   ; Color or grayscale adjustment applies to pen operations in metafiles
    $ColorAdjustTypeText, _	   ; Color or grayscale adjustment applies to text drawn in metafiles
    $ColorAdjustTypeCount, _   ; Used internally to record the number of color adjustment types
    $ColorAdjustTypeAny        ; Reserved

; Color Channel flags
Global Enum _
    $ColorChannelFlagsC, _	; Cyan color channel
    $ColorChannelFlagsM, _	; Magenta color channel
    $ColorChannelFlagsY, _	; Yellow color channel
    $ColorChannelFlagsK, _	; Black color channel
    $ColorChannelFlagsLast	; The last selected channel

Func ObjectTypeIsValid($type)
    Return ($type >= $ObjectTypeMin) And ($type <= $ObjectTypeMax)
EndFunc

#EndRegion Enums, Constants and Structures