#include <Array.au3>
#include 'GUISelButton.au3'

$hGUI = GUICreate('GUISelButton Demo', 280, 100)

$hSelButton1 = _GUICtrlSelButton_Create('Selection Button 1', 'Item #1|Item #2|Item #3', 20, 20, 130, 120, False, 'Sellect all')
$hSelButton2 = _GUICtrlSelButton_Create('Selection Button 2', '', 20, 60, 130, 120, True)

$sItems = ''

For $i = 1 To 50
	$sItems &= ($sItems ? '|' : '') & 'Other Item #' & $i
Next

_GUICtrlSelButton_SetData($hSelButton2, $sItems, 'Sellect all')
_GUICtrlSelButton_SetState($hSelButton2, $GUI_CHECKED, Random(0, 19, 1))
;GUICtrlSetState(_GUICtrlSelButton_GetID($hSelButton2), $GUI_DISABLE)

$iShowSel1_Bttn = GUICtrlCreateButton('Show selected', 180, 20, 80, 20)
$iShowSel2_Bttn = GUICtrlCreateButton('Show selected', 180, 60, 80, 20)

GUISetState(@SW_SHOW, $hGUI)

While 1
	Switch GUIGetMsg()
		Case $GUI_EVENT_CLOSE
			_GUICtrlSelButton_Delete($hSelButton1)
			_GUICtrlSelButton_Delete($hSelButton2)
			
			Exit
		Case $iShowSel1_Bttn
			$aSel = _GUICtrlSelButton_GetSelected($hSelButton1)
			_ArrayDisplay($aSel)
		Case $iShowSel2_Bttn
			$aSel = _GUICtrlSelButton_GetSelected($hSelButton2)
			_ArrayDisplay($aSel)
	EndSwitch
WEnd
