#Au3Stripper_Parameters=/so /rm /pe

#include <ButtonConstants.au3>
#include <DateTimeConstants.au3>
#include <EditConstants.au3>
#include <GUIConstantsEx.au3>
#include <StaticConstants.au3>
#include <WindowsConstants.au3>
#include <IE.au3>
#include <Array.au3>

Opt("GUIOnEventMode", 1)
Opt("TrayAutoPause", 0)
Opt("TrayAutoPause", 0)
Opt("TrayMenuMode", 1)
Opt("TrayOnEventMode", 1)
$Form1 = GUICreate("-", 427, 435, 192, 124)
GUISetBkColor(0xFFFFFF)
$Group1 = GUICtrlCreateGroup(" ", 8, 8, 409, 97)
$Label1 = GUICtrlCreateLabel("", 16, 74, 46, 17)
$Label2 = GUICtrlCreateLabel("", 16, 50, 42, 17)
$Label3 = GUICtrlCreateLabel("", 16, 26, 35, 17)
$in_Login = GUICtrlCreateInput("", 72, 24, 335, 21)
GUICtrlSetOnEvent(-1, "_InChange")
$in_Pass = GUICtrlCreateInput("", 72, 48, 335, 21, BitOR($GUI_SS_DEFAULT_INPUT, $ES_PASSWORD))
GUICtrlSetOnEvent(-1, "_InChange")
$in_Guild = GUICtrlCreateInput("", 72, 72, 335, 21)
GUICtrlSetOnEvent(-1, "_InChange")
GUICtrlCreateGroup("", -99, -99, 1, 1)
$b_MonitorStart = GUICtrlCreateButton(" ", 8, 110, 411, 49)
GUICtrlSetTip(-1, "    2 .")
GUICtrlSetOnEvent(-1, "_MonitorStart")
$Group2 = GUICtrlCreateGroup("", 8, 160, 409, 265)
$m_Start = GUICtrlCreateMonthCal("", 16, 176, 191, 164)
$m_End = GUICtrlCreateMonthCal("", 216, 176, 191, 164)
$b_Date_Now = GUICtrlCreateButton("  ", 216, 344, 192, 25)
GUICtrlSetOnEvent(-1, "_SetLast")
$b_Date_First = GUICtrlCreateButton("  ", 16, 344, 192, 25)
GUICtrlSetOnEvent(-1, "_SetFirst")
$b_ShowStats = GUICtrlCreateButton(" !", 16, 376, 393, 41)
GUICtrlSetOnEvent(-1, "_GetDiff")
GUICtrlCreateGroup("", -99, -99, 1, 1)
Global $DLogin = IniRead("lbm.ini", "LoginInfo", "Login", "0")
Global $DPass = IniRead("lbm.ini", "LoginInfo", "Pass", "0")
Global $DGuild = IniRead("lbm.ini", "LoginInfo", "Guild", "0")
If $DLogin <> "0" Then GUICtrlSetData($in_Login, $DLogin)
If $DPass <> "0" Then GUICtrlSetData($in_Pass, $DPass)
If $DGuild <> "0" Then GUICtrlSetData($in_Guild, $DGuild)

GUISetState(@SW_SHOW)

GUISetOnEvent($GUI_EVENT_CLOSE, "Form1Close")
GUISetOnEvent($GUI_EVENT_MINIMIZE, "Form1Min")
TraySetOnEvent(-8, "Form1Show")
TraySetToolTip("  -.")

While 1
	Sleep(1000)
WEnd

Func _MonitorStart()

	_LockCtrls()
	GUICtrlSetData($b_MonitorStart, " ")
	GUICtrlSetOnEvent($b_MonitorStart, "_MonitorEnd")
	AdlibRegister("_Monitoring", 1000)

EndFunc   ;==>_MonitorStart

Func _MonitorEnd()

	_UnLockCtrls()
	GUICtrlSetData($b_MonitorStart, " ")
	GUICtrlSetOnEvent($b_MonitorStart, "_MonitorStart")
	AdlibUnRegister("_Monitoring")

EndFunc   ;==>_MonitorEnd

Func _SetFirst()
	Local $h = FileFindFirstFile(@ScriptDir & "\Data\*" & $DGuild & "*")
	Local $s = FileFindNextFile($h)
	If Not $s Then
		MsgBox(16, "", "   .")
		Return
	EndIf
	$s = StringReplace($s, ".gvdat", "")
	$s = StringReplace($s, ".", "/")
	GUICtrlSetData($m_Start, $s)
	FileClose($h)
EndFunc   ;==>_SetFirst

Func _SetLast()
	$DGuild = GUICtrlRead($in_Guild)
	if FileExists(@ScriptDir & "\Data\" & StringReplace(GUICtrlRead($m_End), "/", ".") & " (" & GUICtrlRead($DGuild) & ").gvdat") then	
		GUICtrlSetData($m_End, @YEAR & "/" & @MON & "/" & @MDAY)
	Else
		Local $h = FileFindFirstFile(@ScriptDir & "\Data\*" & $DGuild & "*")
		While 1
			Local $s = FileFindNextFile($h)
			If Not $s Then ExitLoop
			$s1 = StringReplace($s, ".gvdat", "")
			$s1 = StringReplace($s1, ".", "/")
		wend
		GUICtrlSetData($m_End, $s1)
		FileClose($h)
	EndIf
EndFunc   ;==>_SetLast

Func _Monitoring()
	ConsoleWrite($DLogin & @CRLF)
	Local $DLogin = 1
	AdlibUnRegister("_Monitoring")
	_GetGuildStats()
	AdlibRegister("_Monitoring", 3600000*2)

EndFunc   ;==>_Monitoring

Func _GetGuildStats()

	Global $oIE = _IECreate("", 0, 0)
	
	$File = @ScriptDir & "\Data\" & @YEAR & "." & @MON & "." & @MDAY & " (" & GUICtrlRead($in_Guild) & ").gvdat"
	FileDelete($File)
	$File = FileOpen($File, 128 + 8 + 1)
	
	_LogoutAndLogin()
	
	Local $i, $j, $t1, $t2, $t3
	
	_IENavigate($oIE, "http://godville.net/stats/guild/" & $DGuild)
	_IENavigate($oIE, "http://godville.net/stats/guild/" & $DGuild)
	$temp = ""
	$temp = _IEGetObjById($oIE, "g_tbl")
	If IsObj($temp) Then
		$data = StringRegExpReplace($temp.innerhtml, "(?smi)<thead>.*</thead>", "")
		$Links = StringRegExp($data, "(?i)<a.*?>(.*?)</a>", 3)
		For $j = 0 To UBound($Links) - 1
			$t1 = $Links[$j]
			_IENavigate($oIE, "http://godville.net/gods/" & $t1)
			$t2 = StringInStr(_IEGetObjById($oIE, "essential_info").innerhtml, "?") ? 1 : 0
			$tmp = StringRegExp(_IEGetObjById($oIE, "characteristics").innerhtml, '(?smi)<a href="/meter/gods/.*?>(.*?)</a>', 3)
			$t3 = StringStripWS($tmp[0], 8)
			FileWrite($File, "<n=" & $t1 & ">" & "<t=" & $t2 & "><v=" & $t3 & ">" & @CRLF)
		Next
	EndIf
	FileClose($File)
	_IEQuit($oIE)

EndFunc   ;==>_GetGuildStats

Func _GetDiff()

	_LockCtrls(1)
	__GetDiff()
	_UnLockCtrls()

EndFunc   ;==>_GetDiff

Func _LockCtrls($f = 0)
	GUICtrlSetState($in_Login, $GUI_DISABLE)
	GUICtrlSetState($in_Pass, $GUI_DISABLE)
	GUICtrlSetState($in_Guild, $GUI_DISABLE)
	If $f = 1 Then GUICtrlSetState($b_MonitorStart, $GUI_DISABLE)
	GUICtrlSetState($m_Start, $GUI_DISABLE)
	GUICtrlSetState($m_End, $GUI_DISABLE)
	GUICtrlSetState($b_Date_Now, $GUI_DISABLE)
	GUICtrlSetState($b_Date_First, $GUI_DISABLE)
	GUICtrlSetState($b_ShowStats, $GUI_DISABLE)
EndFunc   ;==>_LockCtrls

Func _UnLockCtrls()
	GUICtrlSetState($in_Login, $GUI_ENABLE)
	GUICtrlSetState($in_Pass, $GUI_ENABLE)
	GUICtrlSetState($in_Guild, $GUI_ENABLE)
	GUICtrlSetState($b_MonitorStart, $GUI_ENABLE)
	GUICtrlSetState($m_Start, $GUI_ENABLE)
	GUICtrlSetState($m_End, $GUI_ENABLE)
	GUICtrlSetState($b_Date_Now, $GUI_ENABLE)
	GUICtrlSetState($b_Date_First, $GUI_ENABLE)
	GUICtrlSetState($b_ShowStats, $GUI_ENABLE)
EndFunc   ;==>_UnLockCtrls

Func __GetDiff()
	
	$h = FileOpen(@ScriptDir & "\Data\" & StringReplace(GUICtrlRead($m_Start), "/", ".") & " (" & GUICtrlRead($in_Guild) & ").gvdat", 128)
	If Not $h Then
		MsgBox(16, "", "     .")
		Return
	EndIf
	$d_Start = FileRead($h)
	FileClose($h)
	$h = ""
	
	$h = FileOpen(@ScriptDir & "\Data\" & StringReplace(GUICtrlRead($m_End), "/", ".") & " (" & GUICtrlRead($in_Guild) & ").gvdat", 128)
	If Not $h Then
		MsgBox(16, "", "     .")
		Return
	EndIf
	$d_End = FileRead($h)
	FileClose($h)
	$h = ""
	
	$a_S_N = StringRegExp($d_Start, "(?i)<n=(.*?)>", 3)
	$a_S_T = StringRegExp($d_Start, "(?i)<t=(.*?)>", 3)
	$a_S_V = StringRegExp($d_Start, "(?i)<v=(.*?)>", 3)
	
	$a_E_N = StringRegExp($d_End, "(?i)<n=(.*?)>", 3)
	$a_E_T = StringRegExp($d_End, "(?i)<t=(.*?)>", 3)
	$a_E_V = StringRegExp($d_End, "(?i)<v=(.*?)>", 3)
	
	Local $ms_Leave, $ms_Arrive, $ms_Tpl, $ms_Vict, $ms_Loss
	Local $mc_Leave, $mc_Arrive, $mc_Tpl
	
	For $i = 0 To UBound($a_E_N) - 1
		$pos = _ArraySearch($a_S_N, $a_E_N[$i])
		If $pos = -1 Then
			If Not $ms_Arrive Then $ms_Arrive = "  : " & @CRLF
			$ms_Arrive &= "	" & $a_E_N[$i] & @CRLF
			$mc_Arrive += 1
		EndIf
	Next
	
	Local $MaxLen = 0, $Tpls = 0
	For $i = 0 To UBound($a_E_N) - 1
		$l = StringLen($a_E_N[$i])
		If $l > $MaxLen Then $MaxLen = $l + 1
		If $a_E_T[$i] = 1 then $Tpls += 1
	Next
	
	Local $j = 0
	For $i = 0 To UBound($a_S_N) - 1
		$pos = _ArraySearch($a_E_N, $a_S_N[$i])
		If $pos = -1 Then
			If Not $ms_Leave Then $ms_Leave = " : " & @CRLF
			$ms_Leave &= "	" & $a_S_N[$i] & @CRLF
			$mc_Leave += 1
		Else
			If $a_S_T[$i] = 0 And $a_E_T[$pos] = 1 Then
				If Not $ms_Tpl Then $ms_Tpl = " : " & @CRLF
				$ms_Tpl &= "	" & $a_S_N[$i] & @CRLF
				$mc_Tpl += 1
			EndIf
			If $a_S_V[$i] <> $a_E_V[$pos] then
				Local $vs = StringSplit($a_S_V[$i], "/"), $ve = StringSplit($a_E_V[$pos], "/")
				If Not $ms_Vict Then $ms_Vict = "/  :" & @CRLF
				$ms_Vict &= "	" & StringFormat("%-" & $MaxLen & "s", $a_S_N[$i]) & $ve[1] - $vs[1] & " / " & $ve[2] - $vs[2] & @CRLF
			endif
		EndIf
	Next
	
	$fn = @ScriptDir & "\Diffs\" & @YEAR & "." & @MON & "." & @MDAY & " - " & @HOUR & "-" & @MIN & "-" & @SEC & ".txt"
	
	$h = FileOpen($fn, 128 + 8 + 1)
	FileWrite($h, "     " & GUICtrlRead($m_Start) & "  " & GUICtrlRead($m_End) & @CRLF & @CRLF)
	If $ms_Leave Then FileWrite($h, $ms_Leave)
	If $mc_Leave Then FileWrite($h, "	" & StringFormat("%-" & $MaxLen & "s", ": ") & $mc_Leave & @CRLF & @CRLF)
	If $ms_Arrive Then FileWrite($h, $ms_Arrive)
	If $mc_Arrive Then FileWrite($h, "	" & StringFormat("%-" & $MaxLen & "s", ": ") & $mc_Arrive & @CRLF & @CRLF)
	If $Tpls then FileWrite($h, "  : " & $Tpls & @CRLF)
	If $ms_Tpl Then FileWrite($h, $ms_Tpl)
	If $mc_Tpl Then FileWrite($h, "	" & StringFormat("%-" & $MaxLen & "s", ": ") & $mc_Tpl & @CRLF & @CRLF)
	If $ms_Vict Then FileWrite($h, $ms_Vict & @CRLF)
	FileClose($h)
	
	ShellExecute($fn)

EndFunc   ;==>__GetDiff

Func Form1Close()
	If IsDeclared("oIE") Then _IEQuit($oIE)
	Exit
EndFunc   ;==>Form1Close

Func Form1Min()
	GUISetState(@SW_HIDE)
EndFunc   ;==>Form1Min

Func Form1Show()
	GUISetState(@SW_SHOW)
EndFunc   ;==>Form1Show

Func _InChange()

	$DLogin = GUICtrlRead($in_Login)
	$DPass = GUICtrlRead($in_Pass)
	$DGuild = GUICtrlRead($in_Guild)

	If $DLogin <> "" Then IniWrite("lbm.ini", "LoginInfo", "Login", $DLogin)
	If $DPass <> "" Then IniWrite("lbm.ini", "LoginInfo", "Pass", $DPass)
	If $DGuild <> "" Then IniWrite("lbm.ini", "LoginInfo", "Guild", $DGuild)

EndFunc   ;==>_InChange

Func _LogoutAndLogin()
	
	If Ping("godville.net", 1000) = 0 Then
		MsgBox(16, " ", "  .  .")
		Return
	EndIf

	$DLogin = GUICtrlRead($in_Login)
	$DPass = GUICtrlRead($in_Pass)
	
	If $DLogin = "" Or $DPass = "" Then
		MsgBox(16, " ", "    . . ,       .")
		Return
	EndIf

	_IENavigate($oIE, "http://godville.net/login")
	$trl = _IEGetObjById($oIE, "menu_bar")
	If IsObj($trl) Then
		$tdivs = $trl.getElementsByTagName("a")
		For $tdiv In $tdivs
			If $tdiv.innertext = "" Then
				_IEAction($tdiv, "click")
				_IELoadWait($oIE)
				ExitLoop
			EndIf
		Next
	EndIf
	
	_IENavigate($oIE, "http://godville.net/login")
	$divs = _IEFormGetCollection($oIE)
	
	If Not IsObj($divs) Then
		MsgBox(16, " ", ",       .      ,  ...")
		Return
	EndIf
	
	For $olink In $divs
		If $olink.id = "" Then $formid = $olink
	Next
	
	If Not IsObj($formid) Then
		MsgBox(16, " ", '    .  , ,   ,     "!". -    !')
		Return
	EndIf
	
	$temp = _IEGetObjById($oIE, "username")
	_IEFormElementSetValue($temp, $DLogin)
	$temp = _IEGetObjById($oIE, "password")
	_IEFormElementSetValue($temp, $DPass)
	$temp = _IEGetObjById($oIE, "save_login")
	_IEAction($temp, "click")
	
	_IEFormSubmit($formid, 0)
	_IELoadWait($oIE)
	
	$temp = ""
	$temp = _IEGetObjById($oIE, "l_error")
	If IsObj($temp) And StringStripWS($temp.innertext, 8) <> "" Then
		MsgBox(16, " ", "  - " & $temp.innertext)
		Return
	EndIf
	
	IniWrite("lbm.ini", "LoginInfo", "Login", $DLogin)
	IniWrite("lbm.ini", "LoginInfo", "Pass", $DPass)

EndFunc   ;==>_LogoutAndLogin
