#include <pdf_au3_haru.au3>

; :        

Global $pdf, $page


$pdf = AU3_HPDF_New() ;   PDF-

;  1 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


$page = AU3_HPDF_AddPage() ;   
AU3_HPDF_Page_SetSize($page, $HPDF_PAGE_SIZE_A4, $HPDF_PAGE_LANDSCAPE) ;    4,  - 

;AU3_HPDF_Page_SetWidth($page, 5000)  ;    5000 
;AU3_HPDF_Page_SetHeight($page, 5000) ;    5000 

$doc_height = AU3_HPDF_Page_GetHeight($page) ;   
$doc_width = AU3_HPDF_Page_GetWidth($page);   


AU3_HPDF_Page_SetLineWidth($page, 0.5) ;    
AU3_HPDF_Page_SetRGBStroke($page, 255, 0, 0) ;     (,   - )

AU3_HPDF_Page_Rectangle($page, 50, 50, $doc_width - 100, $doc_height - 110) ;  -
AU3_HPDF_Page_Stroke($page) ;   

$page_title = '  PDF'

$def_font = AU3_HPDF_GetFont('Courier-BoldOblique', $CP1251) ;  
AU3_HPDF_Page_SetFontAndSize($page, $def_font, 35) ;   
$tw = AU3_HPDF_Page_TextWidth($page, $page_title) ;    
AU3_HPDF_Page_BeginText($page) ;   
AU3_HPDF_Page_TextOut($page, ($doc_width - $tw) / 2, $doc_height - 50, $page_title) ;     
AU3_HPDF_Page_EndText($page) ;   


AU3_HPDF_Page_BeginText ($page) ;   

$txt_font = AU3_HPDF_GetFont('Courier', $CP1251) ;  

AU3_HPDF_Page_SetFontAndSize ($page, $txt_font, 20) ;   
AU3_HPDF_Page_MoveTextPos($page, 60, $doc_height - 200) ;     
AU3_HPDF_Page_ShowText ($page, '  ') ;     

AU3_HPDF_Page_MoveTextPos ($page, 0, -20) ;     
AU3_HPDF_Page_SetFontAndSize ($page, $txt_font, 13) ;   
AU3_HPDF_Page_ShowText ($page, '  ') ;     

AU3_HPDF_Page_MoveTextPos ($page, 0, -20) ;     
AU3_HPDF_Page_SetFontAndSize ($page, $txt_font, 8) ;   
AU3_HPDF_Page_ShowText ($page, '  ') ;     


$angle1 = 90 ;     
$rad1 = $angle1 / 180 * 3.141592 ;   
AU3_HPDF_Page_SetFontAndSize ($page, $txt_font, 30) ;   

$txt_font = AU3_HPDF_GetFileFont(AU3_HPDF_Get_font_path("Times New Roman", 1, 1, ""), $CP1251);     (      AU3_HPDF_Get_font_path)


AU3_HPDF_Page_SetTextMatrix ($page, cos($rad1), sin($rad1), -sin($rad1), Cos($rad1), $doc_width-100, $doc_height - 500) ;  
AU3_HPDF_Page_SetTextRenderingMode($page,$HPDF_FILL) ;     - $HPDF_FILL
AU3_HPDF_Page_ShowText ($page, ' ');     


$angle1 = 30 ;     
$rad1 = $angle1 / 180 * 3.141592 ;   
AU3_HPDF_Page_SetFontAndSize ($page, $txt_font, 20) ;   
AU3_HPDF_Page_SetTextMatrix ($page, cos($rad1), sin($rad1), -sin($rad1), Cos($rad1), $doc_width-700, $doc_height - 500) ;  
AU3_HPDF_Page_SetTextRenderingMode($page,$HPDF_FILL_THEN_STROKE) ;     - $HPDF_FILL_THEN_STROKE
AU3_HPDF_Page_ShowText ($page, '   30 ');     
AU3_HPDF_Page_EndText ($page) ;   


AU3_HPDF_Page_SetTextRenderingMode($page,$HPDF_FILL) ;     - $HPDF_FILL ()

;   
AU3_HPDF_Page_SetFontAndSize($page, $txt_font, 10) ;   
$tw = AU3_HPDF_Page_TextWidth($page, ' 1') ;    
AU3_HPDF_Page_BeginText($page) ;   
AU3_HPDF_Page_TextOut($page, ($doc_width - $tw) / 2, 70, ' 1') ;     
AU3_HPDF_Page_EndText($page) ;   


;$image = AU3_HPDF_LoadJpegImageFromFile('1.jpg') ;   JPG
;AU3_HPDF_Page_DrawImage ($page, $image, 100, 300, AU3_HPDF_Image_GetWidth($image), AU3_HPDF_Image_GetHeight ($image)) ;   


;  2 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
$page2 = AU3_HPDF_AddPage() ;   

AU3_HPDF_Page_SetSize($page2, $HPDF_PAGE_SIZE_A4, $HPDF_PAGE_LANDSCAPE) ;    4,  - 
;AU3_HPDF_Page_SetWidth($page, 5000)  ;    5000 
;AU3_HPDF_Page_SetHeight($page, 5000) ;    5000 

$doc_height2 = AU3_HPDF_Page_GetHeight($page2) ;   
$doc_width2 = AU3_HPDF_Page_GetWidth($page2);   

AU3_HPDF_Page_SetLineWidth($page2, 5) ;    - 5
AU3_HPDF_Page_SetRGBStroke($page2, 99, 0, 198) ;    - 

AU3_HPDF_Page_Circle($page2, 200, 250, 70) ;  
AU3_HPDF_Page_Stroke($page2) ;   

AU3_HPDF_Page_SetDash($page2,'8,7',2,1) ;   ""    
AU3_HPDF_Page_SetLineWidth($page2, 5);    - 5
AU3_HPDF_Page_SetRGBStroke($page2, 255, 255, 0);    - 
AU3_HPDF_Page_Rectangle($page2, 50, 50, $doc_width2 - 500, $doc_height2 - 110);  -
AU3_HPDF_Page_Stroke($page2);   

AU3_HPDF_Page_SetDash($page2,'8,7,3,2',1,1) ;   ""    
AU3_HPDF_Page_SetLineWidth($page2, 1) ;    - 1
AU3_HPDF_Page_SetRGBStroke($page2, 0, 0, 0) ;    - 
AU3_HPDF_Page_MoveTo($page2, 500, 500) ;       500,500
AU3_HPDF_Page_LineTo($page2, 0, 0) ;         0,0

AU3_HPDF_Page_Stroke($page2) ;   

;   
AU3_HPDF_Page_SetFontAndSize($page2, $txt_font, 10) ;   
$tw = AU3_HPDF_Page_TextWidth($page2, ' 2') ;    
AU3_HPDF_Page_BeginText($page2) ;   
AU3_HPDF_Page_TextOut($page2, ($doc_width2 - $tw) / 2, 70, ' 2') ;     
AU3_HPDF_Page_EndText($page2) ;   


;   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
AU3_HPDF_SaveToFile("test0") ;  PDF-,    
AU3_HPDF_Free() ;  

