; #INDEX# =======================================================================================================================
; Title .........: pdf au3 haru UDF
; Usage..........: #include 'pdf_au3_haru.au3'
; AutoIt Version : 3.3.8.1+
; File Name......: pdf_au3_haru.au3
; File Version...: 0.3
; Site...........: autoit-script.ru
; Language ......: Russian
; Description ...:  au3-    libharu -    PDF- libharu.org
;~				   UDF  libharu,     pdf_au3_haru.dll (    UDF)
;~				   UDF    PDF-,  , ,  .
; Author(s) .....: WSWR
; Date ..........: 2015
; ===============================================================================================================================


;   PDF-                        ()

Const $HPDF_PAGE_SIZE_LETTER = 0 ; 8.5 x 11 (inches)     612 x 792
Const $HPDF_PAGE_SIZE_LEGAL = 1 ; 8.5 x 14 (inches)     612 x 1008
Const $HPDF_PAGE_SIZE_A3 = 2 ; 297 x 420 (mm)        841.89 x 1199.551
Const $HPDF_PAGE_SIZE_A4 = 3 ; 210 x 297 (mm)        595.276 x 841.89
Const $HPDF_PAGE_SIZE_A5 = 4 ; 148 x 210 (mm)        419.528 x 595.276
Const $HPDF_PAGE_SIZE_B4 = 5 ; 250 x 353 (mm)        708.661 x 1000.63
Const $HPDF_PAGE_SIZE_B5 = 6 ; 176 x 250 (mm)        498.898 x 708.661
Const $HPDF_PAGE_SIZE_EXECUTIVE = 7 ; 7.25 x 10.5 (inches)  522 x 756
Const $HPDF_PAGE_SIZE_US4x6 = 8 ; 4 x 6 (inches)        288 x 432
Const $HPDF_PAGE_SIZE_US4x8 = 9 ; 4 x 8 (inches)        288 x 576
Const $HPDF_PAGE_SIZE_US5x7 = 10 ; 5 x 7 (inches)        360 x 504
Const $HPDF_PAGE_SIZE_COMM10 = 11 ; 4.125 x 9.5 (inches)  297 x 684


;  

Const $HPDF_PAGE_PORTRAIT = 0 ; 
Const $HPDF_PAGE_LANDSCAPE = 1 ; 


; ,   AU3_HPDF_GetFont

;~ Courier
;~ Courier-Bold
;~ Courier-Oblique
;~ Courier-BoldOblique
;~ Helvetica
;~ Helvetica-Bold
;~ Helvetica-Oblique
;~ Helvetica-BoldOblique
;~ Times-Roman
;~ Times-Bold
;~ Times-Italic
;~ Times-BoldItalic
;~ Symbol
;~ ZapfDingbats


; 

Const $StandardEncoding = 'StandardEncoding' ; ,   
Const $CP1251 = 'CP1251' ;  


;   

$HPDF_FILL = 0
$HPDF_STROKE = 1
$HPDF_FILL_THEN_STROKE = 2
$HPDF_INVISIBLE = 3
$HPDF_FILL_CLIPPING = 4
$HPDF_STROKE_CLIPPING = 5
$HPDF_FILL_STROKE_CLIPPING = 6
$HPDF_CLIPPING = 7
$HPDF_RENDERING_MODE_EOF = 8


;   

$HPDF_TALIGN_LEFT = 0
$HPDF_TALIGN_RIGHT = 1
$HPDF_TALIGN_CENTER = 2
$HPDF_TALIGN_JUSTIFY = 3



;  

;~ AU3_HPDF_Get_font_path
;~ AU3_HPDF_Page_TextRect
;~ AU3_HPDF_Page_SetTextRenderingMode
;~ AU3_HPDF_Page_SetTextRise
;~ AU3_HPDF_Page_GetCurrentTextPosX
;~ AU3_HPDF_Page_GetCurrentTextPosY
;~ AU3_HPDF_Page_GetCurrentPosX
;~ AU3_HPDF_Page_GetCurrentPosY
;~ AU3_HPDF_Page_MoveTextPos
;~ AU3_HPDF_Page_MoveTextPos2
;~ AU3_HPDF_Page_ShowText
;~ AU3_HPDF_Page_TextOut
;~ AU3_HPDF_Page_EndText
;~ AU3_HPDF_Page_BeginText
;~ AU3_HPDF_Page_SetTextMatrix
;~ AU3_HPDF_Page_TextWidth
;~ AU3_HPDF_Page_SetFontAndSize
;~ AU3_HPDF_GetFont
;~ AU3_HPDF_GetFileFont
;~ AU3_HPDF_Page_DrawImage
;~ AU3_HPDF_Image_GetWidth
;~ AU3_HPDF_Image_GetHeight
;~ AU3_HPDF_LoadJpegImageFromFile
;~ AU3_HPDF_LoadPngImageFromFile
;~ AU3_HPDF_LoadPngImageFromFile2
;~ AU3_HPDF_Page_Eofill
;~ AU3_HPDF_Page_FillStroke
;~ AU3_HPDF_Page_EofillStroke
;~ AU3_HPDF_Page_Fill
;~ AU3_HPDF_Page_SetRGBFill
;~ AU3_HPDF_Page_SetDash
;~ AU3_HPDF_Page_SetRGBStroke
;~ AU3_HPDF_Page_SetLineWidth
;~ AU3_HPDF_Page_MoveTo
;~ AU3_HPDF_Page_LineTo
;~ AU3_HPDF_Page_Circle
;~ AU3_HPDF_Page_Ellipse
;~ AU3_HPDF_Page_Arc
;~ AU3_HPDF_Page_Rectangle
;~ AU3_HPDF_Page_Stroke
;~ AU3_HPDF_SaveToFile
;~ AU3_HPDF_Page_SetSize
;~ AU3_HPDF_Page_SetRotate
;~ AU3_HPDF_Page_GetHeight
;~ AU3_HPDF_Page_GetWidth
;~ AU3_HPDF_Page_SetWidth
;~ AU3_HPDF_Page_SetHeight
;~ AU3_HPDF_AddPage
;~ AU3_HPDF_New
;~ AU3_HPDF_Free

; ===============================================================================================================================

Global $pdf_au3_haru_dll, $pdf_au3_haru_dllname

$pdf_au3_haru_dllname = @ScriptDir & '\pdf_au3_haru.dll'
If Not FileExists($pdf_au3_haru_dllname) Then
	MsgBox(0, '', 'pdf_au3_haru.dll !')
	Exit
EndIf
$pdf_au3_haru_dll = DllOpen($pdf_au3_haru_dllname)

; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Get_font_path
; Description ...:        
; Syntax ........: AU3_HPDF_Get_font_path($sName, $bold, $italic, $font_dir_path)
; Parameters ....: $sName -   - string value, $bold - 1,     - integer value, $italic - 1,    - integer value,
; $font_dir_path -      ( C:\Windows\Fonts\,     - "",       ) - wstring value
; Return values .:  - Returns string data,  -   
; Author ........: WSWR
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:

Func AU3_HPDF_Get_font_path($sName, $bold, $italic, $font_dir_path)
	Local $aPos
	$aPos = DllCall($pdf_au3_haru_dll, 'wstr:cdecl', 'AU3_HPDF_Get_font_path', 'str', $sName, 'int', $bold, 'int', $italic, 'wstr', $font_dir_path)
	Return $aPos[0]
EndFunc

; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_TextRect
; Description ...:        
; Syntax ........: AU3_HPDF_Page_TextRect($p, $Left, $Top, $Right, $Bottom, $text, $align)
; Parameters ....: $p -   - integer value, $Left, $Top, $Right, $Bottom -     - integer value, $text -  - string value, $align -    - integer value
; Return values .: 1
; Author ........: WSWR
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_TextRect($p, $Left, $Top, $Right, $Bottom, $text, $align)
	DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_TextRect', 'int', $p, 'int', $Left, 'int', $Top, 'int', $Right, 'int', $Bottom, 'str', $text, 'int', $align)
EndFunc   ;==>AU3_HPDF_Page_TextRect


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_SetTextRenderingMode
; Description ...:       
; Syntax ........: AU3_HPDF_Page_SetTextRenderingMode($p, $mode)
; Parameters ....: $p -   - integer value, $mode -    - integer value
; Return values .: 1
; Author ........: WSWR
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_SetTextRenderingMode($p, $mode)
	DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_SetTextRenderingMode', 'int', $p, 'int', $mode)
EndFunc   ;==>AU3_HPDF_Page_SetTextRenderingMode


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_SetTextRise
; Description ...:            
; Syntax ........: AU3_HPDF_Page_SetTextRise($p, $value)
; Parameters ....: $p -   - integer value, $value -   - integer value
; Return values .: 1
; Author ........: WSWR
; Modified ......:
; Remarks .......:        
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_SetTextRise($p, $value)
	DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_SetTextRise', 'int', $p, 'int', $value)
EndFunc   ;==>AU3_HPDF_Page_SetTextRise


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_GetCurrentTextPosX
; Description ...:  X -        
; Syntax ........: AU3_HPDF_Page_GetCurrentTextPosX($p)
; Parameters ....: $p -   - integer value.
; Return values .:  - Returns integer data
; Author ........: WSWR
; Modified ......:
; Remarks .......: :       
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_GetCurrentTextPosX($p)
	Local $aPos
	$aPos = DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_GetCurrentTextPosX', 'int', $p)
	Return $aPos[0]
EndFunc   ;==>AU3_HPDF_Page_GetCurrentTextPosX


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_GetCurrentTextPosY
; Description ...:  Y -        
; Syntax ........: AU3_HPDF_Page_GetCurrentTextPosY($p)
; Parameters ....: $p -   - integer value.
; Return values .:  - Returns integer data
; Author ........: WSWR
; Modified ......:
; Remarks .......: :       
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_GetCurrentTextPosY($p)
	Local $aPos
	$aPos = DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_GetCurrentTextPosY', 'int', $p)
	Return $aPos[0]
EndFunc   ;==>AU3_HPDF_Page_GetCurrentTextPosY


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_GetCurrentPosX
; Description ...:  X -       
; Syntax ........: AU3_HPDF_Page_GetCurrentPosX($p)
; Parameters ....: $p -   - integer value.
; Return values .:  - Returns integer data
; Author ........: WSWR
; Modified ......:
; Remarks .......: :       
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_GetCurrentPosX($p)
	Local $aPos
	$aPos = DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_GetCurrentPosX', 'int', $p)
	Return $aPos[0]
EndFunc   ;==>AU3_HPDF_Page_GetCurrentPosX


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_GetCurrentPosY
; Description ...:  Y -       
; Syntax ........: AU3_HPDF_Page_GetCurrentPosY($p)
; Parameters ....: $p -   - integer value.
; Return values .:  - Returns integer data
; Author ........: WSWR
; Modified ......:
; Remarks .......: :       
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_GetCurrentPosY($p)
	Local $aPos
	$aPos = DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_GetCurrentPosY', 'int', $p)
	Return $aPos[0]
EndFunc   ;==>AU3_HPDF_Page_GetCurrentPosY


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_MoveTextPos
; Description ...:     ,    
; Syntax ........: AU3_HPDF_Page_MoveTextPos($p, $x, $y)
; Parameters ....: $p -   - integer value, $x -  X -   , $y -  Y -   
; Return values .: 1
; Author ........: WSWR
; Modified ......:
; Remarks .......:     (x1, y1),     (x1 + , y1 + )
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_MoveTextPos($p, $x, $y)
	DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_MoveTextPos', 'int', $p, 'int', $x, 'int', $y)
	Return 1
EndFunc   ;==>AU3_HPDF_Page_MoveTextPos


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_MoveTextPos2
; Description ...:     ,    
; Syntax ........: AU3_HPDF_Page_MoveTextPos2($p, $x, $y)
; Parameters ....: $p -   - integer value, $x -  X -    - integer value, $y -  Y -    - integer value
; Return values .: 1
; Author ........: WSWR
; Modified ......:
; Remarks .......:     (x1, y1),     (x1 + , y1 + )   AU3_HPDF_Page_MoveTextPos 
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_MoveTextPos2($p, $x, $y) ;
	DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_MoveTextPos2', 'int', $p, 'int', $x, 'int', $y)
	Return 1
EndFunc   ;==>AU3_HPDF_Page_MoveTextPos2


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_ShowText
; Description ...:        
; Syntax ........: AU3_HPDF_Page_ShowText($p, $text)
; Parameters ....: $p -   - integer value, $text -     - string value
; Return values .: 1
; Author ........: WSWR
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_ShowText($p, $text)
	DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_ShowText', 'int', $p, 'str', $text)
	Return 1
EndFunc   ;==>AU3_HPDF_Page_ShowText


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_TextOut
; Description ...:        
; Syntax ........: AU3_HPDF_Page_TextOut($p, $x, $y, $text)
; Parameters ....: $p -   - integer value, $x - X -    - integer value, $y - Y -    - integer value, $text -     - string value
; Return values .: 1
; Author ........: WSWR
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_TextOut($p, $x, $y, $text)
	DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_TextOut', 'int', $p, 'int', $x, 'int', $y, 'str', $text)
	Return 1
EndFunc   ;==>AU3_HPDF_Page_TextOut


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_EndText
; Description ...:      
; Syntax ........: AU3_HPDF_Page_EndText($p)
; Parameters ....: $p -   - integer value.
; Return values .: 1
; Author ........: WSWR
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_EndText($p)
	DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_EndText', 'int', $p)
	Return 1
EndFunc   ;==>AU3_HPDF_Page_EndText


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_BeginText
; Description ...:      
; Syntax ........: AU3_HPDF_Page_BeginText($p)
; Parameters ....: $p -   - integer value.
; Return values .: 1
; Author ........: WSWR
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_BeginText($p)
	DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_BeginText', 'int', $p)
	Return 1
EndFunc   ;==>AU3_HPDF_Page_BeginText


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_SetTextMatrix
; Description ...: ?
; Syntax ........: AU3_HPDF_Page_SetTextMatrix($p,$a,$b,$c,$d,$x,$y)
; Parameters ....: $p -   - integer value, a - double value, b - double value, c - double value, d - double value, x - X-   - integer value, y  - Y-   - integer value
; Return values .: 1
; Author ........: WSWR
; Modified ......:
; Remarks .......: :       
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_SetTextMatrix($p, $a, $b, $c, $d, $x, $y)
	DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_SetTextMatrix', 'int', $p, 'double', $a, 'double', $b, 'double', $c, 'double', $d, 'int', $x, 'int', $y)
	Return 1
EndFunc   ;==>AU3_HPDF_Page_SetTextMatrix


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_TextWidth
; Description ...:       
; Syntax ........: AU3_HPDF_Page_TextWidth($p, $text)
; Parameters ....: $p -   - integer value, $text -     - string value
; Return values .:  - Returns integer data
; Author ........: WSWR
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_TextWidth($p, $text)
	Local $at_width
	$at_width = DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_TextWidth', 'int', $p, 'str', $text)
	Return $at_width[0]
EndFunc   ;==>AU3_HPDF_Page_TextWidth


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_SetFontAndSize
; Description ...:         
; Syntax ........: AU3_HPDF_Page_SetFontAndSize($p, $i, $size)
; Parameters ....: $p -   - integer value, $i -   - integer value, $size -   - integer value
; Return values .: 1
; Author ........: WSWR
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_SetFontAndSize($p, $i, $size)
	DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_SetFontAndSize', 'int', $p, 'int', $i, 'int', $size)
	Return 1
EndFunc   ;==>AU3_HPDF_Page_SetFontAndSize


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_GetFont
; Description ...:       
; Syntax ........: AU3_HPDF_GetFont($p, $encoding_name)
; Parameters ....: $font_name -   - string value, $encoding_name -   - string value
; Return values .:  - Returns integer data
; Author ........: WSWR
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_GetFont($font_name, $encoding_name)
	Local $aFont
	$aFont = DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_GetFont', 'str', $font_name, 'str', $encoding_name)
	Return $aFont[0]
EndFunc   ;==>AU3_HPDF_GetFont


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_GetFileFont
; Description ...:        
; Syntax ........: AU3_HPDF_GetFileFont($file_name, $encoding_name)
; Parameters ....: file_name -     - string value, $encoding_name -   - string value
; Return values .:  - Returns integer data
; Author ........: WSWR
; Modified ......:
; Remarks .......:   .ttf
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_GetFileFont($file_name, $encoding_name)
	Local $aFont
	$aFont = DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_GetFileFont', 'str', $file_name, 'str', $encoding_name)
	Return $aFont[0]
EndFunc   ;==>AU3_HPDF_GetFileFont


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_DrawImage
; Description ...:             
; Syntax ........: AU3_HPDF_Page_DrawImage($p, $image, $x, $y, $width, $height)
; Parameters ....: $p -   - integer value, $image -   - integer value, $x - X-   - integer value, $y - Y-   - integer value, $width -   - integer value, $height -   - integer value
; Return values .: 1
; Author ........: WSWR
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_DrawImage($p, $image, $x, $y, $width, $height)
	DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_DrawImage', 'int', $p, 'int', $image, 'int', $x, 'int', $y, 'int', $width, 'int', $height)
	Return 1
EndFunc   ;==>AU3_HPDF_Page_DrawImage


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Image_GetWidth
; Description ...:     
; Syntax ........: AU3_HPDF_Image_GetWidth($image)
; Parameters ....: $image -   - integer value
; Return values .:  - Returns integer data
; Author ........: WSWR
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Image_GetWidth($image)
	Local $aim_width
	$aim_width = DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Image_GetWidth', 'int', $image)
	Return $aim_width[0]
EndFunc   ;==>AU3_HPDF_Image_GetWidth


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Image_GetHeight
; Description ...:     
; Syntax ........: AU3_HPDF_Image_GetHeight($image)
; Parameters ....: $image -   - integer value
; Return values .:  - Returns integer data
; Author ........: WSWR
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Image_GetHeight($image)
	Local $aim_height
	$aim_height = DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Image_GetHeight', 'int', $image)
	Return $aim_height[0]
EndFunc   ;==>AU3_HPDF_Image_GetHeight


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_LoadJpegImageFromFile
; Description ...:   JPG
; Syntax ........: AU3_HPDF_LoadJpegImageFromFile($filename)
; Parameters ....: $filename -    JPG - string value
; Return values .:  - Returns integer data
; Author ........: WSWR
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_LoadJpegImageFromFile($filename)
	Local $aJpgImage
	$aJpgImage = DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_LoadJpegImageFromFile', 'str', $filename)
	Return $aJpgImage[0]
EndFunc   ;==>AU3_HPDF_LoadJpegImageFromFile


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_LoadPngImageFromFile2
; Description ...:   PNG ( 2? )
; Syntax ........: AU3_HPDF_LoadPngImageFromFile2($filename)
; Parameters ....: $filename -    PNG - string value
; Return values .:  - Returns integer data
; Author ........: WSWR
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_LoadPngImageFromFile2($filename)
	Local $aPngImage
	$aPngImage = DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_LoadPngImageFromFile2', 'str', $filename)
	Return $aPngImage[0]
EndFunc   ;==>AU3_HPDF_LoadPngImageFromFile2


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_LoadPngImageFromFile
; Description ...:   PNG
; Syntax ........: AU3_HPDF_LoadPngImageFromFile($filename)
; Parameters ....: $filename -    PNG - string value
; Return values .:  - Returns integer data
; Author ........: WSWR
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_LoadPngImageFromFile($filename)
	Local $aPngImage
	$aPngImage = DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_LoadPngImageFromFile', 'str', $filename)
	Return $aPngImage[0]
EndFunc   ;==>AU3_HPDF_LoadPngImageFromFile


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_Eofill
; Description ...: ?
; Syntax ........: AU3_HPDF_Page_Eofill($p)
; Parameters ....: $p -   - integer value
; Return values .: 1
; Author ........: WSWR
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_Eofill($p)
	DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_Eofill', 'int', $p)
	Return 1
EndFunc   ;==>AU3_HPDF_Page_Eofill


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_FillStroke
; Description ...: ?
; Syntax ........: AU3_HPDF_Page_FillStroke($p)
; Parameters ....: $p -   - integer value
; Return values .: 1
; Author ........: WSWR
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_FillStroke($p)
	DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_FillStroke', 'int', $p)
	Return 1
EndFunc   ;==>AU3_HPDF_Page_FillStroke


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_EofillStroke
; Description ...: ?
; Syntax ........: AU3_HPDF_Page_EofillStroke($p)
; Parameters ....: $p -   - integer value
; Return values .: 1
; Author ........: WSWR
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_EofillStroke($p)
	DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_EofillStroke', 'int', $p)
	Return 1
EndFunc   ;==>AU3_HPDF_Page_EofillStroke


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_Fill
; Description ...: ?
; Syntax ........: AU3_HPDF_Page_Fill($p)
; Parameters ....: $p -   - integer value
; Return values .: 1
; Author ........: WSWR
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_Fill($p)
	DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_Fill', 'int', $p)
	Return 1
EndFunc   ;==>AU3_HPDF_Page_Fill


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_SetRGBFill
; Description ...:         (RGB)
; Syntax ........: AU3_HPDF_Page_SetRGBFill($p, $r, $g, $b)
; Parameters ....: $p -   - integer value, $r -    - integer value, $g -    - integer value, $b -    - integer value
; Return values .: 1
; Author ........: WSWR
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_SetRGBFill($p, $r, $g, $b)
	DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_SetRGBFill', 'int', $p, 'int', $r, 'int', $g, 'int', $b)
	Return 1
EndFunc   ;==>AU3_HPDF_Page_SetRGBFill


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_SetDash
; Description ...:   ""       
; Syntax ........: AU3_HPDF_Page_SetDash($p, $ptn, $num_param, $phase)
; Parameters ....: $p -   - integer value, $ptn - string value, $num_param - integer value, $phase - integer value
; Return values .: 1
; Author ........: WSWR
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_SetDash($p, $ptn, $num_param, $phase)
	DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_SetDash', 'int', $p, 'str', $ptn, 'int', $num_param, 'int', $phase)
	Return 1
EndFunc   ;==>AU3_HPDF_Page_SetDash


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_SetRGBStroke
; Description ...:         (RGB)
; Syntax ........: AU3_HPDF_Page_SetRGBStroke($p, $r, $g, $b)
; Parameters ....: $p -   - integer value, $r -    - integer value, $g -    - integer value, $b -    - integer value
; Return values .: 1
; Author ........: WSWR
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_SetRGBStroke($p, $r, $g, $b)
	DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_SetRGBStroke', 'int', $p, 'int', $r, 'int', $g, 'int', $b)
	Return 1
EndFunc   ;==>AU3_HPDF_Page_SetRGBStroke


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_SetLineWidth
; Description ...:        
; Syntax ........: AU3_HPDF_Page_SetLineWidth($p, $line_width)
; Parameters ....: $p -   - integer value, $line_width -   - integer value
; Return values .: 1
; Author ........: WSWR
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_SetLineWidth($p, $line_width)
	DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_SetLineWidth', 'int', $p, 'double', $line_width)
	Return 1
EndFunc   ;==>AU3_HPDF_Page_SetLineWidth


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_MoveTo
; Description ...:         
; Syntax ........: AU3_HPDF_Page_MoveTo($p, $x, $y)
; Parameters ....: $p -   - integer value, $x - X- - integer value, $y - Y- - integer value
; Return values .: 1
; Author ........: WSWR
; Modified ......:
; Remarks .......: :       
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_MoveTo($p, $x, $y)
	DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_MoveTo', 'int', $p, 'int', $x, 'int', $y)
	Return 1
EndFunc   ;==>AU3_HPDF_Page_MoveTo


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_LineTo
; Description ...:            
; Syntax ........: AU3_HPDF_Page_LineTo($p, $x, $y)
; Parameters ....: $p -   - integer value, $x - X- - integer value, $y - Y- - integer value
; Return values .: 1
; Author ........: WSWR
; Modified ......:
; Remarks .......: :       
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_LineTo($p, $x, $y)
	DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_LineTo', 'int', $p, 'int', $x, 'int', $y)
	Return 1
EndFunc   ;==>AU3_HPDF_Page_LineTo


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_Circle
; Description ...:          
; Syntax ........: AU3_HPDF_Page_Circle($p, $x, $y, $ray)
; Parameters ....: $p -   - integer value, $x - X- - integer value, $y - Y- - integer value, $ray -   - integer value
; Return values .: 1
; Author ........: WSWR
; Modified ......:
; Remarks .......: :       
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_Circle($p, $x, $y, $ray)
	DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_Circle', 'int', $p, 'int', $x, 'int', $y, 'int', $ray)
	Return 1
EndFunc   ;==>AU3_HPDF_Page_Circle


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_Ellipse
; Description ...:          
; Syntax ........: AU3_HPDF_Page_Ellipse($p, $x, $y, $xray, $yray)
; Parameters ....: $p -   - integer value, $x - X- - integer value, $y - Y- - integer value, $xray -    - integer value, $yray -     - integer value
; Return values .: 1
; Author ........: WSWR
; Modified ......:
; Remarks .......: :       
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_Ellipse($p, $x, $y, $xray, $yray)
	DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_Ellipse', 'int', $p, 'int', $x, 'int', $y, 'int', $xray, 'int', $yray)
	Return 1
EndFunc   ;==>AU3_HPDF_Page_Ellipse


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_Arc
; Description ...:          
; Syntax ........: AU3_HPDF_Page_Arc($p, $x, $y, $ray, $ang1, $ang2)
; Parameters ....: $p -   - integer value, $x - X- - integer value, $y - Y- - integer value, $ang1 -    - integer value, $ang2 -     - integer value
; Return values .: 1
; Author ........: WSWR
; Modified ......:
; Remarks .......: :       ; $ang2   ,  $ang1
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_Arc($p, $x, $y, $ray, $ang1, $ang2)
	DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_Arc', 'int', $p, 'int', $x, 'int', $y, 'int', $ray, 'int', $ang1, 'int', $ang2)
	Return 1
EndFunc   ;==>AU3_HPDF_Page_Arc


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_Rectangle
; Description ...:          
; Syntax ........: AU3_HPDF_Page_Rectangle($p, $x, $y, $w, $h)
; Parameters ....: $p -   - integer value, $x - X- - integer value, $y - Y- - integer value, $w -  - integer value, $h -   - integer value
; Return values .: 1
; Author ........: WSWR
; Modified ......:
; Remarks .......: :       
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_Rectangle($p, $x, $y, $w, $h)
	DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_Rectangle', 'int', $p, 'int', $x, 'int', $y, 'int', $w, 'int', $h)
	Return 1
EndFunc   ;==>AU3_HPDF_Page_Rectangle


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_Stroke
; Description ...:       
; Syntax ........: AU3_HPDF_Page_Stroke($p)
; Parameters ....: $p -   - integer value
; Return values .: 1
; Author ........: WSWR
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_Stroke($p)
	DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_Stroke', 'int', $p)
	Return 1
EndFunc   ;==>AU3_HPDF_Page_Stroke


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_SaveToFile
; Description ...:  
; Syntax ........: AU3_HPDF_SaveToFile($docname)
; Parameters ....: $docname -   - string value
; Return values .: 1
; Author ........: WSWR
; Modified ......:
; Remarks .......:  (.pdf)   ,  
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_SaveToFile($docname)
	DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_SaveToFile', 'str', $docname)
	Return 1
EndFunc   ;==>AU3_HPDF_SaveToFile


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_SetSize
; Description ...:      
; Syntax ........: AU3_HPDF_Page_SetSize($p, $size, $orient)
; Parameters ....: $p -   - integer value, $size -   - integer value, $orient -   - integer value
; Return values .: 1
; Author ........: WSWR
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_SetSize($p, $size, $orient)
	DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_SetSize', 'int', $p, 'int', $size, 'int', $orient)
	Return 1
EndFunc   ;==>AU3_HPDF_Page_SetSize


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_SetRotate
; Description ...:   
; Syntax ........: AU3_HPDF_Page_SetRotate($p, $angle)
; Parameters ....: $p -   - integer value, $angle -    - integer value
; Return values .: 1
; Author ........: WSWR
; Modified ......:
; Remarks .......:  $angle    90 
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_SetRotate($p, $angle)
	DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_SetRotate', 'int', $p, 'int', $angle)
	Return 1
EndFunc   ;==>AU3_HPDF_Page_SetRotate


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_GetHeight
; Description ...:     ( )
; Syntax ........: AU3_HPDF_Page_GetHeight($p)
; Parameters ....: $p -   - integer value
; Return values .:  - Returns integer data
; Author ........: WSWR
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_GetHeight($p)
	$adoc_height = DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_GetHeight', 'int', $p)
	Return $adoc_height[0]
EndFunc   ;==>AU3_HPDF_Page_GetHeight


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_GetWidth
; Description ...:     ( )
; Syntax ........: AU3_HPDF_Page_GetWidth($p)
; Parameters ....: $p -   - integer value
; Return values .:  - Returns integer data
; Author ........: WSWR
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_GetWidth($p)
	$adoc_width = DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_GetWidth', 'int', $p)
	Return $adoc_width[0]
EndFunc   ;==>AU3_HPDF_Page_GetWidth


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_SetWidth
; Description ...:     ( )
; Syntax ........: AU3_HPDF_Page_SetWidth($p)
; Parameters ....: $p -   - integer value
; Return values .: 1
; Author ........: WSWR
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_SetWidth($p, $iWidth)
	DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_SetWidth', 'int', $p, 'int', $iWidth)
	Return 1
EndFunc   ;==>AU3_HPDF_Page_SetWidth


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Page_SetHeight
; Description ...:     ( )
; Syntax ........: AU3_HPDF_Page_SetHeight($p)
; Parameters ....: $p -   - integer value
; Return values .: 1
; Author ........: WSWR
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Page_SetHeight($p, $iHeight)
	DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Page_SetHeight', 'int', $p, 'int', $iHeight)
	Return 1
EndFunc   ;==>AU3_HPDF_Page_SetHeight


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_AddPage
; Description ...:   PDF-  
; Syntax ........: AU3_HPDF_AddPage()
; Parameters ....:
; Return values .:  - Returns integer data
; Author ........: WSWR
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_AddPage()
	$apage = DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_AddPage')
	Return $apage[0]
EndFunc   ;==>AU3_HPDF_AddPage


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_New
; Description ...:   PDF-
; Syntax ........: AU3_HPDF_New()
; Parameters ....:
; Return values .:  - Returns integer data
; Author ........: WSWR
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_New()
	$apdf = DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_New')
	Return $apdf[0]
EndFunc   ;==>AU3_HPDF_New


; #FUNCTION# ====================================================================================================================
; Name ..........: AU3_HPDF_Free
; Description ...:  
; Syntax ........: AU3_HPDF_Free()
; Parameters ....:
; Return values .: 1
; Author ........: WSWR
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......:
Func AU3_HPDF_Free()
	DllCall($pdf_au3_haru_dll, 'int:cdecl', 'AU3_HPDF_Free')
	Return 1
EndFunc   ;==>AU3_HPDF_Free