#NoTrayIcon
#RequireAdmin
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_icon=Icon.ico
#AutoIt3Wrapper_Compression=4
#AutoIt3Wrapper_UseX64=n
#AutoIt3Wrapper_Res_Comment=Program made by G.Sandler
#AutoIt3Wrapper_Res_Fileversion=1.7.0.0
#AutoIt3Wrapper_Res_LegalCopyright=Copyright  2011-2013 G.Sandler (CreatoR), www.autoit-script.ru. All rights reserved.
#AutoIt3Wrapper_Res_requestedExecutionLevel=requireAdministrator
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=y
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****

#Region Header

#CS Info
	Name: 		AutoIt Path Switcher
	Author: 	G.Sandler (CreatoR)
	
	History:
			v1.7
			+ Added AutoIt version suffix to "Run script" option.
			* Fixed issue when "Run x64" item was added on x86 system.
			* Fixed issue with wrong detected AutoIt path (beacuse the new usage of AutoIt3Wrapper).
			* Fixed issue with compiled AutoIt_Path_Switcher.exe as x64.
			
			v1.6
			* Run script option in shell context menu now executes AutoIt3Wrapper.exe (if available) instead of AutoIt3.exe.
				- If AutoIt3Wrapper.exe not found, and AutoIt3_x64.exe found, then additional item added to the shell context menu.
			* Added icon to the compiled version.
			
			v1.5
			* Fixed issue with administrator rights.
			* Fixed bug with hard crash when config file not loaded properly.
			
			v1.4
			+ AutoIt 3.3.6.1 compatible.
			+ x64 system compatible.
			+ AutoIt3Wrapper support.
			* Fixed an issue when applying language.
			* Code cleanup.
			
			v1.3
			* Improved icon refresh for au3-files after association procedure.
			+ Added option to refresh system icons cache.
			+ Added option to open settings file from program's main window.
			* Code cleanup.
#CE

#EndRegion Header

#Region Global Variables

Global Const $GUI_CHECKED 				= 1
Global Const $TRAY_DEFAULT 				= 512
Global Const $TRAY_EVENT_PRIMARYDOWN	= -7
Global Const $GUI_EVENT_CLOSE 			= -3
Global Const $GUI_EVENT_MINIMIZE 		= -4
Global Const $SS_RIGHT 					= 0x2
Global Const $CB_DELETESTRING 			= 0x144
Global Const $CB_GETCOUNT 				= 0x146
Global Const $CB_GETCURSEL 				= 0x147
Global Const $CB_GETLBTEXT 				= 0x148
Global Const $CB_GETLBTEXTLEN 			= 0x149

Global Const $SHCNE_ASSOCCHANGED 		= 0x8000000
Global Const $SHCNF_FLUSH 				= 0x1000
Global Const $SHCNF_IDLIST 				= 0x0

Global $Lang_Items[1]
Global $ContextMenu_Ctrl

Global $Config_File 				= StringTrimRight(@ScriptFullPath, 3) & "ini"

Global $AppLang						= IniRead($Config_File, "Main", "Language", "English")
Global $a_Msgs						= Translate_Proc($AppLang)

Global $AppName 					= $a_Msgs[1]
Global $AppVer 						= "v"

If @Compiled Then
	$AppVer &= StringRegExpReplace(FileGetVersion(@ScriptFullPath), '^([0-9]+(?:[\d.]+[1-9]+0?|[0-9.]{2})?).*$', '\1')
Else
	$AppVer &= StringRegExpReplace(FileRead(@ScriptFullPath), '(?si).*?Res_Fileversion=([0-9]+(?:[\d.]+[1-9]+0?|[0-9.]{2})?).*', '\1')
EndIf

Global $sRegistry_Key				= "HKLM\SOFTWARE\AutoIt v3\AutoIt"
Global $OSArch						= Execute("@OSArch")

If $OSArch = "" Then
	$OSArch							= Execute("@ProcessorArch")
EndIf

If $OSArch <> "x86" Or _OSIs64Bit() Then
	$sRegistry_Key 					= "HKLM\SOFTWARE\Wow6432Node\AutoIt v3\AutoIt"
EndIf

Global $Read_Default_Action 		= RegRead("HKCR\AutoIt3Script\Shell", "")
Global $Set_Local_Compiler			= RegRead("HKCR\AutoIt3Script\Shell\Compile With Local Settings\Command", "")
Global $Refresh_Icons				= IniRead($Config_File, "Main", "Refresh Icons", 1)
Global $AutExe_Command				= StringRegExpReplace(RegRead("HKCR\AutoIt3Script\Shell\Run\Command", ""), '\\(SciTE\\AutoIt3Wrapper\\)?[^\\]*$|"', '')
Global $Combo_Data					= GetAutoItPaths($Config_File, "AutoIt Paths")

If Not IsAdmin() Then
	MsgBox(262144+16, $AppName, StringFormat($a_Msgs[31]))
	Exit
EndIf

#EndRegion Global Variables

#Region GUI Creation Part

$GUI = GUICreate($AppName & " - " & $AppVer, 350, 270)

$Sel_Lang_Button = GUICtrlCreateButton("Language...", 260, 3, 80, 20)
Set_Languages_Proc()

$Au3Dir_Group = GUICtrlCreateGroup($a_Msgs[2], 10, 20, 330, 75)

$AutoIt_Dir_Combo = GUICtrlCreateCombo("", 20, 40, 290, 20)
_GUIComboCtrlSetData(-1, $Combo_Data, $AutExe_Command)

$AutoIt_UsedVer_Label = GUICtrlCreateLabel($a_Msgs[3] & " " & GetAutoItVersion($AutExe_Command), 20, 62, -1, 12)
GUICtrlSetFont(-1, 7.5)

$AutoIt_SelVer_Label = GUICtrlCreateLabel($a_Msgs[4] & " " & GetAutoItVersion($AutExe_Command), 180, 62, -1, 12, $SS_RIGHT)
GUICtrlSetFont(-1, 7.5)

$Sel_AutoIt_Dir_Button = GUICtrlCreateButton("...", 315, 40, 20, 20)
GUICtrlSetTip(-1, $a_Msgs[5])

$Remove_AutoItPath_Entry_Button = GUICtrlCreateButton($a_Msgs[6], 20, 73, 290, 20)

$SelDefAction_Group = GUICtrlCreateGroup($a_Msgs[9], 10, 100, 330, 70)

$Run_Script_Radio = GUICtrlCreateRadio($a_Msgs[10], 20, 120, 300, 20)
GUICtrlSetState(-1, $GUI_CHECKED)

$Edit_Script_Radio = GUICtrlCreateRadio($a_Msgs[11], 20, 140, 300, 20)
If $Read_Default_Action = "Edit" Then GUICtrlSetState(-1, $GUI_CHECKED)

$Set_Local_Compiler_CB = GUICtrlCreateCheckbox($a_Msgs[7], 20, 170, 300, 20)
GUICtrlSetTip(-1, $a_Msgs[8])
If $Set_Local_Compiler <> "" Then GUICtrlSetState(-1, $GUI_CHECKED)

$Refresh_Icons_CB = GUICtrlCreateCheckbox($a_Msgs[29], 20, 190, 300, 20)
If $Refresh_Icons = 1 Then GUICtrlSetState(-1, $GUI_CHECKED)

$OpenPrefsFile_Button = GUICtrlCreateButton($a_Msgs[28], 10, 215, 150, 20)

$OK_Button = GUICtrlCreateButton($a_Msgs[12], 10, 240, 70, 20)
$Exit_Button = GUICtrlCreateButton($a_Msgs[13], 90, 240, 70, 20)

$Switch_Button = GUICtrlCreateButton($a_Msgs[14], 260, 240, 80, 20)

#EndRegion GUI Creation Part

#Region Tray Items Creation Part

Opt("TrayOnEventMode", 1)
Opt("TrayMenuMode", 1)
TraySetOnEvent($TRAY_EVENT_PRIMARYDOWN, "TrayMainEvents")
TraySetToolTip($AppName)
TraySetClick(16)

$ShowApp_TrayItem = TrayCreateItem(StringFormat($a_Msgs[15], $AppName))
TrayItemSetState(-1, $TRAY_DEFAULT)
TrayItemSetOnEvent(-1, "TrayMainEvents")

$Sel_AutoIt_Dir_TrayItem = TrayCreateItem($a_Msgs[5])
TrayItemSetOnEvent(-1, "TrayMainEvents")

$ExitApp_TrayItem = TrayCreateItem($a_Msgs[13])
TrayItemSetOnEvent(-1, "TrayMainEvents")

#EndRegion Tray Items Creation Part

#Region Initialization & Main loop

GUISetState(@SW_SHOW, $GUI)

While 1
	$Msg = GUIGetMsg()
	
	Switch $Msg
		Case $GUI_EVENT_CLOSE, $Exit_Button
			QuitApp()
		Case $GUI_EVENT_MINIMIZE
			TraySetState(1)
			GUISetState(@SW_HIDE)
		Case $Sel_Lang_Button
			_GUICtrlMenu_Show($GUI, $ContextMenu_Ctrl, $Sel_Lang_Button)
		Case $OpenPrefsFile_Button
			ShellExecute($Config_File)
		Case $Lang_Items[1] To $Lang_Items[$Lang_Items[0]]
			Local $sLangRead = GUICtrlRead($Msg, 1)
			IniWrite($Config_File, "Main", "Language", $sLangRead)
			
			$a_Msgs = Translate_Proc($sLangRead)
			
			$AppName = $a_Msgs[1]
			WinSetTitle($GUI, "", $AppName & " - " & $AppVer)
			
			GUICtrlSetData($Au3Dir_Group, $a_Msgs[2])
			GUICtrlSetData($AutoIt_UsedVer_Label, $a_Msgs[3] & StringRegExpReplace(GUICtrlRead($AutoIt_UsedVer_Label), ".*:", ""))
			GUICtrlSetData($AutoIt_SelVer_Label, $a_Msgs[4] & StringRegExpReplace(GUICtrlRead($AutoIt_SelVer_Label), ".*:", ""))
			GUICtrlSetTip($Sel_AutoIt_Dir_Button, $a_Msgs[5])
			GUICtrlSetData($Remove_AutoItPath_Entry_Button, $a_Msgs[6])
			GUICtrlSetData($Set_Local_Compiler_CB, $a_Msgs[7])
			GUICtrlSetTip($Set_Local_Compiler_CB, $a_Msgs[8])
			GUICtrlSetData($SelDefAction_Group, $a_Msgs[9])
			GUICtrlSetData($Run_Script_Radio, $a_Msgs[10])
			GUICtrlSetData($Edit_Script_Radio, $a_Msgs[11])
			GUICtrlSetData($OK_Button, $a_Msgs[12])
			GUICtrlSetData($Exit_Button, $a_Msgs[13])
			TrayItemSetText($ExitApp_TrayItem, $a_Msgs[13])
			GUICtrlSetData($Switch_Button, $a_Msgs[14])
			TrayItemSetText($ShowApp_TrayItem, StringFormat($a_Msgs[15], $AppName))
			TrayItemSetText($Sel_AutoIt_Dir_TrayItem, $a_Msgs[5])
			GUICtrlSetData($OpenPrefsFile_Button, $a_Msgs[28])
			GUICtrlSetData($Refresh_Icons_CB, $a_Msgs[29])
		Case $Sel_AutoIt_Dir_Button
			SelectAutoItPath_Proc()
			GUICtrlSetData($AutoIt_SelVer_Label, $a_Msgs[4] & " " & GetAutoItVersion(GUICtrlRead($AutoIt_Dir_Combo)))
		Case $Remove_AutoItPath_Entry_Button
			RemoveAutoItPathEntry_Proc()
		Case $AutoIt_Dir_Combo
			GUICtrlSetData($AutoIt_SelVer_Label, $a_Msgs[4] & " " & GetAutoItVersion(GUICtrlRead($AutoIt_Dir_Combo)))
		Case $Switch_Button
			SwitchAutoItPath_Proc()
		Case $OK_Button
			SwitchAutoItPath_Proc(1)
			
			If Not @error Then
				QuitApp()
			EndIf
	EndSwitch
WEnd

#EndRegion Initialization & Main loop

#Region Program Functions

Func Translate_Proc($sLanguage)
	Local $iTotal = 31
	Local $a_Msgs[$iTotal+1]
	$a_Msgs[0] = $iTotal
	
	$a_Msgs[1] = "AutoIt Path Switcher"
	$a_Msgs[2] = "AutoIt3 Directory:"
	$a_Msgs[3] = "Used Version:"
	$a_Msgs[4] = "Selected Version:"
	$a_Msgs[5] = "Select AutoIt main path..."
	$a_Msgs[6] = "Remove AutoIt Path Entry From List"
	$a_Msgs[7] = "Set Local Compiler"
	$a_Msgs[8] = "Will add an item to 'AutoIt3 File Types' context menu to compile with local settings (icon, *.bin etc.)"
	$a_Msgs[9] = "Select default action when executing *.au3 file:"
	$a_Msgs[10] = "Run Script"
	$a_Msgs[11] = "Edit Script (Recommended)"
	$a_Msgs[12] = "OK"
	$a_Msgs[13] = "Exit"
	$a_Msgs[14] = "Switch"
	$a_Msgs[15] = "Show <%s>"
	$a_Msgs[16] = "Remove current AutoIt Path entry?"
	$a_Msgs[17] = "Select AutoIt Dir"
	$a_Msgs[18] = "Attention!"
	$a_Msgs[19] = "Error!"
	$a_Msgs[20] = "Question"
	$a_Msgs[21] = "Can not find AutoIt3.exe, please select AutoIt dir."
	$a_Msgs[22] = "Would you like to switch selected AutoIt path?"
	$a_Msgs[23] = "Please set correct AutoIt3 directory."
	$a_Msgs[24] = "Compile With Local Settings"
	$a_Msgs[25] = "Compile Script"
	$a_Msgs[26] = "Edit Script"
	$a_Msgs[27] = "Run Script"
	$a_Msgs[28] = "Open Prefs File"
	$a_Msgs[29] = "Refresh Icons"
	$a_Msgs[30] = "Compile With AutoIt3Wrapper"
	$a_Msgs[31] = "You should run this program with administrator rights.\n\nOK ==> EXIT"
	
	For $i = 1 To $iTotal
		$sMessage = IniRead($Config_File, "Lang_" & $sLanguage, $i, "")
		If $sMessage <> "" Then $a_Msgs[$i] = $sMessage
	Next
	
	Return $a_Msgs
EndFunc

Func Set_Languages_Proc()
	Local $aSectNames = IniReadSectionNames($Config_File)
	
	If Not IsArray($aSectNames) Then
		Dim $Lang_Items[2] = [1, -1]
		Return SetError(1)
	EndIf
	
	Local $sCurrent_Lang, $DummyMenu = GUICtrlCreateDummy()
	$ContextMenu_Ctrl = GUICtrlCreateContextMenu($DummyMenu)
	
	Dim $Lang_Items[1] = [0]
	
	For $i = 1 To UBound($aSectNames)-1
		If StringLeft($aSectNames[$i], 5) = "Lang_" Then
			$Lang_Items[0] += 1
			ReDim $Lang_Items[$Lang_Items[0]+1]
			
			$sCurrent_Lang = StringTrimLeft($aSectNames[$i], 5)
			
			$Lang_Items[$Lang_Items[0]] = GUICtrlCreateMenuItem($sCurrent_Lang, $ContextMenu_Ctrl, -1, 1)
			If $sCurrent_Lang = $AppLang Then GUICtrlSetState(-1, $GUI_CHECKED)
		EndIf
	Next
	
	If $Lang_Items[0] = 0 Then
		Dim $Lang_Items[2] = [1, -1]
	EndIf
EndFunc

Func TrayMainEvents()
	Switch @TRAY_ID
		Case $TRAY_EVENT_PRIMARYDOWN, $ShowApp_TrayItem
			TraySetState(2)
			GUISetState(@SW_SHOW)
			GUISetState(@SW_RESTORE)
		Case $Sel_AutoIt_Dir_TrayItem
			SelectAutoItPath_Proc()
		Case $ExitApp_TrayItem
			QuitApp()
	EndSwitch
EndFunc

Func SelectAutoItPath_Proc()
	Local $iError = 0
	$Init_Au3_Dir = GUICtrlRead($AutoIt_Dir_Combo)
	
	If Not _WinIsVisible($GUI) Then
		TraySetState(2)
	EndIf
	
	While 1
		$Sel_AutoIt_Dir = FileSelectFolder($a_Msgs[17], "", 0, $Init_Au3_Dir, $GUI)
		
		If @error Then
			$iError = 1
			ExitLoop
		EndIf
		
		If Not _IsAutoItDir($Sel_AutoIt_Dir) Then
			MsgBox(262144+48, $a_Msgs[18], $a_Msgs[21], 0, $GUI)
			$Init_Au3_Dir = $Sel_AutoIt_Dir
			ContinueLoop
		EndIf
		
		GUICtrlSetData($AutoIt_Dir_Combo, $Sel_AutoIt_Dir, $Sel_AutoIt_Dir)
		ExitLoop
	WEnd
	
	If Not _WinIsVisible($GUI) Then
		TraySetState(1)
		
		If Not $iError Then
			Local $Ask_Switch = MsgBox(262144+36, $AppName & " - " & $a_Msgs[20], $a_Msgs[22])
			If $Ask_Switch = 6 Then SwitchAutoItPath_Proc()
		EndIf
	EndIf
EndFunc

Func RemoveAutoItPathEntry_Proc()
	If MsgBox(48+4, $a_Msgs[18], $a_Msgs[16], 0, $GUI) = 6 Then
		Local $sAutoIt_Path = GUICtrlRead($AutoIt_Dir_Combo)
		If $sAutoIt_Path = "" Then Return
		
		IniDelete($Config_File, "AutoIt Paths", $sAutoIt_Path)
		GUICtrlSendMsg($AutoIt_Dir_Combo, $CB_DELETESTRING, GUICtrlSendMsg($AutoIt_Dir_Combo, $CB_GETCURSEL, 0, 0), 0)
	EndIf
EndFunc

Func SwitchAutoItPath_Proc($iFlag=0)
	Local $sOriginal_AutoIt_Path = GUICtrlRead($AutoIt_Dir_Combo)
	Local $sAutoIt_Path = _PathFull($sOriginal_AutoIt_Path)
	
	If Not _IsAutoItDir($sAutoIt_Path) Then
		MsgBox(48, $AppName & " - " & $a_Msgs[19], $a_Msgs[23], 0, $GUI)
		Return SetError(1, 0, 0)
	EndIf
	
	Local $sFileType_Icon = $sAutoIt_Path & "\Icons\filetype1.ico"
	If Not FileExists($sFileType_Icon) Then $sFileType_Icon = $sAutoIt_Path & "\Icons\au3script_v10.ico"
	
	Local $Default_Action = "Edit"
	If GUICtrlRead($Run_Script_Radio) = $GUI_CHECKED Then $Default_Action = "Run"
	
	RegWrite("HKCR\.au3", "", "REG_SZ", "AutoIt3Script")
	RegWrite("HKCR\.au3", "PerceivedType", "REG_SZ", "text")
	RegWrite("HKCR\.au3\ShellNew", "FileName", "REG_SZ", "Template.au3")
	
	RegWrite("HKCR\AutoIt3Script", "", "REG_SZ", "AutoIt v3 Script")
	RegWrite("HKCR\AutoIt3Script\DefaultIcon", "", "REG_SZ", $sFileType_Icon)
	RegWrite("HKCR\AutoIt3Script\Shell", "", "REG_SZ", $Default_Action)
	
	If GUICtrlRead($Set_Local_Compiler_CB) = $GUI_CHECKED Then
		RegWrite("HKCR\AutoIt3Script\Shell\Compile With Local Settings", "", "REG_SZ", $a_Msgs[24])
		RegWrite("HKCR\AutoIt3Script\Shell\Compile With Local Settings\Command", "", "REG_SZ", '"' & $sAutoIt_Path & '\AutoIt3.exe" /AutoIt3ExecuteScript "' & @ScriptDir & '\AutoCompiler.au3" "%l"')
	Else
		RegDelete("HKCR\AutoIt3Script\Shell\Compile With Local Settings")
	EndIf
	
	RegWrite("HKCR\AutoIt3Script\Shell\Compile", "", "REG_SZ", $a_Msgs[25])
	RegWrite("HKCR\AutoIt3Script\Shell\Compile\Command", "", "REG_SZ", '"' & $sAutoIt_Path & '\Aut2Exe\Aut2Exe.exe" /in "%l"')
	
	RegWrite("HKCR\AutoIt3Script\Shell\Compile With AutoIt3Wrapper", "", "REG_SZ", $a_Msgs[30])
	RegWrite("HKCR\AutoIt3Script\Shell\Compile With AutoIt3Wrapper\Command", "", "REG_SZ", '"' & $sAutoIt_Path & '\SciTE\AutoIt3Wrapper\AutoIt3Wrapper.exe" /ShowGui /in "%l"')
	
	RegWrite("HKCR\AutoIt3Script\Shell\Edit", "", "REG_SZ", $a_Msgs[26])
	RegWrite("HKCR\AutoIt3Script\Shell\Edit\Command", "", "REG_SZ", '"' & $sAutoIt_Path & '\SciTE\SciTE.exe" "%1"')
	
	RegWrite("HKCR\AutoIt3Script\Shell\Run", "", "REG_SZ", $a_Msgs[27] & ' (' & GetAutoItVersion($sAutoIt_Path) & ')')
	
	If FileExists($sAutoIt_Path & '\SciTE\AutoIt3Wrapper\AutoIt3Wrapper.exe') Then
		RegWrite("HKCR\AutoIt3Script\Shell\Run\Command", "", "REG_SZ", '"' & $sAutoIt_Path & '\SciTE\AutoIt3Wrapper\AutoIt3Wrapper.exe" /run /prod /ErrorStdOut /in "%1" %*')
	Else
		RegWrite("HKCR\AutoIt3Script\Shell\Run\Command", "", "REG_SZ", '"' & $sAutoIt_Path & '\AutoIt3.exe" "%1" %*')
		
		If FileExists($sAutoIt_Path & '\AutoIt3_x64.exe') And ($OSArch <> "x86" Or _OSIs64Bit()) Then
			RegWrite("HKCR\AutoIt3Script\Shell\Run x64", "", "REG_SZ", $a_Msgs[27] & ' (x64, ' & GetAutoItVersion($sAutoIt_Path) & ')')
			RegWrite("HKCR\AutoIt3Script\Shell\Run x64\Command", "", "REG_SZ", '"' & $sAutoIt_Path & '\AutoIt3_x64.exe" "%1" %*')
		EndIf
	EndIf
	
	RegWrite("HKCR\AutoIt3Script\Shell\Open\Command", "", "REG_SZ", '"' & $sAutoIt_Path & '\SciTE\SciTE.exe" "%1"')
	
	RegWrite("HKCR\Applications\SciTE.exe\shell\open\command", "", "REG_SZ", '"' & $sAutoIt_Path & '\SciTE\SciTE.exe" "%1"')
	RegWrite("HKCR\Applications\AutoIt3.exe\shell\open\command", "", "REG_SZ", '"' & $sAutoIt_Path & '\AutoIt3.exe" "%1"')
	
	RegWrite($sRegistry_Key, "InstallDir", "REG_SZ", $sAutoIt_Path)
	
	If GUICtrlRead($Refresh_Icons_CB) = $GUI_CHECKED Then
		_WinAPI_SHChangeNotify($SHCNE_ASSOCCHANGED, BitOR($SHCNF_IDLIST, $SHCNF_FLUSH)); update shell icons
	EndIf
	
	If $iFlag = 0 Then
		GUICtrlSetData($AutoIt_Dir_Combo, $sOriginal_AutoIt_Path, $sOriginal_AutoIt_Path)
		GUICtrlSetData($AutoIt_UsedVer_Label, $a_Msgs[3] & " " & GetAutoItVersion($sOriginal_AutoIt_Path))
		;_MsgBox(262144+64, $AppName & " - Done!", "Now this AutoIt Path is used:" & @LF & "[" & $sAutoIt_Path & "]", $GUI)
	EndIf
	
	Return $sAutoIt_Path
EndFunc

Func GetAutoItVersion($sPath)
	Local $sVersion = FileGetVersion($sPath & "\AutoIt3.exe")
	If @error Then Return "N/A"
	
	Return $sVersion
EndFunc

Func GetAutoItPaths($sConfig, $sSection)
	Local $aPaths = IniReadSection($sConfig, $sSection)
	Local $sRetPaths = ""
	
	For $i = 1 To UBound($aPaths)-1
		If $aPaths[$i][1] = 1 Then $sRetPaths &= $aPaths[$i][0] & "|"
	Next
	
	If $sRetPaths = "" Then Return GetAutoItMainPath()
	
	Return StringRegExpReplace($sRetPaths, "\A\|+|\|+$|(\|)+", "\1")
EndFunc

Func GetAutoItMainPath()
	$Au3_Ret_Path = RegRead($sRegistry_Key, "InstallDir")
	
	If Not _IsAutoItDir($Au3_Ret_Path) Then $Au3_Ret_Path = @ProgramFilesDir & "\AutoIt3"
	If Not _IsAutoItDir($Au3_Ret_Path) Then Return @ScriptDir & "\AutoIt3"
	
	Return $Au3_Ret_Path
EndFunc

Func GetComboArray($hComboBox, $sDelimiter = "|")
	Local $sDelim = $sDelimiter, $sResult, $nItem, $Struct
	
	For $i = 0 To GUICtrlSendMsg($hComboBox, $CB_GETCOUNT, 0, 0) - 1
		$Struct = DllStructCreate("wchar[" & GUICtrlSendMsg($hComboBox, $CB_GETLBTEXTLEN, $i, 0) + 1 & "]")
		DllCall("user32.dll", "int", "SendMessageW", "hwnd", GUICtrlGetHandle($hComboBox), _
			"int", $CB_GETLBTEXT, "int", $i, "ptr", DllStructGetPtr($Struct))
		
		$nItem = DllStructGetData($Struct, 1)
		If $nItem <> "" Then $sResult &= $nItem & $sDelimiter
	Next
	
	$sResult = StringRegExpReplace($sResult, "\A\" & $sDelim & "+|\" & $sDelim & "+$|(\" & $sDelim & ")+", "\1")
	
	Return StringSplit($sResult, "|")
EndFunc

Func _GUIComboCtrlSetData($iCtrlID, $sCombo_Data, $sDefault)
	Local $aCombo_Data = StringSplit($sCombo_Data, "|")
	
	For $i = 1 To UBound($aCombo_Data)-1
		If _PathFull($aCombo_Data[$i]) = $sDefault Then $sDefault = $aCombo_Data[$i]
		GUICtrlSetData($iCtrlID, $aCombo_Data[$i], $sDefault)
	Next
	
	If GUICtrlRead($iCtrlID) = "" Then GUICtrlSetData($iCtrlID, $sDefault, $sDefault)
EndFunc

Func _GUICtrlMenu_Show($hWnd, $nContextID, $nContextControlID, $iMouse=0)
	Local $hMenu = GUICtrlGetHandle($nContextID)
    Local $iCtrlPos = ControlGetPos($hWnd, "", $nContextControlID)
	
	Local $iX = $iCtrlPos[0]
	Local $iY = $iCtrlPos[1] + $iCtrlPos[3]
	
	; Convert the client (GUI) coordinates to screen (desktop) coordinates
	;ClientToScreen
	Local $stPoint = DllStructCreate("int;int")
    
    DllStructSetData($stPoint, 1, $iX)
    DllStructSetData($stPoint, 2, $iY)

    DllCall("user32.dll", "int", "ClientToScreen", "hwnd", $hWnd, "ptr", DllStructGetPtr($stPoint))
    
    $iX = DllStructGetData($stPoint, 1)
    $iY = DllStructGetData($stPoint, 2)
	;ClientToScreen
	
	If $iMouse Then
		$iX = MouseGetPos(0)
		$iY = MouseGetPos(1)
	EndIf
	
	DllCall("user32.dll", "int", "TrackPopupMenuEx", "hwnd", $hMenu, "int", 0, "int", $iX, "int", $iY, "hwnd", $hWnd, "ptr", 0)
EndFunc

Func _WinIsVisible($sTitle)
	Return BitAND(WinGetState($sTitle), 2)
EndFunc

Func _IsAutoItDir($sPath)
	Return FileExists($sPath & "\AutoIt3.exe")
EndFunc

Func QuitApp()
	$aAutoIt_Paths = GetComboArray($AutoIt_Dir_Combo)

	For $i = 1 To UBound($aAutoIt_Paths)-1
		IniWrite($Config_File, "AutoIt Paths", $aAutoIt_Paths[$i], 1)
	Next
	
	IniWrite($Config_File, "Main", "Refresh Icons", Number(GUICtrlRead($Refresh_Icons_CB) = $GUI_CHECKED))
	
	Exit
EndFunc

Func _WinAPI_SHChangeNotify($wEventId, $uFlags, $dwItem1 = 0, $dwItem2 = 0)
    DllCall("shell32.dll", "none", "SHChangeNotify", "long", $wEventId, "uint", $uFlags, "ptr", $dwItem1, "ptr", $dwItem2)
EndFunc

Func _OSIs64Bit() ;; Returns true if OS is 64 bit (credits go to martin)
   Local $hUser32 = DllCall("kernel32.dll", "ptr", "LoadLibrary", "str", "user32.dll")
   Local $OS64 = DllCall("kernel32.dll", "ptr", "GetProcAddress", "ptr", $hUser32[0], "str", "IsWow64Process")
   Return $OS64[0] <> 0
Endfunc

#EndRegion Program Functions

#Region Internal AutoIt UDFs

; #FUNCTION# ====================================================================================================================
; Name...........: _PathFull
; Description ...: Creates a path based on the relative path you provide. The newly created absolute path is returned
; Syntax.........: _PathFull($sRelativePath)
; Parameters ....: $szRelPath - The relative path to be created
; Return values .: Success - Returns the newly created absolute path.
; Author ........: Valik (Original function and modification to rewrite), tittoproject (Rewrite)
; Modified.......:
; Remarks .......:
; Related .......: _PathMake, _PathSplit, .DirCreate, .FileChangeDir
; Link ..........;
; Example .......; Yes
; ===============================================================================================================================
; Note(s):          UNC paths are supported.
;                   Pass "\" to get the root drive of $sBasePath.
;                   Pass "" or "." to return $sBasePath.
;                   A relative path will be built relative to $sBasePath.  To bypass this behavior, use an absolute path.
;
;===============================================================================
Func _PathFull($sRelativePath, $sBasePath = @WorkingDir)
	If Not $sRelativePath Or $sRelativePath = "." Then Return $sBasePath

	; Normalize slash direction.
	Local $sFullPath = StringReplace($sRelativePath, "/", "\") ; Holds the full path (later, minus the root)
	Local Const $sFullPathConst = $sFullPath ; Holds a constant version of the full path.
	Local $sPath ; Holds the root drive/server
	Local $bRootOnly = StringLeft($sFullPath, 1) = "\" And StringMid($sFullPath, 2, 1) <> "\"

	; Check for UNC paths or local drives.  We run this twice at most.  The
	; first time, we check if the relative path is absolute.  If it's not, then
	; we use the base path which should be absolute.
	For $i = 1 To 2
		$sPath = StringLeft($sFullPath, 2)
		If $sPath = "\\" Then
			$sFullPath = StringTrimLeft($sFullPath, 2)
			$sPath &= StringLeft($sFullPath, StringInStr($sFullPath, "\") - 1)
			ExitLoop
		ElseIf StringRight($sPath, 1) = ":" Then
			$sFullPath = StringTrimLeft($sFullPath, 2)
			ExitLoop
		Else
			$sFullPath = $sBasePath & "\" & $sFullPath
		EndIf
	Next

	; If this happens, we've found a funky path and don't know what to do
	; except for get out as fast as possible.  We've also screwed up our
	; variables so we definitely need to quit.
	If $i = 3 Then Return ""

	; Build an array of the path parts we want to use.
	Local $aTemp = StringSplit($sFullPath, "\")
	Local $aPathParts[$aTemp[0]], $j = 0
	For $i = 2 To $aTemp[0]
		If $aTemp[$i] = ".." Then
			If $j Then $j -= 1
		ElseIf Not ($aTemp[$i] = "" And $i <> $aTemp[0]) And $aTemp[$i] <> "." Then
			$aPathParts[$j] = $aTemp[$i]
			$j += 1
		EndIf
	Next

	; Here we re-build the path from the parts above.  We skip the
	; loop if we are only returning the root.
	$sFullPath = $sPath
	If Not $bRootOnly Then
		For $i = 0 To $j - 1
			$sFullPath &= "\" & $aPathParts[$i]
		Next
	Else
		$sFullPath &= $sFullPathConst
		; If we detect more relative parts, remove them by calling ourself recursively.
		If StringInStr($sFullPath, "..") Then $sFullPath = _PathFull($sFullPath)
	EndIf

	; Clean up the path.
	While StringInStr($sFullPath, ".\")
		$sFullPath = StringReplace($sFullPath, ".\", "\")
	WEnd
	Return $sFullPath
EndFunc

; #FUNCTION# ====================================================================================================================
; Name...........: _Iif
; Description ...: Perform a boolean test within an expression.
; Syntax.........: _Iif($fTest, $vTrueVal, $vFalseVal)
; Parameters ....: $fTest     - Boolean test.
;                  $vTrueVal  - Value to return if $fTest is true.
;                  $vFalseVal - Value to return if $fTest is false.
; Return values .: True         - $vTrueVal
;                  False        - $vFalseVal
; Author ........: Dale (Klaatu) Thompson
; Modified.......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: Yes
; ===============================================================================================================================
Func _Iif($fTest, $vTrueVal, $vFalseVal)
	If $fTest Then
		Return $vTrueVal
	Else
		Return $vFalseVal
	EndIf
EndFunc

#EndRegion Internal AutoIt UDFs
