#Include <Misc.au3>

If $CmdLine[0] = 0 Then Exit

Global $iNoPack				= _IsPressed(10) Or ($CmdLine[0] > 1 And $CmdLine[2] = "/NoPack")

Global $sScript_Name 		= StringRegExpReplace($CmdLine[1], "^.*\\", "")
Global $sParent_Dir	 		= StringRegExpReplace($CmdLine[1], "\\[^\\]*$", "")
Global $sParent_Dir_Name 	= StringRegExpReplace($sParent_Dir, "^.*\\", "")

ProgressOn("Compiling Process", StringFormat("Compiling: %s", $sScript_Name), "", 0, 0, 16)
ProgressSet(20, "Getting neccessary information...")

Global $AutoIt3_Dir 		= RegRead("HKEY_LOCAL_MACHINE\SOFTWARE\AutoIt v3\AutoIt", "InstallDir")

Global $ConfigFile			= StringTrimRight(@ScriptFullPath, 3) & "ini"

Global $sIcon_File 			= $sParent_Dir & "\" & IniRead($ConfigFile, "Main", "Icon FileName", $sParent_Dir_Name & "_Icon") & ".ico"
Global $sBin_File 			= $sParent_Dir & "\" & IniRead($ConfigFile, "Main", "Bin FileName", $sParent_Dir_Name) & ".bin"

If Not FileExists($sIcon_File) Then $sIcon_File = $sParent_Dir_Name & "_Icon.ico"
If Not FileExists($sBin_File) Then $sBin_File = $sParent_Dir & "\" & $sParent_Dir_Name & ".bin"
If Not FileExists($sBin_File) Then $sBin_File = $sParent_Dir & "\" & StringTrimRight($sScript_Name, 4) & ".bin"
If Not FileExists($sBin_File) Then $sBin_File = $sParent_Dir & "\Bin.bin"
If Not FileExists($sBin_File) Then $sBin_File = $AutoIt3_Dir & "\Aut2Exe\AutoItSC.bin"

$sCompile_String = '/in "' & $CmdLine[1] & '" /Icon "' & $sIcon_File & '" /Bin "' & $sBin_File & '" /Comp 4'
$sProgress_Compile_String = "[/in %s /Icon %s /Bin %s /Comp 4]"

If $iNoPack Then
	$sCompile_String &= " /NoPack"
	$sProgress_Compile_String = "[/in %s /Icon %s /Bin %s /Comp 4 /NoPack]"
EndIf
	
ProgressSet(60, "Executing Aut2Exe.exe compiler... " & @CRLF & $sProgress_Compile_String)
RunWait($AutoIt3_Dir & '\Aut2Exe\Aut2Exe.exe ' & $sCompile_String)

ProgressSet(100, "Done!")
Sleep(1000)
