#include "SciTE.au3"

;Run SciTE instance
$iSciTE_PID = _SciTE_Open('', 1)

;Set main SciTE Process ID
_SciTE_SetMainPID($iSciTE_PID)

;Close current document if any (last file might be open)
;~ _SciTE_CloseCurrentFile()

;Close all tabs
_SciTE_Extender('dostring scite.MenuCommand(IDM_CLOSEALL)')

;Create temp script file
$sFile = @TempDir & '\Test.au3'
FileClose(FileOpen($sFile, 2))

;Open created script file
_SciTE_OpenFile($sFile)

;Insert some code
_SciTE_InsertText('MsgBox(64, @ScriptName, "Hello World!", 2)' & @CRLF)

;Find "Hello" and replace it with "Hello SciTE's"
_SciTE_FindText('Hello', $SCFIND_MATCHCASE)
_SciTE_ReplaceSelection('Hello SciTE''s')

;Set cursor at the end of the document
_SciTE_SetSelection(-1, -1)

;Go/Run command (F5), run the code
;~ _SciTE_MenuCommand(303)
_SciTE_MenuCommand('IDM_GO')

;Open Find and Replace dialog using IDM_* constant string
_SciTE_MenuCommand('IDM_REPLACE')

;Wait 3.5 seconds and close the SciTE
Sleep(3500)

;We check if process still exists (can be closed by user), to prevent closure of all SciTE instances
If ProcessExists($iSciTE_PID) Then
	_SciTE_Close($iSciTE_PID)
	
	;Another method
	;_SciTE_Quit()
EndIf

;Delete temp script file
FileDelete($sFile)
