#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>
#include <File.au3>
#include <WinAPI.au3>

$hParent = GUICreate('Parent Window', 205, 160, -1, -1, -1, $WS_EX_TOPMOST)
GUISetBkColor(0x0, $hParent)
WinSetTrans($hParent, '', 200)

$hGUI = GUICreate('', 205, 160, 0, 0, $WS_POPUP, BitOR($WS_EX_TOOLWINDOW, $WS_EX_LAYERED, $WS_EX_MDICHILD), $hParent)
GUISetBkColor(0xFFFFFF, $hGUI)
_WinAPI_SetLayeredWindowAttributes($hGUI, 0xFFFFFF)

$sDir = @ScriptDir
$aSmiles = _FileListToArray($sDir, '*.gif')

$iLeft = 20
$iTop = 10

For $i = 1 To UBound($aSmiles) - 1
	GUICtrlCreatePic($sDir & '\' & $aSmiles[$i], $iLeft, $iTop, 20, 20)
	
	$iLeft += 25
	
	If $iLeft + 25 >= 200 Then
		$iLeft = 20
		$iTop += 25
	EndIf
Next

GUISetState(@SW_SHOW, $hParent)
GUISetState(@SW_SHOW, $hGUI)

While 1
	$nMsg = GUIGetMsg()

	Switch $nMsg
		Case $GUI_EVENT_CLOSE
			Exit
	EndSwitch
WEnd

