#include <Array.au3>

#AutoIt3Wrapper_UseX64=n
;#AutoIt3Wrapper_Autoit3Dir=D:\AutoIt_Versions\AutoIt_3.3.8.1

Global Const $cINVOKE_ALL 				= -1 ; All methods/properties
Global Const $cINVOKE_FUNC 				= 1 ; A method (=function)
Global Const $cINVOKE_PROPERTYGET 		= 2 ; Read-only property
Global Const $cINVOKE_PROPERTYPUT 		= 4 ; Read/write property
Global Const $cINVOKE_PROPERTYPUTREF 	= 8 ; Reference property

$hGUI = GUICreate('')
WinSetOnTop($hGUI, '', 1)
$sObj = InputBox('Object name', 'Enter Object Name:', 'Scripting.Dictionary', '', -1, -1, Default, Default, 0, $hGUI)
If StringStripWS($sObj, 8) = '' Then Exit

$oObj = ObjCreate($sObj)
If Not IsObj($oObj) Then Exit

$aObj_Members = _ObjGetMembers($oObj, $cINVOKE_ALL)

If Not @error Then
	If _ArraySearch($aObj_Members, 'Quit', 1) <> -1 Then
		$oObj.Quit ;In case the object creates process instanse
	EndIf
	
	_ArrayDisplay($aObj_Members)
EndIf

Func _ObjGetMembers($oObj, $iInvokeKind = $cINVOKE_ALL)
	If @AutoItVersion <> '3.3.6.1' And @AutoItVersion <> '3.3.8.1' Then
		Return SetError(-1)
	EndIf
	
	If Not IsObj($oObj) Then
		Return SetError(1)
	EndIf
	
	Local $oTLA = ObjCreate('TLI.TLIApplication')
	
	If Not IsObj($oTLA) Then
		InetGet('http://creator-lab.ucoz.ru/AutoIt/tlbinf32.dll', @TempDir & '\tlbinf32.dll')
		RunWait('regsvr32 /s "' & @TempDir & '\tlbinf32.dll"', '', @SW_HIDE)
		
		$oTLA = ObjCreate('TLI.TLIApplication')
		
		If Not IsObj($oTLA) Then
			Return SetError(2)
		EndIf
	EndIf
	
	Local $oInterface = $oTLA.InterfaceInfoFromObject($oObj)
	Local $oMembers = $oInterface.Members
	Local $aRet[$oMembers.Count + 1][3] = [[0, '[Member]', '[Type]']]
	
	For $oMember In $oMembers
		If $iInvokeKind = $cINVOKE_ALL Or $oMember.InvokeKind = $iInvokeKind Then
			$aRet[0][0] += 1
			$aRet[$aRet[0][0]][0] = $aRet[0][0]
			$aRet[$aRet[0][0]][1] = $oMember.Name
			$aRet[$aRet[0][0]][2] = _ObjGetInvokeKindType($oMember.InvokeKind)
		EndIf
	Next
	
	ReDim $aRet[$aRet[0][0] + 1][3]
	Return $aRet
EndFunc

Func _ObjGetInvokeKindType($iInvokeKind)
	Switch $iInvokeKind
		Case 1
			Return 'Method'
		Case 2
			Return 'Property (Read-only)'
		Case 4
			Return 'Property (Read/Write)'
		Case 8
			Return 'Property (Reference)'
	EndSwitch
	
	Return 'Undefined'
EndFunc
