#CS
#include "LibReadWrite.inc"
_DataLibFileRead($sLibFile, $sPassword=0)
_DataLibFileWrite($sLibFile, $vData, $sPassword=0)
_DataLibFileIsCrypt($sLibFile)

@Error =
		0 = 
		1 =   
		2 =   
		3 =  
		4 =     
		5 =    
#CE


#include-once
#include <Crypt.au3>


Func _DataLibFileRead($sLibFile, $sPassword=0)
Local $hFile, $sReturn
$hFile = FileOpen ( $sLibFile, 0 )
	If $hFile = -1 Then Return SetError(1, 0, 0)

$sReturn = FileRead( $hFile )
	If @Error Then Return SetError(2, FileClose ( $hFile ), "")

FileClose ( $hFile )
If StringLeft ( $sReturn, 4 ) = "DLDF" Then
	Return SetError(0,0,StringTrimLeft ( $sReturn, 4 ))
ElseIF StringLeft ( $sReturn, 4 ) = "DLCF" Then
	$sReturn = BinaryToString(_Crypt_DecryptData(StringTrimLeft ( $sReturn, 4 ), $sPassword, $CALG_RC4))
	If StringLeft ( $sReturn, 4 ) = "DLDF" Then Return SetError(0,0,StringTrimLeft ( $sReturn, 4 ))
	Return SetError(3, 0, "")
Else
Return SetError(4, 0, "")
EndIF
EndFunc



Func _DataLibFileWrite($sLibFile, $vData, $sPassword=0)
Local $hFile
$vData = "DLDF"&$vData

If $sPassword <> "0" AND $sPassword <> "" Then $vData = "DLCF"&BinaryToString(_Crypt_EncryptData($vData, $sPassword, $CALG_RC4))
$hFile = FileOpen ( $sLibFile, 2 )
	If $hFile = -1 Then Return SetError(1, 0, 0)

If NOT FileWrite ( $hFile, $vData ) Then Return SetError(5, FileClose ( $hFile ), "")
FileClose ( $hFile )
Return SetError(0, 0, 1)
EndFunc



Func _DataLibFileIsCrypt($sLibFile)
Local $hFile, $sReturn
$hFile = FileOpen ( $sLibFile, 0 )
	If $hFile = -1 Then Return SetError(1, 0, 0)

$sReturn = FileRead( $hFile )
	If @Error Then Return SetError(2, FileClose ( $hFile ), 0)

FileClose ( $hFile )
If StringLeft ( $sReturn, 4 ) = "DLDF" Then
	Return SetError(0,0,0)
ElseIF StringLeft ( $sReturn, 4 ) = "DLCF" Then
	Return SetError(0,0,1)
Else
	Return SetError(4, 0, 0)
EndIF
EndFunc


