#include <Array.au3>
#Include <WinAPIEx.au3>
Global $aRemoteDirListingControls[1]=[0], $aLocalDirListingControls[1]=[0]



Func _ServerWindow_RemoteDirListing($hRemoteContent, $iMsg=0)
Local $aFile, $hCtrl, $h_Handle, $sFileDecription, $aGetDirs[1]=[0], $aGetFiles[1]=[0], $aFileSize[1], $sEncoding
	If $aRemoteDirListingControls[0] > 0 Then
	For $i = 1 To $aRemoteDirListingControls[0]
	GUICtrlDelete ( $aRemoteDirListingControls[$i] )
	Next
	EndIF
ReDim $aRemoteDirListingControls[1]
$aRemoteDirListingControls[0] = 0
$sEncoding = RegRead ( "HKEY_CURRENT_USER\Software\Prog-Soft_10\FtpCnt\Encoding", $sFtpServTitleHex )
If $sEncoding = "" Then RegWrite ( "HKEY_CURRENT_USER\Software\Prog-Soft_10\FtpCnt\Encoding", $sFtpServTitleHex, "REG_SZ", "" )

$aFile = _FTP_ListToArray2D($hFtpServSession, 1, $INTERNET_FLAG_RELOAD)
	If NOT @Error Then
	For $i = 1 To $aFile[0][0]
	If $aFile[$i][0] = "." OR $aFile[$i][0] = ".." OR $aFile[$i][0] = "" Then ContinueLoop
	If $sEncoding <> "" Then $aFile[$i][0] = _ServerWindow_RemoteDirListing_Decoding($aFile[$i][0])
	$aRemoteDirListingControls[0] += 1
	$hCtrl = GUICtrlCreateListViewItem("|"&$aFile[$i][0]&"||", $hRemoteContent)
	_ArrayAdd($aRemoteDirListingControls, $hCtrl)
	GUICtrlSetImage ( $hCtrl, @ScriptFullPath, $iFolderIconIndex )
	_ServerWindow_MarksMenu_Restore($hCtrl, $aFile[$i][0], 0)
	Next
	EndIF

$aFile = _FTP_ListToArray2D($hFtpServSession, 2, $INTERNET_FLAG_RELOAD)
	If NOT @Error Then
	For $i = 1 To $aFile[0][0]
	If $aFile[$i][0] = "." OR $aFile[$i][0] = ".." OR $aFile[$i][0] = "" Then ContinueLoop
	If $sEncoding <> "" Then $aFile[$i][0] = _ServerWindow_RemoteDirListing_Decoding($aFile[$i][0])
	$aRemoteDirListingControls[0] += 1
	$sFileDecription = _WinAPI_AssocQueryString ( "."&_PuthEx_FileMask($aFile[$i][0]), 3 )
		If $sFileDecription <> "" Then 
		$sFileDecription = " "&$sFileDecription
		Else
		$sFileDecription = " "
		EndIF
	$hCtrl = GUICtrlCreateListViewItem("|"&$aFile[$i][0]&"|"&$sFileDecription&"|"&_ConvertFileSize($aFile[$i][1]), $hRemoteContent)
	_ArrayAdd($aRemoteDirListingControls, $hCtrl)
	GUICtrlSetImage ( $hCtrl, @ScriptFullPath, $iFileIconIndex )
	_ServerWindow_MarksMenu_Restore($hCtrl, $aFile[$i][0], 0)
	Next
	EndIF
EndFunc







Func _ServerWindow_LocalDirListing($hLocalContent, $iMsg=0)
Local $sFile, $hCtrl, $hSearch, $sFileDecription, $aGetDirs[1]=[0], $aGetFiles[1]=[0]
	If $aLocalDirListingControls[0] > 0 Then
	For $i = 1 To $aLocalDirListingControls[0]
	GUICtrlDelete ( $aLocalDirListingControls[$i] )
	Next
	EndIF
ReDim $aLocalDirListingControls[1]
$aLocalDirListingControls[0] = 0

$hSearch = FileFindFirstFile("*")
If $hSearch <> -1 Then
	While 1
		$sFile = FileFindNextFile($hSearch)
		If @error Then ExitLoop
			If FileExists( @WorkingDir&"\"&$sFile&"\" ) Then
			$aGetDirs[0] += 1
			_ArrayAdd($aGetDirs, $sFile)
			Else
			$aGetFiles[0] += 1
			_ArrayAdd($aGetFiles, $sFile)
			EndIF
	WEnd
	FileClose($hSearch)
EndIF

For $i = 1 To $aGetDirs[0]
$aLocalDirListingControls[0] += 1
$hCtrl = GUICtrlCreateListViewItem("|"&$aGetDirs[$i]&"||", $hLocalContent)
_ArrayAdd($aLocalDirListingControls, $hCtrl)
GUICtrlSetImage ( $hCtrl, @ScriptFullPath, $iFolderIconIndex )
_ServerWindow_MarksMenu_Restore($hCtrl, $aGetDirs[$i], 1)
Next

For $i = 1 To $aGetFiles[0]
$aLocalDirListingControls[0] += 1
$sFileDecription = _WinAPI_AssocQueryString ( "."&_PuthEx_FileMask($aGetFiles[$i]), 3 )
	If $sFileDecription <> "" Then 
	$sFileDecription = " "&$sFileDecription
	Else
	$sFileDecription = " "
	EndIF
$hCtrl = GUICtrlCreateListViewItem("|"&$aGetFiles[$i]&"|"&$sFileDecription&"|"&_ConvertFileSize(FileGetSize ( $aGetFiles[$i] )), $hLocalContent)
_ArrayAdd($aLocalDirListingControls, $hCtrl)
GUICtrlSetImage ( $hCtrl, @ScriptFullPath, $iFileIconIndex )
_ServerWindow_MarksMenu_Restore($hCtrl, $aGetFiles[$i], 1)
Next
EndFunc




Func _ServerWindow_RemoteDirListing_Decoding($sText)
Switch RegRead ( "HKEY_CURRENT_USER\Software\Prog-Soft_10\FtpCnt\Encoding", $sFtpServTitleHex )
	Case "OEM"
		Return _Encoding_OEM2ANSI($sText)

	Case "UTF8"
		Return _Encoding_UTF8ToANSI($sText)

	Case Else
		Return $sText
EndSwitch
EndFunc

Func _ServerWindow_RemoteDirListing_Encoding($sText)
Switch RegRead ( "HKEY_CURRENT_USER\Software\Prog-Soft_10\FtpCnt\Encoding", $sFtpServTitleHex )
	Case "OEM"
		Return _Encoding_ANSIToOEM($sText)

	Case "UTF8"
		Return _Encoding_ANSIToUTF8($sText)

	Case Else
		Return $sText
EndSwitch
EndFunc


Func _FtpChangeDir( $sDir )
Return _FTP_DirSetCurrent($hFtpServSession, _ServerWindow_RemoteDirListing_Encoding($sDir))
EndFunc

Func _FtpWorkDir()
Return _ServerWindow_RemoteDirListing_Decoding(_FTP_DirGetCurrent( $hFtpServSession ))
EndFunc





Func _ServerWindow_LocalPcListing($hLocalContent, $iMsg=0)
	If $aLocalDirListingControls[0] > 0 Then
	For $i = 1 To $aLocalDirListingControls[0]
	GUICtrlDelete ( $aLocalDirListingControls[$i] )
	Next
	EndIF
ReDim $aLocalDirListingControls[1]
$aLocalDirListingControls[0] = 0
Local $aArray, $hCtrl

$aArray = DriveGetDrive("ALL")
If NOT @error Then
    For $i = 1 To $aArray[0]
    	If DriveStatus ( $aArray[$i] ) <> "READY" Then ContinueLoop
	$hCtrl = GUICtrlCreateListViewItem("|"&StringUpper($aArray[$i])&"||", $hLocalContent)
	$aLocalDirListingControls[0] += 1
	_ArrayAdd($aLocalDirListingControls, $hCtrl)
	GUICtrlSetImage ( $hCtrl, @ScriptFullPath, $iDriveIconIndex )
    Next
EndIf


$hCtrl = GUICtrlCreateListViewItem("|"&@DesktopDir&"||", $hLocalContent)
$aLocalDirListingControls[0] += 1
_ArrayAdd($aLocalDirListingControls, $hCtrl)
GUICtrlSetImage ( $hCtrl, @ScriptFullPath, $iFolderIconIndex )

$hCtrl = GUICtrlCreateListViewItem("|"&@MyDocumentsDir&"||", $hLocalContent)
$aLocalDirListingControls[0] += 1
_ArrayAdd($aLocalDirListingControls, $hCtrl)
GUICtrlSetImage ( $hCtrl, @ScriptFullPath, $iFolderIconIndex )
EndFunc






