#include-once
global $URLhandlerName='AutoitUrlHandler';			     

; #FUNCTION# ====================================================================================================================
; Name ..........: _URLhandler_install
; Description ...:  URL-  ,   $URLhandlerName
; Syntax ........: _URLhandler_install([$fRewrite = 0])
; Parameters ....: $fRewrite            - [optional]  ,       .   0().
; Return values .:  1   ,     0   @error:
;					9-    ,   
;					1,2,3-     (@extended    RegWrite)
; Author ........: Pelme666ko
; ===============================================================================================================================
Func _URLhandler_install($fRewrite=0)
	If $fRewrite=0 Then
		If RegRead('HKCR\'&$URLhandlerName,'')<>'' Then
			SetError(9,1,0)
			Return(0)
		EndIf
	EndIf
	if RegWrite('HKCR\'&$URLhandlerName,'','REG_SZ','URL:'&$URLhandlerName&' Protocol')=0 Then
		SetError(1,@error,0)
		Return(0)
	EndIf
	if RegWrite('HKCR\'&$URLhandlerName,'URL Protocol','REG_SZ','')=0 Then
		SetError(2,@error,0)
		Return(0)
	EndIf
	if RegWrite('HKCR\'&$URLhandlerName&'\shell\open\command','','REG_SZ','"'&@ScriptFullPath&'" "/uri:"%l""')=0 Then
		SetError(3,@error,0)
		Return(0)
	EndIf
	Return(1)
EndFunc



; #FUNCTION# ====================================================================================================================
; Name ..........: _URLhandler_UnInstall
; Description ...:  URL-  ,   $URLhandlerName
; Syntax ........: _URLhandler_UnInstall([$fCheck = 1])
; Parameters ....: $fCheck              - [optional]        .   1().
; Return values .:  1   ,     0   @error:
;					9-       
;					1-     (@extended    RegDelete)
; Author ........: Pelme666ko
; ===============================================================================================================================
Func _URLhandler_UnInstall($fCheck=1)
	If $fCheck=1 Then
		If RegRead('HKCR\'&$URLhandlerName&'\shell\open\command','')<>'"'&@ScriptFullPath&'" "/uri:"%l""' Then
			SetError(9,1,0)
			Return(0)
		EndIf
	EndIf
	if RegDelete('HKCR\'&$URLhandlerName)=0 Then
		SetError(1,@error,0)
		Return(0)
	EndIf
	Return(1)
EndFunc

; #FUNCTION# ====================================================================================================================
; Name ..........: _URLhandler_check
; Description ...:    URL   ,   $URLhandlerName
; Syntax ........: _URLhandler_check()
; Return values .: 	0-  
;					1- ,  
;					2- ,    
; Author ........: Pelme666ko
; ===============================================================================================================================
Func _URLhandler_check()
	$cmd=RegRead('HKCR\'&$URLhandlerName&'\shell\open\command','')
	Switch $cmd
		Case '"'&@ScriptFullPath&'" "/uri:"%l""'
			Return(1)
		Case ''
			Return(0)
		Case Else
			Return(2)
	EndSwitch
EndFunc


; #FUNCTION# ====================================================================================================================
; Name ..........: _URLhandler_getCmd
; Description ...:  ,   URL-
; Syntax ........: _URLhandler_getCmd()
; Return values .: 0,      URL ,  -   URL 
; Author ........: Pelme666ko
; ===============================================================================================================================
Func _URLhandler_getCmd()
	If $cmdline[0]=1 Then
		$len=StringLen($URLhandlerName)+6
		$prefix=StringLeft($cmdline[1],$len)
		If $prefix='/uri:'&$URLhandlerName&':' Then	Return(StringTrimLeft($cmdline[1],$len))
	EndIf
EndFunc