#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_icon=Res\Icon.ico
#AutoIt3Wrapper_outfile=Out\FolderImageChooser.exe
#AutoIt3Wrapper_UseUpx=n
#AutoIt3Wrapper_Res_Comment=Folder Image Chooser
#AutoIt3Wrapper_Res_Description=SECTOR (aka SibMC)
#AutoIt3Wrapper_Res_Fileversion=2.1.0.0
#AutoIt3Wrapper_Res_LegalCopyright=SECTOR (aka SibMC)
#AutoIt3Wrapper_Run_After=Utilities\ResHacker\ResHacker.exe -delete %out%, %out%, Dialog, 1000,
#AutoIt3Wrapper_Run_After=Utilities\ResHacker\ResHacker.exe -delete %out%, %out%, Menu, 166,
#AutoIt3Wrapper_Run_After=Utilities\ResHacker\ResHacker.exe -delete %out%, %out%, Icon, 162,
#AutoIt3Wrapper_Run_After=Utilities\ResHacker\ResHacker.exe -delete %out%, %out%, Icon, 164,
#AutoIt3Wrapper_Run_After=Utilities\ResHacker\ResHacker.exe -delete %out%, %out%, Icon, 169,
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
; Include's
#include <Res\ColorChooser.au3>
#include <Res\ColorPicker.au3>

#Include <GUIButton.au3>
#Include <GUIImageList.au3>
#Include <GDIPlus.au3>
#Include <WinAPI.au3>
#Include <WindowsConstants.au3>

; <Opt's>
OnAutoItExitRegister("_GDIPlus_Shutdown")
Opt("GUICloseOnESC",0)
#NoTrayIcon

; <Dclare var's>
; - Folder, Image, Color, Text
Global $s_current_Folder = "", $s_current_Image = "", $s_current_Color = "", $s_current_BkColor = "", $s_current_Text = ""
; - Other's
Global $inf_name = "Folder Image Chooser", $inf_ver = "2.1", $inf_namev = $inf_name&" - "&$inf_ver, $inf_gui_name = "qwe_FOLDER_IMAGE_CHOOSER_GUIID_SECTOR_ewq"
Global $hMainGUI = 0

; <Check CMD>
_CmdLineSetEvent("Folder","_SetFromCMD","s_current_Folder")

; <Anti double run>
If WinExists($inf_gui_name) Then
	If $s_current_Folder <> "" And FileExists($s_current_Folder) Then
		$hFileO = FileOpen(@TempDir&"\"&$inf_name&".tmp",2)
		FileWrite($hFileO,@AutoItPID&@crlf&$s_current_Folder)
		FileClose($hFileO)
		AutoItWinSetTitle($inf_gui_name&"_new_path")
		$hTimerToExit = TimerInit()
		While 1
			Sleep(100)
			If TimerDiff($hTimerToExit) >= 3 Then Exit
		WEnd
	EndIf
	Exit
EndIf
AutoItWinSetTitle($inf_gui_name)

; ...
If $s_current_Folder = "" Or Not FileExists($s_current_Folder&"\") Then
	If Not _CurrentFolder() Then Exit 1
EndIf

; <GUI>
$hMainGUI = GUICreate($inf_namev,400,405)
; - Menu
Global $hMainMenu = GUICtrlCreateMenu("")
Global $mChooseFolder = GUICtrlCreateMenuItem(" ",$hMainMenu)
Global $mOpenFolder = GUICtrlCreateMenuItem(" ",$hMainMenu)
GUICtrlCreateMenuItem("",$hMainMenu)
Global $mCM = GUICtrlCreateMenu(" ",$hMainMenu)
Global $mCMAdd = GUICtrlCreateMenuItem("",$mCM)
Global $mCMDel = GUICtrlCreateMenuItem("",$mCM)
GUICtrlCreateMenuItem("",$hMainMenu)
Global $mExit = GUICtrlCreateMenuItem("",$hMainMenu)
; - Besides control's
Global $hPath = GUICtrlCreateInput($s_current_Folder,10,10,350,21,0x0800)
Global $hChoosePath = GUICtrlCreateButton("...",360,9,30,23)

GUICtrlCreateGroup(":",10,40,380,235)
GUICtrlCreateGraphic(30,60,340,170)
GUICtrlSetColor(-1,0x979797)
Global $hImageGUI = GUICtrlCreatePic("",31,61,338,168)
Global $hImagePath = GUICtrlCreateInput($s_current_Image,20,240,300,21,0x0800)
Global $hChooseImage = GUICtrlCreateButton("...",320,239,30,23)
Global $hClearImage = GUICtrlCreateButton("X",350,239,30,23)
_GUICtrlButton_SetTextColor(-1,"X", 0xFF0000)

GUICtrlCreateGroup("  :",10,280,380,60)
GUICtrlCreateLabel(":",20,305,35,21)
Global $hColor = _GUIColorPicker_Create('',60,303,50,23,0x000000,BitOR($CP_FLAG_CHOOSERBUTTON, $CP_FLAG_MAGNIFICATION),0,-1,-1,0,' ','...','_ColorChooserDialog')
GUICtrlCreateLabel(":",120,305,35,21)
Global $hBkColor = _GUIColorPicker_Create('',160,303,50,23,0xFFFFFF,BitOR($CP_FLAG_CHOOSERBUTTON, $CP_FLAG_MAGNIFICATION),0,-1,-1,0,' ','...','_ColorChooserDialog')
Global $hText = GUICtrlCreateInput("",220,304,158,21)

Global $hPreSet = GUICtrlCreateButton("",310,350,80,25)
Global $hCancel = GUICtrlCreateButton("",225,350,80,25)
_GUICtrlButton_SetTextColor(-1,"", 0xFF0000)
Global $hOk = GUICtrlCreateButton("",140,350,80,25)
Global $hClear = GUICtrlCreateButton("",10,350,80,25)
_GUICtrlButton_SetTextColor(-1,"", 0xFF0000)
GUICtrlSetTip(-1," ,     ")

_ReadDesktop_ini()
GUISetState()

While 1
	Switch GUIGetMsg()
		Case -3, $mExit, $hCancel
			Exit
		Case $mChooseFolder, $hChoosePath
			_CurrentFolder()
		Case $hChooseImage
			_CurrentImage()
		Case $hClearImage
			$s_current_Image = ""
			_CurrentImage_GUI()
		Case $mOpenFolder
			If FileExists($s_current_Folder) Then ShellExecute($s_current_Folder)
		Case $mCMAdd
			_SetContextMenu(1)
			MsgBox(64,$inf_namev,' "  "     !',5,$hMainGUI)
		Case $mCMDel
			_SetContextMenu(0)
			MsgBox(64,$inf_namev,' "  "     !',5,$hMainGUI)
		Case $hPreSet
			_WriteDesktop_ini()
		Case $hOk
			_WriteDesktop_ini()
			Exit
		Case $hClear
			Local $sDesktopFile = $s_current_Folder&"\desktop.ini"
			If FileExists($sDesktopFile) Then
				IniDelete($sDesktopFile,"{BE098140-A513-11D0-A3A4-00C04FD706EC}","IconArea_Image")
				IniDelete($sDesktopFile,"{BE098140-A513-11D0-A3A4-00C04FD706EC}","IconArea_Text")
				IniDelete($sDesktopFile,"{BE098140-A513-11D0-A3A4-00C04FD706EC}","IconArea_TextBackground")
				IniDelete($sDesktopFile,".ShellClassInfo","InfoTip")
				_ReadDesktop_ini()
			EndIf
	EndSwitch

	If WinExists($inf_gui_name&"_new_path") Then ;    
		$sPid = FileReadLine(@TempDir&"\"&$inf_name&".tmp",1)
		If Not @error Then
			If ProcessExists($sPid) Then
				ProcessClose($sPid)
				$sNewPath = FileReadLine(@TempDir&"\"&$inf_name&".tmp",2)
				If Not @error Then
					If FileExists($sNewPath) And StringInStr(FileGetAttrib($sNewPath),"D") Then
						$s_current_Folder = $sNewPath
						_ReadDesktop_ini()
					EndIf
				EndIf
			EndIf
		EndIf
		If WinExists($hMainGUI) Then WinActivate($hMainGUI)
	EndIf

WEnd

Func _WriteDesktop_ini()

	Local $sDesktopFile = $s_current_Folder&"\desktop.ini"

	_FolderSetImage($s_current_Folder,$s_current_Image)
	_FolderSetColors($s_current_Folder,_GUIColorPicker_GetColor($hColor),_GUIColorPicker_GetColor($hBkColor))
	_FolderSetText($s_current_Folder,GUICtrlRead($hText))

EndFunc

Func _SetContextMenu($iFlag)
	If $iFlag = 1 Then
		If @Compiled Then
	        RegWrite("HKEY_CLASSES_ROOT\Folder\shell\fimagec","","REG_SZ","  ")
			RegWrite("HKEY_CLASSES_ROOT\Folder\shell\fimagec\command","","REG_SZ",'"'&FileGetShortName(@ScriptFullPath)&'" /Folder: "%1"')
		EndIf
	Else
		RegDelete("HKEY_CLASSES_ROOT\Folder\shell\fimagec")
		If @error Then Sleep(10)
	EndIf
EndFunc

Func _ReadDesktop_ini()

	$s_current_Image = ""
	$s_current_Color = ""
	$s_current_BkColor = ""
	$s_current_Text = ""

	Local $sDesktopFile = $s_current_Folder&"\desktop.ini", $temp
	FileChangeDir($s_current_Folder)

	If $hMainGUI <> 0 Then GUICtrlSetData($hPath,$s_current_Folder)

	$temp = IniRead($sDesktopFile,"{BE098140-A513-11D0-A3A4-00C04FD706EC}","IconArea_Image","")
	$s_current_Image = $temp
	_CurrentImage_GUI()

	$temp = IniRead($sDesktopFile,"{BE098140-A513-11D0-A3A4-00C04FD706EC}","IconArea_Text",0x000000)
	$s_current_Color = BitOR(BitAND($temp, 0x00FF00), BitShift(BitAND($temp, 0x0000FF), -16), BitShift(BitAND($temp, 0xFF0000), 16))
	If $hMainGUI <> 0 Then _GUIColorPicker_SetColor($hColor,$s_current_Color)

	$temp = IniRead($sDesktopFile,"{BE098140-A513-11D0-A3A4-00C04FD706EC}","IconArea_TextBackground",0xFFFFFF)
	$s_current_BkColor = BitOR(BitAND($temp, 0x00FF00), BitShift(BitAND($temp, 0x0000FF), -16), BitShift(BitAND($temp, 0xFF0000), 16))
	If $hMainGUI <> 0 Then _GUIColorPicker_SetColor($hBkColor,$s_current_BkColor)

	$temp = IniRead($sDesktopFile,".ShellClassInfo","InfoTip","")
	$s_current_Text = $temp
	If $hMainGUI <> 0 Then GUICtrlSetData($hText,$temp)

EndFunc

Func _CurrentImage()
	While 1
		Local $temp = FileOpenDialog($inf_namev,"","   (*.bmp;*.jpg;*.gif;*.png)|BMP File (*.bmp)|JPG File (*.jpg)|GIF File (*.gif)|PNG File (*.png)")
		If @error Then
			Return 0
		EndIf
		If FileExists($temp) And _GoodImage($temp) Then
			$s_current_Image = $temp
			_CurrentImage_GUI()
			Return 1
		EndIf
	WEnd
EndFunc

Func _CurrentImage_GUI()

	Local $sImgTemp, $Width, $Height, $hOrigin, $W, $K1, $K2, $hBitmap, $hImage, $hGraphic
	$sImgTemp = @TempDir&"\FolderImageChooser_Temp.bmp"
	$Width = 338
	$Height = 168

	;DEBUG; Local $msg = StringFormat("%s (%s)%s%s (%s)",$s_current_Image,FileExists($s_current_Image),@CRLF,$sImgTemp,FileExists($sImgTemp))
	;DEBUG; MsgBox(0,"",$msg)

	If Not FileExists($s_current_Image) Or $s_current_Image = "" Then
		_GDIPlus_Startup()
		$hBitmap = _WinAPI_CreateSolidBitmap(0, _WinAPI_GetSysColor(4), $Width, $Height)
		$hImage = _GDIPlus_BitmapCreateFromHBITMAP($hBitmap)
		_GDIPlus_ImageSaveToFile($hImage, $sImgTemp)
	Else
		_ImageResize($s_current_Image,$sImgTemp,$Width,$Height)
	EndIf
	If $hMainGUI <> 0 Then GUICtrlSetImage($hImageGUI,"")
	If $hMainGUI <> 0 Then GUICtrlSetImage($hImageGUI,$sImgTemp)
	If $hMainGUI <> 0 Then GUICtrlSetData($hImagePath,$s_current_Image)
	Return 1

EndFunc

Func _ImageResize($sImageFile,$sNewImage,$Width,$Height)

	Local $hOrigin, $W, $H, $K1, $K2, $hBitmap, $hImage, $hGraphic

	_GDIPlus_Startup()
	$hOrigin = _GDIPlus_ImageLoadFromFile($sImageFile)
	$W = _GDIPlus_ImageGetWidth($hOrigin)
	$H = _GDIPlus_ImageGetHeight($hOrigin)
	$K1 = $Width / $W
	$K2 = $Height / $H
	If $K1 > $K2 Then
		$K1 = $K2
	EndIf
	$W *= $K1
	$H *= $K1
	$hBitmap = _WinAPI_CreateSolidBitmap(0, _WinAPI_GetSysColor(5), $Width, $Height)
	$hImage = _GDIPlus_BitmapCreateFromHBITMAP($hBitmap)
	_WinAPI_DeleteObject($hBitmap)
	$hGraphic = _GDIPlus_ImageGetGraphicsContext($hImage)
	_GDIPlus_GraphicsDrawImageRect($hGraphic, $hOrigin, ($Width - $W) / 2, ($Height - $H) / 2, $W, $H)
	_GDIPlus_GraphicsDispose($hGraphic)
	_GDIPlus_ImageDispose($hOrigin)
	_GDIPlus_ImageSaveToFile($hImage, $sNewImage)
	_GDIPlus_ImageDispose($hImage)
	;_GDIPlus_Shutdown()

EndFunc

Func _CurrentFolder()
	Dim $s_temp_dir
	While 1
		$s_temp_dir = FileSelectFolder($inf_namev,"")
		If @error Then
			Return 0
		EndIf
		If FileExists($s_temp_dir) Then ExitLoop
	WEnd
	$s_current_Folder = $s_temp_dir
	FileChangeDir($s_current_Folder)
	_ReadDesktop_ini()
	Return 1
EndFunc

Func _FolderSetImage($sFolder, $sImage)

	Local $sDesktopFile = $sFolder&"\desktop.ini", $sFSFolder = $sFolder&"\Folder Setting"

	;DEBUG; MsgBox(0,"",$sDesktopFile&@CRLF&$sImage&" ("&_GoodImage($sImage)&")")

	If Not _GoodImage($sImage) Then
		IniDelete($sDesktopFile,"{BE098140-A513-11D0-A3A4-00C04FD706EC}","IconArea_Image")
	Else
		If FileExists($sDesktopFile) And StringInStr(FileGetAttrib($sDesktopFile),"R") Then FileSetAttrib($sDesktopFile,"-R")
		If Not FileExists($sFolder&"\") Then DirCreate($sFolder)
		If Not FileExists($sFSFolder&"\") Then
			DirCreate($sFSFolder)
			FileSetAttrib($sFSFolder,"+H+S")
		EndIf
		If Not FileCopy($sImage,$sFSFolder&"\backround."&StringRegExpReplace($sImage,"(.*)\\([^\\]*)\.([^\\\.]*)","\3"),9) Then Return -1
		IniWrite($sDesktopFile,"{BE098140-A513-11D0-A3A4-00C04FD706EC}","IconArea_Image","Folder Setting\backround."&StringRegExpReplace($sImage,"(.*)\\([^\\]*)\.([^\\\.]*)","\3"))
	EndIf

	FileSetAttrib($sFolder,"+S")
	FileSetAttrib($sDesktopFile,"+S+H")

	Return 1

EndFunc

Func _FolderSetColors($sFolder, $iRGB, $iBkRGB = 0xFFFFFF)

	Local $sDesktopFile = $sFolder&"\desktop.ini"

	If FileExists($sDesktopFile) And StringInStr(FileGetAttrib($sDesktopFile),"R") Then FileSetAttrib($sDesktopFile,"-R")
	If Not FileExists($sFolder&"\") Then DirCreate($sFolder)

	$iRGB = BitOR(BitAND($iRGB, 0x00FF00), BitShift(BitAND($iRGB, 0x0000FF), -16), BitShift(BitAND($iRGB, 0xFF0000), 16))
	$iBkRGB = BitOR(BitAND($iBkRGB, 0x00FF00), BitShift(BitAND($iBkRGB, 0x0000FF), -16), BitShift(BitAND($iBkRGB, 0xFF0000), 16))

	IniWrite($sDesktopFile,"{BE098140-A513-11D0-A3A4-00C04FD706EC}","IconArea_Text","0x"&Hex($iRGB))
	IniWrite($sDesktopFile,"{BE098140-A513-11D0-A3A4-00C04FD706EC}","IconArea_TextBackground","0x"&Hex($iBkRGB))

	FileSetAttrib($sFolder,"+S")
	FileSetAttrib($sDesktopFile,"+S+H")

	Return 1

EndFunc

Func _FolderSetText($sFolder,$sText = "")

	Local $sDesktopFile = $sFolder&"\desktop.ini"

	If FileExists($sDesktopFile) And StringInStr(FileGetAttrib($sDesktopFile),"R") Then FileSetAttrib($sDesktopFile,"-R")
	If Not FileExists($sFolder&"\") Then DirCreate($sFolder)

	IniWrite($sDesktopFile,".ShellClassInfo","InfoTip",$sText)

	FileSetAttrib($sFolder,"+S")
	FileSetAttrib($sDesktopFile,"+S+H")

	Return 1

EndFunc

Func _GoodImage($sFile)

	$sFile = StringRegExpReplace($sFile,"(.*)\\([^\\]*)\.([^\\\.]*)","\3")
	Local $n, $a, $formats = "bmp,gif,jpg,png"
	$a = StringSplit($formats,",")
	For $n = 1 To $a[0]
		If $a[$n] = $sFile Then Return 1
	Next
	Return 0

EndFunc

Func _SetFromCMD($sValue,$sVar)
	If IsDeclared($sVar) Then Assign($sVar,$sValue)
EndFunc

; #FUNCTION# ====================================================================================================
; Name...........:  _CmdLineSetEvent
; Description....:  Sets an event for passed command line parameters
; Syntax.........:  _CmdLineSetEvent($sArguments, $sFuncName, $sParams="")
; Parameters.....:  $sArguments - The argument that will be checked and passed to the event function.
;                   $sFuncName  - Event function to call when command line is recieved.
;                   $sParams    - [Optional] Additional parameters to pass to the event function.
;
; Return values..:  Success     - Executes the $sFuncName function and returns it's value.
;                   Failure     - Returns 0 and sets @error as following:
;                                      1 - Unable to extract the command line argument.
;                                      2 - Error to call the $sFuncName function.
; Author.........:  G.Sandler (a.k.a CreatoR), creator-lab.ucoz.ru, autoit-script.ru
; Modified.......:
; Remarks........:
; Related........:
; Link...........:
; Example........:
;                    ;This is changed only for testing reasons
;                    If $CmdLine[0] = 0 Then $CmdLineRaw = '/File "C:\File.txt" /Line "Some_Line"'
;                    _CmdLineSetEvent("File", "_Show_CmdLine_Proc", "Call #1")
;                    _CmdLineSetEvent("Line", "_Show_CmdLine_Proc", "Call #2")
;
;                    Func _Show_CmdLine_Proc($sArgument, $sParams)
;                       Return MsgBox(64, $sParams, "Command Line: " & $sArgument)
;                    EndFunc
; ===============================================================================================================
Func _CmdLineSetEvent($sArguments, $sFuncName, $sParams="")
    Local $sRegExp, $sArgs, $sRet
    Local $iStripQuotes = 1, $sPar = "-/", $sVal = "=:"

    $sPar = "[" & StringRegExpReplace($sPar, "([-^\\])", "\\\1") & "]"
    $sVal = "[" & StringRegExpReplace($sVal, "([-^\\])", "\\\1") & " ]"
    $sArguments  = "\Q" & $sArguments & "\E"

    $sRegExp = '(?i)^(?:|.*?\s)'&$sPar&$sArguments&$sVal&'+(?:$|'&$sPar&'|((?:"[^"]*"|[^"])+?)(?:$|\s'&$sPar&'\w)).*'
    $sArgs = StringRegExpReplace($CmdLineRaw, $sRegExp, '\1')
    If @extended = 0 Or $sArgs = "" Then Return SetError(1, 0, 0)

    If $iStripQuotes Then $sArgs = StringRegExpReplace($sArgs, '\A"+|"+\z', '')

    $sRet = Call($sFuncName, $sArgs, $sParams)
    If @error Then $sRet = Call($sFuncName, $sArgs)
    If @error Then Return SetError(2, 0, 0)

    Return $sRet
EndFunc

Func _GUICtrlButton_SetTextColor($iCtrlID, $sText, $iTextColor)

    Local $hWnd, $hTheme, $hImageList, $hBitmap, $hBack, $hDC, $hMemDC, $hSrcDC, $tRect, $pRect, $Width, $Height, $Prev, $Flags = BitOR($DT_CENTER, $DT_SINGLELINE, $DT_VCENTER)

    $hWnd = GUICtrlGetHandle($iCtrlID)
    If Not $hWnd Then
        Return 0
    EndIf
    $hTheme = DllCall('uxtheme.dll', 'ptr', 'OpenThemeData', 'hwnd', $hWnd, 'wstr', 'BUTTON')
    If (@error) Or (Not $hTheme[0]) Then
        GUICtrlSetColor($iCtrlID, $iTextColor)
        GUICtrlSetData($iCtrlID, $sText)
        Return 1
    EndIf
    $Width = _WinAPI_GetClientWidth($hWnd)
    $Height = _WinAPI_GetClientHeight($hWnd)
    $hImageList = _GUIImageList_Create($Width - 8, $Height - 8, 4, 4)
    $tRect = DllStructCreate('int[4]')
    DllStructSetData($tRect, 1, -4, 1)
    DllStructSetData($tRect, 1, -4, 2)
    DllStructSetData($tRect, 1, $Width - 4, 3)
    DllStructSetData($tRect, 1, $Height - 4, 4)
    $pRect = DllStructGetPtr($tRect)
    $hDC = _WinAPI_GetDC(0)
    $hMemDC = _WinAPI_CreateCompatibleDC($hDC)
    $hSrcDC = _WinAPI_CreateCompatibleDC($hDC)
    $hBitmap = _WinAPI_CreateCompatibleBitmap($hDC, $Width - 8, $Height - 8)
    $hBack = _WinAPI_CreateCompatibleBitmap($hDC, $Width - 8, $Height - 8)
    _WinAPI_ReleaseDC(0, $hDC)
    _WinAPI_SelectObject($hSrcDC, $hBack)
    _WinAPI_SelectObject($hMemDC, _SendMessage($hWnd, $WM_GETFONT))
    _WinAPI_SetTextColor($hMemDC, BitOR(BitAND($iTextColor, 0x00FF00), BitShift(BitAND($iTextColor, 0x0000FF), -16), BitShift(BitAND($iTextColor, 0xFF0000), 16)))
    _WinAPI_SetBkMode($hMemDC, $TRANSPARENT)
    ; PBS_NORMAL, PBS_HOT, PBS_PRESSED, PBS_DISABLED, PBS_DEFAULTED
    For $i = 1 To 5
        $Prev = _WinAPI_SelectObject($hMemDC, $hBitmap)
        DllCall('uxtheme.dll', 'int', 'DrawThemeBackground', 'ptr', $hTheme[0], 'hwnd', $hSrcDC, 'int', 1, 'int', $i, 'ptr', $pRect, 'ptr', 0)
        _WinAPI_BitBlt($hMemDC, 0, 0, $Width - 8, $Height - 8, $hSrcDC, 0, 0, $MERGECOPY)
        If $i = 4 Then
            DllCall('uxtheme.dll', 'int', 'DrawThemeText', 'ptr', $hTheme[0], 'hwnd', $hMemDC, 'int', 1, 'int', 4, 'wstr', $sText, 'int', -1, 'dword', $Flags, 'dword', 0, 'ptr', $pRECT)
        Else
            _WinAPI_DrawText($hMemDC, $sText, $tRect, $Flags)
        EndIf
        _WinAPI_SelectObject($hMemDC, $Prev)
        _GUIImageList_Add($hImageList, $hBitmap)
    Next
    ; PBS_HOT (Stylus Hot)
    _GUIImageList_SetImageCount($hImageList, 6)
    _GUIImageList_Copy($hImageList, 1, 5)
    _WinAPI_DeleteDC($hMemDC)
    _WinAPI_DeleteDC($hSrcDC)
    _WinAPI_DeleteObject($hBitmap)
    _WinAPI_DeleteObject($hBack)
    DllCall('uxtheme.dll', 'int', 'CloseThemeData', 'ptr', $hTheme[0])
    $Prev = _GUICtrlButton_GetImageList($hWnd)
    If $Prev[0] Then
        _GUIImageList_Destroy($Prev[0])
    EndIf
    GUICtrlSetData($iCtrlID, '')
    If Not _GUICtrlButton_SetImageList($hWnd, $hImageList, 4) Then
        _GUIImageList_Destroy($hImageList)
        Return 0
    EndIf
    Return 1
EndFunc   ;==>_GUICtrlButton_SetTextColor