#Include <FreeImage.au3>

Global $ImageHandle = -1, $WorkingFileName, $FIF

_FreeImage_LoadDLL(@ScriptDir & '\FreeImage.dll')
_FreeImage_Initialise()

GUICreate('FreeImage Test GUI', 800, 700)
$ShowPic = GUICtrlCreatePic('', 0, 0, 800, 600)

$btnOpen = GUICtrlCreateButton('Choose File', 10, 610, 100, 30)
GUICtrlSetTip(-1, 'Only a copy of the image will be used')

$btnFlipH = GUICtrlCreateButton('Flip Horizontal', 120, 610, 100, 30)
$btnFlipV = GUICtrlCreateButton('Flip Vertical', 230, 610, 100, 30)
$btnRotate = GUICtrlCreateButton('Rotate ...', 340, 610, 100, 30)

GUISetState()

While 1
	Switch GUIGetMsg()
		Case - 3
			Exit
		Case $btnOpen
			_OpenImage()
		Case $btnFlipH
			If $ImageHandle <> -1 Then
				_FreeImage_FlipHorizontal($ImageHandle)
				_FreeImage_SaveU($FIF, $ImageHandle, $WorkingFileName)
				_ShowImage()
			EndIf
		Case $btnFlipV
			If $ImageHandle <> -1 Then
				_FreeImage_FlipVertical($ImageHandle)
				_FreeImage_SaveU($FIF, $ImageHandle, $WorkingFileName)
				_ShowImage()
			EndIf
		Case $btnRotate
			If $ImageHandle <> -1 Then
				$hImageNew = _FreeImage_RotateClassic($ImageHandle, Number(InputBox('Rotate', 'angle for rotation', 90)))
				_FreeImage_SaveU($FIF, $hImageNew, $WorkingFileName)
				_FreeImage_Unload($ImageHandle)
				$ImageHandle = $hImageNew
				_ShowImage()
			EndIf
	EndSwitch
WEnd

Func _OpenImage()
	Local $sFile = FileOpenDialog('Choose Image', '', 'Image Files (*.jpg;*.jpeg;*.bmp;*.gif)', 3)
	If @error Then Return
	If $ImageHandle <> -1 Then _FreeImage_Unload($ImageHandle)
	Local $dot = StringInStr($sFile, '.', 1, -1)
	Local $Name = StringLeft($sFile, $dot - 1)
	Local $Ext = StringMid($sFile, $dot)
	$WorkingFileName = $Name & '_FI4AU3' & $Ext
	FileCopy($sFile, $WorkingFileName)
	$FIF = _FreeImage_GetFileTypeU($WorkingFileName)
	If $FIF = $FIF_UNKNOWN Then
		$FIF = _FreeImage_GetFIFFromFilenameU($WorkingFileName)
	EndIf
	$ImageHandle = _FreeImage_LoadU($FIF, $sFile)
	_ShowImage()
EndFunc   ;==>_OpenImage

Func _SizeProportional(ByRef $Width, ByRef $Height, $WDesired, $HDesired, $WSrc, $HSrc)
	; Prog@ndy
	Local $RatioDes = ($WDesired / $HDesired)
	Local $CurrentRatio = ($WSrc / $HSrc)

	If $CurrentRatio > $RatioDes Then ; scale height
		$Width = $WDesired
		$Height = $WDesired / $CurrentRatio
	Else ; scale width
		$Width = $HDesired * $CurrentRatio
		$Height = $HDesired
	EndIf

EndFunc   ;==>_SizeProportional

Func _ShowImage()
	Local $Width, $Height
	_SizeProportional($Width, $Height, 800, 600, _FreeImage_GetWidth($ImageHandle), _FreeImage_GetHeight($ImageHandle))
	GUICtrlSetPos($ShowPic, 0, 0, $Width, $Height)
	GUICtrlSetImage($ShowPic, $WorkingFileName)
EndFunc   ;==>_ShowImage

Func OnAutoItExit()
	If $ImageHandle <> -1 Then _FreeImage_Unload($ImageHandle)
	_FreeImage_DeInitialise()
EndFunc   ;==>OnAutoItExit
