#Include <FreeImage.au3>

$sFile = 'Test.jpg'

_FreeImage_LoadDLL(@ScriptDir & '\FreeImage.dll')
_FreeImage_Initialise()

$FIF = _FreeImage_GetFileTypeU($sFile)
If $FIF = $FIF_UNKNOWN Then
	$FIF = _FreeImage_GetFIFFromFilenameU($sFile)
EndIf
$hImage = _FreeImage_LoadU($FIF, $sFile)
$hGrey = _FreeImage_ConvertToGreyscale($hImage)
_FreeImage_SaveU($FIF, $hGrey, @ScriptDir & '\Test_Grey.jpg')
_FreeImage_Unload($hImage)
_FreeImage_Unload($hGrey)

_FreeImage_DeInitialise()
