;========================================================================================================================================================
;  ................: ProgressBarEx.au3
; ......................:       .
; .........................: FlatX007
;   GDI+................: Yashied
; ........................: 1.1
;  .........: 09.05.2010
; ....................: AutoIt v3.3.6.0+,     Windows7 (7600).
;  .........: WindowsConstants.au3, GUIConstantsEx.au3, GDIPlus.au3, WinAPI.au3, Memory.au3
; ....................:           -   
;								        .. (100100, 200200 ...   )
;                                   PNG.
;  .............:
;		                          _OptProgressBarEx
;		                          _CreateProgressBarEx
;		                          _ProgressSetEx
;		                          _CloseBrogressBarEx
;
;   ...:
;		                          __WinAPI_SwitchColor
;		                          __LoadImage
;		                          __SetImage
;                                 __GDIPlus_ImageRotateFlip
;                                 __Style
;                                 __PathValid
;  ................:
; -----------------------------> [09.05.2010]
;                                            1.  UDF  3 .

; ()....................: 3
;
; ******************************************************************************************************************************************************
;
; #include <ProgressBarEx.au3>
;
; _OptProgressBarEx()
;
; Global $hProgesEx
;
; $hGUI = GUICreate("Examples #3 -  ProgressBarEx", 800, 300, -1, -1, BitOR($WS_SIZEBOX, $WS_VISIBLE))
; $hButton = GUICtrlCreateButton("", 700, 235, 75, 25, 0)
;
; $nProgesEx = _CreateProgressBarEx($hGUI, 10, 10, 10, 200, BitOR($PBEX_BORDER, $PBEX_GORIZONTAL))
;
; While 1
;     Switch GUIGetMsg()
;         Case -3
;             Exit
;
;         Case $hButton
;             For $i = 0 To 100
;                 Sleep(20)
; 				GUICtrlSetData($hButton, $i & " %")
;                 _ProgressSetEx($i, $hProgesEx, 5)
;             Next
;     EndSwitch
; WEnd
;
; ******************************************************************************************************************************************************
;
; #Region ;**** Directives created by AutoIt3Wrapper_GUI ****
; #AutoIt3Wrapper_outfile=Examples_#1.exe
; #AutoIt3Wrapper_UseUpx=n
; #EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
; #include <ProgressBarEx.au3>
;
; _OptProgressBarEx()
;
; Dim $aProgesEx[5]
;
; $hGUI = GUICreate("Examples #1 -  ProgressBarEx", 800, 500, -1, -1, BitOR($WS_SIZEBOX, $WS_VISIBLE))
; $hButton = GUICtrlCreateButton("", 700, 425, 75, 25, 0)
;
; $aProgesEx[0] = _CreateProgressBarEx($hGUI, 120, 10)
; $aProgesEx[1] = _CreateProgressBarEx($hGUI, 120, 50, 45, 100, $PBEX_GORIZONTAL)
; $aProgesEx[2] = _CreateProgressBarEx($hGUI, 120, 80, 180, 200, BitOR($PBEX_BORDER, $PBEX_GORIZONTAL))
;
; $aProgesEx[3] = _CreateProgressBarEx($hGUI, 10, 10, 10, 30, BitOR($PBEX_BORDER, $PBEX_VERTICAL))
; $aProgesEx[4] = _CreateProgressBarEx($hGUI, 10, 50, 70, 30, BitOR($PBEX_BORDER, $PBEX_VERTICAL))
;
; While 1
; 	Switch GUIGetMsg()
; 		Case -3
; 			Exit
;
; 		Case $hButton
; 			For $i = 0 To 100
; 				Sleep(20)
; 				$g =  StringRight($i, 1)
; 				GUICtrlSetData($hButton, $i & " %")
;
; 				_ProgressSetEx($i, $aProgesEx[0])
;
; 				Switch $i
; 					Case 0 To 30
; 						_ProgressSetEx($i + 10, $aProgesEx[1], 6)
; 					Case 30 To 60
; 						_ProgressSetEx($i + 10, $aProgesEx[1], 3)
; 					Case 60 To 100
; 						_ProgressSetEx($i + 10, $aProgesEx[1], 5)
; 				EndSwitch
;
; 				_ProgressSetEx(100 - $i, $aProgesEx[3], 5)
; 				_ProgressSetEx($i, $aProgesEx[4], 4)
;
; 				If $g = 0 Or $g = 2 Or $g = 4 Or $g = 6 Or $g = 8 Then
; 					_ProgressSetEx($i + 3, $aProgesEx[2], 3)
; 				Else
; 					_ProgressSetEx($i + 3, $aProgesEx[2], 6)
; 				EndIf
;
; 			Next
; 	EndSwitch
; WEnd
;
; ******************************************************************************************************************************************************
;
; #Region ;**** Directives created by AutoIt3Wrapper_GUI ****
; #AutoIt3Wrapper_outfile=Examples_#2.exe
; #AutoIt3Wrapper_UseUpx=n
; #AutoIt3Wrapper_Run_After=Utilities\ResHacker\ResHacker.exe -add %out%, %out%, IMAGE_1.png, rcdata, IMAGE_1, 0
; #AutoIt3Wrapper_Run_After=Utilities\ResHacker\ResHacker.exe -add %out%, %out%, IMAGE_2.png, rcdata, IMAGE_2, 0
; #AutoIt3Wrapper_Run_After=Utilities\ResHacker\ResHacker.exe -add %out%, %out%, IMAGE_3.png, rcdata, IMAGE_3, 0
; #AutoIt3Wrapper_Run_After=Utilities\ResHacker\ResHacker.exe -add %out%, %out%, IMAGE_4.png, rcdata, IMAGE_4, 0
; #AutoIt3Wrapper_Run_After=Utilities\ResHacker\ResHacker.exe -add %out%, %out%, IMAGE_5.png, rcdata, IMAGE_5, 0
; #AutoIt3Wrapper_Run_After=Utilities\ResHacker\ResHacker.exe -add %out%, %out%, IMAGE_6.png, rcdata, IMAGE_6, 0
; #AutoIt3Wrapper_Run_After=Utilities\ResHacker\ResHacker.exe -add %out%, %out%, IMAGE_7.png, rcdata, IMAGE_7, 0
; #AutoIt3Wrapper_Run_After=Utilities\ResHacker\ResHacker.exe -add %out%, %out%, IMAGE_8.png, rcdata, IMAGE_8, 0
; #AutoIt3Wrapper_Run_After=Utilities\ResHacker\ResHacker.exe -add %out%, %out%, IMAGE_9.png, rcdata, IMAGE_9, 0
; #EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
;
; #include <ProgressBarEx.au3>
;
; _OptProgressBarEx($OPT_LOAD_IMAGE_FROM_RESOURSE, "C:\ResProgressBarEx", $OPT_NO_DEL_IMAGE, $OPT_MANUAL_EXIT)
;
; Dim $aProgesEx[5]
;
; $hGUI = GUICreate("Examples #2 - ProgressBarEx", 800, 500, -1, -1, BitOR($WS_SIZEBOX, $WS_VISIBLE))
; $hButton = GUICtrlCreateButton("", 700, 425, 75, 25, 0)
;
; $aProgesEx[0] = _CreateProgressBarEx($hGUI, 120, 10)
; $aProgesEx[1] = _CreateProgressBarEx($hGUI, 120, 50, 45, 100, $PBEX_GORIZONTAL)
; $aProgesEx[2] = _CreateProgressBarEx($hGUI, 120, 80, 180, 200, BitOR($PBEX_BORDER, $PBEX_GORIZONTAL))
;
; $aProgesEx[3] = _CreateProgressBarEx($hGUI, 10, 10, 10, 30, BitOR($PBEX_BORDER, $PBEX_VERTICAL))
; $aProgesEx[4] = _CreateProgressBarEx($hGUI, 10, 50, 70, 30, BitOR($PBEX_BORDER, $PBEX_VERTICAL))
;
; While 1
; 	Switch GUIGetMsg()
; 		Case -3
; 			_CloseBrogressBarEx()
; 			Exit
;
; 		Case $hButton
; 			For $i = 0 To 100
; 				Sleep(20)
; 				$g =  StringRight($i, 1)
; 				GUICtrlSetData($hButton, $i & " %")
;
; 				_ProgressSetEx($i, $aProgesEx[0])
;
; 				Switch $i
; 					Case 0 To 30
; 						_ProgressSetEx($i + 10, $aProgesEx[1], 6)
; 					Case 30 To 60
; 						_ProgressSetEx($i + 10, $aProgesEx[1], 3)
; 					Case 60 To 100
; 						_ProgressSetEx($i + 10, $aProgesEx[1], 5)
; 				EndSwitch
;
; 				_ProgressSetEx(100 - $i, $aProgesEx[3], 5)
; 				_ProgressSetEx($i, $aProgesEx[4], 4)
;
; 				If $g = 0 Or $g = 2 Or $g = 4 Or $g = 6 Or $g = 8 Then
; 					_ProgressSetEx($i + 3, $aProgesEx[2], 3)
; 				Else
; 					_ProgressSetEx($i + 3, $aProgesEx[2], 6)
; 				EndIf
;
; 			Next
; 	EndSwitch
; WEnd
;
;========================================================================================================================================================

#include-once
#include <WindowsConstants.au3>
#include <GUIConstantsEx.au3>
#include <GDIPlus.au3>
#include <WinAPI.au3>
#include <Memory.au3>
;~ #Include <Array.au3>

_GDIPlus_Startup()
Opt("GUICoordMode", 1)

;========================================================================================================================================================
;  :

Global $PATH_IMAGE_DEFAULT = @ScriptDir                              ;   
Global $PATH_IMAGE_RES_SAVE = @ScriptDir & '\' & 'Res'               ;     
Global $LIMIT_AMOUNT_PROGRESS_BAR = 5                                ;     
Global $PBEX_INDENTION_BORDER = 5                                    ;     

;========================================================================================================================================================
;   ()  :

; _OptProgressBarEx()
Global Const $OPT_NO_DEL_IMAGE = 64
Global Const $OPT_DEL_IMAGE = 128
Global Const $OPT_LOAD_IMAGE_FROM_DIR = 512
Global Const $OPT_LOAD_IMAGE_FROM_RESOURSE = 1024
Global Const $OPT_AUTO_EXIT = 2048
Global Const $OPT_MANUAL_EXIT = 4096

; _CreateProgressBarEx()
Global Const $PBEX_DEFAULT = 0
Global Const $PBEX_BORDER = 8
Global Const $PBEX_GORIZONTAL = 16
Global Const $PBEX_VERTICAL = 32

Dim $ALL_STYLE[3] = [$PBEX_BORDER, $PBEX_GORIZONTAL, $PBEX_VERTICAL]

;========================================================================================================================================================

Dim $IMAGE_NAME_OR_RES_NAME[9][2] = [ _
		["IMAGE_1.png", "IMAGE_1"], _
		["IMAGE_2.png", "IMAGE_2"], _
		["IMAGE_3.png", "IMAGE_3"], _
		["IMAGE_4.png", "IMAGE_4"], _
		["IMAGE_5.png", "IMAGE_5"], _
		["IMAGE_6.png", "IMAGE_6"], _
		["IMAGE_7.png", "IMAGE_7"], _
		["IMAGE_8.png", "IMAGE_8"], _
		["IMAGE_9.png", "IMAGE_9"]]

Global $UBOUND_IMAGE_RES = UBound($IMAGE_NAME_OR_RES_NAME), $hBorder
Global $ahIMAGE[$UBOUND_IMAGE_RES][$LIMIT_AMOUNT_PROGRESS_BAR * 2], $ahPic[$UBOUND_IMAGE_RES], $aIMAGE_RES[$UBOUND_IMAGE_RES]

Dim $hID_PIC[102][1]
Dim $aStart[101] = [0]
Dim $RUN_OPT_PROGRESS_BAR_EX[4] = [0]

Global $GDIP_STATUS = 0
Global Const $RT_RCDATA = 10
Global Const $RT_BITMAP = 2
Global Const $STM_SETIMAGE = 0x0172
Global Const $STM_GETIMAGE = 0x0173
Global Const $PBEX_STYLE_BORDER = $WS_BORDER
Global Const $OPT_ERROR_LOAD_IMAGE = 256

; ## =============================================================================================================================================
;  ..................: _OptProgressBarEx
; .....................:      ()
; ....................: _OptProgressBarEx($iOpt [, $sPathImage [, $iDel [, $iExitFunc]]] )
;
; ....................: $iOpt = $OPT_LOAD_IMAGE_FROM_DIR -       ( )
;                                $iOpt = $OPT_LOAD_IMAGE_FROM_RESOURSE -           
;                                $sPathImage -     (  = $PATH_IMAGE_DEFAULT)
;                                $sPathImage -         (  = $PATH_IMAGE_RES_SAVE)
;                                $iDel = $OPT_DEL_IMAGE -      . ( )
;                                                              $OPT_LOAD_IMAGE_FROM_RESOURSE, $OPT_AUTO_EXIT
;                                $iDel = $OPT_NO_DEL_IMAGE -       .
;                                                                  $OPT_LOAD_IMAGE_FROM_RESOURSE
;                                $iExitFunc = $OPT_AUTO_EXIT -       . ( )
;                                $iExitFunc = $OPT_MANUAL_EXIT -     .    _CloseBrogressBarEx ( )
;
;  ERROR...............: (@error) = 1 -          .
;                                (@error) = 2 -          .
;  ........: 
; ........................: FlatX007
; ..................:
;  ...................:    ,          ,
;                                    .
;   ..............: FlatX007@yandex.ru
;  ......................: 
;========================================================================================================================================================

Func _OptProgressBarEx($iOpt = $OPT_LOAD_IMAGE_FROM_DIR, $sPathImage = "", $iDel = "", $iExitFunc = "")

	If $RUN_OPT_PROGRESS_BAR_EX[0] = 0 Then
		Switch $iOpt
			Case $OPT_LOAD_IMAGE_FROM_DIR
				If $sPathImage = "" Then
					$sPath = $PATH_IMAGE_DEFAULT
				Else
					$sP = __PathValid($sPathImage)
					If (@error) Then
						$sPath = $PATH_IMAGE_DEFAULT
					Else
						$sPath = $sP
					EndIf
				EndIf
				ConsoleWrite("$OPT_LOAD_IMAGE_FROM_DIR ; " & "Path = " & $sPath & @CRLF)

				For $i = 0 To $UBOUND_IMAGE_RES - 1
					$aIMAGE_RES[$i] = $sPath & '\' & $IMAGE_NAME_OR_RES_NAME[$i][0]
					If Not FileExists($aIMAGE_RES[$i]) Then
						$RUN_OPT_PROGRESS_BAR_EX[1] = $OPT_ERROR_LOAD_IMAGE
						Return SetError(1, 0, 0) ; ->
					EndIf
				Next
				$RUN_OPT_PROGRESS_BAR_EX[0] = $OPT_LOAD_IMAGE_FROM_DIR

			Case $OPT_LOAD_IMAGE_FROM_RESOURSE
				If $sPathImage = "" Then
					$sPath = $PATH_IMAGE_RES_SAVE
					DirCreate($sPath)
				Else
					DirCreate($sPathImage)
					$sP = __PathValid($sPathImage)
					If (@error) Then
						$sPath = $PATH_IMAGE_RES_SAVE
					Else
						$sPath = $sP
					EndIf
				EndIf
				ConsoleWrite("$OPT_LOAD_IMAGE_FROM_RESOURSE ; " & "Path = " & $sPath & @CRLF)

				For $i = 0 To $UBOUND_IMAGE_RES - 1
					_ResourceSaveToFile($sPath & '\' & $IMAGE_NAME_OR_RES_NAME[$i][0], $IMAGE_NAME_OR_RES_NAME[$i][1], $RT_RCDATA, 0, 1)
					$aIMAGE_RES[$i] = $sPath & '\' & $IMAGE_NAME_OR_RES_NAME[$i][0]
					If (@Compiled) And Not FileExists($aIMAGE_RES[$i]) Then
						$RUN_OPT_PROGRESS_BAR_EX[2] = $OPT_ERROR_LOAD_IMAGE
						Return SetError(2, 0, 0) ; ->
					EndIf
				Next

				Switch $iDel
					Case ""
						ContinueCase
					Case $OPT_DEL_IMAGE
						$RUN_OPT_PROGRESS_BAR_EX[3] = $OPT_DEL_IMAGE
					Case $OPT_NO_DEL_IMAGE
						$RUN_OPT_PROGRESS_BAR_EX[3] = $OPT_NO_DEL_IMAGE
					Case Else
						$RUN_OPT_PROGRESS_BAR_EX[3] = $OPT_DEL_IMAGE
				EndSwitch

				$RUN_OPT_PROGRESS_BAR_EX[0] = $OPT_LOAD_IMAGE_FROM_RESOURSE

			Case Else
				_OptProgressBarEx($OPT_LOAD_IMAGE_FROM_DIR, "")
		EndSwitch
	EndIf

	Switch $iExitFunc
		Case ""
			ContinueCase
		Case $OPT_AUTO_EXIT
;~ 			Opt("OnExitFunc", "_CloseBrogressBarEx")
			OnAutoItExitRegister("_CloseBrogressBarEx")
	EndSwitch

;~ 	_ArrayDisplay($aIMAGE_RES, "Func _OptProgressBarEx() ; Array - $aIMAGE_RES")

EndFunc   ;==>_OptProgressBarEx

; ## =============================================================================================================================================
;  ..................: _CreateProgressBarEx
; .....................:     ()
; ....................: _CreateProgressBarEx($hGui, $iLeft, $iRight, $iTop [, $iHeigth [, $iStyle]] )
;
; ....................: $hGui -   GUI 
;                                $iLeft -      GUI ,    $hGui (  = 10)
;                                $iRight -      GUI ,    $hGui (  = 10)
;                                $iTop -     . (  = 10)
;                                $iHeigth -  . (  = 17)
;                                $iStyle -   .
;                                $iStyle =  $PBEX_DEFAULT -    ,    , $PBEX_GORIZONTAL. ( )
;                                $iStyle =  $PBEX_GORIZONTAL -    .
;                                $iStyle =  $PBEX_VERTICAL -    .
;                                $iStyle =  BitOR($PBEX_BORDER, $PBEX_GORIZONTAL) -      .
;                                $iStyle =  BitOR($PBEX_BORDER, $PBEX_VERTICAL) -      .
;
;
;  ERROR...............: (@error) = 1 -     _OptProgressBarEx.
;                                (@error) = 2 -          .
;                                (@error) = 3 -          .
;                                (@error) = 4 -    $hGui     HWnd.
;                                (@error) = 5 -      ,   $LIMIT_AMOUNT_PROGRESS_BAR.
;  ........: (-1) -     ,    _ProgressSetEx
; ........................: FlatX007
; ..................:
;  ...................:
;   ..............: FlatX007@yandex.ru
;  ......................: 
;========================================================================================================================================================

Func _CreateProgressBarEx($hGui, $iLeft = 10, $iRight = 10, $iTop = 10, $iHeigth = 17, $iStyle = $PBEX_DEFAULT)
	If $RUN_OPT_PROGRESS_BAR_EX[0] = 0 Then Return SetError(1, 0, 0) ; ->
	If $RUN_OPT_PROGRESS_BAR_EX[1] = $OPT_ERROR_LOAD_IMAGE Then Return SetError(2, 0, 0) ; ->
	If $RUN_OPT_PROGRESS_BAR_EX[2] = $OPT_ERROR_LOAD_IMAGE Then Return SetError(3, 0, 0) ; ->

	If Not IsHWnd(WinGetHandle($hGui)) Then Return SetError(4, 0, 0) ; ->

	Global $iID_CONTRL_RANDOM = "0x" & Hex(Round(Random(99, 999999)), 8)

	If Not IsDeclared("iUBound_Id_Pic") Then
		Global $iUBound_Id_Pic = UBound($hID_PIC, 0) - 1
	Else
		$iUBound_Id_Pic += 1
		ReDim $hID_PIC[102][$iUBound_Id_Pic]
	EndIf

	If $iUBound_Id_Pic > $LIMIT_AMOUNT_PROGRESS_BAR Then
		If SetError(5, 0, 1) Then Return -1 ; ->
	EndIf

	$hWnd = WinGetClientSize(WinGetHandle($hGui))
	$iWidhtImageSegmet = ($hWnd[0] - ($iLeft + $iRight)) / 100
	$iHeigtImageSegmet = ($hWnd[1] - ($iLeft + $iRight)) / 100

	$i_Style = __Style($iStyle)
	Switch $i_Style
		Case $PBEX_DEFAULT
			ContinueCase

		Case $PBEX_GORIZONTAL
			For $ia = $iUBound_Id_Pic - 1 To $iUBound_Id_Pic - 1
				For $i = 1 To 100
					If $i = 1 Then
						$hID_PIC[0][$ia] = $iID_CONTRL_RANDOM
						$hID_PIC[101][$ia] = $iStyle
					EndIf
					$hID_PIC[$i][$ia] = GUICtrlCreatePic("", (($iWidhtImageSegmet * $i) + $iLeft) - $iWidhtImageSegmet, $iTop, $iWidhtImageSegmet + 1, $iHeigth)
					GUICtrlSetResizing($hID_PIC[$i][$ia], $GUI_DOCKALL)
				Next
			Next

		Case $PBEX_VERTICAL
			For $ia = $iUBound_Id_Pic - 1 To $iUBound_Id_Pic - 1
				For $i = 1 To 100
					If $i = 1 Then
						$hID_PIC[0][$ia] = $iID_CONTRL_RANDOM
						$hID_PIC[101][$ia] = $iStyle
					EndIf
					$hID_PIC[$i][$ia] = GUICtrlCreatePic("", $iTop, (($iHeigtImageSegmet * $i) + $iLeft) - $iHeigtImageSegmet, $iHeigth, $iHeigtImageSegmet + 1)
					GUICtrlSetResizing($hID_PIC[$i][$ia], $GUI_DOCKALL)
				Next
			Next

		Case 24
			For $ia = $iUBound_Id_Pic - 1 To $iUBound_Id_Pic - 1
				For $i = 1 To 100
					If $i = 1 Then
						$hID_PIC[0][$ia] = $iID_CONTRL_RANDOM
						$hID_PIC[101][$ia] = $iStyle
					EndIf
					$hID_PIC[$i][$ia] = GUICtrlCreatePic("", (($iWidhtImageSegmet * $i) + $iLeft) - $iWidhtImageSegmet, $iTop, $iWidhtImageSegmet + 1, $iHeigth)
					GUICtrlSetResizing($hID_PIC[$i][$ia], $GUI_DOCKALL)
				Next
			Next
			$hBorder = GUICtrlCreateLabel("", $iLeft - $PBEX_INDENTION_BORDER, $iTop - $PBEX_INDENTION_BORDER, ($hWnd[0] - ($iLeft + $iRight)) + ($PBEX_INDENTION_BORDER * 2), $iHeigth + ($PBEX_INDENTION_BORDER * 2), $PBEX_STYLE_BORDER)
			GUICtrlSetResizing($hBorder, $GUI_DOCKALL)
			GUICtrlSetBkColor($hBorder, $GUI_BKCOLOR_TRANSPARENT)

		Case 40
			For $ia = $iUBound_Id_Pic - 1 To $iUBound_Id_Pic - 1
				For $i = 1 To 100
					If $i = 1 Then
						$hID_PIC[0][$ia] = $iID_CONTRL_RANDOM
						$hID_PIC[101][$ia] = $iStyle
					EndIf
					$hID_PIC[$i][$ia] = GUICtrlCreatePic("", $iTop, (($iHeigtImageSegmet * $i) + $iLeft) - $iHeigtImageSegmet, $iHeigth, $iHeigtImageSegmet + 1)
					GUICtrlSetResizing($hID_PIC[$i][$ia], $GUI_DOCKALL)
				Next
			Next
			$hBorder = GUICtrlCreateLabel("", $iTop - $PBEX_INDENTION_BORDER, $iLeft - $PBEX_INDENTION_BORDER, $iHeigth + ($PBEX_INDENTION_BORDER * 2), ($hWnd[1] - ($iLeft + $iRight)) + ($PBEX_INDENTION_BORDER * 2), $PBEX_STYLE_BORDER)
			GUICtrlSetResizing($hBorder, $GUI_DOCKALL)
			GUICtrlSetBkColor($hBorder, $GUI_BKCOLOR_TRANSPARENT)
	EndSwitch

	$Index = $ia - 1
	__LoadImage($Index) ; 0, 1 ...

;~ 	_ArrayDisplay($hID_PIC, "Func _CreateProgressBarEx() ; Array - $hID_PIC")

	Return $iID_CONTRL_RANDOM
EndFunc   ;==>_CreateProgressBarEx

; ## =============================================================================================================================================
;  ..................: _ProgressSetEx
; .....................:         .
; ....................: _ProgressSetEx($iProgress [, $iIdContrl [, Image]] )
;_
; ....................: $iProgress -   ,  0  100.
;                                $iIdContrl -      ,   _CreateProgressBarEx,
;                                              "   ",         .
;                                $iImage -  ""      ,  $IMAGE_NAME_OR_RES_NAME. (  = 4)
;  ERROR...............: (@error) = 1 -      $IMAGE_NAME_OR_RES_NAME, $iImage = 0
;  ........: 
; ........................: FlatX007
; ..................:
;  ...................:
;   ..............: FlatX007@yandex.ru
;  ......................: 
;========================================================================================================================================================

Func _ProgressSetEx($iProgress = 0, $iIdContrl = 0, $iImage = 0)

	If $RUN_OPT_PROGRESS_BAR_EX[1] = $OPT_ERROR_LOAD_IMAGE Then Return ; ->
	If $RUN_OPT_PROGRESS_BAR_EX[2] = $OPT_ERROR_LOAD_IMAGE Then Return ; ->
	If $iIdContrl = -1 Then Return ; ->

	If $iIdContrl = 0 And UBound($hID_PIC, 0) - 1 = 1 Then $iIdContrl = $hID_PIC[0][0]


	If $RUN_OPT_PROGRESS_BAR_EX[0] = $OPT_LOAD_IMAGE_FROM_DIR Then
		If $iImage > $UBOUND_IMAGE_RES - 1 Or StringLeft($iImage, 1) = "-" Then
			$iImage = 0
			SetError(1, 0, 0)
		EndIf
	EndIf

	For $IndexArrayStart = 0 To UBound($hID_PIC, 1) - 1
		If $hID_PIC[0][$IndexArrayStart] = $iIdContrl Then ExitLoop
	Next

	If $iProgress < $aStart[$IndexArrayStart] Then
		If StringLeft($iProgress, 1) = "-" Then $iProgress = 0
		For $i = $iProgress To $aStart[$IndexArrayStart]
			GUICtrlSetImage($hID_PIC[$i][$IndexArrayStart], "")
		Next
	Else
		If $iProgress > 100 Then $iProgress = 100
		For $i = $aStart[$IndexArrayStart] To $iProgress
			Switch $IndexArrayStart
				Case 0
					$ImageNormal = $IndexArrayStart
					$ImageRotate90 = 1
				Case Else
					$ImageNormal = $IndexArrayStart * 2
					$ImageRotate90 = ($IndexArrayStart * 2) + 1
			EndSwitch

			Switch __Style($hID_PIC[101][$IndexArrayStart])
				Case $PBEX_DEFAULT
					ContinueCase
				Case $PBEX_GORIZONTAL, 24
					__SetImage($hID_PIC[$i][$IndexArrayStart], _GDIPlus_BitmapCreateHBITMAPFromBitmap($ahIMAGE[$iImage][$ImageNormal])) ;1
				Case $PBEX_VERTICAL, 40, 104
					__SetImage($hID_PIC[$i][$IndexArrayStart], _GDIPlus_BitmapCreateHBITMAPFromBitmap($ahIMAGE[$iImage][$ImageRotate90])) ;2
			EndSwitch
		Next
	EndIf

	$aStart[$IndexArrayStart] = $iProgress

EndFunc   ;==>_ProgressSetEx

; ## =============================================================================================================================================
;  ..................: _CloseBrogressBarEx
; .....................:            .  _OptProgressBarEx
; ....................: _CloseBrogressBarEx ( )
; ....................: 
;  ERROR...............: 
;  ........: 
; ........................: FlatX007
; ..................:
;  ...................:      ,     
;                                _OptProgressBarEx ( , , , $OPT_MANUAL_EXIT)      .
;   ..............: FlatX007@yandex.ru
;  ......................: 
;========================================================================================================================================================

Func _CloseBrogressBarEx()

	Local $Srting
	Local $Atrib = 'Del /F /Q '

	If $RUN_OPT_PROGRESS_BAR_EX[3] = $OPT_DEL_IMAGE Then
		For $i = 0 To $UBOUND_IMAGE_RES - 1
			$Srting &= $Atrib & ' "' & $aIMAGE_RES[$i] & '"' & ' & '
		Next
	EndIf

	$Srting = StringTrimRight($Srting, 2)
	Run(@ComSpec & ' /c ' & $Srting, '', @SW_HIDE)

	For $r = 0 To 1
		For $i = 0 To $UBOUND_IMAGE_RES - 1
			_GDIPlus_ImageDispose($ahIMAGE[$i][$r])
		Next
	Next

	_GDIPlus_Shutdown()

EndFunc   ;==>_CloseBrogressBarEx

Func __Style($iStyle)

;~ 24 - BitOR($PBEX_BORDER, $PBEX_GORIZONTAL)
;~ 40 - BitOR($PBEX_BORDER, $PBEX_VERTICAL)

	For $i = 0 To UBound($ALL_STYLE) - 1
		If $iStyle = $ALL_STYLE[$i] Then Return $ALL_STYLE[$i]
	Next

	Switch $iStyle
		Case 24, 40
			Return $iStyle
		Case Else
			Return $PBEX_DEFAULT
	EndSwitch

EndFunc   ;==>__Style

; #FUNCTION# ============================================================================================================================================
; Name...........: __GDIPlus_ImageRotateFlip
; Description ...: Rotates and flips an image
; Syntax.........: __GDIPlus_ImageRotateFlip($hImage, $iRotateFlipType)
; Parameters ....: $hImage  		- Pointer to an Image object
;                  $iRotateFlipType - Type of rotation and flip:
;                  |0 - No rotation and no flipping (A 180-degree rotation, a horizontal flip and then a vertical flip)
;                  |1 - A 90-degree rotation without flipping (A 270-degree rotation, a horizontal flip and then a vertical flip)
;                  |2 - A 180-degree rotation without flipping (No rotation, a horizontal flip folow by a vertical flip)
;                  |3 - A 270-degree rotation without flipping (A 90-degree rotation, a horizontal flip and then a vertical flip)
;                  |4 - No rotation and a horizontal flip (A 180-degree rotation followed by a vertical flip)
;                  |5 - A 90-degree rotation followed by a horizontal flip (A 270-degree rotation followed by a vertical flip)
;                  |6 - A 180-degree rotation followed by a horizontal flip (No rotation and a vertical flip)
;                  |7 - A 270-degree rotation followed by a horizontal flip (A 90-degree rotation followed by a vertical flip)
; Return values .: Success      - True
;                  Failure      - False and either:
;                  |@error and @extended are set if DllCall failed
;                  |$GDIP_STATUS contains a non zero value specifying the error code
; Remarks .......: None
; Related .......: None
; Link ..........; @@MsdnLink@@ GdipImageRotateFlip
; Example .......; No
;========================================================================================================================================================
Func __GDIPlus_ImageRotateFlip($hImage, $iRotateFlipType)
	Local $aResult = DllCall($ghGDIPDll, "uint", "GdipImageRotateFlip", "hwnd", $hImage, "int", $iRotateFlipType)

	If @error Then Return SetError(@error, @extended, False)
	$GDIP_STATUS = $aResult[0]
	Return $aResult[0] = 0
EndFunc   ;==>__GDIPlus_ImageRotateFlip

Func __SetImage($hWnd, $hBitmap)

	If Not IsHWnd($hWnd) Then
		$hWnd = GUICtrlGetHandle($hWnd)
		If Not $hWnd Then Return
	EndIf

	Local $hObj

	$hObj = _SendMessage($hWnd, $STM_SETIMAGE, 0, $hBitmap)
	If $hObj Then _WinAPI_DeleteObject($hObj)
	_WinAPI_InvalidateRect($hWnd)
	$hObj = _SendMessage($hWnd, $STM_GETIMAGE)
	If $hObj <> $hBitmap Then _WinAPI_DeleteObject($hBitmap)

EndFunc   ;==>__SetImage

Func __PathValid($Path)
	Local $sPath, $a = $Path

	If StringRight($Path, 1) = "\" Then
		$sPath = StringTrimRight($Path, 1)
		If Not FileExists($Path) Then Return SetError(1, 0, 0)
		Return $sPath
	EndIf

	If Not FileExists($Path) Then Return SetError(2, 0, 0)
	Return $a

EndFunc   ;==>__PathValid

Func __LoadImage($Index)

	Switch $Index
		Case 0
			$ImageNormal = $Index ; 0
			$ImageRotate90 = 1 ; 1
		Case Else
			$ImageNormal = $Index * 2 ; 2 , 4 ...
			$ImageRotate90 = ($Index * 2) + 1 ; 3 , 5 ...
	EndSwitch

	For $r = $ImageNormal To $ImageRotate90
		For $i = 0 To $UBOUND_IMAGE_RES - 1
			$ahPic[$i] = _GDIPlus_ImageLoadFromFile($aIMAGE_RES[$i])
			If $r = $ImageRotate90 Then __GDIPlus_ImageRotateFlip($ahPic[$i], 1)
			$W = _GDIPlus_ImageGetWidth($ahPic[$i])
			$H = _GDIPlus_ImageGetHeight($ahPic[$i])
			$Size = WinGetClientSize(GUICtrlGetHandle($hID_PIC[1][$Index]))

			If ($W) And ($H) And (IsArray($Size)) Then
				If $W < $H Then
					$W = $Size[0] * $W / $H
					$H = $Size[1]
				Else
					$H = $Size[1] * $H / $W
					$W = $Size[0]
				EndIf
				$hBitmap = _WinAPI_CreateBitmap($Size[0], $Size[1], 1, 32)
				$ahIMAGE[$i][$r] = _GDIPlus_BitmapCreateFromHBITMAP($hBitmap)
				_WinAPI_DeleteObject($hBitmap)
				$hGraphic = _GDIPlus_ImageGetGraphicsContext($ahIMAGE[$i][$r])
				$hBrush = _GDIPlus_BrushCreateSolid(BitOR(0xFF000000, __WinAPI_SwitchColor(_WinAPI_GetSysColor($COLOR_3DFACE))))
				_GDIPlus_GraphicsFillRect($hGraphic, 0, 0, $Size[0], $Size[1], $hBrush)
				_GDIPlus_GraphicsDrawImageRect($hGraphic, $ahPic[$i], ($Size[0] - $W) / 2, ($Size[1] - $H) / 2, $W, $H)
				_GDIPlus_GraphicsDispose($hGraphic)
				_GDIPlus_BrushDispose($hBrush)
			EndIf
		Next
	Next

;~ 	_ArrayDisplay($ahIMAGE, "Func __LoadImage() ; Array - $ahIMAGE")

EndFunc   ;==>__LoadImage

Func __WinAPI_SwitchColor($iColor)
	Return BitOR(BitAND($iColor, 0x00FF00), BitShift(BitAND($iColor, 0x0000FF), -16), BitShift(BitAND($iColor, 0xFF0000), 16))
EndFunc   ;==>__WinAPI_SwitchColor


;========================================================================================================================================================
;~                               Resources.au3   http://www.autoitscript.com/forum/index.php?showtopic=51103
;========================================================================================================================================================

Func _ResourceGet($ResName, $ResType = 10, $ResLang = 0, $DLL = -1)
	Local Const $IMAGE_BITMAP = 0
	Local $hInstance, $hBitmap, $InfoBlock, $GlobalMemoryBlock, $MemoryPointer, $ResSize

	If $DLL = -1 Then
		$hInstance = _WinAPI_GetModuleHandle("")
	Else
		$hInstance = _WinAPI_LoadLibrary($DLL)
	EndIf
	If $hInstance = 0 Then Return SetError(1, 0, 0)

	If $ResType = $RT_BITMAP Then
		$hBitmap = _WinAPI_LoadImage($hInstance, $ResName, $IMAGE_BITMAP, 0, 0, 0)
		If @error Then Return SetError(2, 0, 0)
		Return $hBitmap ; returns handle to Bitmap
	EndIf

	If $ResLang <> 0 Then
		$InfoBlock = DllCall("kernel32.dll", "int", "FindResourceExA", "int", $hInstance, "long", $ResType, "str", $ResName, "short", $ResLang)
	Else
		$InfoBlock = DllCall("kernel32.dll", "int", "FindResourceA", "int", $hInstance, "str", $ResName, "long", $ResType)
	EndIf

	If @error Then Return SetError(3, 0, 0)
	$InfoBlock = $InfoBlock[0]
	If $InfoBlock = 0 Then Return SetError(4, 0, 0)

	$ResSize = DllCall("kernel32.dll", "dword", "SizeofResource", "int", $hInstance, "int", $InfoBlock)
	If @error Then Return SetError(5, 0, 0)
	$ResSize = $ResSize[0]
	If $ResSize = 0 Then Return SetError(6, 0, 0)

	$GlobalMemoryBlock = DllCall("kernel32.dll", "int", "LoadResource", "int", $hInstance, "int", $InfoBlock)
	If @error Then Return SetError(7, 0, 0)
	$GlobalMemoryBlock = $GlobalMemoryBlock[0]
	If $GlobalMemoryBlock = 0 Then Return SetError(8, 0, 0)

	$MemoryPointer = DllCall("kernel32.dll", "int", "LockResource", "int", $GlobalMemoryBlock)
	If @error Then Return SetError(9, 0, 0)
	$MemoryPointer = $MemoryPointer[0]
	If $MemoryPointer = 0 Then Return SetError(10, 0, 0)

	If $DLL <> -1 Then _WinAPI_FreeLibrary($hInstance)
	If @error Then Return SetError(11, 0, 0)

	SetExtended($ResSize)
	Return $MemoryPointer
EndFunc   ;==>_ResourceGet

Func _ResourceSaveToFile($FileName, $ResName, $ResType = 10, $ResLang = 0, $CreatePath = 0, $DLL = -1) ; $RT_RCDATA = 10
	Local $ResStruct, $ResSize, $FileHandle

	If $CreatePath Then $CreatePath = 8 ; mode 8 = Create directory structure if it doesn't exist in FileOpen()

	If $ResType = $RT_BITMAP Then
		; workaround: for RT_BITMAP _ResourceGetAsBytes() doesn't work so use _ResourceGetAsImage()
		$hImage = _ResourceGetAsImage($ResName, $ResType)
		If @error Then Return SetError(10, 0, 0)

		; create filepath if doesn't exist
		$FileHandle = FileOpen($FileName, 2 + 16 + $CreatePath)
		If @error Then Return SetError(11, 0, 0)
		FileClose($FileHandle)
		If @error Then Return SetError(12, 0, 0)

		_GDIPlus_ImageSaveToFile($hImage, $FileName)
		_GDIPlus_ImageDispose($hImage)

		$ResSize = FileGetSize($FileName)
	Else
		; standard way
		$ResStruct = _ResourceGetAsBytes($ResName, $ResType, $ResLang, $DLL)
		If @error Then Return SetError(1, 0, 0)
		$ResSize = DllStructGetSize($ResStruct)

		$FileHandle = FileOpen($FileName, 2 + 16 + $CreatePath)
		If @error Then Return SetError(2, 0, 0)
		FileWrite($FileHandle, DllStructGetData($ResStruct, 1))
		If @error Then Return SetError(3, 0, 0)
		FileClose($FileHandle)
		If @error Then Return SetError(4, 0, 0)
	EndIf

	Return $ResSize
EndFunc   ;==>_ResourceSaveToFile

Func _ResourceGetAsBytes($ResName, $ResType = 10, $ResLang = 0, $DLL = -1) ; $RT_RCDATA = 10
	Local $ResPointer, $ResSize

	$ResPointer = _ResourceGet($ResName, $ResType, $ResLang, $DLL)
	If @error Then Return SetError(1, 0, 0)
	$ResSize = @extended
	Return DllStructCreate("byte[" & $ResSize & "]", $ResPointer) ; returns struct with bytes
EndFunc   ;==>_ResourceGetAsBytes

Func _ResourceGetAsImage($ResName, $ResType = 10, $DLL = -1) ; $RT_RCDATA = 10
	Local $ResData, $nSize, $hData, $pData, $pStream, $pBitmap, $hBitmap

	$ResData = _ResourceGet($ResName, $ResType, 0, $DLL)
	If @error Then Return SetError(1, 0, 0)
	$nSize = @extended

	If $ResType = $RT_BITMAP Then
 		; $ResData is hBitmap type
		$hImage = _GDIPlus_BitmapCreateFromHBITMAP($ResData)
	Else
 		; $ResData is memory pointer
		; thanks ProgAndy
		$hData = _MemGlobalAlloc($nSize,2)
		$pData = _MemGlobalLock($hData)
		_MemMoveMemory($ResData,$pData,$nSize)
		_MemGlobalUnlock($hData)
		$pStream = DllCall( "ole32.dll","int","CreateStreamOnHGlobal", "int",$hData, "long",1, "Int*",0)
		$pStream = $pStream[3]
		$hImage = DllCall($ghGDIPDll,"int","GdipCreateBitmapFromStream", "ptr",$pStream, "int*",0)
		$hImage = $hImage[2]
		_WinAPI_DeleteObject($pStream)
		; next line must be commented otherwise animated GIFs will not work
;~ 		_MemGlobalFree($hData)
	EndIf

	Return $hImage ; hImage type
EndFunc
