#include-once

Global $sCommand, $TCPHTTP_CURBYTES, $TCPHTTP_BODY, $TCPHTTP_SOCKET




Func _TCPHttpOpen ($type,$link,$protocol='HTTP/1.1')
	If Not StringRegExp ($link,"^(http://)(www\.)?(([a-zA-Z0-9])([a-zA-Z0-9_.-]+)\.)?([a-zA-Z0-9])([a-zA-Z0-9_.-]+)\.([a-zA-Z]{2,4})/.*$") Then Return SetError(-1,0,0)
	Local $sHost = StringFindSE($link,'http://','/')
	Local $sPage = '/'&StringFindSE($link,'/','',3)
	Local $sName_To_IP = TCPNameToIP($sHost)
	If Not $sName_To_IP Then Return SetError(-2,@error,0)
	While 1
	Local $Socket = TCPConnect($sName_To_IP, 80)
	if IsDeclared ("HeadersSock"&$Socket) = 0 Then ExitLoop
	If $Socket = -1 Or $Socket = 0 Then
		TCPCloseSocket($Socket)
		Return SetError(-3, 0, 0)
	EndIf
	TCPCloseSocket($Socket)
	WEnd
	Global $sCommand = $type&" "&$sPage&" "&$protocol&@CRLF
	Return SetError(0, 0, $Socket)
EndFunc ;return $Socket ;@ex = 0

Func _TCPHttpSetRequestHeader ($header,$value)
	If $header='' Or $value='' Then Return SetError(-1, 0, 0)
	$sCommand &= $header&": "&$value&@CRLF
	Return SetError(0, 0, 1)
EndFunc ;return 1 ;@ex = 0

Func _TCPHttpSetRequestHeaders ($headers)
	If $headers='' Then Return SetError(-1, 0, 0)
	Local $temp_arr = StringSplit($headers,@CRLF,1)
	For $i=1 To $temp_arr[0]
		If $temp_arr[$i]='' And $temp_arr[0]=$i Then ExitLoop
		StringSplit($temp_arr[$i],': ',1)
		If @error Then Return SetError(-2, $i, 0)
	Next
	$sCommand &= $headers
	Return SetError(0, $temp_arr[0]-1, 1)
EndFunc ;return 1 ;@ex = Num Of Headers

Func _TCPHttpSend ($Socket,$value='')
	$sCommand &= @CRLF&$value
	Local $BytesSent = TCPSend($Socket, $sCommand)
	If $BytesSent = 0 Then Return SetError(-1, @error, 0)
	Return SetError(0, $BytesSent, 1)
EndFunc ;return 1 ;@ex = $BytesSent

Func _TCPHttpGetStatus ($Socket)
	Local $sRecv, $sCurRecv
	While 1
		$sRecv = TCPRecv($Socket,1)
		If @error <> 0 Then Return SetError(-1, 0, 0)
		If $sRecv <> '' Then ExitLoop
	WEnd
	While 1
		$sCurRecv = TCPRecv($Socket,1)
		If @error <> 0 Then Return SetError(-1, 0, 0)
		If $sCurRecv <> "" Then
			If $sCurRecv = @CR And TCPRecv($Socket,1) = @LF Then
				$sCurRecv = StringSplit($sRecv,' ',3)
				Assign ("StatusSock"&$Socket,$sCurRecv[1],2)
				Return SetError(0, $sCurRecv[2], $sCurRecv[1])
			Else
				$sRecv &= $sCurRecv
			EndIf
		EndIf
	WEnd
EndFunc ;return Status ;@ex = StatusText

Func _TCPHttpStatus ($Socket)
	If IsDeclared ("StatusSock"&$Socket) Then
		Return SetError(0, 0, Eval("StatusSock"&$Socket))
	Else
		Return SetError(-1, 0, 0)
	EndIf
EndFunc ;return Status ;@ex = 0

Func _TCPHttpGetAllResponseHeaders ($Socket)
	Local $hRecv, $sCurRecv
	While 1
		$hRecv = TCPRecv($Socket,1)
		If @error <> 0 Then Return SetError(-1, 0, 0)
		If $hRecv <> '' Then ExitLoop
	WEnd
	While 1
		$hCurRecv = TCPRecv($Socket,1)
		If @error <> 0 Then Return SetError(-1, 0, 0)
		If $hCurRecv <> "" Then
			If $hCurRecv = @CR And TCPRecv($Socket,1) = @LF Then
				$hCurRecv = TCPRecv($Socket,1)
				If $hCurRecv = @CR And TCPRecv($Socket,1) = @LF Then
					$hCurRecv = StringSplit($hRecv,@CRLF,1)
					Assign ("HeadersSock"&$Socket,$hRecv,2)
					Return SetError (0,$hCurRecv[0],$hRecv)
				Else
					$hRecv &= @CRLF&$hCurRecv
				EndIf
			Else
				$hRecv &= $hCurRecv
			EndIf
		EndIf
	WEnd
EndFunc ;return Headers ;@ex = Num Of Headers

Func _TCPHttpAllResponseHeaders ($Socket)
	If IsDeclared ("HeadersSock"&$Socket) Then
		Return SetError(0, 0, Eval("HeadersSock"&$Socket))
	Else
		Return SetError(-1, 0, 0)
	EndIf
EndFunc ;return Headers ;@ex = 0

Func _TCPHttpResponseCookies ($Socket)
	If Not IsDeclared ("HeadersSock"&$Socket) Then
		Return SetError(-1, 0, 0)
	Else
		Local $Cookies, $a=0
		$Header = StringSplit("HeadersSock"&$Socket,@CRLF,2)
		For $i=1 To $Header[0]
			If StringInStr ($Header[$i],'Set-Cookie: ') Then
				$a += 1
				$Cookies &= StringFindSE ($Header[$i],'Set-Cookie: ',';',$a)&'; '
			EndIf
		Next
		If $a > 0 Then
			$Cookies = StringTrimRight($Cookies,2)
			Return SetError(0, $a, $Cookies)
		Else
			Return SetError(-2, 0, 0)
		EndIf
	EndIf
EndFunc ;return Cookies ;@ex = Num Of Cookies

Func _TCPHttpGetResponseBody ($Socket,$isBinary=1)
	While 1
		$fRecv = TCPRecv($Socket,1,1)
		If @error <> 0 Then Return SetError(-1, 0, 0)
		If $fRecv <> '' Then ExitLoop
	WEnd
	While 1
		$sCurRecv = TCPRecv($Socket,1,1)
		If @error <> 0 Then ExitLoop
		If $sCurRecv <> "" Then
			$fRecv &= $sCurRecv
		EndIf
	WEnd
	If $isBinary = 1 Then
		Return SetError(0, BinaryLen ($fRecv), $fRecv)
	ElseIf $isBinary = 0 Then
		$fRecv = BinaryToString($fRecv)
		Return SetError(0, StringLen($fRecv), $fRecv)
	EndIf
	TCPCloseSocket($Socket)
EndFunc ;return Body Data ;@ex = Size

Func _TCPHttpGetResponseBodyBG ($Socket)
	While 1
		$TCPHTTP_BODY = TCPRecv($Socket,1,1)
		If @error <> 0 Then Return SetError(-1, 0, 0)
		If $TCPHTTP_BODY <> '' Then ExitLoop
	WEnd
	$TCPHTTP_SOCKET = $Socket
	AdlibRegister('_TCPHttpGetResponseBodyAdlib',250)
	Return SetError(0, 0, 1)
EndFunc ;return 1 ;@ex = 0

Func _TCPHttpGetResponseBodyAdlib ()
	$sCurRecv = TCPRecv($TCPHTTP_SOCKET,1048576,1)
	If @error <> 0 Then
		$TCPHTTP_CURBYTES = '-1'
		AdlibUnRegister ('_TCPHttpGetResponseBodyAdlib')
		TCPCloseSocket($TCPHTTP_SOCKET)
		$TCPHTTP_SOCKET = ''
		Return
	EndIf
	If $sCurRecv <> "" Then
		$TCPHTTP_BODY &= $sCurRecv
		$TCPHTTP_CURBYTES = BinaryLen ($TCPHTTP_BODY)
	EndIf
EndFunc


Func StringFindSE($string,$start,$end,$start_occ=1,$end_occ=1,$cas=0)
    Local $source_start,$source_count,$source
    If $start <> '' Then
		Local $st_count
		$st_count = StringSplit($start,'')
		$source_start = StringInStr($string,$start,$cas,$start_occ) + $st_count[0]
	Else
		$source_start = 1
	EndIf
	If $end <> '' Then
		$source_count = StringInStr($string,$end,$cas,$end_occ,$source_start) - $source_start
	Else
		$source_count = -1
	EndIf
	$source = StringMid ($string,$source_start,$source_count)
	;debug
;~ 	ConsoleWrite(@CRLF& ">  : "&$source_start&@CRLF& _
;~ 						"> - : "&$source_count&@CRLF& _
;~ 						"> : "&$source&@CRLF)
    ;debug
	Return $source
EndFunc
