#include-once
#include <GUIConstantsEx.au3>
#include <ComboConstants.au3>
#include <WindowsConstants.au3>

Global Enum _
	$iMSG_First = 0, _
		$iMSG_AutoItScriptsCollector, $iMSG_SpeciallyForAut_ussianCommunity, _
		$iMSG_UpdateCheck, $iMSG_PleaseCompileThisApp, $iMSG_ThereWasErrorCheckUpdates, $iMSG_ThereIsNewVersion, _
		$iMSG_ThereWasErrorDownloadUpdate, $iMSG_YouAreUsingNewstVersion, $iMSG_PleaseCheckInternetConnect, $iMSG_Downloading, $iMSG_Completed, _
		$iMSG_ShowMainWindow, $iMSG_CreateScript, $iMSG_Exit, _
		$iMSG_Count, $iMSG_ScriptName, $iMSG_Author, $iMSG_Size, $iMSG_Modified, _
		$iMSG_FilePath, $iMSG_MainContextMenu, $iMSG_CreateScript_1, $iMSG_AddScripts, $iMSG_CopyScriptsTo, _
		$iMSG_CopyScriptsToOtherCategory, $iMSG_RunScript, $iMSG_EditScript, $iMSG_RenameScript, $iMSG_DeleteScriptFile, _
		$iMSG_RemoveScriptFromList, $iMSG_CopyScriptsFullPath, $iMSG_CopyScriptsFileName, $iMSG_CopyScriptsInformation, $iMSG_OpenScriptDir, _
		$iMSG_SearchScriptOnAutoitScriptCom, $iMSG_SearchScriptOnAutoitScriptRu, _
		$iMSG_Search, $iMSG_RegExpSearch, $iMSG_CaseSensitive, $iMSG_WholeWordOnly, $iMSG_SearchInsideTheScripts, _
		$iMSG_FilterBy, $iMSG_Count_1, $iMSG_ScriptName_1, $iMSG_Author_1, $iMSG_Size_1, _
		$iMSG_Modified_1, $iMSG_FilePath_1, $iMSG_Category, $iMSG_MoveItemUp, $iMSG_MoveItemDown, _
		$iMSG_Category_1, $iMSG_CategoryControls, $iMSG_NewCategory, $iMSG_NewGroup, $iMSG_Remove, _
		$iMSG_Remove_1, $iMSG_Clear, $iMSG_Clear_1, $iMSG_Rename, $iMSG_RemoveEmptyCategories, _
		$iMSG_RemoveNotExistingScripts, $iMSG_Exit_1, $iMSG_Visit, $iMSG_Visit_1, $iMSG_Settings, _
		$iMSG_ShowSettingsDialog, $iMSG_About, $iMSG_ShowAboutDialog, $iMSG_NewCategory_1, $iMSG_EnterANameForNewCategory, _
		$iMSG_NewGroup_1, $iMSG_EnterANameForNewGroup, $iMSG_Attention, $iMSG_AreYouSureRemov_mListCompletely, _
		$iMSG_DoNotAskMeAgain, $iMSG_Yes, $iMSG_No, $iMSG_Remove_2, $iMSG_Error, _
		$iMSG_UnableToClearSe_temIsAGroup, $iMSG_Attention_1, $iMSG_AreYouSureClearThisCategory, $iMSG_DoNotAskMeAgain_1, $iMSG_Yes_1, _
		$iMSG_No_1, $iMSG_Clear_2, $iMSG_RenameCategory, $iMSG_PleaseSetANewNa_ForThisCategory, $iMSG_Error_1, _
		$iMSG_UnableToRenameC_amedToGroup, $iMSG_Error_2, $iMSG_UnableToRenameT_lyAlreadyExists, $iMSG_About_1, $iMSG_PlaySound, _
		$iMSG_Version, $iMSG_Settings_1, $iMSG_General, $iMSG_CheckProgramUpdates, $iMSG_CheckFrequency, $iMSG_CheckForUpdateNow, $iMSG_StartProgramWithWindows, $iMSG_ConfirmWhenDele_tegorygroup, _
		$iMSG_ConfirmWhenClearingCategory, $iMSG_ConfirmWhenDeletingScriptFile, $iMSG_ConfirmWhenRemo_gScriptFromList, $iMSG_ScriptDoubleClickAction, $iMSG_RunTheScript, _
		$iMSG_EditTheScript, $iMSG_ScriptsEditor, $iMSG_UseBuiltInPlugin, $iMSG_CopyScriptsToDataBase, $iMSG_ScriptsDataBasePath, _
		$iMSG_DataBaseFile, $iMSG_Window, $iMSG_SetOnTopOfAllWindows, $iMSG_MinimizeToTray, $iMSG_StartMinimized, _
		$iMSG_UseSkinForInter_werListHandling, $iMSG_StickingGUI, $iMSG_StickToTheScreenEdges, $iMSG_StickToAllWindowsHighCPUUsage, $iMSG_StickRange, _
		$iMSG_Language, $iMSG_OK, $iMSG_Cancel, $iMSG_SetDefaults, $iMSG_RestartRequired, $iMSG_RestoreDefaultSettings, $iMSG_SelectScriptsDataBasePath, $iMSG_OpenDataBaseFile, _
		$iMSG_Remove_3, $iMSG_Clear_3, $iMSG_DeleteScriptFile_1, $iMSG_RemoveScriptFromList_1, $iMSG_ProgramRestartRequired, $iMSG_PleaseWaitCheckingForUpdate, $iMSG_Error_3, _
		$iMSG_ThisScriptSDoesNotExists, $iMSG_PleaseSelectDestinationFolder, $iMSG_Attention_2, $iMSG_ThisFileSAlread_FolderReplaceIt, $iMSG_Error_4, _
		$iMSG_ThereWasAnError_TheseScriptsnns, $iMSG_Attention_3, $iMSG_AreYouSureDelet_etedPermanently, $iMSG_DoNotAskMeAgain_2, $iMSG_Yes_2, _
		$iMSG_No_2, $iMSG_DeleteScriptFile_2, $iMSG_Attention_4, $iMSG_AreYouSureRemov_riptFromTheList, $iMSG_RemoveWithoutAskingNextTime, _
		$iMSG_Yes_3, $iMSG_No_3, $iMSG_RemoveScriptFromList_2, $iMSG_ScriptIInfoRn, $iMSG_ScriptNameSrnSc_riptModifiedSrn, _
		$iMSG_Rnrn, $iMSG_RenameScript_1, $iMSG_TypeNewNameForTheScript, $iMSG_Error_5, $iMSG_ThisScriptSau3AlreadyExists, _
		$iMSG_Error_6, $iMSG_ThereWasAnError_meTheScriptSau3, $iMSG_Error_7, $iMSG_UnableToCopyThe_OnlyOneCategory, $iMSG_SelectCategory, _
		$iMSG_SelectCategoryFromTheList, $iMSG_Attention_5, $iMSG_CanNotAddScript_ategoryFromList, $iMSG_Attention_6, $iMSG_CanNotAddScript_istIsAGroup, _
		$iMSG_Attention_7, $iMSG_YouDroppedFiles_TheseAreValidS, $iMSG_CreateScript_2, $iMSG_AddScripts_1, $iMSG_Attention_8, _
		$iMSG_CanNot, $iMSG_PleaseSelectCategoryFromList, $iMSG_Attention_9, $iMSG_CanNot_1, $iMSG_CurrentItemInCa_istIsAGroup, _
		$iMSG_SaveScript, $iMSG_AddScripts_2, $iMSG_AddAsSubCategory, $iMSG_Category_2, $iMSG_Error_8, _
		$iMSG_UnableToCreateY_ptyCategoryName, $iMSG_Error_9, $iMSG_UnableToCreateThis, $iMSG_AlreadyExists, _
		$iMSG_Bytes, $iMSG_KB, $iMSG_MB, $iMSG_GB, _
		$iMSG_Ok_1, $iMSG_Cancel_1, $iMSG_Ok_2, $iMSG_Cancel_2, $iMSG_Confirm, _
		$iMSG_No_4, $iMSG_NoForAll, $iMSG_Yes_4, $iMSG_YesForAll, $iMSG_Cancel_3, _
		$iMSG_KB_1, $iMSG_MB_1, $iMSG_GB_1, $iMSG_TB, $iMSG_PB, $iMSG_EB, $iMSG_ZB, $iMSG_YB, $iMSG_Bytes_1, _
	$iMSG_Last

Global Const $LANGS_DIR = @ScriptDir & '\Languages'
Global $aTXT_IDs[$iMSG_Last] = [$iMSG_Last-1]
Global $aTXT = _AppTranslation_Register($LANGS_DIR & '\English.lng')

If StringInStr($CmdLineRaw, '/GenerateLangFile') Then
	$sLngName = StringRegExpReplace($CmdLineRaw, '(?i).*?/GenerateLangFile:(?:"([^"]*)".*|.*?)', '\1')
	$sLangFile = $LANGS_DIR & '\' & $sLngName & '.lng'
	If @extended = 0 Or $sLngName = '' Then $sLangFile = '' ;Generate strings for languages found in $LANGS_DIR
	_AppTranslation_GenerateLangFile($sLangFile)
	Exit
EndIf

Func _AppTranslation_Register($sLangFile, $sSetDataFunc = "")
	Local $aTXT[$iMSG_Last] = [$iMSG_Last-1]
	Local $iFileEncoding = FileGetEncoding($sLangFile)
	
	;Default values
	$aTXT[$iMSG_AutoItScriptsCollector] = _AppTranslation_GetString($sLangFile, "AutoItScriptsCollector", "AutoIt Scripts Collector", $iFileEncoding)
	$aTXT[$iMSG_SpeciallyForAut_ussianCommunity] = _AppTranslation_GetString($sLangFile, "SpeciallyForAut_ussianCommunity", "Specially for AutoIt Russian Community", $iFileEncoding)
	
	$aTXT[$iMSG_UpdateCheck] = _AppTranslation_GetString($sLangFile, "UpdateCheck", "Update check", $iFileEncoding)
	$aTXT[$iMSG_PleaseCompileThisApp] = _AppTranslation_GetString($sLangFile, "PleaseCompileThisApp", "Please compile this Application.", $iFileEncoding)
	$aTXT[$iMSG_ThereWasErrorCheckUpdates] = _AppTranslation_GetString($sLangFile, "ThereWasErrorCheckUpdates", "There was an error (%i) checking the update, please contact with the author.", $iFileEncoding)
	$aTXT[$iMSG_ThereIsNewVersion] = _AppTranslation_GetString($sLangFile, "ThereIsNewVersion", "There is new version available (%s).\n\nChange Log:\n\n%s\n\nWould you like to download the update?", $iFileEncoding)
	$aTXT[$iMSG_ThereWasErrorDownloadUpdate] = _AppTranslation_GetString($sLangFile, "ThereWasErrorDownloadUpdate", "There was an error (%i) downloading the update, please contact with the author.", $iFileEncoding)
	$aTXT[$iMSG_YouAreUsingNewstVersion] = _AppTranslation_GetString($sLangFile, "YouAreUsingNewstVersion", "You are using the newest version of this software.", $iFileEncoding)
	$aTXT[$iMSG_PleaseCheckInternetConnect] = _AppTranslation_GetString($sLangFile, "PleaseCheckInternetConnect", "Please check your internet connection and try again.", $iFileEncoding)
	$aTXT[$iMSG_Downloading] = _AppTranslation_GetString($sLangFile, "Downloading", "Downloading [%s]", $iFileEncoding)
	$aTXT[$iMSG_Completed] = _AppTranslation_GetString($sLangFile, "Completed", "Completed: %s%%", $iFileEncoding)
	
	$aTXT[$iMSG_ShowMainWindow] = _AppTranslation_GetString($sLangFile, "ShowMainWindow", 'Show main window', $iFileEncoding)
	$aTXT[$iMSG_CreateScript] = _AppTranslation_GetString($sLangFile, "CreateScript", 'Create script...', $iFileEncoding)
	$aTXT[$iMSG_Exit] = _AppTranslation_GetString($sLangFile, "Exit", 'Exit', $iFileEncoding)
	$aTXT[$iMSG_Count] = _AppTranslation_GetString($sLangFile, "Count", "Count", $iFileEncoding)
	$aTXT[$iMSG_ScriptName] = _AppTranslation_GetString($sLangFile, "ScriptName", "Script Name", $iFileEncoding)
	$aTXT[$iMSG_Author] = _AppTranslation_GetString($sLangFile, "Author", "Author", $iFileEncoding)
	$aTXT[$iMSG_Size] = _AppTranslation_GetString($sLangFile, "Size", "Size", $iFileEncoding)
	$aTXT[$iMSG_Modified] = _AppTranslation_GetString($sLangFile, "Modified", "Modified", $iFileEncoding)
	$aTXT[$iMSG_FilePath] = _AppTranslation_GetString($sLangFile, "FilePath", "File Path", $iFileEncoding)
	$aTXT[$iMSG_MainContextMenu] = _AppTranslation_GetString($sLangFile, "MainContextMenu", "Main Context Menu", $iFileEncoding)
	$aTXT[$iMSG_CreateScript_1] = _AppTranslation_GetString($sLangFile, "CreateScript_1", "Create Script...", $iFileEncoding)
	$aTXT[$iMSG_AddScripts] = _AppTranslation_GetString($sLangFile, "AddScripts", "Add Scripts...", $iFileEncoding)
	$aTXT[$iMSG_CopyScriptsTo] = _AppTranslation_GetString($sLangFile, "CopyScriptsTo", "Copy Script(s) to...", $iFileEncoding)
	$aTXT[$iMSG_CopyScriptsToOtherCategory] = _AppTranslation_GetString($sLangFile, "CopyScriptsToOtherCategory", "Copy Script(s) to other category...", $iFileEncoding)
	$aTXT[$iMSG_RunScript] = _AppTranslation_GetString($sLangFile, "RunScript", "Run Script", $iFileEncoding)
	$aTXT[$iMSG_EditScript] = _AppTranslation_GetString($sLangFile, "EditScript", "Edit Script", $iFileEncoding)
	$aTXT[$iMSG_RenameScript] = _AppTranslation_GetString($sLangFile, "RenameScript", "Rename Script...", $iFileEncoding)
	$aTXT[$iMSG_DeleteScriptFile] = _AppTranslation_GetString($sLangFile, "DeleteScriptFile", "Delete Script File", $iFileEncoding)
	$aTXT[$iMSG_RemoveScriptFromList] = _AppTranslation_GetString($sLangFile, "RemoveScriptFromList", "Remove Script from list", $iFileEncoding)
	$aTXT[$iMSG_CopyScriptsFullPath] = _AppTranslation_GetString($sLangFile, "CopyScriptsFullPath", "Copy Script(s) full path", $iFileEncoding)
	$aTXT[$iMSG_CopyScriptsFileName] = _AppTranslation_GetString($sLangFile, "CopyScriptsFileName", "Copy Script(s) file name", $iFileEncoding)
	$aTXT[$iMSG_CopyScriptsInformation] = _AppTranslation_GetString($sLangFile, "CopyScriptsInformation", "Copy Script(s) information", $iFileEncoding)
	$aTXT[$iMSG_OpenScriptDir] = _AppTranslation_GetString($sLangFile, "OpenScriptDir", "Open Script Dir", $iFileEncoding)
	$aTXT[$iMSG_SearchScriptOnAutoitScriptCom] = _AppTranslation_GetString($sLangFile, "SearchScriptOnAutoitScriptCom", "Search script on autoitscript.com", $iFileEncoding)
	$aTXT[$iMSG_SearchScriptOnAutoitScriptRu] = _AppTranslation_GetString($sLangFile, "SearchScriptOnAutoitScriptRu", "Search script on autoit-script.ru", $iFileEncoding)
	$aTXT[$iMSG_Search] = _AppTranslation_GetString($sLangFile, "Search", "Search:", $iFileEncoding)
	$aTXT[$iMSG_RegExpSearch] = _AppTranslation_GetString($sLangFile, "RegExpSearch", "RegExp Search", $iFileEncoding)
	$aTXT[$iMSG_CaseSensitive] = _AppTranslation_GetString($sLangFile, "CaseSensitive", "Case Sensitive", $iFileEncoding)
	$aTXT[$iMSG_WholeWordOnly] = _AppTranslation_GetString($sLangFile, "WholeWordOnly", "Whole Word Only", $iFileEncoding)
	$aTXT[$iMSG_SearchInsideTheScripts] = _AppTranslation_GetString($sLangFile, "SearchInsideTheScripts", "Search inside the scripts", $iFileEncoding)
	$aTXT[$iMSG_FilterBy] = _AppTranslation_GetString($sLangFile, "FilterBy", "Filter by...", $iFileEncoding)
	$aTXT[$iMSG_Count_1] = _AppTranslation_GetString($sLangFile, "Count_1", "Count", $iFileEncoding)
	$aTXT[$iMSG_ScriptName_1] = _AppTranslation_GetString($sLangFile, "ScriptName_1", "Script Name", $iFileEncoding)
	$aTXT[$iMSG_Author_1] = _AppTranslation_GetString($sLangFile, "Author_1", "Author", $iFileEncoding)
	$aTXT[$iMSG_Size_1] = _AppTranslation_GetString($sLangFile, "Size_1", "Size", $iFileEncoding)
	$aTXT[$iMSG_Modified_1] = _AppTranslation_GetString($sLangFile, "Modified_1", "Modified", $iFileEncoding)
	$aTXT[$iMSG_FilePath_1] = _AppTranslation_GetString($sLangFile, "FilePath_1", "File Path", $iFileEncoding)
	$aTXT[$iMSG_Category] = _AppTranslation_GetString($sLangFile, "Category", "Category:", $iFileEncoding)
	$aTXT[$iMSG_MoveItemUp] = _AppTranslation_GetString($sLangFile, "MoveItemUp", "Move item Up", $iFileEncoding)
	$aTXT[$iMSG_MoveItemDown] = _AppTranslation_GetString($sLangFile, "MoveItemDown", "Move item Down", $iFileEncoding)
	$aTXT[$iMSG_Category_1] = _AppTranslation_GetString($sLangFile, "Category_1", "Category", $iFileEncoding)
	$aTXT[$iMSG_CategoryControls] = _AppTranslation_GetString($sLangFile, "CategoryControls", "Category controls", $iFileEncoding)
	$aTXT[$iMSG_NewCategory] = _AppTranslation_GetString($sLangFile, "NewCategory", "New Category", $iFileEncoding)
	$aTXT[$iMSG_NewGroup] = _AppTranslation_GetString($sLangFile, "NewGroup", "New Group", $iFileEncoding)
	$aTXT[$iMSG_Remove] = _AppTranslation_GetString($sLangFile, "Remove", "Remove", $iFileEncoding)
	$aTXT[$iMSG_Remove_1] = _AppTranslation_GetString($sLangFile, "Remove_1", "Remove", $iFileEncoding)
	$aTXT[$iMSG_Clear] = _AppTranslation_GetString($sLangFile, "Clear", "Clear", $iFileEncoding)
	$aTXT[$iMSG_Clear_1] = _AppTranslation_GetString($sLangFile, "Clear_1", "Clear", $iFileEncoding)
	$aTXT[$iMSG_Rename] = _AppTranslation_GetString($sLangFile, "Rename", "Rename...", $iFileEncoding)
	$aTXT[$iMSG_RemoveEmptyCategories] = _AppTranslation_GetString($sLangFile, "RemoveEmptyCategories", "Remove empty Categories", $iFileEncoding)
	$aTXT[$iMSG_RemoveNotExistingScripts] = _AppTranslation_GetString($sLangFile, "RemoveNotExistingScripts", "Remove not existing scripts", $iFileEncoding)
	$aTXT[$iMSG_Exit_1] = _AppTranslation_GetString($sLangFile, "Exit_1", "Exit", $iFileEncoding)
	$aTXT[$iMSG_Visit] = _AppTranslation_GetString($sLangFile, "Visit", 'Visit: ', $iFileEncoding)
	$aTXT[$iMSG_Visit_1] = _AppTranslation_GetString($sLangFile, "Visit_1", 'Visit: ', $iFileEncoding)
	$aTXT[$iMSG_Settings] = _AppTranslation_GetString($sLangFile, "Settings", "Settings...", $iFileEncoding)
	$aTXT[$iMSG_ShowSettingsDialog] = _AppTranslation_GetString($sLangFile, "ShowSettingsDialog", 'Show settings dialog', $iFileEncoding)
	$aTXT[$iMSG_About] = _AppTranslation_GetString($sLangFile, "About", "About", $iFileEncoding)
	$aTXT[$iMSG_ShowAboutDialog] = _AppTranslation_GetString($sLangFile, "ShowAboutDialog", 'Show about dialog', $iFileEncoding)
	$aTXT[$iMSG_NewCategory_1] = _AppTranslation_GetString($sLangFile, "NewCategory_1", "New Category", $iFileEncoding)
	$aTXT[$iMSG_EnterANameForNewCategory] = _AppTranslation_GetString($sLangFile, "EnterANameForNewCategory", "Enter a name for new category:", $iFileEncoding)
	$aTXT[$iMSG_NewGroup_1] = _AppTranslation_GetString($sLangFile, "NewGroup_1", "New Group", $iFileEncoding)
	$aTXT[$iMSG_EnterANameForNewGroup] = _AppTranslation_GetString($sLangFile, "EnterANameForNewGroup", "Enter a name for new Group:", $iFileEncoding)
	$aTXT[$iMSG_Attention] = _AppTranslation_GetString($sLangFile, "Attention", "Attention", $iFileEncoding)
	$aTXT[$iMSG_AreYouSureRemov_mListCompletely] = _AppTranslation_GetString($sLangFile, "AreYouSureRemov_mListCompletely", "Are you sure, remove selected categories/groups from list completely?", $iFileEncoding)
	$aTXT[$iMSG_DoNotAskMeAgain] = _AppTranslation_GetString($sLangFile, "DoNotAskMeAgain", "Do not ask me again", $iFileEncoding)
	$aTXT[$iMSG_Yes] = _AppTranslation_GetString($sLangFile, "Yes", "Yes", $iFileEncoding)
	$aTXT[$iMSG_No] = _AppTranslation_GetString($sLangFile, "No", "No", $iFileEncoding)
	$aTXT[$iMSG_Remove_2] = _AppTranslation_GetString($sLangFile, "Remove_2", "Remove", $iFileEncoding)
	$aTXT[$iMSG_Error] = _AppTranslation_GetString($sLangFile, "Error", "Error!", $iFileEncoding)
	$aTXT[$iMSG_UnableToClearSe_temIsAGroup] = _AppTranslation_GetString($sLangFile, "UnableToClearSe_temIsAGroup", "Unable to clear, selected item is a Group.", $iFileEncoding)
	$aTXT[$iMSG_Attention_1] = _AppTranslation_GetString($sLangFile, "Attention_1", "Attention", $iFileEncoding)
	$aTXT[$iMSG_AreYouSureClearThisCategory] = _AppTranslation_GetString($sLangFile, "AreYouSureClearThisCategory", "Are you sure, clear this category?", $iFileEncoding)
	$aTXT[$iMSG_DoNotAskMeAgain_1] = _AppTranslation_GetString($sLangFile, "DoNotAskMeAgain_1", "Do not ask me again", $iFileEncoding)
	$aTXT[$iMSG_Yes_1] = _AppTranslation_GetString($sLangFile, "Yes_1", "Yes", $iFileEncoding)
	$aTXT[$iMSG_No_1] = _AppTranslation_GetString($sLangFile, "No_1", "No", $iFileEncoding)
	$aTXT[$iMSG_Clear_2] = _AppTranslation_GetString($sLangFile, "Clear_2", "Clear", $iFileEncoding)
	$aTXT[$iMSG_RenameCategory] = _AppTranslation_GetString($sLangFile, "RenameCategory", "Rename Category/Group", $iFileEncoding)
	$aTXT[$iMSG_PleaseSetANewNa_ForThisCategory] = _AppTranslation_GetString($sLangFile, "PleaseSetANewNa_ForThisCategory", "Please set a new name for this category/group:", $iFileEncoding)
	$aTXT[$iMSG_Error_1] = _AppTranslation_GetString($sLangFile, "Error_1", "Error!", $iFileEncoding)
	$aTXT[$iMSG_UnableToRenameC_amedToGroup] = _AppTranslation_GetString($sLangFile, "UnableToRenameC_amedToGroup", "Unable to rename - Category cannot be renamed to Group.", $iFileEncoding)
	$aTXT[$iMSG_Error_2] = _AppTranslation_GetString($sLangFile, "Error_2", "Error!", $iFileEncoding)
	$aTXT[$iMSG_UnableToRenameT_lyAlreadyExists] = _AppTranslation_GetString($sLangFile, "UnableToRenameT_lyAlreadyExists", "Unable to rename - This category/group probably already exists.", $iFileEncoding)
	$aTXT[$iMSG_About_1] = _AppTranslation_GetString($sLangFile, "About_1", "About", $iFileEncoding)
	$aTXT[$iMSG_PlaySound] = _AppTranslation_GetString($sLangFile, "PlaySound", "Play sound", $iFileEncoding)
	$aTXT[$iMSG_Version] = _AppTranslation_GetString($sLangFile, "Version", "Version: ", $iFileEncoding)
	$aTXT[$iMSG_Settings_1] = _AppTranslation_GetString($sLangFile, "Settings_1", "Settings", $iFileEncoding)
	$aTXT[$iMSG_General] = _AppTranslation_GetString($sLangFile, "General", "General", $iFileEncoding)
	$aTXT[$iMSG_CheckProgramUpdates] = _AppTranslation_GetString($sLangFile, "CheckProgramUpdates", "Check Program Updates", $iFileEncoding)
	$aTXT[$iMSG_CheckFrequency] = _AppTranslation_GetString($sLangFile, "CheckFrequency", "Check frequency (hr):", $iFileEncoding)
	$aTXT[$iMSG_CheckForUpdateNow] = _AppTranslation_GetString($sLangFile, "CheckForUpdateNow", "Check now", $iFileEncoding)
	$aTXT[$iMSG_StartProgramWithWindows] = _AppTranslation_GetString($sLangFile, "StartProgramWithWindows", "Start program with Windows", $iFileEncoding)
	$aTXT[$iMSG_ConfirmWhenDele_tegorygroup] = _AppTranslation_GetString($sLangFile, "ConfirmWhenDele_tegorygroup", "Confirm when deleting category/group", $iFileEncoding)
	$aTXT[$iMSG_ConfirmWhenClearingCategory] = _AppTranslation_GetString($sLangFile, "ConfirmWhenClearingCategory", "Confirm when clearing category", $iFileEncoding)
	$aTXT[$iMSG_ConfirmWhenDeletingScriptFile] = _AppTranslation_GetString($sLangFile, "ConfirmWhenDeletingScriptFile", "Confirm when deleting script file", $iFileEncoding)
	$aTXT[$iMSG_ConfirmWhenRemo_gScriptFromList] = _AppTranslation_GetString($sLangFile, "ConfirmWhenRemo_gScriptFromList", "Confirm when removing script from list", $iFileEncoding)
	$aTXT[$iMSG_ScriptDoubleClickAction] = _AppTranslation_GetString($sLangFile, "ScriptDoubleClickAction", "Script double click action:", $iFileEncoding)
	$aTXT[$iMSG_RunTheScript] = _AppTranslation_GetString($sLangFile, "RunTheScript", "Run the script", $iFileEncoding)
	$aTXT[$iMSG_EditTheScript] = _AppTranslation_GetString($sLangFile, "EditTheScript", "Edit the script", $iFileEncoding)
	$aTXT[$iMSG_ScriptsEditor] = _AppTranslation_GetString($sLangFile, "ScriptsEditor", "Scripts editor:", $iFileEncoding)
	$aTXT[$iMSG_UseBuiltInPlugin] = _AppTranslation_GetString($sLangFile, "UseBuiltInPlugin", "Use Built-In Plug-in", $iFileEncoding)
	$aTXT[$iMSG_CopyScriptsToDataBase] = _AppTranslation_GetString($sLangFile, "CopyScriptsToDataBase", "Copy Scripts To DataBase", $iFileEncoding)
	$aTXT[$iMSG_ScriptsDataBasePath] = _AppTranslation_GetString($sLangFile, "ScriptsDataBasePath", "Scripts DataBase Path:", $iFileEncoding)
	$aTXT[$iMSG_DataBaseFile] = _AppTranslation_GetString($sLangFile, "DataBaseFile", "DataBase File:", $iFileEncoding)
	$aTXT[$iMSG_Window] = _AppTranslation_GetString($sLangFile, "Window", "Window", $iFileEncoding)
	$aTXT[$iMSG_SetOnTopOfAllWindows] = _AppTranslation_GetString($sLangFile, "SetOnTopOfAllWindows", "Set on top of all windows", $iFileEncoding)
	$aTXT[$iMSG_MinimizeToTray] = _AppTranslation_GetString($sLangFile, "MinimizeToTray", "Minimize to tray", $iFileEncoding)
	$aTXT[$iMSG_StartMinimized] = _AppTranslation_GetString($sLangFile, "StartMinimized", "Start minimized", $iFileEncoding)
	$aTXT[$iMSG_UseSkinForInter_werListHandling] = _AppTranslation_GetString($sLangFile, "UseSkinForInter_werListHandling", "Use skin for interface (slower list handling)", $iFileEncoding)
	$aTXT[$iMSG_StickingGUI] = _AppTranslation_GetString($sLangFile, "StickingGUI", "Sticking GUI", $iFileEncoding)
	$aTXT[$iMSG_StickToTheScreenEdges] = _AppTranslation_GetString($sLangFile, "StickToTheScreenEdges", "Stick (to the screen edges)", $iFileEncoding)
	$aTXT[$iMSG_StickToAllWindowsHighCPUUsage] = _AppTranslation_GetString($sLangFile, "StickToAllWindowsHighCPUUsage", "Stick to all windows (High CPU usage !!!)", $iFileEncoding)
	$aTXT[$iMSG_StickRange] = _AppTranslation_GetString($sLangFile, "StickRange", "Stick Range:", $iFileEncoding)
	$aTXT[$iMSG_Language] = _AppTranslation_GetString($sLangFile, "Language", "Language:", $iFileEncoding)
	$aTXT[$iMSG_OK] = _AppTranslation_GetString($sLangFile, "OK", "OK", $iFileEncoding)
	$aTXT[$iMSG_Cancel] = _AppTranslation_GetString($sLangFile, "Cancel", "Cancel", $iFileEncoding)
	$aTXT[$iMSG_SetDefaults] = _AppTranslation_GetString($sLangFile, "SetDefaults", "Set Defaults", $iFileEncoding)
	$aTXT[$iMSG_RestartRequired] = _AppTranslation_GetString($sLangFile, "RestartRequired", "Restart required", $iFileEncoding)
	$aTXT[$iMSG_RestoreDefaultSettings] = _AppTranslation_GetString($sLangFile, "RestoreDefaultSettings", "Restore Default Settings?", $iFileEncoding)
	$aTXT[$iMSG_SelectScriptsDataBasePath] = _AppTranslation_GetString($sLangFile, "SelectScriptsDataBasePath", "Select scripts DataBase path", $iFileEncoding)
	$aTXT[$iMSG_OpenDataBaseFile] = _AppTranslation_GetString($sLangFile, "OpenDataBaseFile", "Open DataBase file", $iFileEncoding)
	$aTXT[$iMSG_Remove_3] = _AppTranslation_GetString($sLangFile, "Remove_3", "Remove", $iFileEncoding)
	$aTXT[$iMSG_Clear_3] = _AppTranslation_GetString($sLangFile, "Clear_3", "Clear", $iFileEncoding)
	$aTXT[$iMSG_DeleteScriptFile_1] = _AppTranslation_GetString($sLangFile, "DeleteScriptFile_1", "Delete Script File", $iFileEncoding)
	$aTXT[$iMSG_RemoveScriptFromList_1] = _AppTranslation_GetString($sLangFile, "RemoveScriptFromList_1", "Remove Script from list", $iFileEncoding)
	$aTXT[$iMSG_ProgramRestartRequired] = _AppTranslation_GetString($sLangFile, "ProgramRestartRequired", "Program restart required, restart now?", $iFileEncoding)
	$aTXT[$iMSG_PleaseWaitCheckingForUpdate] = _AppTranslation_GetString($sLangFile, "PleaseWaitCheckingForUpdate", "Please wait, checking for update...", $iFileEncoding)
	$aTXT[$iMSG_Error_3] = _AppTranslation_GetString($sLangFile, "Error_3", "Error!", $iFileEncoding)
	$aTXT[$iMSG_ThisScriptSDoesNotExists] = _AppTranslation_GetString($sLangFile, "ThisScriptSDoesNotExists", "This script (%s) does not exists.", $iFileEncoding)
	$aTXT[$iMSG_PleaseSelectDestinationFolder] = _AppTranslation_GetString($sLangFile, "PleaseSelectDestinationFolder", "Please select destination folder:", $iFileEncoding)
	$aTXT[$iMSG_Attention_2] = _AppTranslation_GetString($sLangFile, "Attention_2", "Attention", $iFileEncoding)
	$aTXT[$iMSG_ThisFileSAlread_FolderReplaceIt] = _AppTranslation_GetString($sLangFile, "ThisFileSAlread_FolderReplaceIt", "This file (%s) already exists in destination folder, replace it?", $iFileEncoding)
	$aTXT[$iMSG_Error_4] = _AppTranslation_GetString($sLangFile, "Error_4", "Error!", $iFileEncoding)
	$aTXT[$iMSG_ThereWasAnError_TheseScriptsnns] = _AppTranslation_GetString($sLangFile, "ThereWasAnError_TheseScriptsnns", "There was an error to copy these scripts:\n\n%s", $iFileEncoding)
	$aTXT[$iMSG_Attention_3] = _AppTranslation_GetString($sLangFile, "Attention_3", "Attention", $iFileEncoding)
	$aTXT[$iMSG_AreYouSureDelet_etedPermanently] = _AppTranslation_GetString($sLangFile, "AreYouSureDelet_etedPermanently", "Are you sure, delete selected files?\n\n(files will be deleted permanently)", $iFileEncoding)
	$aTXT[$iMSG_DoNotAskMeAgain_2] = _AppTranslation_GetString($sLangFile, "DoNotAskMeAgain_2", "Do not ask me again", $iFileEncoding)
	$aTXT[$iMSG_Yes_2] = _AppTranslation_GetString($sLangFile, "Yes_2", "Yes", $iFileEncoding)
	$aTXT[$iMSG_No_2] = _AppTranslation_GetString($sLangFile, "No_2", "No", $iFileEncoding)
	$aTXT[$iMSG_DeleteScriptFile_2] = _AppTranslation_GetString($sLangFile, "DeleteScriptFile_2", "Delete Script File", $iFileEncoding)
	$aTXT[$iMSG_Attention_4] = _AppTranslation_GetString($sLangFile, "Attention_4", "Attention", $iFileEncoding)
	$aTXT[$iMSG_AreYouSureRemov_riptFromTheList] = _AppTranslation_GetString($sLangFile, "AreYouSureRemov_riptFromTheList", "Are you sure, remove selected script from the list?", $iFileEncoding)
	$aTXT[$iMSG_RemoveWithoutAskingNextTime] = _AppTranslation_GetString($sLangFile, "RemoveWithoutAskingNextTime", "Remove without asking next time", $iFileEncoding)
	$aTXT[$iMSG_Yes_3] = _AppTranslation_GetString($sLangFile, "Yes_3", "Yes", $iFileEncoding)
	$aTXT[$iMSG_No_3] = _AppTranslation_GetString($sLangFile, "No_3", "No", $iFileEncoding)
	$aTXT[$iMSG_RemoveScriptFromList_2] = _AppTranslation_GetString($sLangFile, "RemoveScriptFromList_2", "Remove Script from list", $iFileEncoding)
	$aTXT[$iMSG_ScriptIInfoRn] = _AppTranslation_GetString($sLangFile, "ScriptIInfoRn", "============= Script #%i Info ===========\r\n", $iFileEncoding)
	$aTXT[$iMSG_ScriptNameSrnSc_riptModifiedSrn] = _AppTranslation_GetString($sLangFile, "ScriptNameSrnSc_riptModifiedSrn", "Script Name: %s\r\nScript Path: %s\r\nScript Size: %s\r\nScript Modified: %s\r\n", $iFileEncoding)
	$aTXT[$iMSG_Rnrn] = _AppTranslation_GetString($sLangFile, "Rnrn", "=====================================\r\n\r\n", $iFileEncoding)
	$aTXT[$iMSG_RenameScript_1] = _AppTranslation_GetString($sLangFile, "RenameScript_1", "Rename script", $iFileEncoding)
	$aTXT[$iMSG_TypeNewNameForTheScript] = _AppTranslation_GetString($sLangFile, "TypeNewNameForTheScript", "Type new name for the script:", $iFileEncoding)
	$aTXT[$iMSG_Error_5] = _AppTranslation_GetString($sLangFile, "Error_5", "Error!", $iFileEncoding)
	$aTXT[$iMSG_ThisScriptSau3AlreadyExists] = _AppTranslation_GetString($sLangFile, "ThisScriptSau3AlreadyExists", "This script (%s.au3) already exists.", $iFileEncoding)
	$aTXT[$iMSG_Error_6] = _AppTranslation_GetString($sLangFile, "Error_6", "Error!", $iFileEncoding)
	$aTXT[$iMSG_ThereWasAnError_meTheScriptSau3] = _AppTranslation_GetString($sLangFile, "ThereWasAnError_meTheScriptSau3", "There was an error to rename the script (%s.au3).", $iFileEncoding)
	$aTXT[$iMSG_Error_7] = _AppTranslation_GetString($sLangFile, "Error_7", "Error!", $iFileEncoding)
	$aTXT[$iMSG_UnableToCopyThe_OnlyOneCategory] = _AppTranslation_GetString($sLangFile, "UnableToCopyThe_OnlyOneCategory", "Unable to copy - there is only one category.", $iFileEncoding)
	$aTXT[$iMSG_SelectCategory] = _AppTranslation_GetString($sLangFile, "SelectCategory", "Select Category", $iFileEncoding)
	$aTXT[$iMSG_SelectCategoryFromTheList] = _AppTranslation_GetString($sLangFile, "SelectCategoryFromTheList", "Select category from the list:", $iFileEncoding)
	$aTXT[$iMSG_Attention_5] = _AppTranslation_GetString($sLangFile, "Attention_5", "Attention", $iFileEncoding)
	$aTXT[$iMSG_CanNotAddScript_ategoryFromList] = _AppTranslation_GetString($sLangFile, "CanNotAddScript_ategoryFromList", "Cannot add scripts - Please select category from list.", $iFileEncoding)
	$aTXT[$iMSG_Attention_6] = _AppTranslation_GetString($sLangFile, "Attention_6", "Attention", $iFileEncoding)
	$aTXT[$iMSG_CanNotAddScript_istIsAGroup] = _AppTranslation_GetString($sLangFile, "CanNotAddScript_istIsAGroup", "Cannot add scripts - Current item in category list is a Group.", $iFileEncoding)
	$aTXT[$iMSG_Attention_7] = _AppTranslation_GetString($sLangFile, "Attention_7", "Attention!", $iFileEncoding)
	$aTXT[$iMSG_YouDroppedFiles_TheseAreValidS] = _AppTranslation_GetString($sLangFile, "YouDroppedFiles_TheseAreValidS", "You dropped file(s) with non valid extension/attribute:\n\n%s\n\nThese are valid: %s", $iFileEncoding)
	$aTXT[$iMSG_CreateScript_2] = _AppTranslation_GetString($sLangFile, "CreateScript_2", "create script", $iFileEncoding)
	$aTXT[$iMSG_AddScripts_1] = _AppTranslation_GetString($sLangFile, "AddScripts_1", "add scripts", $iFileEncoding)
	$aTXT[$iMSG_Attention_8] = _AppTranslation_GetString($sLangFile, "Attention_8", "Attention", $iFileEncoding)
	$aTXT[$iMSG_CanNot] = _AppTranslation_GetString($sLangFile, "CanNot", "Cannot", $iFileEncoding)
	$aTXT[$iMSG_PleaseSelectCategoryFromList] = _AppTranslation_GetString($sLangFile, "PleaseSelectCategoryFromList", " - Please select category from list.", $iFileEncoding)
	$aTXT[$iMSG_Attention_9] = _AppTranslation_GetString($sLangFile, "Attention_9", "Attention", $iFileEncoding)
	$aTXT[$iMSG_CanNot_1] = _AppTranslation_GetString($sLangFile, "CanNot_1", "Cannot", $iFileEncoding)
	$aTXT[$iMSG_CurrentItemInCa_istIsAGroup] = _AppTranslation_GetString($sLangFile, "CurrentItemInCa_istIsAGroup", " - Current item in category list is a Group.", $iFileEncoding)
	$aTXT[$iMSG_SaveScript] = _AppTranslation_GetString($sLangFile, "SaveScript", "Save script", $iFileEncoding)
	$aTXT[$iMSG_AddScripts_2] = _AppTranslation_GetString($sLangFile, "AddScripts_2", "Add scripts...", $iFileEncoding)
	$aTXT[$iMSG_AddAsSubCategory] = _AppTranslation_GetString($sLangFile, "AddAsSubCategory", "Add as Sub Category", $iFileEncoding)
	$aTXT[$iMSG_Category_2] = _AppTranslation_GetString($sLangFile, "Category_2", "group|category", $iFileEncoding)
	$aTXT[$iMSG_Error_8] = _AppTranslation_GetString($sLangFile, "Error_8", "Error!", $iFileEncoding)
	$aTXT[$iMSG_UnableToCreateY_ptyCategoryName] = _AppTranslation_GetString($sLangFile, "UnableToCreateY_ptyCategoryName", "Unable to create - You have entered an empty category name.", $iFileEncoding)
	$aTXT[$iMSG_Error_9] = _AppTranslation_GetString($sLangFile, "Error_9", "Error!", $iFileEncoding)
	$aTXT[$iMSG_UnableToCreateThis] = _AppTranslation_GetString($sLangFile, "UnableToCreateThis", "Unable to create - This", $iFileEncoding)
	$aTXT[$iMSG_AlreadyExists] = _AppTranslation_GetString($sLangFile, "AlreadyExists", "already exists.", $iFileEncoding)
	$aTXT[$iMSG_Bytes] = _AppTranslation_GetString($sLangFile, "Bytes", "Bytes", $iFileEncoding)
	$aTXT[$iMSG_KB] = _AppTranslation_GetString($sLangFile, "KB", "KB", $iFileEncoding)
	$aTXT[$iMSG_MB] = _AppTranslation_GetString($sLangFile, "MB", "MB", $iFileEncoding)
	$aTXT[$iMSG_GB] = _AppTranslation_GetString($sLangFile, "GB", "GB", $iFileEncoding)
	$aTXT[$iMSG_Ok_1] = _AppTranslation_GetString($sLangFile, "Ok_1", "Ok", $iFileEncoding)
	$aTXT[$iMSG_Cancel_1] = _AppTranslation_GetString($sLangFile, "Cancel_1", "Cancel", $iFileEncoding)
	$aTXT[$iMSG_Ok_2] = _AppTranslation_GetString($sLangFile, "Ok_2", 'OK', $iFileEncoding)
	$aTXT[$iMSG_Cancel_2] = _AppTranslation_GetString($sLangFile, "Cancel_2", 'Cancel', $iFileEncoding)
	$aTXT[$iMSG_Confirm] = _AppTranslation_GetString($sLangFile, "Confirm", "Confirm...", $iFileEncoding)
	$aTXT[$iMSG_No_4] = _AppTranslation_GetString($sLangFile, "No_4", "No", $iFileEncoding)
	$aTXT[$iMSG_NoForAll] = _AppTranslation_GetString($sLangFile, "NoForAll", "No for all", $iFileEncoding)
	$aTXT[$iMSG_Yes_4] = _AppTranslation_GetString($sLangFile, "Yes_4", "Yes", $iFileEncoding)
	$aTXT[$iMSG_YesForAll] = _AppTranslation_GetString($sLangFile, "YesForAll", "Yes for all", $iFileEncoding)
	$aTXT[$iMSG_Cancel_3] = _AppTranslation_GetString($sLangFile, "Cancel_3", "Cancel", $iFileEncoding)
	$aTXT[$iMSG_KB_1] = _AppTranslation_GetString($sLangFile, "KB_1", 'KB', $iFileEncoding)
	$aTXT[$iMSG_MB_1] = _AppTranslation_GetString($sLangFile, "MB_1", 'MB', $iFileEncoding)
	$aTXT[$iMSG_GB_1] = _AppTranslation_GetString($sLangFile, "GB_1", 'GB', $iFileEncoding)
	$aTXT[$iMSG_TB] = _AppTranslation_GetString($sLangFile, "TB", 'TB', $iFileEncoding)
	$aTXT[$iMSG_PB] = _AppTranslation_GetString($sLangFile, "PB", 'PB', $iFileEncoding)
	$aTXT[$iMSG_EB] = _AppTranslation_GetString($sLangFile, "EB", 'EB', $iFileEncoding)
	$aTXT[$iMSG_ZB] = _AppTranslation_GetString($sLangFile, "ZB", 'ZB', $iFileEncoding)
	$aTXT[$iMSG_YB] = _AppTranslation_GetString($sLangFile, "YB", 'YB', $iFileEncoding)
	$aTXT[$iMSG_Bytes_1] = _AppTranslation_GetString($sLangFile, "Bytes_1", 'Bytes', $iFileEncoding)
	
	If $sSetDataFunc <> "" Then
		Call($sSetDataFunc, $aTXT)
	EndIf
	
	Return $aTXT
EndFunc

Func _AppTranslation_GetLanguages($sLangs_Dir, $bRetArray = False)
	Local $sRet, $sLngFileName, $hSearch = FileFindFirstFile($sLangs_Dir & "\*.lng")
	If $hSearch = -1 Then Return SetError(-1, 0, '')
	
	While 1
		$sLngFileName = FileFindNextFile($hSearch)
		If @error <> 0 Then ExitLoop
		$sRet &= StringLeft($sLngFileName, StringInStr($sLngFileName, ".", 2, -1) - 1) & "|"
	WEnd
	
	FileClose($hSearch)
	
	If $sRet = "" Then Return SetError(1, 0, "")
	
	$sRet = StringRegExpReplace($sRet, "\|+$", "")
	If $bRetArray Then $sRet = StringSplit($sRet, "|")
	Return $sRet
EndFunc

Func _AppTranslation_GetString($sLangFile, $sIdentifier, $sDefault = "", $iFileEncoding = 0)
	$aTXT_IDs[Eval('iMSG_' & $sIdentifier)] = $sIdentifier
	
	Local $sStr = IniRead($sLangFile, "Translation", $sIdentifier, $sDefault)
	
	If $iFileEncoding >= 128 Then
		$sStr = BinaryToString(StringToBinary($sStr), 4)
	EndIf
	
	Return $sStr
EndFunc

Func _AppTranslation_GenerateLangFile($sLangFile = '', $sAppName = @ScriptName, $sAppVer = -1, $sLngAuthor = '')
	Local $aLangs[2] = [1, $sLangFile]
	
	If $sLangFile = '' Then
		$aLangs = _AppTranslation_GetLanguages($LANGS_DIR, True)
	ElseIf Not FileExists($sLangFile) Then
		If $sAppName = @ScriptName Then $sAppName = StringRegExpReplace($sAppName, '\.[^\.]*$', '')
		
		If $sAppVer = -1 Then
			If @Compiled Then
				$sAppVer = StringLeft(FileGetVersion(@ScriptFullPath, 'FileVersion'), 3)
			Else
				$sAppVer = '1.0'
			EndIf
		EndIf
		
		IniWrite($sLangFile, 'Info', 'Program', $sAppName)
		IniWrite($sLangFile, 'Info', 'Version', $sAppVer)
		IniWrite($sLangFile, 'Info', 'Language', StringRegExpReplace($sLangFile, '^.*\\|\.[^\.]*$', ''))
		IniWrite($sLangFile, 'Info', 'Author', '')
	EndIf
	
	For $iLng = 1 To $aLangs[0]
		If $aLangs[$iLng] = '' Then ContinueLoop
		
		If $sLangFile = '' Then
			$aLangs[$iLng] = $LANGS_DIR & '\' & $aLangs[$iLng] & '.lng'
		EndIf
		
		For $i = 1 To $aTXT[0]
			If IniRead($aLangs[$iLng], 'Translation', $aTXT_IDs[$i], '@DEFAULT@') == '@DEFAULT@' Then
				IniWrite($aLangs[$iLng], 'Translation', $aTXT_IDs[$i], $aTXT[$i])
			EndIf
		Next
	Next
EndFunc

Func _AppTranslation_SelectLangGUI($sAppName, $hParent = 0, $sDefLng = "")
	Local $hGUI, $nLng_Combo, $iMsg
	
	GUISetState(@SW_DISABLE, $hParent)
	$hGUI = GUICreate($sAppName, 300, 120, -1, -1, -1, $WS_EX_TOOLWINDOW, $hParent)
	
	GUICtrlCreateLabel("Language:", 20, 52, 80, 17)
	$nLng_Combo = GUICtrlCreateCombo("", 110, 50, 170, 50, BitOr($GUI_SS_DEFAULT_COMBO, $CBS_DROPDOWNLIST))
	GUICtrlSetData($nLng_Combo, _AppTranslation_GetLanguages($LANGS_DIR), $sDefLng)
	
	GUISetState(@SW_SHOW, $hGUI)
	
	While 1
		$iMsg = GUIGetMsg()
		
		Switch $iMsg
			Case $GUI_EVENT_CLOSE
				ExitLoop
			Case $nLng_Combo
				$sDefLng = GUICtrlRead($nLng_Combo)
				$aTXT = _AppTranslation_Register($LANGS_DIR & "\" & $sDefLng & ".lng")
		EndSwitch
	WEnd
	
	GUISetState(@SW_ENABLE, $hParent)
	GUIDelete($hGUI)
	
	Return $sDefLng
EndFunc
