#include-once

Global $PluginsDir					= @ScriptDir & "\Plugins"
Global $Plugins_Reg_File			= $PluginsDir & "\Plugins_Register.ini"

Global $Call_On_App_Start_CMD		= "/Call_On_App_Start"
Global $Plugin_Enabled_CMD			= "/Plugin_Enabled"
Global $Plugin_Disabled_CMD			= "/Plugin_Disabled"
Global $Plugin_Register_CMD			= "/Plugin_Register"
Global $Plugin_Options_Call_CMD		= "/Plugin_Options_Call"
Global $PlugInMenuEvent_CMD			= "/PlugInMenuEvent="

Global $PLUGIN_EXT					= ".plg"

Global $iFirst_Plugins_MenuItem		= 0
Global $iLast_Plugins_MenuItem		= 0
Global $aPlugins_Listing			= 0

Func Initialize_Plugins_Proc()
	If Not FileExists($PluginsDir & "\*" & $PLUGIN_EXT) Then Return SetError(1, 0, 0)
	
	Plugin_CleanBadRegisterEntries()
	
	Local $aPlugin_Moduls = _FileListToArrayEx($PluginsDir, "*" & $PLUGIN_EXT)
	
	For $i = 1 To UBound($aPlugin_Moduls)-1
		Plugin_Call_Proc($aPlugin_Moduls[$i], $Call_On_App_Start_CMD)
	Next
EndFunc

Func Plugin_Call_Proc($sPluginName, $sArguments='', $iWait=0, $iMode=0)
	If Not Plugin_SupportedCMD($sArguments) And Not Plugin_Active($sPluginName) Then Return SetError(-1, 0, 0)
	
	Local $sPlugin_Full_Path = Plugin_Get_FullPath($sPluginName)
	
	Local $sAPP_Plugin_Module = @TempDir & '\APP_P~' & $sPluginName
	If StringRight($sPluginName, 4) <> '.plg' Then $sAPP_Plugin_Module &= '.plg'
	
	If $iMode = 0 Then
		Local $iFlag = 0
		If FileGetSize(@AutoItExe) <> FileGetSize($sAPP_Plugin_Module) Then $iFlag = 1
		
		FileCopy(@AutoItExe, $sAPP_Plugin_Module, $iFlag)
	Else
		$sAPP_Plugin_Module = @AutoItExe
	EndIf
	
	Local $iRet_Pid = Run($sAPP_Plugin_Module & ' /ErrorStdOut /AutoIt3ExecuteScript "' & $sPlugin_Full_Path & '" ' & $sArguments)
	Local $iError = @error
	
	If $iWait <> 0 Then ProcessWaitClose($iRet_Pid, $iWait)
	
	Return SetError($iError, 0, $iRet_Pid)
EndFunc

Func Plugin_SupportedCMD($sCMD)
	Return _
		$sCMD = $Call_On_App_Start_CMD Or _
		$sCMD = $Plugin_Enabled_CMD Or _
		$sCMD = $Plugin_Disabled_CMD Or _
		$sCMD = $Plugin_Register_CMD Or _
		$sCMD = $Plugin_Options_Call_CMD Or _
		$sCMD = $PlugInMenuEvent_CMD
EndFunc

Func Plugin_Active($sPluginName, $aPlugin_Info=-1)
	If IsArray($aPlugin_Info) Then Return Number($aPlugin_Info[1]) = 1
	
	If StringRight($sPluginName, 4) <> $PLUGIN_EXT Then $sPluginName &= $PLUGIN_EXT
	Return Number(IniRead($Plugins_Reg_File, $sPluginName, "PLUGIN_IS_ACTIVE", 0) = 1)
EndFunc

Func Plugin_Exists($sPluginName)
	Return FileExists(Plugin_Get_FullPath($sPluginName))
EndFunc

Func Plugin_Find($sPlugin_In_Name)
	If Plugin_Exists($sPlugin_In_Name) Then Return $sPlugin_In_Name
	
	Local $hSearch = FileFindFirstFile($PluginsDir & "\*" & $PLUGIN_EXT)
	If $hSearch = -1 Then Return SetError(1, 0, -1)
	
	Local $sNext_PluginFile = "", $aPlugin_Info, $sPlugin_Ret_FileName = ""
	
	While 1
		$sNext_PluginFile = FileFindNextFile($hSearch)
		If @error Then ExitLoop
		
		$aPlugin_Info = Plugin_Get_Info($sNext_PluginFile)
		
		If $aPlugin_Info[3] = $sPlugin_In_Name Or $aPlugin_Info[4] = $sPlugin_In_Name Then
			$sPlugin_Ret_FileName = $sNext_PluginFile
			ExitLoop
		EndIf
	WEnd
	
	FileClose($hSearch)
	
	If $sPlugin_Ret_FileName = "" Then Return SetError(2, 0, "")
	Return $sPlugin_Ret_FileName
EndFunc

Func Plugin_ListPluginsToArray($iFlag=0)
	Local $hSearch = FileFindFirstFile($PluginsDir & "\*" & $PLUGIN_EXT)
	If $hSearch = -1 Then Return SetError(1, 0, -1)
	
	Local $sNext_PluginFile = "", $aPlugin_Info, $aPlugins_List[1][5]
	Local $iRegistered = 0
	
	While 1
		$sNext_PluginFile = FileFindNextFile($hSearch)
		If @error Then ExitLoop
		
		$aPlugin_Info = Plugin_Get_Info($sNext_PluginFile)
		If @error Then ContinueLoop
		
		If $iFlag = 1 And $aPlugin_Info[1] <> 1 Then ContinueLoop
		
		$aPlugins_List[0][0] += 1
		ReDim $aPlugins_List[$aPlugins_List[0][0]+1][5]
		
		$aPlugins_List[$aPlugins_List[0][0]][0] = $PluginsDir & "\" & $sNext_PluginFile ;Plugin File Full Path
		$aPlugins_List[$aPlugins_List[0][0]][1] = $sNext_PluginFile ;Plugin File Name
		$aPlugins_List[$aPlugins_List[0][0]][2] = $aPlugin_Info[3] ;Plugin Name
		$aPlugins_List[$aPlugins_List[0][0]][3] = $aPlugin_Info[4] ;Plugin Description
		$aPlugins_List[$aPlugins_List[0][0]][4] = $aPlugin_Info[1] ;Plugin state (Enabled/Disabled)
	WEnd
	
	FileClose($hSearch)
	
	_Array2DSort($aPlugins_List, 0, 1, $aPlugins_List[0][0], 2) ;2 = sort by Plugin Name
	
	If $aPlugins_List[0][0] = 0 Then SetError(2)
	
	Return $aPlugins_List
EndFunc

Func Plugin_ListPluginsToString($iFlag=0)
	If Not FileExists($PluginsDir & "\*" & $PLUGIN_EXT) Then Return SetError(1, 0, "")
	
	Local $sPlugins_List = "", $aPlugin_Info, $aRetArr[1]
	Local $aPlugin_Moduls = _FileListToArrayEx($PluginsDir, "*" & $PLUGIN_EXT)
	
	For $i = 1 To UBound($aPlugin_Moduls)-1
		$aPlugin_Info = Plugin_Get_Info($aPlugin_Moduls[$i])
		If @error Then ContinueLoop
		
		If $aPlugin_Info[3] = "" Then $aPlugin_Info[3] = StringTrimRight($aPlugin_Moduls[$i], 4)
		
		If $iFlag = 0 Or $iFlag = 2 Then
			If Plugin_Active($aPlugin_Moduls[$i], $aPlugin_Info) Then
				$aPlugin_Moduls[$i] = "[X] " & $aPlugin_Info[3]
			Else
				$aPlugin_Moduls[$i] = "[ ] " & $aPlugin_Info[3]
			EndIf
			
			If $iFlag = 2 Then
				$aRetArr[0] += 1
				ReDim $aRetArr[$aRetArr[0]+1]
				$aRetArr[$aRetArr[0]] = $aPlugin_Moduls[$i]
			EndIf
		EndIf
		
		$sPlugins_List &= $aPlugin_Moduls[$i] & "|"
	Next
	
	If $iFlag = 2 Then Return $aRetArr
	Return _StringStripChars($sPlugins_List, "|", 3)
EndFunc

Func Plugin_CleanBadRegisterEntries()
	Local $aSection_Names = IniReadSectionNames($Plugins_Reg_File)
	
	For $i = 1 To UBound($aSection_Names)-1
		If Not FileExists($PluginsDir & "\" & $aSection_Names[$i]) Then IniDelete($Plugins_Reg_File, $aSection_Names[$i])
	Next
EndFunc

Func Plugin_GetUnRegisteredPlugins()
	Local $aRetArr[1]
	Local $aPlugin_Moduls = _FileListToArrayEx($PluginsDir, "*" & $PLUGIN_EXT)
	
	For $i = 1 To UBound($aPlugin_Moduls)-1
		IniReadSection($Plugins_Reg_File, $aPlugin_Moduls[$i])
		
		If @error Then
			$aRetArr[0] += 1
			ReDim $aRetArr[$aRetArr[0]+1]
			
			$aRetArr[$aRetArr[0]] = $aPlugin_Moduls[$i]
		EndIf
	Next
	
	If $aRetArr[0] = 0 Then Return SetError(1, 0, 0)
	
	Return $aRetArr
EndFunc

Func Plugin_Get_FullPath($sPluginName)
	If FileExists($sPluginName) Then Return $sPluginName
	
	Local $sPlugin_Full_Path = $PluginsDir & "\" & $sPluginName & $PLUGIN_EXT
	If StringRight($sPluginName, StringLen($PLUGIN_EXT)) = $PLUGIN_EXT Then $sPlugin_Full_Path = $PluginsDir & "\" & $sPluginName
	
	Return $sPlugin_Full_Path
EndFunc

Func Plugin_Get_Info($sPluginName)
	Local $aRet_Info[5]
	Local $sPlugin_Full_Path = Plugin_Get_FullPath($sPluginName)
	Local $sSectName = StringRegExpReplace($sPluginName, "^.*\\", "")
	If StringRight($sSectName, 4) <> $PLUGIN_EXT Then $sSectName &= $PLUGIN_EXT
	
	If Not FileExists($sPlugin_Full_Path) Then Return SetError(1, 0, $aRet_Info)
	
	IniReadSection($Plugins_Reg_File, $sSectName)
	If @error Then Return SetError(2, 0, $aRet_Info)
	
	$aRet_Info[0] = 4
	
	$aRet_Info[1] = IniRead($Plugins_Reg_File, $sSectName, "PLUGIN_IS_ACTIVE", 0)
	$aRet_Info[2] = IniRead($Plugins_Reg_File, $sSectName, "PLGUIN_AUTHOR", "")
	$aRet_Info[3] = IniRead($Plugins_Reg_File, $sSectName, "PLUGIN_NAME", $sPluginName)
	$aRet_Info[4] = IniRead($Plugins_Reg_File, $sSectName, "PLUGIN_DESCRIPTION", "")
	
	$aRet_Info[1] = _StringStripChars($aRet_Info[1], '"', 3)
	$aRet_Info[2] = _StringStripChars($aRet_Info[2], '"', 3)
	$aRet_Info[3] = _StringStripChars($aRet_Info[3], '"', 3)
	$aRet_Info[4] = _StringStripChars($aRet_Info[4], '"', 3)
	
	Return $aRet_Info
EndFunc

Func Plugin_Set_Info($sPluginName, $sInfo_Part, $sValue)
	Local $sPlugin_Full_Path = Plugin_Get_FullPath($sPluginName)
	Local $sSectName = StringRegExpReplace($sPluginName, "^.*\\", "")
	If StringRight($sSectName, 4) <> $PLUGIN_EXT Then $sSectName &= $PLUGIN_EXT
	
	If Not FileExists($sPlugin_Full_Path) Then Return SetError(1, 0, 0)
	
	Return IniWrite($Plugins_Reg_File, $sSectName, $sInfo_Part, $sValue)
EndFunc

Func _FileListToArrayEx($sUserJSPath, $sFilter = "*")
	Local $hSearch, $sFileName, $sFileNameExt, $asFileList[1]
	If Not __PathIsFolder($sUserJSPath) Then Return SetError(1, 0, "")
	
	Local $aFilters[2] = [1, $sFilter]
	If StringInStr($sFilter, "|") Then $aFilters = StringSplit($sFilter, "|")
	
	For $i = 1 To $aFilters[0]
		$hSearch = FileFindFirstFile($sUserJSPath & "\" & $aFilters[$i])
		
		If $hSearch = -1 Then
			ContinueLoop
		EndIf
		
		While 1
			$sFileName = FileFindNextFile($hSearch)
			If @error Then
				ExitLoop
			EndIf
			
			$sFileNameExt = StringRegExpReplace($sFileName, "^.*\.", "")
			
			If $aFilters[$i] = "*." & $sFileNameExt Then
				$asFileList[0] += 1
				ReDim $asFileList[$asFileList[0] + 1]
				$asFileList[$asFileList[0]] = $sFileName
			EndIf
		WEnd
		
		FileClose($hSearch)
	Next
	
	Return $asFileList
EndFunc

Func _StringStripChars($sString, $sSubString, $iFlag = 0, $iCount = 0)
	If StringLen($sString) = 0 Then Return SetError(1, 0, $sString)
	
	Local $sGroupChar_a = '(', $sGroupChar_b = ')'
	If $iCount < 0 Then Local $sGroupChar_a = '[', $sGroupChar_b = ']'
	
	$sSubString = StringRegExpReplace($sSubString, '([][{}()|.?+*\\^\$])', '\\\1')
	Local $sPattern = '(?i)' & $sGroupChar_a & $sSubString & $sGroupChar_b
	Local $sPattern_Count = '{1,' & $iCount & '}'
	
	If $iCount <= 0 Then $sPattern_Count = '+'
	If $iFlag <> 0 Then $iCount = 0
	If $iFlag = 1 Then $sPattern = '(?i)^' & $sGroupChar_a & $sSubString & $sGroupChar_b & $sPattern_Count
	If $iFlag = 2 Then $sPattern = '(?i)' & $sGroupChar_a & $sSubString & $sGroupChar_b & $sPattern_Count & '$'
	If $iFlag = 3 Then $sPattern = '(?i)^' & $sGroupChar_a & $sSubString & $sGroupChar_b & $sPattern_Count & '|' & _
		$sGroupChar_a & $sSubString & $sGroupChar_b & $sPattern_Count & '$'
	
	Return StringRegExpReplace($sString, $sPattern, '', $iCount)
EndFunc

Func __PathIsFolder($sPath)
	$sPath = StringRegExpReplace($sPath, '\\+$', '') & "\"
	
	If $sPath = "\" Then Return False
	
	Return StringInStr(FileGetAttrib($sPath), "D") > 0
EndFunc

Func _Array2DSort(ByRef $avArray, $iDescending = 0, $iStart = 0, $iEnd = 0, $iSubItem = 0)
	If Not IsArray($avArray) Then Return SetError(1, 0, 0)
	If UBound($avArray, 0) < 2 Then Return SetError(2, 0, 0)
	
	Local $iUBound = UBound($avArray) - 1
	
	; Bounds checking
	If $iEnd < 1 Or $iEnd > $iUBound Then $iEnd = $iUBound
	If $iStart < 0 Then $iStart = 0
	If $iStart > $iEnd Then Return SetError(3, 0, 0)

	; Sort
	Local $iSubMax = UBound($avArray, 2) - 1
	If $iSubItem > $iSubMax Then Return SetError(4, 0, 0)
	
	If $iDescending Then
		$iDescending = -1
	Else
		$iDescending = 1
	EndIf

	__ArrayQuickSort2D($avArray, $iDescending, $iStart, $iEnd, $iSubItem, $iSubMax)
	
	Return 1
EndFunc
