#Region Header

#include-once
#include <Misc.au3>
#include <WinAPI.au3>

#EndRegion Header

#Region Global Variables

Global $bAppUpdate_Debug 		= Not @Compiled

Global $sAppUpdate_ServerPage 	= "http://creator-lab.ucoz.ru/Update_Files/ASC_Update.dat"
Global $sAppUpdate_AppName 		= "ASC"
Global $sAppUpdate_AppVersion 	= "1.0"

Global $aAppUpdate_Msgs[12] 	= _
	[11, _
		"Attention", _
		"Error", _
		"Update check", _
		"Please compile this Application.", _
		"There was an error (%i) checking the update, please contact with the author.", _
		"There is new version available (%s).\n\nChange Log:\n\n%s\n\nWould you like to download the update?", _
		"There was an error (%i) downloading the update, please contact with the author.", _
		"You are using the newest version of this software.", _
		"Please check your internet connection and try again.", _
		"Downloading [%s]", _
		"Completed: %s%%" _
	]

#EndRegion Global Variables

#Region Public Functions

;$iSilentMode <= 0 - Check update and display all messages (on failure/success, ask to update, when update is not available)
;$iSilentMode = 1 - Check update quitly (with no messages when there is no update, only when update is available)
;$iSilentMode = 2 - Check update quitly (with no messages at all, update will be performed without prompt!)
Func _AppCheckUpdates($hParent, $iSilentMode = -1, $iMakeBackup = 1, $sLanguage = '', $hUpdateWait_Wnd = 0)
	If $hParent <> "" And IsString($hParent) Then
		$hParent = WinGetHandle($hParent)
	EndIf
	
	If Not $bAppUpdate_Debug And Not @Compiled Then
		If $iSilentMode <= 0 Then
			If IsHWnd($hUpdateWait_Wnd) Then Run(@AutoItExe & ' /AutoIt3ExecuteLine "If Sleep(10) Then WinSetState(Hwnd(' & $hUpdateWait_Wnd & '), '''', @SW_HIDE)"')
			MsgBox(262144+48, $sAppUpdate_AppName & " - " & $aAppUpdate_Msgs[1], $aAppUpdate_Msgs[4], 0, $hParent)
		EndIf
		
		If Not $bAppUpdate_Debug Then Return 0
	EndIf
	
	If Not __AppCheckUpdates_InetConnected() Then
		If $iSilentMode <= 0 Then
			If IsHWnd($hUpdateWait_Wnd) Then Run(@AutoItExe & ' /AutoIt3ExecuteLine "If Sleep(10) Then WinSetState(Hwnd(' & $hUpdateWait_Wnd & '), '''', @SW_HIDE)"')
			MsgBox(48, $sAppUpdate_AppName & " - " & $aAppUpdate_Msgs[3] & " : " & $aAppUpdate_Msgs[2], $aAppUpdate_Msgs[9], 0, $hParent)
		EndIf
		
		Return SetError(-1, 0, 0)
	EndIf
	
	Local $sUpdate_Info = BinaryToString(InetRead($sAppUpdate_ServerPage, 1), 4)
	
	If Not StringInStr($sUpdate_Info, "[Info]") Then
		If $iSilentMode <= 0 Then
			If IsHWnd($hUpdateWait_Wnd) Then Run(@AutoItExe & ' /AutoIt3ExecuteLine "If Sleep(10) Then WinSetState(Hwnd(' & $hUpdateWait_Wnd & '), '''', @SW_HIDE)"')
			MsgBox(262144+48, $sAppUpdate_AppName & " - " & $aAppUpdate_Msgs[3] & " : " & $aAppUpdate_Msgs[2], StringFormat($aAppUpdate_Msgs[5], 1), 0, $hParent)
		EndIf
		
		Return SetError(1, 0, 0)
	EndIf
	
	Local $sUpdate_Version = StringRegExpReplace($sUpdate_Info, "(?si).*Update Version=([^\r\n]+).*", "\1")
	Local $sUpdate_File = StringRegExpReplace($sUpdate_Info, "(?si).*Update File=([^\r\n]+).*", "\1")
	Local $sUpdate_ChangeLog
	
	If $sLanguage <> "" Then
		$sLanguage &= " "
	EndIf
	
	$sUpdate_ChangeLog = StringRegExpReplace($sUpdate_Info, "(?si).*Update " & $sLanguage & "ChangeLog=([^\r\n]*).*", "\1")
	
	If @extended = 0 Or $sUpdate_ChangeLog = $sUpdate_Info Or StringStripWS($sUpdate_ChangeLog, 8) = "" Then
		$sUpdate_ChangeLog = "N/A"
	Else
		$sUpdate_ChangeLog = StringReplace($sUpdate_ChangeLog, "\n", @CRLF)
	EndIf
	
	If _VersionCompare($sUpdate_Version, $sAppUpdate_AppVersion) = 1 Then
		Local $iUpdate_Ask = 6
		
		;Show message when update available
		If $iSilentMode <= 1 Then
			If IsHWnd($hUpdateWait_Wnd) Then Run(@AutoItExe & ' /AutoIt3ExecuteLine "If Sleep(10) Then WinSetState(Hwnd(' & $hUpdateWait_Wnd & '), '''', @SW_HIDE)"')
			$iUpdate_Ask = MsgBox(262144+36, $sAppUpdate_AppName & " - " & $aAppUpdate_Msgs[3], StringFormat($aAppUpdate_Msgs[6], $sUpdate_Version, $sUpdate_ChangeLog), 0, $hParent)
		EndIf
		
		If $iUpdate_Ask <> 6 Then
			Return 0
		EndIf
		
		GUISetState(@SW_DISABLE, $hParent)
		
		Local $iPrecent
		Local $sLocal_Name = StringTrimRight(@ScriptName, 4) & ".efe"
		Local $sServer_Name = StringRegExpReplace($sUpdate_File, '^.*/', '')
		Local $iIsZipUpdate = (StringRight($sServer_Name, 3) = "zip")
		
		If $iIsZipUpdate Then
			$sLocal_Name = $sServer_Name
		EndIf
		
		If $iMakeBackup Then
			FileCopy(@ScriptFullPath, @ScriptFullPath & ".bak", 1)
		EndIf
		
		Local $hInetGet = InetGet($sUpdate_File, @TempDir & "\" & $sLocal_Name, 1, 1)
		
		If $iSilentMode <= 1 Then
			ProgressOn($sAppUpdate_AppName & " - " & $aAppUpdate_Msgs[3], StringFormat($aAppUpdate_Msgs[10], $sServer_Name))
			
			Do
				Sleep(100)
				$iPrecent = 100 / (InetGetInfo($hInetGet, 1) / InetGetInfo($hInetGet, 0))
				
				If Not __AppCheckUpdates_NumberIsOverflow($iPrecent) Then
					ProgressSet($iPrecent, StringFormat($aAppUpdate_Msgs[11], Round($iPrecent, 1)))
				EndIf
			Until InetGetInfo($hInetGet, 2)    ; Check if the download is complete.
		Else
			Do
				Sleep(100)
			Until InetGetInfo($hInetGet, 2)    ; Check if the download is complete.
		EndIf
		
		Local $nBytes = InetGetInfo($hInetGet, 0)
		InetClose($hInetGet)
		
		If @error Or $nBytes = 0 Then
			If $iSilentMode <= 0 Then
				If IsHWnd($hUpdateWait_Wnd) Then Run(@AutoItExe & ' /AutoIt3ExecuteLine "If Sleep(10) Then WinSetState(Hwnd(' & $hUpdateWait_Wnd & '), '''', @SW_HIDE)"')
				MsgBox(48, $sAppUpdate_AppName & " - " & $aAppUpdate_Msgs[3] & " : " & $aAppUpdate_Msgs[2], StringFormat($aAppUpdate_Msgs[7], 2), 0, $hParent)
			EndIf
			
			Return SetError(2, 0, 0)
		EndIf
		
		If $iSilentMode <= 1 Then
			ProgressOff()
		EndIf
		
		If Not $bAppUpdate_Debug Then
			If $iIsZipUpdate Then
				FileInstall('Resources\7z.exe', @TempDir & '\7z.exe', 1)
				
				RunWait('"' & @TempDir & '\7z.exe" x "' & @TempDir & '\' & $sLocal_Name & '" -y -o"' & @ScriptDir & '\Update_Tmp" * -r', @TempDir, @SW_HIDE)
				Run(@ComSpec & ' /c Ping -n 2 localhost > nul & xcopy /y /s /c "' & _
					@ScriptDir & '\Update_Tmp\*" "' & @ScriptDir & '\*" & Start "" "' & @ScriptFullPath & '" & RD /S /Q "' & @ScriptDir & '\Update_Tmp"', '', @SW_HIDE)
			Else
				Run(@ComSpec & ' /c Ping -n 2 localhost > nul & Move /y "' & _
					@TempDir & '\' & $sLocal_Name & '" "' & @ScriptFullPath & '" & Start "" "' & @ScriptFullPath & '"', '', @SW_HIDE)
			EndIf
			
			Exit
		EndIf
	EndIf
	
	If $iSilentMode <= 0 Then
		If IsHWnd($hUpdateWait_Wnd) Then Run(@AutoItExe & ' /AutoIt3ExecuteLine "If Sleep(10) Then WinSetState(Hwnd(' & $hUpdateWait_Wnd & '), '''', @SW_HIDE)"')
		MsgBox(64, $sAppUpdate_AppName & " - " & $aAppUpdate_Msgs[3], $aAppUpdate_Msgs[8], 0, $hParent)
	EndIf
	
	Return 1
EndFunc

#EndRegion Public Functions

#Region Internal Functions

Func __AppCheckUpdates_InetConnected($sPing_Host = "google.com", $iPing_TimeOut = 1000)
	Local Const $INTERNET_CONNECTION_MODEM = 0x1
	Local Const $INTERNET_CONNECTION_LAN = 0x2
	Local Const $INTERNET_CONNECTION_PROXY = 0x4
	Local Const $INTERNET_CONNECTION_OFFLINE = 0x20
	Local Const $INTERNET_CONNECTION_CONFIGURED = 0x40
	
	Local $stInetGetConnectedState = DllStructCreate("int")
	
	DllCall("wininet.dll", "int", "InternetGetConnectedState", "ptr", DllStructGetPtr($stInetGetConnectedState), "dword", 0)

	Local $s_stDataState = DllStructGetData($stInetGetConnectedState, 1)
	Local $iRetState = 0
	
	If BitAND($s_stDataState, $INTERNET_CONNECTION_MODEM) Or BitAND($s_stDataState, $INTERNET_CONNECTION_PROXY) Then
		$iRetState = 1
	EndIf
	
	If BitAND($s_stDataState, $INTERNET_CONNECTION_OFFLINE) Then
		$iRetState = 0
	EndIf
	
	If $iRetState = 0 Then
		Local $iPingCheck = Ping($sPing_Host, $iPing_TimeOut)
		
		If $iPingCheck > 0 Then
			$iRetState = 1
		EndIf
	EndIf
	
	Return $iRetState
EndFunc

Func __AppCheckUpdates_NumberIsOverflow($nValue)
    Return $nValue - $nValue <> 0
EndFunc

#EndRegion Internal Functions
