#Region Header

#CS Info
	
	Title:          _AboutBox UDF
    Filename:       AboutBox.au3
    Description:    Shows an "About program" dialog box with few nice features.
    Author:         G.Sandler a.k.a (Mr)CreatoR (CreatoR's Lab - www.creator-lab.ucoz.ru, www.autoit-script.ru)
    Version:        0.5
    Requirements:   AutoIt v3.3.0.0 +, Developed/Tested on Windows XP (rus) Service Pack 2/3.
	Usage:          See an example bellow.
    Uses:           GUIConstantsEx.au3, EditConstants.au3, StaticConstants.au3, WindowsConstants.au3, Misc.au3, WinAPI.au3.
	Forum Link:     http://www.autoitscript.com/forum/index.php?showtopic=64738
    Notes:          * This UDF uses GUIRegisterMsg($WM_MOVE, "__AboutBox_WM_MOVE").
	                * Global variables (option) $ABOUTBOX_ScrollMovieEffect can be used to set the "Movie effect" for the AboutBox window.
	
#CE

#CS Example
	
	_Example()
	
	Func _Example()
		Local $hParent_GUI, $nMainMenu, $nAbout_MenuItem, $aAccelKeys
		Local $sTitle, $sScrollText, $sMainLabel, $sCopyRLabel, $nLinkColor, $nBkColor, $aHyperLinks[4]
		
		$hParent_GUI = GUICreate('Parent For "About Program" Demo', 200, 100)
		
		$nMainMenu = GUICtrlCreateMenu("Help")
		$nAbout_MenuItem = GUICtrlCreateMenuItem("About...	(F1)", $nMainMenu)
		
		Dim $aAccelKeys[1][2] = [["{F1}", $nAbout_MenuItem]]
		GUISetAccelerators($aAccelKeys, $hParent_GUI)
		
		GUISetState(@SW_SHOW, $hParent_GUI)
		
		While 1
			Switch GUIGetMsg()
				Case $GUI_EVENT_CLOSE
					Exit
				Case $nAbout_MenuItem
					$ABOUTBOX_ScrollMovieEffect = 1
					
					$sTitle = "About Info"
					
					$sScrollText = "I want to express special gratitude to:" & _
						"\n\n\n\nAutoIt Team\n\n\nAutoIt Community\n\n\n... and many other good people"
					
					$sMainLabel = "My program Name"
					$sCopyRLabel = "Copyright  " & @YEAR & " Company/Author. All rights reserved."
					
					$nLinkColor = 0x0000FF
					$nBkColor = 0xFFFFF0
					
					$aHyperLinks[0] = UBound($aHyperLinks) - 1
					$aHyperLinks[1] = "App Web Page|http://www.autoitscript.com"
					$aHyperLinks[2] = "Email|mailto:my_email@mail.com"
					$aHyperLinks[3] = "Some additional link|http://personalwebpafe.com"
					
					_AboutBox($sTitle, $sMainLabel, "Version: " & @CRLF & "v1.0", $sScrollText, $sCopyRLabel, _
						$aHyperLinks, $hParent_GUI, @AutoItExe, $nLinkColor, $nBkColor, 500, 300)
			EndSwitch
		WEnd
	EndFunc
	
#CE

#include <GUIConstantsEx.au3>
#include <EditConstants.au3>
#include <StaticConstants.au3>
#include <WindowsConstants.au3>
#include <Misc.au3>
#include <WinAPI.au3>

#EndRegion Header

#Region Global Variables

Global $__AboutBox_hAboutGUI, $__AboutBox_aCoverGUIs[42]
Global $__AboutBox_iOldLeftPos, $__AboutBox_iOldTopPos, $__AboutBox_iScrollPos, $__AboutBox_iFirstScroll, $__AboutBox_iScrollLines
Global $__AboutBox_iScrollTimer, $__AboutBox_iScrollSpeed = 1, $__AboutBox_iCustomScrollSpeed = 3
Global $__AboutBox_iLastMouseYPos = -1, $__AboutBox_iIsScrolling = 0, $__AboutBox_hIsPressed, $__AboutBox_iPlaySound = 1
Global $__AboutBox_sSoundFile = @SystemDir & "\oobe\images\title.wma"

#EndRegion Global Variables

#Region Public Variables

Global $ABOUTBOX_ScrollMovieEffect = 1
Global $ABOUTBOX_TempDir = @TempDir

#EndRegion Public Variables

#Region Public Functions

; #FUNCTION# ====================================================================================================
; Name...........:	_AboutBox
; Description....:	Shows an "About program" dialog box with few nice features.
;
; Syntax.........:	_AboutBox($sTitle, $sMainLabelText, $sBodyText, $sScrollText, $sCopyRText, $aHyperLinks, $hParent = 0, $sIconFile = "", $nLinkColor = 0x0000FF, $nBkColor = 0xFFFFFF, $iWidth = 300, $iHeight = 120, $iLeft = -1, $iTop = -1, $nStyle = -1, $nExStyle = -1)
;
; Parameters.....:	$sTitle         - About window title.
;					$sMainLabelText - Main text to be displayed at the top of About window.
;					$sBodyText      - The text to be displayed on the front of About window.
;					$sScrollText    - The text that will be scrolling from up to down.
;					$sCopyRText     - Copyright line, displayed at the bottom of About window.
;					$sPlaySndText   - "Play sound" checkbox text.
;					$aHyperLinks    - 1D Array with hyperlinks info, the data should be stored as foolows (up to 5 hyperlinks allowed):
;                                                                 $aHyperLinks[0] = 2
;                                                                 $aHyperLinks[1] = "App Web Page|http://www.autoitscript.com"
;                                                                 $aHyperLinks[2] = "Email|mailto:my_email@mail.com"
;					$hParent     - [Optional] Parent window handle (default is 0, no parent).
;					$sIconFile   - [Optional] Icon file, will be displayed at the left-top side of About window (default is "", no icon).
;					$nLinkColor  - [Optional] Initial color of the hyperlinks (default is 0x0000FF - Blue).
;					$nBkColor    - [Optional] Background color of the About window (default is 0xFFFFFF - White).
;					$iWidth      - [Optional] The width of the window (default is 300).
;					$iHeight     - [Optional] The height of the window (default is 120).
;					$iLeft       - [Optional] The left side of the dialog box. By default (-1), the window is centered. If defined, top must also be defined.
;					$iTop        - [Optional] The top of the dialog box. Default (-1) is centered.
;					$nStyle      - [Optional] Defines the style of the window. See GUI Control Styles Appendix (Use -1 for the default style, as used in AutoIt GUI window).
;					$nExStyle    - [Optional] Defines the extended style of the window. See the Extended Style Table below (default is -1).
;					
; Return values..:	Success      - None.
;					Failure      - Returns 0 and sets @error as follows:
;                                                                        1 - $aHyperLinks includes more than 5 elements.
;                                                                        2 - The GUI window cannot be created.
;
; Author.........:	G.Sandler a.k.a (Mr)CreatoR (CreatoR's Lab - www.creator-lab.ucoz.ru, www.autoit-script.ru)
; Modified.......:	
; Remarks........:	Uses GUIRegisterMsg($WM_MOVE, "__AboutBox_WM_MOVE").
; Related........:	
; Link...........:	
; Example........:	Yes.
; ===============================================================================================================
Func _AboutBox($sTitle, $sMainLabelText, $sBodyText, $sScrollText, $sCopyRText, $sPlaySndText, $aHyperLinks, $hParent = 0, $sIconFile = "", $nLinkColor = 0x0000FF, $nBkColor = 0xFFFFFF, $iWidth = 300, $iHeight = 120, $iLeft = -1, $iTop = -1, $nStyle = -1, $nExStyle = -1)
	Local $iHyperLinks_Count = UBound($aHyperLinks)
	Local $anLinkLabel[$iHyperLinks_Count][2] = [[$iHyperLinks_Count - 1]], $iLinkTop = 120, $iDelim_Pos, $sURL, $sURL_Title
	Local $ahAbout_Sound
	
	Local $iUseSkin = Number(Eval("iUse_Skin_For_GUI") = 1)
	
	If $iHyperLinks_Count > 6 Then
		Return SetError(1, 0, 0)
	EndIf
	
	Local $iOld_Opt = Opt("GUIOnEventMode", 0)
	Local $hScroll_GUI, $nScroll_Label, $iAbout_Msg, $aCurInfo
	
	If $nExStyle = -1 Then $nExStyle = 0
	$nExStyle = BitOR($WS_EX_TOOLWINDOW, $nExStyle)
	
	If IsHWnd($hParent) Then
		WinSetState($hParent, "", @SW_DISABLE)
	Else
		$nExStyle = BitOR($WS_EX_APPWINDOW, $nExStyle)
	EndIf
	
	$__AboutBox_hAboutGUI = GUICreate($sTitle, $iWidth, $iHeight, $iLeft, $iTop, $nStyle, $nExStyle, $hParent)
	
	If @error Then
		Return SetError(2, 0, 0)
	EndIf
	
	GUISetBkColor($nBkColor)
	
	GUICtrlCreateLabel($sMainLabelText, 30, 20, $iWidth - 60, 40, $ES_CENTER, $GUI_WS_EX_PARENTDRAG)
	GUICtrlSetFont(-1, 14)
	
	GUICtrlCreateIcon($sIconFile, 0, 10, 20)
	GUICtrlSetState(-1, 128)
	
	GUICtrlCreateGraphic(5, 75, $iWidth - 10, 3, $SS_ETCHEDFRAME)
	
	For $i = 1 To $iHyperLinks_Count - 1
		$iDelim_Pos = StringInStr($aHyperLinks[$i], "|")
		$sURL = StringTrimLeft($aHyperLinks[$i], $iDelim_Pos)
		$sURL_Title = StringLeft($aHyperLinks[$i], $iDelim_Pos - 1)
		
		If $sURL = "" Then
			ContinueLoop
		EndIf
		
		$anLinkLabel[$i][0] = __AboutBox_GUICtrlHyperlink_Create($sURL_Title, $iWidth - 150, $iLinkTop, -1, 15, $nLinkColor, $sURL, $SS_CENTER)
		$anLinkLabel[$i][1] = $sURL
		
		$iLinkTop += 30
	Next
	
	$nPlayMusic_CB = GUICtrlCreateCheckbox($sPlaySndText, 10, 80, -1, 18)
	If $__AboutBox_iPlaySound Then GUICtrlSetState(-1, $GUI_CHECKED)
	GUICtrlSetFont(-1, 8)
	
	GUICtrlCreateLabel($sBodyText, 10, 100, 115, $iHeight/2)
	GUICtrlSetFont(-1, 10, 600, 0, "Tahoma")
	
	GUICtrlCreateLabel($sCopyRText, 0, $iHeight - 20, $iWidth, -1, 1)
	GUICtrlSetColor(-1, 0x969696)
	GUICtrlSetState(-1, 128)
	
	If Not $ABOUTBOX_ScrollMovieEffect Then
		$hScroll_GUI = GUICreate('', 180, 160, 150, 90, $WS_CHILD, -1, $__AboutBox_hAboutGUI)
	Else
		$hScroll_GUI = GUICreate('', 180, 160, 150, 90, $WS_CHILD, BitOR($WS_EX_CLIENTEDGE, $WS_EX_DLGMODALFRAME, $WS_EX_COMPOSITED), $__AboutBox_hAboutGUI)
		GUISetBkColor(0x0)
	EndIf
	
	$sScrollText = StringReplace($sScrollText, "\n", @CRLF)
	;$__AboutBox_iScrollLines = (@extended * 23)
	
	Local $aSplitText = StringSplit(StringStripCR($sScrollText), @LF), $iLineRect
	
	$__AboutBox_iScrollLines = 0 ;StringLen($sScrollText)
	
	For $i = 1 To $aSplitText[0]
		$iLineRect = __AboutBox_GUICtrlLabelGetTextWidth($aSplitText[$i])
		$iLineWidth = (180 / $iLineRect[0]) ;180 is the scroll box width, we need to devide it by line width (to get the number of scroll lines for each text line)
		
		If $iLineWidth - $iLineWidth <> 0 Then ;Number overflow check
			$__AboutBox_iScrollLines += (2 * Floor($iLineRect[1] / 2)) ;Text line height (2 actualy, we need the @LF too)
		Else
			$__AboutBox_iScrollLines += ((Ceiling($iLineWidth) + 1) * Floor($iLineRect[1] / 2)) ;Number of lines + 1 (we need the @LF too) multiply by text line height
		EndIf
	Next
	
	Local $iInitTextPos = _Iif($iUseSkin, 130, 150)
	
	$nScroll_Label = GUICtrlCreateLabel($sScrollText, 0, $iInitTextPos, 180, 510, $ES_CENTER)
	GUICtrlSetState(-1, $GUI_HIDE)
	GUICtrlSetCursor(-1, 0)
	GUICtrlSetFont(-1, 9, 0, 0, "Tahoma")
	
	If Not $ABOUTBOX_ScrollMovieEffect Then
		GUICtrlSetColor(-1, 0x804000)
	Else
		GUICtrlSetColor(-1, 0xFFFFFF)
	EndIf
	
	Dim $__AboutBox_iScrollPos = -$iInitTextPos, $__AboutBox_iFirstScroll = 1, $__AboutBox_iScrollTimer = TimerInit()
	Local $iTransHeight = 2, $iTransValue = (UBound($__AboutBox_aCoverGUIs)/2) - 1, $aParentPos = WinGetPos($__AboutBox_hAboutGUI)
	
	If $ABOUTBOX_ScrollMovieEffect Then $iTransHeight = 1
	
	$__AboutBox_iOldLeftPos = $aParentPos[0]
	$__AboutBox_iOldTopPos = $aParentPos[1]
	
	If Not $iUseSkin Then
		For $i = 0 To $iTransValue
			;Top Cover
			$__AboutBox_aCoverGUIs[$i] = GUICreate("", 220, $iTransHeight + 2, 130 + $aParentPos[0], $iTransHeight * $i + 110 + $aParentPos[1], _
				$WS_POPUP, -1, $__AboutBox_hAboutGUI)
			
			GUISetBkColor($nBkColor, $__AboutBox_aCoverGUIs[$i])
			WinSetTrans($__AboutBox_aCoverGUIs[$i], "", (255 / $iTransValue) * (-1 * ($i - $iTransValue)))
			
			;Bottom cover
			$__AboutBox_aCoverGUIs[$i + $iTransValue + 1] = GUICreate("", 220, $iTransHeight + 2, 130 + $aParentPos[0], 260 - $iTransHeight * $i + $aParentPos[1] + 20, _
				$WS_POPUP, -1, $__AboutBox_hAboutGUI)
			
			GUISetBkColor($nBkColor, $__AboutBox_aCoverGUIs[$i + $iTransValue + 1])
			WinSetTrans($__AboutBox_aCoverGUIs[$i + $iTransValue + 1], "", (255 / $iTransValue) * (-1 * ($i - $iTransValue)))
		Next
	EndIf
	
	;Strange bug with freezing GUI
	If $iUseSkin Then
		GUISetState(@SW_SHOW, $hScroll_GUI)
		GUISetState(@SW_SHOW, $__AboutBox_hAboutGUI)
	Else
		GUISetState(@SW_SHOW, $__AboutBox_hAboutGUI)
		GUISetState(@SW_SHOW, $hScroll_GUI)
	EndIf
	
	If Not $iUseSkin Then
		For $i = 0 To 41
			GUISetState(@SW_SHOW, $__AboutBox_aCoverGUIs[$i])
		Next
		
		GUIRegisterMsg($WM_MOVE, "__AboutBox_WM_MOVE")
	EndIf
	
	GUICtrlSetState($nScroll_Label, $GUI_SHOW)
	
	$__AboutBox_hIsPressed = DllOpen("User32.dll")
	
	Local $hCallBack = DllCallbackRegister("__AboutBox_ScrollText_CallBack_Proc", "none", "hwnd;int;int;dword")
	Local $ahTimer = DllCall("user32.dll", "int", "SetTimer", "hwnd", $hScroll_GUI, "int", 1001, "int", 10, "ptr", DllCallbackGetPtr($hCallBack))
	
	GUISwitch($__AboutBox_hAboutGUI)
	WinActivate($__AboutBox_hAboutGUI)
	
	Local $bSndFileExists = FileExists($__AboutBox_sSoundFile)
	
	If Not $bSndFileExists Then
		FileChangeDir(@ScriptDir)
		FileInstall("Resources\BASSMOD.DLL", $ABOUTBOX_TempDir & "\BASSMOD.DLL", 1)
		FileInstall("Resources\About.xm", $ABOUTBOX_TempDir & "\About.xm", 1)
	EndIf
	
	If $__AboutBox_iPlaySound Then
		If Not $bSndFileExists Then
			$ahAbout_Sound = __AboutBox_BASSMOD_Start($ABOUTBOX_TempDir & "\BASSMOD.dll", $ABOUTBOX_TempDir & "\About.xm", 1024+4)
		EndIf
		
		If @error Or $bSndFileExists Then
			SoundPlay($__AboutBox_sSoundFile, 0)
		EndIf
	EndIf
	
	While 1
		$iAbout_Msg = GUIGetMsg()
		
		Switch $iAbout_Msg
			Case $GUI_EVENT_CLOSE
				ExitLoop
			Case $nPlayMusic_CB
				If GUICtrlRead($nPlayMusic_CB) = $GUI_CHECKED Then
					$__AboutBox_iPlaySound = 1
					
					If $__AboutBox_iPlaySound Then
						If Not $bSndFileExists Then
							$ahAbout_Sound = __AboutBox_BASSMOD_Start($ABOUTBOX_TempDir & "\BASSMOD.dll", $ABOUTBOX_TempDir & "\About.xm", 1024+4)
						EndIf
						
						If @error Or $bSndFileExists Then
							SoundPlay($__AboutBox_sSoundFile, 0)
						EndIf
					EndIf
				Else
					$__AboutBox_iPlaySound = 0
					
					If IsArray($ahAbout_Sound) Then
						__AboutBox_BASSMOD_Close($ahAbout_Sound[0], $ahAbout_Sound[1])
						If @error Then SoundPlay("")
					Else
						SoundPlay("")
					EndIf
				EndIf
			Case $anLinkLabel[1][0] To $anLinkLabel[$anLinkLabel[0][0]][0]
				For $i = 1 To $anLinkLabel[0][0]
					If $iAbout_Msg = $anLinkLabel[$i][0] Then
						__AboutBox_GUICtrlHyperlink_Handler($__AboutBox_hAboutGUI, $anLinkLabel[$i][0], $anLinkLabel[$i][1], -1, 0x551A8B)
						ExitLoop
					EndIf
				Next
		EndSwitch
	WEnd
	
	DllCall("user32.dll", "int", "KillTimer", "hwnd", $hScroll_GUI, "int", $ahTimer[0])
	DllCallbackFree($hCallBack)
	DllClose($__AboutBox_hIsPressed)
	
	If IsArray($ahAbout_Sound) Then
		__AboutBox_BASSMOD_Close($ahAbout_Sound[0], $ahAbout_Sound[1])
		
		If Not @error Then
			FileDelete($ABOUTBOX_TempDir & "\BASSMOD.DLL")
			FileDelete($ABOUTBOX_TempDir & "\About.xm")
		Else
			SoundPlay("")
		EndIf
	Else
		SoundPlay("")
	EndIf
	
	If Not $iUseSkin Then
		For $i = 0 To 41
			GUIDelete($__AboutBox_aCoverGUIs[$i])
		Next
		
		GUIRegisterMsg($WM_MOVE, "")
	EndIf
	
	If IsHWnd($hParent) Then
		WinSetState($hParent, "", @SW_ENABLE)
	EndIf
	
	GUIDelete($__AboutBox_hAboutGUI)
	GUISwitch($hParent)
	Opt("GUIOnEventMode", $iOld_Opt)
EndFunc

#EndRegion Public Functions

#Region Internal Functions

Func __AboutBox_ScrollText_CallBack_Proc($hWnd, $iMsg, $wParam, $lParam)
	Local $hScroll_Label_Wnd = ControlGetHandle($hWnd, "", "Static1")
	Local $iScroll_Label_Ctrl = DllCall("user32.dll", "int", "GetDlgCtrlID", "hwnd", $hScroll_Label_Wnd)
	$iScroll_Label_Ctrl = $iScroll_Label_Ctrl[0]
	
	If ($__AboutBox_iIsScrolling Or __AboutBox_Control_GetHovered() = $hScroll_Label_Wnd) And _IsPressed(01, $__AboutBox_hIsPressed) Then
		Local $iCurrent_Mouse_YPos = MouseGetPos(1)
		$__AboutBox_iIsScrolling = 1
		
		If $__AboutBox_iLastMouseYPos < $iCurrent_Mouse_YPos Then ;Move up
			$__AboutBox_iScrollPos -= $__AboutBox_iCustomScrollSpeed
			
			ControlMove($hWnd, "", "Static1", 0, -$__AboutBox_iScrollPos)
		ElseIf $__AboutBox_iLastMouseYPos > $iCurrent_Mouse_YPos Then ;Move down
			$__AboutBox_iScrollPos += $__AboutBox_iCustomScrollSpeed
			
			ControlMove($hWnd, "", "Static1", 0, -$__AboutBox_iScrollPos)
		EndIf
		
		GUICtrlSetCursor($iScroll_Label_Ctrl, 11)
		
		$__AboutBox_iLastMouseYPos = $iCurrent_Mouse_YPos
		$__AboutBox_iScrollTimer = TimerInit()
		$__AboutBox_iFirstScroll = 1
		
		If $__AboutBox_iScrollPos > $__AboutBox_iScrollLines Or $__AboutBox_iScrollPos < -$__AboutBox_iScrollLines Then
			$__AboutBox_iScrollPos = -150
		EndIf
		
		Return
	ElseIf $__AboutBox_iIsScrolling Then
		$__AboutBox_iIsScrolling = 0
		GUICtrlSetCursor($iScroll_Label_Ctrl, 0)
	EndIf
	
	If ($__AboutBox_iFirstScroll And TimerDiff($__AboutBox_iScrollTimer) > 1000) Or (Not $__AboutBox_iFirstScroll And TimerDiff($__AboutBox_iScrollTimer) > 30) Then
		$__AboutBox_iFirstScroll = 0
		$__AboutBox_iScrollTimer = TimerInit()
		$__AboutBox_iScrollPos += $__AboutBox_iScrollSpeed
		
		ControlMove($hWnd, "", "Static1", 0, -$__AboutBox_iScrollPos)
		
		If $__AboutBox_iScrollPos > $__AboutBox_iScrollLines Then
			$__AboutBox_iScrollPos = -150
		EndIf
	EndIf
	
	;WM_MOVE($__AboutBox_hAboutGUI, 0, 0, 0)
EndFunc

Func __AboutBox_WM_MOVE($hWndGUI, $MsgID, $wParam, $lParam)
	If $hWndGUI <> $__AboutBox_hAboutGUI Then
		Return $GUI_RUNDEFMSG
	EndIf
	
	Local $aParentPosArr, $aChildPosArr, $iNew_Left, $iNew_Top
	$aParentPosArr = WinGetPos($hWndGUI)
	
	For $i = 0 To 41
		$aChildPosArr = WinGetPos($__AboutBox_aCoverGUIs[$i])
		
		$iNew_Left = $aChildPosArr[0]
		$iNew_Top = $aChildPosArr[1]
		
		If $__AboutBox_iOldLeftPos > $aParentPosArr[0] Then
			$iNew_Left = $aChildPosArr[0] + ($aParentPosArr[0] - $__AboutBox_iOldLeftPos)
		ElseIf $__AboutBox_iOldLeftPos < $aParentPosArr[0] Then
			$iNew_Left = $aChildPosArr[0] - ($__AboutBox_iOldLeftPos - $aParentPosArr[0])
		EndIf
		
		If $__AboutBox_iOldTopPos > $aParentPosArr[1] Then
			$iNew_Top = $aChildPosArr[1] - ($__AboutBox_iOldTopPos - $aParentPosArr[1])
		ElseIf $__AboutBox_iOldTopPos < $aParentPosArr[1] Then
			$iNew_Top = $aChildPosArr[1] + ($aParentPosArr[1] - $__AboutBox_iOldTopPos)
		EndIf
		
		If $__AboutBox_iOldLeftPos = $iNew_Left And $__AboutBox_iOldTopPos = $iNew_Top Then
			Return
		EndIf
		
		WinMove($__AboutBox_aCoverGUIs[$i], "", $iNew_Left, $iNew_Top)
	Next
	
	$__AboutBox_iOldLeftPos = $aParentPosArr[0]
	$__AboutBox_iOldTopPos = $aParentPosArr[1]
EndFunc

Func __AboutBox_Control_GetHovered()
	Local $iOld_Opt_MCM = Opt("MouseCoordMode", 1)
	Local $Ret = DllCall("user32.dll", "hwnd", "WindowFromPoint", "long", MouseGetPos(0), "long", MouseGetPos(1))
	
	Opt("MouseCoordMode", $iOld_Opt_MCM)
	
	Return HWnd($Ret[0])
EndFunc

Func __AboutBox_GUICtrlHyperlink_Create($sText, $iLeft, $iTop, $iWidth = -1, $iHeight = -1, $iColor = 0x0000FF, $sToolTip = '', $iStyle = -1, $iExStyle = -1)
	If $iWidth = -1 Then
		$iWidth = __AboutBox_GUICtrlLabelGetTextWidth($sText)
		$iWidth = $iWidth[0]
		
		If Not $iWidth Then
			$iWidth = -1
		EndIf
	EndIf
	
	If $iStyle <> -1 And BitAND($iStyle, $SS_CENTER) Then
		$iLeft += -($iWidth / 2) + 70
	EndIf
	
	Local $ID = GUICtrlCreateLabel($sText, $iLeft, $iTop, $iWidth, $iHeight, $iStyle, $iExStyle)
	
	If $ID Then
		GUICtrlSetFont($ID, -1, -1, 4)
		GUICtrlSetColor($ID, $iColor)
		GUICtrlSetCursor($ID, 0)
		GUICtrlSetTip($ID, $sToolTip)
	EndIf
	
	Return $ID
EndFunc

Func __AboutBox_GUICtrlHyperlink_Handler($hWnd, $iCtrlID, $sActionURL, $iAction = -1, $iVisitedColor = 0x551A8B)
	Local $aCurInfo = GUIGetCursorInfo($hWnd)
	
	If Not IsArray($aCurInfo) Then
		Return SetError(1, 0, 0)
	EndIf
	
	While IsArray($aCurInfo) And $aCurInfo[2] = 1
		$aCurInfo = GUIGetCursorInfo($hWnd)
		
		If $aCurInfo[4] <> $iCtrlID Then
			GUISetCursor(7, 1, $hWnd)
		Else
			GUISetCursor(2, 0, $hWnd)
		EndIf
		
		Sleep(10)
	WEnd
	
	GUISetCursor(2, 0, $hWnd)
	
	If IsArray($aCurInfo) And $aCurInfo[4] = $iCtrlID Then
		If $iAction = 1 Then
			Execute($sActionURL)
		ElseIf $iAction = -1 Then
			__AboutBox_ShellExecuteEx($sActionURL)
		EndIf
		
		If @error = 0 And $iVisitedColor Then
			GUICtrlSetColor($iCtrlID, $iVisitedColor)
		EndIf
		
		Return 1
	EndIf
	
	Return SetError(1, 0, 0)
EndFunc

Func __AboutBox_GUICtrlLabelGetTextWidth($s_Data, $i_FontSize = 8.5, $i_FontWeight = -1, $s_TextFont = "Arial")
	Local Const $DEFAULT_CHARSET = 0 ; ANSI character set
	Local Const $OUT_CHARACTER_PRECIS = 2
	Local Const $CLIP_DEFAULT_PRECIS = 0
	Local Const $PROOF_QUALITY = 2
	Local Const $FIXED_PITCH = 1
	Local Const $RGN_XOR = 3
	Local Const $LOGPIXELSY = 90
	
	If $i_FontWeight = "" Or $i_FontWeight = -1 Then
		$i_FontWeight = 400 ; default Font weight
	EndIf
	
	Local $hDC = _WinAPI_GetDC(0)
	Local $intDeviceCap = _WinAPI_GetDeviceCaps($hDC, $LOGPIXELSY)
	Local $intFontHeight = _WinAPI_MulDiv($i_FontSize, $intDeviceCap, 72)
	Local $hFont = _WinAPI_CreateFont(-$intFontHeight, 0, 0, 0, $i_FontWeight, 0, 0, 0, _
		$DEFAULT_CHARSET, $OUT_CHARACTER_PRECIS, $CLIP_DEFAULT_PRECIS, $PROOF_QUALITY, $FIXED_PITCH, $s_TextFont)
	
	_WinAPI_SelectObject($hDC, $hFont)
	Local $stRet = _WinAPI_GetTextExtentPoint32($hDC, $s_Data)
	
	_WinAPI_DeleteObject($hFont)
    _WinAPI_ReleaseDC(0, $hDC)
    ;_WinAPI_InvalidateRect(0, 0)
	
	Local $a_RetLen[2] = [DllStructGetData($stRet, 1), DllStructGetData($stRet, 2)]
	Return $a_RetLen
EndFunc

Func __AboutBox_BASSMOD_Start($sDllFile, $sSoundFile, $iFlag)
	If Not FileExists($sDllFile) Then
		Return SetError(1, 0, -1)
	EndIf
	
	Local $aRet[2]
	Local $hDll = DllOpen($sDllFile)
	
	If $hDll = -1 Then
		SetError(2, 0, -1)
	EndIf
	
	Local $Init = DllCall($hDll, "int", "BASSMOD_Init", "int", -1, _  ;device
		"int", 44100, _  ;freq Hz
		"int", 0)       ;flag
	
	Local $stFileName = DllStructCreate("char[255]")
	DllStructSetData($stFileName, 1, $sSoundFile)
	
	Local $aMusicLoad = DllCall($hDll, "int", "BASSMOD_MusicLoad", "int", False, _  ;loading from memory
		"ptr", DllStructGetPtr($stFileName), _ ;file
		"int", 0, _   ;offset
		"int", 0, _   ;length
		"int", $iFlag) ;flag
	
	Local $hSound = $aMusicLoad[0]
	DllCall($hDll, "int:cdecl", "BASSMOD_MusicPlay", "int", $hSound)
	
	$aRet[0] = $hDll
	$aRet[1] = $hSound
	
	Return $aRet
EndFunc

Func __AboutBox_BASSMOD_Close($hDll, $hSound)
	If $hDll = -1 Then
		Return SetError(1, 0, -1)
	EndIf
	
	DllCall($hDll, "int:cdecl", "BASSMOD_Free", "int", $hSound) ;clear resource
	DllClose($hDll)
EndFunc

Func __AboutBox_ShellExecuteEx($sCmd, $Args = "", $sFolder = "", $Verb = "", $rState = @SW_SHOWNORMAL, $hWnd = 0)
	Local $struINFO = DllStructCreate("long;long;long;ptr;ptr;ptr;ptr;long;long;long;ptr;long;long;long;long")
	Local $struVerb = DllStructCreate("char[15];char")
	Local $struPath = DllStructCreate("char[255];char")
	Local $struArgs = DllStructCreate("char[255];char")
	Local $struWDir = DllStructCreate("char[255];char")
	
	DllStructSetData($struVerb, 1, $Verb)
	
	If StringRight($sCmd, 3) = "lnk" Then
		Local $aShortcutInfo = FileGetShortcut($sCmd)
		
		If IsArray($aShortcutInfo) Then
			DllStructSetData($struPath, 1, $aShortcutInfo[0])
			DllStructSetData($struWDir, 1, $aShortcutInfo[1])
			DllStructSetData($struArgs, 1, $aShortcutInfo[2])
			$rState = $aShortcutInfo[6]
		Else
			Return SetError(1, 0, 0)
		EndIf
	Else
		DllStructSetData($struPath, 1, $sCmd)
		DllStructSetData($struWDir, 1, $sFolder)
		DllStructSetData($struArgs, 1, $Args)
	EndIf

	DllStructSetData($struINFO, 1, DllStructGetSize($struINFO))
	DllStructSetData($struINFO, 2, BitOR(0xC, 0x40, 0x400))
	DllStructSetData($struINFO, 3, $hWnd)
	DllStructSetData($struINFO, 4, DllStructGetPtr($struVerb))
	DllStructSetData($struINFO, 5, DllStructGetPtr($struPath))
	DllStructSetData($struINFO, 6, DllStructGetPtr($struArgs))
	DllStructSetData($struINFO, 7, DllStructGetPtr($struWDir))
	DllStructSetData($struINFO, 8, $rState)

	Local $iRet = DllCall("shell32.dll", "int", "ShellExecuteEx", "ptr", DllStructGetPtr($struINFO))
	If Not IsArray($iRet) Or Not $iRet[0] Then Return SetError(2, 0, 0)
	
	Return 1
EndFunc

#EndRegion Internal Functions
