#NoTrayIcon
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_icon=Resources\Icon.ico
#AutoIt3Wrapper_Compression=4
#AutoIt3Wrapper_UseUpx=n
#AutoIt3Wrapper_Res_Comment=Program made by G.Sandler
#AutoIt3Wrapper_Res_Description=AutoIt Scripts Collector Tool
#AutoIt3Wrapper_Res_Fileversion=1.2.0.0
#AutoIt3Wrapper_Res_LegalCopyright=Copyright  2012 G.Sandler (CreatoR), www.autoit-script.ru. All rights reserved.
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=y
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****

#AutoIt3Wrapper_Autoit3Dir=D:\AutoIt_Versions\AutoIt_3.3.8.1

#Region Header

#CS
	Name:				ASC - AutoIt Scripts Collector
	Description:		AutoIt Scripts Collector Tool.
	Author:				G.Sandler, Copyright  2012 CreatoR's Lab, www.autoit-script.ru, www.creator-lab.ucoz.ru. All rights reserved.
	AutoIt version:		3.3.8.1
#CE

#include <APIConstants.au3>
#include <Constants.au3>
#include <GUIConstantsEx.au3>
#include <ComboConstants.au3>
#include <EditConstants.au3>
#include <StaticConstants.au3>
#include <WindowsConstants.au3>

#include <GUIImageList.au3>
#include <GUIButton.au3>
#Include <GUIListView.au3>

#Include <File.au3>
#Include <Misc.au3>
#Include <String.au3>

#include "Includes\Translation.au3"
#include "Includes\AppCheckUpdates.au3"
#Include "Includes\AboutBox.au3"
#include "Includes\Restart.au3"
#Include "Includes\Plugins.au3"
#Include "Includes\InputBoxEx.au3"
#Include "Includes\ModernMenu.au3"
#Include "Includes\GUIResizingLimit.au3"
#Include "Includes\GUISkin.au3"
#Include "Includes\WinAPIEx.au3"

Opt("GUIOnEventMode", 1)
Opt("GUIEventOptions", 1)
Opt("GUIResizeMode", $GUI_DOCKSIZE)

#EndRegion Header

#Region Global Variables

;========== DEFAULTS ==========
Global $sDef_App_Language				= "English"

Global $iDef_Check_Updates 				= 1
Global $iDef_Check_Updates_Frequency 	= 72 ;Hours
Global $iDef_Start_App_With_Windows 	= 0
Global $iDef_Copy_Scripts_To_DataBase 	= 0
Global $iDef_Confirm_Category_Delete 	= 1
Global $iDef_Confirm_Category_Clear 	= 1
Global $iDef_Confirm_ScriptFile_Delete 	= 1
Global $iDef_Confirm_ScriptList_Remove 	= 1
Global $sDef_Scripts_DataBase_Path 		= @ScriptDir & "\Scripts_DataBase"
Global $sDef_Scripts_DataBase_File 		= @ScriptDir & "\Scripts_DataBase.db"
Global $iDef_DoubleClick_Action 		= 0 ;0 = Run, 1 = Edit
Global $iDef_Use_BuiltIn_Plugin 		= 1
Global $sDef_Scripts_Editor 			= "Editor_Plugin"

Global $iDef_Set_OnTop					= 0
Global $iDef_Minimize_To_Tray			= 0
Global $iDef_Start_Minimized			= 0
Global $iDef_Use_Skin_For_GUI			= 1
Global $iDef_GUIStick					= 1
Global $iDef_GUIStick_To_All			= 0
Global $iDef_GUIStick_Range				= 15
;========== DEFAULTS ==========

Global $sConfig_File 				= StringTrimRight(@ScriptFullPath, 3) & "ini"
Global $sIcons_File 				= @ScriptDir & "\Resources\Icons.icl"

FileInstall("Resources\Icons.icl", $sIcons_File)

Global $sApp_Language				= IniRead($sConfig_File, "Main Settings", "Language", $sDef_App_Language)
Global $aTXT 						= _AppTranslation_Register($LANGS_DIR & "\" & $sApp_Language & ".lng")

Global $sApp_Version 				= StringLeft(_Iif(@Compiled, FileGetVersion(@AutoItExe, "FileVersion"), StringRegExpReplace(FileRead(@ScriptFullPath), '(?s).*?#AutoIt3Wrapper_Res_Fileversion=(.*?)\r?\n.*', '\1')), 3)

Global $sApp_ShortTitle 			= $aTXT[$iMSG_AutoItScriptsCollector]
Global $sApp_Title 					= "ASC -> " & $sApp_ShortTitle
Global $sApp_FullTitle				= $sApp_Title ;& " - " & $sApp_Version

Global $sCopyRight_String 			= "Copyright  2012 CreatoR's Lab (G.Sandler)"
Global $sCopyRight_URL 				= "http://creator-lab.ucoz.ru"

Global $sSpecialFor_String 			= $aTXT[$iMSG_SpeciallyForAut_ussianCommunity]
Global $sSpecialFor_URL 			= "http://autoit-script.ru"

Global $sAppUpdate_ServerPage 		= "http://creator-lab.ucoz.ru/Update_Files/ASC_Update.dat"
Global $sAppUpdate_AppName 			= "ASC"
Global $sAppUpdate_AppVersion 		= $sApp_Version

Global $iCheck_Updates 				= IniRead($sConfig_File, "Main Settings", "Check Updates", $iDef_Check_Updates)
Global $iCheck_Updates_Frequency 	= IniRead($sConfig_File, "Main Settings", "Check Updates Frequency", $iDef_Check_Updates_Frequency)
Global $iStart_App_With_Windows 	= IniRead($sConfig_File, "Main Settings", "Start With Windows", $iDef_Start_App_With_Windows)
Global $iCopy_Scripts_To_DataBase 	= IniRead($sConfig_File, "Main Settings", "Copy Scripts To DataBase", $iDef_Copy_Scripts_To_DataBase)
Global $iConfirm_Category_Delete 	= IniRead($sConfig_File, "Main Settings", "Confirm Category Delete", $iDef_Confirm_Category_Delete)
Global $iConfirm_Category_Clear 	= IniRead($sConfig_File, "Main Settings", "Confirm Category Clear", $iDef_Confirm_Category_Clear)
Global $iConfirm_ScriptFile_Delete 	= IniRead($sConfig_File, "Main Settings", "Confirm Script File Delete", $iDef_Confirm_ScriptFile_Delete)
Global $iConfirm_ScriptList_Remove 	= IniRead($sConfig_File, "Main Settings", "Confirm Script List Remove", $iDef_Confirm_ScriptList_Remove)
Global $sScripts_DataBase_Path 		= IniRead($sConfig_File, "Main Settings", "Scripts DataBase", $sDef_Scripts_DataBase_Path)
Global $sScripts_DataBase_File 		= IniRead($sConfig_File, "Main Settings", "DataBase File", $sDef_Scripts_DataBase_File)
Global $iDoubleClick_Action 		= IniRead($sConfig_File, "Main Settings", "Double Click Action", $iDef_DoubleClick_Action)
Global $iUse_BuiltIn_Plugin 		= IniRead($sConfig_File, "Main Settings", "Use Built-In Plugin As Editor", $iDef_Use_BuiltIn_Plugin)
Global $sScripts_Editor 			= IniRead($sConfig_File, "Main Settings", "Script Editor", $sDef_Scripts_Editor)

Global $iSet_OnTop					= IniRead($sConfig_File, "Window Settings", "Set On Top", $iDef_Set_OnTop)
Global $iMinimize_To_Tray			= IniRead($sConfig_File, "Window Settings", "Minimize To Tray", $iDef_Minimize_To_Tray)
Global $iStart_Minimized			= IniRead($sConfig_File, "Window Settings", "Start Minimized", $iDef_Start_Minimized)
Global $iUse_Skin_For_GUI			= IniRead($sConfig_File, "Window Settings", "Use Skin For GUI", $iDef_Use_Skin_For_GUI)
Global $iGUIStick					= IniRead($sConfig_File, "Window Settings", "GUI Stick", $iDef_GUIStick)
Global $iGUIStick_To_All			= IniRead($sConfig_File, "Window Settings", "GUI Stick To All", $iDef_GUIStick_To_All)
Global $iGUIStick_Range				= IniRead($sConfig_File, "Window Settings", "GUI Stick Range", $iDef_GUIStick_Range)

Global $iDef_GUILeft 				= -1
Global $iDef_GUITop 				= -1
Global $iDef_GUIWidth 				= 700
Global $iDef_GUIHeight 				= 550

Global $iGUI_Left					= IniRead($sConfig_File, "Window Settings", "Left", $iDef_GUILeft)
Global $iGUI_Top					= IniRead($sConfig_File, "Window Settings", "Top", $iDef_GUITop)
Global $iGUI_Width					= IniRead($sConfig_File, "Window Settings", "Width", $iDef_GUIWidth)
Global $iGUI_Height					= IniRead($sConfig_File, "Window Settings", "Height", $iDef_GUIHeight)

If $iGUI_Left	= -1 Or $iGUI_Left	= "" 	Then $iGUI_Left = Default
If $iGUI_Top	= -1 Or $iGUI_Top	= "" 	Then $iGUI_Top 	= Default

Global $aGUI_Last_Pos
Global $hSetting_GUI
Global $iSettings_OK_Button

Global $iCategory_Changed 			= 0
Global $iInput_Changed 				= 0
Global $iDouble_Clicked_Event 		= 0

Global Enum $iSL_Count, $iSL_FileName, $iSL_FileAuthor, $iSL_FileSize, $iSL_FileTime, $iSL_FilePath, $iSL_Total
Global $aScriptsList_Arr[1][1]

Global $sLast_Category 				= ""
Global $iLast_Sel_Category_Indx 	= -1

Global $sOld_Filter_Text 			= ""
Global $nOld_Radio 					= ""

Global $sGroup_RegExp 				= "\A(+) (.*?) (\1)\z"

Global $aDropped_Files[1]
Global $aAllowed_Scripts_DropExt 	= StringSplit(".au3", "|")
Global $aAllowed_Category_DropExt 	= StringSplit("D", "|")

Global Const $COPYANI 				= 161
Global Const $DELANI 				= 162
Global Const $CHECKANI 				= 165
Global Const $WEBSEARCHANI 			= 166
Global Const $COPYFROMWEBANI 		= 170

Global Const $ODT_LISTVIEW 			= 102
Global Const $ODA_DRAWENTIRE 		= 0x1
Global Const $ODA_SELECT 			= 0x2
Global Const $ODA_FOCUS 			= 0x4
Global Const $ODS_NOFOCUSRECT 		= 0x200

;Change HotKeys here
Global Const _
	$sCreateScript_HK 				= "(Ctrl + Shift + S)", _
	$sAddScript_HK 					= "(Ctrl + Shift + A)", _
	$sCopyScriptTo_HK 				= "(Ctrl + Shift + C)", _
	$sCopyScriptToCategory_HK 		= "(Ctrl + Alt + C)", _
	$sRunScript_HK 					= "(Ctrl + R)", _
	$sEditScript_HK 				= "(Ctrl + E)", _
	$sRenameScript_HK 				= "(Ctrl + Shift + R)", _
	$sDelScriptFile_HK 				= "(Shift + Del)", _
	$sRemoveScriptFromList_HK 		= "(Del)", _
	$sCopyScriptPath_HK 			= "(Ctrl + Shift + P)", _
	$sCopyScriptName_HK 			= "(Ctrl + Shift + N)", _
	$sCopyScriptInfo_HK 			= "(Ctrl + Shift + I)", _
	$sOpenScriptDir_HK 				= "(Ctrl + D)", _
	$sMoveItemsUp_HK 				= "(Ctrl + Up)", _
	$sMoveItemsDown_HK 				= "(Ctrl + Down)", _
	$sNewCategory_HK 				= "(Ctrl + N)", _
	$sNewGroup_HK 					= "(Ctrl + G)", _
	$sRemoveEmptyCategory_HK 		= "(Ctrl + Shift + E)", _
	$sRemoveNonExistScripts_HK 		= "(Ctrl + Alt + E)", _
	$sDelCategory_HK 				= "(Ctrl + Shift + Del)", _
	$sCleanCategory_HK 				= "(Alt + C)", _
	$sRenameCategory_HK 			= "(Ctrl + Alt + R)", _
	$sSettings_HK 					= '(F12)', _
	$sAbout_HK 						= '(F1)'

Global $aAppUpdate_Msgs[12] 		= _
	[11, _
		$aTXT[$iMSG_Attention], _
		$aTXT[$iMSG_Error], _
		$aTXT[$iMSG_UpdateCheck], _
		$aTXT[$iMSG_PleaseCompileThisApp], _
		$aTXT[$iMSG_ThereWasErrorCheckUpdates], _
		$aTXT[$iMSG_ThereIsNewVersion], _
		$aTXT[$iMSG_ThereWasErrorDownloadUpdate], _
		$aTXT[$iMSG_YouAreUsingNewstVersion], _
		$aTXT[$iMSG_PleaseCheckInternetConnect], _
		$aTXT[$iMSG_Downloading], _
		$aTXT[$iMSG_Completed] _
	]

;=============== Initialization - Should be here before all other stuff ===============

_ASC_PreventSecondCopy()

;=============== Initialization - Should be here before all other stuff ===============

#EndRegion Global Variables

#Region Tray

Opt('TrayOnEventMode', 1)
Opt('TrayMenuMode', BitOR(1, 2))

TraySetClick(16)

$ShowGUI_TrayItem = TrayCreateItem($aTXT[$iMSG_ShowMainWindow])
TrayItemSetState($ShowGUI_TrayItem, $TRAY_DEFAULT)
TrayItemSetOnEvent($ShowGUI_TrayItem, '_Tray_Events')
TrayCreateItem('')
$Create_Script_TrayItem = TrayCreateItem($aTXT[$iMSG_CreateScript])
TrayItemSetOnEvent($Create_Script_TrayItem, '_Tray_Events')
$Add_Scripts_TrayItem = TrayCreateItem($aTXT[$iMSG_AddScripts])
TrayItemSetOnEvent($Add_Scripts_TrayItem, '_Tray_Events')
TrayCreateItem('')
$Exit_TrayItem = TrayCreateItem($aTXT[$iMSG_Exit])
TrayItemSetOnEvent($Exit_TrayItem, '_Tray_Events')

#EndRegion Tray

#Region GUI

$hMain_GUI = GUICreate($sApp_FullTitle, $iDef_GUIWidth, $iDef_GUIHeight, $iDef_GUILeft, $iDef_GUITop, BitOR($GUI_SS_DEFAULT_GUI, $WS_SIZEBOX, $WS_CLIPCHILDREN), BitOR($WS_EX_ACCEPTFILES, $WS_EX_CLIENTEDGE))

If $iUse_Skin_For_GUI = 1 Then
	_GUISetSkin(@ScriptDir & "\Skins\Skin.dll", @ScriptDir & "\Skins\Skin.skf", $hMain_GUI)
Else
	GUISetBkColor(0xCCCCCC)
EndIf

GUISetIcon($sIcons_File, -11, $hMain_GUI)
GUISetFont(8.3, 400, 0, "Microsoft Sans Serif")

#Region Scripts Part

$Scripts_LV = GUICtrlCreateListView($aTXT[$iMSG_Count] & "|" & $aTXT[$iMSG_ScriptName] & "|" & $aTXT[$iMSG_Author] & "|" & $aTXT[$iMSG_Size] & "|" & $aTXT[$iMSG_Modified] & "|" & $aTXT[$iMSG_FilePath], _
	10, 10, 465, 350, $LVS_SHOWSELALWAYS, BitOR($LVS_EX_GRIDLINES, $LVS_EX_FULLROWSELECT))
$hScripts_LV = GUICtrlGetHandle($Scripts_LV)
GUICtrlSetResizing(-1, BitOR($GUI_DOCKLEFT, $GUI_DOCKRIGHT, $GUI_DOCKTOP, $GUI_DOCKBOTTOM))
GUICtrlSetState(-1, $GUI_DROPACCEPTED)

$Context_Menu = GUICtrlCreateContextMenu($Scripts_LV)

$nSideMenuItem = _CreateSideMenu($Context_Menu)
_SetSideMenuText($nSideMenuItem, $aTXT[$iMSG_MainContextMenu])
_SetSideMenuColor($nSideMenuItem, 0xFFFFFF) ; default color - white
_SetSideMenuBkColor($nSideMenuItem, 0x921801) ; bottom start color - dark blue
_SetSideMenuBkGradColor($nSideMenuItem, 0xFBCE92) ; top end color - light blue
_SetMenuBkColor(0xFDF5F4)

$Create_Script_MenuItem = _GUICtrlCreateODMenuItem($aTXT[$iMSG_CreateScript_1] & @TAB & $sCreateScript_HK, $Context_Menu, $sIcons_File, -1)
GUICtrlSetOnEvent(-1, "_Main_Events")

_GUICtrlCreateODMenuItem("", $Context_Menu)

$Add_Scripts_MenuItem = _GUICtrlCreateODMenuItem($aTXT[$iMSG_AddScripts] & @TAB & $sAddScript_HK, $Context_Menu, $sIcons_File, -1)
GUICtrlSetOnEvent(-1, "_Main_Events")

$Copy_ScriptTo_MenuItem = _GUICtrlCreateODMenuItem($aTXT[$iMSG_CopyScriptsTo] & @TAB & $sCopyScriptTo_HK, $Context_Menu, $sIcons_File, -2)
GUICtrlSetOnEvent(-1, "_Main_Events")

$Copy_ScriptToCategory_MenuItem = _GUICtrlCreateODMenuItem($aTXT[$iMSG_CopyScriptsToOtherCategory] & @TAB & $sCopyScriptToCategory_HK, $Context_Menu, $sIcons_File, -25)
GUICtrlSetOnEvent(-1, "_Main_Events")

_GUICtrlCreateODMenuItem("", $Context_Menu)

$Run_ScriptFile_MenuItem = _GUICtrlCreateODMenuItem($aTXT[$iMSG_RunScript] & @TAB & $sRunScript_HK, $Context_Menu, $sIcons_File, -3)
GUICtrlSetOnEvent(-1, "_Main_Events")

$Edit_ScriptFile_MenuItem = _GUICtrlCreateODMenuItem($aTXT[$iMSG_EditScript] & @TAB & $sEditScript_HK, $Context_Menu, $sIcons_File, -4)
GUICtrlSetOnEvent(-1, "_Main_Events")

_GUICtrlCreateODMenuItem("", $Context_Menu)

$Rename_ScriptFile_MenuItem = _GUICtrlCreateODMenuItem($aTXT[$iMSG_RenameScript] & @TAB & $sRenameScript_HK, $Context_Menu, $sIcons_File, -5)
GUICtrlSetOnEvent(-1, "_Main_Events")

$Delete_ScriptFile_MenuItem = _GUICtrlCreateODMenuItem(" ", $Context_Menu, $sIcons_File, -24)
GUICtrlSetOnEvent(-1, "_Main_Events")
_GUICtrlODMenuItemSetText($Delete_ScriptFile_MenuItem, $aTXT[$iMSG_DeleteScriptFile] & _Iif($iConfirm_ScriptFile_Delete = 1, "...", "") & @TAB & $sDelScriptFile_HK)

$Remove_ScriptFromList_MenuItem = _GUICtrlCreateODMenuItem(" ", $Context_Menu, $sIcons_File, -6)
GUICtrlSetOnEvent(-1, "_Main_Events")
_GUICtrlODMenuItemSetText($Remove_ScriptFromList_MenuItem, $aTXT[$iMSG_RemoveScriptFromList] & _Iif($iConfirm_ScriptList_Remove = 1, "...", "") & @TAB & $sRemoveScriptFromList_HK)

_GUICtrlCreateODMenuItem("", $Context_Menu)

$Copy_ScriptPath_MenuItem = _GUICtrlCreateODMenuItem($aTXT[$iMSG_CopyScriptsFullPath] & @TAB & $sCopyScriptPath_HK, $Context_Menu, $sIcons_File, -7)
GUICtrlSetOnEvent(-1, "_Main_Events")

$Copy_ScriptName_MenuItem = _GUICtrlCreateODMenuItem($aTXT[$iMSG_CopyScriptsFileName] & @TAB & $sCopyScriptName_HK, $Context_Menu, $sIcons_File, -7)
GUICtrlSetOnEvent(-1, "_Main_Events")

$Copy_ScriptInfo_MenuItem = _GUICtrlCreateODMenuItem($aTXT[$iMSG_CopyScriptsInformation] & @TAB & $sCopyScriptInfo_HK, $Context_Menu, $sIcons_File, -8)
GUICtrlSetOnEvent(-1, "_Main_Events")

_GUICtrlCreateODMenuItem("", $Context_Menu)

$Open_ScriptDir_MenuItem = _GUICtrlCreateODMenuItem($aTXT[$iMSG_OpenScriptDir] & @TAB & $sOpenScriptDir_HK, $Context_Menu, $sIcons_File, -9)
GUICtrlSetOnEvent(-1, "_Main_Events")

_GUICtrlCreateODMenuItem("", $Context_Menu)

$Search_ScriptOnAutoItScriptCom_MenuItem = _GUICtrlCreateODMenuItem($aTXT[$iMSG_SearchScriptOnAutoitScriptCom], $Context_Menu, $sIcons_File, -26)
GUICtrlSetOnEvent(-1, "_Main_Events")

$Search_ScriptOnAutoItScriptRu_MenuItem = _GUICtrlCreateODMenuItem($aTXT[$iMSG_SearchScriptOnAutoitScriptRu], $Context_Menu, $sIcons_File, -26)
GUICtrlSetOnEvent(-1, "_Main_Events")

$Search_Label = GUICtrlCreateLabel($aTXT[$iMSG_Search], 10, _Iif($iUse_Skin_For_GUI = 1, 368, 375))
GUICtrlSetFont(-1, 9, 800, 4)
GUICtrlSetCursor(-1, 0)
GUICtrlSetColor(-1, 0x0000FF)
GUICtrlSetOnEvent(-1, "_Main_Events")
GUICtrlSetResizing(-1, BitOR($GUI_DOCKLEFT, $GUI_DOCKBOTTOM, $GUI_DOCKSIZE))

$Filter_Input = GUICtrlCreateInput("", 60, 370, 415, _Iif($iUse_Skin_For_GUI = 1, 20, 24), -1, BitOR($WS_EX_DLGMODALFRAME, $WS_EX_CLIENTEDGE))
GUICtrlSetResizing(-1, BitOR($GUI_DOCKLEFT, $GUI_DOCKBOTTOM, $GUI_DOCKRIGHT, $GUI_DOCKSIZE))

$RegExpSearch_CB = GUICtrlCreateCheckbox($aTXT[$iMSG_RegExpSearch], 10, 395, -1, 15)
GUICtrlSetOnEvent(-1, "_Main_Events")
GUICtrlSetResizing(-1, BitOR($GUI_DOCKLEFT, $GUI_DOCKBOTTOM, $GUI_DOCKSIZE))

$CaseSenseSearch_CB = GUICtrlCreateCheckbox($aTXT[$iMSG_CaseSensitive], 190, 395, -1, 15)
GUICtrlSetOnEvent(-1, "_Main_Events")
GUICtrlSetResizing(-1, BitOR($GUI_DOCKLEFT, $GUI_DOCKBOTTOM, $GUI_DOCKSIZE))

$WholeWordSearch_CB = GUICtrlCreateCheckbox($aTXT[$iMSG_WholeWordOnly], 370, 395, -1, 15)
GUICtrlSetOnEvent(-1, "_Main_Events")
GUICtrlSetResizing(-1, BitOR($GUI_DOCKLEFT, $GUI_DOCKBOTTOM, $GUI_DOCKSIZE))

$SearchInScripts_CB = GUICtrlCreateCheckbox($aTXT[$iMSG_SearchInsideTheScripts], 10, 415, -1, 15)
GUICtrlSetOnEvent(-1, "_Main_Events")
GUICtrlSetResizing(-1, BitOR($GUI_DOCKLEFT, $GUI_DOCKBOTTOM, $GUI_DOCKSIZE))

$aGroup = _GUICtrlCreateGroupEx($aTXT[$iMSG_FilterBy], 7, 440, 473, 65, 3, 0x0000FF, 1, $sIcons_File, -15)
GUICtrlSetResizing($aGroup[0], BitOR($GUI_DOCKSIZE, $GUI_DOCKLEFT, $GUI_DOCKRIGHT, $GUI_DOCKBOTTOM))
GUICtrlSetResizing($aGroup[0] + 1, BitOR($GUI_DOCKSIZE, $GUI_DOCKBOTTOM, $GUI_DOCKLEFT))
GUICtrlSetResizing($aGroup[0] + 2, BitOR($GUI_DOCKSIZE, $GUI_DOCKBOTTOM, $GUI_DOCKRIGHT))
GUICtrlSetResizing($aGroup[0] + 3, BitOR($GUI_DOCKSIZE, $GUI_DOCKLEFT, $GUI_DOCKRIGHT, $GUI_DOCKBOTTOM))
GUICtrlSetResizing($aGroup[0] + 4, BitOR($GUI_DOCKSIZE, $GUI_DOCKLEFT, $GUI_DOCKBOTTOM))
GUICtrlSetResizing($aGroup[0] + 5, BitOR($GUI_DOCKSIZE, $GUI_DOCKLEFT, $GUI_DOCKBOTTOM))

$ScriptCount_Radio = GUICtrlCreateRadio($aTXT[$iMSG_Count_1], 20, 455, -1, 15)
GUICtrlSetOnEvent(-1, "_Main_Events")
GUICtrlSetResizing(-1, BitOR($GUI_DOCKLEFT, $GUI_DOCKBOTTOM, $GUI_DOCKSIZE))

$ScriptSize_Radio = GUICtrlCreateRadio($aTXT[$iMSG_Size_1], 20, 475, -1, 15)
GUICtrlSetOnEvent(-1, "_Main_Events")
GUICtrlSetResizing(-1, BitOR($GUI_DOCKLEFT, $GUI_DOCKBOTTOM, $GUI_DOCKSIZE))

$ScriptName_Radio = GUICtrlCreateRadio($aTXT[$iMSG_ScriptName_1], 180, 455, -1, 15)
GUICtrlSetOnEvent(-1, "_Main_Events")
GUICtrlSetState(-1, 1)
GUICtrlSetResizing(-1, BitOR($GUI_DOCKLEFT, $GUI_DOCKBOTTOM, $GUI_DOCKSIZE))
$nOld_Radio = $ScriptName_Radio

$ScriptModified_Radio = GUICtrlCreateRadio($aTXT[$iMSG_Modified_1], 180, 475, -1, 15)
GUICtrlSetOnEvent(-1, "_Main_Events")
GUICtrlSetResizing(-1, BitOR($GUI_DOCKLEFT, $GUI_DOCKBOTTOM, $GUI_DOCKSIZE))

$ScriptAuthor_Radio = GUICtrlCreateRadio($aTXT[$iMSG_Author_1], 340, 455, -1, 15)
GUICtrlSetOnEvent(-1, "_Main_Events")
GUICtrlSetResizing(-1, BitOR($GUI_DOCKLEFT, $GUI_DOCKBOTTOM, $GUI_DOCKSIZE))

$ScriptPath_Radio = GUICtrlCreateRadio($aTXT[$iMSG_FilePath_1], 340, 475, -1, 15)
GUICtrlSetOnEvent(-1, "_Main_Events")
GUICtrlSetResizing(-1, BitOR($GUI_DOCKLEFT, $GUI_DOCKBOTTOM, $GUI_DOCKSIZE))

#EndRegion Scripts Part

#Region Category Part

_GUICtrlCreateGroup(1, 480, 10, 3, 425)
GUICtrlSetBkColor(-1, 0x800000)
GUICtrlSetResizing(-1, BitOR($GUI_DOCKRIGHT, $GUI_DOCKTOP, $GUI_DOCKBOTTOM, $GUI_DOCKWIDTH))

$aLabel_Size = __AboutBox_GUICtrlLabelGetTextWidth($aTXT[$iMSG_Category], 12, 800)

GUICtrlCreateLabel($aTXT[$iMSG_Category], 495, 18, $aLabel_Size[0]+5, $aLabel_Size[1]+3)
GUICtrlSetFont(-1, 12, 800)
GUICtrlSetResizing(-1, BitOR($GUI_DOCKRIGHT, $GUI_DOCKTOP, $GUI_DOCKSIZE))

$MoveUpItem_Button = GUICtrlCreateButton("", 630, 18, 22, 20, $BS_ICON)
GUICtrlSetOnEvent(-1, "_Main_Events")
GUICtrlSetFont(-1, 9, 800, 0, "Wingdings")
GUICtrlSetImage(-1, $sIcons_File, -16, 0)
GUICtrlSetTip(-1, $aTXT[$iMSG_MoveItemUp] & "   " & $sMoveItemsUp_HK)
GUICtrlSetResizing(-1, BitOR($GUI_DOCKRIGHT, $GUI_DOCKTOP, $GUI_DOCKSIZE))

$MoveDownItem_Button = GUICtrlCreateButton("", 670, 18, 22, 20, $BS_ICON)
GUICtrlSetOnEvent(-1, "_Main_Events")
GUICtrlSetFont(-1, 9, 800, 0, "Wingdings")
GUICtrlSetImage(-1, $sIcons_File, -17, 0)
GUICtrlSetTip(-1, $aTXT[$iMSG_MoveItemDown] & "   " & $sMoveItemsDown_HK)
GUICtrlSetResizing(-1, BitOR($GUI_DOCKRIGHT, $GUI_DOCKTOP, $GUI_DOCKSIZE))

$Category_LV = GUICtrlCreateListView($aTXT[$iMSG_Category_1], 487, 40, 205, 462, BitOR($LVS_SHOWSELALWAYS, $LVS_NOSORTHEADER, $LVS_NOCOLUMNHEADER, $LVS_OWNERDRAWFIXED))
$hCategory_LV = GUICtrlGetHandle($Category_LV)
GUICtrlSetResizing(-1, BitOR($GUI_DOCKRIGHT, $GUI_DOCKTOP, $GUI_DOCKBOTTOM, $GUI_DOCKWIDTH))
GUICtrlSetState(-1, $GUI_DROPACCEPTED)
GUICtrlSetFont(-1, 9, 400, 0, 'Arial')

$Context_Menu = GUICtrlCreateContextMenu($Category_LV)
$nSideMenuItem = _CreateSideMenu($Context_Menu)
_SetSideMenuText($nSideMenuItem, $aTXT[$iMSG_CategoryControls])
_SetSideMenuColor($nSideMenuItem, 0xFFFFFF) ; default color - white
_SetSideMenuBkColor($nSideMenuItem, 0x921801) ; bottom start color - dark blue
_SetSideMenuBkGradColor($nSideMenuItem, 0xFBCE92) ; top end color - light blue
_SetMenuBkColor(0xFDF5F4)

$NewCategory_MenuItem = _GUICtrlCreateODMenuItem($aTXT[$iMSG_NewCategory] & @TAB & $sNewCategory_HK, $Context_Menu, $sIcons_File, -18)
GUICtrlSetOnEvent(-1, "_Main_Events")

$NewGroup_MenuItem = _GUICtrlCreateODMenuItem($aTXT[$iMSG_NewGroup] & @TAB & $sNewGroup_HK, $Context_Menu, $sIcons_File, -19)
GUICtrlSetOnEvent(-1, "_Main_Events")

_GUICtrlCreateODMenuItem("", $Context_Menu)

$RemoveEmptyCategories_MenuItem = _GUICtrlCreateODMenuItem($aTXT[$iMSG_RemoveEmptyCategories] & @TAB & $sRemoveEmptyCategory_HK, $Context_Menu, $sIcons_File, -29)
GUICtrlSetOnEvent(-1, "_Main_Events")

$RemoveNotExistsScripts_MenuItem = _GUICtrlCreateODMenuItem($aTXT[$iMSG_RemoveNotExistingScripts] & @TAB & $sRemoveNonExistScripts_HK, $Context_Menu, $sIcons_File, -24)
GUICtrlSetOnEvent(-1, "_Main_Events")

_GUICtrlCreateODMenuItem("", $Context_Menu)

$MoveUpItem_MenuItem = _GUICtrlCreateODMenuItem($aTXT[$iMSG_MoveItemUp] & @TAB & $sMoveItemsUp_HK, $Context_Menu, $sIcons_File, -16)
GUICtrlSetOnEvent(-1, "_Main_Events")

$MoveDownItem_MenuItem = _GUICtrlCreateODMenuItem($aTXT[$iMSG_MoveItemDown] & @TAB & $sMoveItemsDown_HK, $Context_Menu, $sIcons_File, -17)
GUICtrlSetOnEvent(-1, "_Main_Events")

_GUICtrlCreateODMenuItem("", $Context_Menu)

$RemoveCategory_MenuItem = _GUICtrlCreateODMenuItem($aTXT[$iMSG_Remove], $Context_Menu, $sIcons_File, -22)
_GUICtrlODMenuItemSetText($RemoveCategory_MenuItem, $aTXT[$iMSG_Remove_1] & _Iif($iConfirm_Category_Delete = 1, "...", "") & @TAB & $sRenameCategory_HK)
GUICtrlSetOnEvent(-1, "_Main_Events")

$ClearCategory_MenuItem = _GUICtrlCreateODMenuItem($aTXT[$iMSG_Clear], $Context_Menu, $sIcons_File, -6)
_GUICtrlODMenuItemSetText($ClearCategory_MenuItem, $aTXT[$iMSG_Clear_1] & _Iif($iConfirm_Category_Clear = 1, "...", "") & @TAB & $sCleanCategory_HK)
GUICtrlSetOnEvent(-1, "_Main_Events")

$RenameCategory_MenuItem = _GUICtrlCreateODMenuItem($aTXT[$iMSG_Rename] & @TAB & $sRenameCategory_HK, $Context_Menu, $sIcons_File, -21)
GUICtrlSetOnEvent(-1, "_Main_Events")

#EndRegion Category part

_GUICtrlCreateGroup(0, 8, $iDef_GUIHeight-40, 3, $iDef_GUIWidth-11)
GUICtrlSetBkColor(-1, 0x800000)
GUICtrlSetResizing(-1, BitOR($GUI_DOCKRIGHT, $GUI_DOCKLEFT, $GUI_DOCKBOTTOM, $GUI_DOCKHEIGHT))

$Exit_Button = _GUICtrlCreateButton($aTXT[$iMSG_Exit_1], 10, $iDef_GUIHeight-30, 80, 22, $sIcons_File, _Iif($iUse_Skin_For_GUI = 1, 29, 19))
GUICtrlSetOnEvent(-1, "_Main_Events")
GUICtrlSetResizing($Exit_Button[0], BitOR($GUI_DOCKLEFT, $GUI_DOCKBOTTOM, $GUI_DOCKSIZE))
GUICtrlSetResizing($Exit_Button[1], BitOR($GUI_DOCKLEFT, $GUI_DOCKBOTTOM, $GUI_DOCKSIZE))

$aHyperLink_Size = __AboutBox_GUICtrlLabelGetTextWidth($sCopyRight_String, 8, 0)

$Copyright_Hyperlink = _GUICtrlHyperlink_Create($sCopyRight_String, 375-$aHyperLink_Size[0], $iDef_GUIHeight-33, $aHyperLink_Size[0]+5, 15, 8, 0, 0x0000FF, $aTXT[$iMSG_Visit] & $sCopyRight_URL)
GUICtrlSetOnEvent(-1, "_Main_Events")
GUICtrlSetResizing(-1, BitOR($GUI_DOCKHCENTER, $GUI_DOCKBOTTOM, $GUI_DOCKSIZE))

$aHyperLink_Size = __AboutBox_GUICtrlLabelGetTextWidth($sSpecialFor_String, 7, 0)

$Special_Hyperlink = _GUICtrlHyperlink_Create($sSpecialFor_String, _Iif($sApp_Language = "Russian", 360, 350)-$aHyperLink_Size[0], $iDef_GUIHeight-17, $aHyperLink_Size[0]+5, 12, _
	7, 0, 0xF5F5F5, $aTXT[$iMSG_Visit_1] & $sSpecialFor_URL, 0)
GUICtrlSetOnEvent(-1, "_Main_Events")
GUICtrlSetResizing(-1, BitOR($GUI_DOCKHCENTER, $GUI_DOCKBOTTOM, $GUI_DOCKSIZE))

_GUICtrlCreateGroup(1, 480, $iDef_GUIHeight-30, 3, 25)
GUICtrlSetBkColor(-1, 0x800000)
GUICtrlSetResizing(-1, BitOR($GUI_DOCKRIGHT, $GUI_DOCKBOTTOM, $GUI_DOCKSIZE))

$aHyperLink_Size = __AboutBox_GUICtrlLabelGetTextWidth($aTXT[$iMSG_Settings], 9, 600)

$Settings_HyperlinkDummy = GUICtrlCreateDummy() ;For hotkey
GUICtrlSetOnEvent(-1, "_Main_Events")
$Settings_Hyperlink = _GUICtrlHyperlink_Create($aTXT[$iMSG_Settings], $iDef_GUIWidth-$aHyperLink_Size[0]-20, $iDef_GUIHeight-35, $aHyperLink_Size[0]+5, _
	15, 9, 600, 0x008000, $aTXT[$iMSG_ShowSettingsDialog] & '    ' & $sSettings_HK, 0)
GUICtrlSetOnEvent(-1, "_Main_Events")
GUICtrlSetResizing(-1, BitOR($GUI_DOCKRIGHT, $GUI_DOCKBOTTOM, $GUI_DOCKSIZE))

$aHyperLink_Size = __AboutBox_GUICtrlLabelGetTextWidth($aTXT[$iMSG_About], 9, 600)

$About_HyperlinkDummy = GUICtrlCreateDummy() ;For hotkey
GUICtrlSetOnEvent(-1, "_Main_Events")
$About_Hyperlink = _GUICtrlHyperlink_Create($aTXT[$iMSG_About], $iDef_GUIWidth-$aHyperLink_Size[0]-30, $iDef_GUIHeight-20, $aHyperLink_Size[0]+5, _
	15, 9, 600, 0x008000, $aTXT[$iMSG_ShowAboutDialog] & '    ' & $sAbout_HK)
GUICtrlSetOnEvent(-1, "_Main_Events")
GUICtrlSetResizing(-1, BitOR($GUI_DOCKRIGHT, $GUI_DOCKBOTTOM, $GUI_DOCKSIZE))

#EndRegion GUI

#Region Initializing application

Global $hLV_Header = _GUICtrlListView_GetHeader($hScripts_LV)
Global $hImage_List = _GUIImageList_Create(16, 16, 5, 3)

_GUIImageList_AddIcon($hImage_List, $sIcons_File, 12)
_GUIImageList_AddIcon($hImage_List, $sIcons_File, 26)
_GUIImageList_AddIcon($hImage_List, $sIcons_File, 27)
_GUICtrlListView_SetImageList($hScripts_LV, $hImage_List, 1)
_GUICtrlHeader_SetImageList($hLV_Header, $hImage_List)

_Set_CategoryList_Proc()
_GUIResizingSetLimit($hMain_GUI, $iDef_GUIWidth, $iDef_GUIHeight, @DesktopWidth - 15, @DesktopHeight)
Initialize_Plugins_Proc()

If IsAdmin() Then
	_WinAPI_ChangeWindowMessageFilterEx($hScripts_LV, $WM_COPYGLOBALDATA, $MSGFLT_ALLOW)
	_WinAPI_ChangeWindowMessageFilterEx($hCategory_LV, $WM_DROPFILES, $MSGFLT_ALLOW)
EndIf

GUIRegisterMsg($WM_COMMAND, "WM_COMMAND")
GUIRegisterMsg($WM_DROPFILES, "WM_DROPFILES")
GUIRegisterMsg($WM_NOTIFY, "WM_NOTIFY")
GUIRegisterMsg($WM_NCHITTEST, "WM_NCHITTEST")
GUIRegisterMsg($WM_EXITSIZEMOVE, "WM_EXITSIZEMOVE")
GUIRegisterMsg($WM_SYSCOMMAND, "WM_SYSCOMMAND")
GUIRegisterMsg($WM_WINDOWPOSCHANGING, "WM_WINDOWPOSCHANGING")
GUIRegisterMsg($WM_ENTERMENULOOP, "WM_ENTERMENULOOP")

GUISetOnEvent($GUI_EVENT_CLOSE, "_Main_Events")
GUISetOnEvent($GUI_EVENT_MINIMIZE, "_Main_Events")
GUISetOnEvent($GUI_EVENT_RESTORE, "_Main_Events")
GUISetOnEvent($GUI_EVENT_DROPPED, "_Main_Events")

If $iDoubleClick_Action = 1 Then
	GUICtrlSetState($Edit_ScriptFile_MenuItem, $GUI_DEFBUTTON)
Else
	GUICtrlSetState($Run_ScriptFile_MenuItem, $GUI_DEFBUTTON)
EndIf

$aWinMetrics = _WinGetMetrics($hMain_GUI)

If $iGUI_Width = $iDef_GUIWidth Then $iGUI_Width += ($aWinMetrics[0] * 2)
If $iGUI_Height = $iDef_GUIHeight Then $iGUI_Height += ($aWinMetrics[0] * 2) + $aWinMetrics[1]

WinSetOnTop($hMain_GUI, "", $iSet_OnTop)
WinMove($hMain_GUI, "", $iGUI_Left, $iGUI_Top, $iGUI_Width, $iGUI_Height)

_GUICtrlListView_SetColEquelWidth($hMain_GUI, $Scripts_LV, 0, 50)

If $iStart_Minimized = 1 Then
	TraySetState(1)
	TraySetIcon($sIcons_File, -11)
Else
	GUISetState(@SW_SHOW, $hMain_GUI)
EndIf

;Fix for hotkey/Accelerators assign problem
_WinAPI_LoadKeyboardLayoutEx(0x0409)
_GUICtrlListView_RegisterSortCallBackEx($hScripts_LV, 0, ($iUse_Skin_For_GUI = 0))

Dim $aAccelKeys[24][2] = _
	[ _
		[$sAbout_HK, $About_HyperlinkDummy], [$sSettings_HK, $Settings_HyperlinkDummy], _
		[$sCreateScript_HK, $Create_Script_MenuItem], _
		[$sAddScript_HK, $Add_Scripts_MenuItem], [$sCopyScriptTo_HK, $Copy_ScriptTo_MenuItem], [$sCopyScriptToCategory_HK, $Copy_ScriptToCategory_MenuItem], _
		[$sRunScript_HK, $Run_ScriptFile_MenuItem], [$sEditScript_HK, $Edit_ScriptFile_MenuItem], _
		[$sRenameScript_HK, $Rename_ScriptFile_MenuItem], [$sDelScriptFile_HK, $Delete_ScriptFile_MenuItem], [$sRemoveScriptFromList_HK, $Remove_ScriptFromList_MenuItem], _
		[$sCopyScriptPath_HK, $Copy_ScriptPath_MenuItem], [$sCopyScriptName_HK, $Copy_ScriptName_MenuItem], [$sCopyScriptInfo_HK, $Copy_ScriptInfo_MenuItem], _
		[$sOpenScriptDir_HK, $Open_ScriptDir_MenuItem], _
		[$sMoveItemsUp_HK, $MoveUpItem_Button], [$sMoveItemsDown_HK, $MoveDownItem_Button], _
		[$sNewCategory_HK, $NewCategory_MenuItem], [$sNewGroup_HK, $NewGroup_MenuItem], _
		[$sRemoveEmptyCategory_HK, $RemoveEmptyCategories_MenuItem], [$sRemoveNonExistScripts_HK, $RemoveNotExistsScripts_MenuItem], _
		[$sRenameCategory_HK, $RemoveCategory_MenuItem], [$sCleanCategory_HK, $ClearCategory_MenuItem], [$sRenameCategory_HK, $RenameCategory_MenuItem] _
	]

;Transform Hotkeys strings to Accelerators supported
For $i = 0 To UBound($aAccelKeys)-1
	$aAccelKeys[$i][0] = _String_HotKeyToAccelStr($aAccelKeys[$i][0])
Next

GUISetAccelerators($aAccelKeys, $hMain_GUI)
OnAutoItExitRegister("_ASC_Exit")

;Here we check in quit mode (only if new version available there will be a message).
If $iCheck_Updates = 1 Then
	$iCU_TimerInit = IniRead($sConfig_File, "Main Settings", "Check Updates Timer Init", 0)
	
	If $iCU_TimerInit <= 0 Or (TimerDiff($iCU_TimerInit) / 1000 / 60 / 60) >= $iCheck_Updates_Frequency Then
		IniWrite($sConfig_File, "Main Settings", "Check Updates Timer Init", TimerInit())
		$hUpdateWait_GUI = _UpdateWait_GUI($hMain_GUI)
		_AppCheckUpdates($hMain_GUI, 1, 1, $sApp_Language, $hUpdateWait_GUI) ;Check update quitly
		_CloseUpdateWaitGUI($hMain_GUI, $hUpdateWait_GUI)
	EndIf
EndIf

#EndRegion Initializing application

#Region Main Loop

While 1
	Sleep(10)
	
	If $iInput_Changed Then
		$iInput_Changed = 0
		_GUICtrlListView_SortByFilter_Proc($Scripts_LV)
	EndIf
	
	If $iCategory_Changed Then
		$iCategory_Changed = 0
		$sCurrent_Category = _GetCurrentCategory_Proc()
		
		If $sCurrent_Category = "" Then
			ContinueLoop
		EndIf
		
		If $sCurrent_Category <> $sLast_Category Then
			$sLast_Category = $sCurrent_Category
			$sOld_Filter_Text = ""
			
			_SendMessage($hScripts_LV, $LVM_DELETEALLITEMS)
			_Set_ScriptsList_Proc($sCurrent_Category, 1)
		EndIf
	EndIf
	
	If $iDouble_Clicked_Event Then
		$iDouble_Clicked_Event = 0
		
		If $iDoubleClick_Action = 0 Then
			_Control_ScriptFile_Proc(2) ;Run the script
		Else
			_Control_ScriptFile_Proc(3) ;Edit the script
		EndIf
	EndIf
WEnd

#EndRegion Main Loop

#Region Functions

Func _Main_Events()
	Switch @GUI_CtrlId
		Case $GUI_EVENT_CLOSE, $Exit_Button[1]
			Exit
		Case $GUI_EVENT_MINIMIZE
			_Hide_GUI_Event()
		Case $GUI_EVENT_RESTORE
			GUISetState(@SW_RESTORE, $hMain_GUI)
			_WinAPI_RedrawWindow($hMain_GUI, 0, 0, BitOR($RDW_ALLCHILDREN, $RDW_INVALIDATE))
		Case $GUI_EVENT_DROPPED
			_Dropped_Event_Handler(@GUI_CtrlId)
		Case $Settings_HyperlinkDummy
			_Settings_GUI($hMain_GUI)
		Case $Settings_Hyperlink
			_GUICtrlHyperlink_Handler($hMain_GUI, $Settings_Hyperlink, "_Settings_GUI(Hwnd(" & $hMain_GUI & "))", 1, 0x008000)
		Case $About_HyperlinkDummy
			_About_GUI($hMain_GUI)
		Case $About_Hyperlink
			_GUICtrlHyperlink_Handler($hMain_GUI, $About_Hyperlink, "_About_GUI(Hwnd(" & $hMain_GUI & "))", 1, 0x008000)
		Case $Copyright_Hyperlink
			_GUICtrlHyperlink_Handler($hMain_GUI, $Copyright_Hyperlink, $sCopyRight_URL, -1, 0x551A8B)
		Case $Special_Hyperlink
			_GUICtrlHyperlink_Handler($hMain_GUI, $Special_Hyperlink, $sSpecialFor_URL, -1, 0xCE00CE)
		Case $MoveUpItem_Button, $MoveDownItem_Button, $MoveDownItem_MenuItem, $MoveUpItem_MenuItem
			Local $iMove_Mode = -1
			
			If @GUI_CtrlId = $MoveDownItem_Button Or @GUI_CtrlId = $MoveDownItem_MenuItem Then
				$iMove_Mode = 1
			EndIf
			
			_GUICtrlListView_MoveItems($hMain_GUI, $Category_LV, $iMove_Mode)
			_SetDataBaseCategories_Proc()
		Case $Search_Label
			Local $sCurrent_Filter_Text = GUICtrlRead($Filter_Input)
			
			If $sOld_Filter_Text <> $sCurrent_Filter_Text Then
				$iInput_Changed = True
			EndIf
		Case $ScriptCount_Radio, $ScriptName_Radio, $ScriptAuthor_Radio, $ScriptSize_Radio, $ScriptModified_Radio, $ScriptPath_Radio
			If @GUI_CtrlId <> $nOld_Radio And GUICtrlRead($Filter_Input) <> "" Then
				_GUICtrlListView_SortByFilter_Proc($Scripts_LV)
			EndIf
			
			$nOld_Radio = @GUI_CtrlId
		Case $RegExpSearch_CB, $CaseSenseSearch_CB, $WholeWordSearch_CB, $SearchInScripts_CB
			If @GUI_CtrlId = $SearchInScripts_CB Then
				Local $iState = $GUI_ENABLE
				
				If GUICtrlRead($SearchInScripts_CB) = $GUI_CHECKED Then
					$iState = $GUI_DISABLE
				EndIf
				
				For $iCtrlID = $ScriptCount_Radio To $ScriptPath_Radio
					GUICtrlSetState($iCtrlID, $iState)
				Next
			EndIf
			
			If GUICtrlRead($Filter_Input) <> "" Then
				_GUICtrlListView_SortByFilter_Proc($Scripts_LV)
			EndIf
		Case $NewCategory_MenuItem
			_AddNewCategory_Proc($aTXT[$iMSG_NewCategory_1], $aTXT[$iMSG_EnterANameForNewCategory], "")
		Case $NewGroup_MenuItem
			_AddNewCategory_Proc($aTXT[$iMSG_NewGroup_1], $aTXT[$iMSG_EnterANameForNewGroup], "Group")
		Case $RemoveCategory_MenuItem
			Local $sCurrent_Category = _GetCurrentCategory_Proc()
			Local $sCategory = ""
			
			Local $aSel_Categories = _GUICtrlListView_GetSelectedIndices($Category_LV, True)
			
			If $sCurrent_Category = "" Then
				Return 0
			EndIf
			
			If $iConfirm_Category_Delete = 1 Then
				Local $iAsk = _MsgBoxEx(256+48, 2, $aTXT[$iMSG_Attention], $aTXT[$iMSG_AreYouSureRemov_mListCompletely], 330, 120, $aTXT[$iMSG_DoNotAskMeAgain], 10, $hMain_GUI, $aTXT[$iMSG_Yes], $aTXT[$iMSG_No])
				
				Local $iAsk_Ret = BitAND($iAsk, 8)
				Local $iAsk_Calc = $iAsk - $iAsk_Ret
				
				If $iAsk_Ret = 8 Then
					$iConfirm_Category_Delete = 0
					_GUICtrlODMenuItemSetText($RemoveCategory_MenuItem, $aTXT[$iMSG_Remove_2])
					IniWrite($sConfig_File, "Main Settings", "Confirm Category Delete", 0)
				EndIf
				
				If $iAsk_Calc <> 6 Then
					Return 0
				EndIf
			EndIf
			
			For $i = UBound($aSel_Categories)-1 To 1 Step -1
				$sCategory = _GUICtrlListView_GetItemText($Category_LV, $aSel_Categories[$i])
				
				If $sCurrent_Category = $sCategory And Not _CategoryIsGroup($sCategory) Then
					_SendMessage($hScripts_LV, $LVM_DELETEALLITEMS)
					$aScriptsList_Arr = 0
					Dim $aScriptsList_Arr[1][1]
				EndIf
				
				_GUICtrlListView_DeleteItem($Category_LV, $aSel_Categories[$i])
				IniDelete($sScripts_DataBase_File, $sCategory)
			Next
		Case $ClearCategory_MenuItem
			Local $sCurrent_Category = _GetCurrentCategory_Proc()
			Local $iIndex = @extended
			
			If $sCurrent_Category = "" Then
				Return 0
			EndIf
			
			If _CategoryIsGroup($sCurrent_Category) Then
				Return __MsgBox(48, $aTXT[$iMSG_Error], $aTXT[$iMSG_UnableToClearSe_temIsAGroup], 0, $hMain_GUI)
			EndIf
			
			If $iConfirm_Category_Clear = 1 Then
				Local $iAsk = _MsgBoxEx(256+48, 2, $aTXT[$iMSG_Attention_1], $aTXT[$iMSG_AreYouSureClearThisCategory], 330, 120, $aTXT[$iMSG_DoNotAskMeAgain_1], 10, $hMain_GUI, $aTXT[$iMSG_Yes_1], $aTXT[$iMSG_No_1])
				Local $iAsk_Ret = BitAND($iAsk, 8)
				Local $iAsk_Calc = $iAsk - $iAsk_Ret
				
				If $iAsk_Ret = 8 Then
					$iConfirm_Category_Clear = 0
					_GUICtrlODMenuItemSetText($ClearCategory_MenuItem, $aTXT[$iMSG_Clear_2])
					IniWrite($sConfig_File, "Main Settings", "Confirm Category Clear", 0)
				EndIf
				
				If $iAsk_Calc <> 6 Then
					Return 0
				EndIf
			EndIf
			
			_SendMessage($hScripts_LV, $LVM_DELETEALLITEMS)
			
			$aScriptsList_Arr = 0
			Dim $aScriptsList_Arr[1][1]
		Case $RenameCategory_MenuItem
			Local $sCurrent_Category = _GetCurrentCategory_Proc()
			Local $iIndex = @extended
			
			If $sCurrent_Category = "" Then
				Return 0
			EndIf
			
			Local $iCategoryWasGroup = _CategoryIsGroup($sCurrent_Category)
			
			Local $sNew_Category_Name = _InputBox($aTXT[$iMSG_RenameCategory], $aTXT[$iMSG_PleaseSetANewNa_ForThisCategory], _
				StringRegExpReplace($sCurrent_Category, $sGroup_RegExp, "$2"), _
				-1, 370, 180, -1, -1, 0, $hMain_GUI)
			
			If @error Or StringStripWS($sNew_Category_Name, 8) = "" Then
				Return 0
			EndIf
			
			If Not $iCategoryWasGroup And _CategoryIsGroup($sNew_Category_Name) Then
				Return __MsgBox(48, $aTXT[$iMSG_Error_1], $aTXT[$iMSG_UnableToRenameC_amedToGroup], 0, $hMain_GUI)
			EndIf
			
			If $iCategoryWasGroup Then
				$sNew_Category_Name = _GenerateGroup($sNew_Category_Name)
			EndIf
			
			Local $iRename = _IniRenameSectionEx($sScripts_DataBase_File, $sCurrent_Category, $sNew_Category_Name, 0, 1)
			
			If Not $iRename Or @error Then
				Return __MsgBox(48, $aTXT[$iMSG_Error_2], $aTXT[$iMSG_UnableToRenameT_lyAlreadyExists], 0, $hMain_GUI)
			EndIf
			
			_GUICtrlListView_SetItemText($Category_LV, $iIndex, $sNew_Category_Name)
		Case $RemoveEmptyCategories_MenuItem
			_Control_ScriptFile_Proc(14, 1)
		Case $RemoveNotExistsScripts_MenuItem
			_Control_ScriptFile_Proc(5, 1)
		Case $Create_Script_MenuItem
			ContinueCase ;Handled inside next case (@GUI_CtrlId = $Create_Script_MenuItem ...)
		Case $Add_Scripts_MenuItem
			_AddScript_Event(1) ;1 = GUI event, 2 = Tray Event
		Case $Copy_ScriptTo_MenuItem
			_Control_ScriptFile_Proc(1)
		Case $Copy_ScriptToCategory_MenuItem
			_Control_ScriptFile_Proc(11)
		Case $Run_ScriptFile_MenuItem
			_Control_ScriptFile_Proc(2)
		Case $Edit_ScriptFile_MenuItem
			_Control_ScriptFile_Proc(3)
		Case $Rename_ScriptFile_MenuItem
			_Control_ScriptFile_Proc(10)
		Case $Delete_ScriptFile_MenuItem
			_Control_ScriptFile_Proc(4)
		Case $Remove_ScriptFromList_MenuItem
			_Control_ScriptFile_Proc(5)
		Case $Open_ScriptDir_MenuItem
			_Control_ScriptFile_Proc(6)
		Case $Copy_ScriptPath_MenuItem
			_Control_ScriptFile_Proc(7)
		Case $Copy_ScriptName_MenuItem
			_Control_ScriptFile_Proc(8)
		Case $Copy_ScriptInfo_MenuItem
			_Control_ScriptFile_Proc(9)
		Case $Search_ScriptOnAutoItScriptCom_MenuItem
			_Control_ScriptFile_Proc(12)
		Case $Search_ScriptOnAutoItScriptRu_MenuItem
			_Control_ScriptFile_Proc(13)
	EndSwitch
EndFunc

Func _Tray_Events()
	Switch @TRAY_ID
		Case $ShowGUI_TrayItem
			_Restore_GUI_Event()
		Case $Create_Script_TrayItem, $Add_Scripts_TrayItem
			_AddScript_Event(2) ;1 = GUI event, 2 = Tray Event
		Case $Exit_TrayItem
			Exit
	EndSwitch
EndFunc

Func _Hide_GUI_Event()
	$aGUI_Last_Pos = WinGetPos($hMain_GUI)
	
	If $iMinimize_To_Tray = 1 Then
		GUISetState(@SW_HIDE, $hMain_GUI)
		TraySetIcon($sIcons_File, -11)
		TraySetState(1)
	Else
		GUISetState(@SW_MINIMIZE, $hMain_GUI)
	EndIf
EndFunc

Func _Restore_GUI_Event()
	TraySetState(2)
	GUISetState(@SW_SHOW, $hMain_GUI)
	GUISetState(@SW_RESTORE, $hMain_GUI)
	_WinAPI_RedrawWindow($hMain_GUI, 0, 0, BitOR($RDW_ALLCHILDREN, $RDW_INVALIDATE))
EndFunc

Func _About_GUI($hParent_GUI)
	Local $sTitle, $sScrollText, $sMainLabel, $sCopyRLabel, $sPlaySoundTxt, $nLinkColor, $nBkColor, $aHyperLinks[3] = [2]
	
	$ABOUTBOX_ScrollMovieEffect = 1 ;Number($iUse_Skin_For_GUI = 0)
	
	$sTitle = $aTXT[$iMSG_About_1]
	
	$sScrollText = "~=~=~=~=~=~=~=~=~=~\n" & $sApp_ShortTitle & "\n" & $sApp_Version & "\n~=~=~=~=~=~=~=~=~=~\n\n\n\n\n\n" & _
		"This software designed \nto collect \nAutoIt Script Files\n\n~~~~~~~~~~~~~~~~~~\nTested on: \nWin XP SP3/Win 7\n~~~~~~~~~~~~~~~~~~\n\n\n\n" & _
		"-----------\nCredits:\n-----------\n\nHolger Kotsch\n(ModernMenu.au3)\nYashied\n(Reatart.au3, WinAPIEx.au3)\nAutoIt Team\nAutoIt Community\n\n... and many others"
	
	$sMainLabel = $sApp_ShortTitle
	$sCopyRLabel = $sCopyRight_String & ". All rights reserved."
	
	$sPlaySoundTxt = $aTXT[$iMSG_PlaySound]
	
	$nLinkColor = 0x0000FF
	$nBkColor = 0xFFFFFF
	
	$aHyperLinks[0] = UBound($aHyperLinks) - 1
	$aHyperLinks[1] = "AutoIt Russian Community|http://autoit-script.ru"
	$aHyperLinks[2] = "CreatoR's Lab|http://creator-lab.ucoz.ru"
	
	;Can be Bugie
	GUIRegisterMsg($WM_WINDOWPOSCHANGING, "")
	
	_AboutBox($sTitle, $sMainLabel, $aTXT[$iMSG_Version] & @CRLF & "v" & $sApp_Version, $sScrollText, $sCopyRLabel, $sPlaySoundTxt, $aHyperLinks, $hParent_GUI, @AutoItExe, $nLinkColor, $nBkColor, 500, 300)
	
	If $iGUIStick = 1 Then
		GUIRegisterMsg($WM_WINDOWPOSCHANGING, "WM_WINDOWPOSCHANGING")
	EndIf
EndFunc

Func _Settings_GUI($hParent_GUI)
	Local $iOld_Opt_GOEM = Opt("GUIOnEventMode", 0)
	
	Local $i_Width = 600, $i_Height = 500
	Local $iFirst_CtrlID, $iLast_CtrlID
	Local $iStartAppWithWindows_CB, $iConfirmCategoryDelete_CB, $iConfirmCategoryClear_CB, $iConfirmScriptFileDelete_CB, $iConfirmScriptListRemove_CB
	Local $iRunScriptOnDoubleClick_Radio, $iEditScriptOnDoubleClick_Radio, $iScriptsEditor_Input, $iUsePlugin_CB
	Local $iCopyScriptsToDataBase_CB, $iDataBaseCopyPath_Input, $iDataBaseSelectCopyPath_Button, $iDataBaseSelectFile_Button, $iDataBaseFile_Input
	Local $iSetOnTop_CB, $iMinimizeToTray_CB, $iStartMinimized_CB, $iUseSkinForGUI_CB, $iGUIStick_CB, $iGUIStickToAll_CB, $iGUIStickRange_Input, $iGUIStickRange_UpDown
	Local $iLanguage_Combo, $iCancel_Button, $iSetDefaults_Button, $iMsg, $iState
	
	Local $iInit_UseSkinForGUI = IniRead($sConfig_File, "Window Settings", "Use Skin For GUI", 1)
	
	$hSetting_GUI = GUICreate($aTXT[$iMSG_Settings_1], $i_Width, $i_Height, -1, -1, BitOR($WS_CAPTION, $WS_POPUP, $WS_SYSMENU), -1, $hParent_GUI)
	
	GUICtrlCreateGroup($aTXT[$iMSG_General], 10, 20, $i_Width - 20, 250)
	
	$iFirst_CtrlID = GUICtrlCreateDummy() + 1
	
	$iCheckProgramUpdates_CB = GUICtrlCreateCheckbox($aTXT[$iMSG_CheckProgramUpdates], 20, 35, -1, 15)
	GUICtrlCreateLabel($aTXT[$iMSG_CheckFrequency], 20, 57)
	$iCheckFrequency_Input = GUICtrlCreateInput($iCheck_Updates_Frequency, 145, 55, 35, 20, BitOR($GUI_SS_DEFAULT_INPUT, $ES_NUMBER))
	$iCheckForUpdateNow_Bttn = GUICtrlCreateButton($aTXT[$iMSG_CheckForUpdateNow], 190, 55, 100, 20)
	
	$iStartAppWithWindows_CB = GUICtrlCreateCheckbox($aTXT[$iMSG_StartProgramWithWindows], 20, 80, -1, 15)
	$iConfirmCategoryDelete_CB = GUICtrlCreateCheckbox($aTXT[$iMSG_ConfirmWhenDele_tegorygroup], 20, 100, -1, 15)
	$iConfirmCategoryClear_CB = GUICtrlCreateCheckbox($aTXT[$iMSG_ConfirmWhenClearingCategory], 20, 120, -1, 15)
	$iConfirmScriptFileDelete_CB = GUICtrlCreateCheckbox($aTXT[$iMSG_ConfirmWhenDeletingScriptFile], 20, 140, -1, 15)
	$iConfirmScriptListRemove_CB = GUICtrlCreateCheckbox($aTXT[$iMSG_ConfirmWhenRemo_gScriptFromList], 20, 160, -1, 15)
	
	GUICtrlCreateGroup($aTXT[$iMSG_ScriptDoubleClickAction], $i_Width - 300, 30, 280, 60)
	$iRunScriptOnDoubleClick_Radio = GUICtrlCreateRadio($aTXT[$iMSG_RunTheScript], $i_Width - 290, 45, 150)
	$iEditScriptOnDoubleClick_Radio = GUICtrlCreateRadio($aTXT[$iMSG_EditTheScript], $i_Width - 290, 65, 150)
	GUICtrlCreateGroup($aTXT[$iMSG_ScriptsEditor], $i_Width - 300, 95, 280, 70)
	$iScriptsEditor_Input = GUICtrlCreateInput($sScripts_Editor, $i_Width - 290, 115, 260, 20)
	$iUsePlugin_CB = GUICtrlCreateCheckbox($aTXT[$iMSG_UseBuiltInPlugin], $i_Width - 290, 140)
	
	$iCopyScriptsToDataBase_CB = GUICtrlCreateCheckbox($aTXT[$iMSG_CopyScriptsToDataBase], 20, 180)
	GUICtrlCreateLabel($aTXT[$iMSG_ScriptsDataBasePath], 20, 205)
	$iDataBaseCopyPath_Input = GUICtrlCreateInput($sScripts_DataBase_Path, 140, 205, $i_Width - 185, 20)
	$iDataBaseSelectCopyPath_Button = GUICtrlCreateButton("...", $i_Width - 40, 205, 20, 20)
	GUICtrlCreateLabel($aTXT[$iMSG_DataBaseFile], 20, 235)
	$iDataBaseFile_Input = GUICtrlCreateInput($sScripts_DataBase_File, 110, 235, $i_Width - 155, 20)
	$iDataBaseSelectFile_Button = GUICtrlCreateButton("...", $i_Width - 40, 235, 20, 20)
	
	GUICtrlSetState($iCheckProgramUpdates_CB, _Iif($iCheck_Updates = 1, $GUI_CHECKED, $GUI_UNCHECKED))
	GUICtrlSetState($iCheckFrequency_Input, _Iif($iCheck_Updates = 1, $GUI_ENABLE, $GUI_DISABLE))
	GUICtrlSetState($iStartAppWithWindows_CB, _Iif($iStart_App_With_Windows = 1, $GUI_CHECKED, $GUI_UNCHECKED))
	GUICtrlSetState($iConfirmCategoryDelete_CB, _Iif($iConfirm_Category_Delete = 1, $GUI_CHECKED, $GUI_UNCHECKED))
	GUICtrlSetState($iConfirmCategoryClear_CB, _Iif($iConfirm_Category_Clear = 1, $GUI_CHECKED, $GUI_UNCHECKED))
	GUICtrlSetState($iConfirmScriptFileDelete_CB, _Iif($iConfirm_ScriptFile_Delete = 1, $GUI_CHECKED, $GUI_UNCHECKED))
	GUICtrlSetState($iConfirmScriptListRemove_CB, _Iif($iConfirm_ScriptList_Remove = 1, $GUI_CHECKED, $GUI_UNCHECKED))
	GUICtrlSetState($iRunScriptOnDoubleClick_Radio, _Iif($iDoubleClick_Action <> 1, $GUI_CHECKED, $GUI_UNCHECKED))
	GUICtrlSetState($iEditScriptOnDoubleClick_Radio, _Iif($iDoubleClick_Action = 1, $GUI_CHECKED, $GUI_UNCHECKED))
	GUICtrlSetState($iScriptsEditor_Input, _Iif($iUse_BuiltIn_Plugin <> 1, $GUI_ENABLE, $GUI_DISABLE))
	GUICtrlSetState($iUsePlugin_CB, _Iif($iUse_BuiltIn_Plugin = 1, $GUI_CHECKED, $GUI_UNCHECKED))
	GUICtrlSetState($iCopyScriptsToDataBase_CB, _Iif($iCopy_Scripts_To_DataBase = 1, $GUI_CHECKED, $GUI_UNCHECKED))
	GUICtrlSetState($iDataBaseCopyPath_Input, _Iif($iCopy_Scripts_To_DataBase = 1, $GUI_ENABLE, $GUI_DISABLE))
	GUICtrlSetState($iDataBaseSelectCopyPath_Button, _Iif($iCopy_Scripts_To_DataBase = 1, $GUI_ENABLE, $GUI_DISABLE))
	
	GUICtrlCreateGroup($aTXT[$iMSG_Window], 10, 280, 280, 120)
	
	$iSetOnTop_CB = GUICtrlCreateCheckbox($aTXT[$iMSG_SetOnTopOfAllWindows], 20, 295)
	$iMinimizeToTray_CB = GUICtrlCreateCheckbox($aTXT[$iMSG_MinimizeToTray], 20, 315)
	$iStartMinimized_CB = GUICtrlCreateCheckbox($aTXT[$iMSG_StartMinimized], 20, 335)
	$iUseSkinForGUI_CB = GUICtrlCreateCheckbox("* " & $aTXT[$iMSG_UseSkinForInter_werListHandling], 20, 355)
	
	GUICtrlCreateGroup($aTXT[$iMSG_StickingGUI], 300, 280, 290, 120)
	
	$iGUIStick_CB = GUICtrlCreateCheckbox($aTXT[$iMSG_StickToTheScreenEdges], 320, 295, -1, 15)
	$iGUIStickToAll_CB = GUICtrlCreateCheckbox($aTXT[$iMSG_StickToAllWindowsHighCPUUsage], 320, 313, -1, 15)
	
	GUICtrlCreateLabel($aTXT[$iMSG_StickRange], 320, 337)
	$iGUIStickRange_Input = GUICtrlCreateInput($iGUIStick_Range, 400, 335, 40, 20, BitOR($GUI_SS_DEFAULT_INPUT, $ES_READONLY))
	$iGUIStickRange_UpDown = GUICtrlCreateUpdown(-1)
	GUICtrlSetLimit(-1, 80, 5)
	
	GUICtrlSetState($iSetOnTop_CB, _Iif($iSet_OnTop = 1, $GUI_CHECKED, $GUI_UNCHECKED))
	GUICtrlSetState($iMinimizeToTray_CB, _Iif($iMinimize_To_Tray = 1, $GUI_CHECKED, $GUI_UNCHECKED))
	GUICtrlSetState($iStartMinimized_CB, _Iif($iStart_Minimized = 1, $GUI_CHECKED, $GUI_UNCHECKED))
	GUICtrlSetState($iUseSkinForGUI_CB, _Iif($iInit_UseSkinForGUI = 1, $GUI_CHECKED, $GUI_UNCHECKED))
	GUICtrlSetState($iGUIStick_CB, _Iif($iGUIStick = 1, $GUI_CHECKED, $GUI_UNCHECKED))
	GUICtrlSetState($iGUIStickToAll_CB, _Iif($iGUIStick_To_All = 1, $GUI_CHECKED, $GUI_UNCHECKED))
	
	$iState = _Iif($iGUIStick = 1, $GUI_ENABLE, $GUI_DISABLE)
	GUICtrlSetState($iGUIStickToAll_CB, $iState)
	GUICtrlSetState($iGUIStickRange_Input, $iState)
	GUICtrlSetState($iGUIStickRange_UpDown, $iState)
	
	GUICtrlCreateGroup("* " & $aTXT[$iMSG_Language], 10, 410, 280, 45)
	$iLanguage_Combo = GUICtrlCreateCombo("", 20, 425, 260, 50, BitOr($GUI_SS_DEFAULT_COMBO, $CBS_DROPDOWNLIST))
	GUICtrlSetData($iLanguage_Combo, _AppTranslation_GetLanguages($LANGS_DIR), $sApp_Language)
	
	$iLast_CtrlID = GUICtrlCreateDummy() - 1
	
	$iSettings_OK_Button = GUICtrlCreateButton($aTXT[$iMSG_OK], 20, $i_Height - 30, 60, 20, $BS_DEFPUSHBUTTON)
	GUICtrlSetState($iSettings_OK_Button, $GUI_DISABLE)
	$iCancel_Button = GUICtrlCreateButton($aTXT[$iMSG_Cancel], 100, $i_Height - 30, 60, 20)
	
	$iSetDefaults_Button = GUICtrlCreateButton($aTXT[$iMSG_SetDefaults], 190, $i_Height - 30, 100, 20)
	
	GUICtrlCreateLabel("* " & $aTXT[$iMSG_RestartRequired], $i_Width - 150, $i_Height - 25, 130)
	GUICtrlSetColor(-1, 0xFF0000)
	
	GUISetState(@SW_DISABLE, $hParent_GUI)
	GUISetState(@SW_SHOW, $hSetting_GUI)
	
	_FixSkinActivationBug_Proc($hParent_GUI, 0)
	
	While 1
		$iMsg = GUIGetMsg()
		
		Switch $iMsg
			Case $GUI_EVENT_CLOSE, $iCancel_Button
				ExitLoop
			Case $iCheckProgramUpdates_CB
				If GUICtrlRead($iCheckProgramUpdates_CB) = $GUI_CHECKED Then
					GUICtrlSetState($iCheckFrequency_Input, $GUI_ENABLE)
				Else
					GUICtrlSetState($iCheckFrequency_Input, $GUI_DISABLE)
				EndIf
				
				GUICtrlSetState($iSettings_OK_Button, $GUI_ENABLE)
			Case $iCheckForUpdateNow_Bttn
				$hUpdateWait_GUI = _UpdateWait_GUI($hSetting_GUI)
				_AppCheckUpdates($hSetting_GUI, -1, 1, $sApp_Language, $hUpdateWait_GUI) ;Check update quitly
				_CloseUpdateWaitGUI($hSetting_GUI, $hUpdateWait_GUI)
			Case $iUsePlugin_CB
				If GUICtrlRead($iUsePlugin_CB) = $GUI_CHECKED Then
					GUICtrlSetState($iScriptsEditor_Input, $GUI_DISABLE)
				Else
					GUICtrlSetState($iScriptsEditor_Input, $GUI_ENABLE)
				EndIf
				
				GUICtrlSetState($iSettings_OK_Button, $GUI_ENABLE)
			Case $iGUIStick_CB
				$iState = _Iif(GUICtrlRead($iGUIStick_CB) = $GUI_CHECKED, $GUI_ENABLE, $GUI_DISABLE)
				GUICtrlSetState($iGUIStickToAll_CB, $iState)
				GUICtrlSetState($iGUIStickRange_Input, $iState)
				GUICtrlSetState($iGUIStickRange_UpDown, $iState)
				
				GUICtrlSetState($iSettings_OK_Button, $GUI_ENABLE)
			Case $iCopyScriptsToDataBase_CB
				$iState = _Iif(GUICtrlRead($iCopyScriptsToDataBase_CB) = $GUI_CHECKED, $GUI_ENABLE, $GUI_DISABLE)
				
				GUICtrlSetState($iDataBaseCopyPath_Input, $iState)
				GUICtrlSetState($iDataBaseSelectCopyPath_Button, $iState)
				
				GUICtrlSetState($iSettings_OK_Button, $GUI_ENABLE)
			Case $iDataBaseSelectCopyPath_Button
				Local $sDataBase_Path = __FileSelectFolder($aTXT[$iMSG_SelectScriptsDataBasePath], "", 3, GUICtrlRead($iDataBaseCopyPath_Input), $hSetting_GUI)
				
				If Not @error Then
					GUICtrlSetData($iDataBaseCopyPath_Input, $sDataBase_Path)
				EndIf
				
				GUICtrlSetState($iSettings_OK_Button, $GUI_ENABLE)
			Case $iDataBaseSelectFile_Button
				Local $sDataBase_File = GUICtrlRead($iDataBaseFile_Input)
				Local $sFilePath = StringRegExpReplace($sDataBase_File, "\\[^\\]*$", "")
				Local $sFileName = StringRegExpReplace($sDataBase_File, "^.*\\", "")
				
				$sDataBase_File = __FileSaveDialog($aTXT[$iMSG_OpenDataBaseFile], $sFilePath, "DataBase Files (*.db)|All Files (*.*)", 2, $sFileName, $hSetting_GUI)
				
				If Not @error Then
					GUICtrlSetData($iDataBaseFile_Input, $sDataBase_File)
				EndIf
				
				GUICtrlSetState($iSettings_OK_Button, $GUI_ENABLE)
			Case $iFirst_CtrlID To $iLast_CtrlID
				If _WinAPI_GetClassName(GUICtrlGetHandle($iMsg)) <> 'Static' Then
					GUICtrlSetState($iSettings_OK_Button, $GUI_ENABLE)
				EndIf
			Case $iSetDefaults_Button
				If __MsgBox(52, $aTXT[$iMSG_Attention], $aTXT[$iMSG_RestoreDefaultSettings], 0, $hSetting_GUI) = 6 Then
					GUICtrlSetState($iCheckProgramUpdates_CB, _Iif($iDef_Check_Updates = 1, $GUI_CHECKED, $GUI_UNCHECKED))
					GUICtrlSetState($iStartAppWithWindows_CB, _Iif($iDef_Start_App_With_Windows = 1, $GUI_CHECKED, $GUI_UNCHECKED))
					GUICtrlSetState($iConfirmCategoryDelete_CB, _Iif($iDef_Confirm_Category_Delete = 1, $GUI_CHECKED, $GUI_UNCHECKED))
					GUICtrlSetState($iConfirmCategoryClear_CB, _Iif($iDef_Confirm_Category_Clear = 1, $GUI_CHECKED, $GUI_UNCHECKED))
					GUICtrlSetState($iConfirmScriptFileDelete_CB, _Iif($iDef_Confirm_ScriptFile_Delete = 1, $GUI_CHECKED, $GUI_UNCHECKED))
					GUICtrlSetState($iConfirmScriptListRemove_CB, _Iif($iDef_Confirm_ScriptList_Remove = 1, $GUI_CHECKED, $GUI_UNCHECKED))
					GUICtrlSetState($iRunScriptOnDoubleClick_Radio, _Iif($iDef_DoubleClick_Action <> 1, $GUI_CHECKED, $GUI_UNCHECKED))
					GUICtrlSetState($iEditScriptOnDoubleClick_Radio, _Iif($iDef_DoubleClick_Action = 1, $GUI_CHECKED, $GUI_UNCHECKED))
					GUICtrlSetState($iScriptsEditor_Input, _Iif($iDef_Use_BuiltIn_Plugin <> 1, $GUI_ENABLE, $GUI_DISABLE))
					GUICtrlSetState($iUsePlugin_CB, _Iif($iDef_Use_BuiltIn_Plugin = 1, $GUI_CHECKED, $GUI_UNCHECKED))
					GUICtrlSetState($iCopyScriptsToDataBase_CB, _Iif($iDef_Copy_Scripts_To_DataBase = 1, $GUI_CHECKED, $GUI_UNCHECKED))
					GUICtrlSetState($iDataBaseCopyPath_Input, _Iif($iDef_Copy_Scripts_To_DataBase = 1, $GUI_ENABLE, $GUI_DISABLE))
					GUICtrlSetState($iDataBaseSelectCopyPath_Button, _Iif($iDef_Copy_Scripts_To_DataBase = 1, $GUI_ENABLE, $GUI_DISABLE))
					
					GUICtrlSetState($iSetOnTop_CB, _Iif($iDef_Set_OnTop = 1, $GUI_CHECKED, $GUI_UNCHECKED))
					GUICtrlSetState($iMinimizeToTray_CB, _Iif($iDef_Minimize_To_Tray = 1, $GUI_CHECKED, $GUI_UNCHECKED))
					GUICtrlSetState($iStartMinimized_CB, _Iif($iDef_Start_Minimized = 1, $GUI_CHECKED, $GUI_UNCHECKED))
					GUICtrlSetState($iUseSkinForGUI_CB, _Iif($iDef_Use_Skin_For_GUI = 1, $GUI_CHECKED, $GUI_UNCHECKED))
					GUICtrlSetState($iGUIStick_CB, _Iif($iDef_GUIStick = 1, $GUI_CHECKED, $GUI_UNCHECKED))
					GUICtrlSetState($iGUIStickToAll_CB, _Iif($iDef_GUIStick_To_All = 1, $GUI_CHECKED, $GUI_UNCHECKED))
					
					$iState = _Iif($iDef_GUIStick = 1, $GUI_ENABLE, $GUI_DISABLE)
					GUICtrlSetState($iGUIStickToAll_CB, $iState)
					GUICtrlSetState($iGUIStickRange_Input, $iState)
					GUICtrlSetState($iGUIStickRange_UpDown, $iState)
					
					GUICtrlSetData($iCheckFrequency_Input, $iDef_Check_Updates_Frequency)
					GUICtrlSetData($iScriptsEditor_Input, $sDef_Scripts_Editor)
					GUICtrlSetData($iDataBaseCopyPath_Input, $sDef_Scripts_DataBase_Path)
					GUICtrlSetData($iDataBaseFile_Input, $sDef_Scripts_DataBase_File)
					GUICtrlSetData($iGUIStickRange_Input, $iDef_GUIStick_Range)
					GUICtrlSetData($iLanguage_Combo, "")
					GUICtrlSetData($iLanguage_Combo, _AppTranslation_GetLanguages($LANGS_DIR), $sDef_App_Language)
					
					ContinueCase
				EndIf
			Case $iSettings_OK_Button
				;Read settings
				$iCheck_Updates = Number(GUICtrlRead($iCheckProgramUpdates_CB) = $GUI_CHECKED)
				$iCheck_Updates_Frequency = GUICtrlRead($iCheckFrequency_Input)
				$iStart_App_With_Windows = Number(GUICtrlRead($iStartAppWithWindows_CB) = $GUI_CHECKED)
				$iConfirm_Category_Delete = Number(GUICtrlRead($iConfirmCategoryDelete_CB) = $GUI_CHECKED)
				$iConfirm_Category_Clear = Number(GUICtrlRead($iConfirmCategoryClear_CB) = $GUI_CHECKED)
				$iConfirm_ScriptFile_Delete = Number(GUICtrlRead($iConfirmScriptFileDelete_CB) = $GUI_CHECKED)
				$iConfirm_ScriptList_Remove = Number(GUICtrlRead($iConfirmScriptListRemove_CB) = $GUI_CHECKED)
				$iCopy_Scripts_To_DataBase = Number(GUICtrlRead($iCopyScriptsToDataBase_CB) = $GUI_CHECKED)
				$iSet_OnTop = Number(GUICtrlRead($iSetOnTop_CB) = $GUI_CHECKED)
				$iMinimize_To_Tray = Number(GUICtrlRead($iMinimizeToTray_CB) = $GUI_CHECKED)
				$iStart_Minimized = Number(GUICtrlRead($iStartMinimized_CB) = $GUI_CHECKED)
				$iGUIStick = Number(GUICtrlRead($iGUIStick_CB) = $GUI_CHECKED)
				$iGUIStick_To_All = Number(GUICtrlRead($iGUIStickToAll_CB) = $GUI_CHECKED)
				$iGUIStick_Range = Number(GUICtrlRead($iGUIStickRange_Input))
				$iDoubleClick_Action = Number(GUICtrlRead($iEditScriptOnDoubleClick_Radio) = $GUI_CHECKED)
				$iUse_BuiltIn_Plugin = Number(GUICtrlRead($iUsePlugin_CB) = $GUI_CHECKED)
				$sScripts_Editor = GUICtrlRead($iScriptsEditor_Input)
				$sScripts_DataBase_Path = GUICtrlRead($iDataBaseCopyPath_Input)
				
				Local $iTmp_UseSkinForGUI = Number(GUICtrlRead($iUseSkinForGUI_CB) = $GUI_CHECKED)
				Local $sTmp_DataBaseFile = GUICtrlRead($iDataBaseFile_Input)
				Local $sTmp_AppLanguage = GUICtrlRead($iLanguage_Combo)
				
				Local $iRestart = ($iTmp_UseSkinForGUI <> $iInit_UseSkinForGUI) Or ($sApp_Language <> $sTmp_AppLanguage)
				
				If $iUse_BuiltIn_Plugin <> 1 And $sScripts_Editor = "Editor_Plugin" Then
					$sScripts_Editor = ""
				EndIf
				
				If $iUse_BuiltIn_Plugin = 1 Then
					$sScripts_Editor = "Editor_Plugin"
				ElseIf $sScripts_Editor = "" Then
					$sScripts_Editor = "Default"
				EndIf
				
				;Set settings
				WinSetOnTop($hMain_GUI, "", $iSet_OnTop)
				
				If $iStart_App_With_Windows = 1 Then
					RegWrite("HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Run", $sApp_ShortTitle, "REG_SZ", _Iif(@Compiled, @ScriptFullPath, @AutoItExe & ' "' & @ScriptFullPath & '"'))
				Else
					RegDelete("HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Run", $sApp_ShortTitle)
				EndIf
				
				If $iGUIStick = 1 Then
					GUIRegisterMsg($WM_WINDOWPOSCHANGING, "WM_WINDOWPOSCHANGING")
				Else
					GUIRegisterMsg($WM_WINDOWPOSCHANGING, "")
				EndIf
				
				If $iDoubleClick_Action = 1 Then
					GUICtrlSetState($Edit_ScriptFile_MenuItem, $GUI_DEFBUTTON)
				Else
					GUICtrlSetState($Run_ScriptFile_MenuItem, $GUI_DEFBUTTON)
				EndIf
				
				_GUICtrlODMenuItemSetText($RemoveCategory_MenuItem, $aTXT[$iMSG_Remove_3] & _Iif($iConfirm_Category_Delete = 1, "...", ""))
				_GUICtrlODMenuItemSetText($ClearCategory_MenuItem, $aTXT[$iMSG_Clear_3] & _Iif($iConfirm_Category_Clear = 1, "...", ""))
				_GUICtrlODMenuItemSetText($Delete_ScriptFile_MenuItem, $aTXT[$iMSG_DeleteScriptFile_1] & _Iif($iConfirm_ScriptFile_Delete = 1, "...", "") & @TAB & $sDelScriptFile_HK)
				_GUICtrlODMenuItemSetText($Remove_ScriptFromList_MenuItem, $aTXT[$iMSG_RemoveScriptFromList_1] & _Iif($iConfirm_ScriptList_Remove = 1, "...", "") & @TAB & $sRemoveScriptFromList_HK)
				
				If $sTmp_DataBaseFile <> $sScripts_DataBase_File Then
					$sScripts_DataBase_File = $sTmp_DataBaseFile
					_Set_CategoryList_Proc()
				EndIf
				
				;Write settings
				IniWrite($sConfig_File, "Main Settings", "Check Updates", $iCheck_Updates)
				IniWrite($sConfig_File, "Main Settings", "Check Updates Frequency", $iCheck_Updates_Frequency)
				IniWrite($sConfig_File, "Main Settings", "Check Updates Timer Init", TimerInit())
				
				IniWrite($sConfig_File, "Main Settings", "Start With Windows", $iStart_App_With_Windows)
				IniWrite($sConfig_File, "Main Settings", "Confirm Category Delete", $iConfirm_Category_Delete)
				IniWrite($sConfig_File, "Main Settings", "Confirm Category Clear", $iConfirm_Category_Clear)
				IniWrite($sConfig_File, "Main Settings", "Confirm Script File Delete", $iConfirm_ScriptFile_Delete)
				IniWrite($sConfig_File, "Main Settings", "Confirm Script List Remove", $iConfirm_ScriptList_Remove)
				IniWrite($sConfig_File, "Main Settings", "Copy Scripts To DataBase", $iCopy_Scripts_To_DataBase)
				IniWrite($sConfig_File, "Main Settings", "Scripts DataBase Path", $sScripts_DataBase_Path)
				IniWrite($sConfig_File, "Main Settings", "DataBase File", $sScripts_DataBase_File)
				IniWrite($sConfig_File, "Main Settings", "Double Click Action", $iDoubleClick_Action)
				IniWrite($sConfig_File, "Main Settings", "Use Built-In Plugin As Editor", $iUse_BuiltIn_Plugin)
				IniWrite($sConfig_File, "Main Settings", "Script Editor", $sScripts_Editor)
				
				IniWrite($sConfig_File, "Window Settings", "Set On Top", $iSet_OnTop)
				IniWrite($sConfig_File, "Window Settings", "Minimize To Tray", $iMinimize_To_Tray)
				IniWrite($sConfig_File, "Window Settings", "Start Minimized", $iStart_Minimized)
				IniWrite($sConfig_File, "Window Settings", "Use Skin For GUI", $iTmp_UseSkinForGUI)
				IniWrite($sConfig_File, "Window Settings", "GUI Stick", $iGUIStick)
				IniWrite($sConfig_File, "Window Settings", "GUI Stick To All", $iGUIStick_To_All)
				IniWrite($sConfig_File, "Window Settings", "GUI Stick Range", $iGUIStick_Range)
				
				IniWrite($sConfig_File, "Main Settings", "Language", $sTmp_AppLanguage)
				
				If $iRestart And __MsgBox(52, $aTXT[$iMSG_Attention], $aTXT[$iMSG_ProgramRestartRequired], 0, $hSetting_GUI) = 6 Then
					_ScriptRestart()
				EndIf
				
				$sApp_Language = $sTmp_AppLanguage
				$aTXT = _AppTranslation_Register($LANGS_DIR & "\" & $sApp_Language & ".lng")
				
				ExitLoop
		EndSwitch
	WEnd
	
	GUISetState(@SW_ENABLE, $hParent_GUI)
	GUIDelete($hSetting_GUI)
	Opt("GUIOnEventMode", $iOld_Opt_GOEM)
EndFunc

Func _UpdateWait_GUI($hParent_GUI)
	GUISetState(@SW_DISABLE, $hParent_GUI)
	
	$hUpdateWait_GUI = GUICreate($aTXT[$iMSG_UpdateCheck], 430, 100, -1, -1, BitOR($WS_POPUP, $WS_BORDER), BitOR($WS_EX_TOPMOST, $WS_EX_CLIENTEDGE), $hParent_GUI)
	GUICtrlCreateLabel($aTXT[$iMSG_PleaseWaitCheckingForUpdate], 0, 0, 430, 100, BitOR($SS_CENTER, $SS_CENTERIMAGE))
	GUICtrlSetFont(-1, 12, 800)
	GUISetState(@SW_SHOW, $hUpdateWait_GUI)
	
	_FixSkinActivationBug_Proc($hUpdateWait_GUI, 0)
	
	Return $hUpdateWait_GUI
EndFunc

Func _CloseUpdateWaitGUI($hParent_GUI, $hUpdateWait_GUI)
	GUISetState(@SW_ENABLE, $hParent_GUI)
	GUIDelete($hUpdateWait_GUI)
	GUISwitch($hParent_GUI)
EndFunc

Func _Control_ScriptFile_Proc($iControl_Mode, $iFlag = 0) ;$iFlag = 0 is the default behaviour, otherwise we handle it differently
	If $iFlag = 0 Then
		Local $aSelected_Indices = _GUICtrlListView_GetSelectedIndices($Scripts_LV, 1)
		
		If Not IsArray($aSelected_Indices) Or $aSelected_Indices[0] = 0 Then
			Return 0
		EndIf
		
		Local $iSelected_Index = $aSelected_Indices[1]
		
		Local $sScript_FilePath = _GUICtrlListView_GetItemText($Scripts_LV, $iSelected_Index, $iSL_FilePath)
		Local $sScript_DirPath = StringRegExpReplace($sScript_FilePath, "\\[^\\]*$", "")
		Local $sScript_FileName = StringRegExpReplace($sScript_FilePath, "^.*\\", "")
		Local $sScriptName = StringRegExpReplace($sScript_FileName, "\.[^\.]*$", "")
		Local $iAsk = 0, $iCopy_Flag = 0, $iFileCopy, $sFailedToCopyFiles = ""
		
		If StringRegExp($iControl_Mode, "^[^(1|5|7|8|9)]$") And Not FileExists($sScript_FilePath) Then
			Return __MsgBox(48, $aTXT[$iMSG_Error_3], StringFormat($aTXT[$iMSG_ThisScriptSDoesNotExists], $sScript_FileName), 0, $hMain_GUI)
		EndIf
	EndIf
	
	Switch $iControl_Mode
		Case 1 ;Copy script to...
			Local $sDest_Copy_Dir = __FileSelectFolder($aTXT[$iMSG_PleaseSelectDestinationFolder], "", 3, "", $hMain_GUI)
			
			If @error Then
				Return 0
			EndIf
			
			For $i = 1 To $aSelected_Indices[0]
				$sScript_FilePath = _GUICtrlListView_GetItemText($Scripts_LV, $aSelected_Indices[$i], $iSL_FilePath)
				$sScript_FileName = StringRegExpReplace($sScript_FilePath, "^.*\\", "")
				
				If $iAsk <> 12 And $iAsk <> 14 And FileExists($sDest_Copy_Dir & "\" & $sScript_FileName) Then
					$iAsk = _MsgBox_Copy_Proc($hMain_GUI, $aTXT[$iMSG_Attention_2], _
						StringFormat($aTXT[$iMSG_ThisFileSAlread_FolderReplaceIt], $sScript_FileName), $COPYANI)
					
					If $iAsk = 7 Then
						ContinueLoop
					EndIf
					
					If $iAsk = 2 Then
						ExitLoop
					EndIf
					
					If $iAsk = 14 Then
						$iCopy_Flag = 0
					ElseIf $iAsk = 6 Or $iAsk = 12 Then
						$iCopy_Flag = 1
					EndIf
				EndIf
				
				$iFileCopy = FileCopy($sScript_FilePath, $sDest_Copy_Dir & "\" & $sScript_FileName, $iCopy_Flag)
				
				If Not $iFileCopy And $iAsk <> 7 And $iAsk <> 14 Then
					$sFailedToCopyFiles &= $sScript_FileName & @CRLF
				EndIf
			Next
			
			If $iAsk <> 2 And $sFailedToCopyFiles <> "" Then
				__MsgBox(48, $aTXT[$iMSG_Error_4], StringFormat($aTXT[$iMSG_ThereWasAnError_TheseScriptsnns], $sFailedToCopyFiles), 0, $hMain_GUI)
			EndIf
		Case 2 ;Run script
			Run(@AutoItExe & ' "' & $sScript_FilePath & '"')
		Case 3 ;Edit script
			If $iUse_BuiltIn_Plugin = 1 Then
				If Plugin_Active($sScripts_Editor) Then
					Plugin_Call_Proc($sScripts_Editor, '"' & $sScript_FilePath & '"')
				EndIf
			Else
				If $sScripts_Editor = "Default" Then
					ShellExecute($sScript_FilePath, "", "", "Edit")
				Else
					Run($sScripts_Editor & ' "' & $sScript_FilePath & '"')
				EndIf
			EndIf
		Case 4 ;Delete Script File(s)
			If $iConfirm_ScriptFile_Delete = 1 Then
				$iAsk = _MsgBoxEx(256+48, 2, $aTXT[$iMSG_Attention_3], _
					StringFormat($aTXT[$iMSG_AreYouSureDelet_etedPermanently]), 330, 120, $aTXT[$iMSG_DoNotAskMeAgain_2], 10, $hMain_GUI, $aTXT[$iMSG_Yes_2], $aTXT[$iMSG_No_2])
				
				Local $iAsk_Ret = BitAND($iAsk, 8)
				Local $iAsk_Calc = $iAsk - $iAsk_Ret
				
				If $iAsk_Ret = 8 Then
					$iConfirm_ScriptFile_Delete = 0
					_GUICtrlODMenuItemSetText($Delete_ScriptFile_MenuItem, $aTXT[$iMSG_DeleteScriptFile_2] & @TAB & $sDelScriptFile_HK)
					IniWrite($sConfig_File, "Main Settings", "Confirm Script File Delete", 0)
				EndIf
				
				If $iAsk_Calc <> 6 Then
					Return
				EndIf
			EndIf
			
			For $i = 1 To $aSelected_Indices[0]
				$sScript_FilePath = _GUICtrlListView_GetItemText($Scripts_LV, $aSelected_Indices[$i], $iSL_FilePath)
				FileDelete($sScript_FilePath)
			Next
			
			ContinueCase
		Case 5 ;Remove Script(s) From List - uses $iFlag = 1
			If $iFlag = 0 And $iControl_Mode = 5 And $iConfirm_ScriptList_Remove = 1 Then
				$iAsk = _MsgBoxEx(256+48, 2, $aTXT[$iMSG_Attention_4], $aTXT[$iMSG_AreYouSureRemov_riptFromTheList], _
					330, 120, $aTXT[$iMSG_RemoveWithoutAskingNextTime], 15, $hMain_GUI, $aTXT[$iMSG_Yes_3], $aTXT[$iMSG_No_3])
				
				Local $iAsk_Ret = BitAND($iAsk, 8)
				Local $iAsk_Calc = $iAsk - $iAsk_Ret
				
				If $iAsk_Ret = 8 Then
					$iConfirm_ScriptList_Remove = 0
					_GUICtrlODMenuItemSetText($Remove_ScriptFromList_MenuItem, $aTXT[$iMSG_RemoveScriptFromList_2] & @TAB & $sRemoveScriptFromList_HK)
					IniWrite($sConfig_File, "Main Settings", "Confirm Script List Remove", 0)
				EndIf
				
				If $iAsk_Calc <> 6 Then
					Return
				EndIf
			EndIf
			
			_GUICtrlListView_SetItemsFilter($Scripts_LV, $aScriptsList_Arr, $iSL_FileName, -1)
			
			Local $iTotal_Items = _GUICtrlListView_GetItemCount($Scripts_LV)
			
			;If $iFlag = 1, we just remove not existing scripts from the list
			If $iFlag = 1 Then
				For $i = $iTotal_Items - 1 To 0 Step -1
					$sScript_FilePath = _GUICtrlListView_GetItemText($Scripts_LV, $i, $iSL_FilePath)
					
					If Not FileExists($sScript_FilePath) Then
						_GUICtrlListView_DeleteItem($Scripts_LV, $i)
					EndIf
				Next
			Else
				_GUICtrlListView_DeleteItemsSelected($hScripts_LV)
			EndIf
			
			For $i = 0 To $iTotal_Items - 1
				_GUICtrlListView_SetItemText($Scripts_LV, $i, $i+1, $iSL_FileName)
			Next
			
			Local $aScriptsList_Tmp[$aScriptsList_Arr[0][0]+1][$iSL_Total+1]
			Local $iScript_Found = 0
			
			For $i = 0 To $iTotal_Items - 1
				$iScript_Found = 0
				
				For $j = 1 To $aScriptsList_Arr[0][0]
					If $aScriptsList_Arr[$j][$iSL_FilePath] = _GUICtrlListView_GetItemText($Scripts_LV, $i, $iSL_FilePath) Then
						$aScriptsList_Tmp[0][0] += 1
						
						For $x = 1 To $iSL_Total
							$aScriptsList_Tmp[$aScriptsList_Tmp[0][0]][$x] = $aScriptsList_Arr[$j][$x]
						Next
						
						ExitLoop
					EndIf
				Next
			Next
			
			ReDim $aScriptsList_Tmp[$aScriptsList_Tmp[0][0]+1][$iSL_Total+1]
			$aScriptsList_Arr = $aScriptsList_Tmp
			
			_SetDataBaseScripts_Proc()
			_GUICtrlListView_SortByFilter_Proc($Scripts_LV)
		Case 6 ;Open script's dir
			Run('Explorer.exe /select,"' & $sScript_FilePath & '"')
		Case 7 ;Copy script(s) full path
			$sScript_FilePath = ""
			
			For $i = 1 To $aSelected_Indices[0]
				$sScript_FilePath &= _GUICtrlListView_GetItemText($Scripts_LV, $aSelected_Indices[$i], $iSL_FilePath) & @CRLF
			Next
			
			ClipPut(StringStripWS($sScript_FilePath, 3))
		Case 8 ;Copy script(s) file name
			$sScript_FileName = ""
			
			For $i = 1 To $aSelected_Indices[0]
				$sScript_FilePath = _GUICtrlListView_GetItemText($Scripts_LV, $aSelected_Indices[$i], $iSL_FilePath)
				
				$sScript_FileName &= StringRegExpReplace($sScript_FilePath, "^.*\\", "") & @CRLF
			Next
			
			ClipPut(StringStripWS($sScript_FileName, 3))
		Case 9 ;Copy script(s) info
			Local $sScript_Info, $iScript_Size, $iScript_Mod
			
			For $i = 1 To $aSelected_Indices[0]
				$iScript_Size = _GUICtrlListView_GetItemText($Scripts_LV, $aSelected_Indices[$i], $iSL_FileSize)
				$iScript_Mod = _GUICtrlListView_GetItemText($Scripts_LV, $aSelected_Indices[$i], $iSL_FileTime)
				$sScript_FilePath = _GUICtrlListView_GetItemText($Scripts_LV, $aSelected_Indices[$i], $iSL_FilePath)
				$sScript_FileName = StringRegExpReplace($sScript_FilePath, "^.*\\", "")
				
				$sScript_Info &= StringFormat( _
					$aTXT[$iMSG_ScriptIInfoRn] & _
					$aTXT[$iMSG_ScriptNameSrnSc_riptModifiedSrn] & _
					$aTXT[$iMSG_Rnrn], _
					$i, $sScript_FileName, $sScript_FilePath, $iScript_Size, $iScript_Mod)
			Next
			
			ClipPut(StringStripWS($sScript_Info, 3))
		Case 10 ;Rename script
			Local $sNew_ScriptName, $sNew_ScriptFile
			
			While 1
				$sNew_ScriptName = _InputBox($aTXT[$iMSG_RenameScript_1], $aTXT[$iMSG_TypeNewNameForTheScript], $sScriptName, -1, 370, 180, -1, -1, 0, $hMain_GUI)
				
				If @error Then
					Return 0
				EndIf
				
				$sNew_ScriptFile = $sScript_DirPath & "\" & $sNew_ScriptName & ".au3"
				$sScriptName = $sNew_ScriptName
				
				If FileExists($sNew_ScriptFile) Then
					__MsgBox(48, $aTXT[$iMSG_Error_5], StringFormat($aTXT[$iMSG_ThisScriptSau3AlreadyExists], $sNew_ScriptName), 0, $hMain_GUI)
					ContinueLoop
				ElseIf Not FileMove($sScript_FilePath, $sNew_ScriptFile) Then
					__MsgBox(48, $aTXT[$iMSG_Error_6], StringFormat($aTXT[$iMSG_ThereWasAnError_meTheScriptSau3], $sNew_ScriptName), 0, $hMain_GUI)
				Else
					_GUICtrlListView_SetItemText($Scripts_LV, $iSelected_Index, $sNew_ScriptName & ".au3", $iSL_FileName)
					_GUICtrlListView_SetItemText($Scripts_LV, $iSelected_Index, $sNew_ScriptFile, $iSL_FilePath)
				EndIf
				
				ExitLoop
			WEnd
		Case 11 ;Copy script to other category
			Local $aCategories = _IniReadSectionNamesEx($sScripts_DataBase_File)
			
			If @error Then
				Return
			EndIf
			
			;Remove the current category from the complete categories list
			Local $aTmp[$aCategories[0]+1]
			For $i = 1 To $aCategories[0]
				If $aCategories[$i] <> $sCurrent_Category And Not _CategoryIsGroup($aCategories[$i]) Then
					$aTmp[0] += 1
					$aTmp[$aTmp[0]] = $aCategories[$i]
				EndIf
			Next
			ReDim $aTmp[$aTmp[0]+1]
			
			If $aTmp[0] < 1 Then
				Return __MsgBox(48, $aTXT[$iMSG_Error_7], $aTXT[$iMSG_UnableToCopyThe_OnlyOneCategory], 0, $hMain_GUI)
			EndIf
			
			Local $sSelected_Category = _SelectBox($aTmp, $aTXT[$iMSG_SelectCategory], $aTXT[$iMSG_SelectCategoryFromTheList], 0, $hMain_GUI)
			
			If @error Then
				Return
			EndIf
			
			For $i = 1 To $aSelected_Indices[0]
				$sScript_FilePath = _GUICtrlListView_GetItemText($Scripts_LV, $aSelected_Indices[$i], $iSL_FilePath)
				_AddScriptToDataBase_Proc($sSelected_Category, $sScript_FilePath)
			Next
		Case 12 ;Search script on autoitscript.com
			ShellExecute("http://autoitscript.com/forum/index.php?app=core&module=search&do=quick_search&search_author=&search_term=" & $sScriptName)
		Case 13 ;Search script on autoit-script.ru
			ShellExecute("http://autoit-script.ru/index.php?action=search2&search=" & $sScriptName)
		Case 14 ;Remove empty categories
			Local $iTotal_Items = _GUICtrlListView_GetItemCount($Category_LV)
			
			For $i = $iTotal_Items-1 To 0 Step -1
				$sCategory = _GUICtrlListView_GetItemText($Category_LV, $i)
				
				If Not _CategoryIsGroup($sCategory) And _IniSectionIsEmpty($sScripts_DataBase_File, $sCategory) Then
					_GUICtrlListView_DeleteItem($Category_LV, $i)
					IniDelete($sScripts_DataBase_File, $sCategory)
				EndIf
			Next
	EndSwitch
EndFunc

Func _CategoryItem_Event()
	$iCategory_Changed = True
EndFunc

Func _Set_CategoryList_Proc()
	_GUICtrlListView_SetColumnWidthEx($Category_LV, "0,200")
	
	_SendMessage($hCategory_LV, $LVM_DELETEALLITEMS)
	_SendMessage($hScripts_LV, $LVM_DELETEALLITEMS)
	
	$aScriptsList_Arr = 0
	Dim $aScriptsList_Arr[1][1]
	
	Local $aCategories = _IniReadSectionNamesEx($sScripts_DataBase_File)
	If @error Then Return SetError(1, 0, 0)
	
	For $i = 1 To $aCategories[0]
		GUICtrlCreateListViewItem($aCategories[$i], $Category_LV)
		GUICtrlSetOnEvent(-1, "_CategoryItem_Event")
	Next
EndFunc

Func _Set_ScriptsList_Proc($sCategory, $iChange_ScriptsArr = 1)
	Local $aScriptsList = IniReadSection($sScripts_DataBase_File, $sCategory)
	Local $iError = @error
	
	If $iChange_ScriptsArr Then
		$aScriptsList_Arr = 0
		Dim $aScriptsList_Arr[1][1]
	EndIf
	
	If $iError Then
		Return SetError(1, 0, 0)
	EndIf
	
	_AddScriptsToList_Proc($aScriptsList, $iChange_ScriptsArr)
EndFunc

Func _SetDataBaseCategories_Proc()
	Local $sCurrent_Category
	Local $aSection_Names = _IniReadSectionNamesEx($sScripts_DataBase_File)
	
	If @error Then
		Return SetError(1, 0, 0)
	EndIf
	
	For $i = 0 To _GUICtrlListView_GetItemCount($Category_LV)-1
		$sCurrent_Category = _GUICtrlListView_GetItemText($Category_LV, $i)
		
		For $j = 1 To $aSection_Names[0]
			If $aSection_Names[$j] == $sCurrent_Category Then
				IniWriteSection($sScripts_DataBase_File & ".tmp", $sCurrent_Category, IniReadSection($sScripts_DataBase_File, $sCurrent_Category))
				
				If @error Then
					FileWriteLine($sScripts_DataBase_File & ".tmp", "[" & $sCurrent_Category & "]" & @CRLF)
				EndIf
				
				ExitLoop
			EndIf
		Next
	Next
	
	FileMove($sScripts_DataBase_File & ".tmp", $sScripts_DataBase_File, 1)
EndFunc

Func _SetDataBaseScripts_Proc()
	Local $sCurrent_Category = _GetCurrentCategory_Proc()
	
	If $sCurrent_Category = "" Then
		Return SetError(1, 0, 0)
	EndIf
	
	IniDelete($sScripts_DataBase_File, $sCurrent_Category)
	
	Local $sScript_FilePath
	
	For $i = 0 To _GUICtrlListView_GetItemCount($Scripts_LV)-1
		$sScript_FilePath = _GUICtrlListView_GetItemText($Scripts_LV, $i, $iSL_FilePath)
		IniWrite($sScripts_DataBase_File, $sCurrent_Category, "Script " & $i+1, $sScript_FilePath)
	Next
	
	_SetDataBaseCategories_Proc()
EndFunc

Func _AddScript_Event($iEvent_Type) ;$iEvent_Type = 1 - GUI event, 2 - Tray Event
	Local $bCreate_Script
	
	If $iEvent_Type = 1 Then
		$bCreate_Script = (@GUI_CtrlId = $Create_Script_MenuItem)
	Else
		$bCreate_Script = (@TRAY_ID = $Create_Script_TrayItem)
		_Restore_GUI_Event()
	EndIf
	
	Local $sCurrent_Category = _GetCurrentCategory_Proc()
	Local $iIndex = @extended
	Local $sMsg = _Iif($bCreate_Script, $aTXT[$iMSG_CreateScript_2], $aTXT[$iMSG_AddScripts_1])
	
	If $sCurrent_Category = "" Then
		Return __MsgBox(48, $aTXT[$iMSG_Attention_8], $aTXT[$iMSG_CanNot] & " " & $sMsg & $aTXT[$iMSG_PleaseSelectCategoryFromList], 0, $hMain_GUI)
	EndIf
	
	If _CategoryIsGroup($sCurrent_Category) Then
		Return __MsgBox(48, $aTXT[$iMSG_Attention_9], $aTXT[$iMSG_CanNot_1] & " " & $sMsg & $aTXT[$iMSG_CurrentItemInCa_istIsAGroup], 0, $hMain_GUI)
	EndIf
	
	If $bCreate_Script Then
		If $iCopy_Scripts_To_DataBase = 1 Then
			Local $sScript_FilePath = $sScripts_DataBase_Path & "\" & _FileGetValidName($sCurrent_Category) & "\AutoIt3 Script.au3"
		Else
			Local $sScript_FilePath = FileSaveDialog($aTXT[$iMSG_SaveScript], "", "AutoIt v3 Scripts (*.au3)", 18, "AutoIt3 Script.au3", $hMain_GUI)
			
			If @error Then
				If $iEvent_Type = 2 Then _Hide_GUI_Event()
				Return 0
			EndIf
		EndIf
		
		If Not FileExists($sScript_FilePath) Then
			Local $sClipbrd = ClipGet()
			Local $hFile = FileOpen($sScript_FilePath, 2)
			FileWrite($hFile, _Iif(StringRegExp($sClipbrd, "(?i)(#include|#NoTrayIcon|#(End)?Region|Opt\(.*\)|If\h*.*Then|\$\w+\h*=|Func .*?\(.*?\))"), $sClipbrd, ""))
			FileClose($hFile)
		EndIf
		
		Local $aSelected_Scripts[2] = [1, $sScript_FilePath]
	Else
		Local $aSelected_Scripts = _FileOpenDialogEx($aTXT[$iMSG_AddScripts_2], "", "AutoIt v3 Scripts (*.au3)", 15, -1, "", $hMain_GUI)
		
		If @error Then
			If $iEvent_Type = 2 Then _Hide_GUI_Event()
			Return 0
		EndIf
	EndIf
	
	$aDropped_Files = $aSelected_Scripts
	_Dropped_Event_Handler($Scripts_LV)
	
	If $bCreate_Script Then
		If $iUse_BuiltIn_Plugin = 1 Then
			If Plugin_Active($sScripts_Editor) Then
				Plugin_Call_Proc($sScripts_Editor, '"' & $sScript_FilePath & '"')
			EndIf
		Else
			If $sScripts_Editor = "Default" Then
				ShellExecute($sScript_FilePath, "", "", "Edit")
			Else
				Run($sScripts_Editor & ' "' & $sScript_FilePath & '"')
			EndIf
		EndIf
	EndIf
	
	If $iEvent_Type = 2 Then _Hide_GUI_Event()
EndFunc

Func _AddScriptsToList_Proc($aScriptsList, $iChange_ScriptsArr = 1, $iSelectItems = 0) ;2-d array
	Local $aRetArr[$aScriptsList[0][0]+1][$iSL_Total], $iC = 0, $iCounter = _GUICtrlListView_GetItemCount($Scripts_LV)+1
	Local $aIcons[$iSL_Total] = [0]
	
	For $i = 1 To $aScriptsList[0][0]
		If Not FileExists($aScriptsList[$i][$iSL_FileName]) Then
			ContinueLoop
		EndIf
		
		$aRetArr[$iC][0] = $iCounter
		$aRetArr[$iC][$iSL_FileName] = StringRegExpReplace($aScriptsList[$i][$iSL_FileName], "^.*\\|\.[^\.]*$", "") ;File Name (without extension)
		$aRetArr[$iC][$iSL_FileAuthor] = _Script_GetAuthor($aScriptsList[$i][$iSL_FileName], '') ;File Author
		$aRetArr[$iC][$iSL_FileSize] = _String_GetFormattedSize(FileGetSize($aScriptsList[$i][$iSL_FileName])) ;File size
		$aRetArr[$iC][$iSL_FileTime] = _String_GetFormattedTime(FileGetTime($aScriptsList[$i][$iSL_FileName], 0)) ;File time (modified)
		$aRetArr[$iC][$iSL_FilePath] = $aScriptsList[$i][$iSL_FileName] ;File Path
		
		$iC += 1
		$iCounter += 1
		
		If $iCategory_Changed Or $iInput_Changed Then
			ExitLoop
		EndIf
	Next
	
	If $iC > 0 Then
		ReDim $aRetArr[$iC][$iSL_Total]
		_GUICtrlListView_AddArrayEx($hScripts_LV, $aRetArr, $aIcons, $iSelectItems)
		
		If $iChange_ScriptsArr Then
			Local $iUbound = $aScriptsList_Arr[0][0]
			Local $iRet_Ubound = UBound($aRetArr)-1
			ReDim $aScriptsList_Arr[$iUbound + $iRet_Ubound + 2][$iSL_Total+1]
			
			$aScriptsList_Arr[0][0] = $iUbound + $iRet_Ubound + 1
			
			For $i = $iUbound + 1 To $aScriptsList_Arr[0][0]
				For $j = 1 To $iSL_Total
					$aScriptsList_Arr[$i][$j] = $aRetArr[$i - $iUbound - 1][$j - 1]
				Next
			Next
		EndIf
	EndIf
	
	;_GUICtrlListView_SetColumnWidthEx($hLV, "0,60|1|2")
	_GUICtrlListView_SetColEquelWidth($hMain_GUI, $Scripts_LV, 0, 50)
EndFunc

Func _AddScriptToDataBase_Proc($sCategory, $sScript_Path)
	Local $iLast_Script_Count = 0
	Local $aCategory_Read = IniReadSection($sScripts_DataBase_File, $sCategory)
	
	If Not @error Then
		$iLast_Script_Count = StringStripWS(StringReplace($aCategory_Read[$aCategory_Read[0][0]][0], "Script ", ""), 3)
	EndIf
	
	IniWrite($sScripts_DataBase_File, $sCategory, "Script " & $iLast_Script_Count+1, $sScript_Path)
EndFunc

Func _AddNewCategory_Proc($sTitle = "", $sPrompt = "", $sDefault = "")
	Local $iError, $iExtended, $hFile
	Local $sNew_Category = $sTitle
	Local $sCurrent_Category = _GetCurrentCategory_Proc()
	Local $iCurrent_Category_Indx = @extended
	Local $sNext_Category = _GUICtrlListView_GetItemText($Category_LV, $iCurrent_Category_Indx + 1, 0)
	Local $iCategory_Count = _GUICtrlListView_GetItemCount($Category_LV) - 1
	Local $sAddAsSubCategory = $aTXT[$iMSG_AddAsSubCategory]
	Local $aCategory_Str = StringSplit($aTXT[$iMSG_Category_2], '|')
	Local $bIsGroup = ($sDefault == "Group")
	
	If $sPrompt <> "" Then
		If $iCategory_Count < 0 Then
			$sAddAsSubCategory = 0
		EndIf
		
		$sNew_Category = _InputBox($sTitle, $sPrompt, $sDefault, -1, 370, 140, -1, -1, 0, $hMain_GUI, 0, 0);_Iif($bIsGroup, 0, $sAddAsSubCategory)) ;Bugie with moving items
		Dim $iError = @error, $iExtended = @extended
		
		If $iError Then
			Return 0
		EndIf
		
		If $bIsGroup Then
			$sNew_Category = _GenerateGroup($sNew_Category)
		EndIf
		
		;Checkbox "Add as SubCategory" checked
		If $iExtended Then
			If $sCurrent_Category = "" Then
				$sCurrent_Category = _GUICtrlListView_GetItemText($Category_LV, $iCategory_Count, 0)
			EndIf
			
			$sSpaces = StringRegExpReplace($sCurrent_Category, "^(\h*).*$", "\1")
			If Not StringIsSpace($sSpaces) Then $sSpaces = ""
			$sNew_Category = $sSpaces & "    " & $sNew_Category
		EndIf
		
		If StringStripWS($sNew_Category, 8) = "" Then
			__MsgBox(48, $aTXT[$iMSG_Error_8], $aTXT[$iMSG_UnableToCreateY_ptyCategoryName], 0, $hMain_GUI)
			Return 0
		EndIf
		
		If _GUICtrlListView_FindText($Category_LV, $sNew_Category, -1, 0) <> -1 Then
			__MsgBox(48, $aTXT[$iMSG_Error_9], $aTXT[$iMSG_UnableToCreateThis] & " " & _Iif($bIsGroup, $aCategory_Str[1], $aCategory_Str[2]) & " " & $aTXT[$iMSG_AlreadyExists], 0, $hMain_GUI)
			Return 0
		EndIf
	EndIf
	
	GUICtrlCreateListViewItem($sNew_Category, $Category_LV)
	GUICtrlSetOnEvent(-1, "_CategoryItem_Event")
	
	ControlListView($hMain_GUI, "", $Category_LV, "SelectClear")
	_GUICtrlListView_SetItemSelected($Category_LV, $iCategory_Count + 1, 1, 1)
	ControlFocus($hMain_GUI, "", $Category_LV)
	
	$hFile = FileOpen($sScripts_DataBase_File, 1+8)
	FileWriteLine($hFile, "[" & $sNew_Category & "]" & @CRLF)
	FileClose($hFile)
	
	If $iExtended Then
		If $iCurrent_Category_Indx > -1 Then
			For $i = 1 To ($iCategory_Count - $iCurrent_Category_Indx)
				_GUICtrlListView_MoveItems($hMain_GUI, $Category_LV, -1)
			Next
			
			_GUICtrlListView_SetItemSelected($Category_LV, $iCurrent_Category_Indx + 1, 1, 1)
		EndIf
		
		_SetDataBaseCategories_Proc()
	EndIf
EndFunc

Func _GetCurrentCategory_Proc()
	Local $iIndex = _GUICtrlListView_GetSelectedIndices($Category_LV)
	
	If $iIndex = "" Then
		Return SetError(1, -1, "")
	EndIf
	
	$iIndex = Number($iIndex)
	
	Return SetExtended($iIndex, _GUICtrlListView_GetItemText($Category_LV, $iIndex))
EndFunc

Func _GenerateGroup($sName)
	Local $aCLV_Pos, $aLen
	Local $sSep = ""
	
	$aCLV_Pos = ControlGetPos($hMain_GUI, '', $Category_LV)
	
	While 1
		$aLen = __AboutBox_GUICtrlLabelGetTextWidth($sSep & " " & $sName & " " & $sSep, 9, 400, 'Arial')
		If $aLen[0] >= $aCLV_Pos[2] - 25 Then ExitLoop
		
		$sSep &= ""
	WEnd
	
	Return $sSep & " " & $sName & " " & $sSep
EndFunc

Func _CategoryIsGroup($sCategory)
	Return StringRegExp($sCategory, $sGroup_RegExp)
EndFunc

Func _Script_GetAuthor($sScript, $sDefault = @UserName)
	Local $sRet = $sDefault, $hFile, $sLine, $iCheck = 0
	
	$hFile = FileOpen($sScript, 0)
	If $hFile = -1 Then Return SetError(1, 0, $sRet)
	
	While 1
		$sLine = FileReadLine($hFile)
		If @error <> 0 Then ExitLoop
		
		If $iCheck Then
			If StringRegExp($sLine, '(?i)^\h*#ce') Then
				$iCheck = 0
				ContinueLoop
			EndIf
			
			If StringRegExp($sLine, '(?i)^\h*Author:\h*') Then
				$sRet = StringStripWS(StringRegExpReplace($sLine, '(?i)^\h*Author:\h*', ''), 3)
				ExitLoop
			EndIf
		EndIf
		
		If StringRegExp($sLine, '(?i)^\h*#cs') Then
			$iCheck = 1
		EndIf
	WEnd
	
	FileClose($hFile)
	Return $sRet
EndFunc

Func _FindScriptInDataBase_Proc($sCategory, $sScript_Path)
	Local $aCategory_Read = IniReadSection($sScripts_DataBase_File, $sCategory)
	
	For $i = 1 To UBound($aCategory_Read)-1
		If $aCategory_Read[$i][1] = $sScript_Path Then
			Return $i
		EndIf
	Next
	
	Return -1
EndFunc

Func _GUICtrlHyperlink_Create($sText, $iLeft, $iTop, $iWidth = -1, $iHeight = -1, $iFontSize = -1, $iFontWeight = -1, $iColor = 0x0000FF, $sToolTip = '', $iAttributes = 4)
	If $iWidth = -1 Then
		$iWidth = __AboutBox_GUICtrlLabelGetTextWidth($sText)
		$iWidth = $iWidth[0]
		
		If Not $iWidth Then
			$iWidth = -1
		EndIf
	EndIf
	
	Local $ID = GUICtrlCreateLabel($sText, $iLeft, $iTop, $iWidth, $iHeight)
	
	If $ID Then
		GUICtrlSetFont($ID, $iFontSize, $iFontWeight, $iAttributes)
		GUICtrlSetColor($ID, $iColor)
		GUICtrlSetCursor($ID, 0)
		GUICtrlSetTip($ID, $sToolTip)
	EndIf
	
	Return $ID
EndFunc

Func _GUICtrlHyperlink_Handler($hWnd, $iCtrlID, $sActionURL, $iAction = -1, $iVisitedColor = 0x551A8B)
	Local $aCurInfo = GUIGetCursorInfo($hWnd)
	If Not IsArray($aCurInfo) Then Return 0
	
	While IsArray($aCurInfo) And $aCurInfo[2] = 1
		$aCurInfo = GUIGetCursorInfo($hWnd)
		
		If $aCurInfo[4] <> $iCtrlID Then
			GUISetCursor(7, 1, $hWnd)
		Else
			GUISetCursor(2, 0, $hWnd)
		EndIf
		
		Sleep(10)
	WEnd
	
	GUISetCursor(2, 0, $hWnd)
	
	If IsArray($aCurInfo) And $aCurInfo[4] = $iCtrlID Then
		If $iAction = 1 Then
			Execute($sActionURL)
		ElseIf $iAction = -1 Then
			ShellExecute($sActionURL)
		EndIf
		
		If @error = 0 And $iVisitedColor Then
			GUICtrlSetColor($iCtrlID, $iVisitedColor)
		EndIf
		
		Return 1
	EndIf
	
	Return 0
EndFunc

Func _GUICtrlCreateGroup($iDirection, $iLeft, $iTop, $iWidth = 3, $iLenght = 25)
	Switch $iDirection
		Case 0
			Return GUICtrlCreateLabel("", $iLeft, $iTop, $iLenght, $iWidth, $SS_SUNKEN)
		Case 1
			Return GUICtrlCreateLabel("", $iLeft, $iTop, $iWidth, $iLenght, $SS_SUNKEN)
	EndSwitch
EndFunc

Func _GUICtrlCreateButton($sText, $iLeft, $iTop, $iWidth, $iHeight, $sIconFile = "", $nIconIndex = 0)
	Local $aRetArr[2]
	
	If $iUse_Skin_For_GUI <> 1 Then
		$aRetArr[0] = GUICtrlCreateDummy()
		$aRetArr[1] = _GUICtrlCreateButtoEx($sText, $iLeft, $iTop, $iWidth, $iHeight, -1, -1, $sIconFile, $nIconIndex)
		Return $aRetArr
	EndIf
	
	$aRetArr[0] = GUICtrlCreateIcon($sIconFile, $nIconIndex, $iLeft + 5, $iTop + (($iHeight - 15) / 2), 15, 15)
	GUICtrlSetBkColor($aRetArr[0], $GUI_BKCOLOR_TRANSPARENT)
	GUICtrlSetState($aRetArr[0], $GUI_DISABLE)
	$aRetArr[1] = GUICtrlCreateButton("       " & $sText & " ", $iLeft, $iTop, $iWidth, $iHeight, $WS_CLIPSIBLINGS)
	
	Return $aRetArr
EndFunc

Func _GUICtrlCreateButtoEx($sText, $iLeft, $iTop, $iWidth = -1, $iHeight = -1, $nStyle = -1, $nExStyle = -1, $sIconFile = '', $nIconID = 0, $nAlign = -1)
	Local $nID = GUICtrlCreateButton($sText, $iLeft, $iTop, $iWidth, $iHeight, $nStyle, $nExStyle)
	
	If $sIconFile = '' Then
		Return $nID
	EndIf
	
	Local $hIL = _GUIImageList_Create(16, 16, 5, BitOr($ILC_MASK, $ILC_COLOR32), 0, 1)
	
	_GUIImageList_AddIcon($hIL, $sIconFile, $nIconID)
	_GUICtrlButton_SetImageList($nID, $hIL)
	
	Return $nID
EndFunc

Func _GUICtrlCreateGroupEx($sText, $iLeft, $iTop, $iWidth, $iHeight, $iLineWidth = 3, $nColor = 0, $iStyle = 0, $sIcon = '', $nIconID = 0, $iResizing = 0)
	Local $aIDs[2] ;First + Last IDs
	
	Local $nLabel_Style = $SS_ETCHEDFRAME
	
	;1 to able set color for the Group frame
	If $iStyle > 0 Then
		$nLabel_Style = $SS_SUNKEN
	EndIf
	
	GUIStartGroup()
	
	$aIDs[0] = GUICtrlCreateLabel('', $iLeft+1, $iTop, $iWidth-2, $iLineWidth, $nLabel_Style)
	GUICtrlSetBkColor(-1, $nColor)
	GUICtrlSetResizing(-1, $iResizing)
	
	GUICtrlCreateLabel('', $iLeft+2, $iTop+5, $iLineWidth, $iHeight-4, $nLabel_Style)
	GUICtrlSetBkColor(-1, $nColor)
	GUICtrlSetResizing(-1, $iResizing)
	
	GUICtrlCreateLabel('', ($iLeft+$iWidth), $iTop-3, $iLineWidth, $iHeight-3, $nLabel_Style)
	GUICtrlSetBkColor(-1, $nColor)
	GUICtrlSetResizing(-1, $iResizing)
	
	$aIDs[1] = GUICtrlCreateLabel('', $iLeft+6, ($iTop+$iHeight)-5, $iWidth, $iLineWidth, $nLabel_Style)
	GUICtrlSetBkColor(-1, $nColor)
	GUICtrlSetResizing(-1, $iResizing)
	
	If $sText <> '' Then
		If $sIcon <> '' Then
			$iLeft += 15
			$sText = ' ' & $sText
		EndIf
		
		$aIDs[1] = GUICtrlCreateLabel('  ' & $sText, $iLeft+35, $iTop-6)
		GUICtrlSetColor(-1, $nColor)
		GUICtrlSetResizing(-1, $iResizing)
	EndIf
	
	If $sIcon <> '' Then
		GUICtrlCreateIcon($sIcon, $nIconID, $iLeft+25, $iTop-8, 16, 16)
		GUICtrlSetResizing(-1, $iResizing)
	EndIf
	
	Return $aIDs
EndFunc

Func _GUICtrlListView_AddArrayEx($hWnd, $aItems, $aIcons, $iSelect = 0)
	Local $iItems_Count = _GUICtrlListView_GetItemCount($hWnd)
	Local $iIndex
	
	For $iI = 0 To UBound($aItems) - 1
		$iIndex = _GUICtrlListView_AddItem($hWnd, $aItems[$iI][0], $aIcons[0], $iItems_Count + 9999)
		$iItems_Count += 1
		
		If $iSelect Then
			_GUICtrlListView_SetItemSelected($hWnd, $iIndex, 1)
		EndIf
		
		For $iJ = 1 To UBound($aItems, 2) - 1
			_GUICtrlListView_AddSubItem($hWnd, $iIndex, $aItems[$iI][$iJ], $iJ, $aIcons[$iJ])
		Next
	Next
EndFunc

Func _GUICtrlListView_SetColumnWidthEx($hLV, $sColumns = "0")
	Local $aSelected_Indices = _GUICtrlListView_GetSelectedIndices($hLV, 1)
	Local $aColumnsArr, $aSplitArr
	
	If StringInStr($sColumns, "|") Then
		$aColumnsArr = StringSplit($sColumns, "|")
	Else
		Dim $aColumnsArr[2] = [1, $sColumns]
	EndIf
	
	For $i = 1 To $aColumnsArr[0]
		If StringInStr($aColumnsArr[$i], ",") Then
			$aSplitArr = StringSplit($aColumnsArr[$i], ",")
		Else
			Dim $aSplitArr[3] = [2, $aColumnsArr[$i], -1]
		EndIf
		
		GUICtrlSendMsg($hLV, $LVM_SETCOLUMNWIDTH, Number($aSplitArr[1]), Number($aSplitArr[2]))
	Next
	
	_GUICtrlListView_RestoreSelection($hLV, $aSelected_Indices)
EndFunc

Func _GUICtrlListView_SetColEquelWidth($hWnd, $hLV, $iExcludeCol = -1, $iExcldColWidth = 0)
	Local $aSelected_Indices = _GUICtrlListView_GetSelectedIndices($hLV, 1)
	Local $iColumns_Count = _GUICtrlListView_GetColumnCount($hLV)
	Local $aLV_Width = ControlGetPos($hWnd, "", $hLV)
	
	If @error Then
		Return
	EndIf
	
	Local $iLV_Width = ($aLV_Width[2]-20) / $iColumns_Count
	
	If $iExcludeCol <> -1 Then
		$iLV_Width = ($aLV_Width[2] - $iExcldColWidth - 20) / ($iColumns_Count - 1)
	EndIf
	
	For $i = 0 To $iColumns_Count
		If $i <> $iExcludeCol Then
			GUICtrlSendMsg($hLV, $LVM_SETCOLUMNWIDTH, $i, $iLV_Width)
		Else
			GUICtrlSendMsg($hLV, $LVM_SETCOLUMNWIDTH, $i, $iExcldColWidth)
		EndIf
	Next
	
	_GUICtrlListView_RestoreSelection($hLV, $aSelected_Indices)
EndFunc

Func _GUICtrlListView_SortByFilter_Proc($nLV)
	$sOld_Filter_Text = GUICtrlRead($Filter_Input)
	
	Local $iIndexFilter = $iSL_Count + 1
	
	If GUICtrlRead($ScriptName_Radio) = $GUI_CHECKED Then
		$iIndexFilter = $iSL_FileName + 1
	EndIf
	
	If GUICtrlRead($ScriptAuthor_Radio) = $GUI_CHECKED Then
		$iIndexFilter = $iSL_FileAuthor + 1
	EndIf
	
	If GUICtrlRead($ScriptSize_Radio) = $GUI_CHECKED Then
		$iIndexFilter = $iSL_FileSize + 1
	EndIf
	
	If GUICtrlRead($ScriptModified_Radio) = $GUI_CHECKED Then
		$iIndexFilter = $iSL_FileTime + 1
	EndIf
	
	If GUICtrlRead($ScriptPath_Radio) = $GUI_CHECKED Then
		$iIndexFilter = $iSL_FilePath + 1
	EndIf
	
	If $sOld_Filter_Text = "" Then
		_GUICtrlListView_SetItemsFilter($nLV, $aScriptsList_Arr, $iSL_FileName, -1)
	Else
		_GUICtrlListView_SetItemsFilter($nLV, $aScriptsList_Arr, $iIndexFilter, $sOld_Filter_Text)
	EndIf
EndFunc

Func _GUICtrlListView_SetItemsFilter($nLV, ByRef $aS_LV_Array2D, $iLV_Column_Index, $sLV_Filter_String)
	Local $vData = "", $nUbound = UBound($aS_LV_Array2D), $iIndex
	Local $aSelected_Indices, $sSelected_Count = "|"
	Local $hLV = GUICtrlGetHandle($nLV)
	
	$aSelected_Indices = _GUICtrlListView_GetSelectedIndices($Scripts_LV, 1)
	
	If $sLV_Filter_String = -1 Then
		For $i = 1 To UBound($aSelected_Indices)-1
			$sSelected_Count &= _GUICtrlListView_GetItemText($Scripts_LV, $aSelected_Indices[$i], 0) & "|"
		Next
	EndIf
	
	_SendMessage($hLV, $LVM_DELETEALLITEMS)
	
	Local $iIndex = _GUICtrlListView_GetSelectedIndices($Category_LV)
	
	If $iIndex = "" Then
		$iIndex = $iLast_Sel_Category_Indx
	EndIf
	
	Local $sCurrent_Category = _GUICtrlListView_GetItemText($Category_LV, Number($iIndex), 0)
	
	If $nUbound <= 1 And $sCurrent_Category = "" Then
		Return
	EndIf
	
	If $sCurrent_Category = "" Then
		$sCurrent_Category = $sLast_Category
	EndIf
	
	If GUICtrlRead($Filter_Input) = "" Then
		_Set_ScriptsList_Proc($sCurrent_Category, 0)
		_GUICtrlListView_RestoreSelection($hLV, $aSelected_Indices)
		Return
	EndIf
	
	If $sLV_Filter_String = -1 Then
		For $x = 1 To $nUbound - 1
			$vData = ""
			
			For $y = 1 To UBound($aS_LV_Array2D, 2) - 1
				$vData &= $aS_LV_Array2D[$x][$y] & "|"
				
				If $iCategory_Changed Or $iInput_Changed Then
					ExitLoop 2
				EndIf
			Next
			
			$iIndex = _GUICtrlListView_InsertItem($hLV, "", -1, 0, $nUbound + $x + 9999)
			_GUICtrlListView_SetItemText($hLV, $iIndex, $vData, -1)
			
			If StringInStr($sSelected_Count, "|" & $aS_LV_Array2D[$x][1] & "|") Then
				_GUICtrlListView_SetItemSelected($hLV, $iIndex)
			EndIf
		Next
	Else
		Local $iIsInScriptSearch = Number(GUICtrlRead($SearchInScripts_CB) = $GUI_CHECKED)
		Local $iIsRegExpSearch = Number(GUICtrlRead($RegExpSearch_CB) = $GUI_CHECKED)
		Local $iIsCaseSenseSearch = Number(GUICtrlRead($CaseSenseSearch_CB) = $GUI_CHECKED)
		Local $iIsWholeWordSearch = Number(GUICtrlRead($WholeWordSearch_CB) = $GUI_CHECKED)
		
		Local $sCurrentItem, $aFileFindInfo, $iCaseSensVar = 2, $sCaseSensStr = "(?i)", $sWholeWordStr = $sLV_Filter_String
		
		If $iIsCaseSenseSearch Then
			$iCaseSensVar = 1
			$sCaseSensStr = ""
		EndIf
		
		If $iIsWholeWordSearch Then
			$sWholeWordStr = "(\A|\s)" & $sWholeWordStr & "(\z|\s)"
		EndIf
		
		If $iIsInScriptSearch Then
			$iLV_Column_Index = $iSL_FilePath + 1 ;Path of the script
		EndIf
		
		For $x = 1 To $nUbound - 1
			If $iCategory_Changed Or $iInput_Changed Then
				ExitLoop
			EndIf
			
			$sCurrentItem = $aS_LV_Array2D[$x][$iLV_Column_Index]
			
			If $iIsInScriptSearch Then
				$sCurrentItem = FileRead($sCurrentItem)
				
				;$aFileFindInfo = _FileFindText($sCurrentItem, $sLV_Filter_String, $iIsWholeWordSearch, $iCaseSensVar)
				
				;If @error Then
				;	ContinueLoop
				;EndIf
			EndIf
			
			If $iIsRegExpSearch Then
				If Not StringRegExp($sCurrentItem, $sCaseSensStr & $sWholeWordStr) Then
					ContinueLoop
				EndIf
			Else
				If $iIsWholeWordSearch Then
					If Not StringRegExp($sCurrentItem, $sCaseSensStr & "(\A|\s)" & $sLV_Filter_String & "(\z|\s)") Then
						ContinueLoop
					EndIf
				EndIf
				
				If Not StringInStr($sCurrentItem, $sLV_Filter_String, $iCaseSensVar) Then
					ContinueLoop
				EndIf
			EndIf
			
			$vData = ""
			
			For $y = 1 To UBound($aS_LV_Array2D, 2) - 1
				$vData &= $aS_LV_Array2D[$x][$y] & "|"
				
				If $iCategory_Changed Or $iInput_Changed Then
					ExitLoop 2
				EndIf
			Next
			
			;GUICtrlCreateListViewItem($vData, $nLV)
			
			$iIndex = _GUICtrlListView_InsertItem($hLV, "", -1, 0, $nUbound + $x + 9999)
			_GUICtrlListView_SetItemText($hLV, $iIndex, $vData, -1)
		Next
	EndIf
	
	;If $vData <> "" Then
	;	_GUICtrlListView_SetColumnWidthEx($hLV, "0,60|1|2")
	;EndIf
	
	_GUICtrlListView_SetColEquelWidth($hMain_GUI, $Scripts_LV, 0, 50)
	_GUICtrlListView_RestoreSelection($hLV, $aSelected_Indices)
EndFunc

Func _GUICtrlListView_MoveItems($hWnd, $hListView, $iMoveMode = 1)
	Local $aSelected_Indices = _GUICtrlListView_GetSelectedIndices($hListView, 1)
	
	If UBound($aSelected_Indices) < 2 Then
		Return SetError(1, 0, "")
	EndIf
	
	If $iMoveMode <> 1 And $iMoveMode <> -1 Then
		Return SetError(2, 0, -1)
	EndIf
	
	Local $iTotal_Items = ControlListView($hWnd, "", $hListView, "GetItemCount")
	Local $iUbound = UBound($aSelected_Indices)-1, $iNum = 1, $iStep = 1
	Local $iCurrent_Index, $sCurrent_ItemText
	Local $iUpDown_Index, $sUpDown_ItemText
	Local $iEnsure_VisibleItem
	
	If ($iMoveMode = -1 And $aSelected_Indices[1] = 0) Or ($iMoveMode = 1 And $aSelected_Indices[$iUbound] = $iTotal_Items-1) Then
		Return SetError(3, 0, "")
	EndIf
	
	$iEnsure_VisibleItem = $aSelected_Indices[1] - 1
	
	GUISetState(@SW_DISABLE, $hWnd)
	ControlListView($hWnd, "", $hListView, "SelectClear")
	
	If $iMoveMode = 1 Then
		$iEnsure_VisibleItem = $aSelected_Indices[$iUbound] + 1
		$iNum = $iUbound
		$iUbound = 1
		$iStep = -1
	EndIf
	
	For $i = $iNum To $iUbound Step $iStep
		$iCurrent_Index = $aSelected_Indices[$i]
		$iUpDown_Index = $aSelected_Indices[$i] + $iMoveMode
		
		$sUpDown_ItemText = _GUICtrlListView_GetItemText($hListView, $iUpDown_Index)
		$sCurrent_ItemText = _GUICtrlListView_GetItemText($hListView, $iCurrent_Index)
		
		_GUICtrlListView_SetItemText($hListView, $iUpDown_Index, $sCurrent_ItemText)
		_GUICtrlListView_SetItemText($hListView, $iCurrent_Index, $sUpDown_ItemText)
		
		_GUICtrlListView_SetItemSelected($hListView, $iUpDown_Index, 1)
	Next
	
	;_GUICtrlListView_EnsureVisible($hListView, $iEnsure_VisibleItem, 1)
	GUISetState(@SW_ENABLE, $hWnd)
	ControlFocus($hWnd, "", $hListView)
EndFunc

Func _GUICtrlListView_RestoreSelection($hLV, ByRef $aSelected_Indices)
	For $i = 1 To UBound($aSelected_Indices)-1
		_GUICtrlListView_SetItemSelected($hLV, $aSelected_Indices[$i])
	Next
EndFunc

Func _GUICtrlListView_SimpleSortEx($hWnd, ByRef $vDescending, $iCol)
	If _GUICtrlListView_GetItemCount($hWnd) = 0 Then
		Return
	EndIf
	
	Local $b_desc
	
	If IsArray($vDescending) Then
		$b_desc = $vDescending[$iCol]
	Else
		$b_desc = $vDescending
	EndIf
	
	Local $columns = _GUICtrlListView_GetColumnCount($hWnd)
	Local $items = _GUICtrlListView_GetItemCount($hWnd)
	Local $temp_item = ""
	Local $GroupChar = Opt('GUIDataSeparatorChar')
	
	For $x = 1 To $columns
		$temp_item &= " " & $GroupChar
	Next
	
	$temp_item = StringTrimRight($temp_item, 1)
	
	Local $a_lv[$items][$columns + 1]
	Local $i_selected = StringSplit(_GUICtrlListView_GetSelectedIndices($hWnd), $GroupChar)
	Local $v_item, $iFocused = -1
	
	For $x = 0 To UBound($a_lv) - 1 Step 1
		If $iFocused = -1 Then
			If _GUICtrlListView_GetItemFocused($hWnd, $x) Then
				$iFocused = $x
			EndIf
		EndIf
		
		_GUICtrlListView_SetItemSelected($hWnd, $x, False)
		
		For $y = 0 To UBound($a_lv, 2) - 2 Step 1
			$v_item = StringStripWS(_GUICtrlListView_GetItemText($hWnd, $x, $y), 2)
			
			If StringIsFloat($v_item) Or StringIsInt($v_item) Then
				$a_lv[$x][$y] = Number($v_item)
			Else
				$a_lv[$x][$y] = $v_item
			EndIf
		Next
		
		$a_lv[$x][$y] = $x
	Next
	
	_ArraySort($a_lv, $b_desc, 0, 0, $iCol)
	
	For $x = 0 To UBound($a_lv) - 1 Step 1
		For $y = 0 To UBound($a_lv, 2) - 2 Step 1
			_GUICtrlListView_SetItemText($hWnd, $x, $a_lv[$x][$y], $y)
		Next
		
		For $z = 1 To $i_selected[0]
			If $a_lv[$x][UBound($a_lv, 2) - 1] = $i_selected[$z] Then
				If $a_lv[$x][UBound($a_lv, 2) - 1] = $iFocused Then
					_GUICtrlListView_SetItemSelected($hWnd, $x, True, True)
				Else
					_GUICtrlListView_SetItemSelected($hWnd, $x, True)
				EndIf
				
				ExitLoop
			EndIf
		Next
	Next
	
	If IsArray($vDescending) Then
		$vDescending[$iCol] = Not $b_desc
	Else
		$vDescending = Not $b_desc
	EndIf
EndFunc

Func _GUICtrlListView_RegisterSortCallBackEx($hWnd, $fNumbers = True, $fArrows = True)
	If $Debug_LV Then __UDF_ValidateClassName($hWnd, $__LISTVIEWCONSTANT_ClassName)
	If Not IsHWnd($hWnd) Then $hWnd = GUICtrlGetHandle($hWnd)

	Local $hHeader = _GUICtrlListView_GetHeader($hWnd)

	ReDim $aListViewSortInfo[UBound($aListViewSortInfo) + 1][$iLListViewSortInfoSize]

	$aListViewSortInfo[0][0] = UBound($aListViewSortInfo) - 1
	Local $iIndex = $aListViewSortInfo[0][0]

	$aListViewSortInfo[$iIndex][1] = $hWnd ; Handle/ID of listview
	
	$aListViewSortInfo[$iIndex][2] = DllCallbackRegister("__GUICtrlListView_SortEx", "int", "int;int;hwnd") ; Handle of callback
	$aListViewSortInfo[$iIndex][3] = -1 ; $nColumn
	$aListViewSortInfo[$iIndex][4] = -1 ; nCurCol
	$aListViewSortInfo[$iIndex][5] = 1 ; $nSortDir
	$aListViewSortInfo[$iIndex][6] = -1 ; $nCol
	$aListViewSortInfo[$iIndex][7] = 0 ; $bSet
	$aListViewSortInfo[$iIndex][8] = $fNumbers ; Treat as numbers?
	$aListViewSortInfo[$iIndex][9] = $fArrows ; Use arrows in the header of the columns?
	$aListViewSortInfo[$iIndex][10] = $hHeader ; Handle to the Header
	
	Return $aListViewSortInfo[$iIndex][2] <> 0
EndFunc

Func __GUICtrlListView_SortEx($nItem1, $nItem2, $hWnd)
	Local $iIndex, $tInfo, $val1, $val2, $nResult
	$tInfo = DllStructCreate($tagLVFINDINFO)
	DllStructSetData($tInfo, "Flags", $LVFI_PARAM)

	For $x = 1 To $aListViewSortInfo[0][0]
		If $hWnd = $aListViewSortInfo[$x][1] Then
			$iIndex = $x
			ExitLoop
		EndIf
	Next

	; Switch the sorting direction
	If $aListViewSortInfo[$iIndex][3] = $aListViewSortInfo[$iIndex][4] Then ; $nColumn = nCurCol ?
		If Not $aListViewSortInfo[$iIndex][7] Then ; $bSet
			$aListViewSortInfo[$iIndex][5] *= -1 ; $nSortDir
			$aListViewSortInfo[$iIndex][7] = 1 ; $bSet
		EndIf
	Else
		$aListViewSortInfo[$iIndex][7] = 1 ; $bSet
	EndIf
	
	$aListViewSortInfo[$iIndex][6] = $aListViewSortInfo[$iIndex][3] ; $nCol = $nColumn
	DllStructSetData($tInfo, "Param", $nItem1)
	$val1 = _GUICtrlListView_FindItem($hWnd, -1, $tInfo)
	DllStructSetData($tInfo, "Param", $nItem2)
	$val2 = _GUICtrlListView_FindItem($hWnd, -1, $tInfo)
	$val1 = _GUICtrlListView_GetItemText($hWnd, $val1, $aListViewSortInfo[$iIndex][3])
	$val2 = _GUICtrlListView_GetItemText($hWnd, $val2, $aListViewSortInfo[$iIndex][3])
	
	If $aListViewSortInfo[$iIndex][8] Then ; Treat As Number
		If (StringIsFloat($val1) Or StringIsInt($val1)) Then $val1 = Number($val1)
		If (StringIsFloat($val2) Or StringIsInt($val2)) Then $val2 = Number($val2)
	EndIf
	
	$nResult = 0 ; No change of item1 and item2 positions
	
	Switch $aListViewSortInfo[$iIndex][3]
		Case $iSL_Count ;Count column
			
		Case $iSL_FileSize ;Size column
			Local $sSizeStr1 = StringRegExpReplace($val1, ".* ", "")
			Local $sSizeStr2 = StringRegExpReplace($val2, ".* ", "")
			
			If $sSizeStr1 = $sSizeStr2 Then
				$val1 = Number(StringRegExpReplace($val1, "[,]| .*", "."))
				$val2 = Number(StringRegExpReplace($val2, "[,]| .*", "."))
			Else
				Local $iStr1Num = 0, $iStr2Num = 0
				Local $aSizeStr[4] = [$aTXT[$iMSG_Bytes], $aTXT[$iMSG_KB], $aTXT[$iMSG_MB], $aTXT[$iMSG_GB]]
				
				For $i = 0 To 3
					If $sSizeStr1 = $aSizeStr[$i] Then $val1 = $i
					If $sSizeStr2 = $aSizeStr[$i] Then $val2 = $i
				Next
			EndIf
		Case $iSL_FileTime ;Modified column
			$val1 = StringRegExpReplace($val1, "(\d+)/(\d+)/(\d+), (\d+:\d+:\d+)", "\3/\2/\1 \4")
			$val2 = StringRegExpReplace($val2, "(\d+)/(\d+)/(\d+), (\d+:\d+:\d+)", "\3/\2/\1 \4")
	EndSwitch
	
	If $val1 < $val2 Then
		$nResult = -1 ; Put item2 before item1
	ElseIf $val1 > $val2 Then
		$nResult = 1 ; Put item2 behind item1
	EndIf
	
	$nResult *= $aListViewSortInfo[$iIndex][5] ; $nSortDir
	Return $nResult
EndFunc

Func _ArrayQSort(ByRef $avArray, $Left, $Right)
	Local $i, $j, $t
	If $right - $left < 10 Then
		; InsertSort - fastest on small segments (= 25% total speedup)
		For $i = $left + 1 To $right
			$t = $avArray[$i]
			$j = $i
			While $j > $left _
					And ((IsNumber($avArray[$j - 1]) = IsNumber($t) And $avArray[$j - 1] > $t) _
					Or (IsNumber($avArray[$j - 1]) <> IsNumber($t) And String($avArray[$j - 1]) > String($t)))
				$avArray[$j] = $avArray[$j - 1]
				$j = $j - 1
			WEnd
			$avArray[$j] = $t
		Next
		Return
	EndIf

	; QuickSort - fastest on large segments
	Local $pivot = $avArray[Int(($left + $right) / 2) ]
	Local $L = $left
	Local $R = $right
	Do
		While ((IsNumber($avArray[$L]) = IsNumber($pivot) And $avArray[$L] < $pivot) _
				Or (IsNumber($avArray[$L]) <> IsNumber($pivot) And String($avArray[$L]) < String($pivot)))
			;While $avArray[$L] < $pivot
			$L = $L + 1
		WEnd
		While ((IsNumber($avArray[$R]) = IsNumber($pivot) And $avArray[$R] > $pivot) _
				Or (IsNumber($avArray[$R]) <> IsNumber($pivot) And String($avArray[$R]) > String($pivot)))
			;	While $avArray[$R] > $pivot
			$R = $R - 1
		WEnd
		; Swap
		If $L <= $R Then
			$t = $avArray[$L]
			$avArray[$L] = $avArray[$R]
			$avArray[$R] = $t
			$L = $L + 1
			$R = $R - 1
		EndIf
	Until $L > $R

	_ArrayQSort($avArray, $left, $R)
	_ArrayQSort($avArray, $L, $right)
EndFunc

Func _SelectBox($aSelectList, $sTitle = "", $sPrompt = "", $iOnTop = 0, $hWnd = 0)
	Local $iRet = -1, $iOld_Opt_GOEM = Opt("GUIOnEventMode", 0)
	
	Local $hSelectBox = GUICreate($sTitle, 300, 150, -1, -1, BitOR($WS_CAPTION, $WS_POPUP, $WS_SYSMENU), -1, $hWnd)
	
	If $iOnTop Then
		WinSetOnTop($hSelectBox, "", 1)
	EndIf
	
	GUICtrlCreateLabel($sPrompt, 20, 20, 400, 30)
	GUICtrlSetFont(-1, 10, 800)
	
	Local $sCombo_Data = ""
	
	For $i = 1 To UBound($aSelectList)-1
		$sCombo_Data &= $aSelectList[$i]
		
		If $i < $aSelectList[0] Then
			$sCombo_Data &= "|"
		EndIf
	Next
	
	Local $nSelect_Combo = GUICtrlCreateCombo("", 20, 70, 260, 40, BitOr($GUI_SS_DEFAULT_COMBO, $CBS_DROPDOWNLIST))
	GUICtrlSetData($nSelect_Combo, $sCombo_Data, $aSelectList[1])
	
	Local $nOk_Button = GUICtrlCreateButton($aTXT[$iMSG_Ok_1], 20, 120, 60, 20, $BS_DEFPUSHBUTTON)
	Local $nCancel_Button = GUICtrlCreateButton($aTXT[$iMSG_Cancel_1], 100, 120, 60, 20)
	
	GUISetState(@SW_DISABLE, $hWnd)
	GUISetState(@SW_SHOW, $hSelectBox)
	
	_FixSkinActivationBug_Proc($hWnd)
	
	While 1
		$nMsg = GUIGetMsg()
		
		Switch $nMsg
			Case $nOk_Button
				$iRet = GUICtrlRead($nSelect_Combo)
				ExitLoop
			Case $nCancel_Button, $GUI_EVENT_CLOSE
				ExitLoop
		EndSwitch
	WEnd
	
	GUISetState(@SW_ENABLE, $hWnd)
	GUIDelete($hSelectBox)
	Opt("GUIOnEventMode", $iOld_Opt_GOEM)
	
	Return SetError(Number($iRet = -1), 0, $iRet)
EndFunc

Func _MsgBoxEx($iIcoType, $iButt_Num, $sTitle, $sText, $iWidth, $iHeight, $sCB_Text = -1, $iTimer=-1, $hWnd = 0, $sB1Text = -1, $sB2Text = -1, $nExStyle = -1)
	Local $nYes_Button, $nNo_Button, $nOK_Button, $nCheckBox=-1, $hMsgBox_GUI, $i_Height = $iHeight
	Local $nStyle = BitOR($WS_CAPTION, $WS_POPUP)
	Local $nMsg, $iReturnVal = 0
	Local $nDefButton, $sDefButtonText = $sB1Text, $iCounter
	Local $iMessageBeep = -1, $iIcon_Id = 102
	
	Local $iOld_Opt_GOEM = Opt("GUIOnEventMode", 0)
	Local $iOld_Opt_GCOE = Opt("GUICloseOnESC", 0)
	
	If $iButt_Num = 1 Then
		$nStyle = BitOR($nStyle, $WS_SYSMENU)
	EndIf
	
	If BitAND($iIcoType, 262144) Then
		If $nExStyle = -1 Or $nExStyle = Default Then
			$nExStyle = 0
		EndIf
		
		$nExStyle = BitOR($nExStyle, $WS_EX_TOPMOST)
	EndIf
	
	If $sCB_Text <> -1 Then
		$i_Height += 25
	EndIf
	
	If $sB1Text = -1 Then
		$sB1Text = $aTXT[$iMSG_Ok_2]
	EndIf
	
	If $sB2Text = -1 Then
		$sB2Text = $aTXT[$iMSG_Cancel_2]
	EndIf
	
	$hMsgBox_GUI = GUICreate($sTitle, $iWidth, $i_Height, -1, -1, $nStyle, $nExStyle, $hWnd)
	
	Select
		Case $iIcoType = 16 Or $iIcoType = 16 + 256
			$iIcon_Id = 103
			$iMessageBeep = 0x00000010
		Case $iIcoType = 32 Or $iIcoType = 32 + 256
			$iIcon_Id = 102
			$iMessageBeep = 0x00000020
		Case $iIcoType = 48 Or $iIcoType = 48 + 256
			$iIcon_Id = 101
			$iMessageBeep = 0x00000030
		Case $iIcoType = 64 Or $iIcoType = 64 + 256
			$iIcon_Id = 104
			$iMessageBeep = 0x00000040
	EndSelect
	
	GUICtrlCreateIcon('User32.dll', $iIcon_Id, 10, 10)
	GUICtrlCreateLabel($sText, 70, 15, $iWidth-80, $iHeight-50)
	
	Select
		Case $iButt_Num = 2
			$nYes_Button = GUICtrlCreateButton($sB1Text, ($iWidth/2)-90, $iHeight-35, 70, 20, $BS_DEFPUSHBUTTON)
			$nDefButton = $nYes_Button
			
			Local $iSecButtDeffStyle = 0
			
			If BitAND($iIcoType, 256) Then
				$iSecButtDeffStyle = $BS_DEFPUSHBUTTON
			EndIf
			
			$nNo_Button = GUICtrlCreateButton($sB2Text, ($iWidth/2)+20, $iHeight-35, 70, 20, $iSecButtDeffStyle)
			
			If BitAND($iIcoType, 256) Then
				$nDefButton = $nNo_Button
			EndIf
		Case Else
			$nOK_Button = GUICtrlCreateButton($sB1Text, ($iWidth-70)/2, $iHeight-35, 70, 20)
			GUICtrlSetState($nOK_Button, $GUI_ONTOP)
			$nDefButton = $nOK_Button
	EndSelect
	
	If $sCB_Text <> -1 Then
		$nCheckBox = GUICtrlCreateCheckbox($sCB_Text, 15, $iHeight-10)
	EndIf
	
	DllCall("User32.dll", "int", "MessageBeep", "int", $iMessageBeep)
	
	If IsHWnd($hWnd) Then
		GUISetState(@SW_DISABLE, $hWnd)
		GUISetState(@SW_SHOW, $hMsgBox_GUI)
	Else
		GUISetState(@SW_SHOW, $hMsgBox_GUI)
	EndIf
	
	_FixSkinActivationBug_Proc($hWnd)
	
	If $iTimer > 0 Then
		$iCounter = $iTimer
		$iTimer = TimerInit()
		$sDefButtonText = GUICtrlRead($nDefButton)
		GUICtrlSetData($nDefButton, $sDefButtonText & ' (' & $iCounter & ')')
	EndIf
	
	While 1
		$nMsg = GUIGetMsg()
		
		If $iTimer > 0 And TimerDiff($iTimer) >= 1000 Then
			$iTimer = TimerInit()
			$iCounter -= 1
			
			If $iCounter < 0 Then
				$nMsg = $nDefButton
			Else
				GUICtrlSetData($nDefButton, $sDefButtonText & ' (' & $iCounter & ')')
			EndIf
		EndIf
		
		Select
			Case $iButt_Num = 2 And $nMsg = $nYes_Button
				$iReturnVal = 6
				ExitLoop
			Case $iButt_Num = 2 And $nMsg = $nNo_Button
				$iReturnVal = 7
				ExitLoop
			Case $nMsg = -3 Or ($nMsg = $nOK_Button And $iButt_Num <> 2)
				$iReturnVal = 1
				ExitLoop
		EndSelect
	Wend
	
	If GUICtrlRead($nCheckBox) = 1 Then
		$iReturnVal += 8
	EndIf
	
	If IsHWnd($hWnd) Then
		GUISetState(@SW_ENABLE, $hWnd)
		GUIDelete($hMsgBox_GUI)
		GUISwitch($hWnd)
	Else
		GUIDelete($hMsgBox_GUI)
	EndIf
	
	Opt("GUIOnEventMode", $iOld_Opt_GOEM)
	Opt("GUICloseOnESC", $iOld_Opt_GCOE)
	
	Return $iReturnVal
EndFunc

;==============================================
;	Return values:
;	
;	6 - "Yes" button
;	12 - "Yes to all" button
;	7 - "No" button
;	14 - "No to all" button
;	2 - "Cancel" button
;	10 - "AutoBackup Existing Files" button
;=============================================
Func _MsgBox_Copy_Proc($Parent_hWnd, $sTitle = "Confirm", $sPrompt = "", $iAnim = 0, $iOnTop = 0)
	Local $Old_Opt_GOEM = Opt("GUIOnEventMode", 0)
	Local $iRet_Val = 2
	
	Local $Child_hWnd = GUICreate($sTitle, 400, 200, -1, -1, BitOR($WS_CAPTION, $WS_POPUP, $WS_SYSMENU), -1, $Parent_hWnd)
	
	If $iOnTop Then
		WinSetOnTop($Child_hWnd, "", 1)
	EndIf
	
	GUICtrlCreateAvi(@SystemDir & "\Shell32.dll", $iAnim, 65, 0)
	GUICtrlSetState(-1, 1)
	
	GUICtrlCreateLabel($sPrompt, 20, 80, 400, 40)
	GUICtrlSetFont(-1, 10, 800)
	
	Local $No_Button = GUICtrlCreateButton($aTXT[$iMSG_No_4], 170, 150, 60, 20, $BS_DEFPUSHBUTTON)
	Local $NoForAll_Button = GUICtrlCreateButton($aTXT[$iMSG_NoForAll], 240, 150, 60, 20)
	
	Local $Yes_Button = GUICtrlCreateButton($aTXT[$iMSG_Yes_4], 20, 150, 60, 20)
	Local $YesForAll_Button = GUICtrlCreateButton($aTXT[$iMSG_YesForAll], 90, 150, 60, 20)
	
	Local $Cancel_Button = GUICtrlCreateButton($aTXT[$iMSG_Cancel_3], 320, 150, 60, 20)
	;Local $AutoBackFiles_Button = GUICtrlCreateButton("AutoBackup Existing Files", 20, 180, 150, 20)
	
	GUISetState(@SW_DISABLE, $Parent_hWnd)
	GUISetState(@SW_SHOW, $Child_hWnd)
	
	_FixSkinActivationBug_Proc($Parent_hWnd)
	
	While 1
		$iMsg = GUIGetMsg()
		
		Switch $iMsg
			Case $Yes_Button
				$iRet_Val = 6
				ExitLoop
			Case $YesForAll_Button
				$iRet_Val = 12
				ExitLoop
			Case $No_Button, $GUI_EVENT_CLOSE
				$iRet_Val = 7
				ExitLoop
			Case $NoForAll_Button
				$iRet_Val = 14
				ExitLoop
			Case $Cancel_Button
				$iRet_Val = 2
				ExitLoop
			;Case $AutoBackFiles_Button
				;$iRet_Val = 10
				;ExitLoop
		EndSwitch
	WEnd
	
	GUISetState(@SW_ENABLE, $Parent_hWnd)
	GUIDelete($Child_hWnd)
	Opt("GUIOnEventMode", $Old_Opt_GOEM)
	
	Return $iRet_Val
EndFunc

Func __MsgBox($iFlag, $sTitle, $sText, $iTimeOut, $hWnd)
	_FixSkinActivationBug_Proc($hWnd)
	
	Local $vRet = MsgBox($iFlag, $sTitle, $sText, $iTimeOut, $hWnd)
	Return SetError(@error, @extended, $vRet)
EndFunc

;==============================================
;$iReturnMode = -1 (default) - Return array of selected files
;$iReturnMode = 1 (default) - Return string of selected files (all files returned as full file pathes)
;==============================================
Func _FileOpenDialogEx($sTitle, $sInitDir, $sFilter, $iOptions = 0, $iReturnMode = -1, $sDefaultName = '', $hWnd = 0)
	Local $sFOD_Ret = __FileOpenDialog($sTitle, $sInitDir, $sFilter, $iOptions, $sDefaultName, $hWnd)
	
	If @error Then
		Return SetError(@error, @extended, $sFOD_Ret)
	EndIf
	
	Local $sRet = ''
	Local $aSplit_Str = StringSplit($sFOD_Ret, '|')
	
	If @error Or $aSplit_Str[0] < 2 Then
		If $iReturnMode > 0 Then
			Return $sFOD_Ret
		EndIf
		
		Return $aSplit_Str
	EndIf
	
	Local $sInit_Path = StringRegExpReplace($aSplit_Str[1], '([^\\])\\*$', '\1')
	
	For $i = 2 To $aSplit_Str[0]
		$sRet &= $sInit_Path & '\' & $aSplit_Str[$i] & '|'
	Next
	
	$sRet = StringRegExpReplace($sRet, '\|+$', '')
	
	If $iReturnMode > 0 Then
		Return $sRet
	EndIf
	
	Return StringSplit($sRet, '|')
EndFunc

Func __FileOpenDialog($sTitle, $sInitDir, $sFilter, $iOptions, $sDefaultName, $hWnd)
	_FixSkinActivationBug_Proc($hWnd)
	
	Local $vRet = FileOpenDialog($sTitle, $sInitDir, $sFilter, $iOptions, $sDefaultName, $hWnd)
	Return SetError(@error, @extended, $vRet)
EndFunc

Func __FileSaveDialog($sTitle, $sInitDir, $sFilter, $iOptions, $sDefaultName, $hWnd)
	_FixSkinActivationBug_Proc($hWnd)
	
	Local $vRet = FileSaveDialog($sTitle, $sInitDir, $sFilter, $iOptions, $sDefaultName, $hWnd)
	Return SetError(@error, @extended, $vRet)
EndFunc

Func __FileSelectFolder($sDialogText, $iRootDir, $iFlag, $sInitDir, $hWnd)
	_FixSkinActivationBug_Proc($hWnd)
	
	Local $vRet = FileSelectFolder($sDialogText, $iRootDir, $iFlag, $sInitDir, $hWnd)
	Return SetError(@error, @extended, $vRet)
EndFunc

;===============================================================================
; Description: 		Find text in file.
; Parameter(s): 	$iFile - File name to search in, $Text - text to find.
;					$iMatchWholeWordFlag - flag that defines if serch will match whole word, or search all occurrences.
;					$CaseSense - Defines if the search will be case sensitive.
; Requirement(s):   AutoIt 3.2.2.0.
; Return Value(s):  On seccess - Returns 2-d array, that include fallowing elements:
; 					   $RetArr[$n][0] = The actualy whole line that include $Text.
;					   $RetArr[$n][1] = The number of line that $text was found in.
;					   $RetArr[$n][2] = The position in line that $Text was found in.
;					On failure - If given file not exists, set @error to 1 and return -1...
;					If the $Text was non found, then returns 0 (zero) and set @error on 2.
;
; Author(s):        G.Sandler a.k.a CreatoR
;===============================================================================
Func _FileFindText($sFile, $sFindText, $iMatchWholeWordFlag = 0, $iCaseSense = 0)
	If Not StringInStr($sFile, "|") And Not FileExists($sFile) Then
		Return SetError(1, 0, -1)
	EndIf
	
	Local $aFilesArr = StringSplit($sFile, "|"), $hFile
	Local $iCount = 0, $iLineN = 0, $sCurrentLine, $iMatch = 1, $iStrPos, $aRetArr[1][1]
	
	For $i = 1 To $aFilesArr[0]
		If FileExists($aFilesArr[$i]) Then
			ReDim $aRetArr[$aRetArr[0][0] + FileGetSize($aFilesArr[$i])][4]
			
			$hFile = FileOpen($aFilesArr[$i], 0)
			
			While 1
				$sCurrentLine = FileReadLine($hFile)
				
				If @error = -1 Then
					ExitLoop
				EndIf
				
				$iLineN += 1
				
				If StringIsASCII($sFindText) Then
					$iStrPos = StringInStr($sCurrentLine, $sFindText)
				Else
					$sCurrentLine = StringLower($sCurrentLine)
					$iStrPos = StringInStr($sCurrentLine, StringLower($sFindText))
					$sFindText = StringLower($sFindText)
				EndIf
				
				If StringInStr($sCurrentLine, $sFindText, $iCaseSense) Then
					If $iMatchWholeWordFlag = 1 Then
						If StringRegExp($sCurrentLine, "(\A|\s)\Q" & $sFindText & "\E(\z|\s)") Then
							$iStrPos = StringInStr($sCurrentLine, StringRegExpReplace($sCurrentLine, ".*?(\A|\s)(.?\Q" & $sFindText & "\E.?)(\z|\s).*?", "\1"), $iCaseSense)
							$iMatch = 1
						Else
							$iMatch = 0
						EndIf
					Else
						$iMatch = 1
					EndIf
					
					If $iMatch = 1 Then
						$aRetArr[0][0] += 1
						$aRetArr[$aRetArr[0][0]][0] = $aFilesArr[$i]
						$aRetArr[$aRetArr[0][0]][1] = $sCurrentLine
						$aRetArr[$aRetArr[0][0]][2] = $iLineN
						$aRetArr[$aRetArr[0][0]][3] = $iStrPos
					EndIf
				EndIf
			WEnd
			
			FileClose($hFile)
		EndIf
	Next
	
	If $aRetArr[0][0] < 1 Then
		Return SetError(2, 0, 0)
	EndIf
	
	ReDim $aRetArr[$aRetArr[0][0]+1][4]
	Return $aRetArr
EndFunc

Func _FileGetValidName($sString, $sPattern = '[*?\\/|:<>"]', $sReplace = '_')
	If StringStripWS($sString, 8) = '' Then Return $sString
	
	$sString = StringRegExpReplace($sString, $sPattern, $sReplace)
	Return SetExtended(@extended, StringRegExpReplace($sString, '(' & $sReplace & '+)', $sReplace))
EndFunc

Func _FixSkinActivationBug_Proc($hWnd, $iActivateAfter = 1)
	If $iSet_OnTop <> 1 Or $iUse_Skin_For_GUI = 0 Then
		Return
	EndIf
	
	If $iActivateAfter = 1 Then
		Run(@AutoItExe & ' /AutoIt3ExecuteLine "If Sleep(10) Then WinActivate(Hwnd(' & $hWnd & '))"')
	Else
		WinActivate($hWnd)
	EndIf
EndFunc

Func _IniReadSectionNamesEx($sIniFile)
	Local $aFileReadArr = StringSplit(StringStripCR(FileRead($sIniFile)), @LF)
	If @error Then Return SetError(1, 0, "")
	
	Local $aRetArr[$aFileReadArr[0]+1], $iUbound, $iSplitPos, $sKey, $sValue
	
	For $i = 1 To $aFileReadArr[0]
		If StringRegExp($aFileReadArr[$i], "^\s*\[.+\]") Then
			$aRetArr[0] += 1
			$aRetArr[$aRetArr[0]] = StringRegExpReplace($aFileReadArr[$i], "^\s*\[(.+)\].*", "\1")
		EndIf
	Next
	
	ReDim $aRetArr[$aRetArr[0]+1]
	Return $aRetArr
EndFunc

Func _IniRenameSectionEx($sIniFile, $sSectionName, $sNewSectionName, $iFlag = 0, $iCaseSense = 0)
	Local $iRename_Section = IniRenameSection($sIniFile, $sSectionName, $sNewSectionName, $iFlag)
	
	If $iRename_Section And Not @error Then
		Return $iRename_Section
	EndIf
	
	If _IniSectionExists($sIniFile, $sNewSectionName, $iCaseSense) Then
		Return SetError(1, 0, 0)
	EndIf
	
	Local $aNew_Ini = StringRegExpReplace(FileRead($sIniFile), "\[" & $sSectionName & "\]", "[" & $sNewSectionName & "]", 1)
	$iRename_Section = @extended
	
	If $iRename_Section < 1 Then
		Return SetError(1, 0, 0)
	EndIf
	
	Local $hFOpen = FileOpen($sIniFile, 2)
	FileWrite($hFOpen, $aNew_Ini)
	
	Return FileClose($hFOpen)
EndFunc

Func _IniSectionExists($sIniFile, $sSectionName, $iCaseSense = 0)
	If Not FileExists($sIniFile) Then
		Return SetError(1, 0, 0)
	EndIf
	
	Local $aSection_Names = _IniReadSectionNamesEx($sIniFile)
	
	For $i = 1 To UBound($aSection_Names)-1
		If StringCompare($aSection_Names[$i], $sSectionName, $iCaseSense) = 0 Then
			Return 1
		EndIf
	Next
	
	Return 0
EndFunc

Func _IniSectionIsEmpty($sIniFile, $sSectionName)
	If Not FileExists($sIniFile) Then
		Return SetError(1, 0, 0)
	EndIf
	
	If Not _IniSectionExists($sIniFile, $sSectionName) Then
		Return SetError(1, 0, 0)
	EndIf
	
	IniReadSection($sIniFile, $sSectionName)
	Return Number(@error = 1)
EndFunc

Func _String_GetFormattedTime($aF_Time)
	If UBound($aF_Time) < 6 Then
		Return SetError(1, 0, "")
	EndIf
	
	Return $aF_Time[2] & "/" & $aF_Time[1] & "/" & $aF_Time[0] & ", " & $aF_Time[3] & ":" & $aF_Time[4] & ":" & $aF_Time[5]
EndFunc

Func _String_GetFormattedSize($iByteSize, $iRound = 2, $sRetFormat = -1)
	Local $asBytes[9] = [8, $aTXT[$iMSG_KB_1], $aTXT[$iMSG_MB_1], $aTXT[$iMSG_GB_1], $aTXT[$iMSG_TB], $aTXT[$iMSG_PB], $aTXT[$iMSG_EB], $aTXT[$iMSG_ZB], $aTXT[$iMSG_YB]] ;Last two unreachable ;)
	Local $iBytes_Val = 2 ^ 10
	
	If $iByteSize < $iBytes_Val Then
		Return $iByteSize & " " & $aTXT[$iMSG_Bytes_1]
	EndIf
	
	If IsString($sRetFormat) Then
		For $i = 1 To 8
			If $sRetFormat = $asBytes[$i] Then
				Return Round($iByteSize / $iBytes_Val ^ $i, $iRound) & ' ' & $asBytes[$i]
			EndIf
		Next
	Else
		For $i = 8 To 1 Step -1
			If $iByteSize >= $iBytes_Val ^ $i Then
				Return Round($iByteSize / $iBytes_Val ^ $i, $iRound) & ' ' & $asBytes[$i]
			EndIf
		Next
	EndIf
EndFunc

Func _String_HotKeyToAccelStr($sHotKey)
	$sHotKey = StringLower(StringStripWS($sHotKey, 8))
	$sHotKey = StringRegExpReplace($sHotKey, '^\(|\)$', '')
	$sHotKey = StringReplace($sHotKey, "+", "")
	$sHotKey = StringReplace($sHotKey, "CTRL", "^")
	$sHotKey = StringReplace($sHotKey, "SHIFT", "+")
	$sHotKey = StringReplace($sHotKey, "ALT", "!")
	;$sHotKey = StringRegExpReplace($sHotKey, "(?i)(Up|Down|Del|Home|End|Ins(?:ert)?)", "{\1}")
	$sHotKey = StringRegExpReplace($sHotKey, "([^\^+!]+)$", "{\1}")
	
	Return $sHotKey
EndFunc

Func _DroppedFileIsValidExt($sPath, $aAllowed_DropExt)
	For $i = 1 To $aAllowed_DropExt[0]
		If StringRegExp($sPath, '(?i)\Q' & $aAllowed_DropExt[$i] & '\E$') Or StringInStr(FileGetAttrib($sPath), $aAllowed_DropExt[$i]) Then
			Return True
		EndIf
	Next
	
	Return False
EndFunc

Func _DroppedFileGetValidExt($aAllowed_DropExt)
	Local $sRet = "", $sCurrent_Ext
	
	For $i = 1 To $aAllowed_DropExt[0]
		$sCurrent_Ext = $aAllowed_DropExt[$i]
		
		If StringLen($sCurrent_Ext) = 1 Then
			$sCurrent_Ext = StringReplace($sCurrent_Ext, "R", "R - READONLY File")
			$sCurrent_Ext = StringReplace($sCurrent_Ext, "A", "A - ARCHIVE File")
			$sCurrent_Ext = StringReplace($sCurrent_Ext, "S", "S - SYSTEM File")
			$sCurrent_Ext = StringReplace($sCurrent_Ext, "H", "H - HIDDEN File")
			$sCurrent_Ext = StringReplace($sCurrent_Ext, "N", "N - NORMAL File")
			$sCurrent_Ext = StringReplace($sCurrent_Ext, "O", "O - OFFLINE File")
			$sCurrent_Ext = StringReplace($sCurrent_Ext, "T", "T - TEMPORARY File")
			$sCurrent_Ext = StringReplace($sCurrent_Ext, "D", "D - DIRECTORY")
		EndIf
		
		$sRet &= $sCurrent_Ext
		
		If $i < $aAllowed_DropExt[0] Then
			$sRet &= ", "
		EndIf
	Next
	
	Return $sRet
EndFunc

Func _Dropped_Event_Handler($iDropID)
	Local $sNotValidExtPath = "", $aScriptsList[$aDropped_Files[0]+1][2]
	Local $iValidExtCount = 0
	
	Local $aScripts
	Local $sCurrent_Category = _GetCurrentCategory_Proc()
	Local $iIndex = @extended
	
	If $iDropID = $Category_LV Then
		ControlListView($hMain_GUI, "", $Category_LV, "SelectClear")
		
		For $i = 1 To $aDropped_Files[0]
			If StringInStr(FileGetAttrib($aDropped_Files[$i]), "D") Then
				$sCurrent_Category = StringRegExpReplace($aDropped_Files[$i], "^.*\\", "")
				
				$iFindItem = _GUICtrlListView_FindInText($Category_LV, $sCurrent_Category)
				
				If $iFindItem <> -1 Then
					_GUICtrlListView_SetItemSelected($Category_LV, $iFindItem, 1, 1)
				Else
					_AddNewCategory_Proc($sCurrent_Category)
				EndIf
				
				$aScripts = _FileListToArray($aDropped_Files[$i], "*" & $aAllowed_Scripts_DropExt[1], 1)
				If @error Then ContinueLoop
				
				Dim $aScriptsList[UBound($aScripts)][2]
				
				For $j = 1 To UBound($aScripts)-1
					If $iCopy_Scripts_To_DataBase = 1 Then
						$sScript_File = $sScripts_DataBase_Path & "\" & _FileGetValidName($sCurrent_Category) & "\" & $aScripts[$j]
						FileCopy($aDropped_Files[$i] & "\" & $aScripts[$j], $sScript_File, 8+1)
						$aDropped_Files[$i] = $sScripts_DataBase_Path
					Else
						$sScript_File = $aDropped_Files[$i] & "\" & $aScripts[$j]
					EndIf
					
					If _FindScriptInDataBase_Proc($sCurrent_Category, $sScript_File) <> -1 Then
						ContinueLoop
					EndIf
					
					$iValidExtCount += 1
					$aScriptsList[0][0] += 1
					
					$aScriptsList[$aScriptsList[0][0]][0] = ""
					$aScriptsList[$aScriptsList[0][0]][1] = $sScript_File
					
					_AddScriptToDataBase_Proc($sCurrent_Category, $sScript_File)
				Next
			Else
				$sNotValidExtPath &= $aDropped_Files[$i] & @CRLF
			EndIf
		Next
		
		ReDim $aScriptsList[$aScriptsList[0][0]+1][2]
		
		If $iValidExtCount > 0 Then
			$sLast_Category = ""
			$iCategory_Changed = 1
		EndIf
		
		If $iIndex <> -1 Then
			ControlListView($hMain_GUI, "", $Category_LV, "Select", $iIndex)
		EndIf
	Else
		If $sCurrent_Category = "" Then
			Return __MsgBox(48, $aTXT[$iMSG_Attention_5], $aTXT[$iMSG_CanNotAddScript_ategoryFromList], 0, $hMain_GUI)
		EndIf
		
		If _CategoryIsGroup($sCurrent_Category) Then
			Return __MsgBox(48, $aTXT[$iMSG_Attention_6], $aTXT[$iMSG_CanNotAddScript_istIsAGroup], 0, $hMain_GUI)
		EndIf
		
		ControlListView($hMain_GUI, "", $Scripts_LV, "SelectClear")
		
		For $i = 1 To $aDropped_Files[0]
			If _DroppedFileIsValidExt($aDropped_Files[$i], $aAllowed_Scripts_DropExt) Then
				$iFindItem = _GUICtrlListView_FindInText($Scripts_LV, $aDropped_Files[$i])
				
				If $iFindItem <> -1 Then
					_GUICtrlListView_SetItemSelected($Scripts_LV, $iFindItem, 1)
					ContinueLoop
				EndIf
				
				If $iCopy_Scripts_To_DataBase = 1 Then
					$sScriptName = StringRegExpReplace($aDropped_Files[$i], "^.*\\", "")
					$sScript_File = $sScripts_DataBase_Path & "\" & _FileGetValidName($sCurrent_Category) & "\" & $sScriptName
					FileCopy($aDropped_Files[$i], $sScript_File, 8+1)
					$aDropped_Files[$i] = $sScript_File
				EndIf
				
				$iValidExtCount += 1
				$aScriptsList[0][0] += 1
				
				$aScriptsList[$aScriptsList[0][0]][0] = ""
				$aScriptsList[$aScriptsList[0][0]][1] = $aDropped_Files[$i]
				
				_AddScriptToDataBase_Proc($sCurrent_Category, $aDropped_Files[$i])
			Else
				$sNotValidExtPath &= $aDropped_Files[$i] & @CRLF
			EndIf
		Next
		
		ReDim $aScriptsList[$aScriptsList[0][0]+1][2]
		
		If $iValidExtCount > 0 Then
			_AddScriptsToList_Proc($aScriptsList, 1, 1)
		EndIf
	EndIf
	
	If $sNotValidExtPath <> "" Then
		__MsgBox(262144+48, $aTXT[$iMSG_Attention_7], _
			StringFormat($aTXT[$iMSG_YouDroppedFiles_TheseAreValidS], _
			$sNotValidExtPath, _DroppedFileGetValidExt(_Iif($iDropID = $Category_LV, $aAllowed_Category_DropExt, $aAllowed_Scripts_DropExt))), 0, $hMain_GUI)
	EndIf
	
	$aDropped_Files = 0
EndFunc

Func WM_DROPFILES($hWnd, $msgID, $wParam, $lParam)
	$aDropped_Files = _WinAPI_DragQueryFileEx($wParam)
	;_WinAPI_DragFinish($wParam)
EndFunc

Func WM_NOTIFY($hWnd, $iMsg, $wParam, $lParam)
	Local $hWndFrom, $iIDFrom, $iCode, $tNMHDR
	
	$tNMHDR = DllStructCreate($tagNMHDR, $lParam)
	
	$hWndFrom = HWnd(DllStructGetData($tNMHDR, "hWndFrom"))
	$iIDFrom = DllStructGetData($tNMHDR, "IDFrom")
	$iCode = DllStructGetData($tNMHDR, "Code")
	
	Switch $hWndFrom
		Case $hScripts_LV, $hCategory_LV
			Switch $iCode
				Case $LVN_COLUMNCLICK ; A column was clicked
					Local $iItems_Count = _GUICtrlListView_GetItemCount($hWndFrom)
					
					If $iItems_Count < 1 Or $hWndFrom <> $hScripts_LV Then
						Return $GUI_RUNDEFMSG
					EndIf
					
					Local $tInfo = DllStructCreate($tagNMLISTVIEW, $lParam)
					Local $iSubItem = DllStructGetData($tInfo, "SubItem")
					
					_GUICtrlListView_SortItems($hWndFrom, $iSubItem)
					
					If $iUse_Skin_For_GUI = 1 Then
						_GUICtrlHeader_SetItemFormat($hLV_Header, $aListViewSortInfo[1][4], $HDF_STRING)
						_GUICtrlHeader_SetItemFormat($hLV_Header, $iSubItem, BitOR($HDF_STRING, $HDF_IMAGE, $HDF_BITMAP_ON_RIGHT))
						
						If $aListViewSortInfo[1][5] <> 1 Then
							_GUICtrlHeader_SetItemImage($hLV_Header, $iSubItem, 1)
						Else
							_GUICtrlHeader_SetItemImage($hLV_Header, $iSubItem, 2)
						EndIf
					EndIf
				Case $LVN_ITEMCHANGED ;Sent by a list-view control when the item is chamged
					If $hWndFrom = $hCategory_LV Then
						$iCategory_Changed = True
						
						Local $iIndex = _GUICtrlListView_GetSelectedIndices($Category_LV)
						
						If $iIndex = "" Then
							Return $GUI_RUNDEFMSG
						EndIf
						
						$iIndex = Number($iIndex)
						
						Local $sCurrent_Category = _GUICtrlListView_GetItemText($Category_LV, $iIndex)
						
						If Not _CategoryIsGroup($sCurrent_Category) Then
							$iLast_Sel_Category_Indx = $iIndex
						EndIf
					EndIf
				Case $LVN_BEGINDRAG ;A drag-and-drop operation involving the left mouse button is being initiated
					Return 1
				Case $NM_DBLCLK ;Sent by a list-view control when the user double-clicks an item with the left mouse button
					If $hWndFrom = $hScripts_LV Then
						$iDouble_Clicked_Event = True
					EndIf
			EndSwitch
	EndSwitch
	
	Return $GUI_RUNDEFMSG
EndFunc

Func WM_COMMAND($hWnd, $iMsg, $wParam, $lParam)
	If $hWnd = 0 Or Not WinExists($hWnd) Then
		Return $GUI_RUNDEFMSG
	EndIf
	
	Local $nNotifyCode = BitShift($wParam, 16)
	Local $nID = BitAND($wParam, 0xFFFF)
	
	If $nNotifyCode = $EN_UPDATE Then
		Switch $nID
			Case $Filter_Input
				If StringCompare(GUICtrlRead($Filter_Input), $sOld_Filter_Text, 1) <> 0 Then
					$iInput_Changed = True
				EndIf
			Case Else
				If $hWnd = $hSetting_GUI Then
					GUICtrlSetState($iSettings_OK_Button, $GUI_ENABLE)
				EndIf
		EndSwitch
	EndIf
	
	Return $GUI_RUNDEFMSG
EndFunc

Func WM_NCHITTEST($hWnd, $iMsg, $wParam, $lParam)
	If _WinAPI_GetParent($hWnd) = $__AboutBox_hAboutGUI Then
		Return $GUI_RUNDEFMSG
	EndIf
	
    Local $iRet = _WinAPI_DefWindowProc($hWnd, $iMsg, $wParam, $lParam)
    
    If $iRet = 1 Then
        Return 2
    EndIf
    
    Return $iRet
EndFunc

Func WM_SYSCOMMAND($hWnd, $Msg, $wParam, $lParam)
	If $hWnd <> $hMain_GUI Then
		Return $GUI_RUNDEFMSG
	EndIf
	
	Switch BitAND($wParam, 0xFFF0)
		Case $SC_SIZE, $SC_MOVE
			Local Const $SPI_SETDRAGFULLWINDOWS = 37, $SPI_GETDRAGFULLWINDOWS = 38, $SPIF_SENDWININICHANGE = 2
			Local $iDragParam = 0
			
			If BitAND($wParam, 0xFFF0) = $SC_MOVE Then
				$iDragParam = 1
			EndIf
			
			DllCall("user32.dll", "int", "SystemParametersInfo", "int", $SPI_SETDRAGFULLWINDOWS, "int", $iDragParam, "ptr", 0, "int", 2)
	EndSwitch
EndFunc
    
Func WM_EXITSIZEMOVE($hWnd, $Msg, $wParam, $lParam)
	If $hWnd <> $hMain_GUI Then
		Return $GUI_RUNDEFMSG
	EndIf
	
	Local $iDragFullWindows = RegRead("HKEY_CURRENT_USER\Control Panel\Desktop", "DragFullWindows")
    DllCall("user32.dll", "int", "SystemParametersInfo", "int", 37, "int", $iDragFullWindows, "ptr", 0, "int", 2)
	_WinAPI_RedrawWindow($hMain_GUI, 0, 0, BitOR($RDW_ALLCHILDREN, $RDW_INVALIDATE))
EndFunc

Func WM_WINDOWPOSCHANGING($hWnd, $Msg, $wParam, $lParam)
	If $hWnd <> $hMain_GUI Then
		Return $GUI_RUNDEFMSG
	EndIf
	
	Local $stWinPos 		= DllStructCreate("uint;uint;int;int;int;int;uint", $lParam)
	Local $nLeft   			= DllStructGetData($stWinPos, 3)
	Local $nTop    			= DllStructGetData($stWinPos, 4)
	
	Local $aCurWinPos 		= WinGetPos($hWnd)
	Local $aWorkArea 		= _WinAPI_GetWorkingArea()
	
	;Left
	If Abs($aWorkArea[0] - $nLeft) <= $iGUIStick_Range Then DllStructSetData($stWinPos, 3, $aWorkArea[0])
	;Right
	If Abs($nLeft + $aCurWinPos[2] - $aWorkArea[2]) <= $iGUIStick_Range Then DllStructSetData($stWinPos, 3, $aWorkArea[2] - $aCurWinPos[2])
	;Top
	If Abs($aWorkArea[1] - $nTop) <= $iGUIStick_Range Then DllStructSetData($stWinPos, 4, $aWorkArea[1])
	;Bottom
	If Abs($nTop + $aCurWinPos[3] - $aWorkArea[3]) <= $iGUIStick_Range Then DllStructSetData($stWinPos, 4, $aWorkArea[3] - $aCurWinPos[3])
	
	If $iGUIStick_To_All = 0 Then Return 0
	
	Local $ahWnd = WinList()
	Local $aStickWinPos, $XPoint, $YPoint
	
	For $i = 1 To UBound($ahWnd) - 1
		If $ahWnd[$i][1] = $hWnd Or Not BitAND(WinGetState($ahWnd[$i][1]), 2) Then
			ContinueLoop
		EndIf
		
		$aStickWinPos = WinGetPos($ahWnd[$i][1])
		
		If UBound($aStickWinPos) < 3 Then
			ContinueLoop
		EndIf
		
		$XPoint = $aStickWinPos[0]+15
		$YPoint = $aStickWinPos[1]+15
		
		If $XPoint < 0 Then
			$XPoint = 5
		EndIf
		
		If $YPoint < 0 Then
			$YPoint = 5
		EndIf
		
		If $aCurWinPos[1] + $aCurWinPos[3] >= $aStickWinPos[1] And $aCurWinPos[1] <= $aStickWinPos[1] + $aStickWinPos[3] Then
			;Left
			If Abs(($aStickWinPos[0] + $aStickWinPos[2]) - $nLeft) <= $iGUIStick_Range And _WinAPI_GetWindowFromPoint($XPoint, $YPoint) = $ahWnd[$i][1] Then
				DllStructSetData($stWinPos, 3, $aStickWinPos[0] + $aStickWinPos[2])
			EndIf
			;Right
			If Abs($nLeft + $aCurWinPos[2] - $aStickWinPos[0]) <= $iGUIStick_Range And _WinAPI_GetWindowFromPoint($XPoint, $YPoint) = $ahWnd[$i][1] Then
				DllStructSetData($stWinPos, 3, $aStickWinPos[0] - $aCurWinPos[2])
			EndIf
		EndIf
		
		If $aCurWinPos[0] + $aCurWinPos[2] >= $aStickWinPos[0] And $aCurWinPos[0] <= $aStickWinPos[0] + $aStickWinPos[2] Then
			;Top
			If Abs(($aStickWinPos[1] + $aStickWinPos[3]) - $nTop) <= $iGUIStick_Range And _WinAPI_GetWindowFromPoint($XPoint, $YPoint) = $ahWnd[$i][1] Then
				DllStructSetData($stWinPos, 4, $aStickWinPos[1] + $aStickWinPos[3])
			EndIf
			;Bottom
			If Abs($nTop + $aCurWinPos[3] - $aStickWinPos[1]) <= $iGUIStick_Range And _WinAPI_GetWindowFromPoint($XPoint, $YPoint) = $ahWnd[$i][1] Then
				DllStructSetData($stWinPos, 4, $aStickWinPos[1] - $aCurWinPos[3])
			EndIf
		EndIf
	Next
	
	Return 0
EndFunc

Func WM_ENTERMENULOOP($hWnd, $Msg, $wParam, $lParam)
	Local $iCtrlID = _Iif(ControlGetHandle($hWnd, '', ControlGetFocus($hWnd)) = $hScripts_LV, $Scripts_LV, $Category_LV)
	Local $iState = _Iif(_GUICtrlListView_GetSelectedCount($iCtrlID) = 0, $GUI_DISABLE, $GUI_ENABLE)
	
	Switch $iCtrlID
		Case $Scripts_LV
			GUICtrlSetState($Copy_ScriptTo_MenuItem, $iState)
			GUICtrlSetState($Copy_ScriptToCategory_MenuItem, $iState)
			GUICtrlSetState($Run_ScriptFile_MenuItem, $iState)
			GUICtrlSetState($Edit_ScriptFile_MenuItem, $iState)
			GUICtrlSetState($Rename_ScriptFile_MenuItem, $iState)
			GUICtrlSetState($Delete_ScriptFile_MenuItem, $iState)
			GUICtrlSetState($Remove_ScriptFromList_MenuItem, $iState)
			GUICtrlSetState($Copy_ScriptPath_MenuItem, $iState)
			GUICtrlSetState($Copy_ScriptName_MenuItem, $iState)
			GUICtrlSetState($Copy_ScriptInfo_MenuItem, $iState)
			GUICtrlSetState($Open_ScriptDir_MenuItem, $iState)
			GUICtrlSetState($Search_ScriptOnAutoItScriptCom_MenuItem, $iState)
			GUICtrlSetState($Search_ScriptOnAutoItScriptRu_MenuItem, $iState)
		Case $Category_LV
			GUICtrlSetState($MoveUpItem_MenuItem, $iState)
			GUICtrlSetState($MoveDownItem_MenuItem, $iState)
			GUICtrlSetState($RemoveCategory_MenuItem, $iState)
			GUICtrlSetState($ClearCategory_MenuItem, $iState)
			GUICtrlSetState($RenameCategory_MenuItem, $iState)
	EndSwitch
	
	_WinAPI_RedrawWindow($hScripts_LV)
	_WinAPI_RedrawWindow($hCategory_LV)
	
	Return $GUI_RUNDEFMSG
EndFunc

Func _ASC_WM_MEASUREITEM($stMeasureItem)
	If DllStructGetData($stMeasureItem, 1) = $ODT_LISTVIEW Then
		;Set height of the item's (text and background)
		DllStructSetData($stMeasureItem, 5, 15)
		DllStructSetData($stMeasureItem, 4, DllStructGetData($stMeasureItem, 4) + 15)
	EndIf

	Return $GUI_RUNDEFMSG
EndFunc

Func _ASC_WM_DRAWITEM($stDrawItem)
	If DllStructGetData($stDrawItem, 1) <> $ODT_LISTVIEW Then Return $GUI_RUNDEFMSG
	
	$cID = DllStructGetData($stDrawItem, "cID")
	$itmID = DllStructGetData($stDrawItem, "itmID")
	$itmAction = DllStructGetData($stDrawItem, "itmAction")
	$itmState = DllStructGetData($stDrawItem, "itmState")
	$hItm = DllStructGetData($stDrawItem, "hItm")
	$hDC = DllStructGetData($stDrawItem, "hDC")
	
	Switch $itmAction
		Case $ODA_DRAWENTIRE, $ODA_SELECT
			Local $iDef_BkColor = 0XFFFFFF
			If $iUse_Skin_For_GUI = 1 Then $iDef_BkColor = 0xF0F0F0
			
			;get the text to be drawn
			Local $itmText = _GUICtrlListView_GetItemText($hItm, $itmID)
			Local $iBrushColor = $iDef_BkColor, $iTxtColor = 0x000000
			Local $iItem_Selected = $itmState = $ODS_SELECTED Or $itmState = 17 Or $itmState = BitOR($ODS_SELECTED, $ODS_NOACCEL, $ODS_NOFOCUSRECT)
			
			If $iItem_Selected Then
				$iBrushColor = _WinAPI_GetSysColor($COLOR_HIGHLIGHT)
				$iTxtColor = 0xFFFFFF
			EndIf
			
			If StringRegExp($itmText, $sGroup_RegExp) Then
				$iBrushColor = $iDef_BkColor
				If $iItem_Selected Then $iBrushColor = 0x000000
				$iTxtColor = 0x787878
				
				Local $iItem_H = DllStructGetData($stDrawItem, "itmRect", 4) - DllStructGetData($stDrawItem, "itmRect", 2)
				Local $iItem_W = DllStructGetData($stDrawItem, "itmRect", 1) + DllStructGetData($stDrawItem, "itmRect", 3)
				
				Local $hFont = _WinAPI_CreateFont($iItem_H, $iItem_W, 0, 0, 800, 0, 1, 0, Default, Default, Default, $ANTIALIASED_QUALITY)
				Local $hFontOld = _WinAPI_SelectObject($hDC, $hFont)
				
				_WinAPI_DeleteObject($hFont)
			EndIf
			
			Local $hBrush = _WinAPI_CreateSolidBrush($iBrushColor)
			Local $hBrushOld = _WinAPI_SelectObject($hDC, $hBrush)
			
			_WinAPI_SetTextColor($hDC, $iTxtColor)
			_WinAPI_FillRect($hDC, DllStructGetPtr($stDrawItem, "itmRect"), $hBrush)
			_WinAPI_SelectObject($hDC, $hBrushOld)
			_WinAPI_DeleteObject($hBrush)
			_WinAPI_SetBkMode($hDC, 1)
			
			Local $tRECT = DllStructCreate("int Left;int Top;int Right;int Bottom")
			DllStructSetData($tRECT, "Left", DllStructGetData($stDrawItem, "itmRect", 1) + 5)
			DllStructSetData($tRECT, "Top", DllStructGetData($stDrawItem, "itmRect", 2))
			DllStructSetData($tRECT, "Right", DllStructGetData($stDrawItem, "itmRect", 3))
			DllStructSetData($tRECT, "Bottom", DllStructGetData($stDrawItem, "itmRect", 4))
			
			_WinAPI_DrawText($hDC, $itmText, $tRECT, BitOR($DT_LEFT, $DT_HIDEPREFIX, $DT_EXPANDTABS, $DT_NOPREFIX))
			
			Return 1
		Case $ODA_FOCUS
			Return 1
	EndSwitch
EndFunc

Func _WinAPI_LoadKeyboardLayoutEx($sLayoutID, $hWnd = 0)
	Local Const $WM_INPUTLANGCHANGEREQUEST = 0x50
	Local $aRet = DllCall("user32.dll", "long", "LoadKeyboardLayoutW", "wstr", Hex($sLayoutID, 8), "int", 0)
	
	If Not @error And $aRet[0] Then
		If $hWnd = 0 Then
			$hWnd = WinGetHandle(AutoItWinGetTitle())
		EndIf
		
		DllCall("user32.dll", "ptr", "SendMessage", "hwnd", $hWnd, "int", $WM_INPUTLANGCHANGEREQUEST, "uint_ptr", 1, "uint_ptr", $aRet[0])
		Return 1
	EndIf
	
	Return SetError(1)
EndFunc

Func _WinAPI_GetWindowFromPoint($iX, $iY)
	Local $tPoint = DllStructCreate('X int;Y int')
	
	DllStructSetData($tPoint, 'X', $iX)
	DllStructSetData($tPoint, 'Y', $iY)
	
	Return _WinAPI_WindowFromPoint($tPoint)
EndFunc

Func _WinAPI_GetWorkingArea()
	Local Const $SPI_GETWORKAREA = 48
	Local $stRECT = DllStructCreate("long; long; long; long")
	
	Local $SPIRet = DllCall("User32.dll", "int", "SystemParametersInfo", "uint", $SPI_GETWORKAREA, "uint", 0, "ptr", DllStructGetPtr($stRECT), "uint", 0)
	If @error Then Return 0
	If $SPIRet[0] = 0 Then Return 0
	
	Local $sLeftArea = DllStructGetData($stRECT, 1)
	Local $sTopArea = DllStructGetData($stRECT, 2)
	Local $sRightArea = DllStructGetData($stRECT, 3)
	Local $sBottomArea = DllStructGetData($stRECT, 4)
	
	Local $aRet[4] = [$sLeftArea, $sTopArea, $sRightArea, $sBottomArea]
    Return $aRet
EndFunc

Func _WinGetMetrics($hWnd)
	Local $aWinPos, $aWinClientSize, $aRet[2]
	
	$aWinPos = WinGetPos($hWnd)
	$aWinClientSize = WinGetClientSize($hWnd)
	
	$aRet[0] = ($aWinPos[2] - $aWinClientSize[0]) / 2 ;Border size
	$aRet[1] = $aWinPos[3] - $aWinClientSize[1] - ($aRet[0] * 2) ;Caption height
	
	Return $aRet
EndFunc

Func _ASC_PreventSecondCopy()
	;Unique(?) window title
	Local $sTitle = @ScriptName & "_!@#$%^&*()_+_)(*&^%$#@!_"
	
	If WinExists($sTitle) Then
		If BitAND(WinGetState($sApp_FullTitle), 2) Then
			WinActivate($sApp_FullTitle)
			Exit
		EndIf
	EndIf
	
	AutoItWinSetTitle($sTitle)
EndFunc

Func _ASC_Exit()
	_GUICtrlListView_UnRegisterSortCallBack($hScripts_LV)
	
	If Not IsArray($aGUI_Last_Pos) Then
		$aGUI_Last_Pos = WinGetPos($hMain_GUI)
	EndIf
	
	If UBound($aGUI_Last_Pos) = 4 Then
		$iGUI_Left = $aGUI_Last_Pos[0]
		$iGUI_Top = $aGUI_Last_Pos[1]
		$iGUI_Width = $aGUI_Last_Pos[2]
		$iGUI_Height = $aGUI_Last_Pos[3]
		
		If $iGUI_Left = -1 Then $iGUI_Left = 0
		If $iGUI_Top = -1 Then $iGUI_Top = 0
		
		IniWrite($sConfig_File, "Window Settings", "Left", $iGUI_Left)
		IniWrite($sConfig_File, "Window Settings", "Top", $iGUI_Top)
		IniWrite($sConfig_File, "Window Settings", "Width", $iGUI_Width)
		IniWrite($sConfig_File, "Window Settings", "Height", $iGUI_Height)
	EndIf
EndFunc

#EndRegion Functions
