#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Icon=kworldclock.ico
#AutoIt3Wrapper_Res_requestedExecutionLevel=asInvoker
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
#cs ----------------------------------------------------------------------------

	Name: 			TimeSync v2.0 BETA2
	AutoIt Version: 3.3.6.1
	Author:         Sky-WaLkeR

	Script Function:
	Sync time with TimeSync!
	Now with NTP support and settings GUI!

	!!! ATTENTION !!!
	This is a BETA release, so maybe there are few bugs in code.
	If you find some, send me e-mail shadowalker.main@gmail.com

#ce ----------------------------------------------------------------------------

#include <Date.au3>
#include <GUIConstantsEx.au3>
#include <EditConstants.au3>
#include <WindowsConstants.au3>
#include <GIFAnimation.au3>

Dim $NTP_Server[4] = ['time.nist.gov', 'pool.ntp.org', 'ntp.amnic.net', 'ntp.stairweb.de'], $NTP_IP[4], $NTPIP[4]

Global $gui_sync, $x, $y, $label_sync, $label_sync_status, $gif

$height = 240
$width = 180
$width_sync = 180
$height_sync = 48

$speed = 25
$count_end = (@DesktopWidth / 2 + ($width_sync / 2)) / $speed
$count = (@DesktopWidth / 2 - ($width_sync / 2)) / $speed

$settings = my_GetConfFromFile()

If $settings[3] = 'YES' Or $settings[3] = '~~~' Then
	If Not FileExists('ajax.gif') Then FileInstall('ajax.gif', 'ajax.gif')

	$Form1 = GUICreate("TimeSync", $width, $height, -1, -1, $WS_POPUP)
	_GuiRoundCorners($Form1, 0, 0, 20, 20)
	GUISetBkColor(0x000000)

	GUICtrlCreatePic('',0,0,$width,20,-1,$GUI_WS_EX_PARENTDRAG)

	$label_caption = GUICtrlCreateLabel("TimeSync v2.0", 60, 8, 160, 17)
	GUICtrlSetColor(-1, 0xFFFFFF)

	$group_connect = GUICtrlCreateGroup(' ', 6, 35, 168, 40)
	GUICtrlSetColor(-1, 0xFFFFFF)
	$label_connect = GUICtrlCreateLabel(' ', 14, 35)
	GUICtrlSetColor(-1, 0xFFFFFF)

	$radio_ntp = GUICtrlCreateRadio('NTP', 10, 52, 12, 20)
	$label_ntp = GUICtrlCreateLabel('NTP', 24, 56, 30, 17)
	GUICtrlSetColor(-1, 0xFFFFFF)

	$radio_http = GUICtrlCreateRadio('HTTP', 64, 52, 12, 20)
	$label_http = GUICtrlCreateLabel('HTTP', 78, 54, 80, 17)
	GUICtrlSetColor(-1, 0xFFFFFF)

	$label_proxy = GUICtrlCreateLabel(': (  - )', 8, 84)
	GUICtrlSetColor(-1, 0xFFFFFF)
	$input_proxy = GUICtrlCreateInput('', 6, 100, 168)
	GUICtrlSetColor(-1, 0xFFFFFF)
	GUICtrlSetBkColor(-1, 0x000000)

	$check_sound = GUICtrlCreateCheckbox('   ', 6, 130, 12)
	$label_sound = GUICtrlCreateLabel('   ', 22, 134, 156)
	GUICtrlSetColor(-1, 0xFFFFFF)

	$check_gui = GUICtrlCreateCheckbox(' ', 6, 150, 12)
	$label_gui = GUICtrlCreateLabel(' ', 22, 154, 156)
	GUICtrlSetColor(-1, 0xFFFFFF)

	$check_settings = GUICtrlCreateCheckbox(' ', 6, 170, 12)
	$label_settings = GUICtrlCreateLabel(' ', 22, 174, 156)
	GUICtrlSetColor(-1, 0xFFFFFF)

	$button_start = GUICtrlCreateButton('', 6, 200, 80)
	GUICtrlSetColor(-1, 0xFFFFFF)
	GUICtrlSetBkColor(-1, 0x000000)

	$button_cancel = GUICtrlCreateButton('', 90, 200, 80)
	GUICtrlSetColor(-1, 0xFFFFFF)
	GUICtrlSetBkColor(-1, 0x000000)
	;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

	If $settings[0] = 'NTP' Or $settings[0] = '~~~' Then
		GUICtrlSetState($radio_ntp, $gui_checked)
		GUICtrlSetColor($label_proxy, 0x999999)
		GUICtrlSetColor($input_proxy, 0x999999)
		GUICtrlSetBkColor($input_proxy, 0x555555)
		GUICtrlSetStyle($input_proxy, $ES_READONLY)
	ElseIf $settings[0] = "HTTP" Then
		GUICtrlSetState($radio_http, $gui_checked)
	EndIf
	If $settings[1] <> 'NONE' Then
		GUICtrlSetData($input_proxy, $settings[1])
	EndIf
	If $settings[2] = 'NO' Or $settings[2] = '~~~' Then
		GUICtrlSetState($check_gui, $gui_checked)
	EndIf
	If $settings[3] = 'YES' Or $settings[3] = '~~~' Then
		GUICtrlSetState($check_settings, $gui_checked)
	EndIf
	If $settings[4] = 'YES' Or $settings[4] = '~~~' Then
		GUICtrlSetState($check_sound, $gui_checked)
	EndIf
	;-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

	WinSetTrans($Form1, '', 0)
	GUISetState(@SW_SHOW)
	For $i = 1 To 255 Step 5
		WinSetTrans($Form1, '', $i)
		Sleep(10)
	Next

	While 1
		$msg = GUIGetMsg()
		Select
			Case $msg = $button_cancel
				For $i = 1 To 255 Step 5
					WinSetTrans($Form1, '', 255 - $i)
					Sleep(10)
				Next
				GUIDelete($Form1)
				Exit


			Case $msg = $button_start
				$conf = my_GetConfFromGUI()
				my_SaveConf($conf)
				$settings = my_GetConfFromFile()
				If $settings[2] = 'NO' Then
					my_GuiCreate(1)
				Else
					For $i = 1 To 255 Step 5
						WinSetTrans($Form1, '', 255 - $i)
						Sleep(10)
					Next
					GUIDelete($Form1)
				EndIf
				my_SyncTime()
				If $settings[2] = 'NO' Then my_GuiDelete()
				Exit


			Case $msg = $radio_ntp
				GUICtrlSetState($radio_ntp, $gui_checked)
				GUICtrlSetColor($label_proxy, 0x999999)
				GUICtrlSetColor($input_proxy, 0x999999)
				GUICtrlSetBkColor($input_proxy, 0x555555)
				GUICtrlSetStyle($input_proxy, $ES_READONLY)
			Case $msg = $radio_http
				GUICtrlSetState($radio_http, $gui_checked)
				GUICtrlSetColor($label_proxy, 0xffffff)
				GUICtrlSetColor($input_proxy, 0xffffff)
				GUICtrlSetBkColor($input_proxy, 0x000000)
				GUICtrlSetStyle($input_proxy, $ES_LEFT)

		EndSelect
		Sleep(50)
	WEnd
ElseIf $settings[3] = 'NO' Then
	If $settings[2] = 'NO' Then my_GuiCreate(0)
	my_SyncTime()
	If $settings[2] = 'NO' Then my_GuiDelete()
	Exit
EndIf

Func _GuiRoundCorners($h_win, $i_x1, $i_y1, $i_x3, $i_y3)
	Dim $pos, $ret, $ret2
	$pos = WinGetPos($h_win)
	$ret = DllCall("gdi32.dll", "long", "CreateRoundRectRgn", "long", $i_x1, "long", $i_y1, "long", $pos[2], "long", $pos[3], "long", $i_x3, "long", $i_y3)
	If $ret[0] Then
		$ret2 = DllCall("user32.dll", "long", "SetWindowRgn", "hwnd", $h_win, "long", $ret[0], "int", 1)
		If $ret2[0] Then
			Return 1
		Else
			Return 0
		EndIf
	Else
		Return 0
	EndIf
EndFunc   ;==>_GuiRoundCorners

Func my_GuiCreate($flag)
	If $flag = 1 Then
		$pos = WinGetPos($Form1)
		$x = $pos[0]
		$y = $pos[1] + $height / 2 - $height_sync / 2
		$gui_sync = GUICreate('', $width_sync, $height_sync, $x, $y, $WS_POPUP)
	ElseIf $flag = 0 Then
		$x = 0 - $width_sync
		$y = @DesktopHeight / 2 - $height_sync / 2
		$gui_sync = GUICreate('', $width_sync, $height_sync, $x, $y, $WS_POPUP)
	EndIf

	_GuiRoundCorners($gui_sync, 0, 0, 20, 20)
	GUISetBkColor(0x000000)
	$label_sync = GUICtrlCreateLabel("", 8, 8, 41, 17)
	GUICtrlSetColor($label_sync, 0xFFFFFF)
	$label_sync_status = GUICtrlCreateLabel("", 8, 24, 228, 17)
	GUICtrlSetColor($label_sync_status, 0xFFFFFF)
	$gif = _GUICtrlCreateGIF("ajax.gif", "", 145, 8)
	_GUICtrlSetGIF($gif, '', '')

	If $flag = 1 Then
		WinSetTrans($gui_sync, '', 0)
		GUISetState(@SW_SHOW, $gui_sync)
		For $i = 1 To 255 Step 5
			WinSetTrans($gui_sync, '', $i)
			WinSetTrans($Form1, '', 255 - $i)
			Sleep(10)
		Next
		GUISetState(@SW_HIDE, $Form1)
	ElseIf $flag = 0 Then
		GUISetState(@SW_SHOW, $gui_sync)
		For $i = 1 To $count Step 1
			WinMove($gui_sync, '', $i * $speed, $y)
			Sleep(10)
		Next
	EndIf
EndFunc   ;==>my_GuiCreate


Func my_GuiDelete()
	$pos = WinGetPos($gui_sync)
	$x = $pos[0]
	$y = $pos[1]
	For $i = 1 To $count_end + 2 Step 1
		WinMove($gui_sync, '', $x + ($i * $speed), $y)
		Sleep(10)
	Next
EndFunc   ;==>my_GuiDelete

Func my_GetConfFromGUI()
	Dim $arr[5]
	$arr[0] = GUICtrlRead($radio_ntp)
	$arr[1] = GUICtrlRead($input_proxy)
	$arr[2] = GUICtrlRead($check_gui)
	$arr[3] = GUICtrlRead($check_settings)
	$arr[4] = GUICtrlRead($check_sound)
	Return $arr
EndFunc   ;==>my_GetConfFromGUI

Func my_GetConfFromFile()
	Dim $arr[5]
	$arr[0] = IniRead('TimeSync.ini', 'Settings', 'Type', '~~~')
	$arr[1] = IniRead('TimeSync.ini', 'Settings', 'Proxy', '~~~')
	$arr[2] = IniRead('TimeSync.ini', 'Settings', 'Silent', '~~~')
	$arr[3] = IniRead('TimeSync.ini', 'Settings', 'Settings', '~~~')
	$arr[4] = IniRead('TimeSync.ini', 'Settings', 'Sound', '~~~')
	Return $arr
EndFunc   ;==>my_GetConfFromFile

Func my_SaveConf($arr)
	$check = $arr[0] ; Type of connection
	If $check = $gui_checked Then
		IniWrite('TimeSync.ini', 'Settings', 'Type', 'NTP')
	Else
		IniWrite('TimeSync.ini', 'Settings', 'Type', 'HTTP')
	EndIf

	$check = $arr[1] ; proxy
	If $check = '' Then
		IniWrite('TimeSync.ini', 'Settings', 'Proxy', 'NONE')
	Else
		IniWrite('TimeSync.ini', 'Settings', 'Proxy', $check)
	EndIf

	$check = $arr[2] ; gui
	If $check = $gui_checked Then
		IniWrite('TimeSync.ini', 'Settings', 'Silent', 'NO')
	Else
		IniWrite('TimeSync.ini', 'Settings', 'Silent', 'YES')
	EndIf

	$check = $arr[3] ; settings
	If $check = $gui_checked Then
		IniWrite('TimeSync.ini', 'Settings', 'Settings', 'YES')
	Else
		IniWrite('TimeSync.ini', 'Settings', 'Settings', 'NO')
	EndIf

	$check = $arr[4] ; sound
	If $check = $gui_checked Then
		IniWrite('TimeSync.ini', 'Settings', 'Sound', 'YES')
	Else
		IniWrite('TimeSync.ini', 'Settings', 'Sound', 'NO')
	EndIf
EndFunc   ;==>my_SaveConf

Func check_internet_connectivity()
	TCPStartup()
	For $i = 0 To 3
		$NTPIP[$i] = TCPNameToIP($NTP_Server[$i])
		Sleep(250)
	Next
	TCPShutdown()
	Return $NTPIP
EndFunc   ;==>check_internet_connectivity
Func NTP_Connect($NTP_Server)
	UDPStartup()
	Dim $socket = UDPOpen(TCPNameToIP($NTP_Server), 123)
	$status = UDPSend($socket, MakePacket("1b0e01000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"))
	$data = ""
	While $data = ""
		$data = UDPRecv($socket, 100)
		Sleep(100)
	WEnd
	UDPCloseSocket($socket)
	UDPShutdown()
	Return $data
EndFunc   ;==>NTP_Connect
Func Set_Time($bdata)
	$unsignedHexValue = StringMid($bdata, 83, 8)
	$value = UnsignedHexToDec($unsignedHexValue)
	$TZinfo = _Date_Time_GetTimeZoneInformation()
	$UTC = _DateAdd("s", $value, "1900/01/01 00:00:00")
	If $TZinfo[0] <> 2 Then ; 0 = Daylight Savings not used in current time zone / 1 = Standard Time
		$TZoffset = ($TZinfo[1]) * - 1
	Else ; 2 = Daylight Savings Time
		$TZoffset = ($TZinfo[1] + $TZinfo[7]) * - 1
	EndIf
	$UTC = _DateAdd("n", $TZoffset, $UTC)
	$m = StringMid($UTC, 6, 2)
	$d = StringMid($UTC, 9, 2)
	$y = StringMid($UTC, 1, 4)
	$h = StringMid($UTC, 12, 2)
	$mi = StringMid($UTC, 15, 2)
	$s = StringMid($UTC, 18, 2)
	_SetDate($d, $m, $y)
	_SetTime($h, $mi, $s)
EndFunc   ;==>Set_Time
Func MakePacket($d)
	Local $p = ""
	While $d
		$p &= Chr(Dec(StringLeft($d, 2)))
		$d = StringTrimLeft($d, 2)
	WEnd
	Return $p
EndFunc   ;==>MakePacket
Func UnsignedHexToDec($n)
	$ones = StringRight($n, 1)
	$n = StringTrimRight($n, 1)
	Return Dec($n) * 16 + Dec($ones)
EndFunc   ;==>UnsignedHexToDec

Func HTTPTimeSync($proxy = 'NONE')
	If $proxy <> 'NONE' Then HttpSetProxy(2, $proxy)
	$read = BinaryToString(InetRead('http://www.time100.ru/gmt.html'), 4)
	$regexp = StringRegExp($read, '<span id="timenow">(.*?)</span>', 3)
	If @error Then Return -1
	$time = $regexp[0]
	$regexp = StringRegExp($read, '<b>(.*?)</b>', 3)
	If @error Then Return -2
	$date = $regexp[0]
	$date_split = StringSplit($date, ' ')
	$day = $date_split[1]
	$mon_word = $date_split[2]
	$year = $date_split[3]
	Switch $mon_word
		Case ''
			$mon = '01'
		Case ''
			$mon = '02'
		Case ''
			$mon = '03'
		Case ''
			$mon = '04'
		Case ''
			$mon = '05'
		Case ''
			$mon = '06'
		Case ''
			$mon = '07'
		Case ''
			$mon = '08'
		Case ''
			$mon = '09'
		Case ''
			$mon = '10'
		Case ''
			$mon = '11'
		Case ''
			$mon = '12'
	EndSwitch

	$UTC = $year & '/' & $mon & '/' & $day & ' ' & $time
	$TZinfo = _Date_Time_GetTimeZoneInformation()
	If $TZinfo[0] <> 2 Then
		$TZoffset = ($TZinfo[1]) * - 1
	Else
		$TZoffset = ($TZinfo[1] + $TZinfo[7]) * - 1
	EndIf
	$UTC = _DateAdd("n", $TZoffset, $UTC)
	$mon = StringMid($UTC, 6, 2)
	$day = StringMid($UTC, 9, 2)
	$year = StringMid($UTC, 1, 4)
	$hour = StringMid($UTC, 12, 2)
	$min = StringMid($UTC, 15, 2)
	$sec = StringMid($UTC, 18, 2)
	_SetDate($day, $mon, $year)
	_SetTime($hour, $min, $sec)
	Return 1
EndFunc   ;==>HTTPTimeSync



Func my_SyncTime()
	$beep = 500
	$beep_t = 200
	If $settings[2] = 'NO' Then
		GUICtrlSetData($label_sync, ':')
		GUICtrlSetData($label_sync_status, '  ...')
		_GUICtrlSetGIF($gif, "ajax.gif")
	EndIf
	;-=-=-=-=-=-=-=-=-=-=-=-=-=-
	If $settings[0] = 'NTP' Then ; for NTP type
		$trig = 0
		$NTP_IP = check_internet_connectivity()
		If $NTP_IP[0] <> '' Then
			$adata = NTP_Connect($NTP_Server[0])
		ElseIf $NTP_IP[1] <> '' Then
			$adata = NTP_Connect($NTP_Server[1])
		ElseIf $NTP_IP[2] <> '' Then
			$adata = NTP_Connect($NTP_Server[2])
		ElseIf $NTP_IP[3] <> '' Then
			$adata = NTP_Connect($NTP_Server[3])
		Else
			$trig = 1
			If $settings[2] = 'NO' Then GUICtrlSetData($label_sync_status, ' !')
			$beep = 700
			$beep_t = 1000
		EndIf
		If $trig = 0 Then
			Set_Time($adata)
			If $settings[2] = 'NO' Then GUICtrlSetData($label_sync_status, ' !')
		EndIf
	ElseIf $settings[0] = "HTTP" Then ; for HTTP type
		$ret = HTTPTimeSync($settings[1])
		If $ret = -1 Or $ret = -2 Then
			If $settings[2] = 'NO' Then GUICtrlSetData($label_sync_status, ' !')
			$beep = 700
			$beep_t = 1000
		EndIf
		If $settings[2] = 'NO' Then GUICtrlSetData($label_sync_status, ' !')
	EndIf
	;-=-=-=-=-=-=-=-=-=-=-=-=-=-
	If $settings[2] = 'NO' Then _GUICtrlSetGIF($gif, "", '')
	Sleep(1000)
	If $settings[4] = 'YES' Then Beep($beep, $beep_t)
EndFunc   ;==>my_SyncTime
