#include-once
#include <GUIConstantsEx.au3>
#include <ComboConstants.au3>
#include <WindowsConstants.au3>

Global Enum _
	$iMSG_First = 0, _
		$iMSG_ControlViewer, $iMSG_UnableToSaveImage, $iMSG_UnableToSaveReport, $iMSG_Environment, $iMSG_System, _
		$iMSG_Aero, $iMSG_Enabled, $iMSG_Disabled, $iMSG_Window, $iMSG_Title, _
		$iMSG_Class, $iMSG_Style, $iMSG_ExStyle, $iMSG_Position, $iMSG_Size, _
		$iMSG_Handle, $iMSG_PID, $iMSG_Path, $iMSG_Control, $iMSG_Class_1, _
		$iMSG_Instance, $iMSG_ID, $iMSG_Style_1, $iMSG_ExStyle_1, $iMSG_Position_1, _
		$iMSG_Size_1, $iMSG_Handle_1, $iMSG_Text, $iMSG_File, $iMSG_Report, _
		$iMSG_CopyToClipboard, $iMSG_SaveAs, $iMSG_Exit, $iMSG_Options, $iMSG_AlwaysOnTop, _
		$iMSG_Crosshair, $iMSG_CaptureWhileTracking, $iMSG_ShowAll, $iMSG_TextEncoding, $iMSG_Highlight, _
		$iMSG_HighlightControls, $iMSG_Transparency, $iMSG_FadeIn, $iMSG_Color, $iMSG_Help, _
		$iMSG_About, $iMSG_ColorPicker, $iMSG_XY, $iMSG_Absolute, $iMSG_Window_1, _
		$iMSG_Client, $iMSG_Control_1, $iMSG_Color_1, $iMSG_Solid, $iMSG_BrowseTool, _
		$iMSG_Window_2, $iMSG_Title_1, $iMSG_Class_2, $iMSG_Style_2, $iMSG_ExStyle_2, _
		$iMSG_Position_2, $iMSG_Size_2, $iMSG_Handle_2, $iMSG_PID_1, $iMSG_Path_1, _
		$iMSG_OpenFileLocation, $iMSG_Control_2, $iMSG_Class_3, $iMSG_Instance_1, $iMSG_ID_1, _
		$iMSG_Style_3, $iMSG_ExStyle_3, $iMSG_Position_3, $iMSG_Size_3, $iMSG_Handle_3, _
		$iMSG_Text_1, $iMSG_Capture, $iMSG_DoubleClickOnTh_PictureToSaveIt, $iMSG_AutoIt, $iMSG_ProcessPIDHandl_itleVersionPath, _
		$iMSG_Info, $iMSG_Controls, $iMSG_HandleClassNNID, $iMSG_ChangeColor, $iMSG_Visible, _
		$iMSG_ChangeColor_1, $iMSG_Hidden, $iMSG_ChangeColor_2, $iMSG_Missing, $iMSG_OK, _
		$iMSG_AreYouSureYouWa_loseThisProsess, $iMSG_UnableToCloseTheProcess, $iMSG_SaveReport, $iMSG_SaveImage, _
		$iMSG_PleaseRestart, $iMSG_Language, _
	$iMSG_Last

Global Const $LANGS_DIR = @ScriptDir & "\Languages"
Global $aTXT = _AppTranslation_Register($LANGS_DIR & "\English.lng")

Func _AppTranslation_Register($sLangFile, $sSetDataFunc = "")
	Local $aTXT[$iMSG_Last+1]
	Local $iFileEncoding = FileGetEncoding($sLangFile)
	
	;Default values
	$aTXT[$iMSG_ControlViewer] = _AppTranslation_GetString($sLangFile, "ControlViewer", 'Control Viewer', $iFileEncoding)
	$aTXT[$iMSG_UnableToSaveImage] = _AppTranslation_GetString($sLangFile, "UnableToSaveImage", 'Unable to save image.', $iFileEncoding)
	$aTXT[$iMSG_UnableToSaveReport] = _AppTranslation_GetString($sLangFile, "UnableToSaveReport", 'Unable to save report.', $iFileEncoding)
	$aTXT[$iMSG_Environment] = _AppTranslation_GetString($sLangFile, "Environment", 'Environment', $iFileEncoding)
	$aTXT[$iMSG_System] = _AppTranslation_GetString($sLangFile, "System", 'System:   ', $iFileEncoding)
	$aTXT[$iMSG_Aero] = _AppTranslation_GetString($sLangFile, "Aero", 'Aero:     ', $iFileEncoding)
	$aTXT[$iMSG_Enabled] = _AppTranslation_GetString($sLangFile, "Enabled", 'Enabled', $iFileEncoding)
	$aTXT[$iMSG_Disabled] = _AppTranslation_GetString($sLangFile, "Disabled", 'Disabled', $iFileEncoding)
	$aTXT[$iMSG_Window] = _AppTranslation_GetString($sLangFile, "Window", 'Window', $iFileEncoding)
	$aTXT[$iMSG_Title] = _AppTranslation_GetString($sLangFile, "Title", 'Title:    ', $iFileEncoding)
	$aTXT[$iMSG_Class] = _AppTranslation_GetString($sLangFile, "Class", 'Class:    ', $iFileEncoding)
	$aTXT[$iMSG_Style] = _AppTranslation_GetString($sLangFile, "Style", 'Style:    ', $iFileEncoding)
	$aTXT[$iMSG_ExStyle] = _AppTranslation_GetString($sLangFile, "ExStyle", 'ExStyle:  ', $iFileEncoding)
	$aTXT[$iMSG_Position] = _AppTranslation_GetString($sLangFile, "Position", 'Position: ', $iFileEncoding)
	$aTXT[$iMSG_Size] = _AppTranslation_GetString($sLangFile, "Size", 'Size:     ', $iFileEncoding)
	$aTXT[$iMSG_Handle] = _AppTranslation_GetString($sLangFile, "Handle", 'Handle:   ', $iFileEncoding)
	$aTXT[$iMSG_PID] = _AppTranslation_GetString($sLangFile, "PID", 'PID:      ', $iFileEncoding)
	$aTXT[$iMSG_Path] = _AppTranslation_GetString($sLangFile, "Path", 'Path:     ', $iFileEncoding)
	$aTXT[$iMSG_Control] = _AppTranslation_GetString($sLangFile, "Control", 'Control', $iFileEncoding)
	$aTXT[$iMSG_Class_1] = _AppTranslation_GetString($sLangFile, "Class_1", 'Class:    ', $iFileEncoding)
	$aTXT[$iMSG_Instance] = _AppTranslation_GetString($sLangFile, "Instance", 'Instance: ', $iFileEncoding)
	$aTXT[$iMSG_ID] = _AppTranslation_GetString($sLangFile, "ID", 'ID:       ', $iFileEncoding)
	$aTXT[$iMSG_Style_1] = _AppTranslation_GetString($sLangFile, "Style_1", 'Style:    ', $iFileEncoding)
	$aTXT[$iMSG_ExStyle_1] = _AppTranslation_GetString($sLangFile, "ExStyle_1", 'ExStyle:  ', $iFileEncoding)
	$aTXT[$iMSG_Position_1] = _AppTranslation_GetString($sLangFile, "Position_1", 'Position: ', $iFileEncoding)
	$aTXT[$iMSG_Size_1] = _AppTranslation_GetString($sLangFile, "Size_1", 'Size:     ', $iFileEncoding)
	$aTXT[$iMSG_Handle_1] = _AppTranslation_GetString($sLangFile, "Handle_1", 'Handle:   ', $iFileEncoding)
	$aTXT[$iMSG_Text] = _AppTranslation_GetString($sLangFile, "Text", 'Text:     ', $iFileEncoding)
	$aTXT[$iMSG_File] = _AppTranslation_GetString($sLangFile, "File", '&File', $iFileEncoding)
	$aTXT[$iMSG_Report] = _AppTranslation_GetString($sLangFile, "Report", '&Report', $iFileEncoding)
	$aTXT[$iMSG_CopyToClipboard] = _AppTranslation_GetString($sLangFile, "CopyToClipboard", '&Copy To Clipboard', $iFileEncoding)
	$aTXT[$iMSG_SaveAs] = _AppTranslation_GetString($sLangFile, "SaveAs", 'Save &As...', $iFileEncoding)
	$aTXT[$iMSG_Exit] = _AppTranslation_GetString($sLangFile, "Exit", 'E&xit', $iFileEncoding)
	$aTXT[$iMSG_Options] = _AppTranslation_GetString($sLangFile, "Options", '&Options', $iFileEncoding)
	$aTXT[$iMSG_AlwaysOnTop] = _AppTranslation_GetString($sLangFile, "AlwaysOnTop", '&Always On Top', $iFileEncoding)
	$aTXT[$iMSG_Crosshair] = _AppTranslation_GetString($sLangFile, "Crosshair", 'C&rosshair', $iFileEncoding)
	$aTXT[$iMSG_CaptureWhileTracking] = _AppTranslation_GetString($sLangFile, "CaptureWhileTracking", 'Capture While &Tracking', $iFileEncoding)
	$aTXT[$iMSG_ShowAll] = _AppTranslation_GetString($sLangFile, "ShowAll", 'Show All', $iFileEncoding)
	$aTXT[$iMSG_TextEncoding] = _AppTranslation_GetString($sLangFile, "TextEncoding", 'Text &Encoding', $iFileEncoding)
	$aTXT[$iMSG_Highlight] = _AppTranslation_GetString($sLangFile, "Highlight", '&Highlight', $iFileEncoding)
	$aTXT[$iMSG_HighlightControls] = _AppTranslation_GetString($sLangFile, "HighlightControls", '&Highlight Controls', $iFileEncoding)
	$aTXT[$iMSG_Transparency] = _AppTranslation_GetString($sLangFile, "Transparency", '&Transparency', $iFileEncoding)
	$aTXT[$iMSG_FadeIn] = _AppTranslation_GetString($sLangFile, "FadeIn", '&Fade In', $iFileEncoding)
	$aTXT[$iMSG_Color] = _AppTranslation_GetString($sLangFile, "Color", '&Color...', $iFileEncoding)
	$aTXT[$iMSG_Help] = _AppTranslation_GetString($sLangFile, "Help", '&Help', $iFileEncoding)
	$aTXT[$iMSG_About] = _AppTranslation_GetString($sLangFile, "About", '&About...', $iFileEncoding)
	$aTXT[$iMSG_ColorPicker] = _AppTranslation_GetString($sLangFile, "ColorPicker", 'Color Picker', $iFileEncoding)
	$aTXT[$iMSG_XY] = _AppTranslation_GetString($sLangFile, "XY", 'X, Y:', $iFileEncoding)
	$aTXT[$iMSG_Absolute] = _AppTranslation_GetString($sLangFile, "Absolute", 'Absolute', $iFileEncoding)
	$aTXT[$iMSG_Window_1] = _AppTranslation_GetString($sLangFile, "Window_1", 'Window', $iFileEncoding)
	$aTXT[$iMSG_Client] = _AppTranslation_GetString($sLangFile, "Client", 'Client', $iFileEncoding)
	$aTXT[$iMSG_Control_1] = _AppTranslation_GetString($sLangFile, "Control_1", 'Control', $iFileEncoding)
	$aTXT[$iMSG_Color_1] = _AppTranslation_GetString($sLangFile, "Color_1", 'Color:', $iFileEncoding)
	$aTXT[$iMSG_Solid] = _AppTranslation_GetString($sLangFile, "Solid", 'Solid:', $iFileEncoding)
	$aTXT[$iMSG_BrowseTool] = _AppTranslation_GetString($sLangFile, "BrowseTool", 'Browse Tool', $iFileEncoding)
	$aTXT[$iMSG_Window_2] = _AppTranslation_GetString($sLangFile, "Window_2", 'Window', $iFileEncoding)
	$aTXT[$iMSG_Title_1] = _AppTranslation_GetString($sLangFile, "Title_1", 'Title:', $iFileEncoding)
	$aTXT[$iMSG_Class_2] = _AppTranslation_GetString($sLangFile, "Class_2", 'Class:', $iFileEncoding)
	$aTXT[$iMSG_Style_2] = _AppTranslation_GetString($sLangFile, "Style_2", 'Style:', $iFileEncoding)
	$aTXT[$iMSG_ExStyle_2] = _AppTranslation_GetString($sLangFile, "ExStyle_2", 'ExStyle:', $iFileEncoding)
	$aTXT[$iMSG_Position_2] = _AppTranslation_GetString($sLangFile, "Position_2", 'Position:', $iFileEncoding)
	$aTXT[$iMSG_Size_2] = _AppTranslation_GetString($sLangFile, "Size_2", 'Size:', $iFileEncoding)
	$aTXT[$iMSG_Handle_2] = _AppTranslation_GetString($sLangFile, "Handle_2", 'Handle:', $iFileEncoding)
	$aTXT[$iMSG_PID_1] = _AppTranslation_GetString($sLangFile, "PID_1", 'PID:', $iFileEncoding)
	$aTXT[$iMSG_Path_1] = _AppTranslation_GetString($sLangFile, "Path_1", 'Path:', $iFileEncoding)
	$aTXT[$iMSG_OpenFileLocation] = _AppTranslation_GetString($sLangFile, "OpenFileLocation", 'Open file location', $iFileEncoding)
	$aTXT[$iMSG_Control_2] = _AppTranslation_GetString($sLangFile, "Control_2", 'Control', $iFileEncoding)
	$aTXT[$iMSG_Class_3] = _AppTranslation_GetString($sLangFile, "Class_3", 'Class:', $iFileEncoding)
	$aTXT[$iMSG_Instance_1] = _AppTranslation_GetString($sLangFile, "Instance_1", 'Instance:', $iFileEncoding)
	$aTXT[$iMSG_ID_1] = _AppTranslation_GetString($sLangFile, "ID_1", 'ID:', $iFileEncoding)
	$aTXT[$iMSG_Style_3] = _AppTranslation_GetString($sLangFile, "Style_3", 'Style:', $iFileEncoding)
	$aTXT[$iMSG_ExStyle_3] = _AppTranslation_GetString($sLangFile, "ExStyle_3", 'ExStyle:', $iFileEncoding)
	$aTXT[$iMSG_Position_3] = _AppTranslation_GetString($sLangFile, "Position_3", 'Position:', $iFileEncoding)
	$aTXT[$iMSG_Size_3] = _AppTranslation_GetString($sLangFile, "Size_3", 'Size:', $iFileEncoding)
	$aTXT[$iMSG_Handle_3] = _AppTranslation_GetString($sLangFile, "Handle_3", 'Handle:', $iFileEncoding)
	$aTXT[$iMSG_Text_1] = _AppTranslation_GetString($sLangFile, "Text_1", 'Text:', $iFileEncoding)
	$aTXT[$iMSG_Capture] = _AppTranslation_GetString($sLangFile, "Capture", 'Capture', $iFileEncoding)
	$aTXT[$iMSG_DoubleClickOnTh_PictureToSaveIt] = _AppTranslation_GetString($sLangFile, "DoubleClickOnTh_PictureToSaveIt", 'Double click on the picture to save it', $iFileEncoding)
	$aTXT[$iMSG_AutoIt] = _AppTranslation_GetString($sLangFile, "AutoIt", 'AutoIt', $iFileEncoding)
	$aTXT[$iMSG_ProcessPIDHandl_itleVersionPath] = _AppTranslation_GetString($sLangFile, "ProcessPIDHandl_itleVersionPath", 'Process|PID|Handle|Class|Title|Version|Path', $iFileEncoding)
	$aTXT[$iMSG_Info] = _AppTranslation_GetString($sLangFile, "Info", 'Info', $iFileEncoding)
	$aTXT[$iMSG_Controls] = _AppTranslation_GetString($sLangFile, "Controls", 'Controls', $iFileEncoding)
	$aTXT[$iMSG_HandleClassNNID] = _AppTranslation_GetString($sLangFile, "HandleClassNNID", 'Handle|Class|NN|ID', $iFileEncoding)
	$aTXT[$iMSG_ChangeColor] = _AppTranslation_GetString($sLangFile, "ChangeColor", 'Change color', $iFileEncoding)
	$aTXT[$iMSG_Visible] = _AppTranslation_GetString($sLangFile, "Visible", 'Visible', $iFileEncoding)
	$aTXT[$iMSG_ChangeColor_1] = _AppTranslation_GetString($sLangFile, "ChangeColor_1", 'Change color', $iFileEncoding)
	$aTXT[$iMSG_Hidden] = _AppTranslation_GetString($sLangFile, "Hidden", 'Hidden', $iFileEncoding)
	$aTXT[$iMSG_ChangeColor_2] = _AppTranslation_GetString($sLangFile, "ChangeColor_2", 'Change color', $iFileEncoding)
	$aTXT[$iMSG_Missing] = _AppTranslation_GetString($sLangFile, "Missing", 'Missing', $iFileEncoding)
	$aTXT[$iMSG_OK] = _AppTranslation_GetString($sLangFile, "OK", 'OK', $iFileEncoding)
	$aTXT[$iMSG_AreYouSureYouWa_loseThisProsess] = _AppTranslation_GetString($sLangFile, "AreYouSureYouWa_loseThisProsess", 'Are you sure you want to close this prosess?', $iFileEncoding)
	$aTXT[$iMSG_UnableToCloseTheProcess] = _AppTranslation_GetString($sLangFile, "UnableToCloseTheProcess", 'Unable to close the process.', $iFileEncoding)
	$aTXT[$iMSG_SaveReport] = _AppTranslation_GetString($sLangFile, "SaveReport", 'Save Report', $iFileEncoding)
	$aTXT[$iMSG_SaveImage] = _AppTranslation_GetString($sLangFile, "SaveImage", 'Save Image', $iFileEncoding)
	$aTXT[$iMSG_Language] = _AppTranslation_GetString($sLangFile, "Language", 'Select language...', $iFileEncoding)
	$aTXT[$iMSG_PleaseRestart] = _AppTranslation_GetString($sLangFile, "PleaseRestart", 'Please restart %s.', $iFileEncoding)
	
	If $sSetDataFunc <> "" Then
		Call($sSetDataFunc, $aTXT)
	EndIf
	
	Return $aTXT
EndFunc

Func _AppTranslation_GetLanguages($sLangs_Dir, $bRetArray = False)
	Local $sRet, $sLngFileName, $hSearch = FileFindFirstFile($sLangs_Dir & "\*.lng")
	If $hSearch = -1 Then Return SetError(-1, 0, '')
	
	While 1
		$sLngFileName = FileFindNextFile($hSearch)
		If @error <> 0 Then ExitLoop
		$sRet &= StringLeft($sLngFileName, StringInStr($sLngFileName, ".", 2, -1) - 1) & "|"
	WEnd
	
	FileClose($hSearch)
	
	If $sRet = "" Then Return SetError(1, 0, "")
	
	$sRet = StringTrimRight($sRet, 1)
	If $bRetArray Then $sRet = StringSplit($sRet, "|")
	Return $sRet
EndFunc

Func _AppTranslation_GetString($sLangFile, $sIdentifier, $sDefault = "", $iFileEncoding = 0)
	Local $sStr = IniRead($sLangFile, "Translation", $sIdentifier, $sDefault)
	
	If $iFileEncoding >= 128 Then
		$sStr = BinaryToString(StringToBinary($sStr), 4)
	EndIf
	
	Return $sStr
EndFunc

Func _AppTranslation_SelectLangGUI($sAppName, $hParent = 0, $sLng = "")
	Local $hGUI, $nLng_Combo, $iMsg
	
	GUISetState(@SW_DISABLE, $hParent)
	$hGUI = GUICreate($sAppName, 300, 120, -1, -1, -1, $WS_EX_TOOLWINDOW, $hParent)
	
	GUICtrlCreateLabel("Language:", 20, 52, 80, 17)
	$nLng_Combo = GUICtrlCreateCombo("", 110, 50, 170, 50, BitOr($GUI_SS_DEFAULT_COMBO, $CBS_DROPDOWNLIST))
	GUICtrlSetData($nLng_Combo, _AppTranslation_GetLanguages($LANGS_DIR), $sLng)
	
	GUISetState(@SW_SHOW, $hGUI)
	
	While 1
		$iMsg = GUIGetMsg()
		
		Switch $iMsg
			Case $GUI_EVENT_CLOSE
				ExitLoop
			Case $nLng_Combo
				$sLng = GUICtrlRead($nLng_Combo)
				$aTXT = _AppTranslation_Register($LANGS_DIR & "\" & $sLng & ".lng")
		EndSwitch
	WEnd
	
	GUISetState(@SW_ENABLE, $hParent)
	GUIDelete($hGUI)
	
	Return $sLng
EndFunc
