#include-once



;;=======================================================================================;;
;; Library:    MPCLib (Microteam Power Crypt Library)                                    ;;
;; Author:     Microteam inc.                                                            ;;
;; Version:    1.0.0.0                                                                   ;;
;; Description:                                                                          ;;
;;                  MPC                    ;;
;; File Name: MPCLib.au3                                                                 ;;
;;=======================================================================================;;



#cs
Function: _MPC_CreateMatrix($login, $pass)
Parameters:[
          $login - 
		  $pass - 
		  ]
Return:   ,     
Description:        
#ce
Func _MPC_CreateMatrix($login, $pass)
   
   $l_len = StringLen($login)
   $p_len = StringLen($pass)
   
   Dim $MATRIX[256]
   
   $login_arr= StringSplit($login, "")
   $pass_arr = StringSplit($pass, "")
   
   $number_l = $l_len;
   $number_p = $l_len+64;
   
   $method = 1;
   For $i = 0 To 255
       
	   $number_l += $i;
	   $number_p += $i;
	   
	   $number_l = $l_len;
       $number_p = $l_len+64;
	   
	   For $c = 1 To $l_len
		  if ($method = 1) Then
		  $number_l += Asc($login_arr[$c])+Asc($login_arr[$l_len - $c])+$i+22
		  Elseif ($method = 2) Then
		  $number_l += Asc($login_arr[$c])+Asc($login_arr[$l_len - $c])+$i+57
		  Elseif ($method = 3) Then
		  $number_l += Asc($login_arr[$c])+Asc($login_arr[$l_len - $c])+$i+13
	   EndIf
	   
	   $method+=1
	   if ($method > 3) Then
		  $method = 1;
	   EndIf
	   Next
	   
	   For $c = 1 To $p_len
		  $number_p+= Asc($pass_arr[$c])+Asc($pass_arr[$p_len - $c])+$i
	   Next
	   
	   $x = $number_l&$number_p
	   ;$x -= $i*$p_len
	   if (StringLen($x) > 8) Then
		  $x = StringTrimRight($x, StringLen($x) - 8)
		  $x -= $i
	   Elseif (StringLen($x) < 8) Then
		  
		  $count = 8 - StringLen($x)
	  For $z = 1 To $count
		  $x &= StringMid($i,1,1) 
	   Next
	      $x+=$i
	  EndIf
	   
	   $MATRIX[$i] = $x
	   
	Next 
	
	Return $MATRIX
   
EndFunc


#cs
Function: _MPC_Crypt($message, $login, $pass)
Parameters:[
		  $message -     
          $login - 
		  $pass - 
		  ]
Return:  
Description:    
#ce
Func _MPC_Crypt($message, $login, $pass)
   $msg = StringSplit($message, "")
   $matrix = _MPC_CreateMatrix($login, $pass)
   
   
   $crypted = "";
   For $i = 1 To $msg[0]
	  $char = $msg[$i]
	  
	  $crypted &= $matrix[Asc($char)-1]
   Next
   
   Return $crypted
EndFunc


#cs
Function: _MPC_Crypt($message, $login, $pass)
Parameters:[
		  $bin -  
          $login - 
		  $pass - 
		  ]
Return:  
Description:    
#ce

Func _MPC_Decrypt($bin, $login, $pass)
   $splitted = StringSplit($bin, "")
   
   $matrix = _MPC_CreateMatrix($login, $pass)
   
   $digest = ""
   $count = 1;
   $xcount= 0;
   
   Dim $decrypted[$splitted[0] / 8]
   
   For $i = 1 To $splitted[0]
	  $char = $splitted[$i]
	  
	  if ($count < 8) Then
		 $digest &= $char
		 $count+=1
	  Else
		 $digest &= $char
		 $count = 1
	  EndIf  
	  
	  if (StringLen($digest) = 8) Then
		 $decrypted[$xcount] = $digest
		 $digest = ""
		 $xcount +=1
	  EndIf
   Next
   
   $ret = ""
   
   For $dg In $decrypted
	  
	  For $mt = 0 To 255
		 if ($dg = $matrix[$mt]) Then
		    $ret &= Chr($mt+1)	
		 EndIf
	  Next
   Next
   
   Return $ret
EndFunc