
$sProductKey = _AppTrial_Generate_ProductKey()

InputBox("_AppTrial_Generate_ProductKey", "Unique <Product Key> for this PC:", $sProductKey)

Func _AppTrial_Generate_ProductKey()
	Local $sPK_Val = @OSVersion & @OSArch & @UserName & _GetMACAddress() & @OSBuild & @CPUArch & @OSType & @OSLang
	Local $sRet_PK, $aSplit_PK = StringSplit(StringRegExpReplace(StringUpper($sPK_Val), "[^A-Z0-9]+", ""), "")
	
	For $i = $aSplit_PK[0] To 1 Step -2
		If Mod($i, 5) = 0 Then
			$sRet_PK &= $aSplit_PK[$i] & "-"
		Else
			$sRet_PK &= $aSplit_PK[$i]
		EndIf
	Next
	
	Return StringRegExpReplace($sRet_PK, "\A-+|-+$|\A.{1,4}-|-.{1,4}$", "")
EndFunc

Func _GetMACAddress($iGetMACIndex = 1)
	Local $sRead = ""
	Local $ipHandle = Run(@ComSpec & ' /c ipconfig /all', '', @SW_HIDE, 2)
	
	While Not @error
		$sRead &= StdoutRead($ipHandle)
	WEnd
	
	$sRead = StringStripWS($sRead, 7)
	
	Local $aMAC_Dashed = StringRegExp($sRead , '([0-9A-F]{2}-[0-9A-F]{2}-[0-9A-F]{2}-[0-9A-F]{2}-[0-9A-F]{2}-[0-9A-F]{2})', 3)
	
	If Not IsArray($aMAC_Dashed) Then Return 0
    If $iGetMACIndex <  1 Then Return 0
    If $iGetMACIndex > UBound($aMAC_Dashed) Or $iGetMACIndex = -1 Then $iGetMACIndex = UBound($aMAC_Dashed)
    
    Return StringReplace($aMAC_Dashed[$iGetMACIndex - 1], '-', ':', 0)
EndFunc
