#include-once
#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>
;

Global $i__FCSP_TotalReadySize = 0
Global $i__FCSP_TotalDirSize = 0
Global $i__FCSP_FilesCount = 0
Global $i__FCSP_MainCounter = 0

Global $h__FCSP_CopyProgrss_GUI
Global $n__FCSP_SubFile_Progress
Global $n__FCSP_Cancel_Button
Global $n__FCSP_Remained_Label
Global $i__FCSP_CopyIsCanceled = False

Global $s__FCSP_CancelBtnTxt = "Cancel"
Global $s__FCSP_RemainedLblTxt = "Remained:"
Global $s__FCSP_GettingFilesListTxt = "Getting files list..."
Global $s__FCSP_CopyLocationFormatTxt = '%s\nFrom "%s" To "%s"'

Global $i__FCSP_AskCopyCancel = True
Global $s__FCSP_AskCancelTitle = "Attention"
Global $s__FCSP_AskCancelMsg = "Are you sure, cancel the copy process?"

; #FUNCTION# ====================================================================================================
; Name...........:	_FilesCopyShowProgress
; Description....:	Copy files from one location to another with advanced progress display
; Syntax.........:	_FilesCopyShowProgress($sSourcePath,$sDestPath,$iReplace=0, $sTitle="",$iWidth=-1,$iHeight=-1,$iLeft=-1,$iTop=-1,$hWnd=0)
; Parameters.....:	$sSourcePath - Source directory to copy files from.
;					$sDestPath   - Destination directory that files will be copied to.
;					$iReplace    - [Optional] 0 - Do not replace the existing files, 1 - Replace.
;					$sTitle      - [Optional] Title for the Copy Progress window.
;					$iWidth      - [Optional] Width of the Copy Progress window.
;					$iHeight     - [Optional] Height of the Copy Progress window.
;					$iLeft       - [Optional] Left position of the Copy Progress window.
;					$iTop        - [Optional] Top position of the Copy Progress window.
;					$hWnd        - [Optional] Parent window handle.
;					
; Return values..:	Success     - Copy files and always return 1.
;					Failure     - Returns -1 and set @error as following:
;					              1 - $sSourcePath does not exists (or it's not a directory).
;					              2 - $sDestPath does not exists (or it's not a directory and it can be created).
;					              3 - $iReplace is not valid (not 0 and not 1).
; Author.........:	G.Sandler (a.k.a MrCreatoR), http://creator-lab.ucoz.ru, http://autoit-script.ru
; Modified.......:	
; Remarks........:	
; Related........:	FileCopy?
; Link...........:	
; Example........:	_FilesCopyShowProgress("C:\Temp", "C:\Dest", 1, "Copy...", 400, 170, 0, 0, WinGetHandle(""))
; ===============================================================================================================
Func _FilesCopyShowProgress($sSourcePath,$sDestPath,$iReplace=0,$sTitle="",$iWidth=-1,$iHeight=-1,$iLeft=-1,$iTop=-1,$hWnd=0)
	If Not StringInStr(FileGetAttrib($sSourcePath), "D") Then Return SetError(1, 0, -1)
	If Not StringInStr(FileGetAttrib($sDestPath), "D") And Not DirCreate($sDestPath) Then Return SetError(2, 0, -1)
	If $iReplace <> 0 And $iReplace <> 1 Then SetError(3, 0, -1)
	
	Local $PathName = StringRegExpReplace($sSourcePath, "^.*\\", "")
	Local $Progress = 0, $CurrReadySize, $MidlePath
	Local $CurrentFilePath, $CurrentFileName, $CurrentFilePathName, $CurrParDirName, $CurrParDestDirName
	Local Const $WS_EX_COMPOSITED = 0x2000000
	
	If IsHWnd($hWnd) Then WinSetState($hWnd, "", @SW_DISABLE)
	
	$h__FCSP_CopyProgrss_GUI = GUICreate($sTitle, $iWidth, $iHeight, $iLeft, $iTop, _
		BitOR($WS_SYSMENU, $WS_CAPTION), $WS_EX_COMPOSITED, $hWnd)
	GUISetIcon("Shell32.dll", -135, $h__FCSP_CopyProgrss_GUI)
	
	GUICtrlCreateAvi(@SystemDir & "\Shell32.dll", 161, 25, 0, $iWidth-50)
	GUICtrlSetState(-1, 1)
	
	Local $Main_Label = GUICtrlCreateLabel("", 20, 70, $iWidth-40, 40)
	
	Local $Main_Progress = GUICtrlCreateProgress(20, $iHeight-58, $iWidth-120, 15)
	$n__FCSP_SubFile_Progress = GUICtrlCreateProgress(20, $iHeight-40, $iWidth-120, 10)
	
	$n__FCSP_Cancel_Button = GUICtrlCreateButton($s__FCSP_CancelBtnTxt, $iWidth-80, $iHeight-50, 60, 22)
	$n__FCSP_Remained_Label = GUICtrlCreateLabel($s__FCSP_RemainedLblTxt & " 00:00:00", 20, $iHeight-23, $iWidth-120)
	
	GUISetState(@SW_SHOW, $h__FCSP_CopyProgrss_GUI)
	
	Local $aTotalDirSize = DirGetSize($sSourcePath, 1)
	$i__FCSP_TotalDirSize = $aTotalDirSize[0]
	$i__FCSP_FilesCount = $aTotalDirSize[1]
	
	__FCSP_AdlibEnable("__FCSP_CheckCancel_Proc", $h__FCSP_CopyProgrss_GUI, 10)
	
	GUICtrlSetData($Main_Label, $s__FCSP_GettingFilesListTxt)
	Local $FilesArr = __FCSP_FileListToArrayEx($sSourcePath)
	
	If IsArray($FilesArr) Then
		For $i = 1 To UBound($FilesArr)-1
			If $i__FCSP_CopyIsCanceled Then ExitLoop
			
			;$aCurInfo = GUIGetCursorInfo($h__FCSP_CopyProgrss_GUI)
			;If IsArray($aCurInfo) And $aCurInfo[2] = 1 And $aCurInfo[4] = $n__FCSP_Cancel_Button Then ExitLoop
			
			;If StringInStr(FileGetAttrib($FilesArr[$i]), "D") Then ContinueLoop
			
			$CurrentFilePath = $FilesArr[$i]
			$CurrentFileName = StringRegExpReplace($CurrentFilePath, "^.*\\", "")
			$CurrentFilePathName = StringReplace($CurrentFilePath, $sSourcePath & "\", "")
			$CurrParDirName = __FCSP_GetParentDirName($CurrentFilePath)
			$CurrParDestDirName = __FCSP_GetMidlePath($sDestPath & "\" & $CurrParDirName)
			
			$CurrReadySize = FileGetSize($CurrentFilePath)
			$i__FCSP_TotalReadySize += $CurrReadySize
			$Progress = $i__FCSP_TotalReadySize / $i__FCSP_TotalDirSize * 100
			
			$MidlePath = __FCSP_GetMidlePath($CurrentFilePath)
			
			GUICtrlSetData($Main_Progress, $Progress)
			GUICtrlSetData($Main_Label, _
				StringFormat($s__FCSP_CopyLocationFormatTxt, $CurrentFileName, $CurrParDirName, $CurrParDestDirName))
			
			__FCSP_FileCopyEx($CurrentFilePath, $sDestPath & "\" & $CurrentFilePathName, 8+$iReplace)
			GUICtrlSetData($n__FCSP_SubFile_Progress, 0)
			
			If $i__FCSP_CopyIsCanceled Then ExitLoop
		Next
	EndIf
	
	__FCSP_AdlibDisable($h__FCSP_CopyProgrss_GUI)
	
	If IsHWnd($hWnd) Then WinSetState($hWnd, "", @SW_ENABLE)
	GUIDelete($h__FCSP_CopyProgrss_GUI)
	Return 1
EndFunc

Func __FCSP_FileCopyEx($sSource, $sDest, $iFlag=0, $sProgressRoutineFunc="__FCSP_ProgressRoutine")
	If Not FileExists($sSource) Then Return SetError(1)
	
	If ($iFlag = 0 Or $iFlag = 8) And FileExists($sDest) Then Return 0
	If BitAND($iFlag, 8) Then DirCreate(StringRegExpReplace($sDest, "\\[^\\]*$", ""))
	
	$hCopyProgressRoutine = DllCallbackRegister($sProgressRoutineFunc, "int", "uint64;uint64;uint64;uint64;dword;dword;ptr;ptr;ptr")
	
	DllCall("kernel32.dll", "int", "CopyFileExA", _
		"str", $sSource, _
		"str", $sDest, _
		"ptr", DllCallbackGetPtr($hCopyProgressRoutine), _
		"ptr", 0, _
		"int", 0, _
		"int", 0)
	
	DllCallBackFree($hCopyProgressRoutine)
EndFunc

Func __FCSP_ProgressRoutine($TotalFileSize, $TotalBytesTransferred, $StreamSize, $StreamBytesTransferred, $dwStreamNumber, $dwCallbackReason, $hSourceFile, $hDestinationFile, $lpData)
	$i__FCSP_MainCounter += 1
	
	Local $Precent = $TotalBytesTransferred/$TotalFileSize*100
	Local $TimeRemained = __FCSP_GetTimeRemained($i__FCSP_TotalDirSize, $TotalBytesTransferred, _
		$i__FCSP_FilesCount, $i__FCSP_MainCounter)
	
	GUICtrlSetData($n__FCSP_Remained_Label, $s__FCSP_RemainedLblTxt & " " & $TimeRemained)
	GUICtrlSetData($n__FCSP_SubFile_Progress, $Precent)
	
	Return 0
EndFunc

Func __FCSP_AdlibEnable($sFunction, $hWnd, $iTime=250)
	GUIRegisterMsg($WM_TIMER, $sFunction)
	DllCall("User32.dll", "int", "SetTimer", "hwnd", $hWnd, "int", 50, "int", $iTime, "int", 0)
EndFunc

Func __FCSP_AdlibDisable($hWnd)
	GUIRegisterMsg($WM_TIMER, "")
	DllCall("user32.dll", "int", "KillTimer", "hwnd", $hWnd, "int_ptr", 50)
EndFunc

Func __FCSP_CheckCancel_Proc()
	Switch GUIGetMsg()
		Case $GUI_EVENT_CLOSE, $n__FCSP_Cancel_Button
			If $i__FCSP_AskCopyCancel Then
				If MsgBox(36, $s__FCSP_AskCancelTitle, $s__FCSP_AskCancelMsg, 0, $h__FCSP_CopyProgrss_GUI) <> 6 Then Return
			EndIf
				
			$i__FCSP_CopyIsCanceled = True
			__FCSP_AdlibDisable($h__FCSP_CopyProgrss_GUI)
	EndSwitch
EndFunc

Func __FCSP_FileListToArrayEx($sPath)
	Local $iPID = Run(@ComSpec & ' /C Dir "' & $sPath & '" /S /B /A', '', @SW_HIDE, 2 + 4)
	Local $sStdOutRead = ""
	
	While 1
		$sStdOutRead &= StdoutRead($iPID)
		If @error <> 0 Then ExitLoop
	WEnd
	
	$sStdOutRead = StringStripWS($sStdOutRead, 3)
	
	;Func _StringOEM2ANSI($sStdOutRead)
	Local $sBuffer = DllStructCreate("char[" & StringLen($sStdOutRead) + 1 & "]")
	Local $aRet = DllCall("User32.dll", "int", "OemToChar", "str", $sStdOutRead, "ptr", DllStructGetPtr($sBuffer))
	
	If IsArray($aRet) And $aRet[0] > 0 Then $sStdOutRead = DllStructGetData($sBuffer, 1)
	;EndFunc ==> _StringOEM2ANSI($sStdOutRead)
	
	Return StringSplit(StringStripCR($sStdOutRead), @LF)
EndFunc

;This is way too slow :(
Func __FCSP_FileListToArrayEx_bak($sPath, $sMask="*", $iMode=-1)
	If Not StringInStr(FileGetAttrib($sPath & "\"), "D") Then Return SetError(1, 0, 0)
	
	Local $hSearch, $sFindNext, $sFilePath, $iPathIsFolder, $i = 0
	Local $sRegExpFilter = StringReplace(StringReplace($sMask, ".", "\."), "*", ".*")
	Local $iMax_Ret_Paths = 10000
	Local $aPathesArr[$iMax_Ret_Paths+1] = [1, $sPath]
	
	While $i < $aPathesArr[0]
		$i += 1
		
		$hSearch = FileFindFirstFile($aPathesArr[$i] & "\*")
		If $hSearch = -1 Then ContinueLoop
		
		While 1
			If $i__FCSP_CopyIsCanceled Then Return SetError(1, 0, 0)
			
			$sFindNext = FileFindNextFile($hSearch)
			If @error Then ExitLoop
			
			$sFilePath = $aPathesArr[$i] & "\" & $sFindNext
			$iPathIsFolder = StringInStr(FileGetAttrib($sFilePath & "\"), "D")
			
			If $iMode <= 0 Or ($iMode > 0 And $iPathIsFolder) Then
				If $iPathIsFolder Or (Not $iPathIsFolder And StringRegExp($sFindNext, "(?i)" & $sRegExpFilter)) Then
					If $aPathesArr[0] >= $iMax_Ret_Paths Then
						$iMax_Ret_Paths *= 2
						ReDim $aPathesArr[$iMax_Ret_Paths+1]
					EndIf
					
					$aPathesArr[0] += 1
					$aPathesArr[$aPathesArr[0]] = $sFilePath
				EndIf
			EndIf
		WEnd
		
		FileClose($hSearch)
	Wend
	
	ReDim $aPathesArr[$aPathesArr[0]+1]
	Return $aPathesArr
EndFunc

Func __FCSP_GetMidlePath($sPath, $iMinLen=40)
	If StringLen($sPath) <= $iMinLen Then Return $sPath
	Local $sStartPath = StringLeft($sPath, 25)
	Local $sEndPath = StringTrimLeft($sPath, StringInStr($sPath, "\", 0, -2)-1)
	Return $sStartPath & "..." & $sEndPath
EndFunc

Func __FCSP_GetParentDirName($sFullName)
	Local $iLastSlashPos = StringInStr($sFullName, "\", 0, -1)
	Local $iSecondLastSlashPos = StringInStr($sFullName, "\", 0, -2)
	Return StringMid($sFullName, $iSecondLastSlashPos+1, $iLastSlashPos-$iSecondLastSlashPos-1)
EndFunc

Func __FCSP_GetTimeRemained($iTotalSize, $iCurrentSize, $i__FCSP_FilesCount, $iCurrentFilesCount)
	Local $nLevl = 0.5
	If $iTotalSize <= $iCurrentSize Then Return __FCSP_SecondsToTime(0)
	
	Switch $i__FCSP_FilesCount - $iCurrentFilesCount
		Case 0 To 100
			$nLevl = 0.1
		Case 100 To 1000
			$nLevl = 0.2
		Case 1000 To 2000
			$nLevl = 1
		Case Else
			$nLevl = 1.5
	EndSwitch
	
	Local $iSecs = ($iTotalSize * $nLevl) / (3600 * $iCurrentFilesCount) - ($iCurrentSize * $nLevl) / (3600 * $iCurrentFilesCount)
	Return __FCSP_SecondsToTime($iSecs)
EndFunc

Func __FCSP_SecondsToTime($iTicks, $Delim=":")
	If Number($iTicks) >= 0 Then
		$iHours = Int($iTicks / 3600)
		$iTicks = Mod($iTicks, 3600)
		$iMins = Int($iTicks / 60)
		$iSecs = Round(Mod($iTicks, 60))
		If StringLen($iHours) = 1 Then $iHours = "0" & $iHours
		If StringLen($iMins) = 1 Then $iMins = "0" & $iMins
		If StringLen($iSecs) = 1 Then $iSecs = "0" & $iSecs
		Return $iHours & $Delim & $iMins & $Delim & $iSecs
	EndIf
	
	Return SetError(1, 0, 0)
EndFunc

