#include "GUIFFLabel.au3"

_Example1()
_Example2()
_Example3()

Func _Example1()
	Local $hGUI, $Label, $iTimer, $Red, $Green, $Blue, $nColor, $iClr
	
	$hGUI = GUICreate("Flicker Free Labels - Example 1", 410, 220, -1, -1, BitOR($GUI_SS_DEFAULT_GUI, $WS_MAXIMIZEBOX, $WS_SIZEBOX))
	
	$Label = _GUICtrlFFLabel_Create($hGUI, "Flicker Free", 140, 10, 130, 30, 16)
	GUISetState(@SW_SHOW)
	
	_GUICtrlFFLabel_SetTextColor($Label, 0xFF0000)
	
	$iTimer = TimerInit()
	
	While 1
		Switch GUIGetMsg()
			Case $GUI_EVENT_CLOSE
				GUIDelete($hGUI)
				Return
			Case Else
				If TimerDiff($iTimer) > 50 Then
					$Red = Hex(((Sin(1 * $iClr / 1) + 1) / 2) * 0xFF, 2)
					$Green = Hex(((Sin(2 * $iClr / 1) + 1) / 2) * 0xFF, 2)
					$Blue = Hex(((Sin(3 * $iClr / 1) + 1) / 2) * 0xFF, 2)
					$iClr += 0.01
					$nColor = '0x' & $Red & $Green & $Blue
					_GUICtrlFFLabel_SetTextColor($Label, $nColor)
					$iTimer = TimerInit()
				EndIf
		EndSwitch
	WEnd
EndFunc

Func _Example2()
	Local $hGUI, $Label1, $Label2, $Label3, $nDel_Button
	
	$hGUI = GUICreate("Flicker Free Labels - Example 2", 400, 220)
	
	$Label1 = _GUICtrlFFLabel_Create($hGUI, "Label One", 80, 40, 200, 17)
	$Label2 = _GUICtrlFFLabel_Create($hGUI, "Label Two", 80, 80, 200, 17, 9, 'Times', 1, 0, 0xFF0000)
	$Label3 = _GUICtrlFFLabel_Create($hGUI, "Label Three", 80, 120, 200, 17)
	
	$nDel_Button = GUICtrlCreateButton("Delete (2)", 150, 180, 110, 20)
	
	GUISetState(@SW_SHOW)
	
	;_GUICtrlFFLabel_GUISetBkColor(0xC0C0C0, $hGUI)
	;_GUICtrlFFLabel_SetAutoRefreshMode(False) ;Disable auto-refresh of all labels
	
	While 1
		Switch GUIGetMsg()
			Case $GUI_EVENT_CLOSE
				GUIDelete($hGUI)
				Return
			Case $nDel_Button
				_GUICtrlFFLabel_Delete($Label2)
			Case Else
				_GUICtrlFFLabel_SetData($Label1, "Label One     = " & Random(1, 100000), 0xD4D4D4)
				_GUICtrlFFLabel_SetData($Label2, "Label Two     = " & Random(1, 100000))
				_GUICtrlFFLabel_SetData($Label3, "Label Three  = " & Random(1, 100000))
		EndSwitch
	WEnd
EndFunc

Func _Example3()
	Local $hGUI1, $nGUI1_DelButton, $nGUI1_MainLabel, $nGUI1_Label1, $nGUI1_Label2, $nGUI1_Label3
	Local $hGUI2, $nGUI2_DelButton, $nGUI2_MainLabel, $nGUI2_Label1, $nGUI2_Label2, $nGUI2_Label3
	Local $aPos
	
	$hGUI1 = GUICreate("Flicker Free Labels - Example 3 (GUI 1)", 409, 218, -1, -1, BitOR($GUI_SS_DEFAULT_GUI, $WS_MAXIMIZEBOX, $WS_SIZEBOX))
	
	$nGUI1_DelButton = GUICtrlCreateButton("Delete", 148, 150, 113, 21)
	GUICtrlSetResizing(-1, $GUI_DOCKALL)
	
	$nGUI1_MainLabel = _GUICtrlFFLabel_Create($hGUI1, "Flicker Free", 140, 10, 129, 33, 16)
	$nGUI1_Label1 = _GUICtrlFFLabel_Create($hGUI1, "Label 1 ", 80, 40, 200, 17)
	$nGUI1_Label2 = _GUICtrlFFLabel_Create($hGUI1, "Label Two", 80, 80, 200, 17, 9, 'Times', 1, 0, 0xFF0000)
	$nGUI1_Label3 = _GUICtrlFFLabel_Create($hGUI1, "Label 3", 80, 120, 200, 17)
	
	GUISetState(@SW_SHOW)
	
	;_GUICtrlFFLabel_RefreshAll()
	;_GUICtrlFFLabel_GUISetBkColor(0xC0C0C0, $hGUI1)
	
	$aPos = WinGetPos($hGUI1)
	
	$hGUI2 = GUICreate("Flicker Free Labels - Example 3 (GUI 2)", 410, 220, $aPos[0], $aPos[1] + $aPos[3], BitOR($GUI_SS_DEFAULT_GUI, $WS_MAXIMIZEBOX, $WS_SIZEBOX))
	$nGUI2_DelButton = GUICtrlCreateButton("Delete", 150, 150, 115, 20)
	GUICtrlSetResizing(-1, $GUI_DOCKALL)
	
	$nGUI2_MainLabel = _GUICtrlFFLabel_Create($hGUI2, "Flicker Free", 140, 10, 130, 33, 16)
	$nGUI2_Label1 = _GUICtrlFFLabel_Create($hGUI2, "Label 1", 80, 40, 200, 17)
	$nGUI2_Label2 = _GUICtrlFFLabel_Create($hGUI2, "Label 2", 80, 80, 200, 17, 9, 'Times', 1, 0, 0x0000C0)
	$nGUI2_Label3 = _GUICtrlFFLabel_Create($hGUI2, "Label 3", 80, 120, 200, 17)
	
	_GUICtrlFFLabel_SetTextColor($nGUI2_Label1, 0xFF00FF)
	GUISetState(@SW_SHOW)
	
	;_GUICtrlFFLabel_RefreshAll()
	;_GUICtrlFFLabel_GUISetBkColor(0xC0C0C0, $hGUI2)
	
	While 1
		Switch GUIGetMsg()
			Case $GUI_EVENT_CLOSE
				GUIDelete($hGUI1)
				GUIDelete($hGUI2)
				Return
			Case $nGUI1_DelButton
				_GUICtrlFFLabel_Delete($nGUI1_Label2)
			Case $nGUI2_DelButton
				_GUICtrlFFLabel_Delete($nGUI2_Label2)
			Case Else
				_GUICtrlFFLabel_SetData($nGUI1_Label1, "Label One     = " & Random(1, 100000))
				_GUICtrlFFLabel_SetData($nGUI1_Label2, "Label Two     = " & Random(1, 100000))
				_GUICtrlFFLabel_SetData($nGUI1_Label3, "Label Three   = " & Random(1, 100000))
				_GUICtrlFFLabel_SetData($nGUI2_Label1, "Label One     = " & Random(1, 100000), 0xABCDEF) ;changed labels BG color blue
				_GUICtrlFFLabel_SetData($nGUI2_Label2, "Label Two     = " & Random(1, 100000))
				_GUICtrlFFLabel_SetData($nGUI2_Label3, "Label Three   = " & Random(1, 100000))
		EndSwitch
	WEnd
EndFunc
