#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_UseX64=n
#AutoIt3Wrapper_AU3Check_Parameters=-d -w 1 -w 3 -w 4 ;-w 5
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****

#Region Header and Global Vars

#CS
	Name:				GUIFFLabel UDF.
	Description:		"Flicker Free" label, a label that wont flicker, created using GDI+.
	Author:				Copyright  2011-2013 Brian J Christy, G.Sandler (MrCreatoR).
	AutoIt version:		3.3.8.1
	
	Remarks:            * If $WM_PAINT OR $WM_NCPAINT are needed in your script you MUST pass the msgs to __GUICtrlFFLabel_WM_PAINT.
                        
                        Example:
						        
                                GUIRegisterMsg($WM_PAINT, "_Your_WM_PAINT")
                                GUIRegisterMsg($WM_PAINT, "_Your_WM_NCPAINT")
                                
                                Func _Your_WM_PAINT($hWndGUI, $MsgID, $wParam, $lParam)
                                    __GUICtrlFFLabel_WM_PAINT()
                                    ;your code...
                                EndFunc
							    
                                Func _Your_WM_NCPAINT($hWndGUI, $MsgID, $wParam, $lParam)
                                    __GUICtrlFFLabel_WM_PAINT()
                                    ;your code...
                                EndFunc
						
						* If GUI created without $WS_POPUP style, there is need to refresh all labels after GUISetState(@SW_SHOW),
						  use _GUICtrlFFLabel_RefreshAll() function for it.
	
	History:
						* Global UDF improvements.
						* Changed parameters order in _GUICtrlFFLabel_GUISetBkColor function ($nBkColor, $hWnd = -1).
						* Changed examples.
						* Updated docs (comments in UDF's header).
	
#CE

#include-once
#include <GDIPlus.au3>
#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>

Global $b_GFFL_AutoRefresh 		= True
Global $i_GFFL_GUIDefBkColor 	= __GUICtrlFFLabel_GetWindowBkColor()
Global $a_GFFL_hGraphics[1] 	= [0]
Global $a_GFFL_hDCs[1] 			= [0]

Global Enum _
		$h_GFFL_Wnd, $i_GFFL_GraphicsIndex, $i_GFFL_DCIndex, $b_GFFL_IsMinimized, $h_GFFL_Bitmap, $h_GFFL_Buffer, $h_GFFL_Brush, _
		$s_GFFL_FontFamily, $h_GFFL_Stringformat, $i_GFFL_Layout, $h_GFFL_Font, $i_GFFL_Left, $i_GFFL_Top, $i_GFFL_Width, $i_GFFL_Height, _
		$s_GFFL_Restore, $b_GFFL_Removed, $i_GFFL_Def_Bk_Color, _
	$i_GFFL_Max

Global $a_GFFL_GDILbls[1][$i_GFFL_Max] = [[0]]

#CS
	$a_GFFL_GDILbls[0][0]			= List Count
	[0][1-$i_GFFL_Max]				= Nothing
	
	[$i][$h_GFFL_Wnd]    			= Gui Handle label is located on
	[$i][$i_GFFL_GraphicsIndex]		= Array index number to $a_GFFL_hGraphics that holds this labels Graphics object handle
	[$i][$i_GFFL_DCIndex]			= Array index number to $a_GFFL_hDCs that holds this labels display device context
	[$i][$h_GFFL_Bitmap]			= Bitmap Object Handle
	[$i][$h_GFFL_Buffer]    		= Buffer Handle
	[$i][$h_GFFL_Brush]    			= Handle to brush
	[$i][$s_GFFL_FontFamily]    	= Handle to font family
	[$i][$h_GFFL_Stringformat]  	= Handle to stringformat
	[$i][$i_GFFL_Layout]  			= labels $tagGDIPRECTF structure
	[$i][$h_GFFL_Font]    			= Handle to font
	[$i][$i_GFFL_Left]     			= Left
	[$i][$i_GFFL_Top]     			= Top
	[$i][$i_GFFL_Width]     		= Width
	[$i][$i_GFFL_Height]  			= Height
	[$i][$s_GFFL_Restore]    		= Last text written to label
	[$i][$b_GFFL_Removed]			= indicates to other functions that items have been deleted and objects in index are no longer valid
	[$i][$i_GFFL_Def_Bk_Color]		= Defualt Backgound Color of Label
#CE

_GDIPlus_Startup()
OnAutoItExitRegister('__GUICtrlFFLabel_Dispose')

#EndRegion Header and Global Vars

#Region Public Functions

; #FUNCTION# ====================================================================================================
; Name...........:	_GUICtrlFFLabel_Create
; Description....:	Creates a label that wont flicker using GDI+
; Syntax.........:	_GUICtrlFFLabel_Create($hWnd, $sText, $iLeft, $iTop, $iWidth, $iHeight [, $iFontSize = 11 [, $iFontFamily = -1 [, $iFontStyle = 0 [, $iAlign = 0 [, $iColor = 0x000000 ]]]]])
; Parameters.....:	$hWnd - Handle to GUI
;					$sText - Text
;					$iLeft - The left side of the control.
;					$iTop - The top of the control.
;					$iWidth - The width of the control
;					$iHeight - The height of the control
;					$iFontSize - [Optional] - Size of font
;					$sFontFamily - [Optional] - Font to use. Default font is 'Microsoft Sans Serif' (-1)
;					$iFontStyle - [Optional] - The style of the typeface. Can be a combination of the following:
;										0 - Normal weight or thickness of the typeface
;										1 - Bold typeface
;										2 - Italic typeface
;										4 - Underline
;										8 - Strikethrough
;					$iAlign - [Optional] - Sets the text alignment of a string. The alignment can be one of the following:
;										0 - The text is aligned to the left
;										1 - The text is centered
;										2 - The text is aligned to the right
;					$iColor - [Optional] - Color of text. (hex value Red, Green and Blue 0xRRGGBB. Default color is Black)
; Return values..:	Success - Index of label. Use with _GUICtrlFFLabel_SetData()
; Author.........:	Brian J Christy
; Remarks........:	None
; Example........:	Yes
; ===============================================================================================================
Func _GUICtrlFFLabel_Create($hWnd, $sText, $iLeft, $iTop, $iWidth, $iHeight, $iFontSize = 9, $sFontFamily = -1, $iFontStyle = 0, $iAlign = 0, $iColor = -1)
	If $sFontFamily = -1 Then $sFontFamily = 'Microsoft Sans Serif'
	If $iFontSize = -1 Then $iFontSize = 9
	If $iFontStyle = -1 Then $iFontStyle = 0
	If $iAlign = -1 Then $iAlign = 0
	If $iColor = -1 Then $iColor = 0x000000
	
	ReDim $a_GFFL_GDILbls[UBound($a_GFFL_GDILbls) + 1][$i_GFFL_Max]
	$a_GFFL_GDILbls[0][0] += 1
	
	__GUICtrlFFLabel_Graphics_N_DC($a_GFFL_GDILbls[0][0], $hWnd)
	
	$a_GFFL_GDILbls[$a_GFFL_GDILbls[0][0]][$h_GFFL_Wnd] = $hWnd
	$a_GFFL_GDILbls[$a_GFFL_GDILbls[0][0]][$i_GFFL_Left] = $iLeft
	$a_GFFL_GDILbls[$a_GFFL_GDILbls[0][0]][$i_GFFL_Top] = $iTop
	$a_GFFL_GDILbls[$a_GFFL_GDILbls[0][0]][$i_GFFL_Width] = $iWidth
	$a_GFFL_GDILbls[$a_GFFL_GDILbls[0][0]][$i_GFFL_Height] = $iHeight
	$a_GFFL_GDILbls[$a_GFFL_GDILbls[0][0]][$i_GFFL_Def_Bk_Color] = $i_GFFL_GUIDefBkColor
	
	Local $iGraphicsIndex = $a_GFFL_GDILbls[$a_GFFL_GDILbls[0][0]][$i_GFFL_GraphicsIndex]
	$a_GFFL_GDILbls[$a_GFFL_GDILbls[0][0]][$h_GFFL_Bitmap] = _GDIPlus_BitmapCreateFromGraphics($iWidth, $iHeight, $a_GFFL_hGraphics[$iGraphicsIndex])
	$a_GFFL_GDILbls[$a_GFFL_GDILbls[0][0]][$h_GFFL_Buffer] = _GDIPlus_ImageGetGraphicsContext($a_GFFL_GDILbls[$a_GFFL_GDILbls[0][0]][$h_GFFL_Bitmap])
	$a_GFFL_GDILbls[$a_GFFL_GDILbls[0][0]][$h_GFFL_Brush] = _GDIPlus_BrushCreateSolid("0xFF" & Hex($iColor, 6))
	$a_GFFL_GDILbls[$a_GFFL_GDILbls[0][0]][$s_GFFL_FontFamily] = _GDIPlus_FontFamilyCreate($sFontFamily)
	$a_GFFL_GDILbls[$a_GFFL_GDILbls[0][0]][$h_GFFL_Stringformat] = _GDIPlus_StringFormatCreate()
	_GDIPlus_StringFormatSetAlign($a_GFFL_GDILbls[$a_GFFL_GDILbls[0][0]][$h_GFFL_Stringformat], $iAlign)
	$a_GFFL_GDILbls[$a_GFFL_GDILbls[0][0]][$h_GFFL_Font] = _GDIPlus_FontCreate($a_GFFL_GDILbls[$a_GFFL_GDILbls[0][0]][$s_GFFL_FontFamily], $iFontSize, $iFontStyle)
	_GDIPlus_GraphicsSetSmoothingMode($a_GFFL_GDILbls[$a_GFFL_GDILbls[0][0]][$h_GFFL_Buffer], 4)
	$a_GFFL_GDILbls[$a_GFFL_GDILbls[0][0]][$i_GFFL_Layout] = _GDIPlus_RectFCreate(0, 0, $iWidth, $iHeight)
	$a_GFFL_GDILbls[$a_GFFL_GDILbls[0][0]][$b_GFFL_Removed] = False
	_GUICtrlFFLabel_SetData($a_GFFL_GDILbls[0][0], $sText)
	
	If $a_GFFL_GDILbls[0][0] = 1 And $b_GFFL_AutoRefresh Then
		GUIRegisterMsg($WM_PAINT, "__GUICtrlFFLabel_WM_PAINT"); Register PAINT-Event 0x000F = $WM_PAINT (WindowsConstants.au3)
		GUIRegisterMsg($WM_NCPAINT, "__GUICtrlFFLabel_WM_PAINT") ; $WM_NCPAINT = 0x0085 (WindowsConstants.au3)Restore after Minimize.
	EndIf
	
	Return $a_GFFL_GDILbls[0][0]
EndFunc

; #FUNCTION# ====================================================================================================
; Name...........:	_GUICtrlFFLabel_SetData
; Description....:	Sets text of Flicker Free Label
; Syntax.........:	_GUICtrlFFLabel_SetData($iIndex, $sText [, $iBackGround = -1 ])
; Parameters.....:	$iIndex - Index returned from _GUICtrlFFLabel_Create()
;					$sText - Text you want to be displayed
;					$iBackGround - [Optional] - background color of text. Default or -1 is the GUI window background color.
; Return values..:	Success - sets the text of label
; Author.........:	Brian J Christy
; Remarks........:	tip: when your laying out your gui, having the background color different helps show you full size of label.
; Example........:	Yes
; ===============================================================================================================
Func _GUICtrlFFLabel_SetData($iIndex, $sText, $iBackGround = -1)
	If $iIndex > $a_GFFL_GDILbls[0][0] Or $a_GFFL_GDILbls[$iIndex][$b_GFFL_Removed] Or $a_GFFL_GDILbls[$iIndex][$b_GFFL_IsMinimized] Then
		Return SetError(-1)
	EndIf
	
	If $iBackGround = Default Or $iBackGround = -1 Then
		$iBackGround = $a_GFFL_GDILbls[$iIndex][$i_GFFL_Def_Bk_Color]
	EndIf
	
	_GDIPlus_GraphicsClear($a_GFFL_GDILbls[$iIndex][$h_GFFL_Buffer], "0xFF" & Hex($iBackGround, 6))
	_GDIPlus_GraphicsDrawStringEx($a_GFFL_GDILbls[$iIndex][$h_GFFL_Buffer], $sText, _
		$a_GFFL_GDILbls[$iIndex][$h_GFFL_Font], $a_GFFL_GDILbls[$iIndex][$i_GFFL_Layout], _
		$a_GFFL_GDILbls[$iIndex][$h_GFFL_Stringformat], $a_GFFL_GDILbls[$iIndex][$h_GFFL_Brush])
	
	$a_GFFL_GDILbls[$iIndex][$s_GFFL_Restore] = $sText
	__GUICtrlFFLabel_WriteBuffer($iIndex)
EndFunc

; #FUNCTION# ====================================================================================================
; Name...........:	_GUICtrlFFLabel_Delete
; Description....:	Deletes Flicker Free Label.
; Syntax.........:	_GUICtrlFFLabel_Delete($iIndex)
; Parameters.....:	$iIndex - Index returned from _GUICtrlFFLabel_Create()
; Return values..:	Success - Deletes label.
; Author.........:	G.Sandler
; Remarks........:
; Example........:	Yes
; ===============================================================================================================
Func _GUICtrlFFLabel_Delete($iIndex)
	If $iIndex > $a_GFFL_GDILbls[0][0] Or $a_GFFL_GDILbls[$iIndex][$b_GFFL_Removed] Then
		Return SetError(-1)
	EndIf
	
	_GUICtrlFFLabel_SetData($iIndex, '')
	
	_GDIPlus_FontDispose($a_GFFL_GDILbls[$iIndex][$h_GFFL_Font])
	_GDIPlus_StringFormatDispose($a_GFFL_GDILbls[$iIndex][$h_GFFL_Stringformat])
	_GDIPlus_FontFamilyDispose($a_GFFL_GDILbls[$iIndex][$s_GFFL_FontFamily])
	_GDIPlus_BrushDispose($a_GFFL_GDILbls[$iIndex][$h_GFFL_Brush])
	_GDIPlus_GraphicsDispose($a_GFFL_GDILbls[$iIndex][$h_GFFL_Buffer])
	_GDIPlus_ImageDispose($a_GFFL_GDILbls[$iIndex][$h_GFFL_Bitmap])
	
	$a_GFFL_GDILbls[$iIndex][$h_GFFL_Wnd] = 0
	$a_GFFL_GDILbls[$iIndex][$i_GFFL_Top] = 0
	$a_GFFL_GDILbls[$iIndex][$i_GFFL_Width] = 0
	$a_GFFL_GDILbls[$iIndex][$i_GFFL_Height] = 0
	$a_GFFL_GDILbls[$iIndex][$h_GFFL_Bitmap] = 0
	$a_GFFL_GDILbls[$iIndex][$h_GFFL_Buffer] = 0
	$a_GFFL_GDILbls[$iIndex][$h_GFFL_Brush] = 0
	$a_GFFL_GDILbls[$iIndex][$s_GFFL_FontFamily] = 0
	$a_GFFL_GDILbls[$iIndex][$h_GFFL_Stringformat] = 0
	$a_GFFL_GDILbls[$iIndex][$h_GFFL_Font] = 0
	$a_GFFL_GDILbls[$iIndex][$i_GFFL_Layout] = 0
	$a_GFFL_GDILbls[$iIndex][$b_GFFL_Removed] = True
EndFunc

; #FUNCTION# ====================================================================================================
; Name...........:	_GUICtrlFFLabel_GUISetBkColor
; Description....:  Sets the backgound of the GUI and defualt backgound color of all FFlabels to match.
; Syntax.........:	_GUICtrlFFLabel_GUISetBkColor($nBkColor, $hWnd = -1)
; Parameters.....:	$nBkColor - Hex Color of text. (Red, Green and Blue 0xRRGGBB)
;					$hWnd - [Optional] - Windows handle as returned by GUICreate (default is the last created window).
; Return values..:	Success - Set GUI background color and set $i_GFFL_GUIDefBkColor to current color (to use in _GUICtrlFFLabel_SetData).
; Author.........:	G.Sandler (MrCreatoR), Brian J Christy
; Remarks........:	The window needs to be visible for this function to work so use after calling Guisetstate(@SW_SHOW).
; ===============================================================================================================
Func _GUICtrlFFLabel_GUISetBkColor($nBkColor, $hWnd = -1)
	If $hWnd = -1 Then
		$hWnd = $a_GFFL_GDILbls[$a_GFFL_GDILbls[0][0]][$h_GFFL_Wnd]
	EndIf
	
	GUISetBkColor($nBkColor, $hWnd)
	
	Local $iBkColor = __GUICtrlFFLabel_GetWindowBkColor($hWnd)
	
	For $i = 1 To $a_GFFL_GDILbls[0][0]
		If $a_GFFL_GDILbls[$i][$h_GFFL_Wnd] = $hWnd Then
			$a_GFFL_GDILbls[$i][$i_GFFL_Def_Bk_Color] = $iBkColor
		EndIf
	Next
	
	_GUICtrlFFLabel_RefreshAll()
EndFunc

; #FUNCTION# ====================================================================================================
; Name...........:	_GUICtrlFFLabel_SetTextColor
; Description....:	Sets text color of label
; Syntax.........:	_GUICtrlFFLabel_SetTextColor($iIndex, $nColor)
; Parameters.....:	$iIndex - Index returned from _GUICtrlFFLabel_Create()
;					$nColor - Color of text. (hex value Red, Green and Blue 0xRRGGBB. Default color is Black)
; Return values..:	Success - True
;					Failure - False
; Author.........:	Brian J Christy
; Remarks........:	None
; ===============================================================================================================
Func _GUICtrlFFLabel_SetTextColor($iIndex, $nColor = 0x000000)
	_GDIPlus_BrushSetSolidColor($a_GFFL_GDILbls[$iIndex][$h_GFFL_Brush], "0xFF" & Hex($nColor, 6))
	_GUICtrlFFLabel_RefreshAll()
EndFunc

; #FUNCTION# ====================================================================================================
; Name...........:	_GUICtrlFFLabel_Refresh
; Description....:	Refresh FF label.
; Syntax.........:	_GUICtrlFFLabel_Refresh($iIndex)
; Parameters.....:	$iIndex - Index returned from _GUICtrlFFLabel_Create().
; Return values..:	Success - Redraw label text.
; Author.........:	Brian J Christy, G.Sandler
; Remarks........:	None
; Example........:	Yes
; ===============================================================================================================
Func _GUICtrlFFLabel_Refresh($iIndex)
	_GUICtrlFFLabel_SetData($iIndex, $a_GFFL_GDILbls[$iIndex][$s_GFFL_Restore])
EndFunc

; #FUNCTION# ====================================================================================================
; Name...........:	_GUICtrlFFLabel_RefreshAll
; Description....:	Refresh all FF labels.
; Syntax.........:	_GUICtrlFFLabel_RefreshAll()
; Parameters.....:	$iIndex - Index returned from _GUICtrlFFLabel_Create().
; Return values..:	Success - Redraw all labels text.
; Author.........:	Brian J Christy, G.Sandler
; Remarks........:	None
; Example........:	Yes
; ===============================================================================================================
Func _GUICtrlFFLabel_RefreshAll()
	For $i = 1 To $a_GFFL_GDILbls[0][0]
		If IsHWnd($a_GFFL_GDILbls[$i][$h_GFFL_Wnd]) Then
			_GUICtrlFFLabel_Refresh($i)
		EndIf
	Next
EndFunc

; #FUNCTION# ====================================================================================================
; Name...........:	_GUICtrlFFLabel_SetAutoRefreshMode
; Description....:	Enable or disable auto-refresh of all FF labels.
; Syntax.........:	_GUICtrlFFLabel_SetAutoRefreshMode($bOn = True)
; Parameters.....:	None.
; Return values..:	Success - Enable or disable the auto-refresh process.
; Author.........:	G.Sandler (MrCreatoR)
; Remarks........:	None.
; Example........:	Yes
; ===============================================================================================================
Func _GUICtrlFFLabel_SetAutoRefreshMode($bOn = True)
	$b_GFFL_AutoRefresh = $bOn
EndFunc

#EndRegion Public Functions

#Region Internal Functions

; #FUNCTION# ====================================================================================================
; Name...........:	__GUICtrlFFLabel_GetWindowBkColor
; Description....:	Returns backgound color of GUI
; Syntax.........:	__GUICtrlFFLabel_GetWindowBkColor($hWnd = 0)
; Parameters.....:	$hWnd - [Optional] - Handle to Gui. If no handle passed ($hWnd = 0), function retruns GUI window default backgound color.
; Author.........:	G.Sandler (MrCreatoR)
; Remarks........:	None
; ===============================================================================================================
Func __GUICtrlFFLabel_GetWindowBkColor($hWnd = 0)
	Local $hDC, $iOpt, $iState, $nColor, $hBkGUI
	
	If $hWnd Then
		$hDC = _WinAPI_GetDC($hWnd)
		
		$iOpt = Opt("WinWaitDelay", 0)
		$iState = WinGetState($hWnd)
		
		If Not BitAND($iState, 2) Then WinSetState($hWnd, "", @SW_SHOWNOACTIVATE)
		$nColor = DllCall('gdi32.dll', 'int', 'GetBkColor', 'hwnd', $hDC)
		If Not BitAND($iState, 2) Then WinSetState($hWnd, "", @SW_HIDE)
		
		Opt("WinWaitDelay", $iOpt)
		_WinAPI_ReleaseDC($hWnd, $hDC)
		
		If Not IsArray($nColor) Then
			Return SetError(1)
		EndIf
		
		$nColor = $nColor[0] ;BGR
		$nColor = Hex(BitOR(BitAND($nColor, 0x00FF00), BitShift(BitAND($nColor, 0x0000FF), -16), BitShift(BitAND($nColor, 0xFF0000), 16)), 6) ;convert to RGB
		
		Return "0x" & $nColor
	EndIf
	
	$hBkGUI = GUICreate("", 2, 2, -3, -3, $WS_POPUP, $WS_EX_TOOLWINDOW)
	GUISetState(@SW_SHOWNOACTIVATE, $hBkGUI)
	$nColor = "0x" & Hex(__GUICtrlFFLabel_PixelGetColorEx(1, 1, $hBkGUI), 6)
	GUIDelete($hBkGUI)
	
	Return $nColor
EndFunc

Func __GUICtrlFFLabel_PixelGetColorEx($iX, $iY, $hWnd)
	Local $iWidth, $iHeight, $hDDC, $hCDC, $hBMP, $nColor
	
	$iWidth = _WinAPI_GetWindowWidth($hWnd)
	$iHeight = _WinAPI_GetWindowHeight($hWnd)
	$hDDC = _WinAPI_GetDC($hWnd)
	$hCDC = _WinAPI_CreateCompatibleDC($hDDC)
	$hBMP = _WinAPI_CreateCompatibleBitmap($hDDC, $iWidth, $iHeight)
	_WinAPI_SelectObject($hCDC, $hBMP)
	
	DllCall("User32.dll", "int", "PrintWindow", "hwnd", $hWnd, "hwnd", $hCDC, "int", 0) 
	$nColor = DllCall('gdi32.dll', 'dword', 'GetPixel', 'hwnd', $hCDC, 'int', $iX, 'int', $iY)
	
	_WinAPI_ReleaseDC($hWnd, $hDDC)
	_WinAPI_DeleteDC($hCDC)
	
	If Not IsArray($nColor) Then
		Return SetError(1)
	EndIf
	
	$nColor = $nColor[0]
	$nColor = BitOR(BitAND($nColor, 0x00FF00), BitShift(BitAND($nColor, 0x0000FF), -16), BitShift(BitAND($nColor, 0xFF0000), 16))
	
	Return $nColor
EndFunc

Func __GUICtrlFFLabel_WriteBuffer($iIndex)
	Local $hGDI_HBitmap = _GDIPlus_BitmapCreateHBITMAPFromBitmap($a_GFFL_GDILbls[$iIndex][$h_GFFL_Bitmap])
	Local $hDC = _WinAPI_CreateCompatibleDC($a_GFFL_hDCs[$a_GFFL_GDILbls[$iIndex][$i_GFFL_DCIndex]])
	_WinAPI_SelectObject($hDC, $hGDI_HBitmap)
	_WinAPI_BitBlt($a_GFFL_hDCs[$a_GFFL_GDILbls[$iIndex][$i_GFFL_DCIndex]], _
		$a_GFFL_GDILbls[$iIndex][$i_GFFL_Left], $a_GFFL_GDILbls[$iIndex][$i_GFFL_Top], _
		$a_GFFL_GDILbls[$iIndex][$i_GFFL_Width], $a_GFFL_GDILbls[$iIndex][$i_GFFL_Height], $hDC, 0, 0, 0x00CC0020);$SRCCOPY)
	_WinAPI_DeleteObject($hGDI_HBitmap)
	_WinAPI_DeleteDC($hDC)
EndFunc

Func __GUICtrlFFLabel_WM_PAINT()
	If $b_GFFL_AutoRefresh Then _GUICtrlFFLabel_RefreshAll()
	Return $GUI_RUNDEFMSG
EndFunc

Func __GUICtrlFFLabel_Graphics_N_DC($iIndex, $hWnd)
	;Go through array and see if the GUI hwnd already exists. If it does set the new label to use the hwnds Graphics and DC.
	For $i = 1 To $a_GFFL_GDILbls[0][0]
		If $a_GFFL_GDILbls[$i][$h_GFFL_Wnd] = $hWnd Then
			$a_GFFL_GDILbls[$iIndex][$i_GFFL_GraphicsIndex] = $a_GFFL_GDILbls[$i][$i_GFFL_GraphicsIndex]
			$a_GFFL_GDILbls[$iIndex][$i_GFFL_DCIndex] = $a_GFFL_GDILbls[$i][$i_GFFL_DCIndex]
			Return
		EndIf
	Next

	;If we got this far then it is a new GUI handle. Create the Graphics and DC for that handle and then set new label to use those objects.
	ReDim $a_GFFL_hGraphics[UBound($a_GFFL_hGraphics) + 1]
	$a_GFFL_hGraphics[0] += 1
	ReDim $a_GFFL_hDCs[UBound($a_GFFL_hDCs) + 1]
	$a_GFFL_hDCs[0] += 1

	$a_GFFL_hGraphics[$a_GFFL_hGraphics[0]] = _GDIPlus_GraphicsCreateFromHWND($hWnd)
	$a_GFFL_hDCs[$a_GFFL_hDCs[0]] = _WinAPI_GetDC($hWnd)
	$a_GFFL_GDILbls[$iIndex][$i_GFFL_GraphicsIndex] = $a_GFFL_hGraphics[0]
	$a_GFFL_GDILbls[$iIndex][$i_GFFL_DCIndex] = $a_GFFL_hDCs[0]

EndFunc

Func __GUICtrlFFLabel_Dispose()
	For $i = 1 To $a_GFFL_GDILbls[0][0]
		If Not $a_GFFL_GDILbls[$i][$b_GFFL_Removed] Then
			_GDIPlus_FontDispose($a_GFFL_GDILbls[$i][$h_GFFL_Font])
			_GDIPlus_StringFormatDispose($a_GFFL_GDILbls[$i][$h_GFFL_Stringformat])
			_GDIPlus_FontFamilyDispose($a_GFFL_GDILbls[$i][$s_GFFL_FontFamily])
			_GDIPlus_BrushDispose($a_GFFL_GDILbls[$i][$h_GFFL_Brush])
			_GDIPlus_GraphicsDispose($a_GFFL_GDILbls[$i][$h_GFFL_Buffer])
			_GDIPlus_ImageDispose($a_GFFL_GDILbls[$i][$h_GFFL_Bitmap])
		EndIf
	Next
	
	For $i = 1 To $a_GFFL_hGraphics[0]
		_GDIPlus_GraphicsDispose($a_GFFL_hGraphics[$i])
		For $j = 1 To $a_GFFL_GDILbls[0][0]
			If $a_GFFL_GDILbls[$j][$i_GFFL_DCIndex] = $i Then
				_WinAPI_ReleaseDC($a_GFFL_GDILbls[$j][$h_GFFL_Wnd], $a_GFFL_hDCs[$i])
				ExitLoop
			EndIf
		Next
	Next
	
	_GDIPlus_Shutdown()
EndFunc

#EndRegion Internal Functions
