#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>
#include "GUICtrlSetResizing.au3"

$hGUI = GUICreate("_GUICtrl_SetOnResize - Example", 700, 480) ;, -1, -1, BitOr($GUI_SS_DEFAULT_GUI, $WS_SIZEBOX))

$Edit = GUICtrlCreateEdit("Resize only Left edge", 40, 40, 280, 200)
_GUICtrl_SetOnResize($hGUI, $Edit, 10, $iGCSOR_DefCtrlMinSize, $iGCSOR_RESIZE_LEFT) ;Resize only Left edge (-1 or $iGCSOR_RESIZE_ALL to resize all)

$ListView = GUICtrlCreateListView("ListView Column", 340, 40, 300, 200)
GUICtrlCreateListViewItem("Item (Top + Bottom)", $ListView)
_GUICtrl_SetOnResize($hGUI, $ListView, 10, $iGCSOR_DefCtrlMinSize, BitOR($iGCSOR_RESIZE_TOP, $iGCSOR_RESIZE_BOTTOM)) ;Resize Top + Bottom

$Checkbox = GUICtrlCreateCheckbox("Some Checkbox (Left + Right)", 40, 270)
GUICtrlSetBkColor(-1, 0xFFFFFF)
_GUICtrl_SetOnResize($hGUI, $Checkbox, 10, $iGCSOR_DefCtrlMinSize, BitOR($iGCSOR_RESIZE_LEFT, $iGCSOR_RESIZE_RIGHT)) ;Resize Left + Right

$Label = GUICtrlCreateLabel("Some Label (Top + Right)", 40, 320, -1, 15)
GUICtrlSetBkColor(-1, 0x0000FF)
GUICtrlSetColor(-1, 0xFFFFFF)
_GUICtrl_SetOnResize($hGUI, $Label, 10, 15, BitOR($iGCSOR_RESIZE_TOP, $iGCSOR_RESIZE_RIGHT)) ;Resize Top + Right

$Button = GUICtrlCreateButton("Some Button (All corners)", 40, 370, 160, 40)
_GUICtrl_SetOnResize($hGUI, $Button, 10, $iGCSOR_DefCtrlMinSize, $iGCSOR_RESIZE_ALLCORNERS) ;Resize All Corners

GUISetState(@SW_SHOW, $hGUI)

While 1
	$nMsg = GUIGetMsg()
	
	Switch $nMsg
		Case $GUI_EVENT_CLOSE
			Exit
	EndSwitch
WEnd