#Region Header

#CS
	Name:				GUICtrlRegExpRestrict.au3 (renamed from RestrictControlRegExp.au3)
	Description:		This UDF can restrict the text typed into input controls live while typing based on a given Regular Expression.
	Author:				peethebee (peethebee@gmx.de, http://www.autoit.de), modified by G.Sandler (CreatoR), www.autoit-script.ru
	AutoIt version:		3.3.6.1 - 3.3.12.0
	UDF version:		1.4
	
	Notes:				based on a script by gafrost in this thread:
						http://www.autoitscript.com/forum/index.php?showtopic=31556&hl=guiregistermsg
	
	History:
						[1.4]
							* Removed Startup and Shutdown functions, now it's initialized at first usage.
							* Now the selection preserved when the user input is not allowed (using keyboard and mouse hooks).
							* Fixed major bug in _GUICtrlRegExpRestrict_RemovePattern.
							* Fixed issue with setting back the default input color.
							* Tested on AutoIt 3.3.12.0.
						
						[1.3]
							* Fixed issue when white color was set for last control (not only on input controls).
							* All variables are now declared.
							* Example's patterns improved.
							* Minor fixes.
	
	
	
#CE

;Includes
#include-once
#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>
#include <EditConstants.au3>
#include <WinAPI.au3>

#EndRegion Header

#Region Global Variables

Global $a_GCRER_Arr[1][4] = [[0]]
Global $a_GCRER_InputSel[2] = [0, 0]
Global $i_GCRER_LastCtrlID = 0
Global $b_GCRER_AlertOnRestrict = True
Global $i_GCRER_AlertDelay = 2500
Global $n_GCRER_CtrlAlertBkColor = 0xFFCACA
Global $n_GCRER_CtrlDefBkColor = Default ;0xFFFFFF

Global $h_GCRER_Keyboard_Callback = DllCallbackRegister('__GCRER_Keyboard_Proc', 'int', 'int;ptr;ptr')
Global $h_GCRER_Mouse_Callback = DllCallbackRegister('__GCRER_Mouse_Proc', 'int', 'int;ptr;ptr')
Global $h_GCRER_Mouse_Hook = 0
Global $h_GCRER_Keyboard_Hook = 0

OnAutoItExitRegister('__GCRER_OnExit')

#EndRegion Global Variables

#Region Public Functions

;===============================================================================
;
; Function Name:   	_GUICtrlRegExpRestrict_SetPattern
; Description:		Sets up the restriction pattern for a control.
; Parameter(s):    	$i_RC_CtrlID
;						ID of the control to be monitored
;					$s_RC_RegExp_Pattern
;						RegExp which has to be fullfilled or fullfillable
;					$s_RC_Valid_String (optional, default "")
;						Valid string for testing if RegExp can still be fullfilled.
; Requirement(s):  	This UDF included
; Return Value(s): 	None.
; Author(s):       	peethebee, G.Sandler
;
;===============================================================================
Func _GUICtrlRegExpRestrict_SetPattern($i_RC_CtrlID, $s_RC_RegExp_Pattern, $s_RC_Valid_String = '')
	If $h_GCRER_Mouse_Hook = 0 Then
		GUIRegisterMsg($WM_COMMAND, '__GCRER_Handler')
		Local $hModule = _WinAPI_GetModuleHandle(0)
		$h_GCRER_Keyboard_Hook = _WinAPI_SetWindowsHookEx($WH_KEYBOARD_LL, DllCallbackGetPtr($h_GCRER_Keyboard_Callback), $hModule)
		$h_GCRER_Mouse_Hook = _WinAPI_SetWindowsHookEx($WH_MOUSE_LL, DllCallbackGetPtr($h_GCRER_Mouse_Callback), $hModule)
	EndIf
	
	If $i_RC_CtrlID = -1 Then
		$i_RC_CtrlID = __GCRER_GUIGetLastCtrlID()
	EndIf
	
	$a_GCRER_Arr[0][0] += 1
	ReDim $a_GCRER_Arr[$a_GCRER_Arr[0][0]+1][4]
	
	$a_GCRER_Arr[$a_GCRER_Arr[0][0]][0] = $i_RC_CtrlID
	$a_GCRER_Arr[$a_GCRER_Arr[0][0]][1] = $s_RC_RegExp_Pattern
	$a_GCRER_Arr[$a_GCRER_Arr[0][0]][2] = $s_RC_Valid_String
	$a_GCRER_Arr[$a_GCRER_Arr[0][0]][3] = ''
EndFunc

;===============================================================================
;
; Function Name:   	_GUICtrlRegExpRestrict_RemovePattern
; Description:		Remove the restriction pattern from the control.
; Parameter(s):    	$i_RC_CtrlID
;						Control ID to remove the restricted pattern from.
;
; Requirement(s):  	This UDF included
; Return Value(s): 	None.
; Author(s):       	G.Sandler
;
;===============================================================================
Func _GUICtrlRegExpRestrict_RemovePattern($i_RC_CtrlID)
	Local $a__RegEx_RC_Tmp[1][4]
	
	For $i = 1 To $a_GCRER_Arr[0][0]
		If $a_GCRER_Arr[$i][0] <> $i_RC_CtrlID Then
			$a__RegEx_RC_Tmp[0][0] += 1
			ReDim $a__RegEx_RC_Tmp[$a__RegEx_RC_Tmp[0][0] + 1][4]
			
			$a__RegEx_RC_Tmp[$a__RegEx_RC_Tmp[0][0]][0] = $a_GCRER_Arr[$i][0]
			$a__RegEx_RC_Tmp[$a__RegEx_RC_Tmp[0][0]][1] = $a_GCRER_Arr[$i][1]
			$a__RegEx_RC_Tmp[$a__RegEx_RC_Tmp[0][0]][2] = $a_GCRER_Arr[$i][2]
			$a__RegEx_RC_Tmp[$a__RegEx_RC_Tmp[0][0]][3] = $a_GCRER_Arr[$i][3]
		EndIf
	Next
	
	$a_GCRER_Arr = $a__RegEx_RC_Tmp
EndFunc

#EndRegion Public Functions

#Region Internal Functions

;===============================================================================
;
; Function Name:   	__GCRER_Handler
; Description:		Internal processing function - not to be called from outside!
; Parameter(s):    	[...]
; Requirement(s):  	This UDF included
; Return Value(s): 	None.
; Author(s):       	peethebee (using gafrost's work as a basis)
;
;===============================================================================
Func __GCRER_Handler($hWnd, $msg, $wParam, $lParam)
	Local $nNotifyCode = BitShift($wParam, 16)
	Local $nID = BitAND($wParam, 0xFFFF)
	Local $hCtrl = $lParam
	Local $_re_rc_regex_res
	
	For $i = 1 To $a_GCRER_Arr[0][0]
		If $nID = $a_GCRER_Arr[$i][0] Then
			Switch $nNotifyCode
				Case $EN_UPDATE;, $EN_CHANGE
					__GCRER_ResetColor()
					
					; Check RegEx and set text
					For $j = 0 To StringLen($a_GCRER_Arr[$i][2])
						$_re_rc_regex_res = 1
						
						If StringRegExp(GUICtrlRead($a_GCRER_Arr[$i][0]) & StringTrimLeft($a_GCRER_Arr[$i][2], $j), $a_GCRER_Arr[$i][1]) Then
							ExitLoop
						EndIf
						
						$_re_rc_regex_res = 0
					Next
					
					If $_re_rc_regex_res = 1 Then
						; save string as 'good' value for later resettability
						$a_GCRER_Arr[$i][3] = GUICtrlRead($a_GCRER_Arr[$i][0])
					Else
						; reset Text to last known good value
						GUICtrlSetData($nID, $a_GCRER_Arr[$i][3])
						
						; restore the selection
						If UBound($a_GCRER_InputSel) <= 1 Then
							Dim $a_GCRER_InputSel[2] = [0, 0]
						EndIf
						
						GUICtrlSendMsg($nID, $EM_SETSEL, $a_GCRER_InputSel[0], $a_GCRER_InputSel[1])
						
						; set alert color
						If $b_GCRER_AlertOnRestrict Then
							GUICtrlSetBkColor($nID, $n_GCRER_CtrlAlertBkColor)
							AdlibRegister('__GCRER_ResetColor', $i_GCRER_AlertDelay)
							
							;Comment next line to remove the 'Beep Sound' on wrong set of characters
							DllCall('User32.dll', 'int', 'MessageBeep', 'int', -1)
						EndIf
					EndIf
					
					$i_GCRER_LastCtrlID = $nID
				Case $EN_SETFOCUS
					$i_GCRER_LastCtrlID = $nID
					ContinueCase
				Case $EN_KILLFOCUS
					__GCRER_ResetColor()
			EndSwitch
			
			ExitLoop
		EndIf
	Next
	
	Return $GUI_RUNDEFMSG
EndFunc

Func __GCRER_Keyboard_Proc($nCode, $wParam, $lParam)
	If $nCode < 0 Then
		Return _WinAPI_CallNextHookEx($h_GCRER_Keyboard_Hook, $nCode, $wParam, $lParam)
	EndIf
	
	If $i_GCRER_LastCtrlID And ControlGetHandle('[ACTIVE]', '', ControlGetFocus('[ACTIVE]')) = GUICtrlGetHandle($i_GCRER_LastCtrlID) Then
		$a_GCRER_InputSel = GUICtrlRecvMsg($i_GCRER_LastCtrlID, $EM_GETSEL)
	EndIf
	
	Return _WinAPI_CallNextHookEx($h_GCRER_Keyboard_Hook, $nCode, $wParam, $lParam)
EndFunc

Func __GCRER_Mouse_Proc($nCode, $wParam, $lParam)
	If $nCode < 0 Then
		Return _WinAPI_CallNextHookEx($h_GCRER_Mouse_Hook, $nCode, $wParam, $lParam)
	EndIf
	
	If $i_GCRER_LastCtrlID And ControlGetHandle('[ACTIVE]', '', ControlGetFocus('[ACTIVE]')) = GUICtrlGetHandle($i_GCRER_LastCtrlID) Then
		$a_GCRER_InputSel = GUICtrlRecvMsg($i_GCRER_LastCtrlID, $EM_GETSEL)
	EndIf
	
	Return _WinAPI_CallNextHookEx($h_GCRER_Mouse_Hook, $nCode, $wParam, $lParam)
EndFunc

Func __GCRER_GUIGetLastCtrlID()
	Local $aRet = DllCall('user32.dll', 'int', 'GetDlgCtrlID', 'hwnd', GUICtrlGetHandle(-1))
	
	If @error Then
		Return SetError(1)
	EndIf
	
	Return $aRet[0]
EndFunc

Func __GCRER_ResetColor()
	AdlibUnRegister('__GCRER_ResetColor')
	GUICtrlSetBkColor($i_GCRER_LastCtrlID, $n_GCRER_CtrlDefBkColor)
EndFunc

Func __GCRER_OnExit()
	_WinAPI_UnhookWindowsHookEx($h_GCRER_Mouse_Hook)
	_WinAPI_UnhookWindowsHookEx($h_GCRER_Keyboard_Hook)
	DllCallbackFree($h_GCRER_Keyboard_Callback)
	DllCallbackFree($h_GCRER_Mouse_Callback)
EndFunc

#EndRegion Internal Functions
