#include <GUIConstantsEx.au3>
#include 'GUICtrlRegExpRestrict.au3'

$hGUI = GUICreate('GUICtrlRegExpRestrict Example', 400, 400)

GUICtrlCreateLabel('Restrict type: [Up to 10 letters]', 130, 12)
$Input_1 = GUICtrlCreateInput('', 10, 10, 100, 20)
_GUICtrlRegExpRestrict_SetPattern(-1, '^[a-z]{0,10}$')

GUICtrlCreateLabel('Restrict type: [European(?) date format DD.MM.YYYY]', 130, 82)
$Input_2 = GUICtrlCreateInput('', 10, 80, 100, 20)
_GUICtrlRegExpRestrict_SetPattern(-1, '^([012][0-9]|3[01])\.(0[1-9]|1[012])\.\d{4}$', '31.12.1999')

GUICtrlCreateLabel('Restrict type: [e-Mail address]', 130, 152)
$Input_3 = GUICtrlCreateInput('', 10, 150, 100, 20)
_GUICtrlRegExpRestrict_SetPattern(-1, '^\w{1,20}@\w{2,20}\.[a-z]{2,4}$', 'g@gm.de')

GUICtrlCreateLabel('Restrict type: [Day of month (including ranges)]', 130, 222)
$Input_4 = GUICtrlCreateInput('', 10, 220, 100, 20)
_GUICtrlRegExpRestrict_SetPattern(-1, '^(((?<![3-9])[0-9]|(?<=3)[0-1]){1,2}(?!\d)(, ?|-)?)*$')

GUICtrlCreateLabel('Restrict type: [Full file version, ex: 1.0.0.0]', 130, 292)
$Input_5 = GUICtrlCreateInput('', 10, 290, 100, 20)
_GUICtrlRegExpRestrict_SetPattern(-1, '^\d+\.\d+\.\d+\.\d+$', '1.0.0.0')

GUISetState(@SW_SHOW, $hGUI)

While 1
	Switch GUIGetMsg()
		Case $GUI_EVENT_CLOSE
			Exit
	EndSwitch
WEnd