#include-once
#include <WinAPISys.au3>
#include <EditConstants.au3>
#include <WindowsConstants.au3>

OnAutoItExitRegister('__AppInteraction_OnExit')

Global Const $sAppInteraction_Class = 'Au3AppIntercatWindowClass'
Global Enum $iAppInteraction_Inst, $iAppInteraction_WndProc, $iAppInteraction_Window, $iAppInteraction_Reciever, _
	$iAppInteraction_Total
Global $aAppInteraction_Data[$iAppInteraction_Total]

Func _AppInteraction_SetReciever($sAppName, $sFuncName)
	__AppInteraction_WndCreate($sAppName)
	$aAppInteraction_Data[$iAppInteraction_Reciever] = $sFuncName
EndFunc

Func _AppInteraction_Send($sAppName, $sData)
	Local $hWnd = WinGetHandle('[CLASS:' & $sAppInteraction_Class & ';TITLE:' & $sAppName & ']')
	
	If Not IsHWnd($hWnd) Then
		Return SetError(1, 0, 0)
	EndIf
	
	ControlSetText($hWnd, '', 'Edit1', $sData)
	_WinAPI_PostMessage($hWnd, $WM_USER, 0, 1001)
	
	Return 1
EndFunc

Func __AppInteraction_WndCreate($sName)
	; Get module handle for the current process
	$aAppInteraction_Data[$iAppInteraction_Inst] = _WinAPI_GetModuleHandle(0)
	
	; Create DLL callback function (window procedure)
	$aAppInteraction_Data[$iAppInteraction_WndProc] = DllCallbackRegister('__AppInteraction_WndProc', 'lresult', 'hwnd;uint;wparam;lparam')
	
	; Create and fill $tagWNDCLASSEX structure
	Local $tWCEX = DllStructCreate($tagWNDCLASSEX & ';wchar szClassName[' & (StringLen($sAppInteraction_Class) + 1) & ']')
	DllStructSetData($tWCEX, 'Size', DllStructGetPtr($tWCEX, 'szClassName') - DllStructGetPtr($tWCEX))
	DllStructSetData($tWCEX, 'Style', 0)
	DllStructSetData($tWCEX, 'hWndProc', DllCallbackGetPtr($aAppInteraction_Data[$iAppInteraction_WndProc]))
	DllStructSetData($tWCEX, 'ClsExtra', 0)
	DllStructSetData($tWCEX, 'WndExtra', 0)
	DllStructSetData($tWCEX, 'hInstance', $aAppInteraction_Data[$iAppInteraction_Inst])
	DllStructSetData($tWCEX, 'hIcon', 0)
	DllStructSetData($tWCEX, 'hCursor', 0)
	DllStructSetData($tWCEX, 'hBackground', _WinAPI_CreateSolidBrush(_WinAPI_GetSysColor($COLOR_3DFACE)))
	DllStructSetData($tWCEX, 'MenuName', 0)
	DllStructSetData($tWCEX, 'ClassName', DllStructGetPtr($tWCEX, 'szClassName'))
	DllStructSetData($tWCEX, 'hIconSm', 0)
	DllStructSetData($tWCEX, 'szClassName', $sAppInteraction_Class)
	
	; Register a window class
	_WinAPI_RegisterClassEx($tWCEX)
	
	; Create a window and Edit control
	$aAppInteraction_Data[$iAppInteraction_Window] = _WinAPI_CreateWindowEx(0, $sAppInteraction_Class, $sName, BitOR($WS_CAPTION, $WS_POPUPWINDOW), 0, 0, 100, 100, 0)
	Local $hEdit = _WinAPI_CreateWindowEx(0, 'Edit', '', BitOR($WS_CHILD, $ES_MULTILINE), 0, 0, 100, 100, $aAppInteraction_Data[$iAppInteraction_Window])
	
	; Set controls identifiers
	_WinAPI_SetWindowLong($hEdit, $GWL_ID, 1001)
EndFunc

Func __AppInteraction_OnExit()
	; Unregister window class and release unnecessary resources
	_WinAPI_UnregisterClass($sAppInteraction_Class, $aAppInteraction_Data[$iAppInteraction_Inst])
	_WinAPI_DestroyWindow($aAppInteraction_Data[$iAppInteraction_Window])
	DllCallbackFree($aAppInteraction_Data[$iAppInteraction_WndProc])
EndFunc

Func __AppInteraction_WndProc($hWnd, $iMsg, $wParam, $lParam)
	Switch $iMsg
		Case $WM_USER
			If $lParam = 1001 Then
				Local $sData = ControlGetText($hWnd, '', 'Edit1')
				ControlSetText($hWnd, '', 'Edit1', '')
				Call($aAppInteraction_Data[$iAppInteraction_Reciever], $sData)
			EndIf
	EndSwitch
	
	Return _WinAPI_DefWindowProcW($hWnd, $iMsg, $wParam, $lParam)
EndFunc
