local function IsEditorAvailable()
	return pcall(editor.WordStartPosition, editor, 0)
end

local function IsEnabled()
	return props["autoit.use.pixmaps"] == "1"
end

local function IsValidPixmap(data)
	return data:find("/%* XPM %*/")
end

local function GetLibraryInUse()
	return props["autoit.pixmap.using.library"] == "1"
end

local function SetLibraryInUse(state)
	if state then
		props["autoit.pixmap.using.library"] = "1"
	else
		props["autoit.pixmap.using.library"] = "0"
	end
end

local function GetLoaded()
	return props["autoit.pixmaps.loaded"] == "1"
end

local function SetLoaded(state)
	if state then
		props["autoit.pixmaps.loaded"] = "1"
	else
		props["autoit.pixmaps.loaded"] = "0"
	end
end

local function GetVariableInUse()
	return props["autoit.pixmap.using.variable"] == "1"
end

local function SetVariableInUse(state)
	if state then
		props["autoit.pixmap.using.variable"] = "1"
	else
		props["autoit.pixmap.using.variable"] = "0"
	end
end

local function LoadPixmap()
	if IsEnabled() and IsEditorAvailable() then
		if not IsLexer(SCLEX_AU3) then
			if GetLoaded() then
				SetLoaded(false)
				SetVariableInUse(false)
				SetLibraryInUse(false)
				editor:ClearRegisteredImages()
			end
			return
		elseif GetLoaded() then
			return
		end
		SetLoaded(true)
		local images = {
			["function"] = -1,
			["special"] = 1,
			["preprocessor"] = 2,
			["macro"] = 3,
			["keyword"] = 4
		}
		for key, value in pairs(images) do
			local xpm_data = props["autoit.pixmap." .. key]
			if IsValidPixmap(xpm_data) then
				editor:RegisterImage(value, xpm_data)
			end
		end
	end
end

function SetPixmap()
	if not IsLexer(SCLEX_AU3) then return end
	if IsEnabled() then
		local tCharVal = editor.CharAt[editor:WordStartPosition(editor.CurrentPos)]
		if tCharVal < 0 then
			tCharVal = 256 + tCharVal
		end
		local char = string.char(tCharVal)
		local xpm_data
		if char == "$" then
			if not GetVariableInUse() then
				xpm_data = props["autoit.pixmap.variable"]
				if IsValidPixmap(xpm_data) then
					editor:RegisterImage(-1, xpm_data)
				end
				SetVariableInUse(true)
				SetLibraryInUse(false)
			end
		elseif char == "_"  then
			if not GetLibraryInUse() then
				xpm_data = props["autoit.pixmap.library"]
				if IsValidPixmap(xpm_data) then
					editor:RegisterImage(-1, xpm_data)
				end
				SetLibraryInUse(true)
				SetVariableInUse(false)
			end
		elseif GetVariableInUse() or GetLibraryInUse() then
			xpm_data = props["autoit.pixmap.function"]
			if IsValidPixmap(xpm_data) then
				editor:RegisterImage(-1, xpm_data)
			end
			SetVariableInUse(false)
			SetLibraryInUse(false)
		end
	end
end

AddEventHandler("OnMenuCommand", function(msg, source)
	if (msg == IDM_COMPLETE) or (msg == IDM_COMPLETEWORD) then
		SetPixmap()
	end
	if (msg == IDM_COMPLETE) then
		local tCharVal = editor.CharAt[editor:WordStartPosition(editor.CurrentPos)]
		if tCharVal < 0 then
			tCharVal = 256 + tCharVal
		end
		if string.char(tCharVal) == "$" then
			scite.MenuCommand(IDM_COMPLETEWORD)
			return true
		end
	end
end)

AddEventHandler("OnOpen", LoadPixmap)
AddEventHandler("OnSwitchFile", LoadPixmap)

AddEventHandler("OnChar", SetPixmap)
