local function LoadEndStatements()
	local text = props["block.end.$(au3)"]
	local data = { }
	for word in text:gmatch("%a+") do
		data[word:lower()] = true
	end
	return data
end

local EndStatements = LoadEndStatements()

AddEventHandler("OnKey", function(code)
	local return_value = false
	if (code == 0x0D) and (IsLexer(SCLEX_AU3)) and (not editor:AutoCActive()) then
		local line = editor:LineFromPosition(editor.CurrentPos)
		local if_pattern = "^%s*[Ii][Ff].-[Tt][Hh][Ee][Nn]%s*[^;%s]+"
		local unused1, unused2, word_end = MatchWordAtStart("", line)
		if editor.CurrentPos < word_end then
			return false
		end
		editor:BeginUndoAction()
		if MatchWordAtStart("If", line) then
			if string.find(editor:GetLine(line), if_pattern) then
				editor:NewLine()
				editor:BackTab()
				return_value = true
			end
		end
		if MatchWordAtStart("Case", line) then
			for i = 1, 5 do
				local line_prev = line - i
				if MatchWordAtStart("Case", line_prev) then
					break
				end
				if MatchWordAtStart("Select", line_prev) or MatchWordAtStart("Switch", line_prev) then
					editor:NewLine()
					editor:LineUp()
					editor:Home()
					editor:Tab()
					editor:LineDown()
					editor:Tab()
					editor:LineEnd()
					return_value = true
				end
				if line_prev <= 0 then
					break
				end
			end
		end
		if (MatchWordAtStart("EndSelect", line)) or (MatchWordAtStart("EndSwitch", line)) then
			local found = false
			for i = 1, 5 do
				local line_prev = line - i
				if MatchWordAtStart("Case", line_prev) then
					found = true
					break
				elseif (MatchWordAtStart("Select", line_prev)) or (MatchWordAtStart("Switch", line_prev)) then
					break
				end
			end
			if found then
				editor:NewLine()
				editor:LineUp()
				editor:Home()
				editor:BackTab()
				editor:LineDown()
				editor:BackTab()
				editor:LineEnd()
				return_value = true
			end
		end
		local unused1, unused2, unused3, word = MatchWordAtStart("", line)
		if (word) and (EndStatements[word:lower()]) then
			for i = 1, 5 do
				local line_prev = line - i
				if editor.LineEndPosition[line_prev] ~= editor.LineIndentPosition[line_prev] then
					if MatchWordAtStart("If", line_prev) then
						if string.find(editor:GetLine(line_prev), if_pattern) then
							editor:NewLine()
							editor:LineUp()
							editor:Home()
							editor:BackTab()
							editor:LineDown()
							editor:BackTab()
							editor:LineEnd()
							return_value = true
						end
					end
					break
				end
			end
		end
		editor:EndUndoAction()
	end
	return return_value
end)
