local function IsValidFuncChar(c)
	return string.find(c, "[_%w]") ~= nil
end

local function IsValidStyle(style)
	local style_table = {
		SCE_AU3_COMMENTBLOCK,
		SCE_AU3_COMMENT,
		SCE_AU3_STRING,
		SCE_AU3_SPECIAL,
		SCE_AU3_COMOBJ
	}
	if style_table then
		for i, v in ipairs(style_table) do
			if style == v then
				return false
			end
		end
	end
	return true
end

AddEventHandler("OnChar", function(c)
	if not editor.Focus then return end
	if not IsLexer(SCLEX_AU3) then
		return
	end
	local style_at = editor.StyleAt[editor.CurrentPos - 2]
	if not IsValidStyle(style_at) then
		editor:AutoCStops(c)
		return
	end
	editor:AutoCStops("")
	if (c == "\r") then
		return
	end
	if (c == ",") or (c == "(") or (c == ")") then
		if (c == ",") or (c == ")") then
			if editor:CallTipActive() then
				return
			end
		end
		if props["use.auto.calltips.au3"] ~= "1" then return true end
		if (c == ",") or (c == "(") then
			if tonumber(props["calltips.au3.set.above"]) == 1 then
				scite.SendEditor(SCI_CALLTIPSETPOSITION, true)
			end
		end
		if (c == ",") then
			scite.MenuCommand(IDM_SHOWCALLTIP)
		end
		return
	end
	if props["use.auto.autocomplete.au3"] ~= "1" then return true end
--	if editor:CallTipActive() then
--		return
--	end
	editor.AutoCMaxHeight = 20
	if (c == "$") and (IsValidStyle(style)) then
		scite.MenuCommand(IDM_COMPLETEWORD)
		return
	end
	if (c == "@") and (IsValidStyle(style)) then
		scite.MenuCommand(IDM_COMPLETE)
		return
	end
	if (c == "_") and ((editor:WordStartPosition(editor.CurrentPos) + 1) == editor.CurrentPos) then
		return true
	end
	if not IsValidFuncChar(c) then
		return
	end
	if not editor:AutoCActive() then
		scite.MenuCommand(IDM_COMPLETE)
		if not editor:AutoCActive() then
			scite.MenuCommand(IDM_COMPLETEWORD)
		end
	end
end)

AddEventHandler("OnMenuCommand", function(msg, source)
	if ((msg == IDM_COMPLETE) or (msg == IDM_COMPLETEWORD)) and (not editor.Focus) then
		return true
	end
end)
