#pragma compile(Out, ..\TemplateScript.exe)
#pragma compile(UPX, True)
#pragma compile(Compression, 9)
#pragma compile(Stripper, True)
#pragma compile(FileVersion, 1.0.0.0)
#pragma compile(ProductVersion, 1.0.0.0)
#pragma compile(ProductName, Template Script)
#pragma compile(FileDescription, Open template script for AutoIt)
#pragma compile(LegalCopyright,  G.Sandler)
#pragma compile(CompanyName, CreatoR's Lab)
#pragma compile(Comments, Program made by G.Sandler)
#pragma compile(Sign, G.Sandler)

#NoTrayIcon

#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>

Opt('ExpandEnvStrings', 1)

Global $sConfigFile 	= @ScriptDir & (@Compiled ? '\' : '\..\') & 'Config.ini'
Global $sTemplate_File 	= @ScriptDir & (@Compiled ? '\' : '\..\') & 'Template.auc'

Global $sTmpScrptPath 	= IniRead($sconfigfile, 'Main', 'Temp Script Dir', @TempDir)
Global $iDelTmpScript 	= Int(IniRead($sConfigFile, 'Main', 'Delete Template Script', 0))

Global $sScrptPath 		= _FileNewName($sTmpScrptPath & '\Au3Script_' & @MDAY & '-' & @MON & '-' & @YEAR & ',' & @HOUR & ';' & @MIN & ';' & @SEC & '.au3')
Global $sInitScrptPath 	= $sScrptPath

#Region Script Content

$sDef_Template = FileRead($sTemplate_File)

If $sDef_Template = '' Then
	$sDef_Template = '#include <GUIConstantsEx.au3>' & @CRLF & @CRLF
	$sDef_Template &= '#include <WindowsConstants.au3>' & @CRLF & @CRLF
	$sDef_Template &= '$hGUI = GUICreate(''Test Script'')' & @CRLF & @CRLF
	$sDef_Template &= '$iButton = GUICtrlCreateButton(''Button'', 20, 40, 60, 20)' & @CRLF & @CRLF & @CRLF
	$sDef_Template &= 'GUISetState(@SW_SHOW, $hGUI)' & @CRLF & @CRLF
	$sDef_Template &= 'While 1' & @CRLF
	$sDef_Template &= '	Switch GUIGetMsg()' & @CRLF
	$sDef_Template &= '		Case $GUI_EVENT_CLOSE' & @CRLF
	$sDef_Template &= '			Exit' & @CRLF
	$sDef_Template &= '		Case $iButton' & @CRLF
	$sDef_Template &= '			' & @CRLF
	$sDef_Template &= '	EndSwitch' & @CRLF
	$sDef_Template &= 'WEnd' & @CRLF & @CRLF
EndIf

#EndRegion Script Content

If StringRegExp(ClipGet(), '(?i)(#include|#NoTrayIcon|#(End)?Region|Opt\(.*\)|If\h*.*Then|\$\w+\h*=|Func .*?\(.*?\))') Then
	$sDef_Template = ClipGet()
EndIf

$hFile = FileOpen($sScrptPath, 2)
FileWrite($hFile, $sDef_Template)
FileClose($hFile)

ShellExecuteWait($sScrptPath, '', '', 'Edit')

If @error Then
	MsgBox(48, @ScriptName & ' - Error', 'Unable to execute scripts editor.')
	Exit
EndIf

$hGUI = GUICreate('Template Script Module', 400, 150, -1, -1, -1, $WS_EX_TOPMOST)

$iDelTmpScript_CB = GUICtrlCreateCheckbox('Delete template script', 20, 20)

GUICtrlCreateLabel('Script Path:', 20, 50)
$iTmpScriptPath_Input = GUICtrlCreateInput($sScrptPath, 20, 70, 330, 20)
$iSelTmpScriptPath_Bttn = GUICtrlCreateButton('...', 360, 70, 20, 20)

$iOk_Bttn = GUICtrlCreateButton('OK', 20, 120, 70, 20)

If $iDelTmpScript Then
	GUICtrlSetState($iDelTmpScript_CB, $GUI_CHECKED)
	GUICtrlSetState($iTmpScriptPath_Input, $GUI_DISABLE)
	GUICtrlSetState($iSelTmpScriptPath_Bttn, $GUI_DISABLE)
EndIf

GUISetState(@SW_SHOW, $hGUI)

While 1
	$nMsg = GUIGetMsg()
	
	Switch $nMsg
		Case $GUI_EVENT_CLOSE
			Exit
		Case $iDelTmpScript_CB
			$iDelTmpScript = Number(GUICtrlRead($iDelTmpScript_CB) = $GUI_CHECKED)
			
			If $iDelTmpScript Then
				GUICtrlSetState($iTmpScriptPath_Input, $GUI_DISABLE)
				GUICtrlSetState($iSelTmpScriptPath_Bttn, $GUI_DISABLE)
			Else
				GUICtrlSetState($iTmpScriptPath_Input, $GUI_ENABLE)
				GUICtrlSetState($iSelTmpScriptPath_Bttn, $GUI_ENABLE)
			EndIf
		Case $iSelTmpScriptPath_Bttn
			$sScrptPath = GUICtrlRead($iTmpScriptPath_Input)
			
			$sPath = StringRegExpReplace($sScrptPath, '\\[^\\]*$', '')
			$sName = StringRegExpReplace($sScrptPath, '^.*\\|\.[^\.]*$', '')
			
			$sPath = FileSaveDialog('Save as', $sPath, 'Au3 Script (*.au3)', 18, $sName, $hGUI)
			If @error Then ContinueLoop
			
			GUICtrlSetData($iTmpScriptPath_Input, StringRegExpReplace($sPath, '\.[^\.]*$', '') & '.au3')
		Case $iOk_Bttn
			$sScrptPath = GUICtrlRead($iTmpScriptPath_Input)
			$sScrptName = StringRegExpReplace($sScrptPath, '^.*\\', '')
			
			If GUICtrlRead($iDelTmpScript_CB) = $GUI_CHECKED Then
				FileCopy($sScrptPath, @TempDir & '\' & $sScrptName, 1)
				FileDelete($sScrptPath)
			Else
				If $sScrptPath <> $sInitScrptPath Then
					FileMove($sInitScrptPath, $sScrptPath, 1)
				EndIf
			EndIf
			
			IniWrite($sConfigFile, 'Main', 'Temp Script Dir', StringRegExpReplace($sScrptPath, '\\[^\\]*$', ''))
			IniWrite($sConfigFile, 'Main', 'Delete Template Script', $iDelTmpScript)
			
			Exit
	EndSwitch
WEnd

Func _FileNewName($sFilePath, $sDelim_1 = '(', $sDelim_2 = ')', $sIgnoreStr = '')
	If Not FileExists($sFilePath) Then Return $sFilePath
	Local $iNewNum = 1
	
	If Not StringInStr(FileGetAttrib($sFilePath), 'D') And (Not StringInStr($sFilePath, $sDelim_1) Or Not StringInStr($sFilePath, $sDelim_2)) Then
		Local $sExtSplitter = '.'
		If $sIgnoreStr <> '' And StringInStr($sFilePath, $sIgnoreStr) Then $sExtSplitter = $sIgnoreStr
		
		Local $sFilePathNoExt = StringLeft($sFilePath, StringInStr($sFilePath, $sExtSplitter, 0, -1)-1)
		Local $sFileExt = StringTrimLeft($sFilePath, StringInStr($sFilePath, $sExtSplitter, 0, -1)-1)
		
		While FileExists($sFilePath)
			$sFilePath = $sFilePathNoExt & $sDelim_1 & $iNewNum & $sDelim_2 & $sFileExt
			$iNewNum += 1
		WEnd
		
		Return $sFilePath
	EndIf
	
	Local $sMidleStr = _GetMidleString($sFilePath, $sDelim_1, $sDelim_2, -1)
	
	If $sMidleStr <> $sFilePath Then
		$iNewNum = $sMidleStr + 1
		
		While FileExists($sFilePath)
			$sFilePath = _StringRightReplace($sFilePath, $sMidleStr, $iNewNum)
			$iNewNum += 1
		WEnd
	ElseIf StringInStr(FileGetAttrib($sFilePath), 'D') Then
		While FileExists($sFilePath)
			$sFilePath = $sFilePath & $sDelim_1 & $iNewNum & $sDelim_2
			$iNewNum += 1
		WEnd
	EndIf
	
	Return $sFilePath
EndFunc

Func _StringRightReplace($sString, $sFind, $sReplace)
	Local $iFindPos = StringInStr($sString, $sFind, 0, -1)-1
	Local $sLeftStr = StringLeft($sString, $iFindPos)
	Local $sRightStr = StringTrimLeft($sString, $iFindPos + StringLen($sFind))
	
	Return $sLeftStr & $sReplace & $sRightStr
EndFunc

Func _GetMidleString($sString, $sDelimStart, $sDelimEnd, $iOccurrence = 1)
	If Not StringInStr($sString, $sDelimStart) Or Not StringInStr($sString, $sDelimEnd) Then Return SetError(1, 0, $sString)
	
	If $sDelimStart = $sDelimEnd And $iOccurrence = -1 Then $iOccurrence = -2
	Local $iFirstPos = StringInStr($sString, $sDelimStart, 0, $iOccurrence)
	
	Local $sMidleStr = StringTrimLeft($sString, $iFirstPos)
	If $sDelimStart = $sDelimEnd And $iOccurrence = -2 Then $iOccurrence = -1
	
	Local $iSecondPos = StringInStr($sMidleStr, $sDelimEnd, 0, $iOccurrence) + $iFirstPos
	Return StringTrimRight(StringTrimLeft($sString, $iFirstPos), (StringLen($sString) - $iSecondPos + 1))
EndFunc
