; AutoIt ScriptOMatic
; -------------------
;
; AutoIt's counterpart of Microsoft's Scriptomatic
;
; Author:		SvenP
; Date/version:	2005-04-17
; See also:		http://www.microsoft.com/technet/scriptcenter/tools/scripto2.mspx
; Requires:		AutoIt beta version 3.1.1.8 or higher (COM support!!)
;
; GUI generated by AutoBuilder 0.5 Prototype

#include <GuiConstantsEx.au3>
#include <WindowsConstants.au3>

; ************************
; * Global State Variables
; ************************
Global $g_sCurrentNamespace = "\root\CIMV2"
Global $g_iCurrentNamespaceIndex = 0
Global $g_sWMISource = "localhost"
Global $g_sOutputFormat = "Dialog"

; ************************
; * Main GUI
; ************************

GUICreate("AutoIt Scriptomatic Tool", 684, 561, (@DesktopWidth - 684) / 2, (@DesktopHeight - 561) / 2, $WS_OVERLAPPEDWINDOW + $WS_VISIBLE + $WS_CLIPSIBLINGS)

GUICtrlCreateGroup("", 10, 10, 660, 530)
Global $g_idWMI_NamespaceLabel = GUICtrlCreateLabel("WMI Namespace", 20, 30, 150, 20)
Global $g_idWMI_Namespace = GUICtrlCreateCombo("WMI_Namespaces", 20, 50, 280, 21)
GUICtrlCreateLabel("WMI Class", 320, 30, 140, 20)
Global $g_idWMI_Classes = GUICtrlCreateCombo("WMI_Classes", 320, 50, 340, 21)
Global $g_idAST_Web = GUICtrlCreateButton("Lookup on WWW", 560, 27, 100, 20)
GUICtrlCreateGroup("", 10, 80, 660, 50)
Global $g_idAST_Run = GUICtrlCreateButton("Run", 20, 100, 50, 20)
Global $idAST_CIMv2 = GUICtrlCreateButton("CIMv2", 80, 100, 50, 20)
Global $idAST_WMISource = GUICtrlCreateButton("WMISource", 140, 100, 70, 20)
Global $idAST_Open = GUICtrlCreateButton("Open", 220, 100, 60, 20)
Global $g_idAST_Save = GUICtrlCreateButton("Save", 290, 100, 60, 20)
Local $idAST_Quit = GUICtrlCreateButton("Quit", 360, 100, 60, 20)
GUICtrlCreateGroup("Output", 430, 80, 240, 50)
Global $g_idAST_RadioDialog = GUICtrlCreateRadio("Dialog", 440, 100, 50, 20)
Global $g_idAST_RadioText = GUICtrlCreateRadio("Text", 510, 100, 50, 20)
Global $g_idAST_RadioHTML = GUICtrlCreateRadio("HTML", 570, 100, 50, 20)
Global $g_idAST_ScriptCode = GUICtrlCreateEdit("One moment...", 20, 140, 640, 390)

GUISetState()

; Initial GUI Settings
GUICtrlSetState($g_idAST_Web, $GUI_DISABLE)
GUICtrlSetState($g_idAST_Run, $GUI_DISABLE)
GUICtrlSetState($g_idAST_Save, $GUI_DISABLE)
GUICtrlSetState($g_idAST_RadioDialog, $GUI_CHECKED)

; Fill the WMI_Namespaces Combobox
LoadWMINamespaces()

; Fill the WMI_Classes Combobox
HandleNamespaceChange()

Local $iMsg
While 1
	$iMsg = GUIGetMsg()
	Select
		Case $iMsg = $GUI_EVENT_CLOSE
			ExitLoop
		Case $iMsg = $idAST_Quit
			ExitLoop
		Case $iMsg = $g_idWMI_Namespace
			HandleNamespaceChange()
		Case $iMsg = $g_idWMI_Classes
			ComposeCode()
		Case $iMsg = $g_idAST_Web
			LookupWeb()
		Case $iMsg = $g_idAST_Run
			RunScript()
		Case $iMsg = $g_idAST_Save
			SaveScript()
		Case $iMsg = $idAST_Open
			OpenScript()
		Case $iMsg = $idAST_CIMv2
			SetNamespaceToCIMV2()
		Case $iMsg = $idAST_WMISource
			SetWMIRepository()
		Case $iMsg = $g_idAST_RadioDialog Or _
				$iMsg = $g_idAST_RadioText Or _
				$iMsg = $g_idAST_RadioHTML
			HandleOutputChange()
	EndSelect
WEnd

GUIDelete()

Exit

; ********************************************************************
; * LoadWMINamespaces
; ********************************************************************
Func LoadWMINamespaces()
	Local $sCsvListOfNamespaces = ""
	Local $sNamespacesCombo = ""

	Local $sWaitNamespaces = "Please wait, Loading WMI Namespaces"
	GUICtrlSetData($g_idWMI_Namespace, $sWaitNamespaces, $sWaitNamespaces)

	EnumNamespaces("root", $sCsvListOfNamespaces)

	Local $aNamespaces = StringSplit($sCsvListOfNamespaces, ",")

	For $sNamespace In $aNamespaces
		$sNamespacesCombo = $sNamespacesCombo & "|" & $sNamespace
	Next

	GUICtrlSetData($g_idWMI_Namespace, $sNamespacesCombo, "ROOT\CIMV2")
EndFunc   ;==>LoadWMINamespaces

; ********************************************************************
; * EnumNamespaces
; ********************************************************************
Func EnumNamespaces($sNamespace, ByRef $sTmpCsvListOfNamespaces)
	If $sTmpCsvListOfNamespaces = "" Then
		$sTmpCsvListOfNamespaces = $sNamespace
	Else
		$sTmpCsvListOfNamespaces = $sTmpCsvListOfNamespaces & "," & $sNamespace
	EndIf

	; Local $sComputer = $g_sWMISource
	Local $oWMIService = ObjGet("winmgmts:\\" & $g_sWMISource & "\" & $sNamespace)

	If Not @error Then

		Local $oColNameSpaces = $oWMIService.InstancesOf("__NAMESPACE")

		For $oNameSpace In $oColNameSpaces
			EnumNamespaces($sNamespace & "\" & $oNameSpace.Name, $sTmpCsvListOfNamespaces)
		Next
	Else
		$sTmpCsvListOfNamespaces = ""
	EndIf
EndFunc   ;==>EnumNamespaces

; ********************************************************************
; * HandleNamespaceChange
; ********************************************************************
Func HandleNamespaceChange()
	;'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
	; Clear the WMI classes pulldown location.
	;'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
	Local $sSelectedNamespace = GUICtrlRead($g_idWMI_Namespace)

	; Disable the namespace combobox until class load has been completed
	GUICtrlSetState($g_idWMI_Namespace, $GUI_DISABLE)

	Local $sWMIWaitMsg = "Please wait, trying to load WMI Classes in namespace " & $sSelectedNamespace
	GUICtrlSetData($g_idWMI_Classes, $sWMIWaitMsg, $sWMIWaitMsg)
	GUICtrlSetData($g_idAST_ScriptCode, "One moment...", "")

	LoadWMIClasses()
	$g_sCurrentNamespace = "\" & $sSelectedNamespace

	;'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
	; Clear the code textarea and disable run and save.
	;'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
	GUICtrlSetData($g_idAST_ScriptCode, "", "")

	GUICtrlSetState($g_idWMI_Namespace, $GUI_ENABLE)
	GUICtrlSetState($g_idAST_Run, $GUI_DISABLE)
	GUICtrlSetState($g_idAST_Save, $GUI_DISABLE)
EndFunc   ;==>HandleNamespaceChange

; ********************************************************************
; * LoadWMIClasses
; *
; * Fetch all the classes in the currently selected namespace, and
; * populate the keys of a dictionary object with the names of all
; * dynamic (non-association) classes. Then we transfer the keys to
; * an array, sort the array, and finally use the sorted array to
; * populate the WMI classes pulldown.
; ********************************************************************
Func LoadWMIClasses()
	Const $SORT_KEYS = 1
	; Const $SORT_ITEMS = 2

	Local $oClassDictionary = ObjCreate("Scripting.Dictionary")
	Local $oQualifierDictionary = ObjCreate("Scripting.Dictionary")

	Local $sComputer = "."
	Local $oWMIService = ObjGet("winmgmts:\\" & $sComputer & $g_sCurrentNamespace)

	If Not @error Then

		For $oClass In $oWMIService.SubclassesOf()

			For $objQualifier In $oClass.Qualifiers_() ; Dummy (), because it ends with an underscore !
				$oQualifierDictionary.Add(StringLower($objQualifier.Name), "")
			Next

			If $oQualifierDictionary.Exists("dynamic") Then

				;$TempVar = $oClass.Path_.Class
				;$oClassDictionary.Add($TempVar, "")	; Can't use object in arguments ?!!

				$oClassDictionary.Add($oClass.Path_.Class, "")

			EndIf

			$oQualifierDictionary.RemoveAll

		Next

		$oQualifierDictionary = ""

		;'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
		; If the current namespace contains dynamic classes...
		;'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
		If $oClassDictionary.Count Then

			;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
			; Sort the dictionary.
			;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
			SortDictionary($oClassDictionary, $SORT_KEYS)

			;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
			; Populate the WMI classes pulldown with the sorted dictionary.
			;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

			Local $sClassesCombo = "|Select a WMI class"

			For $strWMIClass In $oClassDictionary ;  method .Keys is not an object ??
				$sClassesCombo = $sClassesCombo & "|" & $strWMIClass
			Next

			GUICtrlSetData($g_idWMI_Classes, $sClassesCombo, "Select a WMI class")

		EndIf
	EndIf

	If @error Or $oClassDictionary.Count = 0 Then
		;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
		; And If the current namespace doesn't contain dynamic classes.
		;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
		GUICtrlSetData($g_idWMI_Classes, "|No dynamic classes found in current namespace.|Select a different namespace", "")

	EndIf

	$oClassDictionary = ""
EndFunc   ;==>LoadWMIClasses

; ********************************************************************
; * SortDictionary
; *
; * Shell sort based on:
; * http://support.microsoft.com/support/kb/articles/q246/0/67.asp
; ********************************************************************
Func SortDictionary(ByRef $oDict, $iSort)
	Const $iDictKey = 1
	Const $iDictItem = 2

	Local $asDict[1][3]

	Local $iCount = $oDict.Count

	If $iCount > 1 Then

		ReDim $asDict[$iCount][3]

		Local $i = 0
		For $oKey In $oDict

			$asDict[$i][$iDictKey] = String($oKey)
			$asDict[$i][$iDictItem] = String($oDict($oKey))

			$i = $i + 1
		Next

		;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
		; Perform a shell sort of the 2D string array
		;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
		For $i = 0 To ($iCount - 2)
			For $j = $i To ($iCount - 1)
				If $asDict[$i][$iSort] > $asDict[$j][$iSort] Then
					Local $sKey = $asDict[$i][$iDictKey]
					Local $sItem = $asDict[$i][$iDictItem]
					$asDict[$i][$iDictKey] = $asDict[$j][$iDictKey]
					$asDict[$i][$iDictItem] = $asDict[$j][$iDictItem]
					$asDict[$j][$iDictKey] = $sKey
					$asDict[$j][$iDictItem] = $sItem
				EndIf
			Next
		Next

		;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
		; Erase the contents of the dictionary object
		;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
		$oDict.RemoveAll

		;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
		; Repopulate the dictionary with the sorted information
		;''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
		For $i = 0 To ($iCount - 1)
			$oDict.Add($asDict[$i][$iDictKey], $asDict[$i][$iDictItem])
		Next

	EndIf
EndFunc   ;==>SortDictionary

; ********************************************************************
; * ComposeCode
; ********************************************************************
Func ComposeCode()
	Local $oClass = ""

	Local $sSelectedClass = GUICtrlRead($g_idWMI_Classes)
	; Check If a valid class has been selected
	If $sSelectedClass <> "Select a WMI class" Then

		Local $bHasDates = False ; Flag: output has date fields
		Local $sHeaderStart = Chr(34)
		Local $sRowStart = Chr(34)
		Local $sColumnSeparator = ": "
		Local $sRowEnd = " & @CRLF"

		Local $sComputerCommand = "$sComputer = " & Chr(34) & $g_sWMISource & Chr(34)

		Local $oWMIService = ObjGet("winmgmts:{impersonationLevel=impersonate}!\\" & @ComputerName & $g_sCurrentNamespace)
		$oClass = $oWMIService.Get($sSelectedClass)

		If IsObj($oClass) Then

			Local $sScriptCode = ""
			$sScriptCode = $sScriptCode & "; Generated by AutoIt Scriptomatic" & @CRLF & @CRLF
			$sScriptCode = $sScriptCode & "$wbemFlagReturnImmediately = 0x10" & @CRLF
			$sScriptCode = $sScriptCode & "$wbemFlagForwardOnly = 0x20" & @CRLF
			$sScriptCode = $sScriptCode & '$colItems = ""' & @CRLF
			$sScriptCode = $sScriptCode & $sComputerCommand & @CRLF & @CRLF
			$sScriptCode = $sScriptCode & '$Output=""' & @CRLF

			If $g_sOutputFormat = "HTML" Then
				$sScriptCode = $sScriptCode & "$Output = $Output & '<html><head><title>Scriptomatic HTML Output</title></head><body> " & _
						"<style>table {font-size: 10pt; font-family: arial;} th {background-color: buttonface; font-decoration: bold;} " & _
						"</style><table BORDER=" & Chr(34) & "1" & Chr(34) & "><tr><th>Property</th><th>Value</th></tr>'" & @CRLF
				$sRowStart = Chr(34) & "<tr><td>"
				$sHeaderStart = "'<tr bgcolor=" & Chr(34) & "yellow" & Chr(34) & "><td>' & " & Chr(34)
				$sColumnSeparator = "</td><td>&nbsp;"
				$sRowEnd = " & " & Chr(34) & "</td></tr>" & Chr(34) & " & @CRLF"
			EndIf

			$sScriptCode = $sScriptCode & "$Output = $Output & " & $sHeaderStart & "Computer" & $sColumnSeparator & Chr(34) & " & $sComputer " & $sRowEnd & @CRLF

			If $g_sOutputFormat = "Dialog" Then
				$sScriptCode = $sScriptCode & "$Output = $Output & " & Chr(34) & "==========================================" & Chr(34) & $sRowEnd & @CRLF
			EndIf

			$sScriptCode = $sScriptCode & "$oWMIService = ObjGet(" & Chr(34) & "winmgmts:\\" & Chr(34) & " & $sComputer & " & Chr(34) & $g_sCurrentNamespace & Chr(34) & ")" & @CRLF
			$sScriptCode = $sScriptCode & "$colItems = $oWMIService.ExecQuery(" & Chr(34) & "SELECT * FROM " & $sSelectedClass & Chr(34) & ", " & Chr(34) & "WQL" & Chr(34) & ", _" & @CRLF
			$sScriptCode = $sScriptCode & "                                          $wbemFlagReturnImmediately + $wbemFlagForwardOnly)" & @CRLF & @CRLF
			$sScriptCode = $sScriptCode & "If IsObj($colItems) Then" & @CRLF
			$sScriptCode = $sScriptCode & "   For $objItem In $colItems" & @CRLF

			For $oProperty In $oClass.Properties_() ; Must use (), because method ends with an underscore

				If $oProperty.IsArray = True Then
					$sScriptCode = $sScriptCode & "      $str" & $oProperty.Name & " = $objItem." & $oProperty.Name & "(0)" & @CRLF
					$sScriptCode = $sScriptCode & "      $Output = $Output & " & $sRowStart & $oProperty.Name & $sColumnSeparator & Chr(34) & " & $str" & $oProperty.Name & $sRowEnd & @CRLF
				ElseIf $oProperty.CIMTYPE = 101 Then
					$bHasDates = True
					$sScriptCode = $sScriptCode & "      $Output = $Output & " & $sRowStart & $oProperty.Name & $sColumnSeparator & Chr(34) & " & WMIDateStringToDate($objItem." & $oProperty.Name & ")" & $sRowEnd & @CRLF
				Else
					$sScriptCode = $sScriptCode & "      $Output = $Output & " & $sRowStart & $oProperty.Name & $sColumnSeparator & Chr(34) & " & $objItem." & $oProperty.Name & $sRowEnd & @CRLF
				EndIf
			Next

			If $g_sOutputFormat = "Dialog" Then
				$sScriptCode = $sScriptCode & '      If MsgBox(1,"WMI Output",$Output) = 2 Then ExitLoop' & @CRLF
				$sScriptCode = $sScriptCode & '      $Output=""' & @CRLF
			EndIf
			$sScriptCode = $sScriptCode & "   Next" & @CRLF

			If $g_sOutputFormat = "Text" Then
				$sScriptCode = $sScriptCode & '   ConsoleWrite($Output)' & @CRLF
				$sScriptCode = $sScriptCode & '   FileWrite(@TempDir & "\' & $sSelectedClass & '.TXT", $Output )' & @CRLF
				$sScriptCode = $sScriptCode & '   Run(@ComSpec & " /c start " & @TempDir & "\' & $sSelectedClass & '.TXT" )' & @CRLF
			ElseIf $g_sOutputFormat = "HTML" Then
				$sScriptCode = $sScriptCode & '   FileWrite(@TempDir & "\' & $sSelectedClass & '.HTML", $Output )' & @CRLF
				$sScriptCode = $sScriptCode & '   Run(@ComSpec & " /c start " & @TempDir & "\' & $sSelectedClass & '.HTML" )' & @CRLF
			EndIf

			$sScriptCode = $sScriptCode & "Else" & @CRLF
			$sScriptCode = $sScriptCode & '   MsgBox(0,"WMI Output","No WMI Objects Found for class: " & ' & Chr(34) & $sSelectedClass & Chr(34) & ' )' & @CRLF

			$sScriptCode = $sScriptCode & "EndIf" & @CRLF
			$sScriptCode = $sScriptCode & @CRLF & @CRLF

			If $bHasDates Then
				$sScriptCode = $sScriptCode & "Func WMIDateStringToDate($dtmDate)" & @CRLF
				$sScriptCode = $sScriptCode & @CRLF
				$sScriptCode = $sScriptCode & Chr(9) & "Return (StringMid($dtmDate, 5, 2) & ""/"" & _" & @CRLF
				$sScriptCode = $sScriptCode & Chr(9) & "StringMid($dtmDate, 7, 2) & ""/"" & StringLeft($dtmDate, 4) _" & @CRLF
				$sScriptCode = $sScriptCode & Chr(9) & "& "" "" & StringMid($dtmDate, 9, 2) & "":"" & StringMid($dtmDate, 11, 2) & "":"" & StringMid($dtmDate,13, 2))" & @CRLF
				$sScriptCode = $sScriptCode & "EndFunc"
			EndIf
		Else
			$sScriptCode = "Error: No Class properties found for " & $g_sCurrentNamespace & "\" & $sSelectedClass
		EndIf

		GUICtrlSetData($g_idAST_ScriptCode, $sScriptCode)

		;'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
		; Once the code is successfully composed and put into the
		; textarea, ensure that the run and save buttons are enabled.
		;'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

		GUICtrlSetState($g_idAST_Run, $GUI_ENABLE)
		GUICtrlSetState($g_idAST_Save, $GUI_ENABLE)

		; Enable Web lookup button
		GUICtrlSetState($g_idAST_Web, $GUI_ENABLE)
	Else
		; Disable Web, Run and Save buttons, because no valid code has been generated
		GUICtrlSetState($g_idAST_Web, $GUI_DISABLE)
		GUICtrlSetState($g_idAST_Run, $GUI_DISABLE)
		GUICtrlSetState($g_idAST_Save, $GUI_DISABLE)
	EndIf
EndFunc   ;==>ComposeCode

; ********************************************************************
; * RunScript
; ********************************************************************
Func RunScript()
	;'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
	; Create a temporary script file named "temp_script.au3".
	;'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

	Local $sTmpName = @TempDir & "\temp_script.au3"

	If FileExists($sTmpName) Then FileDelete($sTmpName)

	FileWrite($sTmpName, GUICtrlRead($g_idAST_ScriptCode))

	;'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
	; Start constructing the command line that will run the script...
	;'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
	Local $sCmdLine = @AutoItExe & " " & $sTmpName

	RunWait($sCmdLine)

	FileDelete($sTmpName)
EndFunc   ;==>RunScript

; ********************************************************************
; * SaveScript
; ********************************************************************
Func SaveScript()
	Local $sTmpName = FileSaveDialog("Save Script", @DesktopDir, "AutoIt3 Scripts (*.au3)", 16, GUICtrlRead($g_idWMI_Classes))

	If Not @error And $sTmpName <> "" Then
		If StringRight($sTmpName, 4) <> ".AU3" Then $sTmpName = $sTmpName & ".AU3"
		If FileExists($sTmpName) Then FileDelete($sTmpName)
		FileWrite($sTmpName, GUICtrlRead($g_idAST_ScriptCode))
	EndIf
EndFunc   ;==>SaveScript

; ********************************************************************
; * OpenScript
; ********************************************************************

Func OpenScript()
	Local $sTmpName = FileOpenDialog("Open Script", @DesktopDir, "AutoIt3 Scripts (*.au3)")

	If Not @error And $sTmpName <> "" Then
		If FileExists($sTmpName) Then
			GUICtrlSetData($g_idAST_ScriptCode, FileRead($sTmpName, FileGetSize($sTmpName)))
		EndIf
	EndIf
EndFunc   ;==>OpenScript

; ****************************************************************************
; * SetNamespaceToCIMV2
; ****************************************************************************
Func SetNamespaceToCIMV2()
	If StringUpper(GUICtrlRead($g_idWMI_Namespace)) <> "ROOT\CIMV2" Then
		GUICtrlSetData($g_idWMI_Namespace, "ROOT\CIMV2", "ROOT\CIMV2")
		HandleNamespaceChange()
	EndIf
EndFunc   ;==>SetNamespaceToCIMV2

; ****************************************************************************
; * SetWMIRepository
; ****************************************************************************
Func SetWMIRepository()
	Local $sWMISourceName = InputBox("Set WMI Repository Source", _
			"Please enter the computer whose WMI repository you want to read from: ", _
			$g_sWMISource)
	If $sWMISourceName <> "" Then

		$g_sWMISource = StringStripWS($sWMISourceName, 1 + 2)
		;target_computers.Value = $g_sWMISource
		LoadWMINamespaces()
	EndIf
EndFunc   ;==>SetWMIRepository

; ****************************************************************************
; * HandleOutputChange
; ****************************************************************************
Func HandleOutputChange()
	Local $sChosenFormat = $g_sOutputFormat
	If GUICtrlRead($g_idAST_RadioDialog) = $GUI_CHECKED Then $sChosenFormat = "Dialog"
	If GUICtrlRead($g_idAST_RadioText) = $GUI_CHECKED Then $sChosenFormat = "Text"
	If GUICtrlRead($g_idAST_RadioHTML) = $GUI_CHECKED Then $sChosenFormat = "HTML"
	If $sChosenFormat <> $g_sOutputFormat Then
		$g_sOutputFormat = $sChosenFormat
		ComposeCode()
	EndIf
EndFunc   ;==>HandleOutputChange

; ****************************************************************************
; * LookupWeb
; ****************************************************************************
Func LookupWeb()
	Local $sSelectedClass = GUICtrlRead($g_idWMI_Classes)

	; Check If a valid class has been selected
	If $sSelectedClass <> "Select a WMI class" Then
		Run(@ComSpec & " /c start http://msdn.microsoft.com/library/en-us/wmisdk/wmi/" & $sSelectedClass & ".asp?frame=true", "", @SW_HIDE)
	EndIf
EndFunc   ;==>LookupWeb
