#pragma compile(Out, ..\..\AutoIt_Loader.exe)
#pragma compile(ExecLevel, AsInvoker)
#pragma compile(UPX, True)
#pragma compile(Compression, 9)
#pragma compile(AutoItExecuteAllowed, True)
#pragma compile(FileVersion, 1.0.0.0)
#pragma compile(ProductVersion, 1.0.0.0)
#pragma compile(ProductName, AutoIt Loader)
#pragma compile(FileDescription, Portable AutoIt Loader)
#pragma compile(LegalCopyright, Copyright  2019 G.Sandler)
#pragma compile(CompanyName, CreatoR's Lab)
#pragma compile(Comments, Program made by G.Sandler)

#NoTrayIcon
#include <TrayConstants.au3>
#Include <GUIMenu.au3>
#Include <WinAPIDlg.au3>
#Include <WinAPIShellEx.au3>
#Include <WinAPIProc.au3>
#Include <File.au3>
#include 'Includes\AboutBox.au3'
#include 'Includes\AppInteraction.au3'
#include 'Includes\AppCheckUpdates.au3'

Global Const $sScript_Dir = _PathFull(@ScriptDir & (@Compiled ? '' : '\..\..'), @ScriptDir)
Global Const $sExe_File = '"' & @AutoItExe & '"' & (@Compiled ? '' : ' "' & @ScriptFullPath & '"')
Global Const $iStartup_Delay = 10

Global Const $sApp_Name = _GetResData('ProductName')
Global Const $sApp_Ver = StringLeft(_GetResData('FileVersion'), 3)
Global Const $sConfig_File = $sScript_Dir & '\Config.ini'
Global Const $sCredits_File = $sScript_Dir & '\Credits.txt'
Global Const $sIcons_File = $sScript_Dir & '\Resources\Icons.icl'
Global Const $sAbout_Img_File = $sScript_Dir & '\Resources\About.jpg'

Global $iUpdate_Check = Int(IniRead($sConfig_File, 'Update', 'Check Update', 1))
Global $iUpdate_Interval = Int(IniRead($sConfig_File, 'Update', 'Update Interval', 24)) ;In hours
Global $iUpdate_Last_Check = Int(IniRead($sConfig_File, 'Update', 'Last Update Check', 0))

$APPCU_7ZIP	= $sScript_Dir & '\Resources\7z.exe'
$APPCU_DAT_URL = 'http://creator-lab.ucoz.ru/Update_Files/AutoItLoaderUpdate.dat'
$APPCU_APP_NAME = $sApp_Name
$APPCU_APP_VER = $sApp_Ver

If Not StringInStr($CmdLineRaw, '/Restore') Then
	_RunOnce()
	_Check_Update()
EndIf

FileChangeDir($sScript_Dir)
OnAutoItExitRegister('_OnExit')

If Not StringInStr($CmdLineRaw, '/Restore') And RegRead('HKCU\Software\Microsoft\Windows\CurrentVersion\RunOnce', $sApp_Name) <> '' Then
	RunWait($sExe_File & ' /Restore', $sScript_Dir)
EndIf

Global $sAutoItVers_Dir = _PathFull(IniRead($sConfig_File, 'Main', 'AutoIt Vers Dir', 'AutoIt'), $sScript_Dir)
Global $sSciTE_Dir = _PathFull(IniRead($sConfig_File, 'Main', 'SciTE Dir', 'SciTE'), $sScript_Dir)
Global $iLoad_AutoItTools = Int(IniRead($sConfig_File, 'Main', 'Load AutoIt Tools', 1))
Global $sAutoItTools = _PathFull(IniRead($sConfig_File, 'Main', 'AutoIt Tools', 'AutoIt_Tools\AutoIt_Tools.exe'), $sScript_Dir)
Global $sAutVerManager = _PathFull(IniRead($sConfig_File, 'Main', 'AutoIt Ver Manager', $sScript_Dir & '\AutVerManager\AutVerManager.exe'), $sScript_Dir)

Global $sAutoIt_Def_Ver = IniRead($sConfig_File, 'Main', 'Default AutoIt Ver', '3.3.14.5')
Global $sAutoIt_Dir = $sAutoItVers_Dir & '\' & $sAutoIt_Def_Ver
Global $sAutoIt_Ver = FileGetVersion($sAutoIt_Dir & '\AutoIt3.exe')

Global Enum $iRegData_Key, $iRegData_File, _
	$iRegData_Total

Global $aRegData[][$iRegData_Total] = _
	[ _
		['HKCU\Software\AutoIt v3', $sScript_Dir & '\Reg#.tmp'], _
		['HKCU\Software\Classes\AutoIt3Script', $sScript_Dir & '\Reg#.tmp'], _
		['HKCU\Software\Classes\AutoIt3XScript', $sScript_Dir & '\Reg#.tmp'], _
		['HKCU\Software\Classes\.au3', $sScript_Dir & '\Reg#.tmp'], _
		['HKCU\Software\Classes\.a3x', $sScript_Dir & '\Reg#.tmp'] _
	]

If StringInStr($CmdLineRaw, '/Restore') Then
	Exit
EndIf

If StringInStr($CmdLineRaw, '/Startup:') Then
	Sleep((Int(StringRegExp($CmdLineRaw, '(?i).*/Startup:(\d+|.*)', 3)[0]) * 1000))
EndIf

_Replace_AutoItDir(False)
_Remember_RegistryData()
_Add_RegistryData()

RegWrite('HKCU\Software\Microsoft\Windows\CurrentVersion\RunOnce', $sApp_Name, 'REG_SZ', $sExe_File & ' /Restore')

If $iLoad_AutoItTools Then
	$iAutToolsPath_PID = _ProcessPathExists($sAutoItTools)
	
	If $iAutToolsPath_PID Then
		$iLoad_AutoItTools = $iAutToolsPath_PID
		_AppInteraction_Send('AutoIt Tools', 'AutoIt_Dir_Changed') ;Reloads menus in AutoIt Tools to read new autoit dir (after replacement)
	Else
		$iLoad_AutoItTools = Run($sAutoItTools, StringRegExpReplace($sAutoItTools, '\\[^\\]+$', ''))
	EndIf
EndIf

Opt('TrayAutoPause', 0)
Opt('TrayMenuMode', 3)

TraySetState(1)
TraySetClick(16 + 2)
TraySetToolTip($sApp_Name & ' (AutoIt Version' & (StringInStr($sAutoIt_Def_Ver, 'Beta\') ? ' (Beta)' : '') & ': ' & $sAutoIt_Ver & ')')

$iChangeAutoItVer_TrayItem = TrayCreateItem('Change AutoIt Version...')
$iAutVerManager_TrayItem = TrayCreateItem('AutoIt Version Manager')
$iPersonalize_TrayItem = TrayCreateItem('Personalize AutoIt data...')
$iStartWithWindows_TrayItem = TrayCreateItem('Start With Windows')
TrayCreateItem('')
$iAbout_TrayItem = TrayCreateItem('About')
$iUpdateCheck_TrayItem = TrayCreateItem('Check For Update...')
TrayCreateItem('')
$iExit_TrayItem = TrayCreateItem('Exit')

TrayItemSetState($iChangeAutoItVer_TrayItem, $TRAY_DEFAULT)

_TrayItemSetIcon($iChangeAutoItVer_TrayItem, -1)
_TrayItemSetIcon($iAutVerManager_TrayItem, -2)
_TrayItemSetIcon($iPersonalize_TrayItem, -8)
_TrayItemSetIcon($iStartWithWindows_TrayItem, ((RegRead('HKCU\Software\Microsoft\Windows\CurrentVersion\Run', $sApp_Name) = $sExe_File & ' /Startup:' & $iStartup_Delay) ? -4 : -3))
_TrayItemSetIcon($iAbout_TrayItem, -5)
_TrayItemSetIcon($iUpdateCheck_TrayItem, -6)
_TrayItemSetIcon($iExit_TrayItem, -7)

;Check updates every hour
AdlibRegister('_Check_Update', (1 * 1000 * 60 * 60))

While 1
	Switch TrayGetMsg()
		Case $iChangeAutoItVer_TrayItem
			TraySetState(2)
			
			While 1
				$sSel = _WinAPI_BrowseForFolderDlg($sAutoItVers_Dir, 'Select AutoIt dir:', $BIF_RETURNONLYFSDIRS)
				
				If $sSel <> '' Then
					If Not FileExists($sSel & '\AutoIt3.exe') Then
						MsgBox(48, $sApp_Name & ' - Attention', 'Please select AutoIt3 dir')
						ContinueLoop
					Else
						FileChangeDir($sScript_Dir)
						
						If $sAutoIt_Dir = $sSel Then
							ExitLoop
						EndIf
						
						$sAutoIt_Dir = $sSel
						$sAutoIt_Ver = FileGetVersion($sAutoIt_Dir & '\AutoIt3.exe')
						$sAutoIt_Def_Ver = StringRegExpReplace($sAutoIt_Dir, '(?i).*?\\(Beta\\)?([^\\]+)$', '\1\2')
						
						IniWrite($sConfig_File, 'Main', 'Default AutoIt Ver', $sAutoIt_Def_Ver)
						
						_Replace_AutoItDir(False)
						_Add_RegistryData()
						
						If $iLoad_AutoItTools Then
							_AppInteraction_Send('AutoIt Tools', 'AutoIt_Dir_Changed') ;Reloads menus in AutoIt Tools to read new autoit dir (after replacement)
						EndIf
						
						If WinExists('[ClASS:SciTEWindow]') Then
							MsgBox(48, $sApp_Name & ' - Attention', 'Please restart SciTE for correct AutoIt version recognition.')
						EndIf
					EndIf
				EndIf
				
				ExitLoop
			WEnd
			
			TraySetState(1)
			TraySetToolTip($sApp_Name & ' (AutoIt Version' & (StringInStr($sAutoIt_Def_Ver, 'Beta\') ? ' (Beta)' : '') & ': ' & $sAutoIt_Ver & ')')
		Case $iAutVerManager_TrayItem
			Run($sAutVerManager, StringRegExpReplace($sAutVerManager, '\\[^\\]+$', ''))
		Case $iPersonalize_TrayItem
			TraySetState(2)
			_Personalize_Data()
			TraySetState(1)
		Case $iStartWithWindows_TrayItem
			If RegRead('HKCU\Software\Microsoft\Windows\CurrentVersion\Run', $sApp_Name) = $sExe_File & ' /Startup:' & $iStartup_Delay Then
				RegDelete('HKCU\Software\Microsoft\Windows\CurrentVersion\Run', $sApp_Name)
				_TrayItemSetIcon($iStartWithWindows_TrayItem, -3)
			Else
				RegWrite('HKCU\Software\Microsoft\Windows\CurrentVersion\Run', $sApp_Name, 'REG_SZ', $sExe_File & ' /Startup:' & $iStartup_Delay)
				_TrayItemSetIcon($iStartWithWindows_TrayItem, -4)
			EndIf
		Case $iAbout_TrayItem
			TraySetState(2)
			
			Local $aData[$ABX_DATA_TOTAL]
			
			$aData[$ABX_DATA_MAINTEXT] = $sApp_Name
			$aData[$ABX_DATA_SUBTEXT] = 'Version: ' & @CRLF & 'v' & $sApp_Ver
			$aData[$ABX_DATA_SCROLLTEXT] = _
				'<img width=270 height=100>' & $sAbout_Img_File & '</img>\n\n\n\n\n\n\n' & _
				_GetResData('FileDescription') & '(Georgia,12,0xFF0000)\n\nCredits:(Georgia,12)\n'
			
			Local $aCredits = StringSplit(StringStripCR(FileRead($sCredits_File)), @LF)
			
			For $i = 1 To $aCredits[0]
				If StringStripWS($aCredits[$i], 3) = '' Then
					$aData[$ABX_DATA_SCROLLTEXT] &= '\n\n'
				Else
					$aData[$ABX_DATA_SCROLLTEXT] &= '\n' & $aCredits[$i] & '(Comic Sans MS,10)'
				EndIf
			Next
			
			$aData[$ABX_DATA_SCROLLTEXT] &= '\n\n\n'
			$aData[$ABX_DATA_COPYRIGHTTEXT] = _GetResData('LegalCopyright') & ', ' & _GetResData('CompanyName')
			Local $aHyperLinks[4] = [3, 'AutoIt Script Page|http://autoitscript.com', 'AutoIt Russian Community|http://autoit-script.ru', 'CreatoR''s Lab|http://creator-lab.ucoz.ru']
			
			_AboutBox('About ' & $sApp_Name, $aData, $aHyperLinks, 0, @AutoItExe, 0x0000FF, 0xFFFFFF, 1)
			TraySetState(1)
		Case $iUpdateCheck_TrayItem
			IniWrite($sConfig_File, 'Update', 'Last Update Check', TimerInit())
			_AppCheckUpdates(0, -1)
		Case $iExit_TrayItem
			Exit
	EndSwitch
WEnd

Func _OnExit()
	;TraySetState(2)
	TraySetClick(0)
	TraySetToolTip($sApp_Name & ' - Please wait, unloading...')
	
	_Restore_RegistryData()
	_Replace_AutoItDir(True)
	
	If $iLoad_AutoItTools Then
		WinClose('[CLASS:AutoIt v3 GUI;TITLE:AutoIt Tools]')
		WinWaitClose('[CLASS:AutoIt v3 GUI;TITLE:AutoIt Tools]', '', 5)
		
		If ProcessExists($iLoad_AutoItTools) Then
			ProcessClose($iLoad_AutoItTools)
		EndIf
	EndIf
	
	RegDelete('HKCU\Software\Microsoft\Windows\CurrentVersion\RunOnce', $sApp_Name)
EndFunc

Func _RunOnce()
	Local $iOld_WTMM = Opt('WinTitleMatchMode', 3)
	
	If WinExists('[CLASS:AutoIt v3;TITLE:~' & $sApp_Name & '~]') Then
		MsgBox(48, $sApp_Name, 'Only one instance of this program allowed.')
		Exit
	EndIf
	
	AutoItWinSetTitle('~' & $sApp_Name & '~')
	Opt('WinTitleMatchMode', $iOld_WTMM)
EndFunc

Func _Check_Update()
	;Check for update in quit mode (only if new version available there will be a message)
	If $iUpdate_Check And (Not $iUpdate_Last_Check Or (TimerDiff($iUpdate_Last_Check) / 1000 / 60 / 60) >= $iUpdate_Interval) Then
		IniWrite($sConfig_File, 'Update', 'Last Update Check', TimerInit())
		_AppCheckUpdates(0, 1)
	EndIf
EndFunc

Func _Personalize_Data()
	Local $iW = 400, $iH = 450
	
	Local $aAbbrevCopyright = StringRegExp(FileRead($sSciTE_Dir & '\abbrev\au3.user.abbrev'), '(?i)Author:\\t\\t\\t\\t(.*?)\\n\\tAutoIt version', 3)
	Local $aPragmaCopyright = StringRegExp(FileRead($sSciTE_Dir & '\Tools\Compiler Wrapper\Default.pragma'), '(?i)#pragma compile\(LegalCopyright, (.*?)\)', 3)
	Local $aPragmaTrademark = StringRegExp(FileRead($sSciTE_Dir & '\Tools\Compiler Wrapper\Default.pragma'), '(?i)#pragma compile\(LegalTrademark, (.*?)\)', 3)
	Local $aPragmaCompany = StringRegExp(FileRead($sSciTE_Dir & '\Tools\Compiler Wrapper\Default.pragma'), '(?i)#pragma compile\(CompanyName, (.*?)\)', 3)
	Local $aPragmaComments = StringRegExp(FileRead($sSciTE_Dir & '\Tools\Compiler Wrapper\Default.pragma'), '(?i)#pragma compile\(Comments, (.*?)\)', 3)
	
	Local $sOld_UDFCreator = IniRead($sSciTE_Dir & '\properties\au3.properties', 'Advanced', 'udf.creator', '')
	Local $sOld_AbbrevCopyright = (IsArray($aAbbrevCopyright) ? $aAbbrevCopyright[0] : '')
	Local $sOld_PragmaCopyright = (IsArray($aPragmaCopyright) ? $aPragmaCopyright[0] : '')
	Local $sOld_PragmaTrademark = (IsArray($aPragmaTrademark) ? $aPragmaTrademark[0] : '')
	Local $sOld_PragmaCompany = (IsArray($aPragmaCompany) ? $aPragmaCompany[0] : '')
	Local $sOld_PragmaComments = (IsArray($aPragmaComments) ? $aPragmaComments[0] : '')
	
	Local $hPrsnlz_GUI = GUICreate('Personalize', $iW, $iH)
	
	GUICtrlCreateLabel('Personalize AutoIt data:', 20, 10)
	
	GUICtrlCreateLabel('UDF Creator', 20, 40)
	Local $iUDFCreator_Input = GUICtrlCreateInput($sOld_UDFCreator, 20, 60, $iW - 40, 20)
	
	GUICtrlCreateLabel('Copyright for abbrevs', 20, 100)
	Local $iAbbrevCopyright_Input = GUICtrlCreateInput($sOld_AbbrevCopyright, 20, 120, $iW - 40, 20)
	
	GUICtrlCreateLabel('Copyright for default pragma directives', 20, 160)
	Local $iPragmaCopyright_Input = GUICtrlCreateInput($sOld_PragmaCopyright, 20, 180, $iW - 40, 20)
	
	GUICtrlCreateLabel('Trademark for default pragma directives', 20, 220)
	Local $iPragmaTrademark_Input = GUICtrlCreateInput($sOld_PragmaTrademark, 20, 240, $iW - 40, 20)
	
	GUICtrlCreateLabel('Company name for default pragma directives', 20, 280)
	Local $iPragmaCompany_Input = GUICtrlCreateInput($sOld_PragmaCompany, 20, 300, $iW - 40, 20)
	
	GUICtrlCreateLabel('Comments for default pragma directives', 20, 340)
	Local $iPragmaComments_Input = GUICtrlCreateInput($sOld_PragmaComments, 20, 360, $iW - 40, 20)
	
	Local $iOk_Bttn = GUICtrlCreateButton('OK', 20, $iH - 30, 70, 20)
	Local $iCancel_Bttn = GUICtrlCreateButton('Cancel', 120, $iH - 30, 70, 20)
	
	GUISetState(@SW_SHOW, $hPrsnlz_GUI)
	
	While 1
		Switch GUIGetMsg()
			Case $GUI_EVENT_CLOSE, $iCancel_Bttn
				ExitLoop
			Case $iOk_Bttn
				Local $sUDFCreator = StringStripWS(GUICtrlRead($iUDFCreator_Input), 3)
				Local $sAbbrevCopyright = StringStripWS(GUICtrlRead($iAbbrevCopyright_Input), 3)
				Local $sPragmaCopyright = StringStripWS(GUICtrlRead($iPragmaCopyright_Input), 3)
				Local $sPragmaTrademark = StringStripWS(GUICtrlRead($iPragmaTrademark_Input), 3)
				Local $sPragmaCompany = StringStripWS(GUICtrlRead($iPragmaCompany_Input), 3)
				Local $sPragmaComments = StringStripWS(GUICtrlRead($iPragmaComments_Input), 3)
				
				$sUDFCreator = ($sUDFCreator ? $sUDFCreator : $sOld_UDFCreator)
				$sAbbrevCopyright = ($sAbbrevCopyright ? $sAbbrevCopyright : $sOld_AbbrevCopyright)
				$sPragmaCopyright = ($sPragmaCopyright ? $sPragmaCopyright : $sOld_PragmaCopyright)
				$sPragmaTrademark = ($sPragmaTrademark ? $sPragmaTrademark : $sOld_PragmaTrademark)
				$sPragmaCompany = ($sPragmaCompany ? $sPragmaCompany : $sOld_PragmaCompany)
				$sPragmaComments = ($sPragmaComments ? $sPragmaComments : $sOld_PragmaComments)
				
				IniWrite($sSciTE_Dir & '\properties\au3.properties', 'Advanced', 'udf.creator', $sUDFCreator)
				_FileReplaceString($sSciTE_Dir & '\abbrev\au3.user.abbrev', '(?i)Author:\\t\\t\\t\\t(.*?)\\n\\tAutoIt version', 'Author:\\t\\t\\t\\t' & $sAbbrevCopyright & '\\n\\tAutoIt version')
				_FileReplaceString($sSciTE_Dir & '\Tools\Compiler Wrapper\Default.pragma', '(?i)#pragma compile\(LegalCopyright, (.*?)\)', '#pragma compile(LegalCopyright, ' & $sPragmaCopyright & ')')
				_FileReplaceString($sSciTE_Dir & '\Tools\Compiler Wrapper\Default.pragma', '(?i)#pragma compile\(LegalTrademark, (.*?)\)', '#pragma compile(LegalTrademark, ' & $sPragmaTrademark & ')')
				_FileReplaceString($sSciTE_Dir & '\Tools\Compiler Wrapper\Default.pragma', '(?i)#pragma compile\(CompanyName, (.*?)\)', '#pragma compile(CompanyName, ' & $sPragmaCompany & ')')
				_FileReplaceString($sSciTE_Dir & '\Tools\Compiler Wrapper\Default.pragma', '(?i)#pragma compile\(Comments, (.*?)\)', '#pragma compile(Comments, ' & $sPragmaComments & ')')
				
				ExitLoop
		EndSwitch
	WEnd
	
	GUIDelete($hPrsnlz_GUI)
EndFunc

Func _Replace_AutoItDir($bRestore)
	Local $aSName, $sVar, $sLast, $sReplace, $sFile, $sSect, $sKeys, $aKeys, $aSect, $sRead, $hFile
	
	If Not $bRestore Then
		FileCopy($sAutoIt_Dir & '\Extras\au3.api', $sSciTE_Dir & '\api\au3.api', 1)
		FileCopy($sAutoIt_Dir & '\Extras\au3.keywords.properties', $sSciTE_Dir & '\properties\au3.keywords.properties', 1)
	EndIf
	
	$aSName = IniReadSectionNames($sConfig_File)
	
	For $i = 1 To UBound($aSName) - 1
		If Not StringRegExp($aSName[$i], '(?i)^File\d*_') Then
			ContinueLoop
		EndIf
		
		$sVar = IniRead($sConfig_File, $aSName[$i], 'Var', '')
		$sLast = IniRead($sConfig_File, $aSName[$i], 'Replaced', '')
		
		Switch $sVar
			Case '%AutoIt_Dir%'
				$sReplace = ($bRestore ? $sVar : $sAutoIt_Dir)
				$sVar = ($bRestore ? ($sLast ? $sLast : $sAutoIt_Dir) : ($sLast ? $sLast : $sVar))
			Case '%AutoIt_Loader_Dir%'
				$sReplace = ($bRestore ? $sVar : $sScript_Dir)
				$sVar = ($bRestore ? ($sLast ? $sLast : $sScript_Dir) : ($sLast ? $sLast : $sVar))
			Case Else
				ContinueLoop
		EndSwitch
		
		$sFile = _PathFull(StringRegExpReplace($aSName[$i], '(?i)^File\d*_', ''), $sScript_Dir)
		$sSect = IniRead($sConfig_File, $aSName[$i], 'Sect', '')
		$sKeys = IniRead($sConfig_File, $aSName[$i], 'Keys', '')
		
		If Not FileExists($sFile) Then
			ContinueLoop
		EndIf
		
		Select
			Case $sSect And $sKeys
				$aKeys = StringSplit($sKeys, ',')
				
				For $j = 1 To $aKeys[0]
					IniWrite($sFile, $sSect, $aKeys[$j], StringReplace(IniRead($sFile, $sSect, $aKeys[$j], ''), $sVar, $sReplace, 0, 2))
				Next
			Case $sSect
				$aSect = IniReadSection($sFile, $sSect)
				
				For $j = 1 To UBound($aSect) - 1
					IniWrite($sFile, $sSect, $aSect[$j][0], StringReplace($aSect[$j][1], $sVar, $sReplace, 0, 2))
				Next
			Case Else
				$sRead = StringReplace(FileRead($sFile), $sVar, $sReplace, 0, 2)
				
				$hFile = FileOpen($sFile, 2)
				FileWrite($hFile, $sRead)
				FileClose($hFile)
		EndSelect
		
		IniWrite($sConfig_File, $aSName[$i], 'Replaced', ($bRestore ? '' : $sReplace))
	Next
EndFunc

Func _Remember_RegistryData()
	For $i = 0 To UBound($aRegData) - 1
		RunWait('RegEdit.exe /E "' & StringTrimRight($aRegData[$i][$iRegData_File], 5) & ($i + 1) & '.tmp" "' & $aRegData[$i][$iRegData_Key] & '"', $sScript_Dir)
		RegDelete($aRegData[$i][$iRegData_Key])
	Next
EndFunc

Func _Restore_RegistryData()
	For $i = 0 To UBound($aRegData) - 1
		$aRegData[$i][$iRegData_File] = StringTrimRight($aRegData[$i][$iRegData_File], 5) & ($i + 1) & '.tmp'
		
		RegDelete($aRegData[$i][$iRegData_Key])
		RunWait('RegEdit.exe /S "' & $aRegData[$i][$iRegData_File] & '"', $sScript_Dir)
		FileDelete($aRegData[$i][$iRegData_File])
	Next
	
	;Remove traces
	DirRemove(@AppDataDir & '\..\Local\AutoIt v3', 1)
	
	;Notify about file assocciations change
	_WinAPI_ShellChangeNotify($SHCNE_ASSOCCHANGED, BitOR($SHCNF_IDLIST, $SHCNF_FLUSH))
EndFunc

Func _Add_RegistryData()
	Local Enum $iRegData_Key, $iRegData_ValName, $iRegData_Value, _
		$iRegData_Total
	
	Local $aRegData[][$iRegData_Total] = _
		[ _
			['HKCU\Software\AutoIt v3\AutoIt', 'InstallDir', $sAutoIt_Dir], _
			['HKCU\Software\AutoIt v3\AutoIt', 'Include', $sAutoIt_Dir & '\Include;' & $sAutoItVers_Dir & '\UDFs'], _
			['HKCU\Software\Classes\.au3', '', 'AutoIt3Script'], _
			['HKCU\Software\Classes\.au3', 'PerceivedType', 'text'], _
			['HKCU\Software\Classes\.au3\ShellNew', 'FileName', ''], _
			['HKCU\Software\Classes\AutoIt3Script', '', 'AutoIt v3 Script'], _
			['HKCU\Software\Classes\AutoIt3Script\DefaultIcon', '', $sAutoItVers_Dir & '\Icons\AutoIt3Script.ico'], _
			['HKCU\Software\Classes\AutoIt3Script\Shell', '', '1_RunX86'], _
			['HKCU\Software\Classes\AutoIt3Script\Shell\1_RunX86', '', 'Run (' & $sAutoIt_Ver & ')'], _
			['HKCU\Software\Classes\AutoIt3Script\Shell\1_RunX86\Command', '', '"' & $sAutoIt_Dir & '\AutoIt3.exe" "%1"'], _
			['HKCU\Software\Classes\AutoIt3Script\Shell\2_RunX64', '', 'Run x64 (' & $sAutoIt_Ver & ')'], _
			['HKCU\Software\Classes\AutoIt3Script\Shell\2_RunX64\Command', '', '"' & $sAutoIt_Dir & '\AutoIt3_x64.exe" "%1"'], _
			['HKCU\Software\Classes\AutoIt3Script\Shell\3_RunRW', '', 'Run with Run Wrapper'], _
			['HKCU\Software\Classes\AutoIt3Script\Shell\3_RunRW\Command', '', '"' & $sSciTE_Dir & '\Tools\Run Wrapper\RW.exe" "%1"'], _
			['HKCU\Software\Classes\AutoIt3Script\Shell\4_CompileX86', '', 'Compile Script (x86)'], _
			['HKCU\Software\Classes\AutoIt3Script\Shell\4_CompileX86\Command', '', '"' & $sAutoIt_Dir & '\Aut2Exe\Aut2Exe.exe" /in "%l"'], _
			['HKCU\Software\Classes\AutoIt3Script\Shell\5_CompileX64', '', 'Compile Script (x64)'], _
			['HKCU\Software\Classes\AutoIt3Script\Shell\5_CompileX64\Command', '', '"' & $sAutoIt_Dir & '\Aut2Exe\Aut2Exe_x64.exe" /in "%l"'], _
			['HKCU\Software\Classes\AutoIt3Script\Shell\6_Compile With Compiler Wrapper', '', 'Compile with Compiler Wrapper'], _
			['HKCU\Software\Classes\AutoIt3Script\Shell\6_Compile With Compiler Wrapper\Command', '', '"' & $sSciTE_Dir & '\Tools\Compiler Wrapper\CW.exe" "%l" /m:1 /c:0'], _
			['HKCU\Software\Classes\AutoIt3Script\Shell\Edit', '', 'Edit'], _
			['HKCU\Software\Classes\AutoIt3Script\Shell\Edit\Command', '', '"' & $sSciTE_Dir & '\SciTE.exe" "%1"'], _
			['HKCU\Software\Classes\AutoIt3Script\Shell\Open', '', 'Open'], _
			['HKCU\Software\Classes\AutoIt3Script\Shell\Open\Command', '', '"' & $sSciTE_Dir & '\SciTE.exe" "%1"'], _
			['HKCU\Software\Classes\.a3x', '', 'AutoIt3XScript'], _
			['HKCU\Software\Classes\AutoIt3XScript', '', 'AutoIt v3 Encoded Script'], _
			['HKCU\Software\Classes\AutoIt3XScript\DefaultIcon', '', $sAutoItVers_Dir & '\Icons\AutoIt3XScript.ico'], _
			['HKCU\Software\Classes\AutoIt3XScript\shell', '', 'Run'], _
			['HKCU\Software\Classes\AutoIt3XScript\shell\Run\command', '', '"' & $sAutoIt_Dir & '\AutoIt3.exe" "%1" %*'], _
			['HKCU\Software\Classes\AutoIt3XScript\shell\Run', '', 'Run'], _
			['HKCU\Software\Classes\AutoIt3XScript\shell\RunX64', '', 'Run (x64)'], _
			['HKCU\Software\Classes\AutoIt3XScript\shell\RunX64', 'Extended', ''], _
			['HKCU\Software\Classes\AutoIt3XScript\shell\RunX64\command', '', '"' & $sAutoIt_Dir & '\AutoIt3_x64.exe" "%1" %*'] _
		]
	
	For $i = 0 To UBound($aRegData) - 1
		RegWrite($aRegData[$i][$iRegData_Key], $aRegData[$i][$iRegData_ValName], 'REG_SZ', $aRegData[$i][$iRegData_Value])
	Next
	
	;Notify about file assocciations change
	_WinAPI_ShellChangeNotify($SHCNE_ASSOCCHANGED, BitOR($SHCNF_IDLIST, $SHCNF_FLUSH))
EndFunc

Func _FileReplaceString($sFile, $sString, $sReplace, $fRegExp = True)
	Local $sRead
	
	If $fRegExp Then
		$sRead = StringRegExpReplace(FileRead($sFile), $sString, $sReplace)
	Else
		$sRead = StringReplace(FileRead($sFile), $sString, $sReplace)
	EndIf
	
	Local $hFile = FileOpen($sFile, FileGetEncoding($sFile) + 2)
	FileWrite($hFile, $sRead)
	FileClose($hFile)
EndFunc

Func _ProcessPathExists($sPath)
	Local $aProc = ProcessList(StringRegExpReplace($sPath, '^.*\\', ''))
	
	For $i = 1 To UBound($aProc) - 1
		If _WinAPI_GetProcessFileName($aProc[$i][1]) = $sPath Then
			Return $aProc[$i][1]
		EndIf
	Next
	
	Return 0
EndFunc

Func _TrayItemSetIcon($iItemID, $iIconID)
	Local Static $hMenu = TrayItemGetHandle(0)
	_GUICtrlMenu_SetItemBmp($hMenu, $iItemID, _WinAPI_Create32BitHBITMAP(_WinAPI_ShellExtractIcon($sIcons_File, $iIconID, 20, 20), True, True), False)
EndFunc

Func _GetResData($sRes)
	If @Compiled Then
		Return FileGetVersion(@AutoItExe, $sRes)
	EndIf
	
	Local $sRet = StringRegExpReplace(FileRead(@ScriptFullPath), '(?si)^.*?#pragma compile\(' & $sRes & ', [''"]?(.*?)[''"]?\)\r\n.*$', '\1')
	
	If @extended = 0 Then
		$sRet = StringRegExpReplace(FileRead(@ScriptFullPath), '(?si)^.*?#AutoIt3Wrapper_Res_' & $sRes & '=([^\r\n]+).*$', '\1')
		
		If @extended = 0 Then
			Return $sRes
		EndIf
	EndIf
	
	Return StringStripWS($sRet, 3)
EndFunc
