#include-once

Func _InetGetSpeed($hInet)
	Local $iOld_Bytes = InetGetInfo($hInet, 0)
	
	Sleep(1000)
	
	Return (InetGetInfo($hInet, 0) - $iOld_Bytes)
EndFunc

Func _InetGetRemained($iBytes, $iTotalBytesSize, $iSpeedByBytes)
	Local $iRemained = Int(($iTotalBytesSize - $iBytes) / $iSpeedByBytes)
	
	If $iRemained < 0 Then
		$iRemained = 0
	EndIf
	
	Return $iRemained
EndFunc

Func _InetGetPrecent($iBytes, $iTotalBytesSize)
	Local $iPrecent = Int(100 / ($iTotalBytesSize / $iBytes))
	
	If $iPrecent < 0 Then
		$iPrecent = 0
	EndIf
	
	Return $iPrecent
EndFunc

Func _InetGetSecsToTime($iTicks, $sDelim = ':')
	If Number($iTicks) >= 0 Then
		Local $iHours = Int($iTicks / 3600)
		$iTicks = Mod($iTicks, 3600)
		Local $iMins = Int($iTicks / 60)
		Local $iSecs = Round(Mod($iTicks, 60))
		If StringLen($iHours) = 1 Then $iHours = '0' & $iHours
		If StringLen($iMins) = 1 Then $iMins = '0' & $iMins
		If StringLen($iSecs) = 1 Then $iSecs = '0' & $iSecs
		Return $iHours & $sDelim & $iMins & $sDelim & $iSecs
	EndIf
	
	Return SetError(1, 0, '00' & $sDelim & '00' & $sDelim & '00')
EndFunc
