#include <GDIPlus.au3>
#include <GUIConstantsEx.au3>

Example()

Func Example()
	Local $hGUI = GUICreate("GDI+", 420, 420)
	GUISetState(@SW_SHOW)

	_GDIPlus_Startup()
	Local $hGraphics = _GDIPlus_GraphicsCreateFromHWND($hGUI)
	_GDIPlus_GraphicsSetSmoothingMode($hGraphics, $GDIP_SMOOTHINGMODE_HIGHQUALITY)
	_GDIPlus_GraphicsClear($hGraphics, 0xFF000000)

	Local $aPathData[107][3] = [[106, 0, 0],[192.18, 15.75, 0],[226.79, 15.73, 3],[259.23, 24.91, 3],[287.25, 40.92, 3],[294.60, 17.47, 3],[316.50, 0.47, 3],[342.35, 0.47, 3],[374.28, 0.47, 3],[400.13, 26.32, 3], _
			[400.13, 58.25, 3],[400.13, 84.25, 3],[382.94, 106.24, 3],[359.35, 113.49, 3],[374.98, 141.27, 3],[383.93, 173.29, 3],[383.93, 207.43, 3],[383.93, 313.34, 3],[298.08, 399.19, 3],[192.18, 399.19, 3], _
			[86.32, 399.19, 3],[0.47, 313.34, 3],[0.47, 207.43, 3],[0.47, 101.57, 3],[86.32, 15.73, 3],[192.18, 15.73, 131],[192.18, 359.65, 0],[275.76, 359.21, 3],[343.95, 291.02, 3],[343.95, 207.43, 3], _
			[343.95, 123.85, 3],[275.76, 55.71, 3],[192.18, 55.71, 3],[108.59, 55.71, 3],[40.45, 123.85, 3],[40.45, 207.43, 3],[40.45, 291.02, 3],[108.59, 359.21, 3],[192.18, 359.21, 131],[142.45, 263.80, 0], _
			[151.82, 250.76, 3],[161.19, 238.04, 3],[170.52, 225.28, 3],[182.85, 225.28, 3],[222.74, 224.72, 3],[234.98, 225.75, 3],[224.86, 212.85, 3],[201.83, 178.14, 3],[192.79, 164.96, 3],[169.24, 197.78, 3], _
			[145.75, 230.65, 3],[122.25, 263.47, 3],[103.93, 263.47, 3],[85.56, 263.47, 3],[67.25, 263.47, 3],[99.36, 218.74, 3],[131.48, 173.95, 3],[163.59, 129.22, 3],[179.65, 107.08, 3],[207.39, 106.38, 3], _
			[223.30, 129.22, 3],[254.62, 173.95, 3],[285.89, 218.74, 3],[317.20, 263.47, 3],[258.95, 263.47, 3],[200.70, 263.47, 3],[142.45, 263.47, 131],[320.36, 45.92, 0],[331.57, 45.87, 3],[342.77, 45.87, 3], _
			[353.98, 45.87, 3],[360.34, 45.87, 3],[360.53, 52.18, 3],[353.98, 52.18, 3],[344.19, 52.18, 3],[334.34, 52.18, 3],[324.55, 52.18, 3],[327.14, 55.47, 3],[329.78, 58.77, 3],[332.41, 62.02, 3], _
			[336.98, 62.02, 3],[354.69, 61.41, 3],[357.18, 62.68, 3],[358.88, 63.57, 3],[359.87, 68.09, 3],[354.22, 68.09, 3],[340.51, 68.09, 3],[326.81, 68.09, 3],[313.06, 68.09, 3],[316.36, 72.05, 3], _
			[319.61, 76.05, 3],[322.85, 80.05, 3],[330.67, 80.05, 3],[355.25, 80.62, 3],[361.52, 79.25, 3],[376.63, 75.91, 3],[375.22, 60.70, 3],[366.18, 57.69, 3],[376.11, 54.95, 3],[378.04, 38.94, 3], _
			[363.59, 35.08, 3],[356.67, 33.25, 3],[320.22, 34.05, 3],[310.66, 34.05, 3],[313.91, 38.00, 3],[317.11, 41.96, 3],[320.36, 45.87, 131]]

	Local $hPath = _GDIPlus_PathCreate2($aPathData)

	Local $hBrush = _GDIPlus_BrushCreateSolid(0x7F0088AA)
	Local $hPen = _GDIPlus_PenCreate(0xFF0088AA, 2)

	_GDIPlus_GraphicsTranslateTransform($hGraphics, 10, 10)

	_GDIPlus_GraphicsFillPath($hGraphics, $hPath, $hBrush)
	_GDIPlus_GraphicsDrawPath($hGraphics, $hPath, $hPen)

	; Loop until the user exits.
	Do
	Until GUIGetMsg() = $GUI_EVENT_CLOSE

	; Clean up resources
	_GDIPlus_BrushDispose($hBrush)
	_GDIPlus_PenDispose($hPen)
	_GDIPlus_PathDispose($hPath)
	_GDIPlus_GraphicsDispose($hGraphics)
	_GDIPlus_Shutdown()
EndFunc   ;==>Example
