#include-once

#include "APIGdiConstants.au3"
#include "WinAPI.au3"
#include "WinAPICom.au3"
#include "WinAPIInternals.au3"

; #INDEX# =======================================================================================================================
; Title .........: WinAPI Extended UDF Library for AutoIt3
; AutoIt Version : 3.3.8.1++
; Description ...: Additional variables, constants and functions for the WinAPIGdi.au3
; Author(s) .....: Yashied, jpm
; Dll(s) ........: gdi32.dll, user32.dll, comctl32.dll, shlwapi.dll, gdiplus.dll, ole32.dll, kernel32.dll, dwmapi.dll
; Requirements ..: AutoIt v3.3 +, Developed/Tested on Windows XP Pro Service Pack 2 and Windows Vista/7
; ===============================================================================================================================

#region Global Variables and Constants

; #CONSTANTS# ===================================================================================================================
Global Const $tagBITMAP = 'struct;long bmType;long bmWidth;long bmHeight;long bmWidthBytes;ushort bmPlanes;ushort bmBitsPixel;ptr bmBits;endstruct'
Global Const $tagBITMAPV4HEADER = 'struct;dword bV4Size;long bV4Width;long bV4Height;ushort bV4Planes;ushort bV4BitCount;dword bV4Compression;dword bV4SizeImage;long bV4XPelsPerMeter;long bV4YPelsPerMeter;dword bV4ClrUsed;dword bV4ClrImportant;dword bV4RedMask;dword bV4GreenMask;dword bV4BlueMask;dword bV4AlphaMask;dword bV4CSType;int bV4Endpoints[9];dword bV4GammaRed;dword bV4GammaGreen;dword bV4GammaBlue;endstruct'
Global Const $tagBITMAPV5HEADER = 'struct;dword bV5Size;long bV5Width;long bV5Height;ushort bV5Planes;ushort bV5BitCount;dword bV5Compression;dword bV5SizeImage;long bV5XPelsPerMeter;long bV5YPelsPerMeter;dword bV5ClrUsed;dword bV5ClrImportant;dword bV5RedMask;dword bV5GreenMask;dword bV5BlueMask;dword bV5AlphaMask;dword bV5CSType;int bV5Endpoints[9];dword bV5GammaRed;dword bV5GammaGreen;dword bV5GammaBlue;dword bV5Intent;dword bV5ProfileData;dword bV5ProfileSize;dword bV5Reserved;endstruct'
Global Const $tagCOLORADJUSTMENT = 'ushort Size;ushort Flags;ushort IlluminantIndex;ushort RedGamma;ushort GreenGamma;ushort BlueGamma;ushort ReferenceBlack;ushort ReferenceWhite;short Contrast;short Brightness;short Colorfulness;short RedGreenTint'
Global Const $tagDEVMODE_DISPLAY = 'wchar DeviceName[32];ushort SpecVersion;ushort DriverVersion;ushort Size;ushort DriverExtra;dword Fields;' & $tagPOINT & ';dword DisplayOrientation;dword DisplayFixedOutput;short Unused1[5];wchar Unused2[32];ushort LogPixels;dword BitsPerPel;dword PelsWidth;dword PelsHeight;dword DisplayFlags;dword DisplayFrequency'
Global Const $tagDIBSECTION = $tagBITMAP & ';' & $tagBITMAPINFOHEADER & ';dword dsBitfields[3];ptr dshSection;dword dsOffset'
Global Const $tagDWM_COLORIZATION_PARAMETERS = 'dword Color;dword AfterGlow;uint ColorBalance;uint AfterGlowBalance;uint BlurBalance;uint GlassReflectionIntensity; uint OpaqueBlend'
Global Const $tagENHMETAHEADER = 'struct;dword Type;dword Size;long rcBounds[4];long rcFrame[4];dword Signature;dword Version;dword Bytes;dword Records;ushort Handles;ushort Reserved;dword Description;dword OffDescription;dword PalEntries;long Device[2];long Millimeters[2];dword PixelFormat;dword OffPixelFormat;dword OpenGL;long Micrometers[2];endstruct'
Global Const $tagEXTLOGPEN = 'dword PenStyle;dword Width;uint BrushStyle;dword Color;ulong_ptr Hatch;dword NumEntries' ; & ';dword StyleEntry[n];'
Global Const $tagFONTSIGNATURE = 'dword fsUsb[4];dword fsCsb[2]'
Global Const $tagGLYPHMETRICS = 'uint BlackBoxX;uint BlackBoxY;' & $tagPOINT & ';short CellIncX;short CellIncY'
Global Const $tagLOGBRUSH = 'uint Style;dword Color;ulong_ptr Hatch'
Global Const $tagLOGPEN = 'uint Style;dword Width;dword Color'
Global Const $tagMAT2 = 'short eM11[2];short eM12[2];short eM21[2];short eM22[2]'
Global Const $tagNEWTEXTMETRIC = $tagTEXTMETRIC & ';dword ntmFlags;uint ntmSizeEM;uint ntmCellHeight;uint ntmAvgWidth'
Global Const $tagNEWTEXTMETRICEX = $tagNEWTEXTMETRIC & ';' & $tagFONTSIGNATURE
Global Const $tagPANOSE = 'struct;byte bFamilyType;byte bSerifStyle;byte bWeight;byte bProportion;byte bContrast;byte bStrokeVariation;byte bArmStyle;byte bLetterform;byte bMidline;byte bXHeight;endstruct'
Global Const $tagOUTLINETEXTMETRIC = 'struct;uint otmSize;' & $tagTEXTMETRIC & ';byte otmFiller;' & $tagPANOSE & ';byte bugFiller[3];uint otmSelection;uint otmType;int otmCharSlopeRise;int otmCharSlopeRun;int otmItalicAngle;uint otmEMSquare;int otmAscent;int otmDescent;uint otmLineGap;uint otmCapEmHeight;uint otmXHeight;long otmFontBox[4];int otmMacAscent;int otmMacDescent;uint otmMacLineGap;uint otmMinimumPPEM;long otmSubscriptSize[2];long otmSubscriptOffset[2];long otmSuperscriptSize[2];long otmSuperscriptOffse[2];uint otmStrikeoutSize;int otmStrikeoutPosition;int otmUnderscoreSize;int otmUnderscorePosition;uint_ptr otmFamilyName;uint_ptr otmFaceName;uint_ptr otmStyleName;uint_ptr otmFullName;endstruct'
Global Const $tagPAINTSTRUCT = 'hwnd hDC;int fErase;dword rPaint[4];int fRestore;int fIncUpdate;byte rgbReserved[32]'
Global Const $tagRGNDATAHEADER = 'struct;dword Size;dword Type;dword Count;dword RgnSize;' & $tagRECT & ';endstruct'
; Global Const $tagRGNDATA = $tagRGNDATAHEADER ; & $tagRECT[n] & ';'
Global Const $tagXFORM = 'float eM11;float eM12;float eM21;float eM22;float eDx;float eDy'
; ===============================================================================================================================
#endregion Global Variables and Constants

#region Functions list

; #CURRENT# =====================================================================================================================
; _WinAPI_AbortPath
; _WinAPI_AddFontMemResourceEx
; _WinAPI_AddFontResourceEx
; _WinAPI_AddIconOverlay
; _WinAPI_AdjustBitmap
; _WinAPI_AlphaBlend
; _WinAPI_AngleArc
; _WinAPI_Arc
; _WinAPI_ArcTo
; _WinAPI_BeginPaint
; _WinAPI_BeginPath
; _WinAPI_CloseEnhMetaFile
; _WinAPI_CloseFigure
; _WinAPI_ColorAdjustLuma
; _WinAPI_ColorHLSToRGB
; _WinAPI_ColorRGBToHLS
; _WinAPI_CombineTransform
; _WinAPI_CompressBitmapBits
; _WinAPI_CopyBitmap
; _WinAPI_CopyEnhMetaFile
; _WinAPI_CopyImage
; _WinAPI_CopyRect
; _WinAPI_Create32BitHBITMAP
; _WinAPI_Create32BitHICON
; _WinAPI_CreateANDBitmap
; _WinAPI_CreateBitmapIndirect
; _WinAPI_CreateBrushIndirect
; _WinAPI_CreateColorAdjustment
; _WinAPI_CreateCompatibleBitmapEx
; _WinAPI_CreateDIB
; _WinAPI_CreateDIBColorTable
; _WinAPI_CreateDIBitmap
; _WinAPI_CreateDIBSection
; _WinAPI_CreateEllipticRgn
; _WinAPI_CreateEmptyIcon
; _WinAPI_CreateEnhMetaFile
; _WinAPI_CreateFontEx
; _WinAPI_CreateIconIndirect
; _WinAPI_CreateNullRgn
; _WinAPI_CreatePolygonRgn
; _WinAPI_CreateRectRgnIndirect
; _WinAPI_CreateTransform
; _WinAPI_DeleteEnhMetaFile
; _WinAPI_DPtoLP
; _WinAPI_DrawAnimatedRects
; _WinAPI_DrawBitmap
; _WinAPI_DrawFocusRect
; _WinAPI_DrawShadowText
; _WinAPI_DwmDefWindowProc
; _WinAPI_DwmEnableBlurBehindWindow
; _WinAPI_DwmEnableComposition
; _WinAPI_DwmExtendFrameIntoClientArea
; _WinAPI_DwmGetColorizationColor
; _WinAPI_DwmGetColorizationParameters
; _WinAPI_DwmGetWindowAttribute
; _WinAPI_DwmInvalidateIconicBitmaps
; _WinAPI_DwmIsCompositionEnabled
; _WinAPI_DwmQueryThumbnailSourceSize
; _WinAPI_DwmRegisterThumbnail
; _WinAPI_DwmSetColorizationParameters
; _WinAPI_DwmSetIconicLivePreviewBitmap
; _WinAPI_DwmSetIconicThumbnail
; _WinAPI_DwmSetWindowAttribute
; _WinAPI_DwmUnregisterThumbnail
; _WinAPI_DwmUpdateThumbnailProperties
; _WinAPI_Ellipse
; _WinAPI_EndPaint
; _WinAPI_EndPath
; _WinAPI_EnumDisplayMonitors
; _WinAPI_EnumDisplaySettings
; _WinAPI_EnumFontFamilies
; _WinAPI_EqualRect
; _WinAPI_EqualRgn
; _WinAPI_ExcludeClipRect
; _WinAPI_ExtCreatePen
; _WinAPI_ExtCreateRegion
; _WinAPI_ExtFloodFill
; _WinAPI_ExtSelectClipRgn
; _WinAPI_FillPath
; _WinAPI_FillRgn
; _WinAPI_FlattenPath
; _WinAPI_FrameRgn
; _WinAPI_GdiComment
; _WinAPI_GetArcDirection
; _WinAPI_GetBitmapBits
; _WinAPI_GetBitmapDimension
; _WinAPI_GetBitmapDimensionEx
; _WinAPI_GetBkColor
; _WinAPI_GetBoundsRect
; _WinAPI_GetBrushOrg
; _WinAPI_GetBValue
; _WinAPI_GetClipBox
; _WinAPI_GetClipRgn
; _WinAPI_GetColorAdjustment
; _WinAPI_GetCurrentObject
; _WinAPI_GetCurrentPosition
; _WinAPI_GetDCEx
; _WinAPI_GetDeviceGammaRamp
; _WinAPI_GetDIBColorTable
; _WinAPI_GetEnhMetaFile
; _WinAPI_GetEnhMetaFileBits
; _WinAPI_GetEnhMetaFileDescription
; _WinAPI_GetEnhMetaFileDimension
; _WinAPI_GetEnhMetaFileHeader
; _WinAPI_GetFontName
; _WinAPI_GetFontResourceInfo
; _WinAPI_GetGlyphOutline
; _WinAPI_GetGraphicsMode
; _WinAPI_GetGValue
; _WinAPI_GetIconDimension
; _WinAPI_GetMapMode
; _WinAPI_GetObjectType
; _WinAPI_GetOutlineTextMetrics
; _WinAPI_GetPixel
; _WinAPI_GetPolyFillMode
; _WinAPI_GetPosFromRect
; _WinAPI_GetRegionData
; _WinAPI_GetRgnBox
; _WinAPI_GetROP2
; _WinAPI_GetRValue
; _WinAPI_GetStretchBltMode
; _WinAPI_GetTabbedTextExtent
; _WinAPI_GetTextAlign
; _WinAPI_GetTextCharacterExtra
; _WinAPI_GetTextColor
; _WinAPI_GetTextFace
; _WinAPI_GetUDFColorMode
; _WinAPI_GetUpdateRect
; _WinAPI_GetUpdateRgn
; _WinAPI_GetWindowExt
; _WinAPI_GetWindowOrg
; _WinAPI_GetWindowRgnBox
; _WinAPI_GetWorldTransform
; _WinAPI_GradientFill
; _WinAPI_InflateRect
; _WinAPI_IntersectClipRect
; _WinAPI_IntersectRect
; _WinAPI_InvalidateRgn
; _WinAPI_InvertANDBitmap
; _WinAPI_InvertColor
; _WinAPI_InvertRect
; _WinAPI_InvertRgn
; _WinAPI_IsAlphaBitmap
; _WinAPI_IsRectEmpty
; _WinAPI_LineDDA
; _WinAPI_LockWindowUpdate
; _WinAPI_LPtoDP
; _WinAPI_MaskBlt
; _WinAPI_ModifyWorldTransform
; _WinAPI_MonitorFromPoint
; _WinAPI_MonitorFromRect
; _WinAPI_MonitorFromWindow
; _WinAPI_MoveToEx
; _WinAPI_OffsetClipRgn
; _WinAPI_OffsetPoints
; _WinAPI_OffsetRect
; _WinAPI_OffsetRgn
; _WinAPI_OffsetWindowOrg
; _WinAPI_PaintDesktop
; _WinAPI_PaintRgn
; _WinAPI_PatBlt
; _WinAPI_PathToRegion
; _WinAPI_PlayEnhMetaFile
; _WinAPI_PlgBlt
; _WinAPI_PolyBezier
; _WinAPI_PolyBezierTo
; _WinAPI_PolyDraw
; _WinAPI_Polygon
; _WinAPI_PrintWindow
; _WinAPI_PtInRectEx
; _WinAPI_PtInRegion
; _WinAPI_PtVisible
; _WinAPI_RadialGradientFill
; _WinAPI_Rectangle
; _WinAPI_RectInRegion
; _WinAPI_RectVisible
; _WinAPI_RemoveFontMemResourceEx
; _WinAPI_RemoveFontResourceEx
; _WinAPI_RestoreDC
; _WinAPI_RGB
; _WinAPI_RotatePoints
; _WinAPI_RoundRect
; _WinAPI_SaveDC
; _WinAPI_SaveHBITMAPToFile
; _WinAPI_SaveHICONToFile
; _WinAPI_ScaleWindowExt
; _WinAPI_SelectClipPath
; _WinAPI_SelectClipRgn
; _WinAPI_SetArcDirection
; _WinAPI_SetBitmapBits
; _WinAPI_SetBitmapDimensionEx
; _WinAPI_SetBoundsRect
; _WinAPI_SetBrushOrg
; _WinAPI_SetColorAdjustment
; _WinAPI_SetDCBrushColor
; _WinAPI_SetDCPenColor
; _WinAPI_SetDeviceGammaRamp
; _WinAPI_SetDIBColorTable
; _WinAPI_SetDIBitsToDevice
; _WinAPI_SetEnhMetaFileBits
; _WinAPI_SetGraphicsMode
; _WinAPI_SetMapMode
; _WinAPI_SetPixel
; _WinAPI_SetPolyFillMode
; _WinAPI_SetRectRgn
; _WinAPI_SetROP2
; _WinAPI_SetStretchBltMode
; _WinAPI_SetTextAlign
; _WinAPI_SetTextCharacterExtra
; _WinAPI_SetTextJustification
; _WinAPI_SetUDFColorMode
; _WinAPI_SetWindowExt
; _WinAPI_SetWindowOrg
; _WinAPI_SetWorldTransform
; _WinAPI_StretchBlt
; _WinAPI_StretchDIBits
; _WinAPI_StrokeAndFillPath
; _WinAPI_StrokePath
; _WinAPI_SubtractRect
; _WinAPI_SwitchColor
; _WinAPI_TabbedTextOut
; _WinAPI_TextOut
; _WinAPI_TransparentBlt
; _WinAPI_UnionRect
; _WinAPI_ValidateRect
; _WinAPI_ValidateRgn
; _WinAPI_WidenPath
; _WinAPI_WindowFromDC
; ===============================================================================================================================
#endregion Functions list

#region Public Functions

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_AbortPath($hDC)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'AbortPath', 'handle', $hDC)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_AbortPath

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_AddFontMemResourceEx($pData, $iSize)
	Local $Ret = DllCall('gdi32.dll', 'handle', 'AddFontMemResourceEx', 'ptr', $pData, 'dword', $iSize, 'ptr', 0, 'dword*', 0)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return SetExtended($Ret[4], $Ret[0])
EndFunc   ;==>_WinAPI_AddFontMemResourceEx

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_AddFontResourceEx($sFont, $iFlag = 0, $fNotify = 0)
	Local $Ret = DllCall('gdi32.dll', 'int', 'AddFontResourceExW', 'wstr', $sFont, 'dword', $iFlag, 'ptr', 0)
	If @error Or Not $Ret[0] Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	If $fNotify Then
		Local Const $WM_FONTCHANGE = 0x001D
		Local Const $HWND_BROADCAST = 0xFFFF
		DllCall('user32.dll', 'lresult', 'SendMessage', 'hwnd', $HWND_BROADCAST, 'uint', $WM_FONTCHANGE, 'wparam', 0, _
				'lparam', 0)
	EndIf

	Return $Ret[0]
EndFunc   ;==>_WinAPI_AddFontResourceEx

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_AddIconOverlay($hIcon, $hOverlay)
	Local $Ret, $hResult = 0, $Error = 0
	Local $hDev[2] = [0, 0]

	Local $tSIZE = _WinAPI_GetIconDimension($hIcon)
	Local $hIL = DllCall('comctl32.dll', 'handle', 'ImageList_Create', 'int', DllStructGetData($tSIZE, 1), _
			'int', DllStructGetData($tSIZE, 2), 'uint', 0x0021, 'int', 2, 'int', 2)
	If @error Or Not $hIL[0] Then Return SetError(@error + 10, @extended, 0)

	Do
		$hDev[0] = _WinAPI_Create32BitHICON($hIcon)
		If @error Then
			$Error = @error + 100
			ExitLoop
		EndIf
		$Ret = DllCall('comctl32.dll', 'int', 'ImageList_ReplaceIcon', 'handle', $hIL[0], 'int', -1, 'handle', $hDev[0])
		If @error Or ($Ret[0] = -1) Then
			$Error = @error + 200
			ExitLoop
		EndIf
		$hDev[1] = _WinAPI_Create32BitHICON($hOverlay)
		If @error Then
			$Error = @error + 300
			ExitLoop
		EndIf
		$Ret = DllCall('comctl32.dll', 'int', 'ImageList_ReplaceIcon', 'handle', $hIL[0], 'int', -1, 'handle', $hDev[1])
		If @error Or ($Ret[0] = -1) Then
			$Error = @error + 400
			ExitLoop
		EndIf
		$Ret = DllCall('comctl32.dll', 'bool', 'ImageList_SetOverlayImage', 'handle', $hIL[0], 'int', 1, 'int', 1)
		If @error Or Not $Ret[0] Then
			$Error = @error + 500
			ExitLoop
		EndIf
		$Ret = DllCall('comctl32.dll', 'handle', 'ImageList_GetIcon', 'handle', $hIL[0], 'int', 0, 'uint', 0x00000100)
		If @error Or Not $Ret[0] Then
			$Error = @error + 600
			ExitLoop
		EndIf
		$hResult = $Ret[0]
	Until 1
	DllCall('comctl32.dll', 'bool', 'ImageList_Destroy', 'handle', $hIL[0])
	For $i = 0 To 1
		If $hDev[$i] Then
			_WinAPI_DestroyIcon($hDev[$i])

		EndIf
	Next
	If Not $hResult Then Return SetError($Error, 0, 0)

	Return $hResult
EndFunc   ;==>_WinAPI_AddIconOverlay

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_AdjustBitmap($hBitmap, $iWidth, $iHeight, $iMode = 3, $tAdjustment = 0)
	Local $tObj = DllStructCreate($tagBITMAP)
	Local $Ret = DllCall('gdi32.dll', 'int', 'GetObject', 'handle', $hBitmap, 'int', DllStructGetSize($tObj), 'struct*', $tObj)
	If @error Or Not $Ret[0] Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	If $iWidth = -1 Then
		$iWidth = DllStructGetData($tObj, 'bmWidth')
	EndIf
	If $iHeight = -1 Then
		$iHeight = DllStructGetData($tObj, 'bmHeight')
	EndIf
	$Ret = DllCall('user32.dll', 'handle', 'GetDC', 'hwnd', 0)
	Local $hDC = $Ret[0]
	$Ret = DllCall('gdi32.dll', 'handle', 'CreateCompatibleDC', 'handle', $hDC)
	Local $hDestDC = $Ret[0]
	$Ret = DllCall('gdi32.dll', 'handle', 'CreateCompatibleBitmap', 'handle', $hDC, 'int', $iWidth, 'int', $iHeight)
	Local $hBmp = $Ret[0]
	$Ret = DllCall('gdi32.dll', 'handle', 'SelectObject', 'handle', $hDestDC, 'handle', $hBmp)
	Local $hDestSv = $Ret[0]
	$Ret = DllCall('gdi32.dll', 'handle', 'CreateCompatibleDC', 'handle', $hDC)
	Local $hSrcDC = $Ret[0]
	$Ret = DllCall('gdi32.dll', 'handle', 'SelectObject', 'handle', $hSrcDC, 'handle', $hBitmap)
	Local $hSrcSv = $Ret[0]
	If _WinAPI_SetStretchBltMode($hDestDC, $iMode) Then
		Switch $iMode
			Case 4 ; HALFTONE
				If IsDllStruct($tAdjustment) Then
					If Not _WinAPI_SetColorAdjustment($hDestDC, $tAdjustment) Then
						; Nothing
					EndIf
				EndIf
			Case Else

		EndSwitch
	EndIf
	$Ret = _WinAPI_StretchBlt($hDestDC, 0, 0, $iWidth, $iHeight, $hSrcDC, 0, 0, DllStructGetData($tObj, 'bmWidth'), DllStructGetData($tObj, 'bmHeight'), 0x00CC0020)
	DllCall('user32.dll', 'int', 'ReleaseDC', 'hwnd', 0, 'handle', $hDC)
	DllCall('gdi32.dll', 'handle', 'SelectObject', 'handle', $hDestDC, 'handle', $hDestSv)
	DllCall('gdi32.dll', 'handle', 'SelectObject', 'handle', $hSrcDC, 'handle', $hSrcSv)
	DllCall('gdi32.dll', 'bool', 'DeleteDC', 'handle', $hDestDC)
	DllCall('gdi32.dll', 'bool', 'DeleteDC', 'handle', $hSrcDC)
	If Not $Ret Then Return SetError(10, 0, 0)

	Return $hBmp
EndFunc   ;==>_WinAPI_AdjustBitmap

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_AlphaBlend($hDestDC, $iXDest, $iYDest, $iWidthDest, $iHeightDest, $hSrcDC, $iXSrc, $iYSrc, $iWidthSrc, $iHeightSrc, $iAlpha, $fAlpha = 0)
	Local $iBlend = BitOR(BitShift(Not ($fAlpha = 0), -24), BitShift(BitAND($iAlpha, 0xFF), -16))
	Local $Ret = DllCall('gdi32.dll', 'bool', 'GdiAlphaBlend', 'handle', $hDestDC, 'int', $iXDest, 'int', $iYDest, _
			'int', $iWidthDest, 'int', $iHeightDest, 'handle', $hSrcDC, 'int', $iXSrc, 'int', $iYSrc, _
			'int', $iWidthSrc, 'int', $iHeightSrc, 'dword', $iBlend)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_AlphaBlend

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_AngleArc($hDC, $iX, $iY, $iRadius, $nStartAngle, $nSweepAngle)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'AngleArc', 'handle', $hDC, 'int', $iX, 'int', $iY, 'dword', $iRadius, _
			'float', $nStartAngle, 'float', $nSweepAngle)
	If @error Then Return SetError(@error, @extended, False)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_AngleArc

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_Arc($hDC, $tRECT, $iXStartArc, $iYStartArc, $iXEndArc, $iYEndArc)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'Arc', 'handle', $hDC, 'int', DllStructGetData($tRECT, 1), _
			'int', DllStructGetData($tRECT, 2), 'int', DllStructGetData($tRECT, 3), 'int', DllStructGetData($tRECT, 4), _
			'int', $iXStartArc, 'int', $iYStartArc, 'int', $iXEndArc, 'int', $iYEndArc)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_Arc

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_ArcTo($hDC, $tRECT, $iXRadial1, $iYRadial1, $iXRadial2, $iYRadial2)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'ArcTo', 'handle', $hDC, 'int', DllStructGetData($tRECT, 1), _
			'int', DllStructGetData($tRECT, 2), 'int', DllStructGetData($tRECT, 3), 'int', DllStructGetData($tRECT, 4), _
			'int', $iXRadial1, 'int', $iYRadial1, 'int', $iXRadial2, 'int', $iYRadial2)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_ArcTo

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_BeginPaint($hWnd, ByRef $tPAINTSTRUCT)
	$tPAINTSTRUCT = DllStructCreate($tagPAINTSTRUCT)
	Local $Ret = DllCall('user32.dll', 'handle', 'BeginPaint', 'hwnd', $hWnd, 'struct*', $tPAINTSTRUCT)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_BeginPaint

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_BeginPath($hDC)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'BeginPath', 'handle', $hDC)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_BeginPath

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_CloseEnhMetaFile($hDC)
	Local $Ret = DllCall('gdi32.dll', 'handle', 'CloseEnhMetaFile', 'handle', $hDC)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_CloseEnhMetaFile

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_CloseFigure($hDC)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'CloseFigure', 'handle', $hDC)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_CloseFigure

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_ColorAdjustLuma($iRGB, $iPercent, $fScale = 1)
	If $iRGB = -1 Then Return SetError(10, 0, -1)

	If $fScale Then
		$iPercent = Floor($iPercent * 10)
	EndIf

	Local $Ret = DllCall('shlwapi.dll', 'dword', 'ColorAdjustLuma', 'dword', __RGB($iRGB), 'int', $iPercent, 'bool', $fScale)
	If @error Then Return SetError(@error, @extended, -1)

	Return __RGB($Ret[0])
EndFunc   ;==>_WinAPI_ColorAdjustLuma

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_ColorHLSToRGB($iHue, $iLuminance, $iSaturation)
	If Not $iSaturation Then $iHue = 160

	Local $Ret = DllCall('shlwapi.dll', 'dword', 'ColorHLSToRGB', 'word', $iHue, 'word', $iLuminance, 'word', $iSaturation)
	If @error Then Return SetError(@error, @extended, -1)

	Return __RGB($Ret[0])
EndFunc   ;==>_WinAPI_ColorHLSToRGB

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_ColorRGBToHLS($iRGB, ByRef $iHue, ByRef $iLuminance, ByRef $iSaturation)
	Local $Ret = DllCall('shlwapi.dll', 'none', 'ColorRGBToHLS', 'dword', __RGB($iRGB), 'word*', 0, 'word*', 0, 'word*', 0)
	If @error Then Return SetError(@error, @extended, 0)

	$iHue = $Ret[2]
	$iLuminance = $Ret[3]
	$iSaturation = $Ret[4]
	Return 1
EndFunc   ;==>_WinAPI_ColorRGBToHLS

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_CombineTransform($tXFORM1, $tXFORM2)
	Local $tXFORM = DllStructCreate($tagXFORM)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'CombineTransform', 'struct*', $tXFORM, 'struct*', $tXFORM1, 'struct*', $tXFORM2)
	If @error Or Not $Ret[0] Then Return SetError(@error + 10, @extended, 0)

	Return $tXFORM
EndFunc   ;==>_WinAPI_CombineTransform

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_CompressBitmapBits($hBitmap, ByRef $pBuffer, $iCompression = 0, $iQuality = 100)
	If Not __DLL('gdiplus.dll') Then Return SetError(103, 0, 0)

	Local $Size[2], $Count, $Format, $Length, $Mime, $Ret, $hDC, $hSv, $hMem, $tBits, $tInfo, $tData, $pData, $Error = 1
	Local $hSource = 0, $hImage = 0, $hToken = 0, $pEncoder = 0, $pStream = 0, $tParam = 0
	Local $tDIB = DllStructCreate($tagDIBSECTION)

	Do
		Switch $iCompression
			Case 0
				$Mime = 'image/png'
			Case 1
				$Mime = 'image/jpeg'
			Case Else
				$Error = 10
				ExitLoop
		EndSwitch
		While $hBitmap
			If Not _WinAPI_GetObject($hBitmap, DllStructGetSize($tDIB), DllStructGetPtr($tDIB)) Then
				$Error = 11
				ExitLoop 2
			EndIf
			If (DllStructGetData($tDIB, 'bmBitsPixel') = 32) And (Not DllStructGetData($tDIB, 'biCompression')) Then
				$Error = 12
				ExitLoop
			EndIf
			If $hSource Then
				$Error = 13
				ExitLoop 2
			EndIf
			$hSource = _WinAPI_CreateDIB(DllStructGetData($tDIB, 'bmWidth'), DllStructGetData($tDIB, 'bmHeight'))
			If Not $hSource Then
				$Error = @error + 100
				ExitLoop 2
			EndIf
			$hDC = _WinAPI_CreateCompatibleDC(0)
			$hSv = _WinAPI_SelectObject($hDC, $hSource)
			If _WinAPI_DrawBitmap($hDC, 0, 0, $hBitmap) Then
				$hBitmap = $hSource
			Else
				$Error = @error + 200
				$hBitmap = 0
			EndIf
			_WinAPI_SelectObject($hDC, $hSv)
			_WinAPI_DeleteDC($hDC)
		WEnd
		If Not $hBitmap Then
			ExitLoop
		EndIf
		For $i = 0 To 1
			$Size[$i] = DllStructGetData($tDIB, $i + 2)
		Next
		$tBits = DllStructCreate('byte[' & ($Size[0] * $Size[1] * 4) & ']')
		If Not _WinAPI_GetBitmapBits($hBitmap, DllStructGetSize($tBits), DllStructGetPtr($tBits)) Then
			$Error = @error + 300
			ExitLoop
		EndIf
		$tData = DllStructCreate($tagGDIPSTARTUPINPUT)
		DllStructSetData($tData, "Version", 1)
		$Ret = DllCall('gdiplus.dll', 'int', 'GdiplusStartup', 'ulong_ptr*', 0, 'struct*', $tData, 'ptr', 0)
		If @error Or $Ret[0] Then
			$Error = @error + 400
			ExitLoop
		EndIf
		If _WinAPI_IsAlphaBitmap($hBitmap) Then
			$Format = 0x0026200A
		Else
			$Format = 0x00022009
		EndIf
		$hToken = $Ret[1]
		$Ret = DllCall('gdiplus.dll', 'int', 'GdipCreateBitmapFromScan0', 'int', $Size[0], 'int', $Size[1], _
				'uint', $Size[0] * 4, 'int', $Format, 'struct*', $tBits, 'ptr*', 0)
		If @error Or $Ret[0] Then
			$Error = @error + 500
			ExitLoop
		EndIf
		$hImage = $Ret[6]
		$Ret = DllCall('gdiplus.dll', 'int', 'GdipGetImageEncodersSize', 'uint*', 0, 'uint*', 0)
		If @error Or $Ret[0] Then
			$Error = @error + 600
			ExitLoop
		EndIf
		$Count = $Ret[1]
		$tData = DllStructCreate('byte[' & $Ret[2] & ']')
		If @error Then
			$Error = @error + 700
			ExitLoop
		EndIf
		$pData = DllStructGetPtr($tData)
		$Ret = DllCall('gdiplus.dll', 'int', 'GdipGetImageEncoders', 'uint', $Count, 'uint', $Ret[2], 'ptr', $pData)
		If @error Or $Ret[0] Then
			$Error = @error + 800
			ExitLoop
		EndIf
		Local Const $tagIMAGECODECINFO = 'byte[16] Clsid;byte[16] FormatID;ptr szCodecName;ptr szDllName;ptr szFormatDescription;ptr szFilenameExtension;ptr szMimeType;dword Flags;dword Version;dword SigCount;dword SigSize;ptr pbSigPattern;ptr pbSigMask'
		For $i = 1 To $Count
			$tInfo = DllStructCreate($tagIMAGECODECINFO, $pData)
			If Not StringInStr(_WinAPI_WideCharToMultiByte(DllStructGetData($tInfo, 'szMimeType')), $Mime) Then
				$pData += DllStructGetSize($tInfo)
			Else
				$pEncoder = $pData
				$Error = 14
				ExitLoop
			EndIf
		Next
		If Not $pEncoder Then
			$Error = 15
			ExitLoop
		EndIf
		Switch $iCompression
			Case 0
				; Nothing
			Case 1
				Local Const $tagENCODERPARAMETER = 'byte[16] GUID;ulong NumberOfValues;dword Type;ptr pValue'
				$tParam = DllStructCreate('dword Count;' & $tagENCODERPARAMETER & ';ulong Quality')
				DllStructSetData($tParam, 'Count', 1)
				DllStructSetData($tParam, 'NumberOfValues', 1)
				DllStructSetData($tParam, 'Type', 4)
				DllStructSetData($tParam, 'pValue', DllStructGetPtr($tParam, 'Quality'))
				DllStructSetData($tParam, 'Quality', $iQuality)
				$Ret = DllCall('ole32.dll', 'long', 'CLSIDFromString', 'wstr', '{1D5BE4B5-FA4A-452D-9CDD-5DB35105E7EB}', _
						'ptr', DllStructGetPtr($tParam, 2))
				If @error Or $Ret[0] Then
					$tParam = 0
				EndIf
		EndSwitch
		$pStream = _WinAPI_CreateStreamOnHGlobal()
		$Ret = DllCall('gdiplus.dll', 'int', 'GdipSaveImageToStream', 'ptr', $hImage, 'ptr', $pStream, _
				'ptr', $pEncoder, 'struct*', $tParam)
		If @error Or $Ret[0] Then
			$Error = @error + 900
			ExitLoop
		EndIf
		$hMem = _WinAPI_GetHGlobalFromStream($pStream)
		$Ret = DllCall('kernel32.dll', 'ulong_ptr', 'GlobalSize', 'handle', $hMem)
		If @error Or Not $Ret[0] Then
			$Error = @error + 1000
			ExitLoop
		EndIf
		$Length = $Ret[0]
		$Ret = DllCall('kernel32.dll', 'ptr', 'GlobalLock', 'handle', $hMem)
		If @error Or Not $Ret[0] Then
			$Error = @error + 1100
			ExitLoop
		EndIf
		$pBuffer = __HeapReAlloc($pBuffer, $Length, 1)
		If Not @error Then
			_WinAPI_MoveMemory($pBuffer, $Ret[0], $Length)
			; $Error = @error +1200 ; cannot really occur
			; EndIf
		Else
			$Error = @error + 1300
		EndIf
	Until 1
	If $pStream Then
		_WinAPI_ReleaseStream($pStream)
	EndIf
	If $hImage Then
		DllCall('gdiplus.dll', 'int', 'GdipDisposeImage', 'handle', $hImage)
	EndIf
	If $hToken Then
		DllCall('gdiplus.dll', 'none', 'GdiplusShutdown', 'ulong_ptr', $hToken)
	EndIf
	If $hSource Then
		_WinAPI_DeleteObject($hSource)
	EndIf
	If $Error Then Return SetError($Error, 0, 0)

	Return $Length
EndFunc   ;==>_WinAPI_CompressBitmapBits

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_CopyBitmap($hBitmap)
	$hBitmap = _WinAPI_CopyImage($hBitmap, 0, 0, 0, 0x2000) ;$LR_CREATEDIBSECTION
	Return SetError(@error, @extended, $hBitmap)
EndFunc   ;==>_WinAPI_CopyBitmap

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_CopyEnhMetaFile($hEmf, $sFile = '')
	Local $TypeOfFile = 'wstr'
	If Not StringStripWS($sFile, 3) Then
		$TypeOfFile = 'ptr'
		$sFile = 0
	EndIf

	Local $Ret = DllCall('gdi32.dll', 'handle', 'CopyEnhMetaFileW', 'handle', $hEmf, $TypeOfFile, $sFile)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_CopyEnhMetaFile

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_CopyImage($hImage, $iType = 0, $xDesired = 0, $yDesired = 0, $iFlags = 0)
	Local $Ret = DllCall('user32.dll', 'handle', 'CopyImage', 'handle', $hImage, 'uint', $iType, _
			'int', $xDesired, 'int', $yDesired, 'uint', $iFlags)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_CopyImage

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_CopyRect($tRECT)
	Local $tData = DllStructCreate($tagRECT)
	Local $Ret = DllCall('user32.dll', 'bool', 'CopyRect', 'struct*', $tData, 'struct*', $tRECT)
	If @error Or Not $Ret[0] Then SetError(@error + 10, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $tData
EndFunc   ;==>_WinAPI_CopyRect

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_Create32BitHBITMAP($hIcon, $fDib = 0, $fDelete = 0)
	Local $hBitmap = 0
	Local $DIB[2] = [0, 0]

	Local $hTemp = _WinAPI_Create32BitHICON($hIcon)
	If @error Then Return SetError(@error, @extended, 0)

	Local $iError = 0
	Do
		Local $tICONINFO = DllStructCreate($tagICONINFO)
		Local $Ret = DllCall('user32.dll', 'bool', 'GetIconInfo', 'handle', $hTemp, 'struct*', $tICONINFO)
		If @error Or Not $Ret[0] Then
			$iError = @error + 10
			ExitLoop
		EndIf
		For $i = 0 To 1
			$DIB[$i] = DllStructGetData($tICONINFO, $i + 4)
		Next
		Local $tBITMAP = DllStructCreate($tagBITMAP)
		If Not _WinAPI_GetObject($DIB[0], DllStructGetSize($tBITMAP), DllStructGetPtr($tBITMAP)) Then
			$iError = @error + 20
			ExitLoop
		EndIf
		If $fDib Then
			$hBitmap = _WinAPI_CreateDIB(DllStructGetData($tBITMAP, 'bmWidth'), DllStructGetData($tBITMAP, 'bmHeight'))
			Local $hDC = _WinAPI_CreateCompatibleDC(0)
			Local $hSv = _WinAPI_SelectObject($hDC, $hBitmap)
			_WinAPI_DrawIconEx($hDC, 0, 0, $hTemp)
			_WinAPI_SelectObject($hDC, $hSv)
			_WinAPI_DeleteDC($hDC)
		Else
			$hBitmap = $DIB[1]
			$DIB[1] = 0
		EndIf
	Until 1
	For $i = 0 To 1
		If $DIB[$i] Then
			_WinAPI_DeleteObject($DIB[$i])
		EndIf
	Next
	_WinAPI_DestroyIcon($hTemp)
	If $iError Then Return SetError($iError, 0, 0)
	If Not $hBitmap Then Return SetError(12, 0, 0)

	If $fDelete Then
		_WinAPI_DestroyIcon($hIcon)
	EndIf

	Return $hBitmap
EndFunc   ;==>_WinAPI_Create32BitHBITMAP

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_Create32BitHICON($hIcon, $fDelete = 0)
	Local $hBitmap[2], $hResult = 0
	Local $DIB[2][2] = [[0, 0],[0, 0]]

	Local $tICONINFO = DllStructCreate($tagICONINFO)
	Local $Ret = DllCall('user32.dll', 'bool', 'GetIconInfo', 'handle', $hIcon, 'struct*', $tICONINFO)
	If @error Then Return SetError(@error, @extended, 0)
	If Not $Ret[0] Then Return SetError(10, 0, 0)

	For $i = 0 To 1
		$hBitmap[$i] = DllStructGetData($tICONINFO, $i + 4)
	Next
	If _WinAPI_IsAlphaBitmap($hBitmap[1]) Then
		$DIB[0][0] = _WinAPI_CreateANDBitmap($hBitmap[1])
		If Not @error Then
			$hResult = _WinAPI_CreateIconIndirect($hBitmap[1], $DIB[0][0])
		EndIf
	Else
		Local $tSIZE = _WinAPI_GetBitmapDimension($hBitmap[1])
		Local $Size[2]
		For $i = 0 To 1
			$Size[$i] = DllStructGetData($tSIZE, $i + 1)
		Next
		Local $hSrcDC = _WinAPI_CreateCompatibleDC(0)
		Local $hDstDC = _WinAPI_CreateCompatibleDC(0)
		Local $hSrcSv, $hDstSv
		For $i = 0 To 1
			$DIB[$i][0] = _WinAPI_CreateDIB($Size[0], $Size[1])
			$DIB[$i][1] = $__Ext
			$hSrcSv = _WinAPI_SelectObject($hSrcDC, $hBitmap[$i])
			$hDstSv = _WinAPI_SelectObject($hDstDC, $DIB[$i][0])
			_WinAPI_BitBlt($hDstDC, 0, 0, $Size[0], $Size[1], $hSrcDC, 0, 0, 0x00C000CA)
			_WinAPI_SelectObject($hSrcDC, $hSrcSv)
			_WinAPI_SelectObject($hDstDC, $hDstSv)
		Next
		_WinAPI_DeleteDC($hSrcDC)
		_WinAPI_DeleteDC($hDstDC)
		$Ret = DllCall('user32.dll', 'lresult', 'CallWindowProc', 'ptr', __XORProc(), 'ptr', 0, _
				'uint', $Size[0] * $Size[1] * 4, 'wparam', $DIB[0][1], 'lparam', $DIB[1][1])
		If Not @error And $Ret[0] Then
			$hResult = _WinAPI_CreateIconIndirect($DIB[1][0], $hBitmap[0])
		EndIf
	EndIf
	For $i = 0 To 1
		_WinAPI_DeleteObject($hBitmap[$i])
		If $DIB[$i][0] Then
			_WinAPI_DeleteObject($DIB[$i][0])
		EndIf
	Next
	If Not $hResult Then Return SetError(11, 0, 0)

	If $fDelete Then
		_WinAPI_DestroyIcon($hIcon)
	EndIf

	Return $hResult
EndFunc   ;==>_WinAPI_Create32BitHICON

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_CreateANDBitmap($hBitmap)
	Local $Error = 0, $hDib = 0

	$hBitmap = _WinAPI_CopyBitmap($hBitmap)
	If Not $hBitmap Then Return SetError(@error + 20, @extended, 0)

	Do
		Local $tDIB[2]
		$tDIB[0] = DllStructCreate($tagDIBSECTION)
		If (Not _WinAPI_GetObject($hBitmap, DllStructGetSize($tDIB[0]), DllStructGetPtr($tDIB[0]))) _
				Or (DllStructGetData($tDIB[0], 'bmBitsPixel') <> 32) Or (DllStructGetData($tDIB[0], 'biCompression')) Then
			$Error = 10
			ExitLoop
		EndIf
		$tDIB[1] = DllStructCreate($tagBITMAP)
		$hDib = _WinAPI_CreateDIB(DllStructGetData($tDIB[0], 'bmWidth'), DllStructGetData($tDIB[0], 'bmHeight'), 1)
		If Not _WinAPI_GetObject($hDib, DllStructGetSize($tDIB[1]), DllStructGetPtr($tDIB[1])) Then
			$Error = 11
			ExitLoop
		EndIf
		Local $Ret = DllCall('user32.dll', 'lresult', 'CallWindowProc', 'ptr', __ANDProc(), 'ptr', 0, 'uint', 0, _
				'wparam', DllStructGetPtr($tDIB[0]), 'lparam', DllStructGetPtr($tDIB[1]))
		If @error Then
			$Error = @error
			ExitLoop
		EndIf
		If Not $Ret[0] Then
			$Error = 12
			ExitLoop
		EndIf
		$Error = 0
	Until 1
	_WinAPI_DeleteObject($hBitmap)
	If $Error Then
		If $hDib Then
			_WinAPI_DeleteObject($hDib)
		EndIf
		$hDib = 0
	EndIf

	Return SetError($Error, 0, $hDib)
EndFunc   ;==>_WinAPI_CreateANDBitmap

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_CreateBitmapIndirect(ByRef $tBITMAP)
	Local $Ret = DllCall('gdi32.dll', 'handle', 'CreateBitmapIndirect', 'struct*', $tBITMAP)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_CreateBitmapIndirect

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_CreateBrushIndirect($iStyle, $iRGB, $iHatch = 0)
	Local $tLOGBRUSH = DllStructCreate($tagLOGBRUSH)
	DllStructSetData($tLOGBRUSH, 1, $iStyle)
	DllStructSetData($tLOGBRUSH, 2, __RGB($iRGB))
	DllStructSetData($tLOGBRUSH, 3, $iHatch)

	Local $Ret = DllCall('gdi32.dll', 'handle', 'CreateBrushIndirect', 'struct*', $tLOGBRUSH)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_CreateBrushIndirect

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......:
; ===============================================================================================================================
Func _WinAPI_CreateColorAdjustment($iFlags = 0, $iIlluminant = 0, $iGammaR = 10000, $iGammaG = 10000, $iGammaB = 10000, $iBlack = 0, $iWhite = 10000, $iContrast = 0, $iBrightness = 0, $iColorfulness = 0, $iTint = 0)
	Local $tCA = DllStructCreate($tagCOLORADJUSTMENT)
	DllStructSetData($tCA, 1, DllStructGetSize($tCA))
	DllStructSetData($tCA, 2, $iFlags)
	DllStructSetData($tCA, 3, $iIlluminant)
	DllStructSetData($tCA, 4, $iGammaR)
	DllStructSetData($tCA, 5, $iGammaG)
	DllStructSetData($tCA, 6, $iGammaB)
	DllStructSetData($tCA, 7, $iBlack)
	DllStructSetData($tCA, 8, $iWhite)
	DllStructSetData($tCA, 9, $iContrast)
	DllStructSetData($tCA, 10, $iBrightness)
	DllStructSetData($tCA, 11, $iColorfulness)
	DllStructSetData($tCA, 12, $iTint)

	Return $tCA
EndFunc   ;==>_WinAPI_CreateColorAdjustment

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_CreateCompatibleBitmapEx($hDC, $iWidth, $iHeight, $iRGB)
	Local $hBrush = _WinAPI_CreateBrushIndirect(0, $iRGB)
	Local $Ret = DllCall('gdi32.dll', 'handle', 'CreateCompatibleDC', 'handle', $hDC)
	Local $hDestDC = $Ret[0]
	$Ret = DllCall('gdi32.dll', 'handle', 'CreateCompatibleBitmap', 'handle', $hDC, 'int', $iWidth, 'int', $iHeight)
	Local $hBmp = $Ret[0]
	$Ret = DllCall('gdi32.dll', 'handle', 'SelectObject', 'handle', $hDestDC, 'handle', $hBmp)
	Local $hDestSv = $Ret[0]
	Local $tRECT = _WinAPI_CreateRectEx(0, 0, $iWidth, $iHeight)
	$Ret = DllCall('user32.dll', 'int', 'FillRect', 'handle', $hDestDC, 'struct*', $tRECT, 'handle', $hBrush)
	If @error Or Not $Ret[0] Then
		$Ret = @error + 10
		_WinAPI_DeleteObject($hBmp)
	EndIf
	_WinAPI_DeleteObject($hBrush)
	DllCall('gdi32.dll', 'handle', 'SelectObject', 'handle', $hDestDC, 'handle', $hDestSv)
	DllCall('gdi32.dll', 'bool', 'DeleteDC', 'handle', $hDestDC)
	If $Ret Then Return SetError($Ret, 0, 0)

	Return $hBmp
EndFunc   ;==>_WinAPI_CreateCompatibleBitmapEx

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_CreateDIB($iWidth, $iHeight, $iBitsPerPel = 32, $tColorTable = 0, $iColorCount = 0)
	Local $RGBQ[2], $Colors
	Switch $iBitsPerPel
		Case 1
			$Colors = 2
		Case 4
			$Colors = 16
		Case 8
			$Colors = 256
		Case Else
			$Colors = 0
	EndSwitch
	If $Colors Then
		If Not IsDllStruct($tColorTable) Then
			Switch $iBitsPerPel
				Case 1
					$RGBQ[0] = 0
					$RGBQ[1] = 0xFFFFFF
					$tColorTable = _WinAPI_CreateDIBColorTable($RGBQ)
				Case Else

			EndSwitch
		Else
			If $Colors > $iColorCount Then
				$Colors = $iColorCount
			EndIf
			If (Not $Colors) Or ((4 * $Colors) > DllStructGetSize($tColorTable)) Then
				Return SetError(20, 0, 0)
			EndIf
		EndIf
		$RGBQ = ';dword aRGBQuad[' & $Colors & ']'
	Else
		$RGBQ = ''
	EndIf
	Local $tBITMAPINFO = DllStructCreate($tagBITMAPINFOHEADER & $RGBQ)

	DllStructSetData($tBITMAPINFO, 'biSize', 40)
	DllStructSetData($tBITMAPINFO, 'biWidth', $iWidth)
	DllStructSetData($tBITMAPINFO, 'biHeight', $iHeight)
	DllStructSetData($tBITMAPINFO, 'biPlanes', 1)
	DllStructSetData($tBITMAPINFO, 'biBitCount', $iBitsPerPel)
	DllStructSetData($tBITMAPINFO, 'biCompression', 0)
	DllStructSetData($tBITMAPINFO, 'biSizeImage', 0)
	DllStructSetData($tBITMAPINFO, 'biXPelsPerMeter', 0)
	DllStructSetData($tBITMAPINFO, 'biYPelsPerMeter', 0)
	DllStructSetData($tBITMAPINFO, 'biClrUsed', $Colors)
	DllStructSetData($tBITMAPINFO, 'biClrImportant', 0)
	If $Colors Then
		If IsDllStruct($tColorTable) Then
			_WinAPI_MoveMemory(DllStructGetPtr($tBITMAPINFO, 'aRGBQuad'), DllStructGetPtr($tColorTable), 4 * $Colors)
		Else
			_WinAPI_ZeroMemory(DllStructGetPtr($tBITMAPINFO, 'aRGBQuad'), 4 * $Colors)
		EndIf
	EndIf
	Local $hBitmap = _WinAPI_CreateDIBSection(0, $tBITMAPINFO, 0, $__Ext)
	If Not $hBitmap Then Return SetError(@error, @extended, 0)

	Return $hBitmap
EndFunc   ;==>_WinAPI_CreateDIB

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_CreateDIBColorTable(Const ByRef $aColorTable, $iStart = 0, $iEnd = -1)
	If __CheckErrorArrayBounds($aColorTable, $iStart, $iEnd) Then Return SetError(@error + 10, @extended, 0)

	Local $tColorTable = DllStructCreate('dword[' & ($iEnd - $iStart + 1) & ']')

	Local $Count = 1
	For $i = $iStart To $iEnd
		DllStructSetData($tColorTable, 1, _WinAPI_SwitchColor(__RGB($aColorTable[$i])), $Count)
		$Count += 1
	Next
	Return $tColorTable
EndFunc   ;==>_WinAPI_CreateDIBColorTable

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_CreateDIBitmap($hDC, ByRef $tBITMAPINFO, $iUsage, $pBits = 0)
	Local $Init = 0
	If $pBits Then
		$Init = 0x04
	EndIf

	Local $Ret = DllCall('gdi32.dll', 'handle', 'CreateDIBitmap', 'handle', $hDC, 'struct*', $tBITMAPINFO, 'dword', $Init, 'ptr', $pBits, _
			'struct*', $tBITMAPINFO, 'uint', $iUsage)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_CreateDIBitmap

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_CreateDIBSection($hDC, $tBITMAPINFO, $iUsage, ByRef $pBits, $hSection = 0, $iOffset = 0)
	$pBits = 0

	Local $Ret = DllCall('gdi32.dll', 'handle', 'CreateDIBSection', 'handle', $hDC, 'struct*', $tBITMAPINFO, 'uint', $iUsage, _
			'ptr*', 0, 'handle', $hSection, 'dword', $iOffset)
	If @error Or Not $Ret[0] Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	$pBits = $Ret[4]
	Return $Ret[0]
EndFunc   ;==>_WinAPI_CreateDIBSection

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_CreateEllipticRgn($tRECT)
	Local $Ret = DllCall('gdi32.dll', 'handle', 'CreateEllipticRgnIndirect', 'struct*', $tRECT)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_CreateEllipticRgn

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_CreateEmptyIcon($iWidth, $iHeight, $iBitsPerPel = 32)
	Local $hXOR = _WinAPI_CreateDIB($iWidth, $iHeight, $iBitsPerPel)
	Local $hAND = _WinAPI_CreateDIB($iWidth, $iHeight, 1)
	Local $hDC = _WinAPI_CreateCompatibleDC(0)
	Local $hSv = _WinAPI_SelectObject($hDC, $hAND)
	Local $hBrush = _WinAPI_CreateSolidBrush(0xFFFFFF)
	Local $tRECT = _WinAPI_CreateRect(0, 0, $iWidth, $iHeight)
	_WinAPI_FillRect($hDC, DllStructGetPtr($tRECT), $hBrush)
	_WinAPI_DeleteObject($hBrush)
	_WinAPI_SelectObject($hDC, $hSv)
	_WinAPI_DeleteDC($hDC)
	Local $hIcon = _WinAPI_CreateIconIndirect($hXOR, $hAND)
	Local $iError = @error
	If $hXOR Then
		_WinAPI_DeleteObject($hXOR)
	EndIf
	If $hAND Then
		_WinAPI_DeleteObject($hAND)
	EndIf
	If Not $hIcon Then Return SetError($iError + 10, 0, 0)

	Return $hIcon
EndFunc   ;==>_WinAPI_CreateEmptyIcon

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_CreateEnhMetaFile($hDC = 0, $tRECT = 0, $fPixels = 0, $sFile = '', $sDescription = '')
	Local $TypeOfFile = 'wstr'
	If Not StringStripWS($sFile, 3) Then
		$TypeOfFile = 'ptr'
		$sFile = 0
	EndIf

	Local $tData = 0, $aData = StringSplit($sDescription, '|', 2)
	If UBound($aData) < 2 Then
		ReDim $aData[2]
		$aData[1] = ''
	EndIf
	For $i = 0 To 1
		$aData[$i] = StringStripWS($aData[$i], 3)
	Next
	If ($aData[0]) Or ($aData[1]) Then
		$tData = _WinAPI_ArrayToStruct($aData)
	EndIf

	Local $Xp, $Yp, $Xm, $Ym, $hRef = 0
	If ($fPixels) And (IsDllStruct($tRECT)) Then
		If Not $hDC Then
			$hRef = _WinAPI_GetDC(0)
		EndIf
		$Xp = _WinAPI_GetDeviceCaps($hRef, 8)
		$Yp = _WinAPI_GetDeviceCaps($hRef, 10)
		$Xm = _WinAPI_GetDeviceCaps($hRef, 4)
		$Ym = _WinAPI_GetDeviceCaps($hRef, 6)
		If $hRef Then
			_WinAPI_ReleaseDC(0, $hRef)
		EndIf
		For $i = 1 To 3 Step 2
			DllStructSetData($tRECT, $i, Round(DllStructGetData($tRECT, $i) * $Xm / $Xp * 100))
		Next
		For $i = 2 To 4 Step 2
			DllStructSetData($tRECT, $i, Round(DllStructGetData($tRECT, $i) * $Ym / $Yp * 100))
		Next
	EndIf

	Local $Ret = DllCall('gdi32.dll', 'handle', 'CreateEnhMetaFileW', 'handle', $hDC, $TypeOfFile, $sFile, 'struct*', $tRECT, _
			'struct*', $tData)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_CreateEnhMetaFile

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_CreateFontEx($iHeight, $iWidth = 0, $iEscapement = 0, $iOrientation = 0, $iWeight = 400, $fItalic = 0, $fUnderline = 0, $fStrikeOut = 0, $iCharSet = 1, $iOutPrecision = 0, $iClipPrecision = 0, $iQuality = 0, $iPitchAndFamily = 0, $sFaceName = '', $iStyle = 0)
	Local $Ret = DllCall('gdi32.dll', 'handle', 'CreateFontW', 'int', $iHeight, 'int', $iWidth, 'int', $iEscapement, _
			'int', $iOrientation, 'int', $iWeight, 'dword', $fItalic, 'dword', $fUnderline, 'dword', $fStrikeOut, _
			'dword', $iCharSet, 'dword', $iOutPrecision, 'dword', $iClipPrecision, 'dword', $iQuality, _
			'dword', $iPitchAndFamily, 'wstr', _WinAPI_GetFontName($sFaceName, $iStyle, $iCharSet))
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_CreateFontEx

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_CreateIconIndirect($hBitmap, $hMask, $XHotspot = 0, $YHotspot = 0, $fIcon = 1)
	Local $tICONINFO = DllStructCreate($tagICONINFO)
	DllStructSetData($tICONINFO, 1, $fIcon)
	DllStructSetData($tICONINFO, 2, $XHotspot)
	DllStructSetData($tICONINFO, 3, $YHotspot)
	DllStructSetData($tICONINFO, 4, $hMask)
	DllStructSetData($tICONINFO, 5, $hBitmap)

	Local $Ret = DllCall('user32.dll', 'handle', 'CreateIconIndirect', 'struct*', $tICONINFO)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_CreateIconIndirect

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_CreateNullRgn()
	Local $Ret = DllCall('gdi32.dll', 'handle', 'CreateRectRgn', 'int', 0, 'int', 0, 'int', 0, 'int', 0)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_CreateNullRgn

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_CreatePolygonRgn(Const ByRef $aPoint, $iStart = 0, $iEnd = -1, $iMode = 1)
	If __CheckErrorArrayBounds($aPoint, $iStart, $iEnd, 2, 2) Then Return SetError(@error + 10, @extended, 0)

	Local $Struct = ''
	For $i = $iStart To $iEnd
		$Struct &= 'int[2];'
	Next
	Local $tData = DllStructCreate($Struct)

	Local $Count = 1
	For $i = $iStart To $iEnd
		For $j = 0 To 1
			DllStructSetData($tData, $Count, $aPoint[$i][$j], $j + 1)
		Next
		$Count += 1
	Next

	Local $Ret = DllCall('gdi32.dll', 'handle', 'CreatePolygonRgn', 'struct*', $tData, 'int', $Count - 1, 'int', $iMode)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_CreatePolygonRgn

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_CreateRectRgnIndirect($tRECT)
	Local $Ret = DllCall('gdi32.dll', 'handle', 'CreateRectRgnIndirect', 'struct*', $tRECT)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_CreateRectRgnIndirect

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......:
; ===============================================================================================================================
Func _WinAPI_CreateTransform($nM11 = 1, $nM12 = 0, $nM21 = 0, $nM22 = 1, $nDx = 0, $nDy = 0)
	Local $tXFORM = DllStructCreate($tagXFORM)
	DllStructSetData($tXFORM, 1, $nM11)
	DllStructSetData($tXFORM, 2, $nM12)
	DllStructSetData($tXFORM, 3, $nM21)
	DllStructSetData($tXFORM, 4, $nM22)
	DllStructSetData($tXFORM, 5, $nDx)
	DllStructSetData($tXFORM, 6, $nDy)

	Return $tXFORM
EndFunc   ;==>_WinAPI_CreateTransform

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_DeleteEnhMetaFile($hEmf)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'DeleteEnhMetaFile', 'ptr', $hEmf)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_DeleteEnhMetaFile

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_DPtoLP($hDC, ByRef $tPOINT, $iCount = 1)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'DPtoLP', 'handle', $hDC, 'struct*', $tPOINT, 'int', $iCount)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_DPtoLP

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_DrawAnimatedRects($hWnd, $tRectFrom, $tRectTo)
	Local $Ret = DllCall('user32.dll', 'bool', 'DrawAnimatedRects', 'hwnd', $hWnd, 'int', 3, 'struct*', $tRectFrom, _
			'struct*', $tRectTo)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_DrawAnimatedRects

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_DrawBitmap($hDC, $iX, $iY, $hBitmap, $iRop = 0x00CC0020)
	Local $tObj = DllStructCreate($tagBITMAP)
	Local $Ret = DllCall('gdi32.dll', 'int', 'GetObject', 'handle', $hBitmap, 'int', DllStructGetSize($tObj), 'struct*', $tObj)
	If @error Or Not $Ret[0] Then Return SetError(@error + 20, @extended, 0)

	$Ret = DllCall('user32.dll', 'handle', 'GetDC', 'hwnd', 0)
	Local $_hDC = $Ret[0]
	$Ret = DllCall('gdi32.dll', 'handle', 'CreateCompatibleDC', 'handle', $_hDC)
	Local $hSrcDC = $Ret[0]
	$Ret = DllCall('gdi32.dll', 'handle', 'SelectObject', 'handle', $hSrcDC, 'handle', $hBitmap)
	Local $hSrcSv = $Ret[0]
	$Ret = DllCall('gdi32.dll', 'int', 'BitBlt', 'hwnd', $hDC, 'int', $iX, 'int', $iY, 'int', DllStructGetData($tObj, 'bmWidth'), 'int', DllStructGetData($tObj, 'bmHeight'), 'hwnd', $hSrcDC, 'int', 0, 'int', 0, 'int', $iRop)
	If @error Or Not $Ret[0] Then
		$Ret = @error + 1
	EndIf
	DllCall('user32.dll', 'int', 'ReleaseDC', 'hwnd', 0, 'handle', $_hDC)
	DllCall('gdi32.dll', 'handle', 'SelectObject', 'handle', $hSrcDC, 'handle', $hSrcSv)
	DllCall('gdi32.dll', 'bool', 'DeleteDC', 'handle', $hSrcDC)
	If Not $Ret Then Return SetError(10, 0, 0)

	Return 1
EndFunc   ;==>_WinAPI_DrawBitmap

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_DrawFocusRect($hDC, $tRECT)
	Local $Ret = DllCall('user32.dll', 'bool', 'DrawFocusRect', 'handle', $hDC, 'struct*', $tRECT)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_DrawFocusRect

; #FUNCTION# ====================================================================================================================
; Author.........: Rover
; Modified.......: Yashied, Jpm
; ===============================================================================================================================
Func _WinAPI_DrawShadowText($hDC, $sText, $rgbText, $rgbShadow, $iXOffset = 0, $iYOffset = 0, $tRECT = 0, $iFlags = 0)
	Local $Ret

	If Not IsDllStruct($tRECT) Then
		$tRECT = DllStructCreate($tagRECT)
		$Ret = DllCall('user32.dll', 'bool', 'GetClientRect', 'hwnd', _WinAPI_WindowFromDC($hDC), 'struct*', $tRECT)
		If @error Then Return SetError(@error + 10, @extended, 0)
		If Not $Ret[0] Then Return SetError(10, 0, 0)
	EndIf
	$Ret = DllCall('comctl32.dll', 'int', 'DrawShadowText', 'handle', $hDC, 'wstr', $sText, 'uint', -1, 'struct*', $tRECT, _
			'dword', $iFlags, 'int', __RGB($rgbText), 'int', __RGB($rgbShadow), 'int', $iXOffset, 'int', $iYOffset)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_DrawShadowText

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_DwmDefWindowProc($hWnd, $iMsg, $wParam, $lParam)
	Local $Ret = DllCall('dwmapi.dll', 'bool', 'DwmDefWindowProc', 'hwnd', $hWnd, 'uint', $iMsg, 'wparam', $wParam, 'lparam', $lParam, 'lresult*', 0)
	If @error Or Not $Ret[0] Then Return SetError(@error + 10, @extended, 0)

	Return $Ret[5]
EndFunc   ;==>_WinAPI_DwmDefWindowProc

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_DwmEnableBlurBehindWindow($hWnd, $fEnable = 1, $fTransition = 0, $hRgn = 0)
	Local $tBLURBEHIND = DllStructCreate('dword;bool;handle;bool')
	Local $Flags = 0

	If $hRgn Then
		$Flags += 2
		DllStructSetData($tBLURBEHIND, 3, $hRgn)
	EndIf

	DllStructSetData($tBLURBEHIND, 1, BitOR($Flags, 0x05))
	DllStructSetData($tBLURBEHIND, 2, $fEnable)
	DllStructSetData($tBLURBEHIND, 4, $fTransition)

	Local $Ret = DllCall('dwmapi.dll', 'long', 'DwmEnableBlurBehindWindow', 'hwnd', $hWnd, 'struct*', $tBLURBEHIND)
	If @error Then Return SetError(@error, @extended, 0)
	If $Ret[0] Then Return SetError(10, $Ret[0], 0)

	Return 1
EndFunc   ;==>_WinAPI_DwmEnableBlurBehindWindow

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_DwmEnableComposition($fEnable)
	If $fEnable Then $fEnable = 1

	Local $Ret = DllCall('dwmapi.dll', 'long', 'DwmEnableComposition', 'uint', $fEnable)
	If @error Then Return SetError(@error, @extended, 0)
	If $Ret[0] Then Return SetError(10, $Ret[0], 0)

	Return 1
EndFunc   ;==>_WinAPI_DwmEnableComposition

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_DwmExtendFrameIntoClientArea($hWnd, $tMARGINS = 0)
	If Not IsDllStruct($tMARGINS) Then
		$tMARGINS = _WinAPI_CreateMargins(-1, -1, -1, -1)
	EndIf

	Local $Ret = DllCall('dwmapi.dll', 'long', 'DwmExtendFrameIntoClientArea', 'hwnd', $hWnd, 'ptr', DllStructGetPtr($tMARGINS))
	If @error Then Return SetError(@error, @extended, 0)
	If $Ret[0] Then Return SetError(10, $Ret[0], 0)

	Return 1
EndFunc   ;==>_WinAPI_DwmExtendFrameIntoClientArea

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_DwmGetColorizationColor()
	Local $Ret = DllCall('dwmapi.dll', 'long', 'DwmGetColorizationColor', 'dword*', 0, 'bool*', 0)
	If @error Then Return SetError(@error, @extended, 0)
	If $Ret[0] Then Return SetError(10, $Ret[0], 0)

	Return SetExtended($Ret[2], $Ret[1])
EndFunc   ;==>_WinAPI_DwmGetColorizationColor

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_DwmGetColorizationParameters()
	Local $tDWMCP = DllStructCreate($tagDWM_COLORIZATION_PARAMETERS)
	Local $Ret = DllCall('dwmapi.dll', 'uint', 127, 'ptr', DllStructGetPtr($tDWMCP))
	If @error Then Return SetError(@error, @extended, 0)
	If $Ret[0] Then Return SetError(10, $Ret[0], 0)

	Return $tDWMCP
EndFunc   ;==>_WinAPI_DwmGetColorizationParameters

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_DwmGetWindowAttribute($hWnd, $iAttribute)
	Local $Struct
	Switch $iAttribute
		Case 5, 9
			$Struct = $tagRECT
		Case 1
			$Struct = 'uint'
		Case Else
			Return SetError(11, 0, 0)
	EndSwitch

	Local $tData = DllStructCreate($Struct)
	Local $Ret = DllCall('dwmapi.dll', 'long', 'DwmGetWindowAttribute', 'hwnd', $hWnd, 'dword', $iAttribute, _
			'struct*', $tData, 'dword', DllStructGetSize($tData))
	If @error Then Return SetError(@error, @extended, 0)
	If $Ret[0] Then Return SetError(10, $Ret[0], 0)

	Switch $iAttribute
		Case 1
			Return DllStructGetData($tData, 1)
		Case Else
			Return $tData
	EndSwitch
EndFunc   ;==>_WinAPI_DwmGetWindowAttribute

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_DwmInvalidateIconicBitmaps($hWnd)
	Local $Ret = DllCall('dwmapi.dll', 'long', 'DwmInvalidateIconicBitmaps', 'hwnd', $hWnd)
	If @error Then Return SetError(@error, @extended, 0)
	If $Ret[0] Then Return SetError(10, $Ret[0], 0)

	Return 1
EndFunc   ;==>_WinAPI_DwmInvalidateIconicBitmaps

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_DwmIsCompositionEnabled()
	Local $Ret = DllCall('dwmapi.dll', 'long', 'DwmIsCompositionEnabled', 'bool*', 0)
	If @error Then Return SetError(@error, @extended, 0)
	If $Ret[0] Then Return SetError(10, $Ret[0], 0)

	Return $Ret[1]
EndFunc   ;==>_WinAPI_DwmIsCompositionEnabled

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_DwmQueryThumbnailSourceSize($hThumbnail)
	Local $tSIZE = DllStructCreate($tagSIZE)
	Local $Ret = DllCall('dwmapi.dll', 'long', 'DwmQueryThumbnailSourceSize', 'handle', $hThumbnail, 'struct*', $tSIZE)
	If @error Then Return SetError(@error, @extended, 0)
	If $Ret[0] Then Return SetError(10, $Ret[0], 0)

	Return $tSIZE
EndFunc   ;==>_WinAPI_DwmQueryThumbnailSourceSize

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_DwmRegisterThumbnail($hDestination, $hSource)
	Local $Ret = DllCall('dwmapi.dll', 'long', 'DwmRegisterThumbnail', 'hwnd', $hDestination, 'hwnd', $hSource, 'handle*', 0)
	If @error Then Return SetError(@error, @extended, 0)
	If $Ret[0] Then Return SetError(10, $Ret[0], 0)

	Return $Ret[3]
EndFunc   ;==>_WinAPI_DwmRegisterThumbnail

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......:
; ===============================================================================================================================
Func _WinAPI_DwmSetColorizationParameters($tDWMCP)
	Local $Ret = DllCall('dwmapi.dll', 'uint', 131, 'ptr', DllStructGetPtr($tDWMCP), 'uint', 0)
	If @error Then Return SetError(@error, @extended, 0)
	If $Ret[0] Then Return SetError(10, $Ret[0], 0)

	Return 1
EndFunc   ;==>_WinAPI_DwmSetColorizationParameters

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_DwmSetIconicLivePreviewBitmap($hWnd, $hBitmap, $fFrame = 0, $tClient = 0)
	Local $Flags
	If $fFrame Then
		$Flags = 0x00000001
	Else
		$Flags = 0
	EndIf

	Local $Ret = DllCall('dwmapi.dll', 'uint', 'DwmSetIconicLivePreviewBitmap', 'hwnd', $hWnd, 'handle', $hBitmap, _
			'struct*', $tClient, 'dword', $Flags)
	If @error Then Return SetError(@error, @extended, 0)
	If $Ret[0] Then Return SetError(10, $Ret[0], 0)

	Return 1
EndFunc   ;==>_WinAPI_DwmSetIconicLivePreviewBitmap

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_DwmSetIconicThumbnail($hWnd, $hBitmap, $fFrame = 0)
	Local $Flags
	If $fFrame Then
		$Flags = 0x00000001
	Else
		$Flags = 0
	EndIf

	Local $Ret = DllCall('dwmapi.dll', 'long', 'DwmSetIconicThumbnail', 'hwnd', $hWnd, 'handle', $hBitmap, 'dword', $Flags)
	If @error Then Return SetError(@error, @extended, 0)
	If $Ret[0] Then Return SetError(10, $Ret[0], 0)

	Return 1
EndFunc   ;==>_WinAPI_DwmSetIconicThumbnail

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_DwmSetWindowAttribute($hWnd, $iAttribute, $iData)
	Switch $iAttribute
		Case 2, 3, 4, 6, 7, 8, 10, 11, 12

		Case Else
			Return SetError(1, 0, 0)
	EndSwitch

	Local $Ret = DllCall('dwmapi.dll', 'long', 'DwmSetWindowAttribute', 'hwnd', $hWnd, 'dword', $iAttribute, _
			'dword*', $iData, 'dword', 4)
	If @error Then Return SetError(@error, @extended, 0)
	If $Ret[0] Then Return SetError(10, $Ret[0], 0)

	Return 1
EndFunc   ;==>_WinAPI_DwmSetWindowAttribute

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_DwmUnregisterThumbnail($hThumbnail)
	Local $Ret = DllCall('dwmapi.dll', 'long', 'DwmUnregisterThumbnail', 'handle', $hThumbnail)
	If @error Then Return SetError(@error, @extended, 0)
	If $Ret[0] Then Return SetError(10, $Ret[0], 0)

	Return 1
EndFunc   ;==>_WinAPI_DwmUnregisterThumbnail

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_DwmUpdateThumbnailProperties($hThumbnail, $fVisible = 1, $fClientAreaOnly = 0, $iOpacity = 255, $tRectDest = 0, $tRectSrc = 0)
	Local Const $tagDWM_THUMBNAIL_PROPERTIES = 'struct;dword dwFlags;int rcDestination[4];int rcSource[4];byte opacity;bool opacity;bool fSourceClientAreaOnly;endstruct'
	Local $tTHUMBNAILPROPERTIES = DllStructCreate($tagDWM_THUMBNAIL_PROPERTIES)
	Local $tSIZE, $Flags = 0
	If Not IsDllStruct($tRectDest) Then
		$tSIZE = _WinAPI_DwmQueryThumbnailSourceSize($hThumbnail)
		If @error Then
			Return SetError(@error + 10, @extended, 0)
		EndIf
		$tRectDest = _WinAPI_CreateRectEx(0, 0, DllStructGetData($tSIZE, 1), DllStructGetData($tSIZE, 2))
	EndIf
	For $i = 1 To 4
		DllStructSetData($tTHUMBNAILPROPERTIES, 2, DllStructGetData($tRectDest, $i), $i)
	Next
	If IsDllStruct($tRectSrc) Then
		$Flags += 2
		For $i = 1 To 4
			DllStructSetData($tTHUMBNAILPROPERTIES, 3, DllStructGetData($tRectSrc, $i), $i)
		Next
	EndIf

	DllStructSetData($tTHUMBNAILPROPERTIES, 1, BitOR($Flags, 0x1D))
	DllStructSetData($tTHUMBNAILPROPERTIES, 4, $iOpacity)
	DllStructSetData($tTHUMBNAILPROPERTIES, 5, $fVisible)
	DllStructSetData($tTHUMBNAILPROPERTIES, 6, $fClientAreaOnly)

	Local $Ret = DllCall('dwmapi.dll', 'long', 'DwmUpdateThumbnailProperties', 'handle', $hThumbnail, _
			'struct*', $tTHUMBNAILPROPERTIES)
	If @error Then Return SetError(@error, @extended, 0)
	If $Ret[0] Then Return SetError(10, $Ret[0], 0)

	Return 1
EndFunc   ;==>_WinAPI_DwmUpdateThumbnailProperties

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_Ellipse($hDC, $tRECT)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'Ellipse', 'handle', $hDC, 'int', DllStructGetData($tRECT, 1), _
			'int', DllStructGetData($tRECT, 2), 'int', DllStructGetData($tRECT, 3), 'int', DllStructGetData($tRECT, 4))
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_Ellipse

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_EndPaint($hWnd, ByRef $tPAINTSTRUCT)
	Local $Ret = DllCall('user32.dll', 'bool', 'EndPaint', 'hwnd', $hWnd, 'struct*', $tPAINTSTRUCT)
	If @error Then Return SetError(@error, @extended, False)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_EndPaint

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_EndPath($hDC)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'EndPath', 'handle', $hDC)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_EndPath

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_EnumDisplayMonitors($hDC = 0, $tRECT = 0)
	Local $hEnumProc = DllCallbackRegister('__EnumDisplayMonitorsProc', 'bool', 'handle;handle;ptr;lparam')

	Dim $__Enum[101][2] = [[0]]
	Local $Ret = DllCall('user32.dll', 'bool', 'EnumDisplayMonitors', 'handle', $hDC, 'struct*', $tRECT, _
			'ptr', DllCallbackGetPtr($hEnumProc), 'lparam', 0)
	If @error Or Not $Ret[0] Or Not $__Enum[0][0] Then
		$__Enum = @error + 10
	EndIf
	DllCallbackFree($hEnumProc)
	If $__Enum Then Return SetError($__Enum, 0, 0)

	__Inc($__Enum, -1)
	Return $__Enum
EndFunc   ;==>_WinAPI_EnumDisplayMonitors

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_EnumDisplaySettings($sDevice, $iMode)
	Local $TypeOfDevice = 'wstr'
	If Not StringStripWS($sDevice, 3) Then
		$TypeOfDevice = 'ptr'
		$sDevice = 0
	EndIf

	Local $tDEVMODE = DllStructCreate($tagDEVMODE_DISPLAY)
	DllStructSetData($tDEVMODE, 'Size', DllStructGetSize($tDEVMODE))
	DllStructSetData($tDEVMODE, 'DriverExtra', 0)

	Local $Ret = DllCall('user32.dll', 'bool', 'EnumDisplaySettingsW', $TypeOfDevice, $sDevice, 'dword', $iMode, _
			'struct*', $tDEVMODE)
	If @error Or Not $Ret[0] Then Return SetError(@error + 10, @extended, 0)

	Local $Result[5]
	$Result[0] = DllStructGetData($tDEVMODE, 'PelsWidth')
	$Result[1] = DllStructGetData($tDEVMODE, 'PelsHeight')
	$Result[2] = DllStructGetData($tDEVMODE, 'BitsPerPel')
	$Result[3] = DllStructGetData($tDEVMODE, 'DisplayFrequency')
	$Result[4] = DllStructGetData($tDEVMODE, 'DisplayFlags')
	Return $Result
EndFunc   ;==>_WinAPI_EnumDisplaySettings

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_EnumFontFamilies($hDC = 0, $sFaceName = '', $iCharSet = 1, $iFontType = 0x07, $sPattern = '', $fExclude = 0)
	Local $tLOGFONT = DllStructCreate($tagLOGFONT)
	Local $tPattern = DllStructCreate('uint;uint;ptr;wchar[' & (StringLen($sPattern) + 1) & ']')

	DllStructSetData($tPattern, 1, $iFontType)
	If Not $sPattern Then
		DllStructSetData($tPattern, 2, 0)
		DllStructSetData($tPattern, 3, 0)
	Else
		DllStructSetData($tPattern, 2, $fExclude)
		DllStructSetData($tPattern, 3, DllStructGetPtr($tPattern, 4))
		DllStructSetData($tPattern, 4, $sPattern)
	EndIf
	DllStructSetData($tLOGFONT, 9, $iCharSet)
	DllStructSetData($tLOGFONT, 13, 0)
	DllStructSetData($tLOGFONT, 14, StringLeft($sFaceName, 31))
	Local $hCDC
	If Not $hDC Then
		$hCDC = _WinAPI_CreateCompatibleDC(0)
	Else
		$hCDC = $hDC
	EndIf
	Dim $__Enum[101][8] = [[0]]
	Local $hEnumProc = DllCallbackRegister('__EnumFontFamiliesProc', 'int', 'ptr;ptr;dword;PTR')
	Local $Ret = DllCall('gdi32.dll', 'int', 'EnumFontFamiliesExW', 'handle', $hCDC, 'struct*', $tLOGFONT, _
			'ptr', DllCallbackGetPtr($hEnumProc), 'PTR', DllStructGetPtr($tPattern), 'dword', 0)
	If @error Or Not $Ret[0] Or Not $__Enum[0][0] Then
		$__Enum = @error + 10
	EndIf
	DllCallbackFree($hEnumProc)
	If Not $hDC Then
		_WinAPI_DeleteDC($hCDC)
	EndIf
	If $__Enum Then Return SetError($__Enum, 0, 0)

	__Inc($__Enum, -1)
	Return $__Enum
EndFunc   ;==>_WinAPI_EnumFontFamilies

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_EqualRect($tRECT1, $tRECT2)
	Local $Ret = DllCall('user32.dll', 'bool', 'EqualRect', 'struct*', $tRECT1, 'struct*', $tRECT2)
	If @error Then Return SetError(@error, @extended, False)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_EqualRect

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_EqualRgn($hRgn1, $hRgn2)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'EqualRgn', 'handle', $hRgn1, 'handle', $hRgn2)
	If @error Then Return SetError(@error, @extended, False)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_EqualRgn

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_ExcludeClipRect($hDC, $tRECT)
	Local $Ret = DllCall('gdi32.dll', 'int', 'ExcludeClipRect', 'handle', $hDC, 'int', DllStructGetData($tRECT, 1), _
			'int', DllStructGetData($tRECT, 2), 'int', DllStructGetData($tRECT, 3), 'int', DllStructGetData($tRECT, 4))
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_ExcludeClipRect

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_ExtCreatePen($iPenStyle, $iWidth, $iBrushStyle, $iRGB, $iHatch = 0, $aUserStyle = 0, $iStart = 0, $iEnd = -1)
	Local $Count = 0, $tStyle = 0

	If BitAND($iPenStyle, 0xFF) = 7 Then
		If __CheckErrorArrayBounds($aUserStyle, $iStart, $iEnd) Then Return SetError(@error + 10, @extended, 0)
		$tStyle = DllStructCreate('dword[' & ($iEnd - $iStart + 1) & ']')

		For $i = $iStart To $iEnd
			DllStructSetData($tStyle, 1, $aUserStyle[$i], $Count + 1)
			$Count += 1
		Next
	EndIf

	Local $tLOGBRUSH = DllStructCreate($tagLOGBRUSH)
	DllStructSetData($tLOGBRUSH, 1, $iBrushStyle)
	DllStructSetData($tLOGBRUSH, 2, __RGB($iRGB))
	DllStructSetData($tLOGBRUSH, 3, $iHatch)

	Local $Ret = DllCall('gdi32.dll', 'handle', 'ExtCreatePen', 'dword', $iPenStyle, 'dword', $iWidth, 'struct*', $tLOGBRUSH, _
			'dword', $Count, 'struct*', $tStyle)
	If @error Then Return SetError(@error, @extended, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_ExtCreatePen

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_ExtCreateRegion($tRGNDATA, $tXFORM = 0)
	Local $Ret = DllCall('gdi32.dll', 'handle', 'ExtCreateRegion', 'struct*', $tXFORM, 'dword', DllStructGetSize($tRGNDATA), _
			'struct*', $tRGNDATA)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_ExtCreateRegion

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_ExtFloodFill($hDC, $iX, $iY, $iRGB, $iType = 0)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'ExtFloodFill', 'handle', $hDC, 'int', $iX, 'int', $iY, 'dword', __RGB($iRGB), _
			'uint', $iType)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_ExtFloodFill

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_ExtSelectClipRgn($hDC, $hRgn, $iMode = 5)
	Local $Ret = DllCall('gdi32.dll', 'int', 'ExtSelectClipRgn', 'handle', $hDC, 'handle', $hRgn, 'int', $iMode)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_ExtSelectClipRgn

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_FillPath($hDC)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'FillPath', 'handle', $hDC)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_FillPath

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_FillRgn($hDC, $hRgn, $hBrush)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'FillRgn', 'handle', $hDC, 'handle', $hRgn, 'handle', $hBrush)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_FillRgn

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_FlattenPath($hDC)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'FlattenPath', 'handle', $hDC)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_FlattenPath

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_FrameRgn($hDC, $hRgn, $hBrush, $iWidth, $iHeight)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'FrameRgn', 'handle', $hDC, 'handle', $hRgn, 'handle', $hBrush, 'int', $iWidth, 'int', $iHeight)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_FrameRgn

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_GdiComment($hDC, $pBuffer, $iSize)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'GdiComment', 'handle', $hDC, 'uint', $iSize, 'ptr', $pBuffer)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_GdiComment

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_GetArcDirection($hDC)
	Local $Ret = DllCall('gdi32.dll', 'int', 'GetArcDirection', 'handle', $hDC)
	If @error Then Return SetError(@error, @extended, 0)
	If ($Ret[0] < 1) Or ($Ret[0] > 2) Then Return SetError(10, $Ret[0], 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetArcDirection

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_GetBitmapBits($hBitmap, $iSize, $pBits)
	Local $Ret = DllCall('gdi32.dll', 'long', 'GetBitmapBits', 'ptr', $hBitmap, 'long', $iSize, 'ptr', $pBits)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetBitmapBits

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_GetBitmapDimensionEx($hBitmap)
	Local $tSIZE = DllStructCreate($tagSIZE)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'GetBitmapDimensionEx', 'handle', $hBitmap, 'struct*', $tSIZE)
	If @error Or Not $Ret[0] Then Return SetError(@error + 10, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $tSIZE
EndFunc   ;==>_WinAPI_GetBitmapDimensionEx

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_GetBkColor($hDC)
	Local $Ret = DllCall('gdi32.dll', 'dword', 'GetBkColor', 'handle', $hDC)
	If @error Or ($Ret[0] = -1) Then Return SetError(@error, @extended, -1)
	; If $Ret[0] = -1 Then Return SetError(1000, 0, 0)

	Return __RGB($Ret[0])
EndFunc   ;==>_WinAPI_GetBkColor

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_GetBoundsRect($hDC, $iFlags = 0)
	Local $tRECT = DllStructCreate($tagRECT)
	Local $Ret = DllCall('gdi32.dll', 'uint', 'GetBoundsRect', 'handle', $hDC, 'struct*', $tRECT, 'uint', $iFlags)
	If @error Or Not $Ret[0] Then Return SetError(@error + 10, @extended, 0)

	Return SetExtended($Ret[0], $tRECT)
EndFunc   ;==>_WinAPI_GetBoundsRect

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_GetBrushOrg($hDC)
	Local $tPOINT = DllStructCreate($tagPOINT)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'GetBrushOrgEx', 'handle', $hDC, 'struct*', $tPOINT)
	If @error Or Not $Ret[0] Then Return SetError(@error + 10, @extended, 0)

	Return $tPOINT
EndFunc   ;==>_WinAPI_GetBrushOrg

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......:
; ===============================================================================================================================
Func _WinAPI_GetBValue($iRGB)
	Return BitShift(BitAND(__RGB($iRGB), 0xFF0000), 16)
EndFunc   ;==>_WinAPI_GetBValue

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_GetClipBox($hDC, ByRef $tRECT)
	$tRECT = DllStructCreate($tagRECT)
	Local $Ret = DllCall('gdi32.dll', 'int', 'GetClipBox', 'handle', $hDC, 'struct*', $tRECT)
	If @error Or Not $Ret[0] Then
		; If Not $Ret[0] Then Return SetError(1000, 0, 0)
		$tRECT = 0
		Return SetError(@error, @extended, 0)
	EndIf

	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetClipBox

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: JPM
; ===============================================================================================================================
Func _WinAPI_GetClipRgn($hDC)
	Local $hRgn = _WinAPI_CreateRectRgn(0, 0, 0, 0)
	Local $iError = 0
	Local $Ret = DllCall('gdi32.dll', 'int', 'GetClipRgn', 'handle', $hDC, 'handle', $hRgn)
	If @error Or ($Ret[0] = -1) Then $iError = @error + 10
	If $iError Or Not $Ret[0] Then
		_WinAPI_DeleteObject($hRgn)
		$hRgn = 0
	EndIf
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)
	Return SetError($iError, 0, $hRgn)
EndFunc   ;==>_WinAPI_GetClipRgn

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_GetColorAdjustment($hDC)
	Local $tAdjustment = DllStructCreate($tagCOLORADJUSTMENT)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'GetColorAdjustment', 'handle', $hDC, 'struct*', $tAdjustment)
	If @error Or Not $Ret[0] Then Return SetError(@error + 10, @extended, 0)

	Return $tAdjustment
EndFunc   ;==>_WinAPI_GetColorAdjustment

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_GetCurrentObject($hDC, $iType)
	Local $Ret = DllCall('gdi32.dll', 'handle', 'GetCurrentObject', 'handle', $hDC, 'uint', $iType)
	If @error Or Not $Ret[0] Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetCurrentObject

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_GetCurrentPosition($hDC)
	Local $tPOINT = DllStructCreate($tagPOINT)
	Local $Ret = DllCall('gdi32.dll', 'int', 'GetCurrentPositionEx', 'handle', $hDC, 'struct*', $tPOINT)
	If @error Or Not $Ret[0] Then Return SetError(@error + 10, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $tPOINT
EndFunc   ;==>_WinAPI_GetCurrentPosition

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_GetDCEx($hWnd, $hRgn, $iFlags)
	Local $Ret = DllCall('user32.dll', 'handle', 'GetDCEx', 'hwnd', $hWnd, 'handle', $hRgn, 'dword', $iFlags)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetDCEx

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_GetDeviceGammaRamp($hDC, ByRef $aRamp)
	$aRamp = 0

	Local $tData = DllStructCreate('word[256];word[256];word[256]')
	Local $Ret = DllCall('gdi32.dll', 'bool', 'GetDeviceGammaRamp', 'handle', $hDC, 'struct*', $tData)
	If @error Or Not $Ret[0] Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Dim $aRamp[256][3]
	For $i = 0 To 2
		For $j = 0 To 255
			$aRamp[$j][$i] = DllStructGetData($tData, $i + 1, $j + 1)
		Next
	Next
	Return 1
EndFunc   ;==>_WinAPI_GetDeviceGammaRamp

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_GetDIBColorTable($hBitmap)
	Local $hDC = _WinAPI_CreateCompatibleDC(0)
	Local $hSv = _WinAPI_SelectObject($hDC, $hBitmap)
	Local $tPeak = DllStructCreate('dword[256]')
	Local $Ret = DllCall('gdi32.dll', 'uint', 'GetDIBColorTable', 'handle', $hDC, 'uint', 0, 'uint', 256, 'struct*', $tPeak)
	If @error Or Not $Ret[0] Then $Ret = @error + 10

	_WinAPI_SelectObject($hDC, $hSv)
	_WinAPI_DeleteDC($hDC)
	If $Ret Then Return SetError($Ret, 0, 0)

	Local $tData = DllStructCreate('dword[' & $Ret[0] & ']')
	If @error Then Return SetError(@error + 20, @extended, 0)

	_WinAPI_MoveMemory(DllStructGetPtr($tData), $Ret[4], 4 * $Ret[0])
	; Return SetError(@error, @extended, 0) ; cannot really occur
	; EndIf

	Return SetExtended($Ret[0], $tData)
EndFunc   ;==>_WinAPI_GetDIBColorTable

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_GetEnhMetaFile($sFile)
	Local $Ret = DllCall('gdi32.dll', 'handle', 'GetEnhMetaFileW', 'wstr', $sFile)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetEnhMetaFile

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_GetEnhMetaFileBits($hEmf, ByRef $pBuffer)
	Local $Ret = DllCall('gdi32.dll', 'uint', 'GetEnhMetaFileBits', 'handle', $hEmf, 'uint', 0, 'ptr', 0)
	If @error Or Not $Ret[0] Then Return SetError(@error + 50, @extended, 0)
	$pBuffer = __HeapReAlloc($pBuffer, $Ret[0], 1)
	If @error Then Return SetError(@error, @extended, 0)

	$Ret = DllCall('gdi32.dll', 'uint', 'GetEnhMetaFileBits', 'handle', $hEmf, 'uint', $Ret[0], 'ptr', $pBuffer)
	If Not $Ret[0] Then Return SetError(60, 0, 0)

	Return $Ret[2]
EndFunc   ;==>_WinAPI_GetEnhMetaFileBits

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_GetEnhMetaFileDescription($hEmf)
	Local $tData = DllStructCreate('wchar[4096]')
	Local $Ret = DllCall('gdi32.dll', 'uint', 'GetEnhMetaFileDescriptionW', 'handle', $hEmf, 'uint', 4096, 'struct*', $tData)
	If @error Or ($Ret[0] = 4294967295) Then Return SetError(@error + 20, $Ret[0], 0) ; GDI_ERROR
	If Not $Ret[0] Then Return 0

	Local $aData = _WinAPI_StructToArray($tData)
	If @error Then Return SetError(@error, @extended, 0)

	Local $Result[2]
	For $i = 0 To 1
		If $aData[0] > $i Then
			$Result[$i] = $aData[$i + 1]
		Else
			$Result[$i] = ''
		EndIf
	Next
	Return $Result
EndFunc   ;==>_WinAPI_GetEnhMetaFileDescription

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_GetEnhMetaFileDimension($hEmf)
	Local $tENHMETAHEADER = _WinAPI_GetEnhMetaFileHeader($hEmf)
	If @error Then Return SetError(@error, @extended, 0)

	Local $tSIZE = DllStructCreate($tagSIZE)
	DllStructSetData($tSIZE, 1, Round((DllStructGetData($tENHMETAHEADER, 'rcFrame', 3) - DllStructGetData($tENHMETAHEADER, 'rcFrame', 1)) * DllStructGetData($tENHMETAHEADER, 'Device', 1) / DllStructGetData($tENHMETAHEADER, 'Millimeters', 1) / 100))
	DllStructSetData($tSIZE, 2, Round((DllStructGetData($tENHMETAHEADER, 'rcFrame', 4) - DllStructGetData($tENHMETAHEADER, 'rcFrame', 2)) * DllStructGetData($tENHMETAHEADER, 'Device', 2) / DllStructGetData($tENHMETAHEADER, 'Millimeters', 2) / 100))

	Return $tSIZE
EndFunc   ;==>_WinAPI_GetEnhMetaFileDimension

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_GetEnhMetaFileHeader($hEmf)
	Local $tENHMETAHEADER = DllStructCreate($tagENHMETAHEADER)
	Local $Ret = DllCall('gdi32.dll', 'uint', 'GetEnhMetaFileHeader', 'handle', $hEmf, _
			'uint', DllStructGetSize($tENHMETAHEADER), 'struct*', $tENHMETAHEADER)
	If @error Or Not $Ret[0] Then Return SetError(@error + 10, @extended, 0)

	Return SetExtended($Ret[0], $tENHMETAHEADER)
EndFunc   ;==>_WinAPI_GetEnhMetaFileHeader

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_GetFontName($sFaceName, $iStyle = 0, $iCharSet = 1)
	If Not $sFaceName Then Return SetError(1, 0, '')

	Local $Flags = 0
	If BitAND($iStyle, 0x01) Then
		$Flags += 0x00000020
	EndIf
	If BitAND($iStyle, 0x02) Then
		$Flags += 0x00000001
	EndIf
	If Not $Flags Then
		$Flags = 0x00000040
	EndIf
	Local $tLOGFONT = DllStructCreate($tagLOGFONT)
	DllStructSetData($tLOGFONT, 9, $iCharSet)
	DllStructSetData($tLOGFONT, 13, 0)
	DllStructSetData($tLOGFONT, 14, StringLeft($sFaceName, 31))
	Local $tFN = DllStructCreate('dword;wchar[64]')
	DllStructSetData($tFN, 1, $Flags)
	DllStructSetData($tFN, 2, '')
	Local $hDC = _WinAPI_CreateCompatibleDC(0)
	Local $hEnumProc = DllCallbackRegister('__EnumFontStylesProc', 'int', 'ptr;ptr;dword;lparam')
	Local $Ret = DllCall('gdi32.dll', 'int', 'EnumFontFamiliesExW', 'handle', $hDC, 'struct*', $tLOGFONT, _
			'ptr', DllCallbackGetPtr($hEnumProc), 'struct*', $tFN, 'dword', 0)
	If Not @error And Not $Ret[0] Then
		$Ret = DllStructGetData($tFN, 2)
	Else
		$Ret = ''
	EndIf
	DllCallbackFree($hEnumProc)
	_WinAPI_DeleteDC($hDC)
	If Not $Ret Then Return SetError(2, 0, '')

	Return $Ret
EndFunc   ;==>_WinAPI_GetFontName

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_GetFontResourceInfo($sFont, $fForce = 0)
	If $fForce Then
		If Not _WinAPI_AddFontResourceEx($sFont, 0x20) Then Return SetError(@error + 20, @extended, '')
	EndIf

	Local $Ret = DllCall('gdi32.dll', 'bool', 'GetFontResourceInfoW', 'wstr', $sFont, 'dword*', 4096, 'wstr', '', 'dword', 0x01)
	If @error Or Not $Ret[0] Then $Ret = @error + 10

	If $fForce Then
		_WinAPI_RemoveFontResourceEx($sFont, 0x20)
	EndIf
	If $Ret Then Return SetError($Ret, 0, '')

	Return $Ret[3]
EndFunc   ;==>_WinAPI_GetFontResourceInfo

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_GetGlyphOutline($hDC, $sChar, $iFormat, ByRef $pBuffer, $tMAT2 = 0)
	Local $tGM = DllStructCreate($tagGLYPHMETRICS)
	Local $Ret, $Length = 0

	If Not IsDllStruct($tMAT2) Then
		$tMAT2 = DllStructCreate('short[8]')
		DllStructSetData($tMAT2, 1, 1, 2)
		DllStructSetData($tMAT2, 1, 1, 8)
	EndIf
	If $iFormat Then
		$Ret = DllCall('gdi32.dll', 'dword', 'GetGlyphOutlineW', 'handle', $hDC, 'uint', AscW($sChar), 'uint', $iFormat, _
				'struct*', $tGM, 'dword', 0, 'ptr', 0, 'struct*', $tMAT2)
		If @error Or ($Ret[0] = 4294967295) Then Return SetError(@error + 10, @extended, 0)
		$Length = $Ret[0]
		$pBuffer = __HeapReAlloc($pBuffer, $Length, 1)
		If @error Then Return SetError(@error + 20, @extended, 0)
	EndIf
	$Ret = DllCall('gdi32.dll', 'dword', 'GetGlyphOutlineW', 'handle', $hDC, 'uint', AscW($sChar), 'uint', $iFormat, _
			'struct*', $tGM, 'dword', $Length, 'ptr', $pBuffer, 'struct*', $tMAT2)
	If @error Then Return SetError(@error, @extended, 0)
	If $Ret[0] = 4294967295 Then Return SetError(10, -1, 0)

	Return SetExtended($Length, $tGM)
EndFunc   ;==>_WinAPI_GetGlyphOutline

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_GetGraphicsMode($hDC)
	Local $Ret = DllCall('gdi32.dll', 'int', 'GetGraphicsMode', 'handle', $hDC)
	If @error Or Not $Ret[0] Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetGraphicsMode

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......:
; ===============================================================================================================================
Func _WinAPI_GetGValue($iRGB)
	Return BitShift(BitAND(__RGB($iRGB), 0x00FF00), 8)
EndFunc   ;==>_WinAPI_GetGValue

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_GetIconDimension($hIcon)
	Local $tICONINFO = DllStructCreate($tagICONINFO)
	Local $Ret = DllCall('user32.dll', 'bool', 'GetIconInfo', 'handle', $hIcon, 'struct*', $tICONINFO)
	If @error Or Not $Ret[0] Then Return SetError(@error + 10, @extended, 0)

	Local $tSIZE = _WinAPI_GetBitmapDimension(DllStructGetData($tICONINFO, 5))
	For $i = 4 To 5
		_WinAPI_DeleteObject(DllStructGetData($tICONINFO, $i))
	Next
	If Not IsDllStruct($tSIZE) Then Return SetError(20, 0, 0)

	Return $tSIZE
EndFunc   ;==>_WinAPI_GetIconDimension

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_GetMapMode($hDC)
	Local $Ret = DllCall('gdi32.dll', 'int', 'GetMapMode', 'handle', $hDC)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetMapMode

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_GetObjectType($hObject)
	Local $Ret = DllCall('gdi32.dll', 'dword', 'GetObjectType', 'handle', $hObject)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetObjectType

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_GetOutlineTextMetrics($hDC)
	Local $Ret = DllCall('gdi32.dll', 'uint', 'GetOutlineTextMetricsW', 'handle', $hDC, 'uint', 0, 'ptr', 0)
	If @error Or Not $Ret[0] Then Return SetError(@error + 10, @extended, 0)
	Local $tData = DllStructCreate('byte[' & $Ret[0] & ']')
	Local $tOLTM = DllStructCreate($tagOUTLINETEXTMETRIC, DllStructGetPtr($tData))
	$Ret = DllCall('gdi32.dll', 'uint', 'GetOutlineTextMetricsW', 'handle', $hDC, 'uint', $Ret[0], 'struct*', $tData)
	If Not $Ret[0] Then Return SetError(20, 0, 0)

	Return $tOLTM
EndFunc   ;==>_WinAPI_GetOutlineTextMetrics

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_GetPixel($hDC, $iX, $iY)
	Local $Ret = DllCall('gdi32.dll', 'dword', 'GetPixel', 'handle', $hDC, 'int', $iX, 'int', $iY)
	If @error Or ($Ret[0] = 4294967295) Then Return SetError(@error, @extended, -1)
	; If $Ret[0] = 4294967295 Then Return SetError(1000, 0, -1)

	Return __RGB($Ret[0])
EndFunc   ;==>_WinAPI_GetPixel

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_GetPolyFillMode($hDC)
	Local $Ret = DllCall('gdi32.dll', 'int', 'GetPolyFillMode', 'handle', $hDC)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetPolyFillMode

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_GetPosFromRect($tRECT)
	Local $Result[4]
	For $i = 0 To 3
		$Result[$i] = DllStructGetData($tRECT, $i + 1)
		If @error Then Return SetError(@error, @extended, 0)
	Next

	For $i = 2 To 3
		$Result[$i] -= $Result[$i - 2]
	Next
	Return $Result
EndFunc   ;==>_WinAPI_GetPosFromRect

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_GetRegionData($hRgn, ByRef $tRGNDATA)
	Local $Ret = DllCall('gdi32.dll', 'dword', 'GetRegionData', 'handle', $hRgn, 'dword', 0, 'ptr', 0)
	If @error Or Not $Ret[0] Then
		$tRGNDATA = 0
		; If Not $Ret[0] Then Return SetError(1000, 0, 0)
		Return SetError(@error, @extended, False)
	EndIf
	$tRGNDATA = DllStructCreate($tagRGNDATAHEADER)
	Local $iRectSize = $Ret[0] - DllStructGetSize($tRGNDATA)
	If $iRectSize > 0 Then $tRGNDATA = DllStructCreate($tagRGNDATAHEADER & ';byte[' & $iRectSize & ']')
	$Ret = DllCall('gdi32.dll', 'dword', 'GetRegionData', 'handle', $hRgn, 'dword', $Ret[0], 'struct*', $tRGNDATA)
	If Not $Ret[0] Then $tRGNDATA = 0

	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetRegionData

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_GetRgnBox($hRgn, ByRef $tRECT)
	$tRECT = DllStructCreate($tagRECT)
	Local $Ret = DllCall('gdi32.dll', 'int', 'GetRgnBox', 'handle', $hRgn, 'struct*', $tRECT)
	If @error Or Not $Ret[0] Then
		$tRECT = 0
		; If Not $Ret[0] Then Return SetError(1000, 0, 0)
		Return SetError(@error, @extended, 0)
	EndIf

	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetRgnBox

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_GetROP2($hDC)
	Local $Ret = DllCall('gdi32.dll', 'int', 'GetROP2', 'handle', $hDC)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetROP2

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......:
; ===============================================================================================================================
Func _WinAPI_GetRValue($iRGB)
	Return BitAND(__RGB($iRGB), 0x0000FF)
EndFunc   ;==>_WinAPI_GetRValue

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_GetStretchBltMode($hDC)
	Local $Ret = DllCall('gdi32.dll', 'int', 'GetStretchBltMode', 'handle', $hDC)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetStretchBltMode

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_GetTabbedTextExtent($hDC, $sText, $aTab = 0, $iStart = 0, $iEnd = -1)
	Local $Tab, $Count
	If Not IsArray($aTab) Then
		If $aTab Then
			$Tab = $aTab
			Dim $aTab[1] = [$Tab]
			$iStart = 0
			$iEnd = 0
			$Count = 1
		Else
			$Count = 0
		EndIf
	Else
		$Count = 1
	EndIf

	If $Count Then
		If __CheckErrorArrayBounds($aTab, $iStart, $iEnd) Then Return SetError(@error + 10, @extended, 0)

		$Count = $iEnd - $iStart + 1
		Local $tTab = DllStructCreate('uint[' & $Count & ']')
		$Tab = 1
		For $i = $iStart To $iEnd
			DllStructSetData($tTab, 1, $aTab[$i], $Tab)
			$Tab += 1
		Next
	EndIf
	Local $Ret = DllCall('user32.dll', 'dword', 'GetTabbedTextExtentW', 'handle', $hDC, 'wstr', $sText, 'int', StringLen($sText), 'int', $Count, 'ptr', DllStructGetPtr($tTab))
	If @error Or Not $Ret[0] Then Return SetError(@error + 20, @extended, 0)

	Return _WinAPI_CreateSize(_WinAPI_LoWord($Ret[0]), _WinAPI_HiWord($Ret[0]))
EndFunc   ;==>_WinAPI_GetTabbedTextExtent

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_GetTextAlign($hDC)
	Local $Ret = DllCall('gdi32.dll', 'uint', 'GetTextAlign', 'handle', $hDC)
	If @error Or ($Ret[0] = 4294967295) Then Return SetError(@error, @extended, -1)
	; If $Ret[0] = 4294967295 Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetTextAlign

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_GetTextCharacterExtra($hDC)
	Local $Ret = DllCall('gdi32.dll', 'int', 'GetTextCharacterExtra', 'handle', $hDC)
	If @error Or ($Ret[0] = 0x8000000) Then Return SetError(@error, @extended, -1)
	; If $Ret[0] = 0x8000000 Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetTextCharacterExtra

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_GetTextColor($hDC)
	Local $Ret = DllCall('gdi32.dll', 'dword', 'GetTextColor', 'handle', $hDC)
	If @error Or ($Ret[0] = 4294967295) Then Return SetError(@error, @extended, -1)
	; If $Ret[0] = 4294967295 Then Return SetError(1000, 0, -1)

	Return __RGB($Ret[0])
EndFunc   ;==>_WinAPI_GetTextColor

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_GetTextFace($hDC)
	Local $Ret = DllCall('gdi32.dll', 'int', 'GetTextFaceW', 'handle', $hDC, 'int', 2048, 'wstr', '')
	If @error Or Not $Ret[0] Then Return SetError(@error + 10, @extended, '')

	Return $Ret[3]
EndFunc   ;==>_WinAPI_GetTextFace

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......:
; ===============================================================================================================================
Func _WinAPI_GetUDFColorMode()
	Return Number($__iRGBMode)
EndFunc   ;==>_WinAPI_GetUDFColorMode

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_GetUpdateRect($hWnd, $fErase = 1)
	Local $tRECT = DllStructCreate($tagRECT)
	Local $Ret = DllCall('user32.dll', 'bool', 'GetUpdateRect', 'hwnd', $hWnd, 'struct*', $tRECT, 'bool', $fErase)
	If @error Or Not $Ret[0] Then Return SetError(@error + 10, @extended, 0)

	Return $tRECT
EndFunc   ;==>_WinAPI_GetUpdateRect

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_GetUpdateRgn($hWnd, $hRgn, $fErase = 1)
	Local $Ret = DllCall('user32.dll', 'int', 'GetUpdateRgn', 'hwnd', $hWnd, 'handle', $hRgn, 'bool', $fErase)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetUpdateRgn

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_GetWindowExt($hDC)
	Local $tSIZE = DllStructCreate($tagSIZE)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'GetWindowExtEx', 'handle', $hDC, 'struct*', $tSIZE)
	If @error Or Not $Ret[0] Then Return SetError(@error + 10, @extended, 0)

	Return $tSIZE
EndFunc   ;==>_WinAPI_GetWindowExt

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_GetWindowOrg($hDC)
	Local $tPOINT = DllStructCreate($tagPOINT)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'GetWindowOrgEx', 'handle', $hDC, 'struct*', $tPOINT)
	If @error Or Not $Ret[0] Then Return SetError(@error + 10, @extended, 0)

	Return $tPOINT
EndFunc   ;==>_WinAPI_GetWindowOrg

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_GetWindowRgnBox($hWnd, ByRef $tRECT)
	$tRECT = DllStructCreate($tagRECT)
	Local $Ret = DllCall('gdi32.dll', 'int', 'GetWindowRgnBox', 'hwnd', $hWnd, 'struct*', $tRECT)
	If @error Then Return SetError(@error, @extended, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_GetWindowRgnBox

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_GetWorldTransform($hDC)
	Local $tXFORM = DllStructCreate($tagXFORM)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'GetWorldTransform', 'handle', $hDC, 'struct*', $tXFORM)
	If @error Or Not $Ret[0] Then Return SetError(@error + 10, @extended, 0)

	Return $tXFORM
EndFunc   ;==>_WinAPI_GetWorldTransform

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_GradientFill($hDC, Const ByRef $aVertex, $iStart = 0, $iEnd = -1, $fRotate = 0)
	If __CheckErrorArrayBounds($aVertex, $iStart, $iEnd, 2) Then Return SetError(@error + 10, @extended, 0)
	If UBound($aVertex, 2) < 3 Then Return SetError(13, 0, 0)

	Local $Point = $iEnd - $iStart + 1
	If $Point > 3 Then
		$iEnd = $iStart + 2
		$Point = 3
	EndIf
	Local $Mode
	Switch $Point
		Case 2
			$Mode = Number(Not $fRotate)
		Case 3
			$Mode = 2
		Case Else
			Return SetError(15, 0, 0)
	EndSwitch
	Local $Struct = ''
	For $i = $iStart To $iEnd
		$Struct &= 'ushort[8];'
	Next
	Local $tVertex = DllStructCreate($Struct)

	Local $Count = 1
	Local $tGradient = DllStructCreate('ulong[' & $Point & ']')
	For $i = $iStart To $iEnd
		DllStructSetData($tGradient, 1, $Count - 1, $Count)
		DllStructSetData($tVertex, $Count, _WinAPI_LoWord($aVertex[$i][0]), 1)
		DllStructSetData($tVertex, $Count, _WinAPI_HiWord($aVertex[$i][0]), 2)
		DllStructSetData($tVertex, $Count, _WinAPI_LoWord($aVertex[$i][1]), 3)
		DllStructSetData($tVertex, $Count, _WinAPI_HiWord($aVertex[$i][1]), 4)
		DllStructSetData($tVertex, $Count, BitShift(_WinAPI_GetRValue($aVertex[$i][2]), -8), 5)
		DllStructSetData($tVertex, $Count, BitShift(_WinAPI_GetGValue($aVertex[$i][2]), -8), 6)
		DllStructSetData($tVertex, $Count, BitShift(_WinAPI_GetBValue($aVertex[$i][2]), -8), 7)
		DllStructSetData($tVertex, $Count, 0, 8)
		$Count += 1
	Next

	Local $Ret = DllCall('gdi32.dll', 'bool', 'GdiGradientFill', 'handle', $hDC, 'struct*', $tVertex, 'ulong', $Point, _
			'struct*', $tGradient, 'ulong', 1, 'ulong', $Mode)
	If @error Then Return SetError(@error, @extended, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_GradientFill

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_InflateRect(ByRef $tRECT, $DX, $DY)
	Local $Ret = DllCall('user32.dll', 'bool', 'InflateRect', 'struct*', $tRECT, 'int', $DX, 'int', $DY)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_InflateRect

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_IntersectClipRect($hDC, $tRECT)
	Local $Ret = DllCall('gdi32.dll', 'int', 'IntersectClipRect', 'handle', $hDC, 'int', DllStructGetData($tRECT, 1), _
			'int', DllStructGetData($tRECT, 2), 'int', DllStructGetData($tRECT, 3), _
			'int', DllStructGetData($tRECT, 4))
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)
	Return $Ret[0]
EndFunc   ;==>_WinAPI_IntersectClipRect

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_IntersectRect($tRECT1, $tRECT2)
	Local $tRECT = DllStructCreate($tagRECT)
	Local $Ret = DllCall('user32.dll', 'bool', 'IntersectRect', 'struct*', $tRECT, 'struct*', $tRECT1, 'struct*', $tRECT2)
	If @error Or Not $Ret[0] Then Return SetError(@error + 10, @extended, 0)

	Return $tRECT
EndFunc   ;==>_WinAPI_IntersectRect

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_InvalidateRgn($hWnd, $hRgn = 0, $fErase = 1)
	Local $Ret = DllCall('user32.dll', 'bool', 'InvalidateRgn', 'hwnd', $hWnd, 'handle', $hRgn, 'bool', $fErase)
	If @error Then Return SetError(@error, @extended, False)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_InvalidateRgn

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_InvertANDBitmap($hBitmap, $fDelete = 0)
	Local $tBITMAP = DllStructCreate($tagBITMAP)
	If Not _WinAPI_GetObject($hBitmap, DllStructGetSize($tBITMAP), DllStructGetPtr($tBITMAP)) Or (DllStructGetData($tBITMAP, 'bmBitsPixel') <> 1) Then
		Return SetError(@error + 10, @extended, 0)
	EndIf
	Local $hResult = _WinAPI_CreateDIB(DllStructGetData($tBITMAP, 'bmWidth'), DllStructGetData($tBITMAP, 'bmHeight'), 1)
	If Not $hResult Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Local $hSrcDC = _WinAPI_CreateCompatibleDC(0)
	Local $hSrcSv = _WinAPI_SelectObject($hSrcDC, $hBitmap)
	Local $hDstDC = _WinAPI_CreateCompatibleDC(0)
	Local $hDstSv = _WinAPI_SelectObject($hDstDC, $hResult)
	_WinAPI_BitBlt($hDstDC, 0, 0, DllStructGetData($tBITMAP, 'bmWidth'), DllStructGetData($tBITMAP, 'bmHeight'), $hSrcDC, 0, 0, 0x00330008)
	_WinAPI_SelectObject($hSrcDC, $hSrcSv)
	_WinAPI_DeleteDC($hSrcDC)
	_WinAPI_SelectObject($hDstDC, $hDstSv)
	_WinAPI_DeleteDC($hDstDC)
	If $fDelete Then
		_WinAPI_DeleteObject($hBitmap)
	EndIf
	Return $hResult
EndFunc   ;==>_WinAPI_InvertANDBitmap

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: JPM
; ===============================================================================================================================
Func _WinAPI_InvertColor($iColor)
	If $iColor = -1 Then Return 0
	Return 0xFFFFFF - BitAND($iColor, 0xFFFFFF)
EndFunc   ;==>_WinAPI_InvertColor

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_InvertRect($hDC, ByRef $tRECT)
	Local $Ret = DllCall('user32.dll', 'bool', 'InvertRect', 'handle', $hDC, 'struct*', $tRECT)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_InvertRect

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_InvertRgn($hDC, $hRgn)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'InvertRgn', 'handle', $hDC, 'handle', $hRgn)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_InvertRgn

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_IsAlphaBitmap($hBitmap)
	$hBitmap = _WinAPI_CopyBitmap($hBitmap)
	If Not $hBitmap Then Return SetError(@error + 20, @extended, 0)

	Local $Ret, $Error = 0
	Do
		Local $tDIB = DllStructCreate($tagDIBSECTION)
		If (Not _WinAPI_GetObject($hBitmap, DllStructGetSize($tDIB), DllStructGetPtr($tDIB))) Or (DllStructGetData($tDIB, 'bmBitsPixel') <> 32) Or (DllStructGetData($tDIB, 'biCompression')) Then
			$Error = 1
			ExitLoop
		EndIf
		$Ret = DllCall('user32.dll', 'int', 'CallWindowProc', 'ptr', __AlphaProc(), 'ptr', 0, 'uint', 0, 'struct*', $tDIB, 'ptr', 0)
		If @error Or ($Ret[0] = -1) Then
			$Error = @error + 10
			ExitLoop
		EndIf
	Until 1
	_WinAPI_DeleteObject($hBitmap)
	If $Error Then Return SetError($Error, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_IsAlphaBitmap

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_IsRectEmpty(ByRef $tRECT)
	Local $Ret = DllCall('user32.dll', 'bool', 'IsRectEmpty', 'struct*', $tRECT)
	If @error Then Return SetError(@error, @extended, False)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_IsRectEmpty

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_LineDDA($X1, $Y1, $X2, $Y2, $pLineProc, $pData = 0)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'LineDDA', 'int', $X1, 'int', $Y1, 'int', $X2, 'int', $Y2, 'ptr', $pLineProc, _
			'lparam', $pData)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_LineDDA

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_LockWindowUpdate($hWnd)
	Local $Ret = DllCall('user32.dll', 'bool', 'LockWindowUpdate', 'hwnd', $hWnd)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_LockWindowUpdate

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_LPtoDP($hDC, ByRef $tPOINT, $iCount = 1)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'LPtoDP', 'handle', $hDC, 'struct*', $tPOINT, 'int', $iCount)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_LPtoDP

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_MaskBlt($hDestDC, $iXDest, $iYDest, $iWidth, $iHeight, $hSrcDC, $iXSrc, $iYSrc, $hMask, $iXMask, $iYMask, $iRop)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'MaskBlt', 'handle', $hDestDC, 'int', $iXDest, 'int', $iYDest, _
			'int', $iWidth, 'int', $iHeight, 'hwnd', $hSrcDC, 'int', $iXSrc, 'int', $iYSrc, 'handle', $hMask, _
			'int', $iXMask, 'int', $iYMask, 'dword', $iRop)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_MaskBlt

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_ModifyWorldTransform($hDC, ByRef $tXFORM, $iMode)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'ModifyWorldTransform', 'handle', $hDC, 'struct*', $tXFORM, 'dword', $iMode)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_ModifyWorldTransform

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: JPM
; ===============================================================================================================================
Func _WinAPI_MonitorFromPoint(ByRef $tPOINT, $iFlag = 1)
	If DllStructGetSize($tPOINT) <> 8 Then Return SetError(@error + 10, @extended, 0)

	Local $Ret = DllCall('user32.dll', 'handle', 'MonitorFromPoint', 'struct', $tPOINT, 'dword', $iFlag)
	If @error Then Return SetError(@error, @extended, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_MonitorFromPoint

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_MonitorFromRect(ByRef $tRECT, $iFlag = 1)
	Local $Ret = DllCall('user32.dll', 'ptr', 'MonitorFromRect', 'struct*', $tRECT, 'dword', $iFlag)
	If @error Then Return SetError(@error, @extended, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_MonitorFromRect

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_MonitorFromWindow($hWnd, $iFlag = 1)
	Local $Ret = DllCall('user32.dll', 'handle', 'MonitorFromWindow', 'hwnd', $hWnd, 'dword', $iFlag)
	If @error Then Return SetError(@error, @extended, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_MonitorFromWindow

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_MoveToEx($hDC, $iX, $iY)
	Local $tPOINT = DllStructCreate($tagPOINT)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'MoveToEx', 'handle', $hDC, 'int', $iX, 'int', $iY, 'struct*', $tPOINT)
	If @error Or Not $Ret[0] Then Return SetError(@error + 10, @extended, 0)

	Return $tPOINT
EndFunc   ;==>_WinAPI_MoveToEx

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_OffsetClipRgn($hDC, $iXOffset, $iYOffset)
	Local $Ret = DllCall('gdi32.dll', 'int', 'OffsetClipRgn', 'handle', $hDC, 'int', $iXOffset, 'int', $iYOffset)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_OffsetClipRgn

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_OffsetPoints(ByRef $aPoint, $iXOffset, $iYOffset, $iStart = 0, $iEnd = -1)
	If __CheckErrorArrayBounds($aPoint, $iStart, $iEnd, 2) Then Return SetError(@error + 10, @extended, 0)
	If UBound($aPoint, 2) < 2 Then Return SetError(13, 0, 0)

	For $i = $iStart To $iEnd
		$aPoint[$i][0] += $iXOffset
		$aPoint[$i][1] += $iYOffset
	Next
	Return 1
EndFunc   ;==>_WinAPI_OffsetPoints

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_OffsetRect(ByRef $tRECT, $DX, $DY)
	Local $Ret = DllCall('user32.dll', 'bool', 'OffsetRect', 'struct*', $tRECT, 'int', $DX, 'int', $DY)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_OffsetRect

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_OffsetRgn($hRgn, $iXOffset, $iYOffset)
	Local $Ret = DllCall('gdi32.dll', 'int', 'OffsetRgn', 'handle', $hRgn, 'int', $iXOffset, 'int', $iYOffset)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_OffsetRgn

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_OffsetWindowOrg($hDC, $iXOffset, $iYOffset)
	$__Ext = DllStructCreate($tagPOINT)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'OffsetWindowOrgEx', 'handle', $hDC, 'int', $iXOffset, 'int', $iYOffset, _
			'struct*', $__Ext)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_OffsetWindowOrg

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_PaintDesktop($hDC)
	Local $Ret = DllCall('user32.dll', 'bool', 'PaintDesktop', 'handle', $hDC)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_PaintDesktop

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_PaintRgn($hDC, $hRgn)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'PaintRgn', 'handle', $hDC, 'handle', $hRgn)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_PaintRgn

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_PatBlt($hDC, $iX, $iY, $iWidth, $iHeight, $iRop)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'PatBlt', 'handle', $hDC, 'int', $iX, 'int', $iY, 'int', $iWidth, 'int', $iHeight, _
			'dword', $iRop)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_PatBlt

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_PathToRegion($hDC)
	Local $Ret = DllCall('gdi32.dll', 'handle', 'PathToRegion', 'handle', $hDC)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_PathToRegion

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_PlayEnhMetaFile($hDC, $hEmf, ByRef $tRECT)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'PlayEnhMetaFile', 'handle', $hDC, 'handle', $hEmf, 'struct*', $tRECT)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_PlayEnhMetaFile

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_PlgBlt($hDestDC, Const ByRef $aPoint, $hSrcDC, $iXSrc, $iYSrc, $iWidth, $iHeight, $hMask = 0, $iXMask = 0, $iYMask = 0)
	If (UBound($aPoint) < 3) Or (UBound($aPoint, 2) < 2) Then Return SetError(12, 0, False)

	Local $tPoints = DllStructCreate('long[2];long[2];long[2]')
	For $i = 0 To 2
		For $j = 0 To 1
			DllStructSetData($tPoints, $i + 1, $aPoint[$i][$j], $j + 1)
		Next
	Next

	Local $Ret = DllCall('gdi32.dll', 'bool', 'PlgBlt', 'handle', $hDestDC, 'struct*', $tPoints, 'handle', $hSrcDC, _
			'int', $iXSrc, 'int', $iYSrc, 'int', $iWidth, 'int', $iHeight, 'ptr', $hMask, _
			'int', $iXMask, 'int', $iYMask)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_PlgBlt

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_PolyBezier($hDC, Const ByRef $aPoint, $iStart = 0, $iEnd = -1)
	If __CheckErrorArrayBounds($aPoint, $iStart, $iEnd, 2, 2) Then Return SetError(@error + 10, @extended, False)

	Local $Point = 1 + 3 * Floor(($iEnd - $iStart) / 3)
	If $Point < 1 Then Return SetError(15, 0, False)

	$iEnd = $iStart + $Point - 1
	Local $Struct = ''
	For $i = $iStart To $iEnd
		$Struct &= 'long[2];'
	Next
	Local $tPOINT = DllStructCreate($Struct)

	Local $Count = 0
	For $i = $iStart To $iEnd
		$Count += 1
		For $j = 0 To 1
			DllStructSetData($tPOINT, $Count, $aPoint[$i][$j], $j + 1)
		Next
	Next

	Local $Ret = DllCall('gdi32.dll', 'bool', 'PolyBezier', 'handle', $hDC, 'struct*', $tPOINT, 'dword', $Point)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_PolyBezier

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_PolyBezierTo($hDC, Const ByRef $aPoint, $iStart = 0, $iEnd = -1)
	If __CheckErrorArrayBounds($aPoint, $iStart, $iEnd, 2, 2) Then Return SetError(@error + 10, @extended, False)

	Local $Point = 3 * Floor(($iEnd - $iStart + 1) / 3)
	If $Point < 3 Then Return SetError(15, 0, False)

	$iEnd = $iStart + $Point - 1
	Local $Struct = ''
	For $i = $iStart To $iEnd
		$Struct &= 'long[2];'
	Next
	Local $tPOINT = DllStructCreate($Struct)

	Local $Count = 0
	For $i = $iStart To $iEnd
		$Count += 1
		For $j = 0 To 1
			DllStructSetData($tPOINT, $Count, $aPoint[$i][$j], $j + 1)
		Next
	Next

	Local $Ret = DllCall('gdi32.dll', 'bool', 'PolyBezierTo', 'handle', $hDC, 'struct*', $tPOINT, 'dword', $Point)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_PolyBezierTo

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_PolyDraw($hDC, Const ByRef $aPoint, $iStart = 0, $iEnd = -1)
	If __CheckErrorArrayBounds($aPoint, $iStart, $iEnd, 2) Then Return SetError(@error + 10, @extended, 0)
	If UBound($aPoint, 2) < 3 Then Return SetError(13, 0, False)

	Local $Point = $iEnd - $iStart + 1
	Local $Struct = ''
	For $i = $iStart To $iEnd
		$Struct &= 'long[2];'
	Next
	Local $tPOINT = DllStructCreate($Struct)
	Local $tTypes = DllStructCreate('byte[' & $Point & ']')
	Local $Count = 0
	For $i = $iStart To $iEnd
		$Count += 1
		For $j = 0 To 1
			DllStructSetData($tPOINT, $Count, $aPoint[$i][$j], $j + 1)
		Next
		DllStructSetData($tTypes, 1, $aPoint[$i][2], $Count)
	Next

	Local $Ret = DllCall('gdi32.dll', 'bool', 'PolyDraw', 'handle', $hDC, 'struct*', $tPOINT, 'struct*', $tTypes, 'dword', $Point)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_PolyDraw

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_Polygon($hDC, Const ByRef $aPoint, $iStart = 0, $iEnd = -1)
	If __CheckErrorArrayBounds($aPoint, $iStart, $iEnd, 2, 2) Then Return SetError(@error + 10, @extended, False)

	Local $Struct = ''
	For $i = $iStart To $iEnd
		$Struct &= 'int[2];'
	Next
	Local $tData = DllStructCreate($Struct)
	Local $Count = 1
	For $i = $iStart To $iEnd
		For $j = 0 To 1
			DllStructSetData($tData, $Count, $aPoint[$i][$j], $j + 1)
		Next
		$Count += 1
	Next

	Local $Ret = DllCall('gdi32.dll', 'bool', 'Polygon', 'handle', $hDC, 'struct*', $tData, 'int', $Count - 1)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_Polygon

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_PrintWindow($hWnd, $hDC, $fClient = 0)
	Local $Ret = DllCall('user32.dll', 'bool', 'PrintWindow', 'hwnd', $hWnd, 'handle', $hDC, 'uint', $fClient)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_PrintWindow

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: JPM
; ===============================================================================================================================
Func _WinAPI_PtInRectEx($iX, $iY, $iLeft, $iTop, $iRight, $iBottom)
	Local $tRECT = _WinAPI_CreateRect($iLeft, $iTop, $iRight, $iBottom)
	Local $tPOINT = _WinAPI_CreatePoint($iX, $iY)
	Local $Ret = DllCall('user32.dll', 'bool', 'PtInRect', 'struct*', $tRECT, 'struct', $tPOINT)
	If @error Then Return SetError(@error, @extended, False)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_PtInRectEx

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_PtInRegion($hRgn, $iX, $iY)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'PtInRegion', 'handle', $hRgn, 'int', $iX, 'int', $iY)
	If @error Then Return SetError(@error, @extended, False)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_PtInRegion

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: JPM
; ===============================================================================================================================
Func _WinAPI_PtVisible($hDC, $iX, $iY)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'PtVisible', 'handle', $hDC, 'int', $iX, 'int', $iY)
	If @error Then Return SetError(@error + 10, @extended, 0)
	If $Ret[0] = -1 Then Return SetError(10, $Ret[0], 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_PtVisible

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_RadialGradientFill($hDC, $iX, $iY, $iRadius, $iRGB1, $iRGB2, $iAngleStart = 0, $iAngleEnd = 360, $iStep = 5)
	If Abs($iAngleStart) > 360 Then
		$iAngleStart = Mod($iAngleStart, 360)
	EndIf
	If Abs($iAngleEnd) > 360 Then
		$iAngleEnd = Mod($iAngleEnd, 360)
	EndIf
	If ($iAngleStart < 0) Or ($iAngleEnd < 0) Then
		$iAngleStart += 360
		$iAngleEnd += 360
	EndIf
	Local $Val
	If $iAngleStart > $iAngleEnd Then
		$Val = $iAngleStart
		$iAngleStart = $iAngleEnd
		$iAngleEnd = $Val
	EndIf
	If $iStep < 1 Then
		$iStep = 1
	EndIf

	Local $Ki = ATan(1) / 45
	Local $Xp = Round($iX + $iRadius * Cos($Ki * $iAngleStart))
	Local $Yp = Round($iY + $iRadius * Sin($Ki * $iAngleStart))
	Local $Xn, $Yn, $An = $iAngleStart
	Local $Vertex[3][3]

	While $An < $iAngleEnd
		$An += $iStep
		If $An > $iAngleEnd Then
			$An = $iAngleEnd
		EndIf
		$Xn = Round($iX + $iRadius * Cos($Ki * $An))
		$Yn = Round($iY + $iRadius * Sin($Ki * $An))
		$Vertex[0][0] = $iX
		$Vertex[0][1] = $iY
		$Vertex[0][2] = $iRGB1
		$Vertex[1][0] = $Xp
		$Vertex[1][1] = $Yp
		$Vertex[1][2] = $iRGB2
		$Vertex[2][0] = $Xn
		$Vertex[2][1] = $Yn
		$Vertex[2][2] = $iRGB2
		If Not _WinAPI_GradientFill($hDC, $Vertex, 0, 2) Then
			Return SetError(@error, @extended, 0)
		EndIf
		$Xp = $Xn
		$Yp = $Yn
	WEnd

	Return 1
EndFunc   ;==>_WinAPI_RadialGradientFill

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_Rectangle($hDC, $tRECT)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'Rectangle', 'handle', $hDC, 'int', DllStructGetData($tRECT, 1), _
			'int', DllStructGetData($tRECT, 2), 'int', DllStructGetData($tRECT, 3), 'int', DllStructGetData($tRECT, 4))
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_Rectangle

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_RectInRegion($hRgn, $tRECT)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'RectInRegion', 'handle', $hRgn, 'struct*', $tRECT)
	If @error Then Return SetError(@error, @extended, False)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_RectInRegion

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_RectVisible($hDC, $tRECT)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'RectVisible', 'handle', $hDC, 'struct*', $tRECT)
	If @error Then Return SetError(@error, @extended, 0)
	Switch $Ret[0]
		Case 0, 1, 2

		Case Else
			Return SetError(10, $Ret[0], 0)
	EndSwitch

	Return $Ret[0]
EndFunc   ;==>_WinAPI_RectVisible

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_RemoveFontMemResourceEx($hFont)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'RemoveFontMemResourceEx', 'handle', $hFont)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_RemoveFontMemResourceEx

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_RemoveFontResourceEx($sFont, $iFlag = 0, $fNotify = 0)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'RemoveFontResourceExW', 'wstr', $sFont, 'dword', $iFlag, 'ptr', 0)
	If @error Or Not $Ret[0] Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	If $fNotify Then
		Local Const $WM_FONTCHANGE = 0x001D
		Local Const $HWND_BROADCAST = 0xFFFF
		DllCall('user32.dll', 'none', 'SendMessage', 'hwnd', $HWND_BROADCAST, 'uint', $WM_FONTCHANGE, 'wparam', 0, 'lparam', 0)
	EndIf
	Return $Ret[0]
EndFunc   ;==>_WinAPI_RemoveFontResourceEx

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_RestoreDC($hDC, $ID)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'RestoreDC', 'handle', $hDC, 'int', $ID)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_RestoreDC

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......:
; ===============================================================================================================================
Func _WinAPI_RGB($iRed, $iGreen, $iBlue)
	Return __RGB(BitOR(BitShift($iBlue, -16), BitShift($iGreen, -8), $iRed))
EndFunc   ;==>_WinAPI_RGB

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_RotatePoints(ByRef $aPoint, $iXC, $iYC, $iAngle, $iStart = 0, $iEnd = -1)
	If __CheckErrorArrayBounds($aPoint, $iStart, $iEnd, 2) Then Return SetError(@error + 10, @extended, 0)
	If UBound($aPoint, 2) < 2 Then Return SetError(13, 0, 0)

	Local $Cos = Cos(ATan(1) / 45 * $iAngle)
	Local $Sin = Sin(ATan(1) / 45 * $iAngle)
	Local $Xn, $Yn

	For $i = $iStart To $iEnd
		$Xn = $aPoint[$i][0] - $iXC
		$Yn = $aPoint[$i][1] - $iYC
		$aPoint[$i][0] = $iXC + Round($Xn * $Cos - $Yn * $Sin)
		$aPoint[$i][1] = $iYC + Round($Xn * $Sin + $Yn * $Cos)
	Next
	Return 1
EndFunc   ;==>_WinAPI_RotatePoints

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_RoundRect($hDC, $tRECT, $iWidth, $iHeight)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'RoundRect', 'handle', $hDC, 'int', DllStructGetData($tRECT, 1), _
			'int', DllStructGetData($tRECT, 2), 'int', DllStructGetData($tRECT, 3), _
			'int', DllStructGetData($tRECT, 4), 'int', $iWidth, 'int', $iHeight)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_RoundRect

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_SaveDC($hDC)
	Local $Ret = DllCall('gdi32.dll', 'int', 'SaveDC', 'handle', $hDC)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_SaveDC

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_SaveHBITMAPToFile($sFile, $hBitmap, $iXPelsPerMeter = Default, $iYPelsPerMeter = Default)
	Local $tBMP = DllStructCreate('align 1;ushort bfType;dword bfSize;ushort bfReserved1;ushort bfReserved2;dword bfOffset')
	Local $tDIB = DllStructCreate($tagDIBSECTION)

	Local $hDC, $hSv, $hSource = 0
	While $hBitmap
		If (Not _WinAPI_GetObject($hBitmap, DllStructGetSize($tDIB), DllStructGetPtr($tDIB))) Or (DllStructGetData($tDIB, 'biCompression')) Then
			$hBitmap = 0
		Else
			Switch DllStructGetData($tDIB, 'bmBitsPixel')
				Case 32
					If Not _WinAPI_IsAlphaBitmap($hBitmap) Then
						If Not $hSource Then
							$hSource = _WinAPI_CreateDIB(DllStructGetData($tDIB, 'bmWidth'), DllStructGetData($tDIB, 'bmHeight'), 24)
							If Not $hSource Then
								$hBitmap = 0
							EndIf
							$hDC = _WinAPI_CreateCompatibleDC(0)
							$hSv = _WinAPI_SelectObject($hDC, $hSource)
							If _WinAPI_DrawBitmap($hDC, 0, 0, $hBitmap) Then
								$hBitmap = $hSource
							Else
								$hBitmap = 0
							EndIf
							_WinAPI_SelectObject($hDC, $hSv)
							_WinAPI_DeleteDC($hDC)
						Else
							$hBitmap = 0
						EndIf
						ContinueLoop
					EndIf
				Case Else

			EndSwitch
			If (Not DllStructGetData($tDIB, 'bmBits')) Or (Not DllStructGetData($tDIB, 'biSizeImage')) Then
				If Not $hSource Then
					$hBitmap = _WinAPI_CopyBitmap($hBitmap)
					$hSource = $hBitmap
				Else
					$hBitmap = 0
				EndIf
			Else
				ExitLoop
			EndIf
		EndIf
	WEnd

	Local $Error = 0, $Result = 0
	Do
		If Not $hBitmap Then
			$Error = 1
			ExitLoop
		EndIf
		Local $Data[4][2]
		$Data[0][0] = DllStructGetPtr($tBMP)
		$Data[0][1] = DllStructGetSize($tBMP)
		$Data[1][0] = DllStructGetPtr($tDIB, 'biSize')
		$Data[1][1] = 40
		$Data[2][1] = DllStructGetData($tDIB, 'biClrUsed') * 4
		Local $tTable = 0
		If $Data[2][1] Then
			$tTable = _WinAPI_GetDIBColorTable($hBitmap)
			If @error Or (@extended <> $Data[2][1] / 4) Then
				$Error = @error + 10
				ExitLoop
			EndIf
		EndIf
		$Data[2][0] = DllStructGetPtr($tTable)
		$Data[3][0] = DllStructGetData($tDIB, 'bmBits')
		$Data[3][1] = DllStructGetData($tDIB, 'biSizeImage')
		DllStructSetData($tBMP, 'bfType', 0x4D42)
		DllStructSetData($tBMP, 'bfSize', $Data[0][1] + $Data[1][1] + $Data[2][1] + $Data[3][1])
		DllStructSetData($tBMP, 'bfReserved1', 0)
		DllStructSetData($tBMP, 'bfReserved2', 0)
		DllStructSetData($tBMP, 'bfOffset', $Data[0][1] + $Data[1][1] + $Data[2][1])
		$hDC = _WinAPI_GetDC(0)
		If $iXPelsPerMeter = Default Then
			If Not DllStructGetData($tDIB, 'biXPelsPerMeter') Then
				DllStructSetData($tDIB, 'biXPelsPerMeter', _WinAPI_GetDeviceCaps($hDC, 8) / _WinAPI_GetDeviceCaps($hDC, 4) * 1000)
			EndIf
		Else
			DllStructSetData($tDIB, 'biXPelsPerMeter', $iXPelsPerMeter)
		EndIf
		If $iYPelsPerMeter = Default Then
			If Not DllStructGetData($tDIB, 'biYPelsPerMeter') Then
				DllStructSetData($tDIB, 'biYPelsPerMeter', _WinAPI_GetDeviceCaps($hDC, 10) / _WinAPI_GetDeviceCaps($hDC, 6) * 1000)
			EndIf
		Else
			DllStructSetData($tDIB, 'biYPelsPerMeter', $iYPelsPerMeter)
		EndIf
		_WinAPI_ReleaseDC(0, $hDC)
		Local $hFile = _WinAPI_CreateFile($sFile, 1, 4)
		If @error Then
			$Error = @error + 20
			ExitLoop
		EndIf
		Local $Bytes
		For $i = 0 To 3
			If $Data[$i][1] Then
				If Not _WinAPI_WriteFile($hFile, $Data[$i][0], $Data[$i][1], $Bytes) Then
					$Error = @error + 30
					ExitLoop 2
				EndIf
			EndIf
		Next
		$Result = 1
	Until 1
	If $hSource Then
		_WinAPI_DeleteObject($hSource)
	EndIf
	_WinAPI_CloseHandle($hFile)
	If Not $Result Then
		FileDelete($sFile)
	EndIf

	Return SetError($Error, 0, $Result)
EndFunc   ;==>_WinAPI_SaveHBITMAPToFile

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_SaveHICONToFile($sFile, Const ByRef $aIcon, $fCompress = 0, $iStart = 0, $iEnd = -1)
	Local $Icon, $Temp, $Count = 1
	If Not IsArray($aIcon) Then
		Dim $Icon[1] = [$aIcon]
		Dim $Temp[1] = [0]
	Else
		If __CheckErrorArrayBounds($aIcon, $iStart, $iEnd) Then Return SetError(@error + 10, @extended, 0)

		$Count = $iEnd - $iStart + 1
		If $Count Then
			Dim $Icon[$Count]
			Dim $Temp[$Count]
			For $i = 0 To $Count - 1
				$Icon[$i] = $aIcon[$iStart + $i]
				$Temp[$i] = 0
			Next
		EndIf
	EndIf

	Local $hFile = _WinAPI_CreateFile($sFile, 1, 4)
	If @error Then Return SetError(@error + 20, @extended, 0)

	Local $tIco = DllStructCreate('align 1;ushort Reserved;ushort Type;ushort Count;byte Data[' & (16 * $Count) & ']')
	Local $Length = DllStructGetSize($tIco)
	Local $pIco = DllStructGetPtr($tIco)
	Local $tBI = DllStructCreate($tagBITMAPINFOHEADER)
	Local $pBI = DllStructGetPtr($tBI)
	Local $tII = DllStructCreate($tagICONINFO)
	Local $tDIB = DllStructCreate($tagDIBSECTION)
	Local $iDIB = DllStructGetSize($tDIB)
	Local $pDIB = DllStructGetPtr($tDIB)
	Local $Offset = $Length

	DllStructSetData($tBI, 'biSize', 40)
	DllStructSetData($tBI, 'biPlanes', 1)
	DllStructSetData($tBI, 'biXPelsPerMeter', 0)
	DllStructSetData($tBI, 'biYPelsPerMeter', 0)
	DllStructSetData($tBI, 'biClrUsed', 0)
	DllStructSetData($tBI, 'biClrImportant', 0)

	DllStructSetData($tIco, 'Reserved', 0)
	DllStructSetData($tIco, 'Type', 1)
	DllStructSetData($tIco, 'Count', $Count)

	Local $Result = 0, $Error = 0
	Do
		Local $Bytes
		If Not _WinAPI_WriteFile($hFile, $pIco, $Length, $Bytes) Then
			$Error = @error + 30
			ExitLoop
		EndIf
		Local $Info[8], $Ret, $pData = 0, $Index = 0
		While $Count > $Index
			$Ret = DllCall('user32.dll', 'bool', 'GetIconInfo', 'handle', $Icon[$Index], 'struct*', $tII)
			If @error Or Not $Ret[0] Then
				$Error = @error + 40
				ExitLoop 2
			EndIf
			For $i = 4 To 5
				$Info[$i] = _WinAPI_CopyImage(DllStructGetData($tII, $i), 0, 0, 0, 0x2008)
				If _WinAPI_GetObject($Info[$i], $iDIB, $pDIB) Then
					$Info[$i - 4] = DllStructGetData($tDIB, 'biSizeImage')
					$Info[$i - 2] = DllStructGetData($tDIB, 'bmBits')
				Else
					$Error = @error + 50
				EndIf
			Next
			$Info[6] = 40
			$Info[7] = DllStructGetData($tDIB, 'bmBitsPixel')
			Switch $Info[7]
				Case 16, 24

				Case 32
					If Not _WinAPI_IsAlphaBitmap($Info[5]) Then
						If Not $Temp[$Index] Then
							$Icon[$Index] = _WinAPI_Create32BitHICON($Icon[$Index])
							$Temp[$Index] = $Icon[$Index]
							If Not @error Then
								ContinueLoop
							Else
								ContinueCase
							EndIf
						EndIf
					Else
						If ($Info[1] >= 256 * 256 * 4) And ($fCompress) Then
							$Bytes = _WinAPI_CompressBitmapBits($Info[5], $pData)
							If Not @error Then
								$Info[0] = 0
								$Info[1] = $Bytes
								$Info[2] = 0
								$Info[3] = $pData
								$Info[6] = 0
							EndIf
						EndIf
					EndIf
				Case Else
					$Error = 60
			EndSwitch
			If $Error Then
				; Nothing
			Else
				Local $Size[2]
				Local $tData = DllStructCreate('byte Width;byte Height;byte ColorCount;byte Reserved;ushort Planes;ushort BitCount;long Size;long Offset', $pIco + 6 + 16 * $Index)
				DllStructSetData($tData, 'ColorCount', 0)
				DllStructSetData($tData, 'Reserved', 0)
				DllStructSetData($tData, 'Planes', 1)
				DllStructSetData($tData, 'BitCount', $Info[7])
				DllStructSetData($tData, 'Size', $Info[0] + $Info[1] + $Info[6])
				DllStructSetData($tData, 'Offset', $Offset)
				For $i = 0 To 1
					$Size[$i] = DllStructGetData($tDIB, $i + 2)
					If $Size[$i] < 256 Then
						DllStructSetData($tData, $i + 1, $Size[$i])
					Else
						DllStructSetData($tData, $i + 1, 0)
					EndIf
				Next
				DllStructSetData($tBI, 'biWidth', $Size[0])
				DllStructSetData($tBI, 'biHeight', 2 * $Size[1])
				DllStructSetData($tBI, 'biBitCount', $Info[7])
				DllStructSetData($tBI, 'biCompression', 0)
				DllStructSetData($tBI, 'biSizeImage', $Info[0] + $Info[1])
				$Offset += $Info[0] + $Info[1] + $Info[6]
				Do
					If $Info[6] Then
						If Not _WinAPI_WriteFile($hFile, $pBI, $Info[6], $Bytes) Then
							$Error = @error + 70
							ExitLoop
						EndIf
						For $i = 1 To 0 Step -1
							If Not _WinAPI_WriteFile($hFile, $Info[$i + 2], $Info[$i], $Bytes) Then
								$Error = @error + 80
								ExitLoop 2
							EndIf
						Next
					Else
						If Not _WinAPI_WriteFile($hFile, $Info[3], $Info[1], $Bytes) Then
							$Error = @error + 90
							ExitLoop
						EndIf
					EndIf
				Until 1
			EndIf
			For $i = 4 To 5
				_WinAPI_DeleteObject($Info[$i])
			Next
			If $Error Then
				ExitLoop 2
			EndIf
			$Index += 1
		WEnd
		$Ret = DllCall('kernel32.dll', 'bool', 'SetFilePointerEx', 'handle', $hFile, 'int64', 0, 'int64*', 0, 'dword', 0)
		If @error Or Not $Ret[0] Then
			$Error = @error + 100
			ExitLoop
		EndIf
		If Not _WinAPI_WriteFile($hFile, $pIco, $Length, $Bytes) Then
			$Error = @error + 110
			ExitLoop
		EndIf
		$Result = 1
	Until 1
	For $i = 0 To $Count - 1
		If $Temp[$i] Then
			_WinAPI_DestroyIcon($Temp[$i])
		EndIf
	Next
	If $pData Then
		__HeapFree($pData)
	EndIf
	_WinAPI_CloseHandle($hFile)
	If Not $Result Then
		FileDelete($sFile)
	EndIf

	Return SetError($Error, 0, $Result)
EndFunc   ;==>_WinAPI_SaveHICONToFile

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_ScaleWindowExt($hDC, $iXNum, $iXDenom, $iYNum, $iYDenom)
	$__Ext = DllStructCreate($tagSIZE)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'ScaleWindowExtEx', 'handle', $hDC, 'int', $iXNum, 'int', $iXDenom, 'int', $iYNum, _
			'int', $iYDenom, 'struct*', $__Ext)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_ScaleWindowExt

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_SelectClipPath($hDC, $iMode = 5)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'SelectClipPath', 'handle', $hDC, 'int', $iMode)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_SelectClipPath

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_SelectClipRgn($hDC, $hRgn)
	Local $Ret = DllCall('gdi32.dll', 'int', 'SelectClipRgn', 'handle', $hDC, 'handle', $hRgn)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_SelectClipRgn

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_SetArcDirection($hDC, $iDirection)
	Local $Ret = DllCall('gdi32.dll', 'int', 'SetArcDirection', 'handle', $hDC, 'int', $iDirection)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_SetArcDirection

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_SetBitmapBits($hBitmap, $iSize, $pBits)
	Local $Ret = DllCall('gdi32.dll', 'long', 'SetBitmapBits', 'handle', $hBitmap, 'dword', $iSize, 'ptr', $pBits)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_SetBitmapBits

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_SetBitmapDimensionEx($hBitmap, $iWidth, $iHeight)
	$__Ext = DllStructCreate($tagSIZE)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'SetBitmapDimensionEx', 'handle', $hBitmap, 'int', $iWidth, 'int', $iHeight, _
			'struct*', $__Ext)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_SetBitmapDimensionEx

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_SetBoundsRect($hDC, $iFlags, $tRECT = 0)
	Local $Ret = DllCall('gdi32.dll', 'uint', 'SetBoundsRect', 'handle', $hDC, 'struct*', $tRECT, 'uint', $iFlags)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_SetBoundsRect

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_SetBrushOrg($hDC, $iX, $iY)
	$__Ext = DllStructCreate($tagPOINT)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'SetBrushOrgEx', 'handle', $hDC, 'int', $iX, 'int', $iY, 'struct*', $__Ext)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_SetBrushOrg

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_SetColorAdjustment($hDC, $tAdjustment)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'SetColorAdjustment', 'handle', $hDC, 'struct*', $tAdjustment)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_SetColorAdjustment

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_SetDCBrushColor($hDC, $iRGB)
	Local $Ret = DllCall('gdi32.dll', 'dword', 'SetDCBrushColor', 'handle', $hDC, 'dword', __RGB($iRGB))
	If @error Or ($Ret[0] = 4294967295) Then Return SetError(@error, @extended, -1)
	; If $Ret[0] = 4294967295 Then Return SetError(1000, 0, -1)

	Return __RGB($Ret[0])
EndFunc   ;==>_WinAPI_SetDCBrushColor

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_SetDCPenColor($hDC, $iRGB)
	Local $Ret = DllCall('gdi32.dll', 'dword', 'SetDCPenColor', 'handle', $hDC, 'dword', __RGB($iRGB))
	If @error Or ($Ret[0] = 4294967295) Then Return SetError(@error, @extended, -1)
	; If $Ret[0] = 4294967295 Then Return SetError(1000, 0, -1)

	Return __RGB($Ret[0])
EndFunc   ;==>_WinAPI_SetDCPenColor

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_SetDeviceGammaRamp($hDC, Const ByRef $aRamp)
	If (UBound($aRamp, 0) <> 2) Or (UBound($aRamp, 1) <> 256) Or (UBound($aRamp, 2) <> 3) Then
		Return SetError(12, 0, 0)
	EndIf

	Local $tData = DllStructCreate('ushort[256];ushort[256];ushort[256]')
	For $i = 0 To 2
		For $j = 0 To 255
			DllStructSetData($tData, $i + 1, $aRamp[$j][$i], $j + 1)
		Next
	Next

	Local $Ret = DllCall('gdi32.dll', 'bool', 'SetDeviceGammaRamp', 'handle', $hDC, 'struct*', $tData)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_SetDeviceGammaRamp

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_SetDIBColorTable($hBitmap, $tColorTable, $iColorCount)
	If $iColorCount > DllStructGetSize($tColorTable) / 4 Then Return SetError(1, 0, 0)

	Local $hDC = _WinAPI_CreateCompatibleDC(0)
	Local $hSv = _WinAPI_SelectObject($hDC, $hBitmap)
	Local $Ret = DllCall('gdi32.dll', 'uint', 'SetDIBColorTable', 'handle', $hDC, 'uint', 0, 'uint', $iColorCount, 'struct*', $tColorTable)
	If @error Then $Ret = @error
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)
	_WinAPI_SelectObject($hDC, $hSv)
	_WinAPI_DeleteDC($hDC)
	If $Ret Then Return SetError($Ret, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_SetDIBColorTable

; #FUNCTION# ====================================================================================================================
; Author.........: Luke
; Modified.......: JPM
; ===============================================================================================================================
Func _WinAPI_SetDIBitsToDevice($hDC, $iXDest, $iYDest, $iWidth, $iHeight, $iXSrc, $iYSrc, $iStartScan, $iScanLines, $tBITMAPINFO, $iUsage, $pBits)
	Local $Ret = DllCall('gdi32.dll', 'int', 'SetDIBitsToDevice', 'handle', $hDC, 'int', $iXDest, 'int', $iYDest, _
			'dword', $iWidth, 'dword', $iHeight, 'int', $iXSrc, 'int', $iYSrc, 'uint', $iStartScan, _
			'uint', $iScanLines, 'ptr', $pBits, 'struct*', $tBITMAPINFO, 'uint', $iUsage)
	If @error Or ($Ret[0] = -1) Then Return SetError(@error + 10, $Ret[0], 0) ; GDI_ERROR

	Return $Ret[0]
EndFunc   ;==>_WinAPI_SetDIBitsToDevice

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_SetEnhMetaFileBits($pData, $iLength)
	Local $Ret = DllCall('gdi32.dll', 'handle', 'SetEnhMetaFileBits', 'uint', $iLength, 'ptr', $pData)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_SetEnhMetaFileBits

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_SetGraphicsMode($hDC, $iMode)
	Local $Ret = DllCall('gdi32.dll', 'int', 'SetGraphicsMode', 'handle', $hDC, 'int', $iMode)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_SetGraphicsMode

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_SetMapMode($hDC, $iMode)
	Local $Ret = DllCall('gdi32.dll', 'int', 'SetMapMode', 'handle', $hDC, 'int', $iMode)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_SetMapMode

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_SetPixel($hDC, $iX, $iY, $iRGB)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'SetPixelV', 'handle', $hDC, 'int', $iX, 'int', $iY, 'dword', __RGB($iRGB))
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_SetPixel

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_SetPolyFillMode($hDC, $iMode = 1)
	Local $Ret = DllCall('gdi32.dll', 'int', 'SetPolyFillMode', 'handle', $hDC, 'int', $iMode)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_SetPolyFillMode

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_SetRectRgn($hRgn, $tRECT)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'SetRectRgn', 'ptr', $hRgn, 'int', DllStructGetData($tRECT, 1), _
			'int', DllStructGetData($tRECT, 2), 'int', DllStructGetData($tRECT, 3), 'int', DllStructGetData($tRECT, 4))
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_SetRectRgn

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_SetROP2($hDC, $iMode)
	Local $Ret = DllCall('gdi32.dll', 'int', 'SetROP2', 'handle', $hDC, 'int', $iMode)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_SetROP2

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: JPM
; ===============================================================================================================================
Func _WinAPI_SetStretchBltMode($hDC, $iMode)
	Local $Ret = DllCall('gdi32.dll', 'int', 'SetStretchBltMode', 'handle', $hDC, 'int', $iMode)
	If @error Or Not $Ret[0] Or ($Ret[0] = 87) Then Return SetError(@error + 10, $Ret[0], 0) ; ERROR_INVALID_PARAMETER

	Return $Ret[0]
EndFunc   ;==>_WinAPI_SetStretchBltMode

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_SetTextAlign($hDC, $iMode = 0)
	Local $Ret = DllCall('gdi32.dll', 'uint', 'SetTextAlign', 'handle', $hDC, 'uint', $iMode)
	If @error Or ($Ret[0] = 4294967295) Then Return SetError(@error, @extended, -1) ; GDI_ERROR
	; If $Ret[0] = 4294967295 Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_SetTextAlign

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_SetTextCharacterExtra($hDC, $iCharExtra)
	Local $Ret = DllCall('gdi32.dll', 'int', 'SetTextCharacterExtra', 'handle', $hDC, 'int', $iCharExtra)
	If @error Or ($Ret[0] = 0x80000000) Then Return SetError(@error, @extended, -1)
	; If $Ret[0] = 0x80000000 Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_SetTextCharacterExtra

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_SetTextJustification($hDC, $iBreakExtra, $iBreakCount)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'SetTextJustification', 'handle', $hDC, 'int', $iBreakExtra, 'int', $iBreakCount)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_SetTextJustification

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......:
; ===============================================================================================================================
Func _WinAPI_SetUDFColorMode($iMode)
	$__iRGBMode = Not ($iMode = 0)
EndFunc   ;==>_WinAPI_SetUDFColorMode

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_SetWindowExt($hDC, $iXExtent, $iYExtent)
	$__Ext = DllStructCreate($tagSIZE)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'SetWindowExtEx', 'handle', $hDC, 'int', $iXExtent, 'int', $iYExtent, _
			'struct*', $__Ext)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_SetWindowExt

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_SetWindowOrg($hDC, $iX, $iY)
	$__Ext = DllStructCreate($tagPOINT)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'SetWindowOrgEx', 'handle', $hDC, 'int', $iX, 'int', $iY, 'struct*', $__Ext)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_SetWindowOrg

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_SetWorldTransform($hDC, ByRef $tXFORM)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'SetWorldTransform', 'handle', $hDC, 'struct*', $tXFORM)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_SetWorldTransform

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_StretchBlt($hDestDC, $iXDest, $iYDest, $iWidthDest, $iHeightDest, $hSrcDC, $iXSrc, $iYSrc, $iWidthSrc, $iHeightSrc, $iRop)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'StretchBlt', 'handle', $hDestDC, 'int', $iXDest, 'int', $iYDest, 'int', $iWidthDest, _
			'int', $iHeightDest, 'hwnd', $hSrcDC, 'int', $iXSrc, 'int', $iYSrc, _
			'int', $iWidthSrc, 'int', $iHeightSrc, 'dword', $iRop)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_StretchBlt

; #FUNCTION# ====================================================================================================================
; Author.........: Jscript
; Modified.......: Yashied, JPM
; ===============================================================================================================================
Func _WinAPI_StretchDIBits($hDestDC, $iXDest, $iYDest, $iWidthDest, $iHeightDest, $iXSrc, $iYSrc, $iWidthSrc, $iHeightSrc, $tBITMAPINFO, $iUsage, $pBits, $iRop)
	Local $Ret = DllCall('gdi32.dll', 'int', 'StretchDIBits', 'handle', $hDestDC, 'int', $iXDest, 'int', $iYDest, _
			'int', $iWidthDest, 'int', $iHeightDest, 'int', $iXSrc, 'int', $iYSrc, _
			'int', $iWidthSrc, 'int', $iHeightSrc, 'ptr', $pBits, 'struct*', $tBITMAPINFO, 'uint', $iUsage, _
			'dword', $iRop)
	If @error Or ($Ret[0] = -1) Then Return SetError(@error + 10, $Ret[0], 0) ; GDI_ERROR

	Return $Ret[0]
EndFunc   ;==>_WinAPI_StretchDIBits

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_StrokeAndFillPath($hDC)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'StrokeAndFillPath', 'handle', $hDC)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_StrokeAndFillPath

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_StrokePath($hDC)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'StrokePath', 'handle', $hDC)
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_StrokePath

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_SubtractRect(ByRef $tRECT1, ByRef $tRECT2)
	Local $tRECT = DllStructCreate($tagRECT)
	Local $Ret = DllCall('user32.dll', 'bool', 'SubtractRect', 'struct*', $tRECT, 'struct*', $tRECT1, 'struct*', $tRECT2)
	If @error Or Not $Ret[0] Then Return SetError(@error + 10, @extended, 0)

	Return $tRECT
EndFunc   ;==>_WinAPI_SubtractRect

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_TabbedTextOut($hDC, $iX, $iY, $sText, $aTab = 0, $iStart = 0, $iEnd = -1, $iOrigin = 0)
	Local $Tab, $Count
	If Not IsArray($aTab) Then
		If $aTab Then
			$Tab = $aTab
			Dim $aTab[1] = [$Tab]
			$iStart = 0
			$iEnd = 0
			$Count = 1
		Else
			$Count = 0
		EndIf
	Else
		$Count = 1
	EndIf

	Local $tTab = 0
	If $Count Then
		If __CheckErrorArrayBounds($aTab, $iStart, $iEnd) Then Return SetError(@error + 10, @extended, 0)

		$Count = $iEnd - $iStart + 1
		$tTab = DllStructCreate('uint[' & $Count & ']')
		$Tab = 1
		For $i = $iStart To $iEnd
			DllStructSetData($tTab, 1, $aTab[$i], $Tab)
			$Tab += 1
		Next
	EndIf
	Local $Ret = DllCall('user32.dll', 'long', 'TabbedTextOutW', 'handle', $hDC, 'int', $iX, 'int', $iY, 'wstr', $sText, _
			'int', StringLen($sText), 'int', $Count, 'ptr', DllStructGetPtr($tTab), 'int', $iOrigin)
	If @error Or Not $Ret[0] Then Return SetError(@error, @extended, 0)

	$__Ext = _WinAPI_CreateSize(_WinAPI_LoWord($Ret[0]), _WinAPI_HiWord($Ret[0]))
	Return 1
EndFunc   ;==>_WinAPI_TabbedTextOut

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_TextOut($hDC, $iX, $iY, $sText)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'TextOutW', 'handle', $hDC, 'int', $iX, 'int', $iY, 'wstr', $sText, _
			'int', StringLen($sText))
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_TextOut

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_TransparentBlt($hDestDC, $iXDest, $iYDest, $iWidthDest, $iHeightDest, $hSrcDC, $iXSrc, $iYSrc, $iWidthSrc, $iHeightSrc, $iRGB)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'GdiTransparentBlt', 'handle', $hDestDC, 'int', $iXDest, 'int', $iYDest, _
			'int', $iWidthDest, 'int', $iHeightDest, 'hwnd', $hSrcDC, 'int', $iXSrc, 'int', $iYSrc, _
			'int', $iWidthSrc, 'int', $iHeightSrc, 'dword', __RGB($iRGB))
	If @error Then Return SetError(@error, @extended, False)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_TransparentBlt

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_UnionRect(ByRef $tRECT1, ByRef $tRECT2)
	Local $tRECT = DllStructCreate($tagRECT)
	Local $Ret = DllCall('user32.dll', 'bool', 'UnionRect', 'struct*', $tRECT, 'struct*', $tRECT1, 'struct*', $tRECT2)
	If @error Or Not $Ret[0] Then Return SetError(@error + 10, 0, 0)

	Return $tRECT
EndFunc   ;==>_WinAPI_UnionRect

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_ValidateRect($hWnd, $tRECT = 0)
	Local $Ret = DllCall('user32.dll', 'bool', 'ValidateRect', 'hwnd', $hWnd, 'struct*', $tRECT)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_ValidateRect

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_ValidateRgn($hWnd, $hRgn = 0)
	Local $Ret = DllCall('user32.dll', 'bool', 'ValidateRgn', 'hwnd', $hWnd, 'handle', $hRgn)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_ValidateRgn

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: Jpm
; ===============================================================================================================================
Func _WinAPI_WidenPath($hDC)
	Local $Ret = DllCall('gdi32.dll', 'bool', 'WidenPath', 'handle', $hDC)
	If @error Then Return SetError(@error, @extended, 0)
	; If Not $Ret[0] Then Return SetError(1000, 0, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_WidenPath

; #FUNCTION# ====================================================================================================================
; Author.........: Yashied
; Modified.......: jpm
; ===============================================================================================================================
Func _WinAPI_WindowFromDC($hDC)
	Local $Ret = DllCall('user32.dll', 'hwnd', 'WindowFromDC', 'handle', $hDC)
	If @error Then Return SetError(@error, @extended, 0)

	Return $Ret[0]
EndFunc   ;==>_WinAPI_WindowFromDC
#endregion Public Functions

#region Embedded DLL Functions

Func __AlphaProc()
	Static $pProc = 0

	If Not $pProc Then
		If @AutoItX64 Then
			$pProc = __Init(Binary( _
					'0x48894C240848895424104C894424184C894C24205541574831C050504883EC28' & _
					'48837C24600074054831C0EB0748C7C0010000004821C0751F488B6C24604883' & _
					'7D180074054831C0EB0748C7C0010000004821C07502EB0948C7C001000000EB' & _
					'034831C04821C0740C48C7C0FFFFFFFF4863C0EB6F48C744242800000000488B' & _
					'6C24604C637D04488B6C2460486345084C0FAFF849C1E7024983C7FC4C3B7C24' & _
					'287C36488B6C24604C8B7D184C037C24284983C7034C897C2430488B6C243080' & _
					'7D0000740C48C7C0010000004863C0EB1348834424280471A54831C04863C0EB' & _
					'034831C04883C438415F5DC3'))
		Else
			$pProc = __Init(Binary( _
					'0x555331C05050837C241C00740431C0EB05B80100000021C075198B6C241C837D' & _
					'1400740431C0EB05B80100000021C07502EB07B801000000EB0231C021C07407' & _
					'B8FFFFFFFFEB4FC70424000000008B6C241C8B5D048B6C241C0FAF5D08C1E302' & _
					'83C3FC3B1C247C288B6C241C8B5D14031C2483C303895C24048B6C2404807D00' & _
					'007407B801000000EB0C8304240471BE31C0EB0231C083C4085B5DC21000'))
		EndIf
	EndIf
	Return $pProc
EndFunc   ;==>__AlphaProc

Func __ANDProc()
	Static $pProc = 0

	If Not $pProc Then
		If @AutoItX64 Then
			$pProc = __Init(Binary( _
					'0x48894C240848895424104C894424184C894C2420554157415648C7C009000000' & _
					'4883EC0848C704240000000048FFC875EF4883EC284883BC24A0000000007405' & _
					'4831C0EB0748C7C0010000004821C00F85840000004883BC24A8000000007405' & _
					'4831C0EB0748C7C0010000004821C07555488BAC24A000000048837D18007405' & _
					'4831C0EB0748C7C0010000004821C07522488BAC24A800000048837D18007405' & _
					'4831C0EB0748C7C0010000004821C07502EB0948C7C001000000EB034831C048' & _
					'21C07502EB0948C7C001000000EB034831C04821C07502EB0948C7C001000000' & _
					'EB034831C04821C0740B4831C04863C0E9D701000048C74424280000000048C7' & _
					'44243000000000488BAC24A00000004C637D0849FFCF4C3B7C24300F8C9C0100' & _
					'0048C74424380000000048C74424400000000048C744244800000000488BAC24' & _
					'A00000004C637D0449FFCF4C3B7C24480F8CDB000000488BAC24A00000004C8B' & _
					'7D184C037C24284983C7034C897C2450488B6C2450807D000074264C8B7C2440' & _
					'4C8B74243849F7DE4983C61F4C89F148C7C00100000048D3E04909C74C897C24' & _
					'4048FF4424384C8B7C24384983FF1F7E6F4C8B7C244049F7D74C897C244048C7' & _
					'442458180000004831C0483B4424587F3D488BAC24A80000004C8B7D184C037C' & _
					'24604C897C24504C8B7C2440488B4C245849D3FF4C89F850488B6C2458588845' & _
					'0048FF4424604883442458F871B948C74424380000000048C744244000000000' & _
					'48834424280448FF4424480F810BFFFFFF48837C24380074794C8B7C244049F7' & _
					'D74C8B74243849F7DE4983C6204C89F148C7C0FFFFFFFF48D3E04921C74C897C' & _
					'244048C7442458180000004831C0483B4424587F3D488BAC24A80000004C8B7D' & _
					'184C037C24604C897C24504C8B7C2440488B4C245849D3FF4C89F850488B6C24' & _
					'585888450048FF4424604883442458F871B948FF4424300F814AFEFFFF48C7C0' & _
					'010000004863C0EB034831C04883C470415E415F5DC3'))
		Else
			$pProc = __Init(Binary( _
					'0x555357BA0800000083EC04C70424000000004A75F3837C243800740431C0EB05' & _
					'B80100000021C07562837C243C00740431C0EB05B80100000021C0753F8B6C24' & _
					'38837D1400740431C0EB05B80100000021C075198B6C243C837D1400740431C0' & _
					'EB05B80100000021C07502EB07B801000000EB0231C021C07502EB07B8010000' & _
					'00EB0231C021C07502EB07B801000000EB0231C021C0740731C0E969010000C7' & _
					'042400000000C7442404000000008B6C24388B5D084B3B5C24040F8C3F010000' & _
					'C744240800000000C744240C00000000C7442410000000008B6C24388B5D044B' & _
					'3B5C24100F8CA90000008B6C24388B5D14031C2483C303895C24148B6C241480' & _
					'7D0000741C8B5C240C8B7C2408F7DF83C71F89F9B801000000D3E009C3895C24' & _
					'0CFF4424088B5C240883FB1F7E578B5C240CF7D3895C240CC744241818000000' & _
					'31C03B4424187F2D8B6C243C8B5D14035C241C895C24148B5C240C8B4C2418D3' & _
					'FB538B6C241858884500FF44241C83442418F871CBC744240800000000C74424' & _
					'0C0000000083042404FF4424100F8145FFFFFF837C240800745B8B5C240CF7D3' & _
					'8B7C2408F7DF83C72089F9B8FFFFFFFFD3E021C3895C240CC744241818000000' & _
					'31C03B4424187F2D8B6C243C8B5D14035C241C895C24148B5C240C8B4C2418D3' & _
					'FB538B6C241858884500FF44241C83442418F871CBFF4424040F81AFFEFFFFB8' & _
					'01000000EB0231C083C4205F5B5DC21000'))
		EndIf
	EndIf
	Return $pProc
EndFunc   ;==>__ANDProc

Func __XORProc()
	Static $pProc = 0

	If Not $pProc Then
		If @AutoItX64 Then
			$pProc = __Init(Binary( _
					'0x48894C240848895424104C894424184C894C24205541574831C050504883EC28' & _
					'48837C24600074054831C0EB0748C7C0010000004821C0751B48837C24680074' & _
					'054831C0EB0748C7C0010000004821C07502EB0948C7C001000000EB034831C0' & _
					'4821C074084831C04863C0EB7748C7442428000000004C637C24584983C7FC4C' & _
					'3B7C24287C4F4C8B7C24604C037C24284C897C2430488B6C2430807D00007405' & _
					'4831C0EB0748C7C0010000004821C0741C4C8B7C24684C037C24284983C7034C' & _
					'897C2430488B6C2430C64500FF48834424280471A148C7C0010000004863C0EB' & _
					'034831C04883C438415F5DC3'))
		Else
			$pProc = __Init(Binary( _
					'0x555331C05050837C241C00740431C0EB05B80100000021C07516837C24200074' & _
					'0431C0EB05B80100000021C07502EB07B801000000EB0231C021C0740431C0EB' & _
					'5AC70424000000008B5C241883C3FC3B1C247C3E8B5C241C031C24895C24048B' & _
					'6C2404807D0000740431C0EB05B80100000021C074168B5C2420031C2483C303' & _
					'895C24048B6C2404C64500FF8304240471B6B801000000EB0231C083C4085B5D' & _
					'C21000'))
		EndIf
	EndIf
	Return $pProc
EndFunc   ;==>__XORProc

#endregion Embedded DLL Functions

#region Internal Functions

Func __EnumDisplayMonitorsProc($hMonitor, $hDC, $pRECT, $lParam)
	#forceref $hDC, $lParam

	__Inc($__Enum)
	$__Enum[$__Enum[0][0]][0] = $hMonitor
	If Not $pRECT Then
		$__Enum[$__Enum[0][0]][1] = 0
	Else
		$__Enum[$__Enum[0][0]][1] = DllStructCreate($tagRECT)
		If Not _WinAPI_MoveMemory(DllStructGetPtr($__Enum[$__Enum[0][0]][1]), $pRECT, 16) Then Return 0
	EndIf
	Return 1
EndFunc   ;==>__EnumDisplayMonitorsProc

Func __EnumFontFamiliesProc($pELFEX, $pNTMEX, $iFontType, $pPattern)
	; Local $tELFEX = DllStructCreate('long;long;long;long;long;byte;byte;byte;byte;byte;byte;byte;byte;wchar[32];wchar[64];wchar[32];wchar[32]', $pELFEX)
	Local $tELFEX = DllStructCreate($tagLOGFONT & ';wchar FullName[64];wchar Style[32];wchar Script[32]', $pELFEX)
	; Local $tNTMEX = DllStructCreate('long;long;long;long;long;long;long;long;long;long;long;wchar;wchar;wchar;wchar;byte;byte;byte;byte;byte;dword;uint;uint;uint;dword[4];dword[2]', $pNTMEX)
	Local $tNTMEX = DllStructCreate($tagNEWTEXTMETRICEX, $pNTMEX)
	Local $tPattern = DllStructCreate('uint;uint;ptr', $pPattern)

	If $iFontType And Not BitAND($iFontType, DllStructGetData($tPattern, 1)) Then
		Return 1
	EndIf
	If DllStructGetData($tPattern, 3) Then
		Local $Ret = DllCall('shlwapi.dll', 'bool', 'PathMatchSpecW', 'ptr', DllStructGetPtr($tELFEX, 14), 'ptr', DllStructGetData($tPattern, 3))
		If Not @error Then
			If DllStructGetData($tPattern, 2) Then
				If $Ret[0] Then
					Return 1
				Else

				EndIf
			Else
				If $Ret[0] Then

				Else
					Return 1
				EndIf
			EndIf
		EndIf
	EndIf
	__Inc($__Enum)
	$__Enum[$__Enum[0][0]][0] = DllStructGetData($tELFEX, 14)
	$__Enum[$__Enum[0][0]][1] = DllStructGetData($tELFEX, 16)
	$__Enum[$__Enum[0][0]][2] = DllStructGetData($tELFEX, 15)
	$__Enum[$__Enum[0][0]][3] = DllStructGetData($tELFEX, 17)
	$__Enum[$__Enum[0][0]][4] = $iFontType
	$__Enum[$__Enum[0][0]][5] = DllStructGetData($tNTMEX, 19)
	$__Enum[$__Enum[0][0]][6] = DllStructGetData($tNTMEX, 20)
	$__Enum[$__Enum[0][0]][7] = DllStructGetData($tNTMEX, 21)
	Return 1
EndFunc   ;==>__EnumFontFamiliesProc

Func __EnumFontStylesProc($pELFEX, $pNTMEX, $iFontType, $pFN)
	#forceref $iFontType

	; Local $tELFEX = DllStructCreate('long;long;long;long;long;byte;byte;byte;byte;byte;byte;byte;byte;wchar[32];wchar[64];wchar[32];wchar[32]', $pELFEX)
	Local $tELFEX = DllStructCreate($tagLOGFONT & ';wchar FullName[64];wchar Style[32];wchar Script[32]', $pELFEX)
	; Local $tNTMEX = DllStructCreate('long;long;long;long;long;long;long;long;long;long;long;wchar;wchar;wchar;wchar;byte;byte;byte;byte;byte;dword;uint;uint;uint;dword[4];dword[2]', $pNTMEX)
	Local $tNTMEX = DllStructCreate($tagNEWTEXTMETRICEX, $pNTMEX)
	Local $tFN = DllStructCreate('dword;wchar[64]', $pFN)

	If BitAND(DllStructGetData($tNTMEX, 'ntmFlags'), 0x0061) = DllStructGetData($tFN, 1) Then
		DllStructSetData($tFN, 2, DllStructGetData($tELFEX, 'FullName'))
		Return 0
	Else
		Return 1
	EndIf
EndFunc   ;==>__EnumFontStylesProc
#endregion Internal Functions
